<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/vernemq/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/vernemq/metadata.yaml"
sidebar_label: "VerneMQ"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# VerneMQ


<img src="https://netdata.cloud/img/vernemq.svg" width="150"/>


Plugin: go.d.plugin
Module: vernemq

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors VerneMQ instances.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per node

These metrics refer to the VerneMQ node.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| node | The value of this label is identical to the value of the "node" label exposed by VerneMQ. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| vernemq.node_socket | open | sockets |
| vernemq.node_socket_operations | open, close | sockets/s |
| vernemq.node_client_keepalive_expired | closed | sockets/s |
| vernemq.node_socket_close_timeout | closed | sockets/s |
| vernemq.node_socket_errors | errors | errors/s |
| vernemq.node_queue_processes | queue_processes | queue processes |
| vernemq.node_queue_processes_operations | setup, teardown | events/s |
| vernemq.node_queue_process_init_from_storage | queue_processes | queue processes/s |
| vernemq.node_queue_messages | received, sent | messages/s |
| vernemq.node_queued_messages | queued | messages |
| vernemq.node_queue_undelivered_messages | dropped, expired, unhandled | messages/s |
| vernemq.node_router_subscriptions | subscriptions | subscriptions |
| vernemq.node_router_matched_subscriptions | local, remote | subscriptions/s |
| vernemq.node_router_memory | used | bytes |
| vernemq.node_average_scheduler_utilization | utilization | percentage |
| vernemq.node_system_processes | processes | processes |
| vernemq.node_system_reductions | reductions | ops/s |
| vernemq.node_system_context_switches | context_switches | ops/s |
| vernemq.node_system_io | received, sent | bytes/s |
| vernemq.node_system_run_queue | ready | processes |
| vernemq.node_system_gc_count | gc | ops/s |
| vernemq.node_system_gc_words_reclaimed | words_reclaimed | ops/s |
| vernemq.node_system_allocated_memory | processes, system | bytes |
| vernemq.node_traffic | received, sent | bytes/s |
| vernemq.node_retain_messages | messages | messages |
| vernemq.node_retain_memory | used | bytes |
| vernemq.node_cluster_traffic | received, sent | bytes/s |
| vernemq.node_cluster_dropped | dropped | bytes/s |
| vernemq.node_netsplit_unresolved | unresolved | netsplits |
| vernemq.node_netsplits | resolved, detected | netsplits/s |
| vernemq.node_uptime | time | seconds |

### Per mqtt

These metrics are specific to the used MQTT protocol version.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| node | The value of this label is identical to the value of the "node" label exposed by VerneMQ. |
| mqtt_version | MQTT version. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| vernemq.node_mqtt_auth | received, sent | packets/s |
| vernemq.node_mqtt_auth_received_by_reason_code | success, continue_authentication, reauthenticate | packets/s |
| vernemq.node_mqtt_auth_sent_by_reason_code | success, continue_authentication, reauthenticate | packets/s |
| vernemq.node_mqtt_connect | connect, connack | packets/s |
| vernemq.node_mqtt_connack_sent_by_return_code | success, unsupported_protocol_version, client_identifier_not_valid, server_unavailable, bad_username_or_password, not_authorized | packets/s |
| vernemq.node_mqtt_connack_sent_by_reason_code | success, unspecified_error, malformed_packet, protocol_error, impl_specific_error, unsupported_protocol_version, client_identifier_not_valid, bad_username_or_password, not_authorized, server_unavailable, server_busy, banned, bad_authentication_method, topic_name_invalid, packet_too_large, quota_exceeded, payload_format_invalid, retain_not_supported, qos_not_supported, use_another_server, server_moved, connection_rate_exceeded | packets/s |
| vernemq.node_mqtt_disconnect | received, sent | packets/s |
| vernemq.node_mqtt_disconnect_received_by_reason_code | normal_disconnect, disconnect_with_will_msg, unspecified_error, malformed_packet, protocol_error, impl_specific_error, topic_name_invalid, receive_max_exceeded, topic_alias_invalid, packet_too_large, message_rate_too_high, quota_exceeded, administrative_action, payload_format_invalid | packets/s |
| node_mqtt_disconnect_sent_by_reason_code | normal_disconnect, unspecified_error, malformed_packet, protocol_error, impl_specific_error, not_authorized, server_busy, server_shutting_down, keep_alive_timeout, session_taken_over, topic_filter_invalid, topic_name_invalid, receive_max_exceeded, topic_alias_invalid, packet_too_large, message_rate_too_high, quota_exceeded, administrative_action, payload_format_invalid, retain_not_supported, qos_not_supported, use_another_server, server_moved, shared_subs_not_supported, connection_rate_exceeded, max_connect_time, subscription_ids_not_supported, wildcard_subs_not_supported | packets/s |
| vernemq.node_mqtt_subscribe | subscribe, suback | packets/s |
| vernemq.node_mqtt_subscribe_error | subscribe | errors/s |
| vernemq.node_mqtt_subscribe_auth_error | subscribe_auth | errors/s |
| vernemq.node_mqtt_unsubscribe | unsubscribe, unsuback | packets/s |
| vernemq.node_mqtt_unsubscribe_error | unsubscribe | errors/s |
| vernemq.node_mqtt_publish | received, sent | packets/s |
| vernemq.node_mqtt_publish_errors | publish | errors/s |
| vernemq.node_mqtt_publish_auth_errors | publish_auth | errors/s |
| vernemq.node_mqtt_puback | received, sent | packets/s |
| vernemq.node_mqtt_puback_received_by_reason_code | success, no_matching_subscribers, unspecified_error, impl_specific_error, not_authorized, topic_name_invalid, packet_id_in_use, quota_exceeded, payload_format_invalid | packets/s |
| vernemq.node_mqtt_puback_sent_by_reason_code | success, no_matching_subscribers, unspecified_error, impl_specific_error, not_authorized, topic_name_invalid, packet_id_in_use, quota_exceeded, payload_format_invalid | packets/s |
| vernemq.node_mqtt_puback_invalid_error | unexpected | messages/s |
| vernemq.node_mqtt_pubrec | received, sent | packets/s |
| vernemq.node_mqtt_pubrec_received_by_reason_code | success, no_matching_subscribers, unspecified_error, impl_specific_error, not_authorized, topic_name_invalid, packet_id_in_use, quota_exceeded, payload_format_invalid | packets/s |
| vernemq.node_mqtt_pubrec_sent_by_reason_code | success, no_matching_subscribers, unspecified_error, impl_specific_error, not_authorized, topic_name_invalid, packet_id_in_use, quota_exceeded, payload_format_invalid | packets/s |
| vernemq.node_mqtt_pubrec_invalid_error | unexpected | messages/s |
| vernemq.node_mqtt_pubrel | received, sent | packets/s |
| vernemq.node_mqtt_pubrel_received_by_reason_code | success, packet_id_not_found | packets/s |
| vernemq.node_mqtt_pubrel_sent_by_reason_code | success, packet_id_not_found | packets/s |
| vernemq.node_mqtt_pubcomp | received, sent | packets/s |
| vernemq.node_mqtt_pubcomp_received_by_reason_code | success, packet_id_not_found | packets/s |
| vernemq.node_mqtt_pubcomp_sent_by_reason_cod | success, packet_id_not_found | packets/s |
| vernemq.node_mqtt_pubcomp_invalid_error | unexpected | messages/s |
| vernemq.node_mqtt_ping | pingreq, pingresp | packets/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ vernemq_socket_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_socket_errors | Node ${label:node} socket errors in the last minute |
| [ vernemq_queue_message_drop ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_queue_undelivered_messages | Node ${label:node} dropped messages due to full queues in the last minute |
| [ vernemq_queue_message_expired ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_queue_undelivered_messages | Node ${label:node} expired before delivery messages in the last minute |
| [ vernemq_queue_message_unhandled ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_queue_undelivered_messages | Node ${label:node} unhandled messages in the last minute |
| [ vernemq_average_scheduler_utilization ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_average_scheduler_utilization | Node ${label:node} scheduler utilization over the last 10 minutes |
| [ vernemq_cluster_dropped ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_cluster_dropped | Node ${label:node} traffic dropped during communication with the cluster nodes in the last minute |
| [ vernemq_netsplits ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_netsplits | Node ${label:node} detected netsplits (split brain) in the last minute |
| [ vernemq_mqtt_connack_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_connack_sent_by_reason_code | Node ${label:node} unsuccessful sent v5 CONNACK packets in the last minute |
| [ vernemq_mqtt_disconnect_received_reason_not_normal ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_disconnect_received_by_reason_code | Node ${label:node} received not normal v5 DISCONNECT packets in the last minute |
| [ vernemq_mqtt_disconnect_sent_reason_not_normal ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_disconnect_sent_by_reason_code | Node ${label:node} sent not normal v5 DISCONNECT packets in the last minute |
| [ vernemq_mqtt_subscribe_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_subscribe_error | Node ${label:node} mqtt v${label:mqtt_version} failed SUBSCRIBE operations in the last minute |
| [ vernemq_mqtt_subscribe_auth_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_subscribe_auth_error | Node ${label:node} mqtt v${label:mqtt_version} unauthorized SUBSCRIBE attempts in the last minute |
| [ vernemq_mqtt_unsubscribe_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_unsubscribe_error | Node ${label:node} mqtt v${label:mqtt_version} failed UNSUBSCRIBE operations in the last minute |
| [ vernemq_mqtt_publish_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_publish_errors | Node ${label:node} mqtt v${label:mqtt_version} failed PUBLISH operations in the last minute |
| [ vernemq_mqtt_publish_auth_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_publish_auth_errors | Node ${label:node} mqtt v${label:mqtt_version} unauthorized PUBLISH attempts in the last minute |
| [ vernemq_mqtt_puback_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_puback_received_by_reason_code | Node ${label:node} mqtt v5 received unsuccessful PUBACK packets in the last minute |
| [ vernemq_mqtt_puback_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_puback_sent_by_reason_code | Node ${label:node} mqtt v5 unsuccessful sent PUBACK packets in the last minute |
| [ vernemq_mqtt_puback_unexpected ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_puback_invalid_error | Node ${label:node} mqtt v${label:mqtt_version} received unexpected PUBACK messages in the last minute |
| [ vernemq_mqtt_pubrec_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubrec_received_by_reason_code | Node ${label:node} mqtt v5 received unsuccessful PUBREC packets in the last minute |
| [ vernemq_mqtt_pubrec_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubrec_sent_by_reason_code | Node ${label:node} mqtt v5 unsuccessful sent PUBREC packets in the last minute |
| [ vernemq_mqtt_pubrec_invalid_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubrec_invalid_error | Node ${label:node} mqtt v${label:mqtt_version} received invalid PUBREC packets in the last minute |
| [ vernemq_mqtt_pubrel_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubrel_received_by_reason_code | Node ${label:node} mqtt v5 received unsuccessful PUBREL packets in the last minute |
| [ vernemq_mqtt_pubrel_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubrel_sent_by_reason_code | Node ${label:node} mqtt v5 unsuccessful sent PUBREL packets in the last minute |
| [ vernemq_mqtt_pubcomp_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubcomp_received_by_reason_code | Node ${label:node} mqtt v5 received unsuccessful PUBCOMP packets in the last minute |
| [ vernemq_mqtt_pubcomp_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubcomp_sent_by_reason_code | Node ${label:node} mqtt v5 unsuccessful sent  PUBCOMP packets in the last minute |
| [ vernemq_mqtt_pubcomp_unexpected ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.node_mqtt_pubcomp_invalid_error | Node ${label:node} mqtt v${label:mqtt_version} received unexpected PUBCOMP packets in the last minute |


## Setup


You can configure the **vernemq** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **vernemq**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/vernemq.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | url | Target endpoint URL. | http://127.0.0.1:8888/metrics | yes |
|  | timeout | HTTP request timeout (seconds). | 1 | no |
| **HTTP Auth** | username | Username for Basic HTTP authentication. |  | no |
|  | password | Password for Basic HTTP authentication. |  | no |
|  | bearer_token_file | Path to a file containing a bearer token (used for `Authorization: Bearer`). |  | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Proxy** | proxy_url | HTTP proxy URL. |  | no |
|  | proxy_username | Username for proxy Basic HTTP authentication. |  | no |
|  | proxy_password | Password for proxy Basic HTTP authentication. |  | no |
| **Request** | method | HTTP method to use. | GET | no |
|  | body | Request body (e.g., for POST/PUT). |  | no |
|  | headers | Additional HTTP headers (one per line as key: value). |  | no |
|  | not_follow_redirects | Do not follow HTTP redirects. | no | no |
|  | force_http2 | Force HTTP/2 (including h2c over TCP). | no | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **vernemq** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the vernemq data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _vernemq_ (or scroll the list) to locate the **vernemq** collector.
5. Click the **+** next to the **vernemq** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/vernemq.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/vernemq.conf
```

##### Examples

###### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8888/metrics

```
</details>

###### HTTP authentication

Local instance with basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8888/metrics
    username: username
    password: password

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8888/metrics

  - name: remote
    url: http://203.0.113.10:8888/metrics

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `vernemq` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m vernemq
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m vernemq -j jobName
  ```

### Getting Logs

If you're encountering problems with the `vernemq` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep vernemq
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep vernemq /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep vernemq
```


