<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/integrations/softnet_statistics.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Softnet Statistics"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Network"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Softnet Statistics


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/net/softnet_stat

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

`/proc/net/softnet_stat` provides statistics that relate to the handling of network packets by softirq.

It provides information about:

- Total number of processed packets (`processed`).
- Times ksoftirq ran out of quota (`dropped`).
- Times net_rx_action was rescheduled.
- Number of times processed all lists before quota.
- Number of times did not process all lists due to quota.
- Number of times net_rx_action was rescheduled for GRO (Generic Receive Offload) cells.
- Number of times GRO cells were processed.

Monitoring the /proc/net/softnet_stat file can be useful for:

- **Network performance monitoring**: By tracking the total number of processed packets and how many packets
  were dropped, you can gain insights into your system's network performance.

- **Troubleshooting**: If you're experiencing network-related issues, this collector can provide valuable clues.
  For instance, a high number of dropped packets may indicate a network problem.

- **Capacity planning**: If your system is consistently processing near its maximum capacity of network
  packets, it might be time to consider upgrading your network infrastructure.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Softnet Statistics instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.softnet_stat | processed, dropped, squeezed, received_rps, flow_limit_count | events/s |

### Per cpu core



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cpu.softnet_stat | processed, dropped, squeezed, received_rps, flow_limit_count | events/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ 1min_netdev_backlog_exceeded ](https://github.com/netdata/netdata/blob/master/src/health/health.d/softnet.conf) | system.softnet_stat | average number of dropped packets in the last minute due to exceeded net.core.netdev_max_backlog |
| [ 1min_netdev_budget_ran_outs ](https://github.com/netdata/netdata/blob/master/src/health/health.d/softnet.conf) | system.softnet_stat | average number of times ksoftirq ran out of sysctl net.core.netdev_budget or net.core.netdev_budget_usecs with work remaining over the last minute (this can be a cause for dropped packets) |


## Setup


### Prerequisites

No action required.

### Configuration

#### Options



There are no configuration options.



#### via File

There is no configuration file.

##### Examples
There are no configuration examples.


