<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/dovecot/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/dovecot/metadata.yaml"
sidebar_label: "Dovecot"
learn_status: "Published"
learn_rel_path: "Data Collection/Mail Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Dovecot


<img src="https://netdata.cloud/img/dovecot.svg" width="150"/>


Plugin: python.d.plugin
Module: dovecot

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Dovecot metrics about sessions, logins, commands, page faults and more.

It uses the dovecot socket and executes the `EXPORT global` command to get the statistics.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

If no configuration is given, the collector will attempt to connect to dovecot using unix socket localized in `/var/run/dovecot/stats`

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Dovecot instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| dovecot.sessions | active sessions | number |
| dovecot.logins | logins | number |
| dovecot.commands | commands | commands |
| dovecot.faults | minor, major | faults |
| dovecot.context_switches | voluntary, involuntary | switches |
| dovecot.io | read, write | KiB/s |
| dovecot.net | read, write | kilobits/s |
| dovecot.syscalls | read, write | syscalls/s |
| dovecot.lookup | path, attr | number/s |
| dovecot.cache | hits | hits/s |
| dovecot.auth | ok, failed | attempts |
| dovecot.auth_cache | hit, miss | number |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Dovecot configuration

The Dovecot UNIX socket should have R/W permissions for user netdata, or Dovecot should be configured with a TCP/IP socket.


### Configuration

#### File

The configuration file name for this integration is `python.d/dovecot.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/dovecot.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| socket | Use this socket to communicate with Devcot | /var/run/dovecot/stats | no |
| host | Instead of using a socket, you can point the collector to an ip for devcot statistics. |  | no |
| port | Used in combination with host, configures the port devcot listens to. |  | no |

</details>

#### Examples

##### Local TCP

A basic TCP configuration.

<details><summary>Config</summary>

```yaml
localtcpip:
 name: 'local'
 host: '127.0.0.1'
 port: 24242

```
</details>

##### Local socket

A basic local socket configuration

<details><summary>Config</summary>

```yaml
localsocket:
 name: 'local'
 socket: '/var/run/dovecot/stats'

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `dovecot` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin dovecot debug trace
  ```


