<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/bind_rndc/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/bind_rndc/metadata.yaml"
sidebar_label: "ISC Bind (RNDC)"
learn_status: "Published"
learn_rel_path: "Data Collection/DNS and DHCP Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# ISC Bind (RNDC)


<img src="https://netdata.cloud/img/isc.png" width="150"/>


Plugin: python.d.plugin
Module: bind_rndc

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor ISCBind (RNDC) performance for optimal DNS server operations. Monitor query rates, response times, and error rates to ensure reliable DNS service delivery.

This collector uses the `rndc` tool to dump (named.stats) statistics then read them to gather Bind Name Server summary performance metrics.

This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

If no configuration is given, the collector will attempt to read named.stats file at `/var/log/bind/named.stats`

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ISC Bind (RNDC) instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| bind_rndc.name_server_statistics | requests, rejected_queries, success, failure, responses, duplicate, recursion, nxrrset, nxdomain, non_auth_answer, auth_answer, dropped_queries | stats |
| bind_rndc.incoming_queries | a dimension per incoming query type | queries |
| bind_rndc.outgoing_queries | a dimension per outgoing query type | queries |
| bind_rndc.stats_size | stats_size | MiB |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ bind_rndc_stats_file_size ](https://github.com/netdata/netdata/blob/master/health/health.d/bind_rndc.conf) | bind_rndc.stats_size | BIND statistics-file size |


## Setup

### Prerequisites

#### Minimum bind version and permissions

Version of bind must be >=9.6 and the Netdata user must have permissions to run `rndc stats`

#### Setup log rotate for bind stats

BIND appends logs at EVERY RUN. It is NOT RECOMMENDED to set `update_every` below 30 sec.
It is STRONGLY RECOMMENDED to create a `bind-rndc.conf` file for logrotate.

To set up BIND to dump stats do the following:

1. Add to 'named.conf.options' options {}:
`statistics-file "/var/log/bind/named.stats";`

2. Create bind/ directory in /var/log:
`cd /var/log/ && mkdir bind`

3. Change owner of directory to 'bind' user:
`chown bind bind/`

4. RELOAD (NOT restart) BIND:
`systemctl reload bind9.service`

5. Run as a root 'rndc stats' to dump (BIND will create named.stats in new directory)

To allow Netdata to run 'rndc stats' change '/etc/bind/rndc.key' group to netdata:
`chown :netdata rndc.key`

Last, BUT NOT least, is to create bind-rndc.conf in logrotate.d/:
```
/var/log/bind/named.stats {

    daily
    rotate 4
    compress
    delaycompress
    create 0644 bind bind
    missingok
    postrotate
        rndc reload > /dev/null
    endscript
}
```
To test your logrotate conf file run as root:
`logrotate /etc/logrotate.d/bind-rndc -d (debug dry-run mode)`



### Configuration

#### File

The configuration file name for this integration is `python.d/bind_rndc.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/bind_rndc.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| named_stats_path | Path to the named stats, after being dumped by `nrdc` | /var/log/bind/named.stats | no |

</details>

#### Examples

##### Local bind stats

Define a local path to bind stats file

```yaml
local:
 named_stats_path: '/var/log/bind/named.stats'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `bind_rndc` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin bind_rndc debug trace
  ```


