; APX CFCMOVCC testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 64

; ----- cfcmovcc instruction -----
; --- cfcmovb ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x42, 0x0A},	{cfcmovb cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x42, 0x0A},	{cfcmovb ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x42, 0x0A},	{cfcmovb rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x42, 0xCA},	{cfcmovb dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x42, 0xCA},	{cfcmovb edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x42, 0xCA},	{cfcmovb rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x42, 0x0A},	{cfcmovb [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x42, 0x0A},	{cfcmovb [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x42, 0x0A},	{cfcmovb [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x42, 0x0A},	{cfcmovb ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x42, 0x0A},	{cfcmovb eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x42, 0x0A},	{cfcmovb rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x42, 0x0A},	{cfcmovb cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x42, 0x0A},	{cfcmovb ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x42, 0x0A},	{cfcmovb rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x42, 0xCA},	{cfcmovb r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x42, 0xCA},	{cfcmovb r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x42, 0xCA},	{cfcmovb r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x42, 0x0A},	{cfcmovb [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x42, 0x0A},	{cfcmovb [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x42, 0x0A},	{cfcmovb [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x42, 0x0A},	{cfcmovb ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x42, 0x0A},	{cfcmovb eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x42, 0x0A},	{cfcmovb rax, rcx, [r26]}

; --- cfcmovbe ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x46, 0x0A},	{cfcmovbe cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x46, 0x0A},	{cfcmovbe ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x46, 0x0A},	{cfcmovbe rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x46, 0xCA},	{cfcmovbe dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x46, 0xCA},	{cfcmovbe edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x46, 0xCA},	{cfcmovbe rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x46, 0x0A},	{cfcmovbe [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x46, 0x0A},	{cfcmovbe [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x46, 0x0A},	{cfcmovbe [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x46, 0x0A},	{cfcmovbe ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x46, 0x0A},	{cfcmovbe eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x46, 0x0A},	{cfcmovbe rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x46, 0x0A},	{cfcmovbe cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x46, 0x0A},	{cfcmovbe ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x46, 0x0A},	{cfcmovbe rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x46, 0xCA},	{cfcmovbe r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x46, 0xCA},	{cfcmovbe r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x46, 0xCA},	{cfcmovbe r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x46, 0x0A},	{cfcmovbe [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x46, 0x0A},	{cfcmovbe [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x46, 0x0A},	{cfcmovbe [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x46, 0x0A},	{cfcmovbe ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x46, 0x0A},	{cfcmovbe eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x46, 0x0A},	{cfcmovbe rax, rcx, [r26]}

; --- cfcmovl ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x4C, 0x0A},	{cfcmovl cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x4C, 0x0A},	{cfcmovl ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x4C, 0x0A},	{cfcmovl rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4C, 0xCA},	{cfcmovl dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4C, 0xCA},	{cfcmovl edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4C, 0xCA},	{cfcmovl rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4C, 0x0A},	{cfcmovl [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4C, 0x0A},	{cfcmovl [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4C, 0x0A},	{cfcmovl [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x4C, 0x0A},	{cfcmovl ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x4C, 0x0A},	{cfcmovl eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x4C, 0x0A},	{cfcmovl rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x4C, 0x0A},	{cfcmovl cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x4C, 0x0A},	{cfcmovl ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x4C, 0x0A},	{cfcmovl rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4C, 0xCA},	{cfcmovl r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4C, 0xCA},	{cfcmovl r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4C, 0xCA},	{cfcmovl r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4C, 0x0A},	{cfcmovl [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4C, 0x0A},	{cfcmovl [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4C, 0x0A},	{cfcmovl [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x4C, 0x0A},	{cfcmovl ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x4C, 0x0A},	{cfcmovl eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x4C, 0x0A},	{cfcmovl rax, rcx, [r26]}

; --- cfcmovle ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x4E, 0x0A},	{cfcmovle cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x4E, 0x0A},	{cfcmovle ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x4E, 0x0A},	{cfcmovle rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4E, 0xCA},	{cfcmovle dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4E, 0xCA},	{cfcmovle edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4E, 0xCA},	{cfcmovle rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4E, 0x0A},	{cfcmovle [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4E, 0x0A},	{cfcmovle [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4E, 0x0A},	{cfcmovle [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x4E, 0x0A},	{cfcmovle ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x4E, 0x0A},	{cfcmovle eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x4E, 0x0A},	{cfcmovle rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x4E, 0x0A},	{cfcmovle cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x4E, 0x0A},	{cfcmovle ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x4E, 0x0A},	{cfcmovle rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4E, 0xCA},	{cfcmovle r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4E, 0xCA},	{cfcmovle r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4E, 0xCA},	{cfcmovle r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4E, 0x0A},	{cfcmovle [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4E, 0x0A},	{cfcmovle [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4E, 0x0A},	{cfcmovle [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x4E, 0x0A},	{cfcmovle ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x4E, 0x0A},	{cfcmovle eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x4E, 0x0A},	{cfcmovle rax, rcx, [r26]}

; --- cfcmovnb ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x43, 0x0A},	{cfcmovnb cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x43, 0x0A},	{cfcmovnb ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x43, 0x0A},	{cfcmovnb rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x43, 0xCA},	{cfcmovnb dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x43, 0xCA},	{cfcmovnb edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x43, 0xCA},	{cfcmovnb rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x43, 0x0A},	{cfcmovnb [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x43, 0x0A},	{cfcmovnb [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x43, 0x0A},	{cfcmovnb [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x43, 0x0A},	{cfcmovnb ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x43, 0x0A},	{cfcmovnb eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x43, 0x0A},	{cfcmovnb rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x43, 0x0A},	{cfcmovnb cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x43, 0x0A},	{cfcmovnb ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x43, 0x0A},	{cfcmovnb rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x43, 0xCA},	{cfcmovnb r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x43, 0xCA},	{cfcmovnb r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x43, 0xCA},	{cfcmovnb r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x43, 0x0A},	{cfcmovnb [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x43, 0x0A},	{cfcmovnb [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x43, 0x0A},	{cfcmovnb [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x43, 0x0A},	{cfcmovnb ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x43, 0x0A},	{cfcmovnb eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x43, 0x0A},	{cfcmovnb rax, rcx, [r26]}

; --- cfcmovnbe ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x47, 0x0A},	{cfcmovnbe cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x47, 0x0A},	{cfcmovnbe ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x47, 0x0A},	{cfcmovnbe rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x47, 0xCA},	{cfcmovnbe dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x47, 0xCA},	{cfcmovnbe edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x47, 0xCA},	{cfcmovnbe rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x47, 0x0A},	{cfcmovnbe [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x47, 0x0A},	{cfcmovnbe [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x47, 0x0A},	{cfcmovnbe [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x47, 0x0A},	{cfcmovnbe ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x47, 0x0A},	{cfcmovnbe eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x47, 0x0A},	{cfcmovnbe rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x47, 0x0A},	{cfcmovnbe cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x47, 0x0A},	{cfcmovnbe ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x47, 0x0A},	{cfcmovnbe rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x47, 0xCA},	{cfcmovnbe r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x47, 0xCA},	{cfcmovnbe r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x47, 0xCA},	{cfcmovnbe r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x47, 0x0A},	{cfcmovnbe [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x47, 0x0A},	{cfcmovnbe [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x47, 0x0A},	{cfcmovnbe [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x47, 0x0A},	{cfcmovnbe ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x47, 0x0A},	{cfcmovnbe eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x47, 0x0A},	{cfcmovnbe rax, rcx, [r26]}

; --- cfcmovnl ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x4D, 0x0A},	{cfcmovnl cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x4D, 0x0A},	{cfcmovnl ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x4D, 0x0A},	{cfcmovnl rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4D, 0xCA},	{cfcmovnl dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4D, 0xCA},	{cfcmovnl edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4D, 0xCA},	{cfcmovnl rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4D, 0x0A},	{cfcmovnl [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4D, 0x0A},	{cfcmovnl [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4D, 0x0A},	{cfcmovnl [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x4D, 0x0A},	{cfcmovnl ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x4D, 0x0A},	{cfcmovnl eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x4D, 0x0A},	{cfcmovnl rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x4D, 0x0A},	{cfcmovnl cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x4D, 0x0A},	{cfcmovnl ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x4D, 0x0A},	{cfcmovnl rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4D, 0xCA},	{cfcmovnl r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4D, 0xCA},	{cfcmovnl r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4D, 0xCA},	{cfcmovnl r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4D, 0x0A},	{cfcmovnl [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4D, 0x0A},	{cfcmovnl [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4D, 0x0A},	{cfcmovnl [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x4D, 0x0A},	{cfcmovnl ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x4D, 0x0A},	{cfcmovnl eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x4D, 0x0A},	{cfcmovnl rax, rcx, [r26]}

; --- cfcmovnle ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x4F, 0x0A},	{cfcmovnle cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x4F, 0x0A},	{cfcmovnle ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x4F, 0x0A},	{cfcmovnle rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4F, 0xCA},	{cfcmovnle dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4F, 0xCA},	{cfcmovnle edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4F, 0xCA},	{cfcmovnle rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4F, 0x0A},	{cfcmovnle [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4F, 0x0A},	{cfcmovnle [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4F, 0x0A},	{cfcmovnle [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x4F, 0x0A},	{cfcmovnle ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x4F, 0x0A},	{cfcmovnle eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x4F, 0x0A},	{cfcmovnle rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x4F, 0x0A},	{cfcmovnle cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x4F, 0x0A},	{cfcmovnle ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x4F, 0x0A},	{cfcmovnle rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4F, 0xCA},	{cfcmovnle r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4F, 0xCA},	{cfcmovnle r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4F, 0xCA},	{cfcmovnle r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4F, 0x0A},	{cfcmovnle [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4F, 0x0A},	{cfcmovnle [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4F, 0x0A},	{cfcmovnle [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x4F, 0x0A},	{cfcmovnle ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x4F, 0x0A},	{cfcmovnle eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x4F, 0x0A},	{cfcmovnle rax, rcx, [r26]}

; --- cfcmovno ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x41, 0x0A},	{cfcmovno cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x41, 0x0A},	{cfcmovno ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x41, 0x0A},	{cfcmovno rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x41, 0xCA},	{cfcmovno dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x41, 0xCA},	{cfcmovno edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x41, 0xCA},	{cfcmovno rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x41, 0x0A},	{cfcmovno [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x41, 0x0A},	{cfcmovno [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x41, 0x0A},	{cfcmovno [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x41, 0x0A},	{cfcmovno ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x41, 0x0A},	{cfcmovno eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x41, 0x0A},	{cfcmovno rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x41, 0x0A},	{cfcmovno cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x41, 0x0A},	{cfcmovno ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x41, 0x0A},	{cfcmovno rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x41, 0xCA},	{cfcmovno r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x41, 0xCA},	{cfcmovno r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x41, 0xCA},	{cfcmovno r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x41, 0x0A},	{cfcmovno [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x41, 0x0A},	{cfcmovno [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x41, 0x0A},	{cfcmovno [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x41, 0x0A},	{cfcmovno ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x41, 0x0A},	{cfcmovno eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x41, 0x0A},	{cfcmovno rax, rcx, [r26]}

; --- cfcmovnp ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x4B, 0x0A},	{cfcmovnp cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x4B, 0x0A},	{cfcmovnp ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x4B, 0x0A},	{cfcmovnp rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4B, 0xCA},	{cfcmovnp dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4B, 0xCA},	{cfcmovnp edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4B, 0xCA},	{cfcmovnp rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4B, 0x0A},	{cfcmovnp [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4B, 0x0A},	{cfcmovnp [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4B, 0x0A},	{cfcmovnp [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x4B, 0x0A},	{cfcmovnp ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x4B, 0x0A},	{cfcmovnp eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x4B, 0x0A},	{cfcmovnp rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x4B, 0x0A},	{cfcmovnp cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x4B, 0x0A},	{cfcmovnp ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x4B, 0x0A},	{cfcmovnp rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4B, 0xCA},	{cfcmovnp r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4B, 0xCA},	{cfcmovnp r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4B, 0xCA},	{cfcmovnp r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4B, 0x0A},	{cfcmovnp [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4B, 0x0A},	{cfcmovnp [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4B, 0x0A},	{cfcmovnp [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x4B, 0x0A},	{cfcmovnp ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x4B, 0x0A},	{cfcmovnp eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x4B, 0x0A},	{cfcmovnp rax, rcx, [r26]}

; --- cfcmovns ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x49, 0x0A},	{cfcmovns cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x49, 0x0A},	{cfcmovns ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x49, 0x0A},	{cfcmovns rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x49, 0xCA},	{cfcmovns dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x49, 0xCA},	{cfcmovns edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x49, 0xCA},	{cfcmovns rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x49, 0x0A},	{cfcmovns [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x49, 0x0A},	{cfcmovns [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x49, 0x0A},	{cfcmovns [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x49, 0x0A},	{cfcmovns ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x49, 0x0A},	{cfcmovns eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x49, 0x0A},	{cfcmovns rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x49, 0x0A},	{cfcmovns cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x49, 0x0A},	{cfcmovns ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x49, 0x0A},	{cfcmovns rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x49, 0xCA},	{cfcmovns r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x49, 0xCA},	{cfcmovns r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x49, 0xCA},	{cfcmovns r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x49, 0x0A},	{cfcmovns [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x49, 0x0A},	{cfcmovns [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x49, 0x0A},	{cfcmovns [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x49, 0x0A},	{cfcmovns ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x49, 0x0A},	{cfcmovns eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x49, 0x0A},	{cfcmovns rax, rcx, [r26]}

; --- cfcmovnz ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x45, 0x0A},	{cfcmovnz cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x45, 0x0A},	{cfcmovnz ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x45, 0x0A},	{cfcmovnz rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x45, 0xCA},	{cfcmovnz dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x45, 0xCA},	{cfcmovnz edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x45, 0xCA},	{cfcmovnz rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x45, 0x0A},	{cfcmovnz [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x45, 0x0A},	{cfcmovnz [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x45, 0x0A},	{cfcmovnz [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x45, 0x0A},	{cfcmovnz ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x45, 0x0A},	{cfcmovnz eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x45, 0x0A},	{cfcmovnz rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x45, 0x0A},	{cfcmovnz cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x45, 0x0A},	{cfcmovnz ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x45, 0x0A},	{cfcmovnz rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x45, 0xCA},	{cfcmovnz r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x45, 0xCA},	{cfcmovnz r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x45, 0xCA},	{cfcmovnz r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x45, 0x0A},	{cfcmovnz [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x45, 0x0A},	{cfcmovnz [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x45, 0x0A},	{cfcmovnz [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x45, 0x0A},	{cfcmovnz ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x45, 0x0A},	{cfcmovnz eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x45, 0x0A},	{cfcmovnz rax, rcx, [r26]}

; --- cfcmovo ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x40, 0x0A},	{cfcmovo cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x40, 0x0A},	{cfcmovo ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x40, 0x0A},	{cfcmovo rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x40, 0xCA},	{cfcmovo dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x40, 0xCA},	{cfcmovo edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x40, 0xCA},	{cfcmovo rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x40, 0x0A},	{cfcmovo [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x40, 0x0A},	{cfcmovo [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x40, 0x0A},	{cfcmovo [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x40, 0x0A},	{cfcmovo ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x40, 0x0A},	{cfcmovo eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x40, 0x0A},	{cfcmovo rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x40, 0x0A},	{cfcmovo cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x40, 0x0A},	{cfcmovo ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x40, 0x0A},	{cfcmovo rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x40, 0xCA},	{cfcmovo r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x40, 0xCA},	{cfcmovo r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x40, 0xCA},	{cfcmovo r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x40, 0x0A},	{cfcmovo [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x40, 0x0A},	{cfcmovo [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x40, 0x0A},	{cfcmovo [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x40, 0x0A},	{cfcmovo ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x40, 0x0A},	{cfcmovo eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x40, 0x0A},	{cfcmovo rax, rcx, [r26]}

; --- cfcmovp ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x4A, 0x0A},	{cfcmovp cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x4A, 0x0A},	{cfcmovp ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x4A, 0x0A},	{cfcmovp rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4A, 0xCA},	{cfcmovp dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4A, 0xCA},	{cfcmovp edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4A, 0xCA},	{cfcmovp rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x4A, 0x0A},	{cfcmovp [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x4A, 0x0A},	{cfcmovp [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x4A, 0x0A},	{cfcmovp [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x4A, 0x0A},	{cfcmovp ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x4A, 0x0A},	{cfcmovp eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x4A, 0x0A},	{cfcmovp rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x4A, 0x0A},	{cfcmovp cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x4A, 0x0A},	{cfcmovp ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x4A, 0x0A},	{cfcmovp rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4A, 0xCA},	{cfcmovp r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4A, 0xCA},	{cfcmovp r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4A, 0xCA},	{cfcmovp r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x4A, 0x0A},	{cfcmovp [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x4A, 0x0A},	{cfcmovp [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x4A, 0x0A},	{cfcmovp [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x4A, 0x0A},	{cfcmovp ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x4A, 0x0A},	{cfcmovp eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x4A, 0x0A},	{cfcmovp rax, rcx, [r26]}

; --- cfcmovs ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x48, 0x0A},	{cfcmovs cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x48, 0x0A},	{cfcmovs ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x48, 0x0A},	{cfcmovs rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x48, 0xCA},	{cfcmovs dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x48, 0xCA},	{cfcmovs edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x48, 0xCA},	{cfcmovs rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x48, 0x0A},	{cfcmovs [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x48, 0x0A},	{cfcmovs [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x48, 0x0A},	{cfcmovs [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x48, 0x0A},	{cfcmovs ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x48, 0x0A},	{cfcmovs eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x48, 0x0A},	{cfcmovs rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x48, 0x0A},	{cfcmovs cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x48, 0x0A},	{cfcmovs ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x48, 0x0A},	{cfcmovs rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x48, 0xCA},	{cfcmovs r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x48, 0xCA},	{cfcmovs r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x48, 0xCA},	{cfcmovs r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x48, 0x0A},	{cfcmovs [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x48, 0x0A},	{cfcmovs [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x48, 0x0A},	{cfcmovs [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x48, 0x0A},	{cfcmovs ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x48, 0x0A},	{cfcmovs eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x48, 0x0A},	{cfcmovs rax, rcx, [r26]}

; --- cfcmovz ---
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x44, 0x0A},	{cfcmovz cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x44, 0x0A},	{cfcmovz ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x44, 0x0A},	{cfcmovz rcx, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x44, 0xCA},	{cfcmovz dx, cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x44, 0xCA},	{cfcmovz edx, ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x44, 0xCA},	{cfcmovz rdx, rcx}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x44, 0x0A},	{cfcmovz [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x44, 0x0A},	{cfcmovz [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x44, 0x0A},	{cfcmovz [rdx], rcx}
testcase	{0x62, 0xF4, 0x7D, 0x1C, 0x44, 0x0A},	{cfcmovz ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x1C, 0x44, 0x0A},	{cfcmovz eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x1C, 0x44, 0x0A},	{cfcmovz rax, rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x44, 0x0A},	{cfcmovz cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x44, 0x0A},	{cfcmovz ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x44, 0x0A},	{cfcmovz rcx, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x44, 0xCA},	{cfcmovz r26w, cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x44, 0xCA},	{cfcmovz r26d, ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x44, 0xCA},	{cfcmovz r26, rcx}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x44, 0x0A},	{cfcmovz [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x44, 0x0A},	{cfcmovz [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x44, 0x0A},	{cfcmovz [r26], rcx}
testcase	{0x62, 0xDC, 0x7D, 0x1C, 0x44, 0x0A},	{cfcmovz ax, cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x1C, 0x44, 0x0A},	{cfcmovz eax, ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x1C, 0x44, 0x0A},	{cfcmovz rax, rcx, [r26]}

