/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelSourceTransformer;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.v4.MavenStaxReader;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class DefaultModelReader
implements ModelReader {
    private final ModelSourceTransformer transformer;

    @Inject
    public DefaultModelReader(ModelSourceTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public Model read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        return this.read(input.toPath(), options);
    }

    @Override
    public Model read(Path path, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(path, "path cannot be null");
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Model model = this.read(in, path, options);
            model.setPomPath(path);
            Model model2 = model;
            return model2;
        }
    }

    @Override
    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            Model model = this.read(in, null, options);
            return model;
        }
    }

    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = input;){
            Model model = this.read(input, null, options);
            return model;
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }

    private InputSource getSource(Map<String, ?> options) {
        Object value = options != null ? options.get("org.apache.maven.model.io.inputSource") : null;
        return value;
    }

    private Path getRootDirectory(Map<String, ?> options) {
        Object value = options != null ? options.get("rootDirectory") : null;
        return value;
    }

    private Model read(InputStream input, Path pomFile, Map<String, ?> options) throws IOException {
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XMLStreamReader parser = factory.createXMLStreamReader(input);
            InputSource source = this.getSource(options);
            boolean strict = this.isStrict(options);
            MavenStaxReader mr = new MavenStaxReader();
            mr.setAddLocationInformation(source != null);
            Model model = new Model(mr.read(parser, strict, source != null ? source.toApiSource() : null));
            return model;
        }
        catch (XMLStreamException e) {
            Location location = e.getLocation();
            throw new ModelParseException(e.getMessage(), location != null ? location.getLineNumber() : -1, location != null ? location.getColumnNumber() : -1, e);
        }
        catch (Exception e) {
            throw new IOException("Unable to transform pom", e);
        }
    }

    private Model read(Reader reader, Path pomFile, Map<String, ?> options) throws IOException {
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XMLStreamReader parser = factory.createXMLStreamReader(reader);
            InputSource source = this.getSource(options);
            boolean strict = this.isStrict(options);
            MavenStaxReader mr = new MavenStaxReader();
            mr.setAddLocationInformation(source != null);
            Model model = new Model(mr.read(parser, strict, source != null ? source.toApiSource() : null));
            return model;
        }
        catch (XMLStreamException e) {
            Location location = e.getLocation();
            throw new ModelParseException(e.getMessage(), location != null ? location.getLineNumber() : -1, location != null ? location.getColumnNumber() : -1, e);
        }
        catch (Exception e) {
            throw new IOException("Unable to transform pom", e);
        }
    }
}

