/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;

public class DependencyContext {
    private final MavenProject project;
    private final Collection<String> scopesToCollectForCurrentProject;
    private final Collection<String> scopesToResolveForCurrentProject;
    private final Collection<String> scopesToCollectForAggregatedProjects;
    private final Collection<String> scopesToResolveForAggregatedProjects;
    private volatile Collection<?> lastDependencyArtifacts = Collections.emptyList();
    private volatile int lastDependencyArtifactCount = -1;

    public DependencyContext(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve) {
        this.project = project;
        this.scopesToCollectForCurrentProject = scopesToCollect;
        this.scopesToResolveForCurrentProject = scopesToResolve;
        this.scopesToCollectForAggregatedProjects = Collections.synchronizedSet(new TreeSet());
        this.scopesToResolveForAggregatedProjects = Collections.synchronizedSet(new TreeSet());
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Collection<String> getScopesToCollectForCurrentProject() {
        return this.scopesToCollectForCurrentProject;
    }

    public Collection<String> getScopesToResolveForCurrentProject() {
        return this.scopesToResolveForCurrentProject;
    }

    public Collection<String> getScopesToCollectForAggregatedProjects() {
        return this.scopesToCollectForAggregatedProjects;
    }

    public Collection<String> getScopesToResolveForAggregatedProjects() {
        return this.scopesToResolveForAggregatedProjects;
    }

    public boolean isResolutionRequiredForCurrentProject() {
        return this.lastDependencyArtifacts != this.project.getDependencyArtifacts() || this.lastDependencyArtifacts != null && this.lastDependencyArtifactCount != this.lastDependencyArtifacts.size();
    }

    public boolean isResolutionRequiredForAggregatedProjects(Collection<String> scopesToCollect, Collection<String> scopesToResolve) {
        return this.scopesToCollectForAggregatedProjects.addAll(scopesToCollect) || this.scopesToResolveForAggregatedProjects.addAll(scopesToResolve);
    }

    public void synchronizeWithProjectState() {
        this.lastDependencyArtifacts = this.project.getDependencyArtifacts();
        this.lastDependencyArtifactCount = this.lastDependencyArtifacts != null ? this.lastDependencyArtifacts.size() : 0;
    }
}

