#!/bin/sh 

# $Id: test.sh,v 1.8 2005/01/13 21:13:22 alien-science Exp $

# To be run from main murk directory

ran_tests=0
passed_tests=0

########
# Runs a test
run_test()
{
   description=$1
   args=$2
   with_prompt=$3

   # This is a new test
   ran_tests=`expr $ran_tests + 1`

   # Tidy up
   rm tests/test_data_a_out.tar  \
      tests/test_data_a.tar.zm   \
      2> /dev/null

   printf "%-32s" "$description"

   if [ "X$with_prompt" = 'XWITH_PROMPT' ]
   then
      # Encrypt
      echo "password" | ./murk $args piggle tests/test_data_a.tar \
                       1> /dev/null 2>&1

      # Decrypt
      echo "password" | ./murk -d -o tests/test_data_a_out.tar \
                                piggle tests/test_data_a.tar.zm  \
                       1> /dev/null 2>&1
   else
      # Encrypt
      echo "password" | ./murk -a $args -k tests/passfile \
                       piggle tests/test_data_a.tar \
                       1> /dev/null 2>&1

      # Decrypt
      ./murk -d -n -o tests/test_data_a_out.tar -k tests/passfile \
                   piggle tests/test_data_a.tar.zm  \
                       1> /dev/null 2>&1
   fi

   # Check
   if cmp tests/test_data_a.tar tests/test_data_a_out.tar 2> /dev/null
   then
      echo "Pass"
      passed_tests=`expr $passed_tests + 1`
   else
      echo "Fail"
   fi
}

# Clean up
rm tests/*.tar*   2> /dev/null
rm tests/passfile 2> /dev/null

# First create some tar files to test with
tar -cf tests/test_data_a.tar *.c *.h *.o murk
echo "Here is a change" > tests/extra.txt
tar -cf tests/test_data_b.tar tests/extra.txt *.c *.h *.o murk 

# Loop through the available ciphers
for cipher in aes-128 aes-192 aes-256 des idea rc2-64 rc2 bf cast \
              rc5 des-ede des-ede3 null
do
   run_test "cipher $cipher" "--cipher $cipher" 'WITH_PROMPT'
done
 
# No compression
run_test "no compression" '-0' 'WITH_PROMPT'

# Loop through some blocksizes
for blk_size in 1 2 4 8 16 32 64 128 256 512 1024
do
   run_test "blocksize ${blk_size}KB" "--blocksize $blk_size" 'WITH_PROMPT'
done

# Add a key to the murk passfile
printf "%-32s" "add key"
ran_tests=`expr $ran_tests + 1`
echo "password" | ./murk -a -k tests/passfile piggle \
                       1> /dev/null 2>&1
entries=`grep piggle tests/passfile | wc -l`
if [ $entries -eq 1 ]
then
   echo "Pass"
   passed_tests=`expr $passed_tests + 1`
else
   echo "Fail"
fi

# Run some encryption/decriptions unprompted
for cipher in des bf des-ede3 
do 
   for blk_size in 1 16 256 1024
   do
      run_test "unattended $cipher/${blk_size}KB" "--cipher $cipher" 'NO_PROMPT'
   done
done

# Check the difference in encrypting a and b tar files
printf "%-32s" "small delta -> small delta"
ran_tests=`expr $ran_tests + 1`
./murk -v -n -k tests/passfile  piggle tests/test_data_a.tar > tests/a.verbose 2>&1
./murk -v -n -k tests/passfile  piggle tests/test_data_b.tar > tests/b.verbose 2>&1
differences=`diff tests/a.verbose tests/b.verbose | wc -l`

if [ $differences -gt 0 -a $differences -le 10 ]
then
   echo "Pass"
   passed_tests=`expr $passed_tests + 1`
else
   echo "Fail"
fi

# Summary
failures=`expr $ran_tests - $passed_tests`

if [ $failures -gt 0 ]
then
   echo "FAILED  ${failures}/${ran_tests}"
else
   echo "Passed all tests"
fi

