
/* $Id: cipher.h,v 1.4 2005/03/11 23:16:02 alien-science Exp $ */

#ifndef CIPHER_H
#define CIPHER_H

#include <openssl/evp.h>
#include "prog_config.h"

/* The maximum length of the name of a cipher type */
#define CIPHER_TYPE_MAXLEN 30

/* A structure that holds message digests */
struct digest {
   char     value[EVP_MAX_MD_SIZE];
   size_t   len;
};

extern void
cipher_new(struct cipher *, const EVP_CIPHER *);

extern void
cipher_delete(struct cipher *);

extern const EVP_CIPHER *
cipher_type(char *);

extern const EVP_MD *
digest_type(char *);

extern int 
cipher_keyword_conf(struct config *);

extern int 
cipher_key_iv(struct config *);

#endif
