/* Generated by re2c 1.3 on Tue Sep 28 18:26:56 2021 */
/**

	MultiMarkdown 6 -- Lightweight markup processor to produce HTML, LaTeX, and more.

	@file lexer.re

	@brief Description of the regular expressions used to define tokens,
	used by re2c to create a lexer/tokenizer.


	@author	Fletcher T. Penney
	@bug

**/

/*

	Copyright © 2016 - 2017 Fletcher T. Penney.


	The `MultiMarkdown 6` project is released under the MIT License..

	GLibFacade.c and GLibFacade.h are from the MultiMarkdown v4 project:

		https://github.com/fletcher/MultiMarkdown-4/

	MMD 4 is released under both the MIT License and GPL.


	CuTest is released under the zlib/libpng license. See CuTest.c for the text
	of the license.


	## The MIT License ##

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.

*/

#include "lexer.h"
#include "libMultiMarkdown.h"
#include "parser.h"


// Basic scanner struct

#define YYCTYPE		unsigned char
#define YYCURSOR	s->cur
#define YYMARKER	s->ptr
#define YYCTXMARKER	s->ctx

int scan(Scanner * s, const char * stop) {

scan:

	if (s->cur >= stop) {
		return 0;
	}

	s->start = s->cur;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
				goto yy4;

			case '\n':
				goto yy6;

			case '\r':
				goto yy8;

			case ' ':
				goto yy9;

			case '!':
				goto yy10;

			case '"':
				goto yy11;

			case '#':
				goto yy13;

			case '$':
				goto yy15;

			case '%':
				goto yy17;

			case '&':
				goto yy19;

			case '\'':
				goto yy21;

			case '(':
				goto yy23;

			case ')':
				goto yy25;

			case '*':
				goto yy27;

			case '+':
				goto yy29;

			case '-':
				goto yy31;

			case '.':
				goto yy33;

			case '/':
				goto yy34;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy36;

			case ':':
				goto yy37;

			case '<':
				goto yy39;

			case '=':
				goto yy41;

			case '>':
				goto yy43;

			case '[':
				goto yy45;

			case '\\':
				goto yy47;

			case ']':
				goto yy49;

			case '^':
				goto yy51;

			case '_':
				goto yy53;

			case '`':
				goto yy55;

			case '{':
				goto yy58;

			case '|':
				goto yy60;

			case '}':
				goto yy63;

			case '~':
				goto yy65;

			case 0xC2:
				goto yy67;

			case 0xEF:
				goto yy68;

			default:
				goto yy2;
		}

yy2:
		++YYCURSOR;
yy3: {
			goto scan;
		}
yy4:
		++YYCURSOR;
		{
			return INDENT_TAB;
		}
yy6:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case ' ':
				goto yy69;

			default:
				goto yy7;
		}

yy7: {
			return TEXT_NL;
		}
yy8:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\n':
				goto yy6;

			case ' ':
				goto yy69;

			default:
				goto yy7;
		}

yy9:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\t':
				goto yy71;

			case '\n':
				goto yy73;

			case '\r':
				goto yy74;

			case ' ':
				goto yy75;

			case 0xC2:
				goto yy77;

			default:
				goto yy3;
		}

yy10:
		yych = *++YYCURSOR;

		switch (yych) {
			case '[':
				goto yy78;

			default:
				goto yy3;
		}

yy11:
		++YYCURSOR;
		{
			return QUOTE_DOUBLE;
		}
yy13:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy80;

			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy82;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy85;

			case '#':
				goto yy86;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy87;

			default:
				goto yy14;
		}

yy14: {
			return TEXT_HASH;
		}
yy15:
		yych = *++YYCURSOR;

		switch (yych) {
			case '$':
				goto yy88;

			default:
				goto yy16;
		}

yy16: {
			return MATH_DOLLAR_SINGLE;
		}
yy17:
		++YYCURSOR;
		{
			return TEXT_PERCENT;
		}
yy19:
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '#':
				goto yy90;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy91;

			case 'A':
			case 'a':
				goto yy93;

			default:
				goto yy20;
		}

yy20: {
			return AMPERSAND;
		}
yy21:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\'':
				goto yy94;

			default:
				goto yy22;
		}

yy22: {
			return QUOTE_SINGLE;
		}
yy23:
		++YYCURSOR;
		{
			return PAREN_LEFT;
		}
yy25:
		++YYCURSOR;
		{
			return PAREN_RIGHT;
		}
yy27:
		++YYCURSOR;
		{
			return STAR;
		}
yy29:
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '+':
				goto yy96;

			default:
				goto yy30;
		}

yy30: {
			return PLUS;
		}
yy31:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
				goto yy97;

			default:
				goto yy32;
		}

yy32: {
			return DASH_N;
		}
yy33:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case ' ':
				goto yy99;

			case '.':
				goto yy100;

			default:
				goto yy3;
		}

yy34:
		++YYCURSOR;
		{
			return SLASH;
		}
yy36:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '.':
				goto yy101;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy102;

			default:
				goto yy3;
		}

yy37:
		++YYCURSOR;
		{
			return COLON;
		}
yy39:
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '!':
				goto yy104;

			case '<':
				goto yy105;

			default:
				goto yy40;
		}

yy40: {
			return ANGLE_LEFT;
		}
yy41:
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '=':
				goto yy106;

			default:
				goto yy42;
		}

yy42: {
			return EQUAL;
		}
yy43:
		++YYCURSOR;
		{
			return ANGLE_RIGHT;
		}
yy45:
		yych = *++YYCURSOR;

		switch (yych) {
			case '#':
				goto yy107;

			case '%':
				goto yy109;

			case '>':
				goto yy111;

			case '?':
				goto yy113;

			case '^':
				goto yy115;

			default:
				goto yy46;
		}

yy46: {
			return BRACKET_LEFT;
		}
yy47:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy117;

			case '\r':
				goto yy119;

			case ' ':
				goto yy120;

			case '!':
				goto yy122;

			case '"':
				goto yy124;

			case '#':
				goto yy126;

			case '$':
				goto yy128;

			case '%':
				goto yy130;

			case '&':
				goto yy132;

			case '\'':
				goto yy134;

			case '(':
				goto yy136;

			case ')':
				goto yy138;

			case '*':
				goto yy140;

			case '+':
				goto yy142;

			case ',':
				goto yy144;

			case '-':
				goto yy146;

			case '.':
				goto yy148;

			case '/':
				goto yy150;

			case ':':
				goto yy152;

			case ';':
				goto yy154;

			case '<':
				goto yy156;

			case '=':
				goto yy158;

			case '>':
				goto yy160;

			case '?':
				goto yy162;

			case '@':
				goto yy164;

			case '[':
				goto yy166;

			case '\\':
				goto yy168;

			case ']':
				goto yy170;

			case '^':
				goto yy172;

			case '_':
				goto yy174;

			case '`':
				goto yy176;

			case '{':
				goto yy178;

			case '|':
				goto yy180;

			case '}':
				goto yy182;

			case '~':
				goto yy184;

			default:
				goto yy48;
		}

yy48: {
			return TEXT_BACKSLASH;
		}
yy49:
		++YYCURSOR;
		{
			return BRACKET_RIGHT;
		}
yy51:
		++YYCURSOR;
		{
			return SUPERSCRIPT;
		}
yy53:
		++YYCURSOR;
		{
			return UL;
		}
yy55:
		yych = *++YYCURSOR;

		switch (yych) {
			case '`':
				goto yy55;

			default:
				goto yy57;
		}

yy57: {
			return BACKTICK;
		}
yy58:
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '+':
				goto yy186;

			case '-':
				goto yy187;

			case '=':
				goto yy188;

			case '>':
				goto yy190;

			case '{':
				goto yy191;

			case '~':
				goto yy193;

			default:
				goto yy59;
		}

yy59: {
			return TEXT_BRACE_LEFT;
		}
yy60:
		yych = *++YYCURSOR;

		switch (yych) {
			case '|':
				goto yy60;

			default:
				goto yy62;
		}

yy62: {
			return PIPE;
		}
yy63:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy194;

			default:
				goto yy64;
		}

yy64: {
			return TEXT_BRACE_RIGHT;
		}
yy65:
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '>':
				goto yy196;

			case '~':
				goto yy198;

			default:
				goto yy66;
		}

yy66: {
			return SUBSCRIPT;
		}
yy67:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0xA0:
				goto yy199;

			default:
				goto yy3;
		}

yy68:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0xBF:
				goto yy200;

			default:
				goto yy3;
		}

yy69:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x04:
			case 0x05:
			case 0x06:
			case 0x07:
			case 0x08:
			case '\v':
			case '\f':
			case 0x0E:
			case 0x0F:
			case 0x10:
			case 0x11:
			case 0x12:
			case 0x13:
			case 0x14:
			case 0x15:
			case 0x16:
			case 0x17:
			case 0x18:
			case 0x19:
			case 0x1A:
			case 0x1B:
			case 0x1C:
			case 0x1D:
			case 0x1E:
			case 0x1F:
			case '!':
			case '"':
			case '#':
			case '$':
			case '%':
			case '&':
			case '\'':
			case '(':
			case ')':
			case '*':
			case '+':
			case ',':
			case '-':
			case '.':
			case '/':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case ';':
			case '<':
			case '=':
			case '>':
			case '?':
			case '@':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '[':
			case '\\':
			case ']':
			case '^':
			case '_':
			case '`':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
			case '{':
			case '|':
			case '}':
			case '~':
			case 0x7F:
				YYCTXMARKER = YYCURSOR;
				goto yy201;

			case 0xC2:
			case 0xC3:
			case 0xC4:
			case 0xC5:
			case 0xC6:
			case 0xC7:
			case 0xC8:
			case 0xC9:
			case 0xCA:
			case 0xCB:
			case 0xCC:
			case 0xCD:
			case 0xCE:
			case 0xCF:
			case 0xD0:
			case 0xD1:
			case 0xD2:
			case 0xD3:
			case 0xD4:
			case 0xD5:
			case 0xD6:
			case 0xD7:
			case 0xD8:
			case 0xD9:
			case 0xDA:
			case 0xDB:
			case 0xDC:
			case 0xDD:
			case 0xDE:
			case 0xDF:
				YYCTXMARKER = YYCURSOR;
				goto yy203;

			case 0xE0:
				YYCTXMARKER = YYCURSOR;
				goto yy204;

			case 0xE1:
			case 0xE2:
			case 0xE3:
			case 0xE4:
			case 0xE5:
			case 0xE6:
			case 0xE7:
			case 0xE8:
			case 0xE9:
			case 0xEA:
			case 0xEB:
			case 0xEC:
			case 0xED:
			case 0xEE:
			case 0xEF:
				YYCTXMARKER = YYCURSOR;
				goto yy205;

			case 0xF0:
				YYCTXMARKER = YYCURSOR;
				goto yy206;

			case 0xF1:
			case 0xF2:
			case 0xF3:
				YYCTXMARKER = YYCURSOR;
				goto yy207;

			case 0xF4:
				YYCTXMARKER = YYCURSOR;
				goto yy208;

			default:
				goto yy70;
		}

yy70:
		YYCURSOR = YYMARKER;

		switch (yyaccept) {
			case 0:
				goto yy7;

			case 1:
				goto yy3;

			case 2:
				goto yy14;

			case 3:
				goto yy20;

			case 4:
				goto yy30;

			case 5:
				goto yy40;

			case 6:
				goto yy42;

			case 7:
				goto yy59;

			case 8:
				goto yy66;

			case 9:
				goto yy76;

			case 10:
				goto yy84;

			case 11:
				goto yy192;

			case 12:
				goto yy210;

			case 13:
				goto yy218;

			case 14:
				goto yy241;

			case 15:
				goto yy275;

			case 16:
				goto yy281;

			case 17:
				goto yy309;

			case 18:
				goto yy324;

			default:
				goto yy334;
		}

yy71:
		++YYCURSOR;
		YYCURSOR -= 1;
		{
			return NON_INDENT_SPACE;
		}
yy73:
		++YYCURSOR;
		goto yy7;
yy74:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy73;

			default:
				goto yy7;
		}

yy75:
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\n':
				goto yy209;

			case '\r':
				goto yy211;

			case ' ':
				goto yy212;

			case 0xC2:
				goto yy213;

			default:
				goto yy76;
		}

yy76: {
			return NON_INDENT_SPACE;
		}
yy77:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy75;

			default:
				goto yy70;
		}

yy78:
		++YYCURSOR;
		{
			return BRACKET_IMAGE_LEFT;
		}
yy80:
		++YYCURSOR;
yy81:
		YYCURSOR = YYCTXMARKER;
		{
			return HASH1;
		}
yy82:
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				goto yy80;

			case '\t':
			case ' ':
				goto yy82;

			case '\r':
				goto yy85;

			case 0xC2:
				goto yy87;

			default:
				goto yy84;
		}

yy84: {
			return HASH1;
		}
yy85:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy80;

			default:
				goto yy81;
		}

yy86:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy214;

			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy216;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy219;

			case '#':
				goto yy220;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy221;

			default:
				goto yy70;
		}

yy87:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy82;

			default:
				goto yy70;
		}

yy88:
		++YYCURSOR;
		{
			return MATH_DOLLAR_DOUBLE;
		}
yy90:
		yych = *++YYCURSOR;

		switch (yych) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy222;

			case 'X':
			case 'x':
				goto yy224;

			default:
				goto yy70;
		}

yy91:
		yych = *++YYCURSOR;
yy92:

		switch (yych) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy91;

			case ';':
				goto yy225;

			default:
				goto yy70;
		}

yy93:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy227;

			default:
				goto yy92;
		}

yy94:
		++YYCURSOR;
		{
			return QUOTE_RIGHT_ALT;
		}
yy96:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy228;

			default:
				goto yy70;
		}

yy97:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
				goto yy230;

			case '>':
				goto yy232;

			case '}':
				goto yy234;

			default:
				goto yy98;
		}

yy98: {
			return DASH_N;
		}
yy99:
		yych = *++YYCURSOR;

		switch (yych) {
			case '.':
				goto yy236;

			default:
				goto yy70;
		}

yy100:
		yych = *++YYCURSOR;

		switch (yych) {
			case '.':
				goto yy237;

			default:
				goto yy70;
		}

yy101:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy239;

			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy242;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy243;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy244;

			default:
				goto yy70;
		}

yy102:
		yych = *++YYCURSOR;

		switch (yych) {
			case '.':
				goto yy101;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy102;

			default:
				goto yy70;
		}

yy104:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
				goto yy245;

			default:
				goto yy70;
		}

yy105:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy246;

			default:
				goto yy70;
		}

yy106:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy248;

			default:
				goto yy70;
		}

yy107:
		++YYCURSOR;
		{
			return BRACKET_CITATION_LEFT;
		}
yy109:
		++YYCURSOR;
		{
			return BRACKET_VARIABLE_LEFT;
		}
yy111:
		++YYCURSOR;
		{
			return BRACKET_ABBREVIATION_LEFT;
		}
yy113:
		++YYCURSOR;
		{
			return BRACKET_GLOSSARY_LEFT;
		}
yy115:
		++YYCURSOR;
		{
			return BRACKET_FOOTNOTE_LEFT;
		}
yy117:
		++YYCURSOR;
yy118: {
			return TEXT_LINEBREAK;
		}
yy119:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy117;

			default:
				goto yy118;
		}

yy120:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy122:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy124:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy126:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy128:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy130:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy132:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy134:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy136:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy138:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy140:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy142:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy144:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy146:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy148:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy150:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy152:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy154:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy156:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy158:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy160:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy162:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy164:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy166:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy168:
		yych = *++YYCURSOR;

		switch (yych) {
			case '(':
				goto yy250;

			case ')':
				goto yy252;

			case '[':
				goto yy254;

			case ']':
				goto yy256;

			default:
				goto yy169;
		}

yy169: {
			return ESCAPED_CHARACTER;
		}
yy170:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy172:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy174:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy176:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy178:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy180:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy182:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy184:
		++YYCURSOR;
		{
			return ESCAPED_CHARACTER;
		}
yy186:
		yych = *++YYCURSOR;

		switch (yych) {
			case '+':
				goto yy258;

			default:
				goto yy70;
		}

yy187:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
				goto yy260;

			default:
				goto yy70;
		}

yy188:
		yych = *++YYCURSOR;

		switch (yych) {
			case '=':
				goto yy262;

			default:
				goto yy189;
		}

yy189: {
			return RAW_FILTER_LEFT;
		}
yy190:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy264;

			default:
				goto yy70;
		}

yy191:
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 'T':
				goto yy266;

			default:
				goto yy192;
		}

yy192: {
			return BRACE_DOUBLE_LEFT;
		}
yy193:
		yych = *++YYCURSOR;

		switch (yych) {
			case '~':
				goto yy267;

			default:
				goto yy70;
		}

yy194:
		++YYCURSOR;
		{
			return BRACE_DOUBLE_RIGHT;
		}
yy196:
		++YYCURSOR;
		{
			return CRITIC_SUB_DIV;
		}
yy198:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy269;

			default:
				goto yy70;
		}

yy199:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
				goto yy71;

			case ' ':
				goto yy75;

			case 0xC2:
				goto yy77;

			default:
				goto yy70;
		}

yy200:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xBC:
				goto yy271;

			default:
				goto yy70;
		}

yy201:
		++YYCURSOR;
		YYCURSOR = YYCTXMARKER;
		{
			return TEXT_NL_SP;
		}
yy203:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy201;

			default:
				goto yy70;
		}

yy204:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy203;

			default:
				goto yy70;
		}

yy205:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy203;

			default:
				goto yy70;
		}

yy206:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy205;

			default:
				goto yy70;
		}

yy207:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy205;

			default:
				goto yy70;
		}

yy208:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
				goto yy205;

			default:
				goto yy70;
		}

yy209:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case ' ':
				goto yy273;

			default:
				goto yy210;
		}

yy210: {
			return TEXT_LINEBREAK;
		}
yy211:
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\n':
				goto yy209;

			case ' ':
				goto yy273;

			default:
				goto yy210;
		}

yy212:
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\n':
				goto yy209;

			case '\r':
				goto yy211;

			case ' ':
				goto yy274;

			case 0xC2:
				goto yy276;

			default:
				goto yy76;
		}

yy213:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy212;

			default:
				goto yy70;
		}

yy214:
		++YYCURSOR;
yy215:
		YYCURSOR = YYCTXMARKER;
		{
			return HASH2;
		}
yy216:
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				goto yy214;

			case '\t':
			case ' ':
				goto yy216;

			case '\r':
				goto yy219;

			case 0xC2:
				goto yy221;

			default:
				goto yy218;
		}

yy218: {
			return HASH2;
		}
yy219:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy214;

			default:
				goto yy215;
		}

yy220:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy277;

			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy279;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy282;

			case '#':
				goto yy283;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy284;

			default:
				goto yy70;
		}

yy221:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy216;

			default:
				goto yy70;
		}

yy222:
		yych = *++YYCURSOR;

		switch (yych) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy222;

			case ';':
				goto yy285;

			default:
				goto yy70;
		}

yy224:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy70;

			default:
				goto yy288;
		}

yy225:
		++YYCURSOR;
		{
			return HTML_ENTITY;
		}
yy227:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy289;

			default:
				goto yy92;
		}

yy228:
		++YYCURSOR;
		{
			return CRITIC_ADD_CLOSE;
		}
yy230:
		++YYCURSOR;
		{
			return DASH_M;
		}
yy232:
		++YYCURSOR;
		{
			return HTML_COMMENT_STOP;
		}
yy234:
		++YYCURSOR;
		{
			return CRITIC_DEL_CLOSE;
		}
yy236:
		yych = *++YYCURSOR;

		switch (yych) {
			case ' ':
				goto yy290;

			default:
				goto yy70;
		}

yy237:
		++YYCURSOR;
		{
			return ELLIPSIS;
		}
yy239:
		yyaccept = 14;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\t':
			case ' ':
				goto yy239;

			case 0xC2:
				goto yy244;

			default:
				goto yy241;
		}

yy241:
		YYCURSOR = YYCTXMARKER;
		{
			return TEXT_NUMBER_POSS_LIST;
		}
yy242:
		++YYCURSOR;
		goto yy241;
yy243:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy242;

			default:
				goto yy241;
		}

yy244:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy239;

			default:
				goto yy70;
		}

yy245:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
				goto yy291;

			default:
				goto yy70;
		}

yy246:
		++YYCURSOR;
		{
			return CRITIC_COM_CLOSE;
		}
yy248:
		++YYCURSOR;
		{
			return CRITIC_HI_CLOSE;
		}
yy250:
		++YYCURSOR;
		{
			return MATH_PAREN_OPEN;
		}
yy252:
		++YYCURSOR;
		{
			return MATH_PAREN_CLOSE;
		}
yy254:
		++YYCURSOR;
		{
			return MATH_BRACKET_OPEN;
		}
yy256:
		++YYCURSOR;
		{
			return MATH_BRACKET_CLOSE;
		}
yy258:
		++YYCURSOR;
		{
			return CRITIC_ADD_OPEN;
		}
yy260:
		++YYCURSOR;
		{
			return CRITIC_DEL_OPEN;
		}
yy262:
		++YYCURSOR;
		{
			return CRITIC_HI_OPEN;
		}
yy264:
		++YYCURSOR;
		{
			return CRITIC_COM_OPEN;
		}
yy266:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
				goto yy293;

			default:
				goto yy70;
		}

yy267:
		++YYCURSOR;
		{
			return CRITIC_SUB_OPEN;
		}
yy269:
		++YYCURSOR;
		{
			return CRITIC_SUB_CLOSE;
		}
yy271:
		++YYCURSOR;
		{
			return OBJECT_REPLACEMENT_CHARACTER;
		}
yy273:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x04:
			case 0x05:
			case 0x06:
			case 0x07:
			case 0x08:
			case '\v':
			case '\f':
			case 0x0E:
			case 0x0F:
			case 0x10:
			case 0x11:
			case 0x12:
			case 0x13:
			case 0x14:
			case 0x15:
			case 0x16:
			case 0x17:
			case 0x18:
			case 0x19:
			case 0x1A:
			case 0x1B:
			case 0x1C:
			case 0x1D:
			case 0x1E:
			case 0x1F:
			case '!':
			case '"':
			case '#':
			case '$':
			case '%':
			case '&':
			case '\'':
			case '(':
			case ')':
			case '*':
			case '+':
			case ',':
			case '-':
			case '.':
			case '/':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case ';':
			case '<':
			case '=':
			case '>':
			case '?':
			case '@':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '[':
			case '\\':
			case ']':
			case '^':
			case '_':
			case '`':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
			case '{':
			case '|':
			case '}':
			case '~':
			case 0x7F:
				YYCTXMARKER = YYCURSOR;
				goto yy294;

			case 0xC2:
			case 0xC3:
			case 0xC4:
			case 0xC5:
			case 0xC6:
			case 0xC7:
			case 0xC8:
			case 0xC9:
			case 0xCA:
			case 0xCB:
			case 0xCC:
			case 0xCD:
			case 0xCE:
			case 0xCF:
			case 0xD0:
			case 0xD1:
			case 0xD2:
			case 0xD3:
			case 0xD4:
			case 0xD5:
			case 0xD6:
			case 0xD7:
			case 0xD8:
			case 0xD9:
			case 0xDA:
			case 0xDB:
			case 0xDC:
			case 0xDD:
			case 0xDE:
			case 0xDF:
				YYCTXMARKER = YYCURSOR;
				goto yy296;

			case 0xE0:
				YYCTXMARKER = YYCURSOR;
				goto yy297;

			case 0xE1:
			case 0xE2:
			case 0xE3:
			case 0xE4:
			case 0xE5:
			case 0xE6:
			case 0xE7:
			case 0xE8:
			case 0xE9:
			case 0xEA:
			case 0xEB:
			case 0xEC:
			case 0xED:
			case 0xEE:
			case 0xEF:
				YYCTXMARKER = YYCURSOR;
				goto yy298;

			case 0xF0:
				YYCTXMARKER = YYCURSOR;
				goto yy299;

			case 0xF1:
			case 0xF2:
			case 0xF3:
				YYCTXMARKER = YYCURSOR;
				goto yy300;

			case 0xF4:
				YYCTXMARKER = YYCURSOR;
				goto yy301;

			default:
				goto yy70;
		}

yy274:
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '\n':
				goto yy209;

			case '\r':
				goto yy211;

			case ' ':
				goto yy302;

			case 0xC2:
				goto yy304;

			default:
				goto yy275;
		}

yy275: {
			return INDENT_SPACE;
		}
yy276:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy274;

			default:
				goto yy70;
		}

yy277:
		++YYCURSOR;
yy278:
		YYCURSOR = YYCTXMARKER;
		{
			return HASH3;
		}
yy279:
		yyaccept = 16;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				goto yy277;

			case '\t':
			case ' ':
				goto yy279;

			case '\r':
				goto yy282;

			case 0xC2:
				goto yy284;

			default:
				goto yy281;
		}

yy281: {
			return HASH3;
		}
yy282:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy277;

			default:
				goto yy278;
		}

yy283:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy305;

			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy307;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy310;

			case '#':
				goto yy311;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy312;

			default:
				goto yy70;
		}

yy284:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy279;

			default:
				goto yy70;
		}

yy285:
		++YYCURSOR;
		{
			return HTML_ENTITY;
		}
yy287:
		yych = *++YYCURSOR;
yy288:

		switch (yych) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '[':
			case '\\':
			case ']':
			case '^':
			case '_':
			case '`':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
				goto yy287;

			case ';':
				goto yy313;

			default:
				goto yy70;
		}

yy289:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy315;

			default:
				goto yy92;
		}

yy290:
		yych = *++YYCURSOR;

		switch (yych) {
			case '.':
				goto yy317;

			default:
				goto yy70;
		}

yy291:
		++YYCURSOR;
		{
			return HTML_COMMENT_START;
		}
yy293:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'C':
				goto yy319;

			default:
				goto yy70;
		}

yy294:
		++YYCURSOR;
		YYCURSOR = YYCTXMARKER;
		{
			return TEXT_LINEBREAK_SP;
		}
yy296:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy294;

			default:
				goto yy70;
		}

yy297:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy296;

			default:
				goto yy70;
		}

yy298:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy296;

			default:
				goto yy70;
		}

yy299:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy298;

			default:
				goto yy70;
		}

yy300:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
			case 0x90:
			case 0x91:
			case 0x92:
			case 0x93:
			case 0x94:
			case 0x95:
			case 0x96:
			case 0x97:
			case 0x98:
			case 0x99:
			case 0x9A:
			case 0x9B:
			case 0x9C:
			case 0x9D:
			case 0x9E:
			case 0x9F:
			case 0xA0:
			case 0xA1:
			case 0xA2:
			case 0xA3:
			case 0xA4:
			case 0xA5:
			case 0xA6:
			case 0xA7:
			case 0xA8:
			case 0xA9:
			case 0xAA:
			case 0xAB:
			case 0xAC:
			case 0xAD:
			case 0xAE:
			case 0xAF:
			case 0xB0:
			case 0xB1:
			case 0xB2:
			case 0xB3:
			case 0xB4:
			case 0xB5:
			case 0xB6:
			case 0xB7:
			case 0xB8:
			case 0xB9:
			case 0xBA:
			case 0xBB:
			case 0xBC:
			case 0xBD:
			case 0xBE:
			case 0xBF:
				goto yy298;

			default:
				goto yy70;
		}

yy301:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x80:
			case 0x81:
			case 0x82:
			case 0x83:
			case 0x84:
			case 0x85:
			case 0x86:
			case 0x87:
			case 0x88:
			case 0x89:
			case 0x8A:
			case 0x8B:
			case 0x8C:
			case 0x8D:
			case 0x8E:
			case 0x8F:
				goto yy298;

			default:
				goto yy70;
		}

yy302:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy209;

			case '\r':
				goto yy211;

			case ' ':
				goto yy302;

			case 0xC2:
				goto yy304;

			default:
				goto yy70;
		}

yy304:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy302;

			default:
				goto yy70;
		}

yy305:
		++YYCURSOR;
yy306:
		YYCURSOR = YYCTXMARKER;
		{
			return HASH4;
		}
yy307:
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				goto yy305;

			case '\t':
			case ' ':
				goto yy307;

			case '\r':
				goto yy310;

			case 0xC2:
				goto yy312;

			default:
				goto yy309;
		}

yy309: {
			return HASH4;
		}
yy310:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy305;

			default:
				goto yy306;
		}

yy311:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy320;

			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy322;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy325;

			case '#':
				goto yy326;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy327;

			default:
				goto yy70;
		}

yy312:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy307;

			default:
				goto yy70;
		}

yy313:
		++YYCURSOR;
		{
			return HTML_ENTITY;
		}
yy315:
		++YYCURSOR;
		{
			return AMPERSAND_LONG;
		}
yy317:
		++YYCURSOR;
		{
			return ELLIPSIS;
		}
yy319:
		yych = *++YYCURSOR;

		switch (yych) {
			case ':':
				goto yy328;

			case '}':
				goto yy329;

			default:
				goto yy70;
		}

yy320:
		++YYCURSOR;
yy321:
		YYCURSOR = YYCTXMARKER;
		{
			return HASH5;
		}
yy322:
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				goto yy320;

			case '\t':
			case ' ':
				goto yy322;

			case '\r':
				goto yy325;

			case 0xC2:
				goto yy327;

			default:
				goto yy324;
		}

yy324: {
			return HASH5;
		}
yy325:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy320;

			default:
				goto yy321;
		}

yy326:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0x00:
			case '\n':
				YYCTXMARKER = YYCURSOR;
				goto yy330;

			case '\t':
			case ' ':
				YYCTXMARKER = YYCURSOR;
				goto yy332;

			case '\r':
				YYCTXMARKER = YYCURSOR;
				goto yy335;

			case 0xC2:
				YYCTXMARKER = YYCURSOR;
				goto yy336;

			default:
				goto yy70;
		}

yy327:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy322;

			default:
				goto yy70;
		}

yy328:
		yych = *++YYCURSOR;

		switch (yych) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy337;

			default:
				goto yy70;
		}

yy329:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy338;

			default:
				goto yy70;
		}

yy330:
		++YYCURSOR;
yy331:
		YYCURSOR = YYCTXMARKER;
		{
			return HASH6;
		}
yy332:
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case 0x00:
			case '\n':
				goto yy330;

			case '\t':
			case ' ':
				goto yy332;

			case '\r':
				goto yy335;

			case 0xC2:
				goto yy336;

			default:
				goto yy334;
		}

yy334: {
			return HASH6;
		}
yy335:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\n':
				goto yy330;

			default:
				goto yy331;
		}

yy336:
		yych = *++YYCURSOR;

		switch (yych) {
			case 0xA0:
				goto yy332;

			default:
				goto yy70;
		}

yy337:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
				goto yy340;

			case '}':
				goto yy341;

			default:
				goto yy70;
		}

yy338:
		++YYCURSOR;
		{
			return TOC;
		}
yy340:
		yych = *++YYCURSOR;

		switch (yych) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy342;

			default:
				goto yy70;
		}

yy341:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy343;

			default:
				goto yy70;
		}

yy342:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy345;

			default:
				goto yy70;
		}

yy343:
		++YYCURSOR;
		{
			return TOC_SINGLE;
		}
yy345:
		yych = *++YYCURSOR;

		switch (yych) {
			case '}':
				goto yy346;

			default:
				goto yy70;
		}

yy346:
		++YYCURSOR;
		{
			return TOC_RANGE;
		}
	}

}
