/* Generated by re2c 0.15.3 on Fri Mar  8 21:20:09 2019 */
/**

	MultiMarkdown -- Lightweight markup processor to produce HTML, LaTeX, and more.

	@file opml-lexer.c

	@brief Tokenize OPML file for parsing


	@author	Fletcher T. Penney
	@bug

**/

/*

	Copyright © 2016 - 2019 Fletcher T. Penney.


	The `MultiMarkdown 6` project is released under the MIT License..

	GLibFacade.c and GLibFacade.h are from the MultiMarkdown v4 project:

		https://github.com/fletcher/MultiMarkdown-4/

	MMD 4 is released under both the MIT License and GPL.


	CuTest is released under the zlib/libpng license. See CuTest.c for the
	text of the license.

	uthash library:
		Copyright (c) 2005-2016, Troy D. Hanson

		Licensed under Revised BSD license

	miniz library:
		Copyright 2013-2014 RAD Game Tools and Valve Software
		Copyright 2010-2014 Rich Geldreich and Tenacious Software LLC

		Licensed under the MIT license

	argtable3 library:
		Copyright (C) 1998-2001,2003-2011,2013 Stewart Heitmann
		<sheitmann@users.sourceforge.net>
		All rights reserved.

		Licensed under the Revised BSD License


	## The MIT License ##

	Permission is hereby granted, free of charge, to any person obtaining
	a copy of this software and associated documentation files (the
	"Software"), to deal in the Software without restriction, including
	without limitation the rights to use, copy, modify, merge, publish,
	distribute, sublicense, and/or sell copies of the Software, and to
	permit persons to whom the Software is furnished to do so, subject to
	the following conditions:

	The above copyright notice and this permission notice shall be
	included in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
	EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
	CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
	TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


	## Revised BSD License ##

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are
	met:
	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above
	      copyright notice, this list of conditions and the following
	      disclaimer in the documentation and/or other materials provided
	      with the distribution.
	    * Neither the name of the <organization> nor the
	      names of its contributors may be used to endorse or promote
	      products derived from this software without specific prior
	      written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT
	HOLDER> BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES LOSS OF USE, DATA, OR
	PROFITS OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
	LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
	NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

#include <stdlib.h>

#include "opml-lexer.h"
#include "opml-parser.h"


// Basic scanner struct

#define YYCTYPE		unsigned char
#define YYCURSOR	s->cur
#define YYMARKER	s->ptr
#define YYCTXMARKER	s->ctx

int opml_scan(Scanner * s, const char * stop) {

scan:

	if (s->cur >= stop) {
		return 0;
	}

	s->start = s->cur;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy4;

			case '\r':
				goto yy6;

			case '<':
				goto yy7;

			default:
				goto yy2;
		}

yy2:
		++YYCURSOR;
yy3: {
			goto scan;
		}
yy4:
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy190;
yy5: {
			return OPML_WSNL;
		}
yy6:
		yych = *++YYCURSOR;
		goto yy190;
yy7:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '/':
				goto yy8;

			case '?':
				goto yy14;

			case 'B':
			case 'b':
				goto yy11;

			case 'H':
			case 'h':
				goto yy13;

			case 'O':
			case 'o':
				goto yy10;

			case 'T':
			case 't':
				goto yy12;

			default:
				goto yy3;
		}

yy8:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy159;

			case 'H':
			case 'h':
				goto yy157;

			case 'O':
			case 'o':
				goto yy156;

			case 'T':
			case 't':
				goto yy158;

			default:
				goto yy9;
		}

yy9:
		YYCURSOR = YYMARKER;

		switch (yyaccept) {
			case 0:
				goto yy3;

			case 1:
				goto yy56;

			default:
				goto yy58;
		}

yy10:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy40;

			case 'U':
			case 'u':
				goto yy41;

			default:
				goto yy9;
		}

yy11:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy34;

			default:
				goto yy9;
		}

yy12:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy27;

			default:
				goto yy9;
		}

yy13:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy21;

			default:
				goto yy9;
		}

yy14:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'X':
			case 'x':
				goto yy15;

			default:
				goto yy9;
		}

yy15:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy16;

			default:
				goto yy9;
		}

yy16:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy17;

			default:
				goto yy9;
		}

yy17:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy19;

			default:
				goto yy17;
		}

yy19:
		++YYCURSOR;
		{
			return OPML_XML;
		}
yy21:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy22;

			default:
				goto yy9;
		}

yy22:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy23;

			default:
				goto yy9;
		}

yy23:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy25;

			default:
				goto yy23;
		}

yy25:
		++YYCURSOR;
		{
			return OPML_HEAD_OPEN;
		}
yy27:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy28;

			default:
				goto yy9;
		}

yy28:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy29;

			default:
				goto yy9;
		}

yy29:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy30;

			default:
				goto yy9;
		}

yy30:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy32;

			default:
				goto yy30;
		}

yy32:
		++YYCURSOR;
		{
			return OPML_TITLE_OPEN;
		}
yy34:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy35;

			default:
				goto yy9;
		}

yy35:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'Y':
			case 'y':
				goto yy36;

			default:
				goto yy9;
		}

yy36:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy38;

			default:
				goto yy36;
		}

yy38:
		++YYCURSOR;
		{
			return OPML_BODY_OPEN;
		}
yy40:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy151;

			default:
				goto yy9;
		}

yy41:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy42;

			default:
				goto yy9;
		}

yy42:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy43;

			default:
				goto yy9;
		}

yy43:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy44;

			default:
				goto yy9;
		}

yy44:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'N':
			case 'n':
				goto yy45;

			default:
				goto yy9;
		}

yy45:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy46;

			default:
				goto yy9;
		}

yy46:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy46;

			case '\r':
				goto yy48;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			case 'T':
			case 't':
				goto yy50;

			default:
				goto yy51;
		}

yy48:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy46;

			case '\r':
				goto yy48;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			case 'T':
			case 't':
				goto yy50;

			default:
				goto yy51;
		}

yy50:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy59;

			default:
				goto yy52;
		}

yy51:
		++YYCURSOR;
		yych = *YYCURSOR;
yy52:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy53:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '/':
				goto yy53;

			case '>':
				goto yy57;

			default:
				goto yy51;
		}

yy55:
		++YYCURSOR;
yy56: {
			return OPML_OUTLINE_OPEN;
		}
yy57:
		++YYCURSOR;
yy58: {
			return OPML_OUTLINE_SELF_CLOSE;
		}
yy59:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'X':
			case 'x':
				goto yy60;

			default:
				goto yy52;
		}

yy60:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy61;

			default:
				goto yy52;
		}

yy61:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy61;

			case '\r':
				goto yy63;

			case '/':
				goto yy53;

			case '=':
				goto yy65;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy63:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy61;

			case '\r':
				goto yy63;

			case '/':
				goto yy53;

			case '=':
				goto yy65;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy65:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy65;

			case '\r':
				goto yy67;

			case '"':
				goto yy69;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy67:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy65;

			case '\r':
				goto yy67;

			case '"':
				goto yy69;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy69:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy70;

			default:
				goto yy52;
		}

yy70:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy71;

			default:
				goto yy52;
		}

yy71:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy72;

			default:
				goto yy52;
		}

yy72:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy73;

			default:
				goto yy52;
		}

yy73:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy74;

			default:
				goto yy52;
		}

yy74:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy75;

			default:
				goto yy52;
		}

yy75:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy76;

			default:
				goto yy52;
		}

yy76:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy77;

			default:
				goto yy52;
		}

yy77:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy79;

			case 'P':
			case 'p':
				goto yy78;

			default:
				goto yy52;
		}

yy78:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy101;

			default:
				goto yy52;
		}

yy79:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy80;

			default:
				goto yy52;
		}

yy80:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy81;

			default:
				goto yy52;
		}

yy81:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy82;

			default:
				goto yy52;
		}

yy82:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy83;

			default:
				goto yy52;
		}

yy83:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy84;

			default:
				goto yy52;
		}

yy84:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy52;
		}

yy85:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy86;

			default:
				goto yy52;
		}

yy86:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy87;

			default:
				goto yy52;
		}

yy87:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy88;

			default:
				goto yy52;
		}

yy88:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy89;

			default:
				goto yy52;
		}

yy89:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy90;

			default:
				goto yy52;
		}

yy90:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy91;

			default:
				goto yy52;
		}

yy91:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy92;

			default:
				goto yy52;
		}

yy92:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy93;

			default:
				goto yy52;
		}

yy93:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy94;

			default:
				goto yy52;
		}

yy94:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy95;

			default:
				goto yy52;
		}

yy95:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy95;

			case '\r':
				goto yy99;

			case '/':
				goto yy53;

			case '>':
				goto yy97;

			default:
				goto yy51;
		}

yy97:
		++YYCURSOR;
		{
			return OPML_OUTLINE_METADATA;
		}
yy99:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy95;

			case '\r':
				goto yy99;

			case '/':
				goto yy53;

			case '>':
				goto yy97;

			default:
				goto yy51;
		}

yy101:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy102;

			default:
				goto yy52;
		}

yy102:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy103;

			default:
				goto yy52;
		}

yy103:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy104;

			default:
				goto yy52;
		}

yy104:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy105;

			default:
				goto yy52;
		}

yy105:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy106;

			default:
				goto yy52;
		}

yy106:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy107;

			default:
				goto yy52;
		}

yy107:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy108;

			default:
				goto yy52;
		}

yy108:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy109;

			default:
				goto yy52;
		}

yy109:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy110;

			default:
				goto yy52;
		}

yy110:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy111;

			default:
				goto yy52;
		}

yy111:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy112;

			default:
				goto yy52;
		}

yy112:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy113;

			default:
				goto yy52;
		}

yy113:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy114;

			default:
				goto yy52;
		}

yy114:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy115;

			default:
				goto yy52;
		}

yy115:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy116;

			default:
				goto yy52;
		}

yy116:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy116;

			case '\r':
				goto yy118;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			case '_':
				goto yy120;

			default:
				goto yy51;
		}

yy118:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy116;

			case '\r':
				goto yy118;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			case '_':
				goto yy120;

			default:
				goto yy51;
		}

yy120:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'N':
			case 'n':
				goto yy121;

			default:
				goto yy52;
		}

yy121:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy122;

			default:
				goto yy52;
		}

yy122:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy123;

			default:
				goto yy52;
		}

yy123:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy124;

			default:
				goto yy52;
		}

yy124:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy124;

			case '\r':
				goto yy126;

			case '/':
				goto yy53;

			case '=':
				goto yy128;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy126:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy124;

			case '\r':
				goto yy126;

			case '/':
				goto yy53;

			case '=':
				goto yy128;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy128:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy128;

			case '\r':
				goto yy130;

			case '"':
				goto yy132;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy130:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy128;

			case '\r':
				goto yy130;

			case '"':
				goto yy132;

			case '/':
				goto yy53;

			case '>':
				goto yy55;

			default:
				goto yy51;
		}

yy132:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy137;

			case '/':
				goto yy134;

			case '>':
				goto yy136;

			default:
				goto yy132;
		}

yy134:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy137;

			case '/':
				goto yy134;

			case '>':
				goto yy150;

			default:
				goto yy132;
		}

yy136:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy56;
		}

		goto yy146;
yy137:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy137;

			case '\r':
				goto yy141;

			case '/':
				goto yy53;

			case '>':
				goto yy139;

			default:
				goto yy51;
		}

yy139:
		++YYCURSOR;
yy140: {
			return OPML_OUTLINE_PREAMBLE;
		}
yy141:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy137;

			case '\r':
				goto yy141;

			case '/':
				goto yy53;

			case '>':
				goto yy139;

			default:
				goto yy51;
		}

yy143:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy143;

			case '\r':
				goto yy147;

			case '>':
				goto yy149;

			default:
				goto yy9;
		}

yy145:
		++YYCURSOR;
		yych = *YYCURSOR;
yy146:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy143;

			default:
				goto yy145;
		}

yy147:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy143;

			case '\r':
				goto yy147;

			case '>':
				goto yy149;

			default:
				goto yy9;
		}

yy149:
		yych = *++YYCURSOR;
		goto yy140;
yy150:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy58;
		}

		goto yy146;
yy151:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy152;

			default:
				goto yy9;
		}

yy152:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy154;

			default:
				goto yy152;
		}

yy154:
		++YYCURSOR;
		{
			return OPML_OPML_OPEN;
		}
yy156:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy177;

			case 'U':
			case 'u':
				goto yy176;

			default:
				goto yy9;
		}

yy157:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy171;

			default:
				goto yy9;
		}

yy158:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy165;

			default:
				goto yy9;
		}

yy159:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy160;

			default:
				goto yy9;
		}

yy160:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy161;

			default:
				goto yy9;
		}

yy161:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'Y':
			case 'y':
				goto yy162;

			default:
				goto yy9;
		}

yy162:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy163;

			default:
				goto yy9;
		}

yy163:
		++YYCURSOR;
		{
			return OPML_BODY_CLOSE;
		}
yy165:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy166;

			default:
				goto yy9;
		}

yy166:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy167;

			default:
				goto yy9;
		}

yy167:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy168;

			default:
				goto yy9;
		}

yy168:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy169;

			default:
				goto yy9;
		}

yy169:
		++YYCURSOR;
		{
			return OPML_TITLE_CLOSE;
		}
yy171:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy172;

			default:
				goto yy9;
		}

yy172:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy173;

			default:
				goto yy9;
		}

yy173:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy174;

			default:
				goto yy9;
		}

yy174:
		++YYCURSOR;
		{
			return OPML_HEAD_CLOSE;
		}
yy176:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy182;

			default:
				goto yy9;
		}

yy177:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy178;

			default:
				goto yy9;
		}

yy178:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy179;

			default:
				goto yy9;
		}

yy179:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy180;

			default:
				goto yy9;
		}

yy180:
		++YYCURSOR;
		{
			return OPML_OPML_CLOSE;
		}
yy182:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy183;

			default:
				goto yy9;
		}

yy183:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy184;

			default:
				goto yy9;
		}

yy184:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'N':
			case 'n':
				goto yy185;

			default:
				goto yy9;
		}

yy185:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy186;

			default:
				goto yy9;
		}

yy186:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy187;

			default:
				goto yy9;
		}

yy187:
		++YYCURSOR;
		{
			return OPML_OUTLINE_CLOSE;
		}
yy189:
		++YYCURSOR;
		yych = *YYCURSOR;
yy190:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy189;

			case '\r':
				goto yy191;

			default:
				goto yy5;
		}

yy191:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy189;

			case '\r':
				goto yy191;

			default:
				goto yy5;
		}
	}

}
