/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Defines
 */
#define VERSION			"4.3"

#define MAX_STRING      	2048
#define OUTBUF_LENGTH		2048
#define TICKS_SEC       	10000

#define PANEL_HIDDEN		fPanelHidden
#define PANEL_VISIBLE		!fPanelHidden

#define ECHO_OFF        	1
#define ECHO_ON         	2

#define F1			274
#define F2			275
#define F3			276
#define F4			277
#define F5			278
#define F6	 		348
#define F7			349
#define F8			350
#define F9			342
#define F10			343
#define F11			345
#define F12			346
#define BEEP			7
#define BS  			8
#define TAB			9
#define CR 			13
#define ESC			27
#define BACKSPACE		127
#define L_ALT(x)		(124+((x)-'a'))
#define HOME			293
#define INSERT			294
#define DELETE			295
#define END			296
#define PGUP			297
#define PGDWN			298
#define ARROW_U			183
#define ARROW_D			184
#define ARROW_R			185
#define ARROW_L			186
#define ARROW_C			189
#define XARROW_U		171
#define XARROW_D		172
#define XARROW_R		173
#define XARROW_L		174

#define LEFT            	0
#define RIGHT           	1
#define UP			2
#define DOWN			3

#define STDIN			0
#define STDOUT			1
#define STDERR			2

#define ANSI_DEFAULT		0
#define ANSI_BOLD		1
#define ANSI_UNDERLINE		4
#define ANSI_BLINK		5
#define ANSI_REVERSE		7
#define ANSI_BOLD_OFF		22
#define ANSI_UNDERLINE_OFF	24
#define ANSI_BLINK_OFF		25
#define ANSI_REVERSE_OFF	27
#define ANSI_FG_BLACK		30
#define ANSI_FG_RED		31
#define ANSI_FG_GREEN		32
#define ANSI_FG_BROWN		33
#define ANSI_FG_BLUE		34
#define ANSI_FG_MAGENTA		35
#define ANSI_FG_CYAN		36
#define ANSI_FG_WHITE		37
#define ANSI_FG_DEFAULT		39

typedef enum color_types {
    /* 0 is reserved */
    COL_BLACK=1, COL_RED, COL_GREEN, COL_YELLOW, COL_BLUE, COL_MAGENTA,
    COL_CYAN, COL_WHITE, COL_BANNER, COL_MSG, COL_STATUS, COL_SCRL_BANNER,
    COL_DIALOG
} TCOLOR;

typedef enum settings_state {
    STATE_ERRFILE=-3, STATE_ILLPARM, STATE_NOMEM, STATE_READY, 
    STATE_CREATE_1, STATE_CREATE_2, STATE_CREATE_3, STATE_CREATE_4, 
    STATE_TTOGGLE, STATE_TDELETE, STATE_TCREATE_1, STATE_TCREATE_2, 
    STATE_TCREATE_3, STATE_PCREATE_1, STATE_PCREATE_2, STATE_VCREATE_1, 
    STATE_VCREATE_2, STATE_ALIAS_1, STATE_ALIAS_2, STATE_NAMING_1, 
    STATE_NAMING_2, STATE_NDELETE, STATE_PDELETE, STATE_VDELETE, STATE_SAVE, 
    STATE_QUIT, STATE_WRITE, STATE_TABSCREATE, STATE_TABSDELETE
} SSTATE;

#define MAX_LINES		5000	
#define LEN_COL    		len_col
#define LEN_ROW    		len_row
#define LINE_LENGTH     	(LEN_COL-1)
#define SCROLL_SIZE		((LEN_ROW/2)+3)
#define LINE_MAXIM      	512
#define INPUT_MAX      		500
#define ALIAS_MAX       	12
#define TAB_LEN			8
#define CSIPARAMS		16

#define TRG_NORMAL		0
#define TRG_LOGIN		-1
#define TRG_PASSWORD		-2

typedef struct user_set 	USER;
typedef struct trigger  	TRIGGER;
typedef struct scroll   	SCROLL;
typedef struct naming   	NAMING;
typedef struct path     	PATH;
typedef struct tabs     	TABS;
typedef struct var_type 	VAR;

/*
 * Globals
 */
extern  long  total_sent;
extern  long  total_recv;
extern	char  outbuf[];
extern	char  inbuf[];
extern	char  send_buffer[];
extern	char *pOut; 
extern	char *pEndIn;
extern 	char *pCursor;
extern  USER *settings;
extern  int   len_col;
extern  int   len_row;

extern  bool  fEchoIn;
extern  bool  fEchoOut;
extern  bool  fProcessData;
extern  bool  fReconnect;
extern  bool  fPrintTime;
extern  bool  fKeypadWalk;
extern  bool  fStatusReport;
extern  bool  fCharacterMode;
extern  bool  fDown;
extern  bool  fPanelHidden;

extern WINDOW *wMain;
extern WINDOW *wBanner;
extern WINDOW *wInput;
extern WINDOW *wMsg;
extern WINDOW *wStatus;
extern WINDOW *wScroll;
extern WINDOW *wDialog;

extern PANEL  *pMain;
extern PANEL  *pBanner;
extern PANEL  *pInput;
extern PANEL  *pMsg;
extern PANEL  *pStatus;
extern PANEL  *pScroll;
extern PANEL  *pDialog;

/*
 * Global functions
 */
extern bool  write_desc		(int sock);
extern void  read_input   	(void);
extern void  process_buffer	(void);
extern void  create_banner	(void);
extern void  print_cmd_line	(void);
extern void  process_input	(char *input, char *args, bool fReturn);
extern void  move_cursor	(WINDOW *win, int direction, int value);
extern void  backspace		(void);
extern void  show_scroll	(int direction, int scroll_size);
extern void  put_in_scroll	(char *pBegin, char *pEnd, int attr);
extern bool  init_log		(char *filename);
extern bool  close_log		(void);
extern bool  toggle_log		(void);
extern void  write_log		(char *log_start, char *log_end);
extern void  dialog   		(char *string);
extern char *fread_string	(FILE *fp);
extern char *fread_to_eol	(FILE *fp);
extern char *fread_word		(FILE *fp);
extern char *get_arg  		(char *src, char *dst);
extern char *get_acc_arg 	(char *src, char *dst);
extern void  init_settings	(int argc, char **argv);
extern bool  load_settings	(char *file); 
extern void  show_settings	(void); 
extern void  do_help		(void);
extern void  free_tabs		(TABS *tabs);
extern void  free_path		(PATH *path);
extern void  free_trigger	(TRIGGER *trigger);
extern void  free_naming 	(NAMING *name);
extern void  free_var    	(VAR *var);
extern void  draw_border	(WINDOW *win);
extern void  do_status  	(char *string, int st_time);
extern void  trigger_check	(char *pTrg);
extern char *parse_input	(char *src, char *args, char *dest, bool fReturn);
extern void  do_command		(char *cmdline);
extern int   check_iac		(unsigned char *pIac);
extern void  check_tab		(char *buffer, char *end);
extern void  scroll_setup	(int lines);
extern bool  process_alias   	(int alias);
extern bool  process_naming  	(char *buffer);
extern bool  process_path    	(char *buffer);
extern bool  process_if		(char *buffer);
extern void  show_triggers	(void);
extern void  show_aliases	(void);
extern void  show_paths		(void);
extern void  show_tabs		(void);
extern void  show_vars		(void);

extern SSTATE   set_settings	(char *input); 
extern TRIGGER *trig_lookup	(TRIGGER *beg, int level);
extern TRIGGER *new_trigger	(int level, bool last);
extern NAMING  *new_naming	(bool last);
extern PATH    *new_path	(bool last);
extern TABS    *new_tabs	(bool last);
extern VAR     *new_var		(bool last);
extern VAR     *var_lookup	(char *var);

struct user_set {
    TRIGGER 	*trigger_list;
    NAMING	*naming_list;
    PATH  	*path_list;
    TABS  	*tabs_list;
    VAR   	*vars_list;
    char    	*site;
    char    	*alias[ALIAS_MAX];
    int      	 port;
    int      	 sock;
    SSTATE     	 state;
};

struct trigger {
    TRIGGER 	*next;
    char	*in;
    char 	*out;
    char        *inp;
    char 	 arg[LINE_MAXIM];
    char 	*pArg;
    int	     	 level;
    bool     	 enabled;
};

struct naming {
    NAMING	*next;
    char 	*name;
    char	*string;
};

struct path {
    PATH	*next;
    char 	*name;
    char	*path;
};

struct tabs {
    TABS 	*next;
    char 	*name;
};

struct var_type {
    VAR         *next;
    char        *name;
    char        *value;         /* value is a string also */
};

struct scroll {
    char   	*data;
    int   	*attr;
    int          len;
};

struct cmd_table_type {
    char    *cmd;
    void   (*function)(int index, char *args);
    char    *help;
};


