# RPM Spec file for mod_ca

Name:      mod_ca
Version:   0.2.2
Release:   1%{?dist}
Summary:   Redwax Apache backend modules
License:   ASL 2.0
Group:     System Environment/Daemons
Source:    https://archive.redwax.eu/dist/rs/%{name}/%{name}-%{version}/%{name}-%{version}.tar.bz2
Url:       https://redwax.eu/rs/
BuildRequires: gcc, pkgconfig(apr-1), pkgconfig(apr-util-1), pkgconfig(openssl)
%if 0%{?is_opensuse}
BuildRequires: apache2-devel
Requires: apache2
%else
%if 0%{?mgaversion}
BuildRequires: apache-devel
Requires: apache
%else
BuildRequires: httpd-devel
Requires: httpd
%endif
%endif

%if 0%{?is_opensuse}
%define moduledir %{_libdir}/apache2
%define includedir %{_includedir}/apache2
%else
%define moduledir %{_libdir}/httpd/modules
%define includedir %{_includedir}/httpd
%endif

%description
The Apache mod_ca module supplies a basic provider implementing a simple
certificate authority.

%package devel
Group: Development/Libraries
Summary: Development tools for the mod_ca provider.
%if 0%{?is_opensuse}
Requires: apache2-devel
%else
%if 0%{?mgaversion}
Requires: apache-devel
%else
Requires: httpd-devel
%endif
%endif

%description devel
Header file for the mod_ca provider implementing a simple certificate
authority.

%prep
%setup -q
%build
%configure
%make_build

%install
%make_install

%files
%{moduledir}/mod_ca.so
%{moduledir}/mod_ca_crl.so
%{moduledir}/mod_ca_ldap.so
%{moduledir}/mod_ca_simple.so
%{moduledir}/mod_ca_disk.so
%{moduledir}/mod_ca_engine.so

%files devel
%{includedir}/mod_ca.h


