/* Licensed to Stichting The Commons Conservancy (TCC) under one or more
 * contributor license agreements.  See the AUTHORS file distributed with
 * this work for additional information regarding copyright ownership.
 * TCC licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * CA module to provide CA hooks for the certificate authority.
 *
 *  Author: Graham Leggett
 */
#include "httpd.h"
#include "http_config.h"

#include "mod_ca.h"

module AP_MODULE_DECLARE_DATA ca_module;

APR_HOOK_STRUCT(
        APR_HOOK_LINK(ca_reqauthz)
        APR_HOOK_LINK(ca_certstore)
        APR_HOOK_LINK(ca_sign)
        APR_HOOK_LINK(ca_getca)
        APR_HOOK_LINK(ca_getnextca)
        APR_HOOK_LINK(ca_getchain)
        APR_HOOK_LINK(ca_getcrl)
        APR_HOOK_LINK(ca_getcertstatus)
        APR_HOOK_LINK(ca_getcert)
        APR_HOOK_LINK(ca_makeserial)
        APR_HOOK_LINK(ca_makekey)
        APR_HOOK_LINK(ca_gettime))

APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_reqauthz,
        (request_rec *r, apr_hash_t *params, const unsigned char *buffer, apr_size_t len),
        (r, params, buffer, len), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_sign,
        (request_rec *r, apr_hash_t *params, const unsigned char **buffer, apr_size_t *len),
        (r, params, buffer, len), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_certstore,
        (request_rec *r, apr_hash_t *params, const unsigned char *buffer, apr_size_t len),
        (r, params, buffer, len), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_getca,
        (request_rec *r, const unsigned char **cacert, apr_size_t *len, apr_time_t *validity),
        (r, cacert, len, validity), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_getnextca,
        (request_rec *r, const unsigned char **cacert, apr_size_t *len, apr_time_t *validity),
        (r, cacert, len, validity), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_getchain,
        (request_rec *r, const unsigned char **chain, apr_size_t *len, apr_time_t *validity),
        (r, chain, len, validity), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_getcrl,
        (request_rec *r, const unsigned char **crl, apr_size_t *len, apr_time_t *validity),
        (r, crl, len, validity), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_ALL(ap, CA, int, ca_getcertstatus,
        (request_rec *r, apr_hash_t *certstatus, apr_time_t *validity),
        (r, certstatus, validity), OK, DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_getcert,
        (request_rec *r, apr_hash_t *search, const unsigned char **cert, apr_size_t *len),
        (r, search, cert, len), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_makeserial,
        (request_rec *r, apr_hash_t *params, const unsigned char **serial, apr_size_t *len),
        (r, params, serial, len), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_makekey,
        (request_rec *r, apr_hash_t *params, const unsigned char **key, apr_size_t *len),
        (r, params, key, len), DECLINED);
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(ap, CA, int, ca_gettime,
        (request_rec *r, apr_time_t *time, apr_interval_time_t *as, apr_interval_time_t *ams, apr_interval_time_t *amicro),
        (r, time, as, ams, amicro), DECLINED);

static const command_rec ca_cmds[] =
{
{ NULL } };

static void register_hooks(apr_pool_t *p)
{
}

module AP_MODULE_DECLARE_DATA ca_module =
{ STANDARD20_MODULE_STUFF, NULL, /* dir config creater */
NULL, /* dir merger --- default is to override */
NULL, /* server config */
NULL, /* merge server config */
ca_cmds, /* command apr_table_t */
register_hooks /* register hooks */
};
