/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.midp.examples.simpledemo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.microemu.midp.examples.simpledemo.BaseExamplesCanvas;
import org.microemu.midp.examples.simpledemo.SimpleDemoMIDlet;
import org.microemu.midp.examples.simpledemo.Utils;

public class KeyCanvasPanel
extends BaseExamplesCanvas {
    static Hashtable actionNames = new Hashtable();
    static Hashtable shortNames = new Hashtable();
    int lastKeyCode = 0;
    int sameKeyCount = 0;
    int lastKeyRepeatedKeyCode = 0;
    int keyRepeatedCount = 0;
    long keyRepeatedTime = 0L;
    long keyRepeatedInitialDellay = 0L;
    String lastKeyEvent = null;
    Vector keysHistory = new Vector();
    Vector keysPressed = new Vector();
    boolean debug = true;

    public KeyCanvasPanel() {
        super("KeyCanvas");
    }

    protected void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setGrayScale(255);
        g.fillRect(0, 0, width, height);
        g.setColor(0);
        int line = 0;
        this.writeln(g, line++, "Key Canvas - Press any key!");
        if (this.fullScreenMode) {
            this.writeln(g, line++, "Back - same key 3 times");
        }
        if (this.sameKeyCount > 0) {
            this.writeln(g, line++, "KeyCode: " + this.lastKeyCode);
            this.writeln(g, line++, "As char: " + (char)this.lastKeyCode);
            this.writeln(g, line++, "GameAction: " + KeyCanvasPanel.gameActionName(this.getGameAction(this.lastKeyCode)));
            this.writeln(g, line++, "KeyName: " + this.getKeyName(this.lastKeyCode));
            StringBuffer pressed = new StringBuffer();
            Enumeration en = this.keysPressed.elements();
            while (en.hasMoreElements()) {
                pressed.append(en.nextElement());
            }
            this.writeln(g, line++, "Pressed: " + pressed.toString());
            this.writeln(g, line++, "Event: " + this.lastKeyEvent);
        }
        if (this.keysHistory.size() > 0) {
            this.writeln(g, line++, "- history -");
            for (int i = this.keysHistory.size() - 1; i >= 0 && this.writeln(g, line++, (String)this.keysHistory.elementAt(i)) <= height; --i) {
            }
        }
    }

    public String getKeyName(int keyCode) {
        try {
            return super.getKeyName(keyCode);
        }
        catch (IllegalArgumentException e) {
            return "not valid key code";
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.lastKeyCode == keyCode) {
            ++this.sameKeyCount;
            if (this.fullScreenMode && this.sameKeyCount >= 3) {
                this.setFullScreenMode(false);
                SimpleDemoMIDlet.showMenu();
            }
        } else {
            this.sameKeyCount = 1;
            this.logEvent(String.valueOf(keyCode) + " " + this.getKeyName(keyCode));
        }
        this.keyRepeatedTime = System.currentTimeMillis();
        this.lastKeyCode = keyCode;
        this.lastKeyEvent = "keyPressed";
        this.keysPressed.addElement(this.shortName(keyCode));
        if (this.debug) {
            System.out.println(this.lastKeyEvent + " " + keyCode);
        }
        this.repaint();
    }

    public void keyReleased(int keyCode) {
        this.lastKeyEvent = "keyReleased";
        this.lastKeyCode = keyCode;
        if (this.debug) {
            System.out.println(this.lastKeyEvent + " " + keyCode);
        }
        this.keysPressed.removeElement(this.shortName(keyCode));
        this.keyRepeatedCount = 1;
        this.keyRepeatedTime = 0L;
        this.keyRepeatedInitialDellay = 0L;
        this.repaint();
    }

    public void keyRepeated(int keyCode) {
        long keyRepeatedDellay = 0L;
        this.keyRepeatedCount = this.lastKeyRepeatedKeyCode == keyCode ? ++this.keyRepeatedCount : 1;
        keyRepeatedDellay = System.currentTimeMillis() - this.keyRepeatedTime;
        if (this.keyRepeatedInitialDellay == 0L) {
            this.keyRepeatedInitialDellay = keyRepeatedDellay;
        }
        this.keyRepeatedTime = System.currentTimeMillis();
        this.lastKeyEvent = "keyRepeated (" + Utils.d00(this.keyRepeatedCount) + ")";
        if (keyRepeatedDellay != 0L) {
            this.lastKeyEvent = this.lastKeyEvent + " " + this.keyRepeatedInitialDellay + "/" + keyRepeatedDellay + " ms";
        }
        this.lastKeyCode = keyCode;
        this.lastKeyRepeatedKeyCode = keyCode;
        if (this.debug) {
            System.out.println(this.lastKeyEvent + " " + keyCode);
        }
        this.repaint();
    }

    private void logEvent(String e) {
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.when());
        sb.append("   ").append(e);
        this.keysHistory.addElement(sb.toString());
    }

    static String gameActionName(int gameAction) {
        return (String)actionNames.get(new Integer(gameAction));
    }

    String shortName(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        String n = (String)shortNames.get(new Integer(gameAction));
        if (n != null) {
            return n;
        }
        return "" + (char)keyCode;
    }

    private static void actionName(int gameAction, String name, String shortName) {
        actionNames.put(new Integer(gameAction), name);
        shortNames.put(new Integer(gameAction), shortName);
    }

    private static void initActionNames() {
        KeyCanvasPanel.actionName(1, "UP", "u");
        KeyCanvasPanel.actionName(6, "DOWN", "d");
        KeyCanvasPanel.actionName(2, "LEFT", "l");
        KeyCanvasPanel.actionName(5, "RIGHT", "r");
        KeyCanvasPanel.actionName(8, "FIRE", "f");
        KeyCanvasPanel.actionName(9, "GAME_A", "a");
        KeyCanvasPanel.actionName(10, "GAME_B", "b");
        KeyCanvasPanel.actionName(11, "GAME_C", "c");
        KeyCanvasPanel.actionName(12, "GAME_D", "d");
        KeyCanvasPanel.actionName(48, "KEY_NUM0", "0");
        KeyCanvasPanel.actionName(49, "KEY_NUM1", "1");
        KeyCanvasPanel.actionName(50, "KEY_NUM2", "2");
        KeyCanvasPanel.actionName(51, "KEY_NUM3", "3");
        KeyCanvasPanel.actionName(52, "KEY_NUM4", "4");
        KeyCanvasPanel.actionName(53, "KEY_NUM5", "5");
        KeyCanvasPanel.actionName(54, "KEY_NUM6", "6");
        KeyCanvasPanel.actionName(55, "KEY_NUM7", "7");
        KeyCanvasPanel.actionName(56, "KEY_NUM8", "8");
        KeyCanvasPanel.actionName(57, "KEY_NUM9", "9");
        KeyCanvasPanel.actionName(42, "KEY_STAR", "*");
        KeyCanvasPanel.actionName(35, "KEY_POUND", "#");
    }

    static {
        KeyCanvasPanel.initActionNames();
    }
}

