/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQAbout.h"

#include <QDialogButtonBox>
#include <QLabel>
#include <QTabWidget>
#include <QTextStream>
#include <QVBoxLayout>
#include <QFile>

#include "MvVersionInfo.h"
#include "MvPath.hpp"

MvQAbout::MvQAbout(QString title, QString description, Versions version,
	           QMap<Version,QString> text) : QDialog(0)
{
	setWindowTitle(tr("About ") + title);
	
	QString versionTxt;
	QTextStream str(&versionTxt) ;

	QString mvVersionTxt;
	QTextStream mvStr(&mvVersionTxt) ;
	
	if(version.testFlag(GribApiVersion))
	{
		str  << "<p><b>GRIB_API version:</b> ";

		if(text.contains(GribApiVersion))
		{
			str << text[GribApiVersion];
		}
		else
		{
			MvGribApiVersionInfo mvInfo;
			/*long gribapiVersionNumber =  grib.gribapiVersionNumber();
    			long gribapiMajorVersion  = gribapiVersionNumber / 10000;
    			long gribapiMinorVersion  = (gribapiVersionNumber - (gribapiMajorVersion * 10000)) / 100;
    			long gribapiRevisVersion  = gribapiVersionNumber % 100;*/
		
			str  << mvInfo.majorVersion() << "." << mvInfo.minorVersion() <<
                            "." << mvInfo.revision() << " (" << mvInfo.version() << ")";
		}
	}

	if(version.testFlag(MetviewVersion))
	{
		str << "<p><b>Metview version:</b> ";

	 	if(text.contains(MetviewVersion))
		{
			str  << text[MetviewVersion];
			mvStr << text[MetviewVersion];
			
		}
		else
		{
			MvVersionInfo mvInfo;  // the constructor populates the class with information
			
			str << mvInfo.majorVersion() << "." << mvInfo.minorVersion() <<
                                              "." << mvInfo.revision() << " (" << mvInfo.version() << ", " <<
                                              (sizeof (int *) * 8) << "-bit)";   // could be any pointer, just to get the size
                                              
                                              
                        mvStr  << mvInfo.majorVersion() << "." << mvInfo.minorVersion() <<
                                              "." << mvInfo.revision() << " (" << mvInfo.version() << ", " <<
                                              (sizeof (int *) * 8) << "-bit)";  
					      

			const char *dev  = getenv("METVIEW_VERSION");  // only add dir if using dev version
			if (dev && (!strcmp(dev, "dev")))
				str << "<p><b>Metview dir:</b> " << QString(mvInfo.installDir().c_str());
		} 
	
	}

	if(version.testFlag(MagicsVersion))
	{
		if(text.contains(MagicsVersion))
		{
			str << "<p><b>Magics version:</b> " << text[MagicsVersion];
		}
	}
	
	if(version.testFlag(OdbApiVersion))
	{
		if(text.contains(OdbApiVersion))
		{
			str << "<p><b>ODB_API version:</b> " << text[OdbApiVersion];
		}
	}

	if(version.testFlag(NetcdfVersion))
	{
		str  << "<p><b>NetCDF version:</b> ";
		if(text.contains(NetcdfVersion))
		{
			str << text[NetcdfVersion];
		}
		else
		{
			MvNetcdfVersionInfo mvInfo; // the constructor populates the class
			str  << mvInfo.majorVersion() << "." << mvInfo.minorVersion() <<
                            "." << mvInfo.revision() << " (" << mvInfo.version() << ")";
		}
	}
	
	const char *qtv=qVersion();
    	if(qtv)
    	{
             str << "<p><b>Qt version: </b>" + QString(qtv);
   	}
	
	QVBoxLayout *vb=new QVBoxLayout(this);
	setLayout(vb);
	
	//Logo + text
	
	QLabel *logo=new QLabel(this);	
	logo->setFrameStyle(QFrame::StyledPanel | QFrame::Plain);
	logo->setAutoFillBackground(true);
	QPalette pal=logo->palette();	
	pal.setBrush(QPalette::Window,Qt::white);
	logo->setPalette(pal);	
		
	QString logoTxt;
	logoTxt="<table><tr>";
	logoTxt+="<td><img src=\":/window/metview_logo\"></td>";
	logoTxt+="<td align=\"left\">";
	logoTxt+="<h3>&nbsp;&nbsp;" + title + "</h3>";
	if(!description.isEmpty())
	{
		logoTxt+="<p>" + description + "</p>";
	}	
	if(!mvVersionTxt.isEmpty())
	{
		logoTxt+="<p>&nbsp;&nbsp;Metview version: " + mvVersionTxt + "</p>";	
	}
	logoTxt+="</td></tr></table>";
	logo->setText(logoTxt);
	
	vb->addWidget(logo);

	//tab
	QTabWidget *tw=new QTabWidget(this);
	
	//Version
	QLabel *versionLabel=new QLabel(this);
	versionLabel->setIndent(10);
	versionLabel->setText(versionTxt);
	tw->addTab(versionLabel,tr("Version"));
	
	//Licence
	QLabel *licenceLabel=new QLabel(this);
	//licenceLabel->setAlignment(Qt::AlignJustify); 
	licenceLabel->setWordWrap(false);
	licenceLabel->setIndent(10);

	QString licenceTxt;
	string licenceTextPath = MakeSystemEtcPath("licence_for_about_box.txt");
	QFile file(licenceTextPath.c_str());
	if (file.open(QIODevice::ReadOnly))
	{
		QTextStream ts(&file);
		licenceTxt = ts.readAll();
	}
	
	licenceLabel->setText(licenceTxt);
	tw->addTab(licenceLabel,tr("Licence"));
	
	vb->addWidget(tw);
	
	// Buttonbox
	QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok,Qt::Horizontal,this);
	vb->addWidget(buttonBox);

     	connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));

	
}
