/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQWcsClientEditor_H
#define MvQWcsClientEditor_H

#include <QGridLayout>
#include <QLineEdit>
#include <QComboBox>
#include <QMainWindow>
#include <QStringList>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"
#include "MvQWcsClient.h"

class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QListView;
class QListWidgetItem;
class QListWidget;
class QProgressBar;
class QPushButton;
class QSplitter;
class QStringListModel;
class QTabWidget;
class QTextBrowser;
class QToolButton;
class QTreeView;
class QVBoxLayout;

class MvQHighlighter;
class MvQLogBrowser;
class MvQOgcTreeModel;
class MvQTextEditSearchLine;
class MvQWcsUiClient;
class MvQWmsGetCapHighlighter;


class MvQWcsClientEditor : public MvQMainWindow
{
	Q_OBJECT

public:
	MvQWcsClientEditor(MvQWcsUiClient*,QWidget *w=0);
	~MvQWcsClientEditor();

public slots:
	void slotClientModeChanged(QString);
	void slotSaveInfo();
	void slotStatusMessage(QString);
	void slotSelectUrl(const QString&);
	void slotCheckUrlComboContents();
	void slotSelectVersion(const QString&);
	void slotRunGetCapabilities();	
	void slotGetCapabilityLoaded();
	void slotSelectLayer(const QModelIndex&);
	void slotSelectStyle(int);
	void slotSelectCrs(QString);
	void slotDimensionChanged(MvQOgcDimension*,QString);
	void slotExtraGetCapChanged(QString);
	void slotExtraGetCovChanged(QString);
	void slotAddItemToUrlCombo(QString);
	void slotPreview();
	void slotPreviewLoaded(QString);
	void slotLegendLoaded(QString);
	void slotSetGetCovInfo(QString);
	void slotUpdateLogOutput();
	void slotClearLog(bool);
	void slotGetCovChanged();
	void slotRunDescribeCov();	
	void slotDescribeCovLoaded();
	void slotUpdateServiceInfo(); 

signals:
	void clientModeChanged();
	void clientModeIsAboutToChange();

	
protected:
	void setupControlsActions();
	void setupViewActions();
	void setupLayerPanel(QVBoxLayout *);
	void setupLayerInfoTab();
	void setupLayerCombo();
	void setupCovOfferList();
	void setupLayerList();
	void setupDimension();

	void initClientMode();
	void initVersionCombo();
	void initExtraParEdit();
	void initFormatCombo();
	void initStyleCombo();
	void initCrsCombo();

	void clearServerDependentData();
	void clearLayerDependentData();
	void clearDimension();

	void loadStarted();
	void loadFinished();
	void writeSettings();
	void readSettings();	

	MvQWcsUiClient* client_;

	QVBoxLayout* 	mainLayout_;
	QSplitter*   	mainSplitter_;
	QSplitter*   	requestSplitter_;

	QCheckBox*	openCb_;

	QLabel* 	loadLabel_;
	QLabel*		statusMessageLabel_;
	QList<QLabel*>  toolBarLabel_;

	MvQMainWindow::MenuItemMap 	menuItems_;
	QAction* 	actionCapability_;
	QAction*	actionStopLoad_;
	QAction* 	actionLog_;
	QComboBox* 	urlCombo_;
	QComboBox* 	versionCombo_;
	QComboBox* 	clientModeCombo_;
	QMap<QString,MvQWcsUiClient::ClientMode> clientModeMap_;

	QComboBox* formatCombo_;
	QLineEdit *extraGetCapEdit_;
	QLineEdit *extraGetCovEdit_;
	
	QListView*	  covOfferList_;
	QStringListModel* covOfferModel_;

	QTabWidget*	layerTab_;
	QWidget* 	layerPanel_;
	QGridLayout*	layerGrid_;
	QHBoxLayout*	layerLayout_;
	QTreeView*	layerTree_;
	MvQOgcTreeModel* layerModel_;
	QComboBox* 	crsCombo_;
	QComboBox* 	styleCombo_;
	QPushButton*	describeCovPb_;
	int 		dimensionNum_;
	int 		layerParamRowNum_;
	//QMap<QString,MvQWmsDimensionGuiItem*> dim_;

	QTabWidget* 	layerInfoTab_;
	QTextBrowser* 	getCapInfo_;
	QTextBrowser* 	describeCovInfo_;
	QTextBrowser* 	serviceInfo_;
	QTextBrowser* 	layerPreview_;
	QTextBrowser* 	getCovInfoMv_;
	MvQHighlighter*	highlighterMv_;


	MvQLogBrowser* 	logBrowser_;
	QWidget*	logPanel_;

	MvQTextEditSearchLine* getCapSearch_;
	MvQWmsGetCapHighlighter* highlighterGetCap_;
	
	MvQTextEditSearchLine* describeCovSearch_;
	MvQWmsGetCapHighlighter* highlighterDescribeCov_;

	QProgressBar*	loadProgress_;
};


#endif

