%---------------------------------------------------------------------------%
% vim: ft=mercury ts=4 sw=4 et
%---------------------------------------------------------------------------%
%
% A test of uint64 to decimal string conversion.
%
%---------------------------------------------------------------------------%

:- module uint64_to_string.
:- interface.

:- import_module io.

:- pred main(io::di, io::uo) is det.

%---------------------------------------------------------------------------%
%---------------------------------------------------------------------------%

:- implementation.

:- import_module int64.
:- import_module list.
:- import_module string.
:- import_module uint64.

%---------------------------------------------------------------------------%

main(!IO) :-
    P = (pred(U::in, !.IO::di, !:IO::uo) is det :-
        io.print_line(uint64_to_string(U), !IO)
    ),
    list.foldl(P, test_numbers, !IO).

:- func test_numbers = list(uint64).

test_numbers = [
    0u64,
    1u64,
    2u64,
    4u64,
    7u64,
    8u64,
    9u64,
    10u64,
    11u64,
    15u64,
    16u64,
    31u64,
    32u64,
    64u64,
    99u64,
    100u64,
    101u64,
    126u64, % max_int8 - 1
    127u64, % max_int8
    128u64, % max_int8 + 1
    254u64, % max_uint8 - 1
    255u64, % max_uint8
    256u64, % max_uint8 + 1
    999u64,
    1000u64,
    1001u64,
    1023u64,
    1024u64,
    9999u64,
    10000u64,
    10001u64,
    32766u64, % max_int16 - 1
    32767u64, % max_int16
    32768u64, % max_int16 + 1
    65534u64, % max_uint16 - 1
    65535u64, % max_uint16
    65536u64, % max_uint16 + 1
    99999u64,
    100000u64,
    100001u64,
    999999u64,
    1000000u64,
    1000001u64,
    9999999u64,
    10000000u64,
    10000001u64,
    99999999u64,
    100000000u64,
    100000001u64,
    999999999u64,
    1000000000u64,
    1000000001u64,
    2147483646u64,  % max_int32 - 1
    2147483647u64,  % max_int32
    2147483648u64,  % max_int32 + 1
    4294967294u64,  % max_uint32 - 1
    4294967295u64,  % max_uint32
    4294967296u64,  % max_uint32 + 1
    9999999999u64,
    10000000000u64,
    10000000001u64,
    99999999999u64,
    100000000000u64,
    100000000001u64,
    999999999999u64,
    1000000000000u64,
    1000000000001u64,
    9999999999999u64,
    10000000000000u64,
    10000000000001u64,
    99999999999999u64,
    100000000000000u64,
    100000000000001u64,
    999999999999999u64,
    1000000000000000u64,
    1000000000000001u64,
    9999999999999999u64,
    10000000000000000u64,
    10000000000000001u64,
    99999999999999999u64,
    100000000000000000u64,
    100000000000000001u64,
    999999999999999999u64,
    1000000000000000000u64,
    1000000000000000001u64,
    9223372036854775806u64, % max_int64 - 1
    9223372036854775807u64, % max_int64
    9223372036854775808u64, % max_int64 + 1
    9999999999999999999u64,
    10000000000000000000u64,
    10000000000000000001u64,
    18446744073709551614u64, % max_uint64 - 1
    18446744073709551615u64  % max_uint64
].

%---------------------------------------------------------------------------%
:- end_module uint64_to_string.
%---------------------------------------------------------------------------%
