/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.util;

import edu.sdsc.nbcr.opal.state.HibernateUtil;
import edu.sdsc.nbcr.opal.state.ServiceStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class Undeploy {
    private static Logger logger = Logger.getLogger((String)Undeploy.class.getName());

    public static void main(String[] args) throws Exception {
        String serviceName = System.getProperty("serviceName");
        if (serviceName == null) {
            logger.error((Object)"System property serviceName not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property serviceName set to: " + serviceName));
        }
        String version = System.getProperty("appVersion");
        if (version.equals("")) {
            version = null;
        }
        if (version == null) {
            logger.info((Object)"Version number not supplied by user");
        } else {
            logger.info((Object)("Property appVersion set to: " + version));
        }
        String wsddTemplate = System.getProperty("wsddTemplate");
        if (wsddTemplate == null) {
            logger.error((Object)"System property wsddTemplate not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property wsddTemplate set to: " + wsddTemplate));
        }
        String wsddFinal = System.getProperty("wsddFinal");
        if (wsddFinal == null) {
            logger.error((Object)"System property wsddFinal not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property wsddFinal set to: " + wsddFinal));
        }
        File f = new File(wsddTemplate);
        if (!f.exists()) {
            logger.error((Object)("WSDD template file " + wsddTemplate + " does not exist"));
            System.exit(1);
        }
        if (version != null) {
            serviceName = serviceName + "_" + version;
        }
        logger.info((Object)("Service name used for undeployment: " + serviceName));
        byte[] data = new byte[(int)f.length()];
        FileInputStream fIn = new FileInputStream(f);
        fIn.read(data);
        fIn.close();
        String templateData = new String(data);
        String finalData = templateData.replaceAll("@SERVICE_NAME@", serviceName);
        FileOutputStream fOut = new FileOutputStream(wsddFinal);
        fOut.write(finalData.getBytes());
        fOut.close();
        logger.info((Object)"Updating service status in database to INACTIVE");
        ServiceStatus serviceStatus = new ServiceStatus();
        serviceStatus.setServiceName(serviceName);
        serviceStatus.setStatus("INACTIVE");
        HibernateUtil.saveServiceStatus(serviceStatus);
    }
}

