/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.util;

import edu.sdsc.nbcr.opal.FaultType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Extract {
    private static Logger logger = Logger.getLogger((String)Extract.class.getName());
    protected ZipFile zippy;
    protected byte[] b = new byte[8092];
    protected SortedSet dirsMade = new TreeSet();
    protected boolean warnedMkDir = false;

    public void extract(String targetDir, String fileName) throws FaultType {
        logger.debug((Object)"called");
        if (fileName.endsWith(".zip") || fileName.endsWith(".jar")) {
            this.unZipFile(targetDir, fileName);
        } else if (fileName.endsWith(".tar") || fileName.endsWith("tar.gz")) {
            this.unTarFile(targetDir, fileName);
        } else if (fileName.endsWith(".gz")) {
            this.gunZipFile(targetDir, fileName);
        } else {
            String msg = "File " + fileName + " doesn't end with .zip, .jar, .gz or .tar(.gz) - " + "can't extract";
            logger.warn((Object)msg);
            return;
        }
    }

    protected void gunZipFile(String targetDir, String fileName) throws FaultType {
        logger.debug((Object)"called");
        try {
            int len;
            String outputFileName = fileName.substring(0, fileName.indexOf(".gz"));
            FileOutputStream out = new FileOutputStream(new File(outputFileName));
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(fileName));
            int MAX_BUFFER_SIZE = 1024;
            byte[] buf = new byte[MAX_BUFFER_SIZE];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.flush();
            out.close();
            in.close();
        }
        catch (IOException ioe) {
            String msg = "Error while extracting gzip file: " + ioe.getMessage();
            logger.error((Object)msg);
            throw new FaultType(msg);
        }
    }

    protected void unZipFile(String targetDir, String fileName) throws FaultType {
        logger.debug((Object)"called");
        try {
            this.zippy = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> all = this.zippy.entries();
            while (all.hasMoreElements()) {
                this.unZipFileEntry(targetDir, all.nextElement());
            }
        }
        catch (IOException err) {
            logger.error((Object)err);
            String msg = "IO Error while unzipping input file: " + err.getMessage();
            throw new FaultType(msg);
        }
    }

    protected void unZipFileEntry(String targetDir, ZipEntry e) throws IOException {
        int len;
        String zipName = e.getName();
        if (zipName.startsWith("/")) {
            if (!this.warnedMkDir) {
                logger.debug((Object)"Ignoring absolute paths");
            }
            this.warnedMkDir = true;
            zipName = zipName.substring(1);
        }
        if (zipName.endsWith("/")) {
            return;
        }
        this.createDir(targetDir, zipName);
        String fileName = targetDir + File.separator + zipName;
        logger.debug((Object)("Creating " + fileName));
        FileOutputStream os = new FileOutputStream(fileName);
        InputStream is = this.zippy.getInputStream(e);
        int MAX_BUFFER_SIZE = 1024;
        byte[] buf = new byte[MAX_BUFFER_SIZE];
        while ((len = is.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        os.flush();
        os.close();
        is.close();
    }

    protected void unTarFile(String targetDir, String fileName) throws FaultType {
        logger.debug((Object)"called");
        try {
            InputStream in = fileName.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(fileName)) : new FileInputStream(fileName);
            TarInputStream tin = new TarInputStream(in);
            TarEntry tarEntry = tin.getNextEntry();
            while (tarEntry != null) {
                this.unTarFileEntry(targetDir, tin, tarEntry);
                tarEntry = tin.getNextEntry();
            }
            tin.close();
        }
        catch (IOException ioe) {
            String msg = "Error while extracting tarball: " + ioe.getMessage();
            logger.error((Object)msg);
            throw new FaultType(msg);
        }
    }

    protected void unTarFileEntry(String targetDir, TarInputStream tin, TarEntry tarEntry) throws IOException {
        File destPath = new File(targetDir + File.separator + tarEntry.getName());
        logger.debug((Object)("Processing " + destPath.getAbsoluteFile()));
        this.createDir(targetDir, tarEntry.getName());
        if (!tarEntry.isDirectory()) {
            FileOutputStream fout = new FileOutputStream(destPath);
            tin.copyEntryContents((OutputStream)fout);
            fout.close();
        }
    }

    protected void createDir(String targetDir, String zipName) {
        int ix = zipName.lastIndexOf(47);
        if (ix > 0) {
            File d;
            String dirName = zipName.substring(0, ix);
            dirName = targetDir + File.separator + dirName;
            if (!(this.dirsMade.contains(dirName) || (d = new File(dirName)).exists() && d.isDirectory())) {
                logger.debug((Object)("Creating Directory: " + dirName));
                if (!d.mkdirs()) {
                    logger.warn((Object)("Warning: unable to mkdir " + dirName));
                }
                this.dirsMade.add(dirName);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Extract ex = new Extract();
        ex.extract("build", "./samples/samples.zip");
    }
}

