/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.globus.mds.MDS;
import org.globus.mds.MDSException;

public class MDSCommon {
    private static String constructFilter(String hostname, Vector schedulertypes) {
        StringBuffer filter = new StringBuffer();
        filter.append("(&(objectclass=GlobusServiceJobManager)(hn=");
        filter.append(hostname);
        if (hostname.indexOf("*") == -1) {
            filter.append("*");
        }
        filter.append(")");
        int size = schedulertypes.size();
        if (size != 0) {
            filter.append("(|");
            for (int i = 0; i < size; ++i) {
                filter.append("(schedulertype=");
                filter.append(schedulertypes.elementAt(i));
                filter.append(")");
            }
            filter.append(")");
        }
        filter.append(")");
        return filter.toString();
    }

    public static Vector hostname2contacts(MDS mds, String basedn, String hostname, Vector schedulertypes) throws MDSException {
        String filter = MDSCommon.constructFilter(hostname, schedulertypes);
        SearchResult si = null;
        Attributes attrs = null;
        Attribute at = null;
        Vector<Object> contacts = new Vector<Object>();
        NamingEnumeration results = null;
        try {
            results = mds.searchl(basedn, filter, new String[]{"contact"}, 2);
            while (results != null && results.hasMoreElements()) {
                si = (SearchResult)results.next();
                attrs = si.getAttributes();
                at = attrs.get("contact");
                contacts.addElement(at.get());
            }
        }
        catch (NamingException e) {
            throw new MDSException("Failed to search for contacts", e.getMessage());
        }
        return contacts;
    }

    public static Hashtable listContacts(MDS mds, String basedn, String hostname, Vector schedulertypes) throws MDSException {
        String filter = MDSCommon.constructFilter(hostname, schedulertypes);
        SearchResult si = null;
        Attributes attrs = null;
        Object at = null;
        Hashtable<String, Object> contacts = new Hashtable<String, Object>();
        NamingEnumeration results = null;
        String key = null;
        try {
            results = mds.searchl(basedn, filter, new String[]{"contact", "hn", "schedulertype"}, 2);
            while (results != null && results.hasMoreElements()) {
                si = (SearchResult)results.next();
                attrs = si.getAttributes();
                key = attrs.get("hn").get() + "-" + attrs.get("schedulertype").get();
                contacts.put(key, attrs.get("contact").get());
            }
        }
        catch (NamingException e) {
            throw new MDSException("Failed to search for contacts", e.getMessage());
        }
        return contacts;
    }

    public static Vector userJobs(MDS mds, String basedn, String userid) throws MDSException {
        StringBuffer filter = new StringBuffer();
        filter.append("(&(objectclass=GlobusQueueEntry)(globaluserid=");
        filter.append(userid);
        filter.append("))");
        SearchResult si = null;
        Attributes attrs = null;
        Attribute at = null;
        Vector<Object> joblist = new Vector<Object>();
        NamingEnumeration results = null;
        try {
            results = mds.searchl(basedn, filter.toString(), new String[]{"globaljobid"}, 2);
            while (results != null && results.hasMoreElements()) {
                si = (SearchResult)results.next();
                attrs = si.getAttributes();
                at = attrs.get("globaljobid");
                joblist.addElement(at.get());
            }
        }
        catch (NamingException e) {
            throw new MDSException("Failed to search for user jobs", e.getMessage());
        }
        return joblist;
    }

    public static String toGlobusDN(String dn) {
        if (dn == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(dn, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            buf.insert(0, tokens.nextToken().trim());
            if (!tokens.hasMoreTokens()) continue;
            buf.insert(0, "/");
        }
        buf.insert(0, '/');
        return buf.toString();
    }
}

