package gomo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import org.obo.dataadapter.OBOParseEngine;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOParser;
import org.obo.dataadapter.ParseEngine;
import org.obo.datamodel.NestedValue;


public class OBOParserAdapter implements OBOParser {
	private static Logger logger;
	
	static {
		logger = Logger.getLogger("gomo");
		logger.setUseParentHandlers(false);
		logger.setLevel(Level.OFF);
	}

	@Override
	public boolean prefersRaw(String tag, String value, NestedValue nv)
			throws OBOParseException {
		//logger.entering("OBOParserAdapter", "prefersRaw", tag);
		return false;
	}

	@Override
	public void readAltID(String id, NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readAltID", id);
		
	}

	@Override
	public void readAlwaysImpliesInverse(boolean b, NestedValue nv)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readAlwaysImpliesInverse", b);
		
	}

	/**
	 * Specifies the program which generated file.
	 * eg. OBO-Edit 2.1-beta1
	 * @param autogeneratedBy the program which generated the file
	 */
	@Override
	public void readAutogeneratedBy(String autogeneratedBy)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readAutogeneratedBy", autogeneratedBy);
		
	}

	@Override
	public void readComment(String comment, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readComment", comment);
		
	}

	@Override
	public void readConsider(String id, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readConsider", id);
		
	}

	@Override
	public void readCreatedBy(String user, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readCreatedBy", user);
		
	}

	/**
	 * This function doesn't seem to be called, at least not on the
	 * obo file I traced. Look at readDate as it seems to specify the
	 * creation date.
	 * @see readDate
	 */
	@Override
	public void readCreationDate(Date date, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readCreationDate", date);
		
	}

	/**
	 * The date on which the file was created?
	 */
	@Override
	public void readDate(Date date) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readDate", date);
		
	}

	@Override
	public void readDef(String def, XrefPair[] xrefs, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readDef", def);
		
	}

	/**
	 * Seems to be just some XML thing. I doubt it'd be of interest to most people.
	 * It seem to always be "gene_ontology".
	 * @param ns the name space.
	 */
	@Override
	public void readDefaultNamespace(String ns) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readDefaultNamespace", ns);
		
	}

	@Override
	public void readDisjoint(String id, String ns, boolean implied,
			NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readDisjoint", id);
		
	}

	@Override
	public void readDomain(String domain, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readDomain", domain);
		
	}

	@Override
	public void readFileVersion(String version) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readFileVersion", version);
		
	}

	/**
	 * The version of the file format.
	 * eg. 1.2
	 */
	@Override
	public void readFormatVersion(String version) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readFormatVersion", version);
		
	}

	@Override
	public void readHoldsOverChain(String[] ids, String ns, boolean implied,
			NestedValue nv) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readHoldsOverChain", ids);
		
	}

	/**
	 * IMPORTANT METHOD
	 * gets the ID of whatever the stanza is. If the stanza is "term" then
	 * this is the GO term ID.
	 */
	@Override
	public void readID(String id, NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readID", id);
		
	}

	@Override
	public void readIDMapping(String originalid, String newid)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIDMapping", originalid);
		
	}

	@Override
	public void readIDPrefix(String prefix) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIDPrefix", prefix);
		
	}

	@Override
	public void readIDSpace(String idspace, String uriPrefix)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIDSpace", idspace);
		
	}

	@Override
	public void readImpliedID() {
		logger.entering("OBOParserAdapter", "readImpliedID");
		
	}

	@Override
	public void readImport(String path) throws IOException, OBOParseException {
		logger.entering("OBOParserAdapter", "readImport", path);
		
	}

	@Override
	public void readInstanceOf(String id, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readInstanceOf", id);
		
	}

	@Override
	public void readInverseOf(String id, String ns, boolean implied,
			NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readInverseOf", id);
		
	}

	@Override
	public void readIsa(String id, String ns, boolean completes,
			boolean implied, NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsa", id);
		
	}

	@Override
	public void readIsAnonymous(NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsAnonymous");
		
	}

	@Override
	public void readIsCyclic(boolean isCyclic, NestedValue nv)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsCyclic", isCyclic);
		
	}

	@Override
	public void readIsMetadataTag(NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsMetadataTag");
		
	}

	@Override
	public void readIsObsolete(NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsObsolete");
		
	}

	@Override
	public void readIsReflexive(boolean b, NestedValue nv)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsReflexive", b);
		
	}

	@Override
	public void readIsSymmetric(boolean isSymmetric, NestedValue nv)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsSymmetric", isSymmetric);
		
	}

	@Override
	public void readIsTransitive(boolean isTransitive, NestedValue nv)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsTransitive", isTransitive);
		
	}

	@Override
	public void readIsUniversallyQuantified(boolean isUniversallyQuantified,
			NestedValue nv) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readIsUniversallyQuantified", isUniversallyQuantified);
		
	}

	@Override
	public void readModificationDate(Date date, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readModificationDate", date);
		
	}

	@Override
	public void readModifiedBy(String user, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readModifiedBy", user);
		
	}

	@Override
	public void readName(String name, NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readName", name);
		
	}

	@Override
	public void readNamespace(String ns, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readNamespace", ns);
		
	}

	@Override
	public void readNamespaceIDRule(String ns, String rule)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readNamespaceIDRule", ns);
		
	}

	@Override
	public void readPropertyValue(String propID, String val, String typeID,
			boolean quoted, NestedValue nv) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readPropertyValue", propID);
		
	}

	@Override
	public void readRange(String range, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readRange", range);
		
	}

	@Override
	public void readRelationship(String relType, String id, boolean necessary,
			boolean inverseNecessary, boolean completes, boolean implied,
			Integer minCardinality, Integer maxCardinality,
			Integer cardinality, String ns, NestedValue val, List<String> args,
			boolean parentIsProperty) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readRelationship", new Object[]{relType, id});
		
	}

	/**
	 * A remark on the file. The remark on my file seems to be about the
	 * revision control version. eg. cvs version: $Revision: 1.804 $
	 * @param remark a bit of information about the file
	 */
	@Override
	public void readRemark(String remark) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readRemark", remark);
		
	}

	@Override
	public void readReplacedBy(String id, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readReplacedBy", id);
		
	}

	/**
	 * Specifies the name of the person (or maybe their username?) who
	 * created the file. eg. jane
	 * @param savedBy the name of the person who created the file
	 */
	@Override
	public void readSavedBy(String savedBy) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readSavedBy", savedBy);
		
	}

	@Override
	public void readSubset(String name, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readSubset", name);
		
	}

	/**
	 * I'm not certain of what this does but it appears to specify available
	 * subsets of the GO. I'm not sure how you go about extracting those
	 * subsets either. Examples of subsets are: goslim_candida, goslim_generic
	 * goslim_goa, goslim_pir, goslim_plant, goslim_pombe, goslim_yeast and 
	 * gosubset_prok
	 */
	@Override
	public void readSubsetDef(String name, String desc)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readSubsetDef", name);
		
	}

	@Override
	public void readSynonym(String name, XrefPair[] xrefs, int scope,
			String catID, NestedValue val) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readSynonym", name);
		
	}

	/**
	 * I'm not certain of what this does.
	 * An example id is: systematic_synonym
	 */
	@Override
	public void readSynonymCategory(String id, String name, int scope)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readSynonymCategory", id);
		
	}

	@Override
	public void readTransitiveOver(String id, String ns, boolean implied,
			NestedValue nv) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readTransitiveOver", id);
		
	}

	@Override
	public void readUnion(String id, String ns, boolean implied, NestedValue val)
			throws OBOParseException {
		logger.entering("OBOParserAdapter", "readUnion", id);
		
	}

	@Override
	public void readXrefAnalog(XrefPair pair) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readXrefAnalog", pair);
		
	}

	@Override
	public void readXrefUnk(XrefPair pair) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readXrefUnk", pair);
		
	}

	/**
	 * called when parsing has been canceled by engine.cancel()
	 */
	@Override
	public void cancel() {
		logger.entering("OBOParserAdapter", "cancel");
		
	}

	@Override
	public void endFileParse(String uri) throws OBOParseException {
		logger.entering("OBOParserAdapter", "endFileParse", uri);
		
	}

	@Override
	public void endParse() throws OBOParseException {
		logger.entering("OBOParserAdapter", "endParse");
		
	}

	@Override
	public String mapID(String id) {
		logger.entering("OBOParserAdapter", "mapID", id);
		return null;
	}

	@Override
	public void readBangComment(String comment) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readBangComment", comment);
		
	}

	@Override
	public boolean readTagValue(String tag, String value, NestedValue nv,
			boolean handled) throws OBOParseException {
		logger.entering("OBOParserAdapter", "readTagValue", new Object[]{tag,value});
		return false;
	}

	/**
	 * called when the parse engine is set.
	 * @param engine the parsing engine which can be used to cancel the parse, or extract line numbers, etc.
	 */
	@Override
	public void setParseEngine(ParseEngine engine) {
		logger.entering("OBOParserAdapter", "setParseEngine");
		
	}

	/**
	 * called when the file specified by uri is about to be parsed
	 * @param uri an absolute path (it seems)
	 */
	@Override
	public void startFileParse(String uri) throws OBOParseException {
		logger.entering("OBOParserAdapter", "startFileParse", uri);
		
	}

	/**
	 * called when parsing is started
	 */
	@Override
	public void startParse() throws OBOParseException {
		logger.entering("OBOParserAdapter", "startParse");
		
	}

	/**
	 * IMPORTANT METHOD
	 * tells you when a sub group of data has started, like a GO term which
	 * has the name value of "term".
	 * @param name the name of the subgroup, like "term" for a GO term
	 */
	@Override
	public boolean startStanza(String name) throws OBOParseException {
		logger.entering("OBOParserAdapter", "startStanza", name);
		return false;
	}
	
	public static void trace(File oboFile, File logFile) throws IOException, OBOParseException {
		logger.setLevel(Level.ALL);
		Handler h;
		h = new FileHandler(logFile.getPath());
		h.setFormatter(new SimpleFormatter());
		h.setLevel(Level.ALL);
		logger.addHandler(h);
		OBOParseEngine engine = new OBOParseEngine(new OBOParserAdapter());
		engine.setPath(oboFile.getPath());
		engine.parse();
	}
	
	public static void main(String[] args) throws IOException {
		if (args.length != 2) {
			System.err.println("Expected <GO OBO File> <Log File>");
			return;
		}
		File oboFile, logFile;
		oboFile = new File(args[0]);
		if (!oboFile.exists()) {
			System.err.println("OBO file doesn't exist");
			return;
		}
		if (!oboFile.isFile()) {
			System.err.println("OBO file isn't a normal file.");
			return;
		}
		if (!oboFile.canRead()) {
			System.err.println("OBO file can't be read.");
			return;
		}
		logFile = new File(args[1]);
		try {
			trace(oboFile, logFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
