/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.state;

import edu.sdsc.nbcr.opal.JobOutputType;
import edu.sdsc.nbcr.opal.JobStatisticsType;
import edu.sdsc.nbcr.opal.OutputFileType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.state.HibernateUtil;
import edu.sdsc.nbcr.opal.state.JobInfo;
import java.sql.Time;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.types.URI;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class PackageTest
extends TestCase {
    private static Logger logger = Logger.getLogger((String)PackageTest.class.getName());
    private static Session session = null;
    String jobID = "app" + System.currentTimeMillis();

    public static void main(String[] args) {
        TestRunner.run((Test)PackageTest.suite());
        System.exit(0);
    }

    public PackageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PackageTest.class);
    }

    protected void setUp() {
        if (session == null) {
            logger.info((Object)"Initializing hibernate");
            session = HibernateUtil.getSessionFactory().openSession();
        }
    }

    protected void tearDown() {
    }

    public void testSaveJob() {
        System.out.println("Testing insertion of job state into database");
        JobInfo info = new JobInfo();
        info.setJobID(this.jobID);
        info.setCode(0);
        info.setMessage("This is a test");
        info.setBaseURL("http://localhost/test");
        Date currentDate = new Date();
        info.setStartTimeDate(new java.sql.Date(currentDate.getTime()));
        info.setStartTimeTime(new Time(currentDate.getTime()));
        info.setActivationTimeDate(new java.sql.Date(currentDate.getTime()));
        info.setActivationTimeTime(new Time(currentDate.getTime()));
        info.setCompletionTimeDate(new java.sql.Date(currentDate.getTime()));
        info.setCompletionTimeTime(new Time(currentDate.getTime()));
        info.setLastUpdateTime(new Time(currentDate.getTime()));
        info.setLastUpdateDate(new java.sql.Date(currentDate.getTime()));
        info.setClientDN("CN=Test");
        info.setClientIP("127.0.0.1");
        info.setServiceName("Command-line");
        try {
            boolean status = HibernateUtil.saveJobInfoInDatabase(info);
            PackageTest.assertTrue((String)"Insertion of job state failed with status: ", (boolean)status);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Insertion of job state failed");
        }
    }

    public void testSaveOutput() {
        System.out.println("Testing insertion of job outputs into database");
        JobOutputType outputs = new JobOutputType();
        try {
            outputs.setStdOut(new URI("http://localhost/test/stdout.txt"));
            outputs.setStdErr(new URI("http://localhost/test/stderr.txt"));
            OutputFileType[] files = new OutputFileType[]{new OutputFileType()};
            files[0].setName("foo.txt");
            files[0].setUrl(new URI("http://localhost/test/foo.txt"));
            outputs.setOutputFile(files);
            boolean status = HibernateUtil.saveOutputsInDatabase(this.jobID, outputs);
            PackageTest.assertTrue((String)"Insertion of job outputs failed with status: ", (boolean)status);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Insertion of job outputs failed");
        }
    }

    public void testJobUpdate() {
        System.out.println("Testing update of job state");
        try {
            int rows = HibernateUtil.updateJobInfoInDatabase(this.jobID, 1, "This is a test update", "http://localhost/test", "testHandle");
            PackageTest.assertEquals((String)"Update of job status failed - number of rows", (int)1, (int)rows);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Update of job state failed");
        }
    }

    public void testSearchJob() {
        System.out.println("Testing search for jobs");
        try {
            StatusOutputType status = HibernateUtil.getStatus(this.jobID);
            PackageTest.assertNotNull((String)"Job search failed", (Object)status);
            System.out.println("Job Status: " + this.jobID + " - {" + status.getCode() + ", " + status.getMessage() + ", " + status.getBaseURL() + "}");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Job search failed");
        }
    }

    public void testSearchJobStats() {
        System.out.println("Testing search for job statistics");
        try {
            JobStatisticsType stats = HibernateUtil.getStatistics(this.jobID);
            PackageTest.assertNotNull((String)"Search for job statistics failed", (Object)stats);
            System.out.println("Job Statistics: " + this.jobID + " - {" + stats.getStartTime().getTime() + ", " + stats.getActivationTime().getTime() + ", " + stats.getCompletionTime().getTime() + "}");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Search for job statistics failed");
        }
    }

    public void testSearchOutput() {
        System.out.println("Testing search for job output");
        JobOutputType outputs = null;
        try {
            outputs = HibernateUtil.getOutputs(this.jobID);
            PackageTest.assertNotNull((String)"Job output search failed", (Object)outputs);
            System.out.println("Standard output: " + outputs.getStdOut());
            System.out.println("Standard error: " + outputs.getStdErr());
            OutputFileType[] files = outputs.getOutputFile();
            for (int i = 0; i < files.length; ++i) {
                System.out.println(files[i].getName() + ": " + files[i].getUrl());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Job output search failed");
        }
    }
}

