/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import edu.sdsc.nbcr.opal.manager.pbsTorque.Job;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PBSJobManager
implements OpalJobManager {
    private static Logger logger = Logger.getLogger((String)PBSJobManager.class.getName());
    private Properties props;
    private AppConfigType config;
    private StatusOutputType status;
    private String handle;
    private boolean started = false;
    private volatile boolean done = false;
    private Job job;

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.info((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.status = new StatusOutputType();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
        logger.info((Object)"called");
        throw new JobManagerException("destroyJobManager() method not implemented");
    }

    @Override
    public String launchJob(String argList, Integer numProcs, String workingDir) throws JobManagerException {
        logger.info((Object)"called");
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        logger.debug((Object)("Argument list: " + args));
        String systemProcsString = this.props.getProperty("num.procs");
        int systemProcs = 0;
        if (systemProcsString != null) {
            systemProcs = Integer.parseInt(systemProcsString);
        }
        String cmd = null;
        if (this.config.isParallel()) {
            if (numProcs == null) {
                String msg = "Number of processes unspecified for parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (numProcs > systemProcs) {
                String msg = "Processors required - " + numProcs + ", available - " + systemProcs;
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            String mpiRun = this.props.getProperty("mpi.run");
            if (mpiRun == null) {
                String msg = "Can't find property mpi.run for running parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            cmd = mpiRun + " -np " + numProcs + " " + this.config.getBinaryLocation();
            if (args != null && !args.equals("")) {
                cmd = cmd + " " + args;
            }
            logger.debug((Object)("CMD: " + args));
        } else {
            cmd = this.config.getBinaryLocation();
            if (args != null && !args.equals("")) {
                cmd = cmd + " " + args;
            }
            logger.debug((Object)("CMD: " + cmd));
        }
        long hardLimit = 0L;
        if (this.props.getProperty("opal.hard_limit") != null) {
            hardLimit = Long.parseLong(this.props.getProperty("opal.hard_limit"));
            logger.debug((Object)"Property hard_limit is not supported by this job manager");
        }
        try {
            logger.debug((Object)("Working directory: " + workingDir));
            String jobName = this.createSubmissionJobName();
            String script = this.createSubmissionScript(cmd, workingDir, jobName);
            this.job = new Job(jobName, script);
            if (this.config.isParallel()) {
                this.job.setNodes(numProcs.toString());
            }
            this.handle = this.job.queue();
            logger.info((Object)("PBS job has been submitted with id " + this.handle));
        }
        catch (Exception e) {
            String msg = "Error while running executable via DRMAA - " + e.getMessage();
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.started = true;
        return this.handle;
    }

    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            while (true) {
                String jobState = Job.getJobStatus(this.handle);
                logger.debug((Object)("Received job status: " + jobState));
                if (jobState.equals("Q")) {
                    Thread.sleep(3000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String msg = "Can't wait for job to activate - " + e.getMessage();
            logger.warn((Object)msg);
        }
        this.status.setCode(2);
        this.status.setMessage("Execution in progress");
        return this.status;
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String jobState = "";
        boolean gotStatus = true;
        try {
            do {
                Thread.sleep(3000L);
                jobState = Job.getJobStatus(this.handle);
                logger.debug((Object)("Received job status: " + jobState));
            } while (!jobState.equals("C") && !jobState.equals("E"));
        }
        catch (Exception e) {
            String msg = "Can't wait for job to complete - " + e.getMessage();
            logger.warn((Object)msg);
            gotStatus = false;
        }
        if (!gotStatus) {
            this.status.setCode(8);
            this.status.setMessage("Execution complete - check outputs to verify successful execution");
        } else if (jobState.equals("C")) {
            this.status.setCode(8);
            this.status.setMessage("Execution complete - check outputs to verify successful execution");
        } else {
            this.status.setCode(4);
            this.status.setMessage("Execution failed - final job status is " + jobState);
        }
        return this.status;
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't destroy a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            Job.destroy(this.handle);
        }
        catch (Exception e) {
            String msg = "Error while destroying job: " + e.getMessage();
            logger.error((Object)e);
            throw new JobManagerException(msg);
        }
        this.status.setCode(4);
        this.status.setMessage("Process destroyed on user request");
        return this.status;
    }

    private String createSubmissionScript(String cmd, String workingDir, String jobName) throws IOException {
        File tmpFile = File.createTempFile("/pbs", ".submit");
        PrintWriter pw = new PrintWriter(new FileWriter(tmpFile));
        pw.println("#!/bin/bash");
        pw.println("#PBS -N " + jobName);
        pw.println("#PBS -e " + workingDir + "stderr.txt");
        pw.println("#PBS -o " + workingDir + "stdout.txt");
        String pbsExprFileName = this.props.getProperty("pbs.expr.file");
        if (pbsExprFileName != null) {
            try {
                String strLine;
                Properties condorProps = new Properties();
                FileInputStream in = new FileInputStream(pbsExprFileName);
                DataInputStream din = new DataInputStream(in);
                BufferedReader br = new BufferedReader(new InputStreamReader(din));
                while ((strLine = br.readLine()) != null) {
                    pw.println(strLine);
                }
                in.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load " + pbsExprFileName + " identified by pbs.expr.file: " + e.getMessage()));
            }
        }
        pw.println("cd " + workingDir);
        pw.println(cmd);
        pw.close();
        return tmpFile.getAbsolutePath();
    }

    private String createSubmissionJobName() throws JobManagerException {
        String startstr;
        String jobName;
        String jobNameLimitString = this.props.getProperty("pbs.name.limit");
        int jobNameLimit = 15;
        if (jobNameLimitString != null) {
            jobNameLimit = Integer.parseInt(jobNameLimitString);
        }
        if ((jobName = (startstr = this.config.getBinaryLocation()).substring(startstr.lastIndexOf("/") + 1)).length() > jobNameLimit) {
            jobName = jobName.substring(0, jobNameLimit);
        }
        return jobName;
    }
}

