/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.gui.actions;

import edu.sdsc.nbcr.opal.AppServiceLocator;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

public class GetJobStatusAction
extends MappingDispatchAction {
    protected Log log = LogFactory.getLog((String)"edu.sdsc.nbcr.opal");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.debug((Object)"Action: GetJobStatusAction");
        if (request.getSession(false) == null || request.getSession(false).getAttribute("appMetadata") == null) {
            this.log.error((Object)"*** Session has timed out ***");
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("Session timed out");
            request.setAttribute("ERROR_MESSAGES", errors);
            return mapping.findForward("Timeout");
        }
        String jobId = request.getParameter("jobId");
        String serviceID = request.getParameter("serviceID");
        ArrayList<String> errors = new ArrayList<String>();
        if (jobId == null || serviceID == null || jobId.length() == 0 || serviceID.length() == 0) {
            if (jobId == null || jobId.length() == 0) {
                this.log.error((Object)"Error jobId can not be retrived.");
            }
            if (serviceID == null || serviceID.length() == 0) {
                this.log.error((Object)"Error serviceID can not be retrived.");
            }
            errors = new ArrayList();
            errors.add("I could not find the jobId and the serviceID");
            errors.add("Please return to the welcome page...");
            request.setAttribute("ERROR_MESSAGES", errors);
            return mapping.findForward("Error");
        }
        String url = this.getServlet().getServletContext().getInitParameter("OPAL_URL");
        if (url == null) {
            this.log.warn((Object)"OPAL_URL not found in web.xml. Using default.");
            url = "http://localhost:8080/opal2/services";
        }
        StatusOutputType status = null;
        try {
            AppServiceLocator asl = new AppServiceLocator();
            AppServicePortType appServicePort = asl.getAppServicePort(new URL(url + "/" + serviceID));
            status = appServicePort.queryStatus(jobId);
        }
        catch (FaultType e) {
            this.log.error((Object)"A remote error occurred while querying status.");
            this.log.error((Object)("The remote error message is: " + e.getMessage1()), (Throwable)((Object)e));
            errors.add("A remote error occured while querying status");
            errors.add("The remote error message is: " + e.getMessage1());
            request.setAttribute("ERROR_MESSAGES", errors);
            return mapping.findForward("Error");
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while querying status");
            this.log.error((Object)("The error message is: " + e.getMessage()), (Throwable)e);
            errors.add("An error occured while querying status");
            errors.add("The error message is: " + e.getMessage());
            errors.add("Please go back to the List of Applications page and try to resubmit your job");
            request.setAttribute("ERROR_MESSAGES", errors);
            return mapping.findForward("Error");
        }
        request.setAttribute("serviceID", (Object)serviceID);
        request.setAttribute("jobId", (Object)jobId);
        request.setAttribute("status", (Object)status);
        return mapping.findForward("JobStatus");
    }
}

