/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.proxy;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.globus.tools.ui.proxy.GridProxyProperties;
import org.globus.tools.ui.proxy.MyproxyGUI;
import org.globus.tools.ui.util.JJPanel;

public class MyproxyDialog
extends JDialog
implements ActionListener {
    protected MyproxyGUI myproxyInit;
    private GridProxyProperties gridProps;
    private JTextField portalLifetimeTF = new JTextField(4);
    private JTextField credLifetimeTF = new JTextField(4);
    private JTextField myproxyServerTF = new JTextField(10);
    private JTextField myproxyPortTF = new JTextField(6);
    private JButton okButton;
    private JButton saveButton;
    private JButton exitButton;

    public MyproxyDialog(MyproxyGUI parent) {
        this.myproxyInit = parent;
        this.gridProps = parent.getGridProxyProperties();
        this.setTitle("Myproxy Properties");
        this.setSize(300, 200);
        Container contentPane = this.getContentPane();
        JJPanel gridPanel = new JJPanel();
        gridPanel.setBorder(BorderFactory.createEtchedBorder());
        gridPanel.setAnchor(13);
        gridPanel.add(new JLabel("Myproxy Server: "), 0, 0, 1, 1);
        gridPanel.add(new JLabel("Myproxy Port: "), 0, 1, 1, 1);
        gridPanel.add(new JLabel("Portal Lifetime: "), 0, 2, 1, 1);
        gridPanel.add(new JLabel("Credential Lifetime: "), 0, 3, 1, 1);
        gridPanel.setAnchor(17);
        this.myproxyServerTF.setText(this.gridProps.getMyproxyServer());
        gridPanel.add(this.myproxyServerTF, 1, 0, 1, 1);
        this.myproxyPortTF.setText("" + this.gridProps.getMyproxyPort());
        gridPanel.add(this.myproxyPortTF, 1, 1, 1, 1);
        contentPane.add((Component)gridPanel, "Center");
        JPanel portalLifetimePanel = new JPanel(new FlowLayout(0, 0, 0));
        this.portalLifetimeTF.setText("" + this.gridProps.getPortalLifetime());
        portalLifetimePanel.add(this.portalLifetimeTF);
        portalLifetimePanel.add(new JLabel(" hours"));
        gridPanel.add(portalLifetimePanel, 1, 2, 1, 1);
        JPanel credLifetimePanel = new JPanel(new FlowLayout(0, 0, 0));
        credLifetimePanel.add(this.credLifetimeTF);
        this.credLifetimeTF.setText("" + this.gridProps.getCredLifetime());
        credLifetimePanel.add(new JLabel(" hours"));
        gridPanel.add(credLifetimePanel, 1, 3, 1, 1);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton("OK");
        this.saveButton = new JButton("Save");
        this.exitButton = new JButton("Cancel");
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.exitButton);
        this.okButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        contentPane.add((Component)buttonPanel, "South");
    }

    private boolean error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Need More Information", 2);
        return false;
    }

    private boolean validateSettings() {
        if (this.myproxyServerTF.getText().trim().equals("")) {
            return this.error("Please enter the hostname of the myproxy server");
        }
        if (this.myproxyPortTF.getText().trim().equals("")) {
            return this.error("Please enter the port number of the myproxy server");
        }
        if (this.credLifetimeTF.getText().trim().equals("")) {
            return this.error("Please enter the lifetime of the credential on the myproxy server");
        }
        if (this.portalLifetimeTF.getText().trim().equals("")) {
            return this.error("Please enter the maximum allowed lifetime of the proxy on the portal");
        }
        this.gridProps.setMyproxyServer(this.myproxyServerTF.getText().trim());
        this.gridProps.setMyproxyPort(new Integer(this.myproxyPortTF.getText().trim()));
        this.gridProps.setCredLifetime(new Integer(this.credLifetimeTF.getText().trim()));
        this.gridProps.setPortalLifetime(new Integer(this.portalLifetimeTF.getText().trim()));
        return true;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.okButton) {
            if (!this.validateSettings()) {
                return;
            }
            this.myproxyInit.setGridProxyProperties(this.gridProps);
            this.setVisible(false);
        } else if (source == this.saveButton) {
            if (!this.validateSettings()) {
                return;
            }
            this.myproxyInit.setGridProxyProperties(this.gridProps);
            this.gridProps.saveProperties();
        } else if (source == this.exitButton) {
            this.setVisible(false);
        } else {
            System.err.println("Unidentified event in MyproxyDialog");
        }
    }
}

