/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.config;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.globus.tools.ui.config.ConfigurationModule;

public abstract class AbstractWizard
extends JFrame
implements ActionListener {
    protected int moduleCount = 0;
    protected JPanel modulePanel = new JPanel();
    protected int currentModuleNumber = 0;
    private JButton backButton = new JButton("<< Back");
    private JButton nextButton = new JButton("Next >>");
    private JButton finishButton = new JButton("Finish");

    public AbstractWizard() {
        this.initComponents();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        Container contentPane = this.getContentPane();
        this.modulePanel.setLayout(new CardLayout());
        contentPane.add(this.modulePanel);
        JPanel buttonPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        this.backButton.addActionListener(this);
        this.backButton.setEnabled(false);
        buttonPanel.add(this.backButton);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        buttonPanel.add(this.nextButton);
        this.finishButton.addActionListener(this);
        this.finishButton.setEnabled(false);
        buttonPanel.add(this.finishButton);
        contentPane.add((Component)buttonPanel, "South");
    }

    protected void addModule(ConfigurationModule module) {
        ++this.moduleCount;
        this.modulePanel.add((Component)((Object)module), "Step " + new Integer(this.moduleCount));
        if (this.moduleCount == 1) {
            this.finishButton.setEnabled(true);
        } else if (this.moduleCount > 1) {
            this.nextButton.setEnabled(true);
            this.finishButton.setEnabled(false);
        }
    }

    public abstract void saveSettings();

    private boolean verifyAndSaveCurrent() {
        ConfigurationModule m = (ConfigurationModule)((Object)this.modulePanel.getComponent(this.currentModuleNumber));
        boolean rs = m.verifySettings();
        if (!rs) {
            return false;
        }
        m.saveSettings();
        return true;
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("Cancel")) {
            System.exit(0);
        } else if (actionCommand.equals("<< Back")) {
            if (((JButton)source).isEnabled()) {
                ((CardLayout)this.modulePanel.getLayout()).previous(this.modulePanel);
                --this.currentModuleNumber;
                if (this.currentModuleNumber == 0) {
                    this.backButton.setEnabled(false);
                }
                if (this.currentModuleNumber < this.moduleCount - 1) {
                    this.nextButton.setEnabled(true);
                    this.finishButton.setEnabled(false);
                }
            }
        } else if (actionCommand.equals("Next >>")) {
            if (((JButton)source).isEnabled()) {
                if (!this.verifyAndSaveCurrent()) {
                    return;
                }
                ((CardLayout)this.modulePanel.getLayout()).next(this.modulePanel);
                ++this.currentModuleNumber;
                if (this.currentModuleNumber == this.moduleCount - 1) {
                    this.nextButton.setEnabled(false);
                    this.finishButton.setEnabled(true);
                }
                if (this.currentModuleNumber > 0) {
                    this.backButton.setEnabled(true);
                }
            }
        } else if (actionCommand.equals("Finish")) {
            if (!this.verifyAndSaveCurrent()) {
                return;
            }
            this.saveSettings();
        }
    }
}

