/* Copyright (c) 2015 Mathias Panzenböck
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MEDIAEXTRACT_TEXT_H__
#define MEDIAEXTRACT_TEXT_H__
#pragma once

#include "mediaextract.h"

#define IS_NON_PRINTABLE_CODEPOINT(CP) \
	((CP) <= 0x8 || (CP) == 0xB || ((CP) >= 0xE && (CP) <= 0x1F) || (CP) == 0x7F)

#define ASCII_MAX 0x7F
#define LATIN1_MAX 0xFF
#define CODEPOINT_MAX 0x10FFFF

int ascii_isfile   (const uint8_t *data, size_t input_len, struct file_info *info);
int utf8_isfile    (const uint8_t *data, size_t input_len, struct file_info *info);
int utf16le_isfile (const uint8_t *data, size_t input_len, struct file_info *info);
int utf16be_isfile (const uint8_t *data, size_t input_len, struct file_info *info);
int utf32le_isfile (const uint8_t *data, size_t input_len, struct file_info *info);
int utf32be_isfile (const uint8_t *data, size_t input_len, struct file_info *info);

#endif /* MEDIAEXTRACT_TEXT_H__ */
