________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
SPDX-FileCopyrightText: 1998-2023 Paulo Moura <pmoura@logtalk.org>  
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


Atom is a multiple platform text editor available from:

	https://atom.io

Atom supports converting TextMate language bundles into language support
packages. The conversion process is described at:

	https://atom.io/docs/latest/converting-a-text-mate-bundle

The following shell commands can be used:

	$ apm init --package ~/.atom/packages/language-logtalk --convert $LOGTALKHOME/coding/textmate2/Logtalk.tmbundle
	$ sed -i.bak "s/0.0.0/$(sed -e 's/-.*$//' < $LOGTALKUSER/VERSION.txt)/" ~/.atom/packages/language-logtalk/package.json

If the `apm` command is not available, you can install it by selecting Atom's
menu option `Install Shell Commands`.

In alternative, a third-party maintained converted bundle is readily available
from:

	https://atom.io/packages/language-logtalk

Several Atom packages can be useful for Logtalk development. Those include:

1. `process-palette`

The provided `process-palette.json` file defines commands for compiling a file
from within Atom allowing clicking on warnings and errors and jump to their
location, for running unit tests, for scanning for dead code, for generating
HTML documentation, and for generating SVG diagrams.

In most cases, the menu options should be used with with either your *loader*
file or *tester* file selected. This ensures that the full code of your
application is loaded to perform the requested menu option.

For using these commands, install the `process-palette` package and replace
or merge the contents of the file with default file found at `~/.atom`. If
no `~/.atom/process-palette.json` file exists just copy the provided file
to `~/.atom`. Customization of this file is usually required to select your
preferred Prolog backend and keyboard shortcuts. The package settings may also
need to be edited to select the shell to be use (notably, on Windows, a Bash
shell must be specified; e.g. the Bash shell provided by Git for Windows).

2. `atom-ctags`

By installing this package and the Logtalk ctags support (see `../ctags`), it
is possible to use Atom's `Command Palette` to index and browse Logtalk code
(e.g. to search and navigate to entity and predicate declarations).

3. `atom-html-preview`

One of the packages that allows convenient rendering of HTML and SVG files,
including those generated for API documentation of Logtalk code.

4. `graphviz-preview`

For visualizing the `.dot` files generated by the `diagrams` tool.

5. `svg-preview`

For visualizing the `.svg` files generated by the `diagrams` tool.

6. `file-icons`

For displaying file icons, including for Logtalk source files, in the tabs
and the tree-view.


Logtalk source files (including the library entities and the programming
examples) are indented using tabs and are expected to remain perfectly 
indented no matter your tab width preference (a common setting is a tab
width equivalent to 4 spaces).
