%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  
%  This file is part of VivoMind Prolog Unicode Resources  
%  
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: March 15, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedDecompositionType-6.1.0.txt
# Date: 2011-07-25, 00:54:13 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/

# ================================================

# Decomposition_Type (from UnicodeData.txt, field 5: see UAX #44: http://www.unicode.org/reports/tr44/)

#  All code points not explicitly listed for Decomposition_Type
#  have the value None.

# @missing: 0000..10FFFF; None
*/

unicode_font(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_font(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_font(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_font(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

% ================================================

unicode_font(0x2102, 0x2102).	% Font L&       DOUBLE-STRUCK CAPITAL C
unicode_font(0x210A, 0x2113).	% Font L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_font(0x2115, 0x2115).	% Font L&       DOUBLE-STRUCK CAPITAL N
unicode_font(0x2119, 0x211D).	% Font L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_font(0x2124, 0x2124).	% Font L&       DOUBLE-STRUCK CAPITAL Z
unicode_font(0x2128, 0x2128).	% Font L&       BLACK-LETTER CAPITAL Z
unicode_font(0x212C, 0x212D).	% Font L&   [2] SCRIPT CAPITAL B..BLACK-LETTER CAPITAL C
unicode_font(0x212F, 0x2131).	% Font L&   [3] SCRIPT SMALL E..SCRIPT CAPITAL F
unicode_font(0x2133, 0x2134).	% Font L&   [2] SCRIPT CAPITAL M..SCRIPT SMALL O
unicode_font(0x2139, 0x2139).	% Font L&       INFORMATION SOURCE
unicode_font(0x213C, 0x213F).	% Font L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_font(0x2140, 0x2140).	% Font Sm       DOUBLE-STRUCK N-ARY SUMMATION
unicode_font(0x2145, 0x2149).	% Font L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_font(0xFB20, 0xFB28).	% Font Lo   [9] HEBREW LETTER ALTERNATIVE AYIN..HEBREW LETTER WIDE TAV
unicode_font(0xFB29, 0xFB29).	% Font Sm       HEBREW LETTER ALTERNATIVE PLUS SIGN
unicode_font(0x1D400, 0x1D454).	% Font L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_font(0x1D456, 0x1D49C).	% Font L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_font(0x1D49E, 0x1D49F).	% Font L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_font(0x1D4A2, 0x1D4A2).	% Font L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_font(0x1D4A5, 0x1D4A6).	% Font L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_font(0x1D4A9, 0x1D4AC).	% Font L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_font(0x1D4AE, 0x1D4B9).	% Font L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_font(0x1D4BB, 0x1D4BB).	% Font L&       MATHEMATICAL SCRIPT SMALL F
unicode_font(0x1D4BD, 0x1D4C3).	% Font L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_font(0x1D4C5, 0x1D505).	% Font L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_font(0x1D507, 0x1D50A).	% Font L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_font(0x1D50D, 0x1D514).	% Font L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_font(0x1D516, 0x1D51C).	% Font L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_font(0x1D51E, 0x1D539).	% Font L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_font(0x1D53B, 0x1D53E).	% Font L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_font(0x1D540, 0x1D544).	% Font L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_font(0x1D546, 0x1D546).	% Font L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_font(0x1D54A, 0x1D550).	% Font L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_font(0x1D552, 0x1D6A5).	% Font L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_font(0x1D6A8, 0x1D6C0).	% Font L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_font(0x1D6C1, 0x1D6C1).	% Font Sm       MATHEMATICAL BOLD NABLA
unicode_font(0x1D6C2, 0x1D6DA).	% Font L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_font(0x1D6DB, 0x1D6DB).	% Font Sm       MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
unicode_font(0x1D6DC, 0x1D6FA).	% Font L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_font(0x1D6FB, 0x1D6FB).	% Font Sm       MATHEMATICAL ITALIC NABLA
unicode_font(0x1D6FC, 0x1D714).	% Font L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_font(0x1D715, 0x1D715).	% Font Sm       MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
unicode_font(0x1D716, 0x1D734).	% Font L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_font(0x1D735, 0x1D735).	% Font Sm       MATHEMATICAL BOLD ITALIC NABLA
unicode_font(0x1D736, 0x1D74E).	% Font L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_font(0x1D74F, 0x1D74F).	% Font Sm       MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_font(0x1D750, 0x1D76E).	% Font L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_font(0x1D76F, 0x1D76F).	% Font Sm       MATHEMATICAL SANS-SERIF BOLD NABLA
unicode_font(0x1D770, 0x1D788).	% Font L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_font(0x1D789, 0x1D789).	% Font Sm       MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
unicode_font(0x1D78A, 0x1D7A8).	% Font L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_font(0x1D7A9, 0x1D7A9).	% Font Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
unicode_font(0x1D7AA, 0x1D7C2).	% Font L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_font(0x1D7C3, 0x1D7C3).	% Font Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_font(0x1D7C4, 0x1D7CB).	% Font L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_font(0x1D7CE, 0x1D7FF).	% Font Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
unicode_font(0x1EE00, 0x1EE03).	% Font Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_font(0x1EE05, 0x1EE1F).	% Font Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_font(0x1EE21, 0x1EE22).	% Font Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_font(0x1EE24, 0x1EE24).	% Font Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_font(0x1EE27, 0x1EE27).	% Font Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_font(0x1EE29, 0x1EE32).	% Font Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_font(0x1EE34, 0x1EE37).	% Font Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_font(0x1EE39, 0x1EE39).	% Font Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_font(0x1EE3B, 0x1EE3B).	% Font Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_font(0x1EE42, 0x1EE42).	% Font Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_font(0x1EE47, 0x1EE47).	% Font Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_font(0x1EE49, 0x1EE49).	% Font Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_font(0x1EE4B, 0x1EE4B).	% Font Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_font(0x1EE4D, 0x1EE4F).	% Font Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_font(0x1EE51, 0x1EE52).	% Font Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_font(0x1EE54, 0x1EE54).	% Font Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_font(0x1EE57, 0x1EE57).	% Font Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_font(0x1EE59, 0x1EE59).	% Font Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_font(0x1EE5B, 0x1EE5B).	% Font Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_font(0x1EE5D, 0x1EE5D).	% Font Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_font(0x1EE5F, 0x1EE5F).	% Font Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_font(0x1EE61, 0x1EE62).	% Font Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_font(0x1EE64, 0x1EE64).	% Font Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_font(0x1EE67, 0x1EE6A).	% Font Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_font(0x1EE6C, 0x1EE72).	% Font Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_font(0x1EE74, 0x1EE77).	% Font Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_font(0x1EE79, 0x1EE7C).	% Font Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_font(0x1EE7E, 0x1EE7E).	% Font Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_font(0x1EE80, 0x1EE89).	% Font Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_font(0x1EE8B, 0x1EE9B).	% Font Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_font(0x1EEA1, 0x1EEA3).	% Font Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_font(0x1EEA5, 0x1EEA9).	% Font Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_font(0x1EEAB, 0x1EEBB).	% Font Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN

% Total code points: 1184
