#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "localizer.h"
#include "config.h"

int main (int argc, char **argv) {
	long ip = 0;
	localizer *l = NULL;
	char ipbuf[256];
	
	l = localizer_init();
	
	if (argc == 2 && 
	    argv[1][0] == '-' &&
	    argv[1][1] == 'h') {
		printf("loc-search (using localizer C-API %s)\n", PACKAGE_VERSION);
		printf("searches the localizer-DB for IPs\n\n");
		printf("Usage:\n");
		printf("$ %s <localizer-db> < <file>\n", argv[0]);
		printf("<localizer-db> path to the localizer-db\n");
		printf("<file>         IP-addresses (one per line)\n");
		exit(-1);
	}
	
	if (localizer_read_shm(l, argc == 2 ? argv[1] : NULL)) return -1;
		
	while(fgets(ipbuf, sizeof(ipbuf)-1, stdin)) {
		char *s = ipbuf;
		l_data_export lext;
		for (s = ipbuf; *s && *s != '\n' && *s != '\r'; s++);
		*s = '\0';
			
		ip = localizer_ip2int(ipbuf);
	
		printf("%s,", ipbuf);
		if (-1 != localizer_search(l, ip, &lext)) {
			printf("%s,%s,%s,%s\n", 
			       lext.city, 
			       lext.province, 
			       lext.country, 
			       lext.provider);
		} else {
			printf(",,,\n");
		}
	}
	
	localizer_free(l);
	
	return 0;
}
