#ifndef _MIO_H_
#define _MIO_H_

#include "config.h"
#include "buffer.h"

#ifdef HAVE_LIBZ
#include <zlib.h>
#endif
#ifdef HAVE_LIBBZ
#include <bzlib.h>
#endif

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

typedef struct {
	int fd;
	enum { MIO_UNSET, MIO_PLAIN, MIO_GZIP, MIO_BZIP } file_type;
	enum { MIO_FILE, MIO_MMAP } access_type;
	
	buffer *ibuf;
	buffer *obuf;
	
	int offset;
	
	int eof;
#ifdef HAVE_LIBZ	
	z_stream gz;
#endif
#ifdef HAVE_LIBBZ
	bz_stream bz;
#endif
} mfile;

int    mopen (mfile *f, const char *fn);
char * mgets (mfile *f, buffer *buf);
void   mclose(mfile *f);

#endif
