; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -stop-after=legalizer -o - %s | FileCheck -check-prefix=GFX10 %s

define amdgpu_ps <4 x float> @sample_d_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dsdv, float %s) {
  ; GFX10-LABEL: name: sample_d_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY14]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.d.1d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.d.1d.v4f32.f16.f32(i32 15, half %dsdh, half %dsdv, float %s, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_d_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t) {
  ; GFX10-LABEL: name: sample_d_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.d.2d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.d.2d.v4f32.f16.f32(i32 15, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_d_3d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dtdh, half %drdh, half %dsdv, half %dtdv, half %drdv, float %s, float %t, float %r) {
  ; GFX10-LABEL: name: sample_d_3d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GFX10:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[COPY13]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC2:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC3:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY19]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY20]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<14 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BUILD_VECTOR_TRUNC2]](<2 x s16>), [[BUILD_VECTOR_TRUNC3]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.d.3d), 15, [[CONCAT_VECTORS]](<14 x s16>), $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.d.3d.v4f32.f16.f32(i32 15, half %dsdh, half %dtdh, half %drdh, half %dsdv, half %dtdv, half %drdv, float %s, float %t, float %r, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_d_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dsdv, float %s) {
  ; GFX10-LABEL: name: sample_c_d_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY15]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.d.1d), 15, [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.d.1d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dsdv, float %s, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_d_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t) {
  ; GFX10-LABEL: name: sample_c_d_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[COPY14]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.d.2d), 15, [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.d.2d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_d_cl_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dsdv, float %s, float %clamp) {
  ; GFX10-LABEL: name: sample_d_cl_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY14]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY15]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.d.cl.1d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.d.cl.1d.v4f32.f16.f32(i32 15, half %dsdh, half %dsdv, float %s, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_d_cl_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp) {
  ; GFX10-LABEL: name: sample_d_cl_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.d.cl.2d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.d.cl.2d.v4f32.f16.f32(i32 15, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_d_cl_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dsdv, float %s, float %clamp) {
  ; GFX10-LABEL: name: sample_c_d_cl_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY15]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY16]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.d.cl.1d), 15, [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.d.cl.1d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dsdv, float %s, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_d_cl_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp) {
  ; GFX10-LABEL: name: sample_c_d_cl_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[COPY14]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[BITCAST3:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY19]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<12 x s16>) = G_CONCAT_VECTORS [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), [[BITCAST3]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.d.cl.2d), 15, [[CONCAT_VECTORS]](<12 x s16>), $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.d.cl.2d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dsdv, float %s) {
  ; GFX10-LABEL: name: sample_cd_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY14]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.cd.1d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.1d.v4f32.f16.f32(i32 15, half %dsdh, half %dsdv, float %s, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t) {
  ; GFX10-LABEL: name: sample_cd_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.cd.2d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.2d.v4f32.f16.f32(i32 15, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dsdv, float %s) {
  ; GFX10-LABEL: name: sample_c_cd_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY15]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.cd.1d), 15, [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.1d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dsdv, float %s, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t) {
  ; GFX10-LABEL: name: sample_c_cd_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[COPY14]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.cd.2d), 15, [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.2d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_cl_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dsdv, float %s, float %clamp) {
  ; GFX10-LABEL: name: sample_cd_cl_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY14]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY15]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.cd.cl.1d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.cl.1d.v4f32.f16.f32(i32 15, half %dsdh, half %dsdv, float %s, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_cl_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp) {
  ; GFX10-LABEL: name: sample_cd_cl_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY12]](s32), [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.cd.cl.2d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.cl.2d.v4f32.f16.f32(i32 15, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_cl_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dsdv, float %s, float %clamp) {
  ; GFX10-LABEL: name: sample_c_cd_cl_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[DEF]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY15]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY16]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.cd.cl.1d), 15, [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.1d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dsdv, float %s, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_cl_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp) {
  ; GFX10-LABEL: name: sample_c_cd_cl_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[COPY14]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[BITCAST3:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY19]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<12 x s16>) = G_CONCAT_VECTORS [[BITCAST]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BITCAST2]](<2 x s16>), [[BITCAST3]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.cd.cl.2d), 15, [[CONCAT_VECTORS]](<12 x s16>), $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.2d.v4f32.f16.f32(i32 15, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps float @sample_c_d_o_2darray_V1(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, i32 %offset, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %slice) {
  ; GFX10-LABEL: name: sample_c_d_o_2darray_V1
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GFX10:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY16]](s32), [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[BITCAST3:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY19]](s32)
  ; GFX10:   [[BITCAST4:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY20]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<14 x s16>) = G_CONCAT_VECTORS [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST2]](<2 x s16>), [[BITCAST3]](<2 x s16>), [[BITCAST4]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(s32) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.d.o.2darray), 4, [[CONCAT_VECTORS]](<14 x s16>), $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (s32) from custom "ImageResource")
  ; GFX10:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0
main_body:
  %v = call float @llvm.amdgcn.image.sample.c.d.o.2darray.f16.f32.f32(i32 4, i32 %offset, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %slice, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret float %v
}

define amdgpu_ps <2 x float> @sample_c_d_o_2darray_V2(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, i32 %offset, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %slice) {
  ; GFX10-LABEL: name: sample_c_d_o_2darray_V2
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $sgpr10
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $sgpr11
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $sgpr12
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $sgpr13
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; GFX10:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; GFX10:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY12]](s32)
  ; GFX10:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY16]](s32), [[COPY17]](s32)
  ; GFX10:   [[BITCAST2:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY18]](s32)
  ; GFX10:   [[BITCAST3:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY19]](s32)
  ; GFX10:   [[BITCAST4:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[COPY20]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<14 x s16>) = G_CONCAT_VECTORS [[BITCAST]](<2 x s16>), [[BITCAST1]](<2 x s16>), [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>), [[BITCAST2]](<2 x s16>), [[BITCAST3]](<2 x s16>), [[BITCAST4]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.sample.c.d.o.2darray), 6, [[CONCAT_VECTORS]](<14 x s16>), $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, $noreg, [[BUILD_VECTOR]](<8 x s32>), [[BUILD_VECTOR1]](<4 x s32>), 0, 0, 0, 2 :: (dereferenceable load (<2 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<2 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
main_body:
  %v = call <2 x float> @llvm.amdgcn.image.sample.c.d.o.2darray.v2f32.f16.f32(i32 6, i32 %offset, float %zcompare, half %dsdh, half %dtdh, half %dsdv, half %dtdv, float %s, float %t, float %slice, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <2 x float> %v
}

declare <4 x float> @llvm.amdgcn.image.sample.d.1d.v4f32.f16.f32(i32, half, half, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.d.2d.v4f32.f16.f32(i32, half, half, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.d.3d.v4f32.f16.f32(i32, half, half, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.d.1d.v4f32.f16.f32(i32, float, half, half, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.d.2d.v4f32.f16.f32(i32, float, half, half, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.d.cl.1d.v4f32.f16.f32(i32, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.d.cl.2d.v4f32.f16.f32(i32, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.d.cl.1d.v4f32.f16.f32(i32, float, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.d.cl.2d.v4f32.f16.f32(i32, float, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

declare <4 x float> @llvm.amdgcn.image.sample.cd.1d.v4f32.f16.f32(i32, half, half, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.cd.2d.v4f32.f16.f32(i32, half, half, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.1d.v4f32.f16.f32(i32, float, half, half, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.2d.v4f32.f16.f32(i32, float, half, half, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.cd.cl.1d.v4f32.f16.f32(i32, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.cd.cl.2d.v4f32.f16.f32(i32, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.1d.v4f32.f16.f32(i32, float, half, half, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.2d.v4f32.f16.f32(i32, float, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

declare float @llvm.amdgcn.image.sample.c.d.o.2darray.f16.f32.f32(i32, i32, float, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <2 x float> @llvm.amdgcn.image.sample.c.d.o.2darray.v2f32.f16.f32(i32, i32, float, half, half, half, half, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readonly }
attributes #2 = { nounwind readnone }
