; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=amdgcn- -mcpu=gfx900 -amdgpu-dpp-combine=false -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-O0 %s
; RUN: llc -mtriple=amdgcn- -mcpu=gfx900 -amdgpu-dpp-combine=false -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-O3 %s

define amdgpu_gfx void @strict_wwm_no_cfg(<4 x i32> inreg %tmp14) {
; GFX9-O0-LABEL: strict_wwm_no_cfg:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    ; kill: def $sgpr40_sgpr41_sgpr42_sgpr43 killed $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_load_dwordx2 v[5:6], off, s[36:39], s34
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s34
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s34
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v2, v0 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v0, v0, v2
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v0, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v0, v1, v0
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[40:41], v3, v4
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s[40:41]
; GFX9-O0-NEXT:    s_mov_b32 s35, 1
; GFX9-O0-NEXT:    v_lshlrev_b32_e64 v3, s35, v3
; GFX9-O0-NEXT:    s_mov_b32 s35, 2
; GFX9-O0-NEXT:    v_and_b32_e64 v3, v3, s35
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_no_cfg:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    buffer_load_dwordx2 v[2:3], off, s[4:7], 0
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_mov_b32_dpp v0, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX9-O3-NEXT:    v_add_u32_e32 v0, v3, v0
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-O3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX9-O3-NEXT:    v_lshlrev_b32_e32 v4, 1, v4
; GFX9-O3-NEXT:    v_and_b32_e32 v4, 2, v4
; GFX9-O3-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %tmp100 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %tmp14, i32 0, i32 0, i32 0)
  %tmp101 = bitcast <2 x float> %tmp100 to <2 x i32>
  %tmp102 = extractelement <2 x i32> %tmp101, i32 0
  %tmp103 = extractelement <2 x i32> %tmp101, i32 1
  %tmp105 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp102, i32 0)
  %tmp107 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp103, i32 0)


  %tmp120 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp105, i32 323, i32 12, i32 15, i1 false)
  %tmp121 = add i32 %tmp105, %tmp120
  %tmp122 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp121)

  %tmp135 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp107, i32 323, i32 12, i32 15, i1 false)
  %tmp136 = add i32 %tmp107, %tmp135
  %tmp137 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp136)

  %tmp138 = icmp eq i32 %tmp122, %tmp137
  %tmp139 = sext i1 %tmp138 to i32
  %tmp140 = shl nsw i32 %tmp139, 1
  %tmp141 = and i32 %tmp140, 2
  %tmp145 = bitcast i32 %tmp141 to float
  call void @llvm.amdgcn.raw.buffer.store.f32(float %tmp145, <4 x i32> %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define amdgpu_gfx void @strict_wwm_cfg(<4 x i32> inreg %tmp14, i32 %arg) {
; GFX9-O0-LABEL: strict_wwm_cfg:
; GFX9-O0:       ; %bb.0: ; %entry
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_writelane_b32 v5, s30, 0
; GFX9-O0-NEXT:    v_writelane_b32 v5, s31, 1
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    s_mov_b64 s[42:43], s[38:39]
; GFX9-O0-NEXT:    s_mov_b64 s[40:41], s[36:37]
; GFX9-O0-NEXT:    v_writelane_b32 v5, s40, 2
; GFX9-O0-NEXT:    v_writelane_b32 v5, s41, 3
; GFX9-O0-NEXT:    v_writelane_b32 v5, s42, 4
; GFX9-O0-NEXT:    v_writelane_b32 v5, s43, 5
; GFX9-O0-NEXT:    s_mov_b32 s30, 0
; GFX9-O0-NEXT:    buffer_load_dwordx2 v[3:4], off, s[36:39], s30
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s30
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s30
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v2, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v1, v2
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[34:35], v0, s30
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s30
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[30:31], exec
; GFX9-O0-NEXT:    v_writelane_b32 v5, s30, 6
; GFX9-O0-NEXT:    v_writelane_b32 v5, s31, 7
; GFX9-O0-NEXT:    s_and_b64 s[30:31], s[30:31], s[34:35]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[30:31]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB1_2
; GFX9-O0-NEXT:  ; %bb.1: ; %if
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[30:31], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O0-NEXT:    s_mov_b64 exec, s[30:31]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[30:31], -1
; GFX9-O0-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v2, v1
; GFX9-O0-NEXT:    s_mov_b64 exec, s[30:31]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:  .LBB1_2: ; %merge
; GFX9-O0-NEXT:    v_readlane_b32 s34, v5, 6
; GFX9-O0-NEXT:    v_readlane_b32 s35, v5, 7
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-O0-NEXT:    v_readlane_b32 s30, v5, 0
; GFX9-O0-NEXT:    v_readlane_b32 s31, v5, 1
; GFX9-O0-NEXT:    v_readlane_b32 s36, v5, 2
; GFX9-O0-NEXT:    v_readlane_b32 s37, v5, 3
; GFX9-O0-NEXT:    v_readlane_b32 s38, v5, 4
; GFX9-O0-NEXT:    v_readlane_b32 s39, v5, 5
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[34:35], v0, v3
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s34, 1
; GFX9-O0-NEXT:    v_lshlrev_b32_e64 v0, s34, v0
; GFX9-O0-NEXT:    s_mov_b32 s34, 2
; GFX9-O0-NEXT:    v_and_b32_e64 v0, v0, s34
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_cfg:
; GFX9-O3:       ; %bb.0: ; %entry
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    buffer_load_dwordx2 v[2:3], off, s[4:7], 0
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O3-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-O3-NEXT:    s_and_saveexec_b64 s[34:35], vcc
; GFX9-O3-NEXT:  ; %bb.1: ; %if
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[36:37], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O3-NEXT:    s_mov_b64 exec, s[36:37]
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[36:37], -1
; GFX9-O3-NEXT:    v_mov_b32_dpp v1, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v3, v1
; GFX9-O3-NEXT:    s_mov_b64 exec, s[36:37]
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O3-NEXT:  ; %bb.2: ; %merge
; GFX9-O3-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-O3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-O3-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-O3-NEXT:    v_and_b32_e32 v0, 2, v0
; GFX9-O3-NEXT:    buffer_store_dword v0, off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
entry:
  %tmp100 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %tmp14, i32 0, i32 0, i32 0)
  %tmp101 = bitcast <2 x float> %tmp100 to <2 x i32>
  %tmp102 = extractelement <2 x i32> %tmp101, i32 0
  %tmp105 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp102, i32 0)

  %tmp120 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp105, i32 323, i32 12, i32 15, i1 false)
  %tmp121 = add i32 %tmp105, %tmp120
  %tmp122 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp121)

  %cond = icmp eq i32 %arg, 0
  br i1 %cond, label %if, label %merge
if:
  %tmp103 = extractelement <2 x i32> %tmp101, i32 1
  %tmp107 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp103, i32 0)

  %tmp135 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp107, i32 323, i32 12, i32 15, i1 false)
  %tmp136 = add i32 %tmp107, %tmp135
  %tmp137 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp136)
  br label %merge

merge:
  %merge_value = phi i32 [ 0, %entry ], [%tmp137, %if ]
  %tmp138 = icmp eq i32 %tmp122, %merge_value
  %tmp139 = sext i1 %tmp138 to i32
  %tmp140 = shl nsw i32 %tmp139, 1
  %tmp141 = and i32 %tmp140, 2
  %tmp145 = bitcast i32 %tmp141 to float
  call void @llvm.amdgcn.raw.buffer.store.f32(float %tmp145, <4 x i32> %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define hidden amdgpu_gfx i32 @strict_wwm_called(i32 %a) noinline {
; GFX9-O0-LABEL: strict_wwm_called:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v0, v0
; GFX9-O0-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX9-O0-NEXT:    v_sub_u32_e64 v0, v0, v1
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_called:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v0, v0
; GFX9-O3-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX9-O3-NEXT:    v_sub_u32_e32 v0, v0, v1
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %add = add i32 %a, %a
  %mul = mul i32 %add, %a
  %sub = sub i32 %mul, %add
  ret i32 %sub
}

define amdgpu_gfx void @strict_wwm_call(<4 x i32> inreg %tmp14, i32 inreg %arg) {
; GFX9-O0-LABEL: strict_wwm_call:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_writelane_b32 v3, s33, 2
; GFX9-O0-NEXT:    s_mov_b32 s33, s32
; GFX9-O0-NEXT:    s_add_i32 s32, s32, 0x400
; GFX9-O0-NEXT:    v_writelane_b32 v3, s30, 0
; GFX9-O0-NEXT:    v_writelane_b32 v3, s31, 1
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    ; kill: def $sgpr40_sgpr41_sgpr42_sgpr43 killed $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s34
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    s_getpc_b64 s[30:31]
; GFX9-O0-NEXT:    s_add_u32 s30, s30, strict_wwm_called@rel32@lo+4
; GFX9-O0-NEXT:    s_addc_u32 s31, s31, strict_wwm_called@rel32@hi+12
; GFX9-O0-NEXT:    s_mov_b64 s[46:47], s[2:3]
; GFX9-O0-NEXT:    s_mov_b64 s[44:45], s[0:1]
; GFX9-O0-NEXT:    s_mov_b64 s[0:1], s[44:45]
; GFX9-O0-NEXT:    s_mov_b64 s[2:3], s[46:47]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    s_swappc_b64 s[30:31], s[30:31]
; GFX9-O0-NEXT:    v_readlane_b32 s30, v3, 0
; GFX9-O0-NEXT:    v_readlane_b32 s31, v3, 1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v1, v2
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    s_add_i32 s32, s32, 0xfffffc00
; GFX9-O0-NEXT:    v_readlane_b32 s33, v3, 2
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_call:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_mov_b32 s38, s33
; GFX9-O3-NEXT:    s_mov_b32 s33, s32
; GFX9-O3-NEXT:    s_addk_i32 s32, 0x400
; GFX9-O3-NEXT:    s_mov_b64 s[36:37], s[30:31]
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O3-NEXT:    s_getpc_b64 s[30:31]
; GFX9-O3-NEXT:    s_add_u32 s30, s30, strict_wwm_called@rel32@lo+4
; GFX9-O3-NEXT:    s_addc_u32 s31, s31, strict_wwm_called@rel32@hi+12
; GFX9-O3-NEXT:    s_swappc_b64 s[30:31], s[30:31]
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v1, v2
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O3-NEXT:    buffer_store_dword v0, off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    s_addk_i32 s32, 0xfc00
; GFX9-O3-NEXT:    s_mov_b32 s33, s38
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[30:31], -1
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[30:31]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[36:37]
  %tmp107 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %arg, i32 0)
  %tmp134 = call amdgpu_gfx i32 @strict_wwm_called(i32 %tmp107)
  %tmp136 = add i32 %tmp134, %tmp107
  %tmp137 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp136)
  call void @llvm.amdgcn.raw.buffer.store.i32(i32 %tmp137, <4 x i32> %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define amdgpu_gfx i64 @strict_wwm_called_i64(i64 %a) noinline {
; GFX9-O0-LABEL: strict_wwm_called_i64:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr0_vgpr1 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_add_co_u32_e64 v4, s[34:35], v4, v5
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v0, s[34:35], v0, v1, s[34:35]
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-O0-NEXT:    s_mov_b32 s34, 32
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s34, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], s34, v[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-O0-NEXT:    v_mul_lo_u32 v2, v2, v3
; GFX9-O0-NEXT:    v_mad_u64_u32 v[6:7], s[36:37], v0, v3, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s35
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    v_lshlrev_b64 v[1:2], s34, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    s_mov_b32 s35, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_or_b32_e64 v0, v0, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_sub_co_u32_e64 v1, s[36:37], v1, v3
; GFX9-O0-NEXT:    v_subb_co_u32_e64 v0, s[36:37], v0, v2, s[36:37]
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_lshrrev_b64 v[1:2], s34, v[1:2]
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 killed $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_called_i64:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    v_add_co_u32_e32 v2, vcc, v0, v0
; GFX9-O3-NEXT:    v_addc_co_u32_e32 v3, vcc, v1, v1, vcc
; GFX9-O3-NEXT:    v_mul_lo_u32 v4, v3, v0
; GFX9-O3-NEXT:    v_mul_lo_u32 v5, v2, v1
; GFX9-O3-NEXT:    v_mad_u64_u32 v[0:1], s[34:35], v2, v0, 0
; GFX9-O3-NEXT:    v_add3_u32 v1, v1, v5, v4
; GFX9-O3-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v2
; GFX9-O3-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %add = add i64 %a, %a
  %mul = mul i64 %add, %a
  %sub = sub i64 %mul, %add
  ret i64 %sub
}

define amdgpu_gfx void @strict_wwm_call_i64(<4 x i32> inreg %tmp14, i64 inreg %arg) {
; GFX9-O0-LABEL: strict_wwm_call_i64:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_writelane_b32 v10, s33, 8
; GFX9-O0-NEXT:    s_mov_b32 s33, s32
; GFX9-O0-NEXT:    s_add_i32 s32, s32, 0xc00
; GFX9-O0-NEXT:    v_writelane_b32 v10, s30, 0
; GFX9-O0-NEXT:    v_writelane_b32 v10, s31, 1
; GFX9-O0-NEXT:    s_mov_b32 s34, s8
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    v_writelane_b32 v10, s36, 2
; GFX9-O0-NEXT:    v_writelane_b32 v10, s37, 3
; GFX9-O0-NEXT:    v_writelane_b32 v10, s38, 4
; GFX9-O0-NEXT:    v_writelane_b32 v10, s39, 5
; GFX9-O0-NEXT:    ; kill: def $sgpr34 killed $sgpr34 def $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b32 s35, s9
; GFX9-O0-NEXT:    ; kill: def $sgpr30_sgpr31 killed $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b64 s[30:31], 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s35
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, s30
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s31
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[30:31], -1
; GFX9-O0-NEXT:    v_writelane_b32 v10, s30, 6
; GFX9-O0-NEXT:    v_writelane_b32 v10, s31, 7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v8
; GFX9-O0-NEXT:    s_mov_b32 s30, 32
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    v_lshrrev_b64 v[3:4], s30, v[8:9]
; GFX9-O0-NEXT:    s_getpc_b64 s[30:31]
; GFX9-O0-NEXT:    s_add_u32 s30, s30, strict_wwm_called_i64@gotpcrel32@lo+4
; GFX9-O0-NEXT:    s_addc_u32 s31, s31, strict_wwm_called_i64@gotpcrel32@hi+12
; GFX9-O0-NEXT:    s_load_dwordx2 s[30:31], s[30:31], 0x0
; GFX9-O0-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-O0-NEXT:    s_mov_b64 s[36:37], s[0:1]
; GFX9-O0-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-O0-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-O0-NEXT:    s_swappc_b64 s[30:31], s[30:31]
; GFX9-O0-NEXT:    v_readlane_b32 s34, v10, 6
; GFX9-O0-NEXT:    v_readlane_b32 s35, v10, 7
; GFX9-O0-NEXT:    v_readlane_b32 s36, v10, 2
; GFX9-O0-NEXT:    v_readlane_b32 s37, v10, 3
; GFX9-O0-NEXT:    v_readlane_b32 s38, v10, 4
; GFX9-O0-NEXT:    v_readlane_b32 s39, v10, 5
; GFX9-O0-NEXT:    v_readlane_b32 s30, v10, 0
; GFX9-O0-NEXT:    v_readlane_b32 s31, v10, 1
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_add_co_u32_e64 v2, s[40:41], v2, v4
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v3, s[40:41], v3, v5, s[40:41]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_store_dwordx2 v[0:1], off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    s_add_i32 s32, s32, 0xfffff400
; GFX9-O0-NEXT:    v_readlane_b32 s33, v10, 8
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_call_i64:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v6, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_mov_b32 s40, s33
; GFX9-O3-NEXT:    s_mov_b32 s33, s32
; GFX9-O3-NEXT:    s_addk_i32 s32, 0x800
; GFX9-O3-NEXT:    s_mov_b64 s[36:37], s[30:31]
; GFX9-O3-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-O3-NEXT:    v_mov_b32_e32 v7, s9
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[30:31], -1
; GFX9-O3-NEXT:    s_getpc_b64 s[34:35]
; GFX9-O3-NEXT:    s_add_u32 s34, s34, strict_wwm_called_i64@gotpcrel32@lo+4
; GFX9-O3-NEXT:    s_addc_u32 s35, s35, strict_wwm_called_i64@gotpcrel32@hi+12
; GFX9-O3-NEXT:    s_load_dwordx2 s[34:35], s[34:35], 0x0
; GFX9-O3-NEXT:    s_mov_b64 exec, s[30:31]
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-O3-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[38:39], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v6
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-O3-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-O3-NEXT:    s_swappc_b64 s[30:31], s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O3-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v6
; GFX9-O3-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v7, vcc
; GFX9-O3-NEXT:    s_mov_b64 exec, s[38:39]
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O3-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    s_addk_i32 s32, 0xf800
; GFX9-O3-NEXT:    s_mov_b32 s33, s40
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[30:31], -1
; GFX9-O3-NEXT:    buffer_load_dword v6, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[30:31]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[36:37]
  %tmp107 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %arg, i64 0)
  %tmp134 = call amdgpu_gfx i64 @strict_wwm_called_i64(i64 %tmp107)
  %tmp136 = add i64 %tmp134, %tmp107
  %tmp137 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp136)
  %tmp138 = bitcast i64 %tmp137 to <2 x i32>
  call void @llvm.amdgcn.raw.buffer.store.v2i32(<2 x i32> %tmp138, <4 x i32> %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define amdgpu_gfx void @strict_wwm_amdgpu_cs_main(<4 x i32> inreg %desc, i32 %index) {
; GFX9-O0-LABEL: strict_wwm_amdgpu_cs_main:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    ; kill: def $sgpr40_sgpr41_sgpr42_sgpr43 killed $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s34, 5
; GFX9-O0-NEXT:    v_lshlrev_b32_e64 v0, s34, v0
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_load_dwordx4 v[10:13], v0, s[36:39], s34 offen
; GFX9-O0-NEXT:    buffer_load_dwordx2 v[3:4], v0, s[36:39], s34 offen offset:16
; GFX9-O0-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    s_mov_b32 s35, 0x7fffffff
; GFX9-O0-NEXT:    s_mov_b32 s40, -1
; GFX9-O0-NEXT:    ; kill: def $sgpr40 killed $sgpr40 def $sgpr40_sgpr41
; GFX9-O0-NEXT:    s_mov_b32 s41, s35
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s40
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s41
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s40
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s41
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v2
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v4
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s40
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s41
; GFX9-O0-NEXT:    s_not_b64 exec, exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6_vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v9
; GFX9-O0-NEXT:    buffer_store_dwordx4 v[5:8], v0, s[36:39], s34 offen
; GFX9-O0-NEXT:    buffer_store_dwordx2 v[3:4], v0, s[36:39], s34 offen offset:16
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_amdgpu_cs_main:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX9-O3-NEXT:    buffer_load_dwordx4 v[1:4], v0, s[4:7], 0 offen
; GFX9-O3-NEXT:    buffer_load_dwordx2 v[5:6], v0, s[4:7], 0 offen offset:16
; GFX9-O3-NEXT:    s_mov_b32 s34, -1
; GFX9-O3-NEXT:    s_brev_b32 s35, -2
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, s34
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, s35
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, s34
; GFX9-O3-NEXT:    v_mov_b32_e32 v4, s35
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, s34
; GFX9-O3-NEXT:    v_mov_b32_e32 v6, s35
; GFX9-O3-NEXT:    s_not_b64 exec, exec
; GFX9-O3-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-O3-NEXT:    v_mov_b32_e32 v9, v3
; GFX9-O3-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O3-NEXT:    v_mov_b32_e32 v10, v4
; GFX9-O3-NEXT:    v_mov_b32_e32 v11, v5
; GFX9-O3-NEXT:    v_mov_b32_e32 v12, v6
; GFX9-O3-NEXT:    buffer_store_dwordx4 v[7:10], v0, s[4:7], 0 offen
; GFX9-O3-NEXT:    buffer_store_dwordx2 v[11:12], v0, s[4:7], 0 offen offset:16
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %tmp17 = shl i32 %index, 5
  %tmp18 = tail call <4 x i32> @llvm.amdgcn.s.buffer.load.v4i32(<4 x i32> %desc, i32 %tmp17, i32 0)
  %.i0.upto1.bc = bitcast <4 x i32> %tmp18 to <2 x i64>
  %tmp19 = or i32 %tmp17, 16
  %tmp20 = tail call <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32> %desc, i32 %tmp19, i32 0)
  %.i0.upto1.extract = extractelement <2 x i64> %.i0.upto1.bc, i32 0
  %tmp22 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %.i0.upto1.extract, i64 9223372036854775807)
  %tmp97 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp22)
  %.i1.upto1.extract = extractelement <2 x i64> %.i0.upto1.bc, i32 1
  %tmp99 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %.i1.upto1.extract, i64 9223372036854775807)
  %tmp174 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp99)
  %.i25 = bitcast <2 x i32> %tmp20 to i64
  %tmp176 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %.i25, i64 9223372036854775807)
  %tmp251 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp176)
  %.cast = bitcast i64 %tmp97 to <2 x float>
  %.cast6 = bitcast i64 %tmp174 to <2 x float>
  %.cast7 = bitcast i64 %tmp251 to <2 x float>
  %tmp254 = shufflevector <2 x float> %.cast, <2 x float> %.cast6, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  tail call void @llvm.amdgcn.raw.buffer.store.v4f32(<4 x float> %tmp254, <4 x i32> %desc, i32 %tmp17, i32 0, i32 0)
  tail call void @llvm.amdgcn.raw.buffer.store.v2f32(<2 x float> %.cast7, <4 x i32> %desc, i32 %tmp19, i32 0, i32 0)
  ret void
}

declare i32 @llvm.amdgcn.strict.wwm.i32(i32)
declare i64 @llvm.amdgcn.strict.wwm.i64(i64)
declare i32 @llvm.amdgcn.set.inactive.i32(i32, i32)
declare i64 @llvm.amdgcn.set.inactive.i64(i64, i64)
declare i32 @llvm.amdgcn.update.dpp.i32(i32, i32, i32, i32, i32, i1)
declare <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32>, i32, i32, i32)
declare void @llvm.amdgcn.raw.buffer.store.f32(float, <4 x i32>, i32, i32, i32)
declare void @llvm.amdgcn.raw.buffer.store.i32(i32, <4 x i32>, i32, i32, i32)
declare void @llvm.amdgcn.raw.buffer.store.v2i32(<2 x i32>, <4 x i32>, i32, i32, i32)
declare void @llvm.amdgcn.raw.buffer.store.v2f32(<2 x float>, <4 x i32>, i32, i32, i32)
declare void @llvm.amdgcn.raw.buffer.store.v4f32(<4 x float>, <4 x i32>, i32, i32, i32)
declare <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32>, i32, i32)
declare <4 x i32> @llvm.amdgcn.s.buffer.load.v4i32(<4 x i32>, i32, i32)
