-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "Python",
  files = { "%.py$", "%.pyw$", "%.rpy$" },
  headers = "^#!.*[ /]python",
  comment = "#",
  block_comment = { '"""', '"""' },
  patterns = {
    { pattern = "#.*",                         type = "comment"  },
    { pattern = { '^%s*"""', '"""' },          type = "comment"  },
    { pattern = '[uUrR]%f["]',                 type = "keyword"  },
    { pattern = "class%s+()[%a_][%w_]*",       type = {"keyword", "keyword2"} },
    { pattern = { '[ruU]?"""', '"""'; '\\' },  type = "string"   },
    { pattern = { "[ruU]?'''", "'''", '\\' },  type = "string"   },
    { pattern = { '[ruU]?"', '"', '\\' },      type = "string"   },
    { pattern = { "[ruU]?'", "'", '\\' },      type = "string"   },
    { pattern = "0x[%da-fA-F]+",               type = "number"   },
    { pattern = "-?%d+[%d%.eE]*",              type = "number"   },
    { pattern = "-?%.?%d+",                    type = "number"   },
    { pattern = "[%+%-=/%*%^%%<>!~|&]",        type = "operator" },
    { pattern = "[%a_][%w_]*%f[(]",            type = "function" },
    { pattern = "[%a_][%w_]*",                 type = "symbol"   },
  },
  symbols = {
    ["class"]    = "keyword",
    ["finally"]  = "keyword",
    ["is"]       = "keyword",
    ["return"]   = "keyword",
    ["continue"] = "keyword",
    ["for"]      = "keyword",
    ["lambda"]   = "keyword",
    ["try"]      = "keyword",
    ["def"]      = "keyword",
    ["async"]    = "keyword",
    ["await"]    = "keyword",
    ["from"]     = "keyword",
    ["nonlocal"] = "keyword",
    ["while"]    = "keyword",
    ["and"]      = "keyword",
    ["global"]   = "keyword",
    ["not"]      = "keyword",
    ["with"]     = "keyword",
    ["as"]       = "keyword",
    ["elif"]     = "keyword",
    ["if"]       = "keyword",
    ["or"]       = "keyword",
    ["else"]     = "keyword",
    ["match"]    = "keyword",
    ["case"]     = "keyword",
    ["import"]   = "keyword",
    ["pass"]     = "keyword",
    ["break"]    = "keyword",
    ["except"]   = "keyword",
    ["in"]       = "keyword",
    ["del"]      = "keyword",
    ["raise"]    = "keyword",
    ["yield"]    = "keyword",
    ["assert"]   = "keyword",
    ["self"]     = "keyword2",
    ["None"]     = "literal",
    ["True"]     = "literal",
    ["False"]    = "literal",
  }
}
