/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_ms.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t47;
  double t48, t49, t52, t55, t56, t57, t58, t59;
  double t60, t63, t66, t67, t70, t71, t72, t73;
  double t78, t80, t84, tzk0;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t47 = t42 * t44 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = 0.1e1 / t23 / t22;
  t55 = 0.1e1 - 0.25e2 / 0.81e2 * t48 * t49 * t52;
  t56 = t55 * t55;
  t57 = t56 * t55;
  t58 = t48 * t47;
  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t63 = t48 * t48;
  t66 = t59 * t59;
  t67 = 0.1e1 / t66;
  t70 = 0.1e1 + 0.25e3 / 0.243e3 * t58 * t60 + 0.625e5 / 0.59049e5 * params->b * t63 * t48 * t67;
  t71 = 0.1e1 / t70;
  t72 = t57 * t71;
  t73 = params->kappa + t36 + params->c;
  t78 = params->kappa * (0.1e1 - params->kappa / t73) - t41;
  t80 = t72 * t78 + t41 + 0.1e1;
  t84 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t80);
  tzk0 = 0.2e1 * t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t47;
  double t48, t49, t52, t55, t56, t57, t58, t59;
  double t60, t63, t66, t67, t70, t71, t72, t73;
  double t78, t80, t84, tzk0;

  double t86, t90, t91, t94, t95, t96, t98, t99;
  double t100, t101, t103, t104, t105, t110, t111, t112;
  double t115, t116, t117, t118, t122, t123, t126, t127;
  double t129, t132, t135, t137, t142, tvrho0, t145, t146;
  double t147, t149, t150, t151, t152, t153, t154, t156;
  double t158, t160, t162, t163, t167, t169, t173, tvsigma0;
  double tvlapl0, t175, t176, t184, t185, t187, t191, tvtau0;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t47 = t42 * t44 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = 0.1e1 / t23 / t22;
  t55 = 0.1e1 - 0.25e2 / 0.81e2 * t48 * t49 * t52;
  t56 = t55 * t55;
  t57 = t56 * t55;
  t58 = t48 * t47;
  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t63 = t48 * t48;
  t66 = t59 * t59;
  t67 = 0.1e1 / t66;
  t70 = 0.1e1 + 0.25e3 / 0.243e3 * t58 * t60 + 0.625e5 / 0.59049e5 * params->b * t63 * t48 * t67;
  t71 = 0.1e1 / t70;
  t72 = t57 * t71;
  t73 = params->kappa + t36 + params->c;
  t78 = params->kappa * (0.1e1 - params->kappa / t73) - t41;
  t80 = t72 * t78 + t41 + 0.1e1;
  t84 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t80);
  tzk0 = 0.2e1 * t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t18 / t31;
  t90 = params->kappa * params->kappa;
  t91 = t37 * t37;
  t94 = t90 / t91 * t21;
  t95 = t25 * sigma[0];
  t96 = t30 * rho[0];
  t98 = 0.1e1 / t31 / t96;
  t99 = t28 * t98;
  t100 = t95 * t99;
  t101 = t94 * t100;
  t103 = t56 * t71;
  t104 = t103 * t78;
  t105 = t47 * t49;
  t110 = -0.5e1 / 0.3e1 * t42 * t33 + t29 * t98 / 0.3e1;
  t111 = t52 * t110;
  t112 = t105 * t111;
  t115 = t70 * t70;
  t116 = 0.1e1 / t115;
  t117 = t57 * t116;
  t118 = t48 * t60;
  t122 = params->b * t63 * t47;
  t123 = t67 * t110;
  t126 = 0.25e3 / 0.81e2 * t118 * t110 + 0.125e6 / 0.19683e5 * t122 * t123;
  t127 = t78 * t126;
  t129 = t73 * t73;
  t132 = t90 / t129 * t21;
  t135 = -0.1e2 / 0.729e3 * t132 * t100 + 0.1e2 / 0.729e3 * t101;
  t137 = -0.1e2 / 0.729e3 * t101 - 0.5e2 / 0.27e2 * t104 * t112 - t117 * t127 + t72 * t135;
  t142 = my_piecewise3(t3, 0, -t7 * t86 * t80 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t25 * t28;
  t146 = t145 * t33;
  t147 = t94 * t146;
  t149 = t78 * t47;
  t150 = t103 * t149;
  t151 = t49 * t52;
  t152 = t28 * t33;
  t153 = t151 * t152;
  t154 = t150 * t153;
  t156 = t118 * t152;
  t158 = t67 * t28;
  t160 = t122 * t158 * t33;
  t162 = -0.125e3 / 0.324e3 * t156 - 0.15625e5 / 0.19683e5 * t160;
  t163 = t78 * t162;
  t167 = 0.5e1 / 0.972e3 * t132 * t146 - 0.5e1 / 0.972e3 * t147;
  t169 = 0.5e1 / 0.972e3 * t147 + 0.25e2 / 0.108e3 * t154 - t117 * t163 + t72 * t167;
  t173 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t169);
  tvsigma0 = 0.2e1 * rho[0] * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t175 = t28 * t44;
  t176 = t151 * t175;
  t184 = 0.25e3 / 0.81e2 * t118 * t175 + 0.125e6 / 0.19683e5 * t122 * t158 * t44;
  t185 = t78 * t184;
  t187 = -0.5e2 / 0.27e2 * t150 * t176 - t117 * t185;
  t191 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t187);
  tvtau0 = 0.2e1 * rho[0] * t191;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t47;
  double t48, t49, t52, t55, t56, t57, t58, t59;
  double t60, t63, t66, t67, t70, t71, t72, t73;
  double t78, t80, t84, tzk0;

  double t86, t90, t91, t94, t95, t96, t98, t99;
  double t100, t101, t103, t104, t105, t110, t111, t112;
  double t115, t116, t117, t118, t122, t123, t126, t127;
  double t129, t132, t135, t137, t142, tvrho0, t145, t146;
  double t147, t149, t150, t151, t152, t153, t154, t156;
  double t158, t160, t162, t163, t167, t169, t173, tvsigma0;
  double tvlapl0, t175, t176, t184, t185, t187, t191, tvtau0;

  double t194, t204, t205, t206, t207, t208, t210, t211;
  double t212, t214, t216, t217, t218, t220, t221, t222;
  double t223, t225, t226, t227, t228, t231, t232, t233;
  double t234, t237, t240, t241, t248, t249, t250, t254;
  double t255, t256, t257, t260, t263, t268, t269, t275;
  double t281, t286, t288, t293, tv2rho20, t299, t300, t302;
  double t304, t306, t307, t309, t310, t311, t312, t313;
  double t314, t315, t318, t319, t321, t322, t323, t325;
  double t326, t327, t329, t330, t332, t338, t340, t342;
  double t344, t345, t348, t350, t351, t353, t356, t362;
  double t364, t369, tv2rhosigma0, tv2rholapl0, t375, t376, t380, t388;
  double t394, t402, t403, t405, t410, tv2rhotau0, t413, t415;
  double t416, t417, t419, t420, t421, t424, t425, t427;
  double t428, t429, t431, t432, t434, t435, t438, t441;
  double t443, t445, t447, t448, t452, t454, t458, tv2sigma20;
  double tv2sigmalapl0, t461, t462, t463, t464, t467, t472, t473;
  double t475, t476, t477, t478, t480, t483, t485, t488;
  double t490, t491, t493, t497, tv2sigmatau0, tv2lapl20, tv2lapltau0, t500;
  double t501, t502, t506, t509, t512, t513, t521, t522;
  double t524, t528, tv2tau20;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t47 = t42 * t44 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = 0.1e1 / t23 / t22;
  t55 = 0.1e1 - 0.25e2 / 0.81e2 * t48 * t49 * t52;
  t56 = t55 * t55;
  t57 = t56 * t55;
  t58 = t48 * t47;
  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t63 = t48 * t48;
  t66 = t59 * t59;
  t67 = 0.1e1 / t66;
  t70 = 0.1e1 + 0.25e3 / 0.243e3 * t58 * t60 + 0.625e5 / 0.59049e5 * params->b * t63 * t48 * t67;
  t71 = 0.1e1 / t70;
  t72 = t57 * t71;
  t73 = params->kappa + t36 + params->c;
  t78 = params->kappa * (0.1e1 - params->kappa / t73) - t41;
  t80 = t72 * t78 + t41 + 0.1e1;
  t84 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t80);
  tzk0 = 0.2e1 * t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t18 / t31;
  t90 = params->kappa * params->kappa;
  t91 = t37 * t37;
  t94 = t90 / t91 * t21;
  t95 = t25 * sigma[0];
  t96 = t30 * rho[0];
  t98 = 0.1e1 / t31 / t96;
  t99 = t28 * t98;
  t100 = t95 * t99;
  t101 = t94 * t100;
  t103 = t56 * t71;
  t104 = t103 * t78;
  t105 = t47 * t49;
  t110 = -0.5e1 / 0.3e1 * t42 * t33 + t29 * t98 / 0.3e1;
  t111 = t52 * t110;
  t112 = t105 * t111;
  t115 = t70 * t70;
  t116 = 0.1e1 / t115;
  t117 = t57 * t116;
  t118 = t48 * t60;
  t122 = params->b * t63 * t47;
  t123 = t67 * t110;
  t126 = 0.25e3 / 0.81e2 * t118 * t110 + 0.125e6 / 0.19683e5 * t122 * t123;
  t127 = t78 * t126;
  t129 = t73 * t73;
  t132 = t90 / t129 * t21;
  t135 = -0.1e2 / 0.729e3 * t132 * t100 + 0.1e2 / 0.729e3 * t101;
  t137 = -0.1e2 / 0.729e3 * t101 - 0.5e2 / 0.27e2 * t104 * t112 - t117 * t127 + t72 * t135;
  t142 = my_piecewise3(t3, 0, -t7 * t86 * t80 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t25 * t28;
  t146 = t145 * t33;
  t147 = t94 * t146;
  t149 = t78 * t47;
  t150 = t103 * t149;
  t151 = t49 * t52;
  t152 = t28 * t33;
  t153 = t151 * t152;
  t154 = t150 * t153;
  t156 = t118 * t152;
  t158 = t67 * t28;
  t160 = t122 * t158 * t33;
  t162 = -0.125e3 / 0.324e3 * t156 - 0.15625e5 / 0.19683e5 * t160;
  t163 = t78 * t162;
  t167 = 0.5e1 / 0.972e3 * t132 * t146 - 0.5e1 / 0.972e3 * t147;
  t169 = 0.5e1 / 0.972e3 * t147 + 0.25e2 / 0.108e3 * t154 - t117 * t163 + t72 * t167;
  t173 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t169);
  tvsigma0 = 0.2e1 * rho[0] * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t175 = t28 * t44;
  t176 = t151 * t175;
  t184 = 0.25e3 / 0.81e2 * t118 * t175 + 0.125e6 / 0.19683e5 * t122 * t158 * t44;
  t185 = t78 * t184;
  t187 = -0.5e2 / 0.27e2 * t150 * t176 - t117 * t185;
  t191 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t187);
  tvtau0 = 0.2e1 * rho[0] * t191;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t194 = t18 * t44;
  t204 = t90 / t91 / t37 * t49;
  t205 = sigma[0] * sigma[0];
  t206 = t52 * t205;
  t207 = t30 * t30;
  t208 = t207 * t96;
  t210 = 0.1e1 / t19 / t208;
  t211 = t27 * t210;
  t212 = t206 * t211;
  t214 = 0.4e3 / 0.531441e6 * t204 * t212;
  t216 = 0.1e1 / t31 / t207;
  t217 = t28 * t216;
  t218 = t95 * t217;
  t220 = 0.11e3 / 0.2187e4 * t94 * t218;
  t221 = t55 * t71;
  t222 = t221 * t78;
  t223 = t48 * t21;
  t225 = 0.1e1 / t24 / t59;
  t226 = t110 * t110;
  t227 = t225 * t226;
  t228 = t223 * t227;
  t231 = t56 * t116;
  t232 = t231 * t149;
  t233 = t110 * t126;
  t234 = t151 * t233;
  t237 = t103 * t135;
  t240 = t226 * t49;
  t241 = t240 * t52;
  t248 = 0.4e2 / 0.9e1 * t42 * t98 - 0.11e2 / 0.9e1 * t29 * t216;
  t249 = t52 * t248;
  t250 = t105 * t249;
  t254 = 0.1e1 / t115 / t70;
  t255 = t57 * t254;
  t256 = t126 * t126;
  t257 = t78 * t256;
  t260 = t135 * t126;
  t263 = t47 * t60;
  t268 = params->b * t63;
  t269 = t67 * t226;
  t275 = 0.5e3 / 0.81e2 * t263 * t226 + 0.25e3 / 0.81e2 * t118 * t248 + 0.625e6 / 0.19683e5 * t268 * t269 + 0.125e6 / 0.19683e5 * t122 * t67 * t248;
  t281 = t90 / t129 / t73 * t49;
  t286 = -0.4e3 / 0.531441e6 * t281 * t212 + 0.11e3 / 0.2187e4 * t132 * t218 + t214 - t220;
  t288 = -t214 + t220 + 0.1e5 / 0.729e3 * t222 * t228 + 0.1e3 / 0.27e2 * t232 * t234 - 0.1e3 / 0.27e2 * t237 * t112 - 0.5e2 / 0.27e2 * t104 * t241 - 0.5e2 / 0.27e2 * t104 * t250 + 0.2e1 * t255 * t257 - 0.2e1 * t117 * t260 - t117 * t78 * t275 + t72 * t286;
  t293 = my_piecewise3(t3, 0, t7 * t194 * t80 / 0.12e2 - t7 * t86 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t288);
  tv2rho20 = 0.2e1 * rho[0] * t293 + 0.4e1 * t142;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t299 = t52 * t27;
  t300 = t207 * t30;
  t302 = 0.1e1 / t19 / t300;
  t304 = t299 * t302 * sigma[0];
  t306 = 0.5e2 / 0.177147e6 * t204 * t304;
  t307 = t145 * t98;
  t309 = 0.1e2 / 0.729e3 * t94 * t307;
  t310 = t78 * t48;
  t311 = t221 * t310;
  t312 = t21 * t225;
  t313 = t152 * t110;
  t314 = t312 * t313;
  t315 = t311 * t314;
  t318 = t151 * t152 * t126;
  t319 = t232 * t318;
  t321 = t135 * t47;
  t322 = t103 * t321;
  t323 = t322 * t153;
  t325 = t78 * t110;
  t326 = t103 * t325;
  t327 = t326 * t153;
  t329 = t151 * t99;
  t330 = t150 * t329;
  t332 = t231 * t163;
  t338 = t135 * t162;
  t340 = t263 * t313;
  t342 = t118 * t99;
  t344 = t268 * t67;
  t345 = t344 * t313;
  t348 = t122 * t158 * t98;
  t350 = -0.125e3 / 0.162e3 * t340 + 0.25e3 / 0.243e3 * t342 - 0.78125e5 / 0.19683e5 * t345 + 0.125e6 / 0.59049e5 * t348;
  t351 = t78 * t350;
  t353 = t103 * t167;
  t356 = t167 * t126;
  t362 = 0.5e2 / 0.177147e6 * t281 * t304 - 0.1e2 / 0.729e3 * t132 * t307 - t306 + t309;
  t364 = t306 - t309 - 0.125e4 / 0.729e3 * t315 - 0.25e2 / 0.108e3 * t319 + 0.25e2 / 0.108e3 * t323 + 0.25e2 / 0.108e3 * t327 - 0.5e2 / 0.81e2 * t330 + 0.5e2 / 0.27e2 * t332 * t112 + 0.2e1 * t255 * t163 * t126 - t117 * t338 - t117 * t351 - 0.5e2 / 0.27e2 * t353 * t112 - t117 * t356 + t72 * t362;
  t369 = my_piecewise3(t3, 0, -t7 * t86 * t169 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t364);
  tv2rhosigma0 = 0.2e1 * rho[0] * t369 + 0.2e1 * t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t375 = t175 * t110;
  t376 = t312 * t375;
  t380 = t151 * t175 * t126;
  t388 = t231 * t185;
  t394 = t135 * t184;
  t402 = 0.5e3 / 0.81e2 * t263 * t375 - 0.125e4 / 0.243e3 * t156 + 0.625e6 / 0.19683e5 * t344 * t375 - 0.625e6 / 0.59049e5 * t160;
  t403 = t78 * t402;
  t405 = 0.1e5 / 0.729e3 * t311 * t376 + 0.5e2 / 0.27e2 * t232 * t380 - 0.5e2 / 0.27e2 * t322 * t176 - 0.5e2 / 0.27e2 * t326 * t176 + 0.25e3 / 0.81e2 * t154 + 0.5e2 / 0.27e2 * t388 * t112 + 0.2e1 * t255 * t185 * t126 - t117 * t394 - t117 * t403;
  t410 = my_piecewise3(t3, 0, -t7 * t86 * t187 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t405);
  tv2rhotau0 = 0.2e1 * rho[0] * t410 + 0.2e1 * t191;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t413 = t207 * rho[0];
  t415 = 0.1e1 / t19 / t413;
  t416 = t299 * t415;
  t417 = t204 * t416;
  t419 = t27 * t415;
  t420 = t312 * t419;
  t421 = t311 * t420;
  t424 = t151 * t152 * t162;
  t425 = t232 * t424;
  t427 = t167 * t47;
  t428 = t103 * t427;
  t429 = t428 * t153;
  t431 = t419 * t151;
  t432 = t104 * t431;
  t434 = t162 * t162;
  t435 = t78 * t434;
  t438 = t167 * t162;
  t441 = t263 * t419;
  t443 = t67 * t27;
  t445 = t268 * t443 * t415;
  t447 = 0.125e3 / 0.648e3 * t441 + 0.78125e5 / 0.78732e5 * t445;
  t448 = t78 * t447;
  t452 = -0.25e2 / 0.236196e6 * t281 * t416 + 0.25e2 / 0.236196e6 * t417;
  t454 = -0.25e2 / 0.236196e6 * t417 + 0.625e3 / 0.1458e4 * t421 - 0.25e2 / 0.54e2 * t425 + 0.25e2 / 0.54e2 * t429 - 0.25e2 / 0.432e3 * t432 + 0.2e1 * t255 * t435 - 0.2e1 * t117 * t438 - t117 * t448 + t72 * t452;
  t458 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t454);
  tv2sigma20 = 0.2e1 * rho[0] * t458;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t461 = 0.1e1 / t19 / t207;
  t462 = t27 * t461;
  t463 = t312 * t462;
  t464 = t311 * t463;
  t467 = t151 * t175 * t162;
  t472 = t462 * t151;
  t473 = t104 * t472;
  t475 = t52 * t28;
  t476 = t475 * t33;
  t477 = t105 * t476;
  t478 = t388 * t477;
  t480 = t185 * t162;
  t483 = t167 * t184;
  t485 = t263 * t462;
  t488 = t268 * t443 * t461;
  t490 = -0.125e3 / 0.81e2 * t485 - 0.15625e6 / 0.19683e5 * t488;
  t491 = t78 * t490;
  t493 = -0.25e4 / 0.729e3 * t464 + 0.5e2 / 0.27e2 * t232 * t467 - 0.5e2 / 0.27e2 * t428 * t176 + 0.25e2 / 0.54e2 * t473 - 0.25e2 / 0.108e3 * t478 + 0.2e1 * t255 * t480 - t117 * t483 - t117 * t491;
  t497 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t493);
  tv2sigmatau0 = 0.2e1 * rho[0] * t497;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t500 = 0.1e1 / t19 / t96;
  t501 = t27 * t500;
  t502 = t312 * t501;
  t506 = t151 * t175 * t184;
  t509 = t501 * t151;
  t512 = t184 * t184;
  t513 = t78 * t512;
  t521 = 0.1e4 / 0.81e2 * t263 * t501 + 0.125e7 / 0.19683e5 * t268 * t443 * t500;
  t522 = t78 * t521;
  t524 = 0.2e5 / 0.729e3 * t311 * t502 + 0.1e3 / 0.27e2 * t232 * t506 - 0.1e3 / 0.27e2 * t104 * t509 + 0.2e1 * t255 * t513 - t117 * t522;
  t528 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t524);
  tv2tau20 = 0.2e1 * rho[0] * t528;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t47;
  double t48, t49, t52, t55, t56, t57, t58, t59;
  double t60, t63, t66, t67, t70, t71, t72, t73;
  double t78, t80, t84, tzk0;

  double t86, t90, t91, t94, t95, t96, t98, t99;
  double t100, t101, t103, t104, t105, t110, t111, t112;
  double t115, t116, t117, t118, t122, t123, t126, t127;
  double t129, t132, t135, t137, t142, tvrho0, t145, t146;
  double t147, t149, t150, t151, t152, t153, t154, t156;
  double t158, t160, t162, t163, t167, t169, t173, tvsigma0;
  double tvlapl0, t175, t176, t184, t185, t187, t191, tvtau0;

  double t194, t204, t205, t206, t207, t208, t210, t211;
  double t212, t214, t216, t217, t218, t220, t221, t222;
  double t223, t225, t226, t227, t228, t231, t232, t233;
  double t234, t237, t240, t241, t248, t249, t250, t254;
  double t255, t256, t257, t260, t263, t268, t269, t275;
  double t281, t286, t288, t293, tv2rho20, t299, t300, t302;
  double t304, t306, t307, t309, t310, t311, t312, t313;
  double t314, t315, t318, t319, t321, t322, t323, t325;
  double t326, t327, t329, t330, t332, t338, t340, t342;
  double t344, t345, t348, t350, t351, t353, t356, t362;
  double t364, t369, tv2rhosigma0, tv2rholapl0, t375, t376, t380, t388;
  double t394, t402, t403, t405, t410, tv2rhotau0, t413, t415;
  double t416, t417, t419, t420, t421, t424, t425, t427;
  double t428, t429, t431, t432, t434, t435, t438, t441;
  double t443, t445, t447, t448, t452, t454, t458, tv2sigma20;
  double tv2sigmalapl0, t461, t462, t463, t464, t467, t472, t473;
  double t475, t476, t477, t478, t480, t483, t485, t488;
  double t490, t491, t493, t497, tv2sigmatau0, tv2lapl20, tv2lapltau0, t500;
  double t501, t502, t506, t509, t512, t513, t521, t522;
  double t524, t528, tv2tau20;

  double t531, t541, t542, t544, t547, t548, t550, t553;
  double t554, t557, t561, t565, t568, t573, t574, t580;
  double t583, t584, t585, t588, t590, t592, t594, t595;
  double t596, t598, t599, t600, t601, t603, t606, t607;
  double t608, t611, t617, t619, t620, t621, t622, t623;
  double t624, t626, t627, t628, t632, t641, t651, t652;
  double t654, t656, t663, t667, t668, t669, t670, t671;
  double t674, t677, t680, t681, t686, tv3rho30, t696, t698;
  double t699, t700, t702, t703, t704, t706, t708, t709;
  double t711, t712, t713, t715, t718, t723, t727, t730;
  double t731, t732, t733, t734, t735, t736, t738, t739;
  double t740, t741, t743, t744, t745, t748, t749, t752;
  double t753, t755, t757, t760, t761, t762, t764, t765;
  double t766, t768, t770, t771, t773, t776, t777, t779;
  double t784, t787, t788, t789, t790, t793, t795, t797;
  double t800, t802, t803, t808, t812, t814, t815, t817;
  double t820, t821, t823, t825, t827, t829, t830, t832;
  double t834, t837, t839, t840, t848, t867, t869, t874;
  double tv3rho2sigma0, tv3rho2lapl0, t884, t893, t896, t904, t906, t910;
  double t913, t914, t917, t922, t923, t924, t932, t938;
  double t941, t944, t946, t961, t962, t976, t977, t982;
  double tv3rho2tau0, t988, t990, t991, t992, t993, t994, t995;
  double t997, t998, t999, t1001, t1002, t1003, t1006, t1007;
  double t1009, t1010, t1011, t1013, t1015, t1018, t1019, t1021;
  double t1024, t1025, t1027, t1028, t1029, t1030, t1033, t1037;
  double t1039, t1040, t1042, t1043, t1044, t1046, t1048, t1051;
  double t1052, t1053, t1055, t1058, t1060, t1061, t1062, t1064;
  double t1066, t1069, t1071, t1072, t1074, t1076, t1079, t1094;
  double t1095, t1097, t1099, t1100, t1101, t1103, t1104, t1105;
  double t1107, t1108, t1109, t1110, t1111, t1113, t1116, t1119;
  double t1122, t1123, t1128, tv3rhosigma20, tv3rhosigmalapl0, t1136, t1138, t1141;
  double t1142, t1143, t1145, t1146, t1147, t1150, t1153, t1154;
  double t1156, t1157, t1158, t1162, t1163, t1165, t1166, t1167;
  double t1174, t1181, t1183, t1184, t1185, t1187, t1190, t1191;
  double t1192, t1194, t1197, t1199, t1202, t1205, t1206, t1208;
  double t1210, t1227, t1228, t1229, t1236, t1237, t1238, t1240;
  double t1243, t1246, t1248, t1249, t1254, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0;
  double t1260, t1264, t1269, t1270, t1274, t1276, t1280, t1289;
  double t1292, t1293, t1294, t1300, t1306, t1312, t1318, t1326;
  double t1327, t1329, t1330, t1335, tv3rhotau20, t1338, t1339, t1340;
  double t1342, t1345, t1348, t1352, t1353, t1355, t1356, t1360;
  double t1362, t1364, t1366, t1367, t1370, t1373, t1376, t1377;
  double t1380, t1381, t1383, t1385, t1386, t1387, t1389, t1390;
  double t1391, t1394, t1395, t1397, t1399, t1400, t1401, t1403;
  double t1407, tv3sigma30, tv3sigma2lapl0, t1409, t1410, t1412, t1414, t1417;
  double t1420, t1423, t1426, t1428, t1429, t1433, t1435, t1437;
  double t1440, t1441, t1443, t1444, t1446, t1447, t1449, t1451;
  double t1453, t1455, t1456, t1459, t1460, t1465, t1469, t1472;
  double t1474, t1475, t1476, t1478, t1480, t1481, t1485, tv3sigma2tau0;
  double tv3sigmalapl20, tv3sigmalapltau0, t1487, t1488, t1490, t1493, t1498, t1499;
  double t1500, t1503, t1504, t1507, t1512, t1513, t1514, t1517;
  double t1520, t1525, t1530, t1536, t1541, t1543, t1545, t1546;
  double t1548, t1549, t1551, t1555, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t1557, t1558, t1563, t1566, t1567, t1571, t1574, t1578;
  double t1581, t1582, t1585, t1590, t1593, t1594, t1596, t1600;
  double tv3tau30;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t47 = t42 * t44 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = 0.1e1 / t23 / t22;
  t55 = 0.1e1 - 0.25e2 / 0.81e2 * t48 * t49 * t52;
  t56 = t55 * t55;
  t57 = t56 * t55;
  t58 = t48 * t47;
  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t63 = t48 * t48;
  t66 = t59 * t59;
  t67 = 0.1e1 / t66;
  t70 = 0.1e1 + 0.25e3 / 0.243e3 * t58 * t60 + 0.625e5 / 0.59049e5 * params->b * t63 * t48 * t67;
  t71 = 0.1e1 / t70;
  t72 = t57 * t71;
  t73 = params->kappa + t36 + params->c;
  t78 = params->kappa * (0.1e1 - params->kappa / t73) - t41;
  t80 = t72 * t78 + t41 + 0.1e1;
  t84 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t80);
  tzk0 = 0.2e1 * t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t18 / t31;
  t90 = params->kappa * params->kappa;
  t91 = t37 * t37;
  t94 = t90 / t91 * t21;
  t95 = t25 * sigma[0];
  t96 = t30 * rho[0];
  t98 = 0.1e1 / t31 / t96;
  t99 = t28 * t98;
  t100 = t95 * t99;
  t101 = t94 * t100;
  t103 = t56 * t71;
  t104 = t103 * t78;
  t105 = t47 * t49;
  t110 = -0.5e1 / 0.3e1 * t42 * t33 + t29 * t98 / 0.3e1;
  t111 = t52 * t110;
  t112 = t105 * t111;
  t115 = t70 * t70;
  t116 = 0.1e1 / t115;
  t117 = t57 * t116;
  t118 = t48 * t60;
  t122 = params->b * t63 * t47;
  t123 = t67 * t110;
  t126 = 0.25e3 / 0.81e2 * t118 * t110 + 0.125e6 / 0.19683e5 * t122 * t123;
  t127 = t78 * t126;
  t129 = t73 * t73;
  t132 = t90 / t129 * t21;
  t135 = -0.1e2 / 0.729e3 * t132 * t100 + 0.1e2 / 0.729e3 * t101;
  t137 = -0.1e2 / 0.729e3 * t101 - 0.5e2 / 0.27e2 * t104 * t112 - t117 * t127 + t72 * t135;
  t142 = my_piecewise3(t3, 0, -t7 * t86 * t80 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t25 * t28;
  t146 = t145 * t33;
  t147 = t94 * t146;
  t149 = t78 * t47;
  t150 = t103 * t149;
  t151 = t49 * t52;
  t152 = t28 * t33;
  t153 = t151 * t152;
  t154 = t150 * t153;
  t156 = t118 * t152;
  t158 = t67 * t28;
  t160 = t122 * t158 * t33;
  t162 = -0.125e3 / 0.324e3 * t156 - 0.15625e5 / 0.19683e5 * t160;
  t163 = t78 * t162;
  t167 = 0.5e1 / 0.972e3 * t132 * t146 - 0.5e1 / 0.972e3 * t147;
  t169 = 0.5e1 / 0.972e3 * t147 + 0.25e2 / 0.108e3 * t154 - t117 * t163 + t72 * t167;
  t173 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t169);
  tvsigma0 = 0.2e1 * rho[0] * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t175 = t28 * t44;
  t176 = t151 * t175;
  t184 = 0.25e3 / 0.81e2 * t118 * t175 + 0.125e6 / 0.19683e5 * t122 * t158 * t44;
  t185 = t78 * t184;
  t187 = -0.5e2 / 0.27e2 * t150 * t176 - t117 * t185;
  t191 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t187);
  tvtau0 = 0.2e1 * rho[0] * t191;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t194 = t18 * t44;
  t204 = t90 / t91 / t37 * t49;
  t205 = sigma[0] * sigma[0];
  t206 = t52 * t205;
  t207 = t30 * t30;
  t208 = t207 * t96;
  t210 = 0.1e1 / t19 / t208;
  t211 = t27 * t210;
  t212 = t206 * t211;
  t214 = 0.4e3 / 0.531441e6 * t204 * t212;
  t216 = 0.1e1 / t31 / t207;
  t217 = t28 * t216;
  t218 = t95 * t217;
  t220 = 0.11e3 / 0.2187e4 * t94 * t218;
  t221 = t55 * t71;
  t222 = t221 * t78;
  t223 = t48 * t21;
  t225 = 0.1e1 / t24 / t59;
  t226 = t110 * t110;
  t227 = t225 * t226;
  t228 = t223 * t227;
  t231 = t56 * t116;
  t232 = t231 * t149;
  t233 = t110 * t126;
  t234 = t151 * t233;
  t237 = t103 * t135;
  t240 = t226 * t49;
  t241 = t240 * t52;
  t248 = 0.4e2 / 0.9e1 * t42 * t98 - 0.11e2 / 0.9e1 * t29 * t216;
  t249 = t52 * t248;
  t250 = t105 * t249;
  t254 = 0.1e1 / t115 / t70;
  t255 = t57 * t254;
  t256 = t126 * t126;
  t257 = t78 * t256;
  t260 = t135 * t126;
  t263 = t47 * t60;
  t268 = params->b * t63;
  t269 = t67 * t226;
  t275 = 0.5e3 / 0.81e2 * t263 * t226 + 0.25e3 / 0.81e2 * t118 * t248 + 0.625e6 / 0.19683e5 * t268 * t269 + 0.125e6 / 0.19683e5 * t122 * t67 * t248;
  t281 = t90 / t129 / t73 * t49;
  t286 = -0.4e3 / 0.531441e6 * t281 * t212 + 0.11e3 / 0.2187e4 * t132 * t218 + t214 - t220;
  t288 = -t214 + t220 + 0.1e5 / 0.729e3 * t222 * t228 + 0.1e3 / 0.27e2 * t232 * t234 - 0.1e3 / 0.27e2 * t237 * t112 - 0.5e2 / 0.27e2 * t104 * t241 - 0.5e2 / 0.27e2 * t104 * t250 + 0.2e1 * t255 * t257 - 0.2e1 * t117 * t260 - t117 * t78 * t275 + t72 * t286;
  t293 = my_piecewise3(t3, 0, t7 * t194 * t80 / 0.12e2 - t7 * t86 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t288);
  tv2rho20 = 0.2e1 * rho[0] * t293 + 0.4e1 * t142;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t299 = t52 * t27;
  t300 = t207 * t30;
  t302 = 0.1e1 / t19 / t300;
  t304 = t299 * t302 * sigma[0];
  t306 = 0.5e2 / 0.177147e6 * t204 * t304;
  t307 = t145 * t98;
  t309 = 0.1e2 / 0.729e3 * t94 * t307;
  t310 = t78 * t48;
  t311 = t221 * t310;
  t312 = t21 * t225;
  t313 = t152 * t110;
  t314 = t312 * t313;
  t315 = t311 * t314;
  t318 = t151 * t152 * t126;
  t319 = t232 * t318;
  t321 = t135 * t47;
  t322 = t103 * t321;
  t323 = t322 * t153;
  t325 = t78 * t110;
  t326 = t103 * t325;
  t327 = t326 * t153;
  t329 = t151 * t99;
  t330 = t150 * t329;
  t332 = t231 * t163;
  t338 = t135 * t162;
  t340 = t263 * t313;
  t342 = t118 * t99;
  t344 = t268 * t67;
  t345 = t344 * t313;
  t348 = t122 * t158 * t98;
  t350 = -0.125e3 / 0.162e3 * t340 + 0.25e3 / 0.243e3 * t342 - 0.78125e5 / 0.19683e5 * t345 + 0.125e6 / 0.59049e5 * t348;
  t351 = t78 * t350;
  t353 = t103 * t167;
  t356 = t167 * t126;
  t362 = 0.5e2 / 0.177147e6 * t281 * t304 - 0.1e2 / 0.729e3 * t132 * t307 - t306 + t309;
  t364 = t306 - t309 - 0.125e4 / 0.729e3 * t315 - 0.25e2 / 0.108e3 * t319 + 0.25e2 / 0.108e3 * t323 + 0.25e2 / 0.108e3 * t327 - 0.5e2 / 0.81e2 * t330 + 0.5e2 / 0.27e2 * t332 * t112 + 0.2e1 * t255 * t163 * t126 - t117 * t338 - t117 * t351 - 0.5e2 / 0.27e2 * t353 * t112 - t117 * t356 + t72 * t362;
  t369 = my_piecewise3(t3, 0, -t7 * t86 * t169 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t364);
  tv2rhosigma0 = 0.2e1 * rho[0] * t369 + 0.2e1 * t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t375 = t175 * t110;
  t376 = t312 * t375;
  t380 = t151 * t175 * t126;
  t388 = t231 * t185;
  t394 = t135 * t184;
  t402 = 0.5e3 / 0.81e2 * t263 * t375 - 0.125e4 / 0.243e3 * t156 + 0.625e6 / 0.19683e5 * t344 * t375 - 0.625e6 / 0.59049e5 * t160;
  t403 = t78 * t402;
  t405 = 0.1e5 / 0.729e3 * t311 * t376 + 0.5e2 / 0.27e2 * t232 * t380 - 0.5e2 / 0.27e2 * t322 * t176 - 0.5e2 / 0.27e2 * t326 * t176 + 0.25e3 / 0.81e2 * t154 + 0.5e2 / 0.27e2 * t388 * t112 + 0.2e1 * t255 * t185 * t126 - t117 * t394 - t117 * t403;
  t410 = my_piecewise3(t3, 0, -t7 * t86 * t187 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t405);
  tv2rhotau0 = 0.2e1 * rho[0] * t410 + 0.2e1 * t191;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t413 = t207 * rho[0];
  t415 = 0.1e1 / t19 / t413;
  t416 = t299 * t415;
  t417 = t204 * t416;
  t419 = t27 * t415;
  t420 = t312 * t419;
  t421 = t311 * t420;
  t424 = t151 * t152 * t162;
  t425 = t232 * t424;
  t427 = t167 * t47;
  t428 = t103 * t427;
  t429 = t428 * t153;
  t431 = t419 * t151;
  t432 = t104 * t431;
  t434 = t162 * t162;
  t435 = t78 * t434;
  t438 = t167 * t162;
  t441 = t263 * t419;
  t443 = t67 * t27;
  t445 = t268 * t443 * t415;
  t447 = 0.125e3 / 0.648e3 * t441 + 0.78125e5 / 0.78732e5 * t445;
  t448 = t78 * t447;
  t452 = -0.25e2 / 0.236196e6 * t281 * t416 + 0.25e2 / 0.236196e6 * t417;
  t454 = -0.25e2 / 0.236196e6 * t417 + 0.625e3 / 0.1458e4 * t421 - 0.25e2 / 0.54e2 * t425 + 0.25e2 / 0.54e2 * t429 - 0.25e2 / 0.432e3 * t432 + 0.2e1 * t255 * t435 - 0.2e1 * t117 * t438 - t117 * t448 + t72 * t452;
  t458 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t454);
  tv2sigma20 = 0.2e1 * rho[0] * t458;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t461 = 0.1e1 / t19 / t207;
  t462 = t27 * t461;
  t463 = t312 * t462;
  t464 = t311 * t463;
  t467 = t151 * t175 * t162;
  t472 = t462 * t151;
  t473 = t104 * t472;
  t475 = t52 * t28;
  t476 = t475 * t33;
  t477 = t105 * t476;
  t478 = t388 * t477;
  t480 = t185 * t162;
  t483 = t167 * t184;
  t485 = t263 * t462;
  t488 = t268 * t443 * t461;
  t490 = -0.125e3 / 0.81e2 * t485 - 0.15625e6 / 0.19683e5 * t488;
  t491 = t78 * t490;
  t493 = -0.25e4 / 0.729e3 * t464 + 0.5e2 / 0.27e2 * t232 * t467 - 0.5e2 / 0.27e2 * t428 * t176 + 0.25e2 / 0.54e2 * t473 - 0.25e2 / 0.108e3 * t478 + 0.2e1 * t255 * t480 - t117 * t483 - t117 * t491;
  t497 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t493);
  tv2sigmatau0 = 0.2e1 * rho[0] * t497;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t500 = 0.1e1 / t19 / t96;
  t501 = t27 * t500;
  t502 = t312 * t501;
  t506 = t151 * t175 * t184;
  t509 = t501 * t151;
  t512 = t184 * t184;
  t513 = t78 * t512;
  t521 = 0.1e4 / 0.81e2 * t263 * t501 + 0.125e7 / 0.19683e5 * t268 * t443 * t500;
  t522 = t78 * t521;
  t524 = 0.2e5 / 0.729e3 * t311 * t502 + 0.1e3 / 0.27e2 * t232 * t506 - 0.1e3 / 0.27e2 * t104 * t509 + 0.2e1 * t255 * t513 - t117 * t522;
  t528 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t524);
  tv2tau20 = 0.2e1 * rho[0] * t528;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t531 = t18 * t33;
  t541 = t56 * t254;
  t542 = t541 * t149;
  t544 = t151 * t110 * t256;
  t547 = t55 * t116;
  t548 = t547 * t310;
  t550 = t312 * t226 * t126;
  t553 = t110 * t248;
  t554 = t312 * t553;
  t557 = t231 * t321;
  t561 = t151 * t248 * t126;
  t565 = t151 * t110 * t275;
  t568 = t103 * t286;
  t573 = t110 * t49;
  t574 = t573 * t249;
  t580 = 0.1e1 / t31 / t413;
  t583 = -0.44e3 / 0.27e2 * t42 * t216 + 0.154e3 / 0.27e2 * t29 * t580;
  t584 = t52 * t583;
  t585 = t105 * t584;
  t588 = t207 * t207;
  t590 = 0.1e1 / t19 / t588;
  t592 = t206 * t27 * t590;
  t594 = 0.44e4 / 0.531441e6 * t204 * t592;
  t595 = t28 * t580;
  t596 = t95 * t595;
  t598 = 0.154e4 / 0.6561e4 * t94 * t596;
  t599 = -0.1e3 / 0.9e1 * t542 * t544 - 0.1e5 / 0.243e3 * t548 * t550 + 0.1e5 / 0.243e3 * t311 * t554 + 0.1e3 / 0.9e1 * t557 * t234 + 0.5e2 / 0.9e1 * t232 * t561 + 0.5e2 / 0.9e1 * t232 * t565 - 0.5e2 / 0.9e1 * t568 * t112 - 0.5e2 / 0.9e1 * t237 * t250 - 0.5e2 / 0.9e1 * t104 * t574 - 0.5e2 / 0.27e2 * t104 * t585 + t594 - t598;
  t600 = t47 * t21;
  t601 = t226 * t110;
  t603 = t600 * t225 * t601;
  t606 = t231 * t78;
  t607 = t52 * t126;
  t608 = t240 * t607;
  t611 = t221 * t135;
  t617 = t91 * t91;
  t619 = t90 / t617;
  t620 = t205 * sigma[0];
  t621 = t60 * t620;
  t622 = t588 * t96;
  t623 = 0.1e1 / t622;
  t624 = t621 * t623;
  t626 = 0.16e5 / 0.43046721e8 * t619 * t624;
  t627 = t58 * t67;
  t628 = t601 * t71;
  t632 = t135 * t275;
  t641 = params->b * t58;
  t651 = 0.5e3 / 0.81e2 * t601 * t60 + 0.5e3 / 0.27e2 * t263 * t553 + 0.25e3 / 0.81e2 * t118 * t583 + 0.25e7 / 0.19683e5 * t641 * t67 * t601 + 0.625e6 / 0.6561e4 * t268 * t123 * t248 + 0.125e6 / 0.19683e5 * t122 * t67 * t583;
  t652 = t78 * t651;
  t654 = t129 * t129;
  t656 = t90 / t654;
  t663 = -0.16e5 / 0.43046721e8 * t656 * t624 + 0.44e4 / 0.531441e6 * t281 * t592 - 0.154e4 / 0.6561e4 * t132 * t596 + t626 - t594 + t598;
  t667 = t115 * t115;
  t668 = 0.1e1 / t667;
  t669 = t57 * t668;
  t670 = t256 * t126;
  t671 = t78 * t670;
  t674 = t135 * t256;
  t677 = t286 * t126;
  t680 = 0.1e5 / 0.243e3 * t222 * t603 + 0.5e2 / 0.9e1 * t606 * t608 + 0.1e5 / 0.243e3 * t611 * t228 + 0.6e1 * t255 * t127 * t275 - t626 - 0.1e7 / 0.19683e5 * t627 * t628 * t78 - 0.3e1 * t117 * t632 - t117 * t652 + t72 * t663 - 0.5e2 / 0.9e1 * t237 * t241 - 0.6e1 * t669 * t671 + 0.6e1 * t255 * t674 - 0.3e1 * t117 * t677;
  t681 = t599 + t680;
  t686 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t531 * t80 + t7 * t194 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t86 * t288 - 0.3e1 / 0.8e1 * t7 * t20 * t681);
  tv3rho30 = 0.2e1 * rho[0] * t686 + 0.6e1 * t293;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t696 = t322 * t329;
  t698 = t286 * t47;
  t699 = t103 * t698;
  t700 = t699 * t153;
  t702 = t135 * t110;
  t703 = t103 * t702;
  t704 = t703 * t153;
  t706 = t326 * t329;
  t708 = t151 * t217;
  t709 = t150 * t708;
  t711 = t78 * t248;
  t712 = t103 * t711;
  t713 = t712 * t153;
  t715 = t231 * t338;
  t718 = t231 * t351;
  t723 = t547 * t163;
  t727 = t231 * t427;
  t730 = t310 * t21;
  t731 = t547 * t730;
  t732 = t225 * t28;
  t733 = t33 * t110;
  t734 = t733 * t126;
  t735 = t732 * t734;
  t736 = t731 * t735;
  t738 = t221 * t149;
  t739 = t152 * t226;
  t740 = t312 * t739;
  t741 = t738 * t740;
  t743 = t99 * t110;
  t744 = t312 * t743;
  t745 = t311 * t744;
  t748 = t151 * t152 * t256;
  t749 = t542 * t748;
  t752 = t151 * t99 * t126;
  t753 = t232 * t752;
  t755 = t541 * t163;
  t757 = t105 * t111 * t126;
  t760 = t135 * t48;
  t761 = t221 * t760;
  t762 = t761 * t314;
  t764 = t152 * t248;
  t765 = t312 * t764;
  t766 = t311 * t765;
  t768 = t557 * t318;
  t770 = t231 * t325;
  t771 = t770 * t318;
  t773 = 0.1e3 / 0.27e2 * t727 * t234 + 0.25e4 / 0.729e3 * t736 - 0.125e4 / 0.243e3 * t741 + 0.2e5 / 0.2187e4 * t745 + 0.25e2 / 0.54e2 * t749 + 0.1e3 / 0.81e2 * t753 - 0.2e3 / 0.27e2 * t755 * t757 - 0.25e4 / 0.729e3 * t762 - 0.125e4 / 0.729e3 * t766 - 0.25e2 / 0.54e2 * t768 - 0.25e2 / 0.54e2 * t771;
  t776 = t151 * t152 * t275;
  t777 = t232 * t776;
  t779 = t103 * t362;
  t784 = t221 * t167;
  t787 = t627 * t226;
  t788 = t71 * t78;
  t789 = t788 * t152;
  t790 = t787 * t789;
  t793 = t299 * t210 * sigma[0];
  t795 = 0.5e2 / 0.19683e5 * t204 * t793;
  t797 = t162 * t226 * t151;
  t800 = t588 * t30;
  t802 = t60 / t800;
  t803 = t802 * t205;
  t808 = t145 * t216;
  t812 = 0.2e4 / 0.14348907e8 * t619 * t803;
  t814 = 0.11e3 / 0.2187e4 * t94 * t808;
  t815 = 0.2e4 / 0.14348907e8 * t656 * t803 - 0.5e2 / 0.19683e5 * t281 * t793 + 0.11e3 / 0.2187e4 * t132 * t808 - t812 + t795 - t814;
  t817 = t135 * t350;
  t820 = t226 * t60;
  t821 = t820 * t152;
  t823 = t263 * t743;
  t825 = t263 * t764;
  t827 = t118 * t217;
  t829 = t641 * t67;
  t830 = t829 * t739;
  t832 = t344 * t743;
  t834 = t344 * t764;
  t837 = t122 * t158 * t216;
  t839 = -0.125e3 / 0.162e3 * t821 + 0.1e4 / 0.243e3 * t823 - 0.125e3 / 0.162e3 * t825 - 0.275e4 / 0.729e3 * t827 - 0.3125e6 / 0.19683e5 * t830 + 0.125e7 / 0.59049e5 * t832 - 0.78125e5 / 0.19683e5 * t834 - 0.1375e7 / 0.177147e6 * t837;
  t840 = t78 * t839;
  t848 = t286 * t162;
  t867 = -0.2e1 * t117 * t362 * t126 - t117 * t167 * t275 - t117 * t848 + 0.2e1 * t255 * t167 * t256 - 0.6e1 * t669 * t163 * t256 + t812 + 0.4e1 * t255 * t338 * t126 + 0.4e1 * t255 * t351 * t126 + 0.2e1 * t255 * t163 * t275 - 0.5e2 / 0.27e2 * t353 * t241 + t814;
  t869 = -0.1e3 / 0.81e2 * t696 + 0.25e2 / 0.108e3 * t700 + 0.25e2 / 0.54e2 * t704 - 0.1e3 / 0.81e2 * t706 + 0.55e3 / 0.243e3 * t709 + 0.25e2 / 0.108e3 * t713 + 0.1e3 / 0.27e2 * t715 * t112 + 0.1e3 / 0.27e2 * t718 * t112 + 0.5e2 / 0.27e2 * t332 * t250 - 0.1e5 / 0.729e3 * t723 * t228 + t773 - 0.25e2 / 0.108e3 * t777 - 0.1e3 / 0.27e2 * t779 * t112 - 0.5e2 / 0.27e2 * t353 * t250 + 0.1e5 / 0.729e3 * t784 * t228 + 0.125e6 / 0.19683e5 * t790 - t795 + 0.5e2 / 0.27e2 * t606 * t797 + t72 * t815 - 0.2e1 * t117 * t817 - t117 * t840 + t867;
  t874 = my_piecewise3(t3, 0, t7 * t194 * t169 / 0.12e2 - t7 * t86 * t364 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t869);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t874 + 0.4e1 * t369;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t884 = t547 * t185;
  t893 = t231 * t394;
  t896 = t231 * t403;
  t904 = t44 * t110;
  t906 = t732 * t904 * t126;
  t910 = t151 * t175 * t256;
  t913 = t175 * t226;
  t914 = t312 * t913;
  t917 = t541 * t185;
  t922 = -0.1e5 / 0.729e3 * t884 * t228 - 0.5e2 / 0.27e2 * t699 * t176 - 0.1e3 / 0.27e2 * t703 * t176 - 0.5e2 / 0.27e2 * t712 * t176 + 0.1e3 / 0.27e2 * t893 * t112 + 0.1e3 / 0.27e2 * t896 * t112 + 0.5e2 / 0.27e2 * t388 * t250 + 0.5e3 / 0.81e2 * t323 + 0.5e3 / 0.81e2 * t327 - 0.2e4 / 0.243e3 * t330 - 0.2e5 / 0.729e3 * t731 * t906 - 0.1e3 / 0.27e2 * t542 * t910 + 0.1e5 / 0.243e3 * t738 * t914 - 0.2e3 / 0.27e2 * t917 * t757 + 0.2e5 / 0.729e3 * t761 * t376;
  t923 = t175 * t248;
  t924 = t312 * t923;
  t932 = t151 * t175 * t275;
  t938 = t184 * t226 * t151;
  t941 = t788 * t175;
  t944 = t286 * t184;
  t946 = t135 * t402;
  t961 = 0.5e3 / 0.81e2 * t820 * t175 - 0.5e4 / 0.243e3 * t340 + 0.5e3 / 0.81e2 * t263 * t923 + 0.1e5 / 0.729e3 * t342 + 0.25e7 / 0.19683e5 * t829 * t913 - 0.625e7 / 0.59049e5 * t345 + 0.625e6 / 0.19683e5 * t344 * t923 + 0.5e7 / 0.177147e6 * t348;
  t962 = t78 * t961;
  t976 = 0.1e5 / 0.729e3 * t311 * t924 + 0.1e3 / 0.27e2 * t557 * t380 + 0.1e3 / 0.27e2 * t770 * t380 + 0.5e2 / 0.27e2 * t232 * t932 - 0.1e6 / 0.2187e4 * t315 - 0.5e3 / 0.81e2 * t319 + 0.5e2 / 0.27e2 * t606 * t938 - 0.1e7 / 0.19683e5 * t787 * t941 - t117 * t944 - 0.2e1 * t117 * t946 - t117 * t962 + 0.2e1 * t255 * t185 * t275 + 0.4e1 * t255 * t394 * t126 + 0.4e1 * t255 * t403 * t126 - 0.6e1 * t669 * t185 * t256;
  t977 = t922 + t976;
  t982 = my_piecewise3(t3, 0, t7 * t194 * t187 / 0.12e2 - t7 * t86 * t405 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t977);
  tv3rho2tau0 = 0.2e1 * rho[0] * t982 + 0.4e1 * t410;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t988 = t428 * t329;
  t990 = t149 * t49;
  t991 = t541 * t990;
  t992 = t33 * t162;
  t993 = t992 * t126;
  t994 = t475 * t993;
  t995 = t991 * t994;
  t997 = t992 * t110;
  t998 = t732 * t997;
  t999 = t731 * t998;
  t1001 = t167 * t48;
  t1002 = t221 * t1001;
  t1003 = t1002 * t314;
  t1006 = t312 * t419 * t126;
  t1007 = t548 * t1006;
  t1009 = t419 * t110;
  t1010 = t312 * t1009;
  t1011 = t738 * t1010;
  t1013 = t557 * t424;
  t1015 = t770 * t424;
  t1018 = t151 * t152 * t350;
  t1019 = t232 * t1018;
  t1021 = t727 * t318;
  t1024 = t151 * t99 * t162;
  t1025 = t232 * t1024;
  t1027 = t588 * rho[0];
  t1028 = 0.1e1 / t1027;
  t1029 = t60 * t1028;
  t1030 = t1029 * sigma[0];
  t1033 = t299 * t302;
  t1037 = 0.25e3 / 0.4782969e7 * t619 * t1030;
  t1039 = 0.1e3 / 0.177147e6 * t204 * t1033;
  t1040 = -0.25e3 / 0.4782969e7 * t656 * t1030 + 0.1e3 / 0.177147e6 * t281 * t1033 + t1037 - t1039;
  t1042 = t627 * t110;
  t1043 = t788 * t419;
  t1044 = t1042 * t1043;
  t1046 = t237 * t431;
  t1048 = t103 * t452;
  t1051 = t27 * t302;
  t1052 = t1051 * t151;
  t1053 = t104 * t1052;
  t1055 = t167 * t350;
  t1058 = t135 * t447;
  t1060 = -0.1e3 / 0.81e2 * t988 + 0.25e2 / 0.27e2 * t995 + 0.25e4 / 0.729e3 * t999 - 0.25e4 / 0.729e3 * t1003 - 0.625e3 / 0.1458e4 * t1007 + 0.625e3 / 0.486e3 * t1011 - 0.25e2 / 0.54e2 * t1013 - 0.25e2 / 0.54e2 * t1015 - 0.25e2 / 0.54e2 * t1019 - 0.25e2 / 0.54e2 * t1021 + 0.1e3 / 0.81e2 * t1025 + t72 * t1040 - 0.3125e5 / 0.19683e5 * t1044 - 0.25e2 / 0.432e3 * t1046 - 0.5e2 / 0.27e2 * t1048 * t112 + 0.25e2 / 0.81e2 * t1053 - 0.2e1 * t117 * t1055 - t117 * t1058;
  t1061 = t110 * t60;
  t1062 = t1061 * t419;
  t1064 = t263 * t1051;
  t1066 = t829 * t1009;
  t1069 = t268 * t443 * t302;
  t1071 = 0.125e3 / 0.648e3 * t1062 - 0.25e3 / 0.243e3 * t1064 + 0.78125e5 / 0.19683e5 * t1066 - 0.3125e6 / 0.59049e5 * t1069;
  t1072 = t78 * t1071;
  t1074 = t452 * t126;
  t1076 = t135 * t434;
  t1079 = t362 * t162;
  t1094 = t312 * t1051;
  t1095 = t311 * t1094;
  t1097 = t761 * t420;
  t1099 = t362 * t47;
  t1100 = t103 * t1099;
  t1101 = t1100 * t153;
  t1103 = t167 * t110;
  t1104 = t103 * t1103;
  t1105 = t1104 * t153;
  t1107 = t78 * t27;
  t1108 = t231 * t1107;
  t1109 = t415 * t49;
  t1110 = t1109 * t607;
  t1111 = t1108 * t1110;
  t1113 = t541 * t435;
  t1116 = t231 * t438;
  t1119 = t231 * t448;
  t1122 = -t117 * t1072 - t117 * t1074 + 0.2e1 * t255 * t1076 - 0.2e1 * t117 * t1079 - 0.6e1 * t669 * t435 * t126 + 0.4e1 * t255 * t163 * t350 + 0.4e1 * t255 * t438 * t126 + 0.2e1 * t255 * t448 * t126 - t1037 + t1039 - 0.5e4 / 0.2187e4 * t1095 + 0.625e3 / 0.1458e4 * t1097 + 0.25e2 / 0.54e2 * t1101 + 0.25e2 / 0.54e2 * t1105 + 0.25e2 / 0.432e3 * t1111 - 0.1e3 / 0.27e2 * t1113 * t112 + 0.1e3 / 0.27e2 * t1116 * t112 + 0.5e2 / 0.27e2 * t1119 * t112;
  t1123 = t1060 + t1122;
  t1128 = my_piecewise3(t3, 0, -t7 * t86 * t454 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1123);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1128 + 0.2e1 * t458;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1136 = t44 * t162;
  t1138 = t732 * t1136 * t110;
  t1141 = t185 * t47;
  t1142 = t541 * t1141;
  t1143 = t1142 * t318;
  t1145 = t185 * t48;
  t1146 = t547 * t1145;
  t1147 = t1146 * t314;
  t1150 = t475 * t1136 * t126;
  t1153 = t573 * t476;
  t1154 = t388 * t1153;
  t1156 = t162 * t47;
  t1157 = t151 * t110;
  t1158 = t1156 * t1157;
  t1162 = t312 * t462 * t126;
  t1163 = t548 * t1162;
  t1165 = t462 * t110;
  t1166 = t312 * t1165;
  t1167 = t738 * t1166;
  t1174 = t151 * t175 * t350;
  t1181 = t893 * t477;
  t1183 = t475 * t98;
  t1184 = t105 * t1183;
  t1185 = t388 * t1184;
  t1187 = t896 * t477;
  t1190 = 0.325e5 / 0.2187e4 * t421 + 0.25e3 / 0.81e2 * t429 - 0.1e5 / 0.729e3 * t731 * t1138 + 0.25e2 / 0.54e2 * t1143 + 0.125e4 / 0.729e3 * t1147 - 0.1e3 / 0.27e2 * t991 * t1150 - 0.25e2 / 0.108e3 * t1154 - 0.1e3 / 0.27e2 * t917 * t1158 + 0.25e4 / 0.729e3 * t1163 - 0.25e4 / 0.243e3 * t1167 + 0.5e2 / 0.27e2 * t557 * t467 + 0.5e2 / 0.27e2 * t770 * t467 + 0.5e2 / 0.27e2 * t232 * t1174 + 0.5e2 / 0.27e2 * t727 * t380 + 0.1e5 / 0.729e3 * t1002 * t376 - 0.25e2 / 0.108e3 * t1181 + 0.5e2 / 0.81e2 * t1185 - 0.25e2 / 0.108e3 * t1187 - 0.25e3 / 0.81e2 * t425;
  t1191 = t788 * t462;
  t1192 = t1042 * t1191;
  t1194 = t237 * t472;
  t1197 = t135 * t490;
  t1199 = t1061 * t462;
  t1202 = t829 * t1165;
  t1205 = -0.125e3 / 0.81e2 * t1199 + 0.1625e4 / 0.243e3 * t441 - 0.625e6 / 0.19683e5 * t1202 + 0.203125e7 / 0.59049e5 * t445;
  t1206 = t78 * t1205;
  t1208 = t362 * t184;
  t1210 = t167 * t402;
  t1227 = t669 * t78;
  t1228 = t184 * t162;
  t1229 = t1228 * t126;
  t1236 = t461 * t49;
  t1237 = t1236 * t607;
  t1238 = t1108 * t1237;
  t1240 = t231 * t483;
  t1243 = t231 * t491;
  t1246 = t761 * t463;
  t1248 = 0.25e6 / 0.19683e5 * t1192 + 0.25e2 / 0.54e2 * t1194 - 0.325e3 / 0.162e3 * t432 - t117 * t1197 - t117 * t1206 - t117 * t1208 - t117 * t1210 + 0.2e1 * t255 * t394 * t162 + 0.2e1 * t255 * t403 * t162 + 0.2e1 * t255 * t185 * t350 + 0.2e1 * t255 * t483 * t126 + 0.2e1 * t255 * t491 * t126 - 0.6e1 * t1227 * t1229 - 0.5e2 / 0.27e2 * t1100 * t176 - 0.5e2 / 0.27e2 * t1104 * t176 - 0.25e2 / 0.54e2 * t1238 + 0.5e2 / 0.27e2 * t1240 * t112 + 0.5e2 / 0.27e2 * t1243 * t112 - 0.25e4 / 0.729e3 * t1246;
  t1249 = t1190 + t1248;
  t1254 = my_piecewise3(t3, 0, -t7 * t86 * t493 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1249);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1254 + 0.2e1 * t497;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1260 = t788 * t501;
  t1264 = t312 * t501 * t126;
  t1269 = t501 * t110;
  t1270 = t312 * t1269;
  t1274 = t44 * t184;
  t1276 = t732 * t1274 * t110;
  t1280 = t475 * t1274 * t126;
  t1289 = t151 * t175 * t402;
  t1292 = -0.2e7 / 0.19683e5 * t1042 * t1260 - 0.2e5 / 0.729e3 * t548 * t1264 + 0.2e5 / 0.729e3 * t761 * t502 + 0.2e5 / 0.243e3 * t738 * t1270 - 0.2e6 / 0.2187e4 * t464 - 0.2e5 / 0.729e3 * t731 * t1276 - 0.2e3 / 0.27e2 * t991 * t1280 + 0.1e3 / 0.27e2 * t557 * t506 + 0.1e3 / 0.27e2 * t770 * t506 - 0.5e3 / 0.81e2 * t478 + 0.1e3 / 0.27e2 * t232 * t1289;
  t1293 = t500 * t49;
  t1294 = t1293 * t607;
  t1300 = t541 * t513;
  t1306 = t135 * t512;
  t1312 = t231 * t522;
  t1318 = t135 * t521;
  t1326 = 0.1e4 / 0.81e2 * t1061 * t501 - 0.1e5 / 0.243e3 * t485 + 0.5e7 / 0.19683e5 * t829 * t1269 - 0.125e8 / 0.59049e5 * t488;
  t1327 = t78 * t1326;
  t1329 = 0.1e3 / 0.27e2 * t1108 * t1294 - 0.1e3 / 0.27e2 * t237 * t509 + 0.1e4 / 0.81e2 * t473 - 0.1e3 / 0.27e2 * t1300 * t112 - 0.6e1 * t669 * t513 * t126 + 0.2e1 * t255 * t1306 + 0.4e1 * t255 * t185 * t402 + 0.5e2 / 0.27e2 * t1312 * t112 + 0.2e1 * t255 * t522 * t126 - t117 * t1318 - t117 * t1327;
  t1330 = t1292 + t1329;
  t1335 = my_piecewise3(t3, 0, -t7 * t86 * t524 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1330);
  tv3rhotau20 = 0.2e1 * rho[0] * t1335 + 0.2e1 * t528;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1338 = 0.1e1 / t588;
  t1339 = t1338 * t60;
  t1340 = t619 * t1339;
  t1342 = t167 * t434;
  t1345 = t452 * t162;
  t1348 = t167 * t447;
  t1352 = t67 * t1338;
  t1353 = t641 * t1352;
  t1355 = -0.125e3 / 0.2592e4 * t1339 - 0.78125e5 / 0.78732e5 * t1353;
  t1356 = t78 * t1355;
  t1360 = 0.125e3 / 0.6377292e7 * t656 * t1339 - 0.125e3 / 0.6377292e7 * t1340;
  t1362 = t1338 * t71;
  t1364 = t627 * t1362 * t78;
  t1366 = t434 * t162;
  t1367 = t78 * t1366;
  t1370 = t163 * t447;
  t1373 = t727 * t424;
  t1376 = t151 * t152 * t447;
  t1377 = t232 * t1376;
  t1380 = t312 * t419 * t162;
  t1381 = t548 * t1380;
  t1383 = t1002 * t420;
  t1385 = t52 * t162;
  t1386 = t1109 * t1385;
  t1387 = t1108 * t1386;
  t1389 = t452 * t47;
  t1390 = t103 * t1389;
  t1391 = t1390 * t153;
  t1394 = t151 * t152 * t434;
  t1395 = t542 * t1394;
  t1397 = t353 * t431;
  t1399 = t225 * t1338;
  t1400 = t600 * t1399;
  t1401 = t222 * t1400;
  t1403 = 0.125e3 / 0.6377292e7 * t1340 + 0.6e1 * t255 * t1342 - 0.3e1 * t117 * t1345 - 0.3e1 * t117 * t1348 - t117 * t1356 + t72 * t1360 + 0.15625e5 / 0.39366e5 * t1364 - 0.6e1 * t669 * t1367 + 0.6e1 * t255 * t1370 - 0.25e2 / 0.18e2 * t1373 - 0.25e2 / 0.36e2 * t1377 - 0.625e3 / 0.486e3 * t1381 + 0.625e3 / 0.486e3 * t1383 + 0.25e2 / 0.144e3 * t1387 + 0.25e2 / 0.36e2 * t1391 + 0.25e2 / 0.18e2 * t1395 - 0.25e2 / 0.144e3 * t1397 - 0.625e3 / 0.1944e4 * t1401;
  t1407 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1403);
  tv3sigma30 = 0.2e1 * rho[0] * t1407;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1409 = 0.1e1 / t208;
  t1410 = t1409 * t71;
  t1412 = t627 * t1410 * t78;
  t1414 = t483 * t162;
  t1417 = t491 * t162;
  t1420 = t185 * t447;
  t1423 = t185 * t434;
  t1426 = t1002 * t463;
  t1428 = t1236 * t1385;
  t1429 = t1108 * t1428;
  t1433 = t388 * t431;
  t1435 = t452 * t184;
  t1437 = t167 * t490;
  t1440 = -0.625e5 / 0.19683e5 * t1412 + 0.4e1 * t255 * t1414 + 0.4e1 * t255 * t1417 + 0.2e1 * t255 * t1420 - 0.6e1 * t669 * t1423 - 0.5e4 / 0.729e3 * t1426 - 0.25e2 / 0.27e2 * t1429 - 0.5e2 / 0.27e2 * t1390 * t176 + 0.25e2 / 0.432e3 * t1433 - t117 * t1435 - 0.2e1 * t117 * t1437;
  t1441 = t1409 * t60;
  t1443 = t67 * t1409;
  t1444 = t641 * t1443;
  t1446 = 0.125e3 / 0.324e3 * t1441 + 0.15625e6 / 0.19683e5 * t1444;
  t1447 = t78 * t1446;
  t1449 = t1240 * t477;
  t1451 = t1243 * t477;
  t1453 = t225 * t27;
  t1455 = t223 * t1453 * t415;
  t1456 = t884 * t1455;
  t1459 = t312 * t462 * t162;
  t1460 = t548 * t1459;
  t1465 = t151 * t175 * t447;
  t1469 = t151 * t175 * t434;
  t1472 = t1142 * t424;
  t1474 = t225 * t1409;
  t1475 = t600 * t1474;
  t1476 = t222 * t1475;
  t1478 = t353 * t472;
  t1480 = -t117 * t1447 - 0.25e2 / 0.54e2 * t1449 - 0.25e2 / 0.54e2 * t1451 - 0.625e3 / 0.1458e4 * t1456 + 0.5e4 / 0.729e3 * t1460 + 0.1e3 / 0.27e2 * t727 * t467 + 0.5e2 / 0.27e2 * t232 * t1465 - 0.1e3 / 0.27e2 * t542 * t1469 + 0.25e2 / 0.27e2 * t1472 + 0.625e3 / 0.243e3 * t1476 + 0.25e2 / 0.27e2 * t1478;
  t1481 = t1440 + t1480;
  t1485 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1481);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1485;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1487 = 0.1e1 / t300;
  t1488 = t1487 * t71;
  t1490 = t627 * t1488 * t78;
  t1493 = t312 * t501 * t162;
  t1498 = t225 * t1487;
  t1499 = t600 * t1498;
  t1500 = t222 * t1499;
  t1503 = t312 * t462 * t184;
  t1504 = t548 * t1503;
  t1507 = t475 * t1274 * t162;
  t1512 = t52 * t184;
  t1513 = t1236 * t1512;
  t1514 = t1108 * t1513;
  t1517 = t151 * t175 * t490;
  t1520 = t1293 * t1385;
  t1525 = t1300 * t477;
  t1530 = t167 * t512;
  t1536 = t1312 * t477;
  t1541 = t167 * t521;
  t1543 = t1487 * t60;
  t1545 = t67 * t1487;
  t1546 = t641 * t1545;
  t1548 = -0.25e3 / 0.81e2 * t1543 - 0.125e7 / 0.19683e5 * t1546;
  t1549 = t78 * t1548;
  t1551 = 0.5e6 / 0.19683e5 * t1490 - 0.2e5 / 0.729e3 * t548 * t1493 + 0.2e5 / 0.729e3 * t1002 * t502 - 0.5e4 / 0.243e3 * t1500 + 0.5e4 / 0.729e3 * t1504 - 0.2e3 / 0.27e2 * t991 * t1507 + 0.1e3 / 0.27e2 * t727 * t506 - 0.25e2 / 0.27e2 * t1514 + 0.1e3 / 0.27e2 * t232 * t1517 + 0.1e3 / 0.27e2 * t1108 * t1520 - 0.1e3 / 0.27e2 * t353 * t509 + 0.25e2 / 0.54e2 * t1525 - 0.6e1 * t669 * t513 * t162 + 0.2e1 * t255 * t1530 + 0.4e1 * t255 * t185 * t490 - 0.25e2 / 0.108e3 * t1536 + 0.2e1 * t255 * t522 * t162 - t117 * t1541 - t117 * t1549;
  t1555 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1551);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1555;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1557 = 0.1e1 / t413;
  t1558 = t1557 * t71;
  t1563 = t312 * t501 * t184;
  t1566 = t225 * t1557;
  t1567 = t600 * t1566;
  t1571 = t151 * t175 * t512;
  t1574 = t1293 * t1512;
  t1578 = t151 * t175 * t521;
  t1581 = t512 * t184;
  t1582 = t78 * t1581;
  t1585 = t185 * t521;
  t1590 = t67 * t1557;
  t1593 = 0.2e4 / 0.81e2 * t1557 * t60 + 0.1e8 / 0.19683e5 * t641 * t1590;
  t1594 = t78 * t1593;
  t1596 = -0.4e7 / 0.19683e5 * t627 * t1558 * t78 - 0.2e5 / 0.243e3 * t548 * t1563 + 0.4e5 / 0.243e3 * t222 * t1567 - 0.1e3 / 0.9e1 * t542 * t1571 + 0.1e3 / 0.9e1 * t1108 * t1574 + 0.5e2 / 0.9e1 * t232 * t1578 - 0.6e1 * t669 * t1582 + 0.6e1 * t255 * t1585 - t117 * t1594;
  t1600 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1596);
  tv3tau30 = 0.2e1 * rho[0] * t1600;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t47;
  double t48, t49, t52, t55, t56, t57, t58, t59;
  double t60, t63, t66, t67, t70, t71, t72, t73;
  double t78, t80, t84, tzk0;

  double t86, t90, t91, t94, t95, t96, t98, t99;
  double t100, t101, t103, t104, t105, t110, t111, t112;
  double t115, t116, t117, t118, t122, t123, t126, t127;
  double t129, t132, t135, t137, t142, tvrho0, t145, t146;
  double t147, t149, t150, t151, t152, t153, t154, t156;
  double t158, t160, t162, t163, t167, t169, t173, tvsigma0;
  double tvlapl0, t175, t176, t184, t185, t187, t191, tvtau0;

  double t194, t204, t205, t206, t207, t208, t210, t211;
  double t212, t214, t216, t217, t218, t220, t221, t222;
  double t223, t225, t226, t227, t228, t231, t232, t233;
  double t234, t237, t240, t241, t248, t249, t250, t254;
  double t255, t256, t257, t260, t263, t268, t269, t275;
  double t281, t286, t288, t293, tv2rho20, t299, t300, t302;
  double t304, t306, t307, t309, t310, t311, t312, t313;
  double t314, t315, t318, t319, t321, t322, t323, t325;
  double t326, t327, t329, t330, t332, t338, t340, t342;
  double t344, t345, t348, t350, t351, t353, t356, t362;
  double t364, t369, tv2rhosigma0, tv2rholapl0, t375, t376, t380, t388;
  double t394, t402, t403, t405, t410, tv2rhotau0, t413, t415;
  double t416, t417, t419, t420, t421, t424, t425, t427;
  double t428, t429, t431, t432, t434, t435, t438, t441;
  double t443, t445, t447, t448, t452, t454, t458, tv2sigma20;
  double tv2sigmalapl0, t461, t462, t463, t464, t467, t472, t473;
  double t475, t476, t477, t478, t480, t483, t485, t488;
  double t490, t491, t493, t497, tv2sigmatau0, tv2lapl20, tv2lapltau0, t500;
  double t501, t502, t506, t509, t512, t513, t521, t522;
  double t524, t528, tv2tau20;

  double t531, t541, t542, t544, t547, t548, t550, t553;
  double t554, t557, t561, t565, t568, t573, t574, t580;
  double t583, t584, t585, t588, t590, t592, t594, t595;
  double t596, t598, t599, t600, t601, t603, t606, t607;
  double t608, t611, t617, t619, t620, t621, t622, t623;
  double t624, t626, t627, t628, t632, t641, t651, t652;
  double t654, t656, t663, t667, t668, t669, t670, t671;
  double t674, t677, t680, t681, t686, tv3rho30, t696, t698;
  double t699, t700, t702, t703, t704, t706, t708, t709;
  double t711, t712, t713, t715, t718, t723, t727, t730;
  double t731, t732, t733, t734, t735, t736, t738, t739;
  double t740, t741, t743, t744, t745, t748, t749, t752;
  double t753, t755, t757, t760, t761, t762, t764, t765;
  double t766, t768, t770, t771, t773, t776, t777, t779;
  double t784, t787, t788, t789, t790, t793, t795, t797;
  double t800, t802, t803, t808, t812, t814, t815, t817;
  double t820, t821, t823, t825, t827, t829, t830, t832;
  double t834, t837, t839, t840, t848, t867, t869, t874;
  double tv3rho2sigma0, tv3rho2lapl0, t884, t893, t896, t904, t906, t910;
  double t913, t914, t917, t922, t923, t924, t932, t938;
  double t941, t944, t946, t961, t962, t976, t977, t982;
  double tv3rho2tau0, t988, t990, t991, t992, t993, t994, t995;
  double t997, t998, t999, t1001, t1002, t1003, t1006, t1007;
  double t1009, t1010, t1011, t1013, t1015, t1018, t1019, t1021;
  double t1024, t1025, t1027, t1028, t1029, t1030, t1033, t1037;
  double t1039, t1040, t1042, t1043, t1044, t1046, t1048, t1051;
  double t1052, t1053, t1055, t1058, t1060, t1061, t1062, t1064;
  double t1066, t1069, t1071, t1072, t1074, t1076, t1079, t1094;
  double t1095, t1097, t1099, t1100, t1101, t1103, t1104, t1105;
  double t1107, t1108, t1109, t1110, t1111, t1113, t1116, t1119;
  double t1122, t1123, t1128, tv3rhosigma20, tv3rhosigmalapl0, t1136, t1138, t1141;
  double t1142, t1143, t1145, t1146, t1147, t1150, t1153, t1154;
  double t1156, t1157, t1158, t1162, t1163, t1165, t1166, t1167;
  double t1174, t1181, t1183, t1184, t1185, t1187, t1190, t1191;
  double t1192, t1194, t1197, t1199, t1202, t1205, t1206, t1208;
  double t1210, t1227, t1228, t1229, t1236, t1237, t1238, t1240;
  double t1243, t1246, t1248, t1249, t1254, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0;
  double t1260, t1264, t1269, t1270, t1274, t1276, t1280, t1289;
  double t1292, t1293, t1294, t1300, t1306, t1312, t1318, t1326;
  double t1327, t1329, t1330, t1335, tv3rhotau20, t1338, t1339, t1340;
  double t1342, t1345, t1348, t1352, t1353, t1355, t1356, t1360;
  double t1362, t1364, t1366, t1367, t1370, t1373, t1376, t1377;
  double t1380, t1381, t1383, t1385, t1386, t1387, t1389, t1390;
  double t1391, t1394, t1395, t1397, t1399, t1400, t1401, t1403;
  double t1407, tv3sigma30, tv3sigma2lapl0, t1409, t1410, t1412, t1414, t1417;
  double t1420, t1423, t1426, t1428, t1429, t1433, t1435, t1437;
  double t1440, t1441, t1443, t1444, t1446, t1447, t1449, t1451;
  double t1453, t1455, t1456, t1459, t1460, t1465, t1469, t1472;
  double t1474, t1475, t1476, t1478, t1480, t1481, t1485, tv3sigma2tau0;
  double tv3sigmalapl20, tv3sigmalapltau0, t1487, t1488, t1490, t1493, t1498, t1499;
  double t1500, t1503, t1504, t1507, t1512, t1513, t1514, t1517;
  double t1520, t1525, t1530, t1536, t1541, t1543, t1545, t1546;
  double t1548, t1549, t1551, t1555, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t1557, t1558, t1563, t1566, t1567, t1571, t1574, t1578;
  double t1581, t1582, t1585, t1590, t1593, t1594, t1596, t1600;
  double tv3tau30;

  double t1618, t1628, t1630, t1632, t1633, t1634, t1636, t1637;
  double t1638, t1642, t1649, t1657, t1658, t1659, t1664, t1665;
  double t1666, t1672, t1675, t1677, t1686, t1689, t1691, t1701;
  double t1708, t1711, t1730, t1743, t1749, t1750, t1757, t1776;
  double t1778, t1798, t1805, t1814, t1815, t1820, t1843, t1861;
  double t1865, t1872, tv4rho40, t1885, t1891, t1894, t1904, t1910;
  double t1916, t1935, t1941, t1951, t1954, t1961, t1965, t1980;
  double t2011, t2019, t2022, t2026, t2030, t2033, t2038, t2040;
  double t2042, t2044, t2075, t2080, t2087, t2101, t2114, t2123;
  double t2132, t2142, t2145, t2156, t2157, t2161, t2163, t2170;
  double t2174, t2179, t2184, t2187, t2191, t2194, t2200, t2201;
  double t2207, t2210, t2215, t2219, t2238, t2245, t2246, t2250;
  double t2254, t2276, t2280, t2287, t2295, tv4rho3sigma0, tv4rho3lapl0, t2319;
  double t2331, t2346, t2350, t2357, t2398, t2414, t2425, t2429;
  double t2432, t2437, t2455, t2458, t2477, t2484, t2487, t2494;
  double t2517, t2533, t2541, tv4rho3tau0, t2551, t2556, t2574, t2580;
  double t2583, t2585, t2590, t2600, t2603, t2610, t2616, t2635;
  double t2636, t2640, t2652, t2662, t2665, t2677, t2698, t2700;
  double t2719, t2740, t2743, t2748, t2753, t2755, t2766, t2773;
  double t2777, t2780, t2784, t2823, t2827, t2835, t2839, t2843;
  double t2868, t2872, t2898, t2905, t2909, t2920, t2927, t2936;
  double t2940, t2952, t2960, tv4rho2sigma20, tv4rho2sigmalapl0, t2980, t2995, t3007;
  double t3016, t3018, t3026, t3033, t3068, t3099, t3101, t3102;
  double t3121, t3142, t3153, t3156, t3159, t3162, t3165, t3184;
  double t3187, t3200, t3244, t3247, t3249, t3290, t3326, t3330;
  double t3338, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0, t3355, t3376, t3392, t3422;
  double t3437, t3455, t3462, t3465, t3468, t3473, t3494, t3506;
  double t3517, t3524, t3557, t3564, tv4rho2tau20, t3574, t3579, t3588;
  double t3602, t3637, t3657, t3680, t3683, t3691, t3700, t3703;
  double t3706, t3708, t3711, t3714, t3724, t3729, t3733, t3738;
  double t3740, t3742, t3764, t3768, t3772, t3775, t3781, t3813;
  double t3833, t3840, tv4rhosigma30, tv4rhosigma2lapl0, t3856, t3865, t3890, t3893;
  double t3917, t3961, t3969, t3972, t3975, t3999, t4033, t4069;
  double t4109, t4110, t4124, t4157, t4165, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0;
  double t4194, t4223, t4225, t4235, t4241, t4252, t4255, t4258;
  double t4261, t4299, t4320, t4328, t4364, t4366, t4373, t4379;
  double t4391, t4410, t4444, t4452, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20;
  double t4482, t4495, t4498, t4504, t4507, t4517, t4550, t4560;
  double t4577, t4591, t4598, tv4rhotau30, t4602, t4603, t4613, t4614;
  double t4616, t4620, t4639, t4646, t4651, t4656, t4660, t4668;
  double t4711, t4716, tv4sigma40, tv4sigma3lapl0, t4734, t4738, t4754, t4790;
  double t4824, t4862, t4868, tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0, t4878, t4882;
  double t4909, t4933, t4946, t4950, t4969, t4991, t5031, t5037;
  double tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, t5060, t5069, t5074, t5075;
  double t5099, t5156, t5161, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30;
  double t5173, t5180, t5218, t5222, tv4tau40;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t47 = t42 * t44 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = 0.1e1 / t23 / t22;
  t55 = 0.1e1 - 0.25e2 / 0.81e2 * t48 * t49 * t52;
  t56 = t55 * t55;
  t57 = t56 * t55;
  t58 = t48 * t47;
  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t63 = t48 * t48;
  t66 = t59 * t59;
  t67 = 0.1e1 / t66;
  t70 = 0.1e1 + 0.25e3 / 0.243e3 * t58 * t60 + 0.625e5 / 0.59049e5 * params->b * t63 * t48 * t67;
  t71 = 0.1e1 / t70;
  t72 = t57 * t71;
  t73 = params->kappa + t36 + params->c;
  t78 = params->kappa * (0.1e1 - params->kappa / t73) - t41;
  t80 = t72 * t78 + t41 + 0.1e1;
  t84 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t80);
  tzk0 = 0.2e1 * t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t86 = t18 / t31;
  t90 = params->kappa * params->kappa;
  t91 = t37 * t37;
  t94 = t90 / t91 * t21;
  t95 = t25 * sigma[0];
  t96 = t30 * rho[0];
  t98 = 0.1e1 / t31 / t96;
  t99 = t28 * t98;
  t100 = t95 * t99;
  t101 = t94 * t100;
  t103 = t56 * t71;
  t104 = t103 * t78;
  t105 = t47 * t49;
  t110 = -0.5e1 / 0.3e1 * t42 * t33 + t29 * t98 / 0.3e1;
  t111 = t52 * t110;
  t112 = t105 * t111;
  t115 = t70 * t70;
  t116 = 0.1e1 / t115;
  t117 = t57 * t116;
  t118 = t48 * t60;
  t122 = params->b * t63 * t47;
  t123 = t67 * t110;
  t126 = 0.25e3 / 0.81e2 * t118 * t110 + 0.125e6 / 0.19683e5 * t122 * t123;
  t127 = t78 * t126;
  t129 = t73 * t73;
  t132 = t90 / t129 * t21;
  t135 = -0.1e2 / 0.729e3 * t132 * t100 + 0.1e2 / 0.729e3 * t101;
  t137 = -0.1e2 / 0.729e3 * t101 - 0.5e2 / 0.27e2 * t104 * t112 - t117 * t127 + t72 * t135;
  t142 = my_piecewise3(t3, 0, -t7 * t86 * t80 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t137);
  tvrho0 = 0.2e1 * rho[0] * t142 + 0.2e1 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t145 = t25 * t28;
  t146 = t145 * t33;
  t147 = t94 * t146;
  t149 = t78 * t47;
  t150 = t103 * t149;
  t151 = t49 * t52;
  t152 = t28 * t33;
  t153 = t151 * t152;
  t154 = t150 * t153;
  t156 = t118 * t152;
  t158 = t67 * t28;
  t160 = t122 * t158 * t33;
  t162 = -0.125e3 / 0.324e3 * t156 - 0.15625e5 / 0.19683e5 * t160;
  t163 = t78 * t162;
  t167 = 0.5e1 / 0.972e3 * t132 * t146 - 0.5e1 / 0.972e3 * t147;
  t169 = 0.5e1 / 0.972e3 * t147 + 0.25e2 / 0.108e3 * t154 - t117 * t163 + t72 * t167;
  t173 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t169);
  tvsigma0 = 0.2e1 * rho[0] * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t175 = t28 * t44;
  t176 = t151 * t175;
  t184 = 0.25e3 / 0.81e2 * t118 * t175 + 0.125e6 / 0.19683e5 * t122 * t158 * t44;
  t185 = t78 * t184;
  t187 = -0.5e2 / 0.27e2 * t150 * t176 - t117 * t185;
  t191 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t187);
  tvtau0 = 0.2e1 * rho[0] * t191;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t194 = t18 * t44;
  t204 = t90 / t91 / t37 * t49;
  t205 = sigma[0] * sigma[0];
  t206 = t52 * t205;
  t207 = t30 * t30;
  t208 = t207 * t96;
  t210 = 0.1e1 / t19 / t208;
  t211 = t27 * t210;
  t212 = t206 * t211;
  t214 = 0.4e3 / 0.531441e6 * t204 * t212;
  t216 = 0.1e1 / t31 / t207;
  t217 = t28 * t216;
  t218 = t95 * t217;
  t220 = 0.11e3 / 0.2187e4 * t94 * t218;
  t221 = t55 * t71;
  t222 = t221 * t78;
  t223 = t48 * t21;
  t225 = 0.1e1 / t24 / t59;
  t226 = t110 * t110;
  t227 = t225 * t226;
  t228 = t223 * t227;
  t231 = t56 * t116;
  t232 = t231 * t149;
  t233 = t110 * t126;
  t234 = t151 * t233;
  t237 = t103 * t135;
  t240 = t226 * t49;
  t241 = t240 * t52;
  t248 = 0.4e2 / 0.9e1 * t42 * t98 - 0.11e2 / 0.9e1 * t29 * t216;
  t249 = t52 * t248;
  t250 = t105 * t249;
  t254 = 0.1e1 / t115 / t70;
  t255 = t57 * t254;
  t256 = t126 * t126;
  t257 = t78 * t256;
  t260 = t135 * t126;
  t263 = t47 * t60;
  t268 = params->b * t63;
  t269 = t67 * t226;
  t275 = 0.5e3 / 0.81e2 * t263 * t226 + 0.25e3 / 0.81e2 * t118 * t248 + 0.625e6 / 0.19683e5 * t268 * t269 + 0.125e6 / 0.19683e5 * t122 * t67 * t248;
  t281 = t90 / t129 / t73 * t49;
  t286 = -0.4e3 / 0.531441e6 * t281 * t212 + 0.11e3 / 0.2187e4 * t132 * t218 + t214 - t220;
  t288 = -t214 + t220 + 0.1e5 / 0.729e3 * t222 * t228 + 0.1e3 / 0.27e2 * t232 * t234 - 0.1e3 / 0.27e2 * t237 * t112 - 0.5e2 / 0.27e2 * t104 * t241 - 0.5e2 / 0.27e2 * t104 * t250 + 0.2e1 * t255 * t257 - 0.2e1 * t117 * t260 - t117 * t78 * t275 + t72 * t286;
  t293 = my_piecewise3(t3, 0, t7 * t194 * t80 / 0.12e2 - t7 * t86 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t288);
  tv2rho20 = 0.2e1 * rho[0] * t293 + 0.4e1 * t142;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t299 = t52 * t27;
  t300 = t207 * t30;
  t302 = 0.1e1 / t19 / t300;
  t304 = t299 * t302 * sigma[0];
  t306 = 0.5e2 / 0.177147e6 * t204 * t304;
  t307 = t145 * t98;
  t309 = 0.1e2 / 0.729e3 * t94 * t307;
  t310 = t78 * t48;
  t311 = t221 * t310;
  t312 = t21 * t225;
  t313 = t152 * t110;
  t314 = t312 * t313;
  t315 = t311 * t314;
  t318 = t151 * t152 * t126;
  t319 = t232 * t318;
  t321 = t135 * t47;
  t322 = t103 * t321;
  t323 = t322 * t153;
  t325 = t78 * t110;
  t326 = t103 * t325;
  t327 = t326 * t153;
  t329 = t151 * t99;
  t330 = t150 * t329;
  t332 = t231 * t163;
  t338 = t135 * t162;
  t340 = t263 * t313;
  t342 = t118 * t99;
  t344 = t268 * t67;
  t345 = t344 * t313;
  t348 = t122 * t158 * t98;
  t350 = -0.125e3 / 0.162e3 * t340 + 0.25e3 / 0.243e3 * t342 - 0.78125e5 / 0.19683e5 * t345 + 0.125e6 / 0.59049e5 * t348;
  t351 = t78 * t350;
  t353 = t103 * t167;
  t356 = t167 * t126;
  t362 = 0.5e2 / 0.177147e6 * t281 * t304 - 0.1e2 / 0.729e3 * t132 * t307 - t306 + t309;
  t364 = t306 - t309 - 0.125e4 / 0.729e3 * t315 - 0.25e2 / 0.108e3 * t319 + 0.25e2 / 0.108e3 * t323 + 0.25e2 / 0.108e3 * t327 - 0.5e2 / 0.81e2 * t330 + 0.5e2 / 0.27e2 * t332 * t112 + 0.2e1 * t255 * t163 * t126 - t117 * t338 - t117 * t351 - 0.5e2 / 0.27e2 * t353 * t112 - t117 * t356 + t72 * t362;
  t369 = my_piecewise3(t3, 0, -t7 * t86 * t169 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t364);
  tv2rhosigma0 = 0.2e1 * rho[0] * t369 + 0.2e1 * t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t375 = t175 * t110;
  t376 = t312 * t375;
  t380 = t151 * t175 * t126;
  t388 = t231 * t185;
  t394 = t135 * t184;
  t402 = 0.5e3 / 0.81e2 * t263 * t375 - 0.125e4 / 0.243e3 * t156 + 0.625e6 / 0.19683e5 * t344 * t375 - 0.625e6 / 0.59049e5 * t160;
  t403 = t78 * t402;
  t405 = 0.1e5 / 0.729e3 * t311 * t376 + 0.5e2 / 0.27e2 * t232 * t380 - 0.5e2 / 0.27e2 * t322 * t176 - 0.5e2 / 0.27e2 * t326 * t176 + 0.25e3 / 0.81e2 * t154 + 0.5e2 / 0.27e2 * t388 * t112 + 0.2e1 * t255 * t185 * t126 - t117 * t394 - t117 * t403;
  t410 = my_piecewise3(t3, 0, -t7 * t86 * t187 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t405);
  tv2rhotau0 = 0.2e1 * rho[0] * t410 + 0.2e1 * t191;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t413 = t207 * rho[0];
  t415 = 0.1e1 / t19 / t413;
  t416 = t299 * t415;
  t417 = t204 * t416;
  t419 = t27 * t415;
  t420 = t312 * t419;
  t421 = t311 * t420;
  t424 = t151 * t152 * t162;
  t425 = t232 * t424;
  t427 = t167 * t47;
  t428 = t103 * t427;
  t429 = t428 * t153;
  t431 = t419 * t151;
  t432 = t104 * t431;
  t434 = t162 * t162;
  t435 = t78 * t434;
  t438 = t167 * t162;
  t441 = t263 * t419;
  t443 = t67 * t27;
  t445 = t268 * t443 * t415;
  t447 = 0.125e3 / 0.648e3 * t441 + 0.78125e5 / 0.78732e5 * t445;
  t448 = t78 * t447;
  t452 = -0.25e2 / 0.236196e6 * t281 * t416 + 0.25e2 / 0.236196e6 * t417;
  t454 = -0.25e2 / 0.236196e6 * t417 + 0.625e3 / 0.1458e4 * t421 - 0.25e2 / 0.54e2 * t425 + 0.25e2 / 0.54e2 * t429 - 0.25e2 / 0.432e3 * t432 + 0.2e1 * t255 * t435 - 0.2e1 * t117 * t438 - t117 * t448 + t72 * t452;
  t458 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t454);
  tv2sigma20 = 0.2e1 * rho[0] * t458;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t461 = 0.1e1 / t19 / t207;
  t462 = t27 * t461;
  t463 = t312 * t462;
  t464 = t311 * t463;
  t467 = t151 * t175 * t162;
  t472 = t462 * t151;
  t473 = t104 * t472;
  t475 = t52 * t28;
  t476 = t475 * t33;
  t477 = t105 * t476;
  t478 = t388 * t477;
  t480 = t185 * t162;
  t483 = t167 * t184;
  t485 = t263 * t462;
  t488 = t268 * t443 * t461;
  t490 = -0.125e3 / 0.81e2 * t485 - 0.15625e6 / 0.19683e5 * t488;
  t491 = t78 * t490;
  t493 = -0.25e4 / 0.729e3 * t464 + 0.5e2 / 0.27e2 * t232 * t467 - 0.5e2 / 0.27e2 * t428 * t176 + 0.25e2 / 0.54e2 * t473 - 0.25e2 / 0.108e3 * t478 + 0.2e1 * t255 * t480 - t117 * t483 - t117 * t491;
  t497 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t493);
  tv2sigmatau0 = 0.2e1 * rho[0] * t497;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t500 = 0.1e1 / t19 / t96;
  t501 = t27 * t500;
  t502 = t312 * t501;
  t506 = t151 * t175 * t184;
  t509 = t501 * t151;
  t512 = t184 * t184;
  t513 = t78 * t512;
  t521 = 0.1e4 / 0.81e2 * t263 * t501 + 0.125e7 / 0.19683e5 * t268 * t443 * t500;
  t522 = t78 * t521;
  t524 = 0.2e5 / 0.729e3 * t311 * t502 + 0.1e3 / 0.27e2 * t232 * t506 - 0.1e3 / 0.27e2 * t104 * t509 + 0.2e1 * t255 * t513 - t117 * t522;
  t528 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t524);
  tv2tau20 = 0.2e1 * rho[0] * t528;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t531 = t18 * t33;
  t541 = t56 * t254;
  t542 = t541 * t149;
  t544 = t151 * t110 * t256;
  t547 = t55 * t116;
  t548 = t547 * t310;
  t550 = t312 * t226 * t126;
  t553 = t110 * t248;
  t554 = t312 * t553;
  t557 = t231 * t321;
  t561 = t151 * t248 * t126;
  t565 = t151 * t110 * t275;
  t568 = t103 * t286;
  t573 = t110 * t49;
  t574 = t573 * t249;
  t580 = 0.1e1 / t31 / t413;
  t583 = -0.44e3 / 0.27e2 * t42 * t216 + 0.154e3 / 0.27e2 * t29 * t580;
  t584 = t52 * t583;
  t585 = t105 * t584;
  t588 = t207 * t207;
  t590 = 0.1e1 / t19 / t588;
  t592 = t206 * t27 * t590;
  t594 = 0.44e4 / 0.531441e6 * t204 * t592;
  t595 = t28 * t580;
  t596 = t95 * t595;
  t598 = 0.154e4 / 0.6561e4 * t94 * t596;
  t599 = -0.1e3 / 0.9e1 * t542 * t544 - 0.1e5 / 0.243e3 * t548 * t550 + 0.1e5 / 0.243e3 * t311 * t554 + 0.1e3 / 0.9e1 * t557 * t234 + 0.5e2 / 0.9e1 * t232 * t561 + 0.5e2 / 0.9e1 * t232 * t565 - 0.5e2 / 0.9e1 * t568 * t112 - 0.5e2 / 0.9e1 * t237 * t250 - 0.5e2 / 0.9e1 * t104 * t574 - 0.5e2 / 0.27e2 * t104 * t585 + t594 - t598;
  t600 = t47 * t21;
  t601 = t226 * t110;
  t603 = t600 * t225 * t601;
  t606 = t231 * t78;
  t607 = t52 * t126;
  t608 = t240 * t607;
  t611 = t221 * t135;
  t617 = t91 * t91;
  t619 = t90 / t617;
  t620 = t205 * sigma[0];
  t621 = t60 * t620;
  t622 = t588 * t96;
  t623 = 0.1e1 / t622;
  t624 = t621 * t623;
  t626 = 0.16e5 / 0.43046721e8 * t619 * t624;
  t627 = t58 * t67;
  t628 = t601 * t71;
  t632 = t135 * t275;
  t641 = params->b * t58;
  t651 = 0.5e3 / 0.81e2 * t601 * t60 + 0.5e3 / 0.27e2 * t263 * t553 + 0.25e3 / 0.81e2 * t118 * t583 + 0.25e7 / 0.19683e5 * t641 * t67 * t601 + 0.625e6 / 0.6561e4 * t268 * t123 * t248 + 0.125e6 / 0.19683e5 * t122 * t67 * t583;
  t652 = t78 * t651;
  t654 = t129 * t129;
  t656 = t90 / t654;
  t663 = -0.16e5 / 0.43046721e8 * t656 * t624 + 0.44e4 / 0.531441e6 * t281 * t592 - 0.154e4 / 0.6561e4 * t132 * t596 + t626 - t594 + t598;
  t667 = t115 * t115;
  t668 = 0.1e1 / t667;
  t669 = t57 * t668;
  t670 = t256 * t126;
  t671 = t78 * t670;
  t674 = t135 * t256;
  t677 = t286 * t126;
  t680 = 0.1e5 / 0.243e3 * t222 * t603 + 0.5e2 / 0.9e1 * t606 * t608 + 0.1e5 / 0.243e3 * t611 * t228 + 0.6e1 * t255 * t127 * t275 - t626 - 0.1e7 / 0.19683e5 * t627 * t628 * t78 - 0.3e1 * t117 * t632 - t117 * t652 + t72 * t663 - 0.5e2 / 0.9e1 * t237 * t241 - 0.6e1 * t669 * t671 + 0.6e1 * t255 * t674 - 0.3e1 * t117 * t677;
  t681 = t599 + t680;
  t686 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t531 * t80 + t7 * t194 * t137 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t86 * t288 - 0.3e1 / 0.8e1 * t7 * t20 * t681);
  tv3rho30 = 0.2e1 * rho[0] * t686 + 0.6e1 * t293;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t696 = t322 * t329;
  t698 = t286 * t47;
  t699 = t103 * t698;
  t700 = t699 * t153;
  t702 = t135 * t110;
  t703 = t103 * t702;
  t704 = t703 * t153;
  t706 = t326 * t329;
  t708 = t151 * t217;
  t709 = t150 * t708;
  t711 = t78 * t248;
  t712 = t103 * t711;
  t713 = t712 * t153;
  t715 = t231 * t338;
  t718 = t231 * t351;
  t723 = t547 * t163;
  t727 = t231 * t427;
  t730 = t310 * t21;
  t731 = t547 * t730;
  t732 = t225 * t28;
  t733 = t33 * t110;
  t734 = t733 * t126;
  t735 = t732 * t734;
  t736 = t731 * t735;
  t738 = t221 * t149;
  t739 = t152 * t226;
  t740 = t312 * t739;
  t741 = t738 * t740;
  t743 = t99 * t110;
  t744 = t312 * t743;
  t745 = t311 * t744;
  t748 = t151 * t152 * t256;
  t749 = t542 * t748;
  t752 = t151 * t99 * t126;
  t753 = t232 * t752;
  t755 = t541 * t163;
  t757 = t105 * t111 * t126;
  t760 = t135 * t48;
  t761 = t221 * t760;
  t762 = t761 * t314;
  t764 = t152 * t248;
  t765 = t312 * t764;
  t766 = t311 * t765;
  t768 = t557 * t318;
  t770 = t231 * t325;
  t771 = t770 * t318;
  t773 = 0.1e3 / 0.27e2 * t727 * t234 + 0.25e4 / 0.729e3 * t736 - 0.125e4 / 0.243e3 * t741 + 0.2e5 / 0.2187e4 * t745 + 0.25e2 / 0.54e2 * t749 + 0.1e3 / 0.81e2 * t753 - 0.2e3 / 0.27e2 * t755 * t757 - 0.25e4 / 0.729e3 * t762 - 0.125e4 / 0.729e3 * t766 - 0.25e2 / 0.54e2 * t768 - 0.25e2 / 0.54e2 * t771;
  t776 = t151 * t152 * t275;
  t777 = t232 * t776;
  t779 = t103 * t362;
  t784 = t221 * t167;
  t787 = t627 * t226;
  t788 = t71 * t78;
  t789 = t788 * t152;
  t790 = t787 * t789;
  t793 = t299 * t210 * sigma[0];
  t795 = 0.5e2 / 0.19683e5 * t204 * t793;
  t797 = t162 * t226 * t151;
  t800 = t588 * t30;
  t802 = t60 / t800;
  t803 = t802 * t205;
  t808 = t145 * t216;
  t812 = 0.2e4 / 0.14348907e8 * t619 * t803;
  t814 = 0.11e3 / 0.2187e4 * t94 * t808;
  t815 = 0.2e4 / 0.14348907e8 * t656 * t803 - 0.5e2 / 0.19683e5 * t281 * t793 + 0.11e3 / 0.2187e4 * t132 * t808 - t812 + t795 - t814;
  t817 = t135 * t350;
  t820 = t226 * t60;
  t821 = t820 * t152;
  t823 = t263 * t743;
  t825 = t263 * t764;
  t827 = t118 * t217;
  t829 = t641 * t67;
  t830 = t829 * t739;
  t832 = t344 * t743;
  t834 = t344 * t764;
  t837 = t122 * t158 * t216;
  t839 = -0.125e3 / 0.162e3 * t821 + 0.1e4 / 0.243e3 * t823 - 0.125e3 / 0.162e3 * t825 - 0.275e4 / 0.729e3 * t827 - 0.3125e6 / 0.19683e5 * t830 + 0.125e7 / 0.59049e5 * t832 - 0.78125e5 / 0.19683e5 * t834 - 0.1375e7 / 0.177147e6 * t837;
  t840 = t78 * t839;
  t848 = t286 * t162;
  t867 = -0.2e1 * t117 * t362 * t126 - t117 * t167 * t275 - t117 * t848 + 0.2e1 * t255 * t167 * t256 - 0.6e1 * t669 * t163 * t256 + t812 + 0.4e1 * t255 * t338 * t126 + 0.4e1 * t255 * t351 * t126 + 0.2e1 * t255 * t163 * t275 - 0.5e2 / 0.27e2 * t353 * t241 + t814;
  t869 = -0.1e3 / 0.81e2 * t696 + 0.25e2 / 0.108e3 * t700 + 0.25e2 / 0.54e2 * t704 - 0.1e3 / 0.81e2 * t706 + 0.55e3 / 0.243e3 * t709 + 0.25e2 / 0.108e3 * t713 + 0.1e3 / 0.27e2 * t715 * t112 + 0.1e3 / 0.27e2 * t718 * t112 + 0.5e2 / 0.27e2 * t332 * t250 - 0.1e5 / 0.729e3 * t723 * t228 + t773 - 0.25e2 / 0.108e3 * t777 - 0.1e3 / 0.27e2 * t779 * t112 - 0.5e2 / 0.27e2 * t353 * t250 + 0.1e5 / 0.729e3 * t784 * t228 + 0.125e6 / 0.19683e5 * t790 - t795 + 0.5e2 / 0.27e2 * t606 * t797 + t72 * t815 - 0.2e1 * t117 * t817 - t117 * t840 + t867;
  t874 = my_piecewise3(t3, 0, t7 * t194 * t169 / 0.12e2 - t7 * t86 * t364 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t869);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t874 + 0.4e1 * t369;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t884 = t547 * t185;
  t893 = t231 * t394;
  t896 = t231 * t403;
  t904 = t44 * t110;
  t906 = t732 * t904 * t126;
  t910 = t151 * t175 * t256;
  t913 = t175 * t226;
  t914 = t312 * t913;
  t917 = t541 * t185;
  t922 = -0.1e5 / 0.729e3 * t884 * t228 - 0.5e2 / 0.27e2 * t699 * t176 - 0.1e3 / 0.27e2 * t703 * t176 - 0.5e2 / 0.27e2 * t712 * t176 + 0.1e3 / 0.27e2 * t893 * t112 + 0.1e3 / 0.27e2 * t896 * t112 + 0.5e2 / 0.27e2 * t388 * t250 + 0.5e3 / 0.81e2 * t323 + 0.5e3 / 0.81e2 * t327 - 0.2e4 / 0.243e3 * t330 - 0.2e5 / 0.729e3 * t731 * t906 - 0.1e3 / 0.27e2 * t542 * t910 + 0.1e5 / 0.243e3 * t738 * t914 - 0.2e3 / 0.27e2 * t917 * t757 + 0.2e5 / 0.729e3 * t761 * t376;
  t923 = t175 * t248;
  t924 = t312 * t923;
  t932 = t151 * t175 * t275;
  t938 = t184 * t226 * t151;
  t941 = t788 * t175;
  t944 = t286 * t184;
  t946 = t135 * t402;
  t961 = 0.5e3 / 0.81e2 * t820 * t175 - 0.5e4 / 0.243e3 * t340 + 0.5e3 / 0.81e2 * t263 * t923 + 0.1e5 / 0.729e3 * t342 + 0.25e7 / 0.19683e5 * t829 * t913 - 0.625e7 / 0.59049e5 * t345 + 0.625e6 / 0.19683e5 * t344 * t923 + 0.5e7 / 0.177147e6 * t348;
  t962 = t78 * t961;
  t976 = 0.1e5 / 0.729e3 * t311 * t924 + 0.1e3 / 0.27e2 * t557 * t380 + 0.1e3 / 0.27e2 * t770 * t380 + 0.5e2 / 0.27e2 * t232 * t932 - 0.1e6 / 0.2187e4 * t315 - 0.5e3 / 0.81e2 * t319 + 0.5e2 / 0.27e2 * t606 * t938 - 0.1e7 / 0.19683e5 * t787 * t941 - t117 * t944 - 0.2e1 * t117 * t946 - t117 * t962 + 0.2e1 * t255 * t185 * t275 + 0.4e1 * t255 * t394 * t126 + 0.4e1 * t255 * t403 * t126 - 0.6e1 * t669 * t185 * t256;
  t977 = t922 + t976;
  t982 = my_piecewise3(t3, 0, t7 * t194 * t187 / 0.12e2 - t7 * t86 * t405 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t977);
  tv3rho2tau0 = 0.2e1 * rho[0] * t982 + 0.4e1 * t410;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t988 = t428 * t329;
  t990 = t149 * t49;
  t991 = t541 * t990;
  t992 = t33 * t162;
  t993 = t992 * t126;
  t994 = t475 * t993;
  t995 = t991 * t994;
  t997 = t992 * t110;
  t998 = t732 * t997;
  t999 = t731 * t998;
  t1001 = t167 * t48;
  t1002 = t221 * t1001;
  t1003 = t1002 * t314;
  t1006 = t312 * t419 * t126;
  t1007 = t548 * t1006;
  t1009 = t419 * t110;
  t1010 = t312 * t1009;
  t1011 = t738 * t1010;
  t1013 = t557 * t424;
  t1015 = t770 * t424;
  t1018 = t151 * t152 * t350;
  t1019 = t232 * t1018;
  t1021 = t727 * t318;
  t1024 = t151 * t99 * t162;
  t1025 = t232 * t1024;
  t1027 = t588 * rho[0];
  t1028 = 0.1e1 / t1027;
  t1029 = t60 * t1028;
  t1030 = t1029 * sigma[0];
  t1033 = t299 * t302;
  t1037 = 0.25e3 / 0.4782969e7 * t619 * t1030;
  t1039 = 0.1e3 / 0.177147e6 * t204 * t1033;
  t1040 = -0.25e3 / 0.4782969e7 * t656 * t1030 + 0.1e3 / 0.177147e6 * t281 * t1033 + t1037 - t1039;
  t1042 = t627 * t110;
  t1043 = t788 * t419;
  t1044 = t1042 * t1043;
  t1046 = t237 * t431;
  t1048 = t103 * t452;
  t1051 = t27 * t302;
  t1052 = t1051 * t151;
  t1053 = t104 * t1052;
  t1055 = t167 * t350;
  t1058 = t135 * t447;
  t1060 = -0.1e3 / 0.81e2 * t988 + 0.25e2 / 0.27e2 * t995 + 0.25e4 / 0.729e3 * t999 - 0.25e4 / 0.729e3 * t1003 - 0.625e3 / 0.1458e4 * t1007 + 0.625e3 / 0.486e3 * t1011 - 0.25e2 / 0.54e2 * t1013 - 0.25e2 / 0.54e2 * t1015 - 0.25e2 / 0.54e2 * t1019 - 0.25e2 / 0.54e2 * t1021 + 0.1e3 / 0.81e2 * t1025 + t72 * t1040 - 0.3125e5 / 0.19683e5 * t1044 - 0.25e2 / 0.432e3 * t1046 - 0.5e2 / 0.27e2 * t1048 * t112 + 0.25e2 / 0.81e2 * t1053 - 0.2e1 * t117 * t1055 - t117 * t1058;
  t1061 = t110 * t60;
  t1062 = t1061 * t419;
  t1064 = t263 * t1051;
  t1066 = t829 * t1009;
  t1069 = t268 * t443 * t302;
  t1071 = 0.125e3 / 0.648e3 * t1062 - 0.25e3 / 0.243e3 * t1064 + 0.78125e5 / 0.19683e5 * t1066 - 0.3125e6 / 0.59049e5 * t1069;
  t1072 = t78 * t1071;
  t1074 = t452 * t126;
  t1076 = t135 * t434;
  t1079 = t362 * t162;
  t1094 = t312 * t1051;
  t1095 = t311 * t1094;
  t1097 = t761 * t420;
  t1099 = t362 * t47;
  t1100 = t103 * t1099;
  t1101 = t1100 * t153;
  t1103 = t167 * t110;
  t1104 = t103 * t1103;
  t1105 = t1104 * t153;
  t1107 = t78 * t27;
  t1108 = t231 * t1107;
  t1109 = t415 * t49;
  t1110 = t1109 * t607;
  t1111 = t1108 * t1110;
  t1113 = t541 * t435;
  t1116 = t231 * t438;
  t1119 = t231 * t448;
  t1122 = -t117 * t1072 - t117 * t1074 + 0.2e1 * t255 * t1076 - 0.2e1 * t117 * t1079 - 0.6e1 * t669 * t435 * t126 + 0.4e1 * t255 * t163 * t350 + 0.4e1 * t255 * t438 * t126 + 0.2e1 * t255 * t448 * t126 - t1037 + t1039 - 0.5e4 / 0.2187e4 * t1095 + 0.625e3 / 0.1458e4 * t1097 + 0.25e2 / 0.54e2 * t1101 + 0.25e2 / 0.54e2 * t1105 + 0.25e2 / 0.432e3 * t1111 - 0.1e3 / 0.27e2 * t1113 * t112 + 0.1e3 / 0.27e2 * t1116 * t112 + 0.5e2 / 0.27e2 * t1119 * t112;
  t1123 = t1060 + t1122;
  t1128 = my_piecewise3(t3, 0, -t7 * t86 * t454 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1123);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1128 + 0.2e1 * t458;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1136 = t44 * t162;
  t1138 = t732 * t1136 * t110;
  t1141 = t185 * t47;
  t1142 = t541 * t1141;
  t1143 = t1142 * t318;
  t1145 = t185 * t48;
  t1146 = t547 * t1145;
  t1147 = t1146 * t314;
  t1150 = t475 * t1136 * t126;
  t1153 = t573 * t476;
  t1154 = t388 * t1153;
  t1156 = t162 * t47;
  t1157 = t151 * t110;
  t1158 = t1156 * t1157;
  t1162 = t312 * t462 * t126;
  t1163 = t548 * t1162;
  t1165 = t462 * t110;
  t1166 = t312 * t1165;
  t1167 = t738 * t1166;
  t1174 = t151 * t175 * t350;
  t1181 = t893 * t477;
  t1183 = t475 * t98;
  t1184 = t105 * t1183;
  t1185 = t388 * t1184;
  t1187 = t896 * t477;
  t1190 = 0.325e5 / 0.2187e4 * t421 + 0.25e3 / 0.81e2 * t429 - 0.1e5 / 0.729e3 * t731 * t1138 + 0.25e2 / 0.54e2 * t1143 + 0.125e4 / 0.729e3 * t1147 - 0.1e3 / 0.27e2 * t991 * t1150 - 0.25e2 / 0.108e3 * t1154 - 0.1e3 / 0.27e2 * t917 * t1158 + 0.25e4 / 0.729e3 * t1163 - 0.25e4 / 0.243e3 * t1167 + 0.5e2 / 0.27e2 * t557 * t467 + 0.5e2 / 0.27e2 * t770 * t467 + 0.5e2 / 0.27e2 * t232 * t1174 + 0.5e2 / 0.27e2 * t727 * t380 + 0.1e5 / 0.729e3 * t1002 * t376 - 0.25e2 / 0.108e3 * t1181 + 0.5e2 / 0.81e2 * t1185 - 0.25e2 / 0.108e3 * t1187 - 0.25e3 / 0.81e2 * t425;
  t1191 = t788 * t462;
  t1192 = t1042 * t1191;
  t1194 = t237 * t472;
  t1197 = t135 * t490;
  t1199 = t1061 * t462;
  t1202 = t829 * t1165;
  t1205 = -0.125e3 / 0.81e2 * t1199 + 0.1625e4 / 0.243e3 * t441 - 0.625e6 / 0.19683e5 * t1202 + 0.203125e7 / 0.59049e5 * t445;
  t1206 = t78 * t1205;
  t1208 = t362 * t184;
  t1210 = t167 * t402;
  t1227 = t669 * t78;
  t1228 = t184 * t162;
  t1229 = t1228 * t126;
  t1236 = t461 * t49;
  t1237 = t1236 * t607;
  t1238 = t1108 * t1237;
  t1240 = t231 * t483;
  t1243 = t231 * t491;
  t1246 = t761 * t463;
  t1248 = 0.25e6 / 0.19683e5 * t1192 + 0.25e2 / 0.54e2 * t1194 - 0.325e3 / 0.162e3 * t432 - t117 * t1197 - t117 * t1206 - t117 * t1208 - t117 * t1210 + 0.2e1 * t255 * t394 * t162 + 0.2e1 * t255 * t403 * t162 + 0.2e1 * t255 * t185 * t350 + 0.2e1 * t255 * t483 * t126 + 0.2e1 * t255 * t491 * t126 - 0.6e1 * t1227 * t1229 - 0.5e2 / 0.27e2 * t1100 * t176 - 0.5e2 / 0.27e2 * t1104 * t176 - 0.25e2 / 0.54e2 * t1238 + 0.5e2 / 0.27e2 * t1240 * t112 + 0.5e2 / 0.27e2 * t1243 * t112 - 0.25e4 / 0.729e3 * t1246;
  t1249 = t1190 + t1248;
  t1254 = my_piecewise3(t3, 0, -t7 * t86 * t493 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1249);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1254 + 0.2e1 * t497;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1260 = t788 * t501;
  t1264 = t312 * t501 * t126;
  t1269 = t501 * t110;
  t1270 = t312 * t1269;
  t1274 = t44 * t184;
  t1276 = t732 * t1274 * t110;
  t1280 = t475 * t1274 * t126;
  t1289 = t151 * t175 * t402;
  t1292 = -0.2e7 / 0.19683e5 * t1042 * t1260 - 0.2e5 / 0.729e3 * t548 * t1264 + 0.2e5 / 0.729e3 * t761 * t502 + 0.2e5 / 0.243e3 * t738 * t1270 - 0.2e6 / 0.2187e4 * t464 - 0.2e5 / 0.729e3 * t731 * t1276 - 0.2e3 / 0.27e2 * t991 * t1280 + 0.1e3 / 0.27e2 * t557 * t506 + 0.1e3 / 0.27e2 * t770 * t506 - 0.5e3 / 0.81e2 * t478 + 0.1e3 / 0.27e2 * t232 * t1289;
  t1293 = t500 * t49;
  t1294 = t1293 * t607;
  t1300 = t541 * t513;
  t1306 = t135 * t512;
  t1312 = t231 * t522;
  t1318 = t135 * t521;
  t1326 = 0.1e4 / 0.81e2 * t1061 * t501 - 0.1e5 / 0.243e3 * t485 + 0.5e7 / 0.19683e5 * t829 * t1269 - 0.125e8 / 0.59049e5 * t488;
  t1327 = t78 * t1326;
  t1329 = 0.1e3 / 0.27e2 * t1108 * t1294 - 0.1e3 / 0.27e2 * t237 * t509 + 0.1e4 / 0.81e2 * t473 - 0.1e3 / 0.27e2 * t1300 * t112 - 0.6e1 * t669 * t513 * t126 + 0.2e1 * t255 * t1306 + 0.4e1 * t255 * t185 * t402 + 0.5e2 / 0.27e2 * t1312 * t112 + 0.2e1 * t255 * t522 * t126 - t117 * t1318 - t117 * t1327;
  t1330 = t1292 + t1329;
  t1335 = my_piecewise3(t3, 0, -t7 * t86 * t524 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1330);
  tv3rhotau20 = 0.2e1 * rho[0] * t1335 + 0.2e1 * t528;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1338 = 0.1e1 / t588;
  t1339 = t1338 * t60;
  t1340 = t619 * t1339;
  t1342 = t167 * t434;
  t1345 = t452 * t162;
  t1348 = t167 * t447;
  t1352 = t67 * t1338;
  t1353 = t641 * t1352;
  t1355 = -0.125e3 / 0.2592e4 * t1339 - 0.78125e5 / 0.78732e5 * t1353;
  t1356 = t78 * t1355;
  t1360 = 0.125e3 / 0.6377292e7 * t656 * t1339 - 0.125e3 / 0.6377292e7 * t1340;
  t1362 = t1338 * t71;
  t1364 = t627 * t1362 * t78;
  t1366 = t434 * t162;
  t1367 = t78 * t1366;
  t1370 = t163 * t447;
  t1373 = t727 * t424;
  t1376 = t151 * t152 * t447;
  t1377 = t232 * t1376;
  t1380 = t312 * t419 * t162;
  t1381 = t548 * t1380;
  t1383 = t1002 * t420;
  t1385 = t52 * t162;
  t1386 = t1109 * t1385;
  t1387 = t1108 * t1386;
  t1389 = t452 * t47;
  t1390 = t103 * t1389;
  t1391 = t1390 * t153;
  t1394 = t151 * t152 * t434;
  t1395 = t542 * t1394;
  t1397 = t353 * t431;
  t1399 = t225 * t1338;
  t1400 = t600 * t1399;
  t1401 = t222 * t1400;
  t1403 = 0.125e3 / 0.6377292e7 * t1340 + 0.6e1 * t255 * t1342 - 0.3e1 * t117 * t1345 - 0.3e1 * t117 * t1348 - t117 * t1356 + t72 * t1360 + 0.15625e5 / 0.39366e5 * t1364 - 0.6e1 * t669 * t1367 + 0.6e1 * t255 * t1370 - 0.25e2 / 0.18e2 * t1373 - 0.25e2 / 0.36e2 * t1377 - 0.625e3 / 0.486e3 * t1381 + 0.625e3 / 0.486e3 * t1383 + 0.25e2 / 0.144e3 * t1387 + 0.25e2 / 0.36e2 * t1391 + 0.25e2 / 0.18e2 * t1395 - 0.25e2 / 0.144e3 * t1397 - 0.625e3 / 0.1944e4 * t1401;
  t1407 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1403);
  tv3sigma30 = 0.2e1 * rho[0] * t1407;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1409 = 0.1e1 / t208;
  t1410 = t1409 * t71;
  t1412 = t627 * t1410 * t78;
  t1414 = t483 * t162;
  t1417 = t491 * t162;
  t1420 = t185 * t447;
  t1423 = t185 * t434;
  t1426 = t1002 * t463;
  t1428 = t1236 * t1385;
  t1429 = t1108 * t1428;
  t1433 = t388 * t431;
  t1435 = t452 * t184;
  t1437 = t167 * t490;
  t1440 = -0.625e5 / 0.19683e5 * t1412 + 0.4e1 * t255 * t1414 + 0.4e1 * t255 * t1417 + 0.2e1 * t255 * t1420 - 0.6e1 * t669 * t1423 - 0.5e4 / 0.729e3 * t1426 - 0.25e2 / 0.27e2 * t1429 - 0.5e2 / 0.27e2 * t1390 * t176 + 0.25e2 / 0.432e3 * t1433 - t117 * t1435 - 0.2e1 * t117 * t1437;
  t1441 = t1409 * t60;
  t1443 = t67 * t1409;
  t1444 = t641 * t1443;
  t1446 = 0.125e3 / 0.324e3 * t1441 + 0.15625e6 / 0.19683e5 * t1444;
  t1447 = t78 * t1446;
  t1449 = t1240 * t477;
  t1451 = t1243 * t477;
  t1453 = t225 * t27;
  t1455 = t223 * t1453 * t415;
  t1456 = t884 * t1455;
  t1459 = t312 * t462 * t162;
  t1460 = t548 * t1459;
  t1465 = t151 * t175 * t447;
  t1469 = t151 * t175 * t434;
  t1472 = t1142 * t424;
  t1474 = t225 * t1409;
  t1475 = t600 * t1474;
  t1476 = t222 * t1475;
  t1478 = t353 * t472;
  t1480 = -t117 * t1447 - 0.25e2 / 0.54e2 * t1449 - 0.25e2 / 0.54e2 * t1451 - 0.625e3 / 0.1458e4 * t1456 + 0.5e4 / 0.729e3 * t1460 + 0.1e3 / 0.27e2 * t727 * t467 + 0.5e2 / 0.27e2 * t232 * t1465 - 0.1e3 / 0.27e2 * t542 * t1469 + 0.25e2 / 0.27e2 * t1472 + 0.625e3 / 0.243e3 * t1476 + 0.25e2 / 0.27e2 * t1478;
  t1481 = t1440 + t1480;
  t1485 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1481);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1485;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1487 = 0.1e1 / t300;
  t1488 = t1487 * t71;
  t1490 = t627 * t1488 * t78;
  t1493 = t312 * t501 * t162;
  t1498 = t225 * t1487;
  t1499 = t600 * t1498;
  t1500 = t222 * t1499;
  t1503 = t312 * t462 * t184;
  t1504 = t548 * t1503;
  t1507 = t475 * t1274 * t162;
  t1512 = t52 * t184;
  t1513 = t1236 * t1512;
  t1514 = t1108 * t1513;
  t1517 = t151 * t175 * t490;
  t1520 = t1293 * t1385;
  t1525 = t1300 * t477;
  t1530 = t167 * t512;
  t1536 = t1312 * t477;
  t1541 = t167 * t521;
  t1543 = t1487 * t60;
  t1545 = t67 * t1487;
  t1546 = t641 * t1545;
  t1548 = -0.25e3 / 0.81e2 * t1543 - 0.125e7 / 0.19683e5 * t1546;
  t1549 = t78 * t1548;
  t1551 = 0.5e6 / 0.19683e5 * t1490 - 0.2e5 / 0.729e3 * t548 * t1493 + 0.2e5 / 0.729e3 * t1002 * t502 - 0.5e4 / 0.243e3 * t1500 + 0.5e4 / 0.729e3 * t1504 - 0.2e3 / 0.27e2 * t991 * t1507 + 0.1e3 / 0.27e2 * t727 * t506 - 0.25e2 / 0.27e2 * t1514 + 0.1e3 / 0.27e2 * t232 * t1517 + 0.1e3 / 0.27e2 * t1108 * t1520 - 0.1e3 / 0.27e2 * t353 * t509 + 0.25e2 / 0.54e2 * t1525 - 0.6e1 * t669 * t513 * t162 + 0.2e1 * t255 * t1530 + 0.4e1 * t255 * t185 * t490 - 0.25e2 / 0.108e3 * t1536 + 0.2e1 * t255 * t522 * t162 - t117 * t1541 - t117 * t1549;
  t1555 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1551);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1555;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1557 = 0.1e1 / t413;
  t1558 = t1557 * t71;
  t1563 = t312 * t501 * t184;
  t1566 = t225 * t1557;
  t1567 = t600 * t1566;
  t1571 = t151 * t175 * t512;
  t1574 = t1293 * t1512;
  t1578 = t151 * t175 * t521;
  t1581 = t512 * t184;
  t1582 = t78 * t1581;
  t1585 = t185 * t521;
  t1590 = t67 * t1557;
  t1593 = 0.2e4 / 0.81e2 * t1557 * t60 + 0.1e8 / 0.19683e5 * t641 * t1590;
  t1594 = t78 * t1593;
  t1596 = -0.4e7 / 0.19683e5 * t627 * t1558 * t78 - 0.2e5 / 0.243e3 * t548 * t1563 + 0.4e5 / 0.243e3 * t222 * t1567 - 0.1e3 / 0.9e1 * t542 * t1571 + 0.1e3 / 0.9e1 * t1108 * t1574 + 0.5e2 / 0.9e1 * t232 * t1578 - 0.6e1 * t669 * t1582 + 0.6e1 * t255 * t1585 - t117 * t1594;
  t1600 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1596);
  tv3tau30 = 0.2e1 * rho[0] * t1600;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1618 = t275 * t47 * t1157;
  t1628 = t206 * t27 / t19 / t1027;
  t1630 = 0.3916e6 / 0.4782969e7 * t204 * t1628;
  t1632 = 0.1e1 / t31 / t300;
  t1633 = t28 * t1632;
  t1634 = t95 * t1633;
  t1636 = 0.2618e5 / 0.19683e5 * t94 * t1634;
  t1637 = t541 * t78;
  t1638 = t52 * t256;
  t1642 = t226 * t226;
  t1649 = t248 * t248;
  t1657 = t627 * t601;
  t1658 = t116 * t78;
  t1659 = t1658 * t126;
  t1664 = t90 / t654 / t73;
  t1665 = t205 * t205;
  t1666 = t60 * t1665;
  t1672 = 0.1e1 / t31 / t588 / t300 * t21 * t145;
  t1675 = t588 * t207;
  t1677 = t621 / t1675;
  t1686 = t90 / t617 / t37;
  t1689 = 0.64e6 / 0.31381059609e11 * t1686 * t1666 * t1672;
  t1691 = 0.352e6 / 0.43046721e8 * t619 * t1677;
  t1701 = t110 * t583;
  t1708 = 0.616e4 / 0.81e2 * t42 * t580 - 0.2618e4 / 0.81e2 * t29 * t1632;
  t1711 = params->b * t48;
  t1730 = -0.4e3 / 0.9e1 * t541 * t127 * t1618 - 0.4e5 / 0.243e3 * t548 * t312 * t233 * t248 - t1630 + t1636 - 0.2e3 / 0.9e1 * t1637 * t240 * t1638 + 0.1e5 / 0.243e3 * t222 * t1642 * t21 * t225 - 0.1e3 / 0.9e1 * t568 * t241 - 0.5e2 / 0.9e1 * t104 * t1649 * t49 * t52 - 0.2e7 / 0.6561e4 * t787 * t788 * t248 + 0.4e7 / 0.19683e5 * t1657 * t1659 + t72 * (-0.64e6 / 0.31381059609e11 * t1664 * t1666 * t1672 + 0.352e6 / 0.43046721e8 * t656 * t1677 - 0.3916e6 / 0.4782969e7 * t281 * t1628 + 0.2618e5 / 0.19683e5 * t132 * t1634 + t1689 - t1691 + t1630 - t1636) - 0.4e1 * t117 * t135 * t651 - t117 * t78 * (0.1e4 / 0.27e2 * t820 * t248 + 0.5e3 / 0.27e2 * t263 * t1649 + 0.2e4 / 0.81e2 * t263 * t1701 + 0.25e3 / 0.81e2 * t118 * t1708 + 0.25e7 / 0.6561e4 * t1711 * t67 * t1642 + 0.5e7 / 0.6561e4 * t641 * t269 * t248 + 0.625e6 / 0.6561e4 * t268 * t67 * t1649 + 0.25e7 / 0.19683e5 * t268 * t123 * t583 + 0.125e6 / 0.19683e5 * t122 * t67 * t1708);
  t1743 = t275 * t275;
  t1749 = t57 / t667 / t70;
  t1750 = t256 * t256;
  t1757 = t48 * t67;
  t1776 = -0.6e1 * t117 * t286 * t275 - 0.24e2 * t669 * t135 * t670 - 0.4e1 * t117 * t663 * t126 + 0.12e2 * t255 * t286 * t256 + 0.6e1 * t255 * t78 * t1743 + 0.24e2 * t1749 * t78 * t1750 + 0.8e1 * t255 * t127 * t651 + t1691 - 0.2e7 / 0.6561e4 * t1757 * t1642 * t71 * t78 - 0.1e3 / 0.9e1 * t568 * t250 - 0.2e3 / 0.27e2 * t104 * t573 * t584 - 0.5e2 / 0.27e2 * t104 * t105 * t52 * t1708 - 0.2e3 / 0.27e2 * t103 * t663 * t112 + 0.4e5 / 0.243e3 * t611 * t603;
  t1778 = t52 * t275;
  t1798 = t231 * t135;
  t1805 = t547 * t149;
  t1814 = t55 * t254;
  t1815 = t1814 * t310;
  t1820 = 0.1e3 / 0.9e1 * t606 * t240 * t1778 + 0.2e5 / 0.243e3 * t221 * t286 * t228 - 0.4e7 / 0.19683e5 * t627 * t628 * t135 - 0.36e2 * t669 * t257 * t275 + 0.24e2 * t255 * t260 * t275 + 0.1e5 / 0.243e3 * t222 * t223 * t225 * t1649 + 0.2e3 / 0.9e1 * t1798 * t608 - 0.2e3 / 0.9e1 * t237 * t574 - 0.2e3 / 0.27e2 * t237 * t585 - t1689 - 0.4e5 / 0.243e3 * t1805 * t312 * t601 * t126 - 0.2e3 / 0.9e1 * t542 * t151 * t248 * t256 + 0.4e5 / 0.243e3 * t1815 * t312 * t226 * t256;
  t1843 = t547 * t760;
  t1861 = t56 * t668;
  t1865 = 0.2e3 / 0.9e1 * t770 * t561 + 0.2e3 / 0.27e2 * t232 * t151 * t583 * t126 + 0.1e3 / 0.9e1 * t232 * t151 * t248 * t275 - 0.4e3 / 0.9e1 * t541 * t674 * t112 + 0.2e3 / 0.9e1 * t231 * t677 * t112 + 0.2e3 / 0.9e1 * t231 * t632 * t112 + 0.2e3 / 0.27e2 * t231 * t652 * t112 - 0.4e5 / 0.243e3 * t1843 * t550 - 0.2e5 / 0.243e3 * t548 * t312 * t226 * t275 + 0.2e5 / 0.81e2 * t738 * t312 * t226 * t248 + 0.4e5 / 0.243e3 * t761 * t554 + 0.4e5 / 0.729e3 * t311 * t312 * t1701 + 0.2e3 / 0.9e1 * t557 * t561 + 0.4e3 / 0.9e1 * t1861 * t671 * t112;
  t1872 = my_piecewise3(t3, 0, 0.1e2 / 0.27e2 * t7 * t18 * t98 * t80 - 0.5e1 / 0.9e1 * t7 * t531 * t137 + t7 * t194 * t288 / 0.2e1 - t7 * t86 * t681 / 0.2e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t1730 + t1776 + t1820 + t1865));
  tv4rho40 = 0.2e1 * rho[0] * t1872 + 0.8e1 * t686;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1885 = t33 * t126;
  t1891 = t547 * t760 * t21;
  t1894 = t33 * t248;
  t1904 = t221 * t711 * t21;
  t1910 = t1814 * t730;
  t1916 = t547 * t149 * t21;
  t1935 = t152 * t583;
  t1941 = 0.25e2 / 0.18e2 * t991 * t475 * t1885 * t275 + 0.25e4 / 0.243e3 * t1891 * t735 + 0.125e4 / 0.243e3 * t731 * t732 * t1894 * t126 + 0.125e4 / 0.243e3 * t731 * t732 * t733 * t275 - 0.125e4 / 0.81e2 * t1904 * t732 * t33 * t47 * t110 - 0.25e4 / 0.243e3 * t1910 * t732 * t733 * t256 + 0.125e4 / 0.81e2 * t1916 * t732 * t33 * t226 * t126 - 0.2e5 / 0.729e3 * t731 * t732 * t98 * t110 * t126 - 0.25e2 / 0.36e2 * t770 * t776 - 0.25e2 / 0.108e3 * t232 * t151 * t152 * t651 - 0.125e4 / 0.243e3 * t761 * t765 - 0.125e4 / 0.729e3 * t311 * t312 * t1935 - 0.25e2 / 0.36e2 * t557 * t776;
  t1951 = t217 * t110;
  t1954 = t99 * t248;
  t1961 = t1711 * t67;
  t1965 = t99 * t226;
  t1980 = -0.125e3 / 0.54e2 * t1061 * t764 + 0.5e3 / 0.81e2 * t820 * t99 - 0.55e4 / 0.243e3 * t263 * t1951 + 0.5e3 / 0.81e2 * t263 * t1954 - 0.125e3 / 0.162e3 * t263 * t1935 + 0.385e5 / 0.2187e4 * t118 * t595 - 0.3125e6 / 0.6561e4 * t1961 * t152 * t601 + 0.25e7 / 0.19683e5 * t829 * t1965 - 0.3125e6 / 0.6561e4 * t829 * t152 * t553 - 0.6875e7 / 0.59049e5 * t344 * t1951 + 0.625e6 / 0.19683e5 * t344 * t1954 - 0.78125e5 / 0.19683e5 * t344 * t1935 + 0.1925e8 / 0.531441e6 * t122 * t158 * t580;
  t2011 = 0.2e5 / 0.729e3 * t761 * t744 - 0.3e1 * t117 * t135 * t839 - t117 * t78 * t1980 - t117 * t167 * t651 - t117 * t663 * t162 - 0.3e1 * t117 * t286 * t350 - 0.3e1 * t117 * t815 * t126 - 0.3e1 * t117 * t362 * t275 + 0.6e1 * t255 * t362 * t256 - 0.6e1 * t669 * t167 * t670 + 0.12e2 * t255 * t817 * t126 + 0.6e1 * t255 * t338 * t275 + 0.6e1 * t255 * t840 * t126;
  t2019 = t60 / t31 / t588 / t413;
  t2022 = t620 * t21 * t145;
  t2026 = t60 * t623 * t205;
  t2030 = t299 * t590 * sigma[0];
  t2033 = t145 * t580;
  t2038 = 0.8e5 / 0.10460353203e11 * t1686 * t2019 * t2022;
  t2040 = 0.38e5 / 0.14348907e8 * t619 * t2026;
  t2042 = 0.341e5 / 0.1594323e7 * t204 * t2030;
  t2044 = 0.154e4 / 0.6561e4 * t94 * t2033;
  t2075 = 0.6e1 * t255 * t351 * t275 + t72 * (0.8e5 / 0.10460353203e11 * t1664 * t2019 * t2022 - 0.38e5 / 0.14348907e8 * t656 * t2026 + 0.341e5 / 0.1594323e7 * t281 * t2030 - 0.154e4 / 0.6561e4 * t132 * t2033 - t2038 + t2040 - t2042 + t2044) + 0.2e1 * t255 * t163 * t651 + 0.6e1 * t255 * t356 * t275 - 0.1e7 / 0.19683e5 * t627 * t628 * t167 + 0.6e1 * t255 * t848 * t126 - 0.18e2 * t669 * t351 * t256 + 0.24e2 * t1749 * t163 * t670 - 0.5e2 / 0.9e1 * t779 * t241 - t2040 - 0.18e2 * t669 * t338 * t256 + 0.1e5 / 0.243e3 * t221 * t362 * t228 - 0.5e2 / 0.9e1 * t353 * t574;
  t2080 = t71 * t135;
  t2087 = t1757 * t601;
  t2101 = t231 * t167;
  t2114 = 0.1e5 / 0.243e3 * t784 * t603 - 0.5e2 / 0.27e2 * t353 * t585 + 0.125e6 / 0.6561e4 * t787 * t2080 * t152 - 0.5e2 / 0.9e1 * t103 * t815 * t112 + 0.25e6 / 0.6561e4 * t2087 * t789 - 0.1e7 / 0.19683e5 * t787 * t788 * t99 - 0.5e2 / 0.9e1 * t779 * t250 + 0.5e2 / 0.9e1 * t1798 * t797 + 0.5e2 / 0.9e1 * t606 * t350 * t226 * t151 + 0.5e2 / 0.9e1 * t2101 * t608 + t2042 - 0.2e3 / 0.9e1 * t541 * t338 * t757 - 0.2e3 / 0.9e1 * t541 * t351 * t757 - 0.55e3 / 0.81e2 * t232 * t151 * t217 * t126;
  t2123 = t1861 * t149;
  t2132 = t1658 * t162;
  t2142 = t541 * t321;
  t2145 = t541 * t325;
  t2156 = 0.1e5 / 0.243e3 * t738 * t312 * t1965 - 0.11e6 / 0.2187e4 * t311 * t312 * t1951 - 0.25e2 / 0.18e2 * t2123 * t151 * t152 * t670 - 0.1e3 / 0.27e2 * t542 * t151 * t99 * t256 - t2044 + 0.1e7 / 0.19683e5 * t1657 * t2132 - 0.18e2 * t1227 * t162 * t275 * t126 + 0.1e5 / 0.729e3 * t311 * t312 * t1954 + 0.25e2 / 0.18e2 * t2142 * t748 + 0.25e2 / 0.18e2 * t2145 * t748 + 0.1e3 / 0.27e2 * t557 * t752 + 0.1e3 / 0.27e2 * t770 * t752 + 0.5e2 / 0.27e2 * t232 * t151 * t99 * t275;
  t2157 = t231 * t702;
  t2161 = t221 * t135 * t226;
  t2163 = t312 * t152 * t47;
  t2170 = t256 * t47 * t1157;
  t2174 = t105 * t249 * t126;
  t2179 = t223 * t225 * t248 * t110;
  t2184 = t223 * t227 * t126;
  t2187 = t231 * t698;
  t2191 = t221 * t286 * t48;
  t2194 = t231 * t711;
  t2200 = t627 * t226 * t116;
  t2201 = t78 * t28;
  t2207 = -0.25e2 / 0.18e2 * t2157 * t318 - 0.125e4 / 0.81e2 * t2161 * t2163 - 0.1e3 / 0.9e1 * t755 * t1618 + 0.1e3 / 0.3e1 * t1861 * t163 * t2170 - 0.1e3 / 0.9e1 * t755 * t2174 - 0.1e5 / 0.243e3 * t723 * t2179 + 0.2e5 / 0.243e3 * t1814 * t163 * t2184 - 0.25e2 / 0.36e2 * t2187 * t318 - 0.125e4 / 0.243e3 * t2191 * t314 - 0.25e2 / 0.36e2 * t2194 * t318 + t2038 + 0.55e3 / 0.81e2 * t322 * t708 - 0.125e6 / 0.6561e4 * t2200 * t2201 * t1885 + 0.1e5 / 0.243e3 * t1002 * t554;
  t2210 = t627 * t110 * t71;
  t2215 = t103 * t663 * t47;
  t2219 = t103 * t286 * t110;
  t2238 = t231 * t1099;
  t2245 = 0.125e6 / 0.6561e4 * t2210 * t2201 * t1894 + 0.25e2 / 0.108e3 * t2215 * t153 + 0.25e2 / 0.36e2 * t2219 * t153 + 0.5e2 / 0.9e1 * t231 * t840 * t112 + 0.5e2 / 0.9e1 * t718 * t250 - 0.1e5 / 0.243e3 * t547 * t351 * t228 - 0.1e3 / 0.9e1 * t755 * t608 + 0.5e2 / 0.9e1 * t332 * t574 - 0.1e5 / 0.243e3 * t723 * t603 + 0.5e2 / 0.27e2 * t332 * t585 + 0.1e3 / 0.9e1 * t2238 * t234 + 0.5e2 / 0.9e1 * t727 * t561 + 0.5e2 / 0.9e1 * t727 * t565;
  t2246 = t547 * t1001;
  t2250 = t103 * t135 * t248;
  t2254 = t103 * t78 * t583;
  t2276 = t221 * t78 * t601;
  t2280 = t541 * t427;
  t2287 = -0.1e5 / 0.243e3 * t2246 * t550 + 0.25e2 / 0.36e2 * t2250 * t153 + 0.25e2 / 0.108e3 * t2254 * t153 + 0.5e2 / 0.9e1 * t231 * t848 * t112 + 0.1e3 / 0.9e1 * t231 * t817 * t112 + 0.5e2 / 0.9e1 * t715 * t250 - 0.1e5 / 0.243e3 * t547 * t338 * t228 - 0.77e4 / 0.729e3 * t150 * t151 * t595 + 0.55e3 / 0.81e2 * t326 * t708 - 0.1e3 / 0.27e2 * t703 * t329 - 0.125e4 / 0.243e3 * t2276 * t312 * t152 - 0.1e3 / 0.9e1 * t2280 * t544 - 0.5e2 / 0.27e2 * t699 * t329 - 0.5e2 / 0.27e2 * t712 * t329;
  t2295 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t531 * t169 + t7 * t194 * t364 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t86 * t869 - 0.3e1 / 0.8e1 * t7 * t20 * (t1941 + t2011 + t2075 + t2114 + t2156 + t2207 + t2245 + t2287));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2295 + 0.6e1 * t874;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2319 = t44 * t126;
  t2331 = t44 * t248;
  t2346 = t184 * t126;
  t2350 = t1658 * t184;
  t2357 = -0.2e4 / 0.81e2 * t696 + 0.25e3 / 0.27e2 * t700 + 0.5e3 / 0.27e2 * t704 - 0.2e4 / 0.81e2 * t706 + 0.22e5 / 0.729e3 * t709 + 0.25e3 / 0.27e2 * t713 - 0.1e5 / 0.81e2 * t1916 * t732 * t44 * t226 * t126 - 0.1e3 / 0.9e1 * t991 * t475 * t2319 * t275 + 0.2e5 / 0.243e3 * t1910 * t732 * t44 * t256 * t110 - 0.2e5 / 0.243e3 * t1891 * t906 - 0.1e5 / 0.243e3 * t731 * t732 * t2331 * t126 - 0.1e5 / 0.243e3 * t731 * t732 * t904 * t275 + 0.1e5 / 0.81e2 * t1904 * t732 * t44 * t47 * t110 + 0.1e6 / 0.729e3 * t736 - 0.18e2 * t1227 * t2346 * t275 + 0.1e7 / 0.19683e5 * t1657 * t2350 - 0.5e5 / 0.243e3 * t741 + 0.4e6 / 0.2187e4 * t745 + 0.5e3 / 0.27e2 * t749 + 0.2e4 / 0.81e2 * t753;
  t2398 = t175 * t583;
  t2414 = 0.5e3 / 0.27e2 * t1061 * t923 - 0.25e4 / 0.81e2 * t821 + 0.2e5 / 0.243e3 * t823 - 0.25e4 / 0.81e2 * t825 + 0.5e3 / 0.81e2 * t263 * t2398 - 0.11e6 / 0.2187e4 * t827 + 0.25e7 / 0.6561e4 * t1961 * t175 * t601 - 0.125e8 / 0.19683e5 * t830 + 0.25e7 / 0.6561e4 * t829 * t175 * t553 + 0.25e8 / 0.59049e5 * t832 - 0.3125e7 / 0.19683e5 * t834 + 0.625e6 / 0.19683e5 * t344 * t2398 - 0.55e8 / 0.531441e6 * t837;
  t2425 = -0.1e6 / 0.729e3 * t762 - 0.5e5 / 0.729e3 * t766 - 0.5e3 / 0.27e2 * t768 - 0.5e3 / 0.27e2 * t771 - 0.25e3 / 0.27e2 * t777 + 0.5e7 / 0.19683e5 * t790 - 0.1e7 / 0.6561e4 * t787 * t2080 * t175 - 0.2e7 / 0.6561e4 * t2087 * t941 + 0.2e1 * t255 * t185 * t651 + 0.6e1 * t255 * t944 * t126 + 0.12e2 * t255 * t946 * t126 + 0.6e1 * t255 * t394 * t275 + 0.6e1 * t255 * t962 * t126 + 0.6e1 * t255 * t403 * t275 - 0.18e2 * t669 * t394 * t256 - 0.18e2 * t669 * t403 * t256 - t117 * t78 * t2414 - t117 * t663 * t184 - 0.3e1 * t117 * t286 * t402 - 0.3e1 * t117 * t135 * t961;
  t2429 = t547 * t394;
  t2432 = t231 * t962;
  t2437 = t547 * t403;
  t2455 = t231 * t944;
  t2458 = t231 * t946;
  t2477 = 0.5e2 / 0.9e1 * t893 * t250 - 0.1e5 / 0.243e3 * t2429 * t228 + 0.5e2 / 0.9e1 * t2432 * t112 + 0.5e2 / 0.9e1 * t896 * t250 - 0.1e5 / 0.243e3 * t2437 * t228 - 0.1e3 / 0.9e1 * t917 * t608 + 0.5e2 / 0.9e1 * t388 * t574 - 0.1e7 / 0.6561e4 * t2210 * t2201 * t2331 - 0.5e2 / 0.27e2 * t2215 * t176 - 0.5e2 / 0.9e1 * t2219 * t176 - 0.5e2 / 0.9e1 * t2250 * t176 - 0.5e2 / 0.27e2 * t2254 * t176 + 0.5e2 / 0.9e1 * t2455 * t112 + 0.1e3 / 0.9e1 * t2458 * t112 - 0.1e5 / 0.243e3 * t884 * t603 + 0.5e2 / 0.27e2 * t388 * t585 + 0.1e7 / 0.6561e4 * t2200 * t2201 * t2319 + 0.1e5 / 0.243e3 * t2276 * t312 * t175 + 0.5e2 / 0.9e1 * t1798 * t938 + 0.5e2 / 0.9e1 * t606 * t402 * t226 * t151;
  t2484 = t541 * t394;
  t2487 = t541 * t403;
  t2494 = t1861 * t185;
  t2517 = t1814 * t185;
  t2533 = 0.1e5 / 0.243e3 * t761 * t924 + 0.1e5 / 0.729e3 * t311 * t312 * t2398 + 0.5e2 / 0.9e1 * t557 * t932 + 0.5e2 / 0.9e1 * t770 * t932 + 0.5e2 / 0.27e2 * t232 * t151 * t175 * t651 + 0.2e5 / 0.243e3 * t2517 * t2184 - 0.1e3 / 0.9e1 * t917 * t1618 - 0.1e3 / 0.9e1 * t2142 * t910 - 0.1e3 / 0.9e1 * t2145 * t910 + 0.1e5 / 0.81e2 * t2161 * t312 * t175 * t47 + 0.24e2 * t1749 * t185 * t670;
  t2541 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t531 * t187 + t7 * t194 * t405 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t86 * t977 - 0.3e1 / 0.8e1 * t7 * t20 * (t2357 + t2425 + t2477 + 0.1e3 / 0.9e1 * t2123 * t151 * t175 * t670 + 0.5e2 / 0.9e1 * t2194 * t380 - 0.2e3 / 0.9e1 * t2484 * t757 - 0.2e3 / 0.9e1 * t2487 * t757 - 0.1e3 / 0.9e1 * t917 * t2174 - 0.1e5 / 0.243e3 * t884 * t2179 + 0.1e3 / 0.3e1 * t2494 * t2170 + 0.5e2 / 0.9e1 * t2187 * t380 + 0.1e5 / 0.243e3 * t2191 * t376 + 0.1e3 / 0.9e1 * t2157 * t380 + t2533));
  tv4rho3tau0 = 0.2e1 * rho[0] * t2541 + 0.6e1 * t982;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2551 = t1861 * t990;
  t2556 = t98 * t162;
  t2574 = t541 * t321 * t49;
  t2580 = t541 * t325 * t49;
  t2583 = t78 * t226;
  t2585 = t547 * t2583 * t21;
  t2590 = t33 * t350;
  t2600 = t547 * t1001 * t21;
  t2603 = t415 * t126;
  t2610 = -0.25e2 / 0.9e1 * t2551 * t475 * t992 * t256 - 0.4e3 / 0.81e2 * t991 * t475 * t2556 * t126 + 0.25e2 / 0.27e2 * t991 * t475 * t992 * t275 - 0.4e5 / 0.2187e4 * t731 * t732 * t2556 * t110 + 0.25e4 / 0.729e3 * t731 * t732 * t992 * t248 + 0.5e2 / 0.27e2 * t2574 * t994 + 0.5e4 / 0.729e3 * t1891 * t998 + 0.5e2 / 0.27e2 * t2580 * t994 + 0.25e4 / 0.243e3 * t2585 * t732 * t992 * t47 + 0.5e2 / 0.27e2 * t991 * t475 * t2590 * t126 + 0.5e4 / 0.729e3 * t731 * t732 * t2590 * t110 + 0.5e4 / 0.729e3 * t2600 * t735 - 0.625e3 / 0.243e3 * t1916 * t1453 * t2603 * t110 - 0.5e2 / 0.27e2 * t1048 * t250;
  t2616 = t627 * t248;
  t2635 = t162 * t126;
  t2636 = t2635 * t110;
  t2640 = t350 * t350;
  t2652 = t248 * t60;
  t2662 = t1051 * t110;
  t2665 = t419 * t248;
  t2677 = 0.1e5 / 0.729e3 * t221 * t452 * t228 + 0.5e2 / 0.81e2 * t237 * t1052 - 0.3125e5 / 0.19683e5 * t2616 * t1043 - 0.25e2 / 0.432e3 * t568 * t431 - 0.475e3 / 0.243e3 * t104 * t211 * t151 - 0.1e3 / 0.27e2 * t1637 * t434 * t226 * t151 + 0.1e3 / 0.27e2 * t2101 * t797 + 0.5e2 / 0.27e2 * t606 * t447 * t226 * t151 - 0.1e5 / 0.729e3 * t1910 * t732 * t33 * t2636 + 0.4e1 * t255 * t78 * t2640 + 0.2e1 * t255 * t452 * t256 - t117 * t452 * t275 - 0.2e1 * t117 * t135 * t1071 - t117 * t78 * (0.125e3 / 0.648e3 * t2652 * t419 - 0.5e3 / 0.243e3 * t1061 * t1051 + 0.475e4 / 0.729e3 * t263 * t211 + 0.78125e5 / 0.6561e4 * t1961 * t419 * t226 - 0.25e7 / 0.59049e5 * t829 * t2662 + 0.78125e5 / 0.19683e5 * t829 * t2665 + 0.59375e7 / 0.177147e6 * t268 * t443 * t210) - 0.2e1 * t117 * t1040 * t126;
  t2698 = t802 * sigma[0];
  t2700 = 0.1075e5 / 0.14348907e8 * t619 * t2698;
  t2719 = -0.4e1 * t117 * t362 * t350 - 0.2e1 * t117 * t167 * t839 - t117 * t286 * t447 + 0.2e1 * t255 * t286 * t434 - 0.2e1 * t117 * t815 * t162 - 0.5e2 / 0.27e2 * t1048 * t241 + 0.4e1 * t255 * t1072 * t126 + t2700 + 0.24e2 * t1749 * t435 * t256 - 0.12e2 * t669 * t438 * t256 - 0.6e1 * t669 * t448 * t256 - 0.12e2 * t669 * t1076 * t126 + 0.8e1 * t255 * t338 * t350 + 0.8e1 * t255 * t1079 * t126;
  t2740 = t60 / t31 / t1675;
  t2743 = t205 * t21 * t145;
  t2748 = t299 * t210;
  t2753 = 0.1e5 / 0.3486784401e10 * t1686 * t2740 * t2743;
  t2755 = 0.19e4 / 0.531441e6 * t204 * t2748;
  t2766 = t627 * t110 * t116;
  t2773 = t103 * t362 * t110;
  t2777 = t103 * t167 * t248;
  t2780 = 0.8e1 * t255 * t1055 * t126 + 0.4e1 * t255 * t1058 * t126 - 0.6e1 * t669 * t435 * t275 + 0.4e1 * t255 * t163 * t839 + 0.4e1 * t255 * t438 * t275 + 0.2e1 * t255 * t448 * t275 + t72 * (-0.1e5 / 0.3486784401e10 * t1664 * t2740 * t2743 + 0.1075e5 / 0.14348907e8 * t656 * t2698 - 0.19e4 / 0.531441e6 * t281 * t2748 + t2753 - t2700 + t2755) - t2755 + 0.1e3 / 0.27e2 * t231 * t1074 * t112 - 0.2e3 / 0.81e2 * t1100 * t329 - 0.2e3 / 0.81e2 * t1104 * t329 + 0.625e5 / 0.19683e5 * t2766 * t1107 * t2603 - 0.1e5 / 0.2187e4 * t761 * t1094 + 0.25e2 / 0.27e2 * t2773 * t153 + 0.25e2 / 0.54e2 * t2777 * t153;
  t2784 = t231 * t135 * t27;
  t2823 = 0.25e2 / 0.216e3 * t2784 * t1110 + 0.25e2 / 0.432e3 * t1108 * t1109 * t1778 - 0.1e3 / 0.27e2 * t1113 * t250 + 0.2e5 / 0.729e3 * t1814 * t435 * t228 - 0.2e3 / 0.27e2 * t541 * t1076 * t112 + 0.2e3 / 0.27e2 * t231 * t1079 * t112 + 0.2e3 / 0.27e2 * t231 * t1055 * t112 + 0.1e3 / 0.27e2 * t231 * t1058 * t112 + 0.1e3 / 0.27e2 * t231 * t1072 * t112 + 0.1e3 / 0.27e2 * t1116 * t250 - 0.2e5 / 0.729e3 * t547 * t438 * t228 + 0.5e2 / 0.27e2 * t1119 * t250 - 0.1e5 / 0.729e3 * t547 * t448 * t228 - 0.25e6 / 0.19683e5 * t2200 * t2201 * t992;
  t2827 = t103 * t815 * t47;
  t2835 = t541 * t1107;
  t2839 = t302 * t49;
  t2843 = t221 * t2583;
  t2868 = 0.625e3 / 0.1458e4 * t2191 * t420 + 0.25e2 / 0.54e2 * t2827 * t153 + 0.11e4 / 0.243e3 * t428 * t708 - 0.24e2 * t1227 * t2635 * t350 - t2753 - 0.25e2 / 0.216e3 * t2835 * t1109 * t1638 - 0.5e2 / 0.81e2 * t1108 * t2839 * t607 + 0.625e3 / 0.486e3 * t2843 * t420 + 0.95e5 / 0.6561e4 * t311 * t312 * t211 + 0.1e5 / 0.2187e4 * t548 * t312 * t1051 * t126 - 0.1e5 / 0.729e3 * t738 * t312 * t2662 - 0.11e4 / 0.243e3 * t232 * t151 * t217 * t162 + 0.2e3 / 0.81e2 * t557 * t1024 + 0.2e3 / 0.81e2 * t770 * t1024 + 0.2e3 / 0.81e2 * t232 * t151 * t99 * t350;
  t2872 = t221 * t427;
  t2898 = t231 * t1103;
  t2905 = 0.25e2 / 0.27e2 * t2280 * t748 - 0.25e4 / 0.243e3 * t2872 * t740 + 0.625e3 / 0.729e3 * t1815 * t312 * t419 * t256 + 0.625e3 / 0.486e3 * t738 * t312 * t2665 - 0.25e2 / 0.54e2 * t2187 * t424 - 0.25e2 / 0.27e2 * t2157 * t424 - 0.25e2 / 0.27e2 * t557 * t1018 - 0.25e2 / 0.54e2 * t2194 * t424 - 0.25e2 / 0.27e2 * t770 * t1018 - 0.25e2 / 0.54e2 * t232 * t151 * t152 * t839 - 0.25e2 / 0.27e2 * t2238 * t318 - 0.25e2 / 0.27e2 * t2898 * t318 - 0.25e2 / 0.54e2 * t727 * t776 + 0.2e3 / 0.81e2 * t727 * t752;
  t2909 = t221 * t362 * t48;
  t2920 = t221 * t321;
  t2927 = t105 * t111 * t350;
  t2936 = t71 * t167;
  t2940 = t1757 * t226;
  t2952 = 0.4e5 / 0.2187e4 * t1002 * t744 - 0.5e4 / 0.729e3 * t2909 * t314 - 0.25e4 / 0.729e3 * t1002 * t765 - 0.625e3 / 0.729e3 * t1843 * t1006 - 0.625e3 / 0.1458e4 * t548 * t312 * t419 * t275 + 0.625e3 / 0.243e3 * t2920 * t1010 + 0.2e3 / 0.9e1 * t1861 * t435 * t757 - 0.4e3 / 0.27e2 * t755 * t2927 - 0.4e3 / 0.27e2 * t541 * t438 * t757 - 0.2e3 / 0.27e2 * t541 * t448 * t757 + 0.25e6 / 0.19683e5 * t787 * t2936 * t152 - 0.625e5 / 0.6561e4 * t2940 * t1043 + 0.1e7 / 0.59049e5 * t1042 * t788 * t1051 - 0.1e3 / 0.27e2 * t103 * t1040 * t112 - 0.625e5 / 0.19683e5 * t1042 * t2080 * t419;
  t2960 = my_piecewise3(t3, 0, t7 * t194 * t454 / 0.12e2 - t7 * t86 * t1123 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2610 + t2677 + t2719 + t2780 + t2823 + t2868 + t2905 + t2952));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2960 + 0.4e1 * t1128;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t2980 = t1861 * t1141;
  t2995 = t44 * t350;
  t3007 = t541 * t394 * t47;
  t3016 = 0.2e1 * t255 * t185 * t839 - 0.2e4 / 0.243e3 * t988 - 0.2e3 / 0.81e2 * t1142 * t752 + 0.1e3 / 0.9e1 * t2551 * t475 * t1136 * t256 - 0.25e2 / 0.18e2 * t2980 * t748 - 0.2e5 / 0.2187e4 * t1146 * t744 + 0.125e4 / 0.729e3 * t1146 * t765 + 0.25e4 / 0.729e3 * t547 * t394 * t48 * t314 - 0.1e5 / 0.243e3 * t2585 * t732 * t1136 * t47 - 0.2e3 / 0.27e2 * t991 * t475 * t2995 * t126 - 0.2e5 / 0.729e3 * t731 * t732 * t2995 * t110 - 0.2e5 / 0.729e3 * t2600 * t906 + 0.25e2 / 0.27e2 * t3007 * t318 - 0.2e3 / 0.27e2 * t2574 * t1150 - 0.2e5 / 0.729e3 * t1891 * t1138 - 0.2e3 / 0.27e2 * t2580 * t1150;
  t3018 = t541 * t403 * t47;
  t3026 = t541 * t185 * t110;
  t3033 = t461 * t126;
  t3068 = 0.25e2 / 0.27e2 * t3018 * t318 + 0.25e4 / 0.729e3 * t547 * t403 * t48 * t314 + 0.25e2 / 0.27e2 * t3026 * t318 + 0.125e4 / 0.243e3 * t547 * t185 * t226 * t2163 + 0.5e4 / 0.243e3 * t1916 * t1453 * t3033 * t110 + 0.2e3 / 0.9e1 * t1861 * t480 * t757 - 0.1e3 / 0.27e2 * t991 * t475 * t1136 * t275 - 0.1e5 / 0.729e3 * t731 * t732 * t1136 * t248 + 0.25e2 / 0.54e2 * t1142 * t776 + 0.1e4 / 0.81e2 * t995 + 0.1e6 / 0.2187e4 * t999 + 0.4e1 * t255 * t403 * t350 + 0.2e1 * t255 * t944 * t162 + 0.4e1 * t255 * t946 * t162 + 0.4e1 * t255 * t394 * t350 + 0.2e1 * t255 * t962 * t162;
  t3099 = -0.1e6 / 0.2187e4 * t1003 - 0.65e5 / 0.2187e4 * t1007 + 0.65e5 / 0.729e3 * t1011 - 0.5e3 / 0.81e2 * t1013 - 0.5e3 / 0.81e2 * t1015 - 0.5e3 / 0.81e2 * t1019 - 0.5e3 / 0.81e2 * t1021 + 0.2e4 / 0.243e3 * t1025 - 0.12e2 * t669 * t135 * t1229 - 0.12e2 * t1227 * t402 * t162 * t126 - 0.12e2 * t1227 * t184 * t350 * t126 - 0.6e1 * t1227 * t1228 * t275 - 0.65e7 / 0.59049e5 * t1044 - 0.325e3 / 0.81e2 * t1046 + 0.5e6 / 0.19683e5 * t1042 * t2080 * t462 + 0.25e6 / 0.19683e5 * t2616 * t1191;
  t3101 = t1814 * t1145;
  t3102 = t312 * t28;
  t3121 = t462 * t248;
  t3142 = t547 * t491;
  t3153 = t231 * t1208;
  t3156 = 0.26e4 / 0.243e3 * t1053 - 0.5e4 / 0.729e3 * t3101 * t3102 * t734 - t117 * t167 * t961 - t117 * t286 * t490 - 0.2e1 * t117 * t135 * t1205 - t117 * t78 * (-0.125e3 / 0.81e2 * t2652 * t462 + 0.325e4 / 0.243e3 * t1062 - 0.26e5 / 0.729e3 * t1064 - 0.625e6 / 0.6561e4 * t1961 * t462 * t226 + 0.1625e8 / 0.59049e5 * t1066 - 0.625e6 / 0.19683e5 * t829 * t3121 - 0.325e8 / 0.177147e6 * t1069) - t117 * t815 * t184 - 0.2e1 * t117 * t362 * t402 - 0.1e3 / 0.27e2 * t917 * t797 + 0.25e2 / 0.27e2 * t2835 * t1236 * t1638 - 0.25e4 / 0.243e3 * t2843 * t463 + 0.5e2 / 0.27e2 * t1243 * t250 - 0.1e5 / 0.729e3 * t3142 * t228 - 0.25e4 / 0.729e3 * t2191 * t463 + 0.1e7 / 0.19683e5 * t2200 * t2201 * t1136 - 0.125e6 / 0.19683e5 * t2200 * t185 * t152 + 0.1e3 / 0.27e2 * t3153 * t112;
  t3159 = t231 * t1210;
  t3162 = t231 * t1197;
  t3165 = t231 * t1206;
  t3184 = t547 * t483;
  t3187 = t1749 * t78;
  t3200 = 0.1e3 / 0.27e2 * t3159 * t112 + 0.1e3 / 0.27e2 * t3162 * t112 + 0.1e3 / 0.27e2 * t3165 * t112 - 0.5e6 / 0.19683e5 * t2766 * t1107 * t3033 - 0.5e2 / 0.27e2 * t2827 * t176 - 0.1e3 / 0.27e2 * t2773 * t176 - 0.5e2 / 0.27e2 * t2777 * t176 - 0.25e2 / 0.27e2 * t2784 * t1237 - 0.25e2 / 0.54e2 * t1108 * t1236 * t1778 + 0.5e2 / 0.27e2 * t1240 * t250 - 0.1e5 / 0.729e3 * t3184 * t228 + 0.24e2 * t3187 * t1228 * t256 + 0.25e2 / 0.54e2 * t568 * t472 + 0.5e6 / 0.6561e4 * t2940 * t1191 - 0.1e7 / 0.19683e5 * t787 * t2936 * t175 + 0.5e2 / 0.27e2 * t2101 * t938;
  t3244 = t541 * t483;
  t3247 = 0.5e2 / 0.27e2 * t606 * t490 * t226 * t151 + 0.2e5 / 0.729e3 * t2909 * t376 + 0.1e5 / 0.729e3 * t1002 * t924 - 0.25e2 / 0.108e3 * t2455 * t477 - 0.25e2 / 0.54e2 * t2458 * t477 - 0.25e2 / 0.108e3 * t2432 * t477 - 0.25e2 / 0.54e2 * t896 * t1153 - 0.25e2 / 0.54e2 * t893 * t1153 - 0.25e2 / 0.108e3 * t388 * t248 * t49 * t476 - 0.1e3 / 0.27e2 * t917 * t1156 * t151 * t248 + 0.2e5 / 0.729e3 * t2517 * t162 * t48 * t312 * t226 + 0.5e4 / 0.729e3 * t1843 * t1162 + 0.25e4 / 0.729e3 * t548 * t312 * t462 * t275 - 0.2e3 / 0.27e2 * t2484 * t1158 - 0.2e3 / 0.27e2 * t2487 * t1158 - 0.2e3 / 0.27e2 * t917 * t2927 - 0.2e3 / 0.27e2 * t3244 * t757;
  t3249 = t541 * t491;
  t3290 = -0.2e3 / 0.27e2 * t3249 * t757 - 0.55e3 / 0.243e3 * t388 * t105 * t475 * t216 + 0.1e3 / 0.81e2 * t893 * t1184 - 0.1e3 / 0.27e2 * t2280 * t910 + 0.1e5 / 0.243e3 * t2872 * t914 + 0.1e3 / 0.81e2 * t896 * t1184 + 0.1e3 / 0.81e2 * t388 * t573 * t1183 - 0.5e4 / 0.729e3 * t1815 * t312 * t462 * t256 - 0.5e4 / 0.243e3 * t2920 * t1166 - 0.25e4 / 0.243e3 * t738 * t312 * t3121 + 0.5e2 / 0.27e2 * t2187 * t467 + 0.1e3 / 0.27e2 * t2157 * t467 + 0.1e3 / 0.27e2 * t557 * t1174 + 0.5e2 / 0.27e2 * t2194 * t467 + 0.1e3 / 0.27e2 * t770 * t1174 + 0.5e2 / 0.27e2 * t232 * t151 * t175 * t839;
  t3326 = t732 * t44;
  t3330 = 0.1e3 / 0.27e2 * t2238 * t380 + 0.1e3 / 0.27e2 * t2898 * t380 + 0.5e2 / 0.27e2 * t727 * t932 - 0.6e1 * t669 * t483 * t256 - 0.6e1 * t669 * t491 * t256 + 0.4e1 * t255 * t1197 * t126 + 0.4e1 * t255 * t1206 * t126 + 0.2e1 * t255 * t491 * t275 + 0.4e1 * t255 * t1208 * t126 + 0.4e1 * t255 * t1210 * t126 + 0.2e1 * t255 * t483 * t275 - 0.52e6 / 0.6561e4 * t1095 + 0.65e5 / 0.2187e4 * t1097 + 0.5e3 / 0.81e2 * t1101 + 0.5e3 / 0.81e2 * t1105 + 0.325e3 / 0.81e2 * t1111 + 0.4e5 / 0.729e3 * t1910 * t3326 * t2636;
  t3338 = my_piecewise3(t3, 0, t7 * t194 * t493 / 0.12e2 - t7 * t86 * t1249 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3016 + t3068 + t3099 + t3156 + t3200 + t3247 + t3290 + t3330));
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t3338 + 0.4e1 * t1254;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t3355 = t44 * t402;
  t3376 = t500 * t126;
  t3392 = 0.26e7 / 0.6561e4 * t421 - 0.2e5 / 0.243e3 * t1916 * t732 * t1274 * t226 - 0.4e5 / 0.729e3 * t1891 * t1276 - 0.4e5 / 0.729e3 * t731 * t732 * t3355 * t110 - 0.2e5 / 0.729e3 * t731 * t732 * t1274 * t248 - 0.4e3 / 0.27e2 * t2574 * t1280 - 0.4e3 / 0.27e2 * t2580 * t1280 - 0.4e3 / 0.27e2 * t991 * t475 * t3355 * t126 - 0.2e3 / 0.27e2 * t991 * t475 * t1274 * t275 - 0.4e5 / 0.243e3 * t1916 * t1453 * t3376 * t110 + 0.2e3 / 0.9e1 * t2551 * t475 * t1274 * t256 + 0.2e4 / 0.81e2 * t1143 + 0.2e6 / 0.2187e4 * t1147 - 0.1e4 / 0.81e2 * t1154 + 0.4e6 / 0.2187e4 * t1163 - 0.4e6 / 0.729e3 * t1167 - 0.1e4 / 0.81e2 * t1181 + 0.4e4 / 0.243e3 * t1185;
  t3422 = t501 * t248;
  t3437 = t402 * t402;
  t3455 = -0.1e4 / 0.81e2 * t1187 - 0.2e7 / 0.19683e5 * t2616 * t1260 - 0.4e7 / 0.19683e5 * t1042 * t2080 * t501 - 0.1e3 / 0.27e2 * t568 * t509 - 0.1e3 / 0.27e2 * t1637 * t512 * t226 * t151 + 0.5e2 / 0.27e2 * t606 * t521 * t226 * t151 - 0.4e7 / 0.6561e4 * t2940 * t1260 + 0.4e8 / 0.59049e5 * t1192 + 0.2e4 / 0.81e2 * t1194 - 0.13e5 / 0.243e3 * t432 - t117 * t78 * (0.1e4 / 0.81e2 * t2652 * t501 - 0.2e5 / 0.243e3 * t1199 + 0.13e6 / 0.729e3 * t441 + 0.5e7 / 0.6561e4 * t1961 * t501 * t226 - 0.1e9 / 0.59049e5 * t1202 + 0.5e7 / 0.19683e5 * t829 * t3422 + 0.1625e9 / 0.177147e6 * t445) + 0.2e1 * t255 * t286 * t512 - t117 * t286 * t521 - 0.2e1 * t117 * t135 * t1326 + 0.4e1 * t255 * t78 * t3437 + 0.8e5 / 0.729e3 * t1910 * t3326 * t184 * t110 * t126 + 0.4e1 * t255 * t185 * t961 + 0.4e1 * t255 * t1318 * t126 + 0.4e1 * t255 * t1327 * t126;
  t3462 = t1814 * t513;
  t3465 = t231 * t1318;
  t3468 = t231 * t1327;
  t3473 = t547 * t522;
  t3494 = t541 * t1306;
  t3506 = 0.2e1 * t255 * t522 * t275 - 0.1e3 / 0.27e2 * t1300 * t250 + 0.2e5 / 0.729e3 * t3462 * t228 + 0.1e3 / 0.27e2 * t3465 * t112 + 0.1e3 / 0.27e2 * t3468 * t112 + 0.5e2 / 0.27e2 * t1312 * t250 - 0.1e5 / 0.729e3 * t3473 * t228 + 0.4e7 / 0.19683e5 * t2766 * t1107 * t3376 + 0.2e5 / 0.729e3 * t2191 * t502 + 0.2e7 / 0.19683e5 * t2200 * t2201 * t1274 + 0.2e3 / 0.27e2 * t2784 * t1294 + 0.2e5 / 0.243e3 * t2843 * t502 - 0.2e3 / 0.27e2 * t2835 * t1293 * t1638 + 0.1e3 / 0.27e2 * t1108 * t1293 * t1778 - 0.2e3 / 0.27e2 * t3494 * t112 + 0.24e2 * t1749 * t513 * t256 - 0.12e2 * t669 * t1306 * t126 - 0.6e1 * t669 * t513 * t275;
  t3517 = t1861 * t513;
  t3524 = t541 * t522;
  t3557 = 0.8e1 * t255 * t394 * t402 - 0.6e1 * t669 * t522 * t256 + 0.4e5 / 0.729e3 * t1815 * t312 * t501 * t256 + 0.2e3 / 0.9e1 * t3517 * t757 - 0.4e3 / 0.27e2 * t917 * t105 * t111 * t402 - 0.2e3 / 0.27e2 * t3524 * t757 + 0.2e5 / 0.243e3 * t738 * t312 * t3422 + 0.1e3 / 0.27e2 * t2187 * t506 + 0.2e3 / 0.27e2 * t2157 * t506 + 0.2e3 / 0.27e2 * t557 * t1289 + 0.1e3 / 0.27e2 * t2194 * t506 + 0.2e3 / 0.27e2 * t770 * t1289 + 0.1e3 / 0.27e2 * t232 * t151 * t175 * t961 - 0.4e5 / 0.729e3 * t1843 * t1264 - 0.2e5 / 0.729e3 * t548 * t312 * t501 * t275 + 0.4e5 / 0.243e3 * t2920 * t1270 - 0.24e2 * t1227 * t2346 * t402 - 0.2e4 / 0.81e2 * t1238 - 0.4e6 / 0.2187e4 * t1246;
  t3564 = my_piecewise3(t3, 0, t7 * t194 * t524 / 0.12e2 - t7 * t86 * t1330 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3392 + t3455 + t3506 + t3557));
  tv4rho2tau20 = 0.2e1 * rho[0] * t3564 + 0.4e1 * t1335;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t3574 = t33 * t434;
  t3579 = t33 * t447;
  t3588 = t415 * t162;
  t3602 = t541 * t427 * t49;
  t3637 = 0.25e2 / 0.9e1 * t991 * t475 * t992 * t350 - 0.25e4 / 0.243e3 * t1910 * t732 * t3574 * t110 + 0.25e2 / 0.18e2 * t991 * t475 * t3579 * t126 + 0.125e4 / 0.243e3 * t731 * t732 * t3579 * t110 + 0.625e3 / 0.243e3 * t1910 * t1453 * t3588 * t126 - 0.625e3 / 0.162e3 * t1916 * t1453 * t3588 * t110 - 0.25e2 / 0.6e1 * t2551 * t475 * t3574 * t126 + 0.25e2 / 0.9e1 * t3602 * t994 + 0.25e4 / 0.243e3 * t2600 * t998 + 0.6e1 * t255 * t362 * t434 - 0.3e1 * t117 * t1040 * t162 + 0.12e2 * t255 * t438 * t350 + 0.6e1 * t255 * t1345 * t126 + 0.6e1 * t255 * t1348 * t126 + 0.2e1 * t255 * t1356 * t126 + 0.6e1 * t255 * t338 * t447 + 0.6e1 * t255 * t351 * t447 + 0.6e1 * t255 * t163 * t1071 - 0.18e2 * t669 * t1342 * t126;
  t3657 = 0.25e3 / 0.1594323e7 * t619 * t1029;
  t3680 = t788 * t110;
  t3683 = t627 * t1338;
  t3691 = t231 * t167 * t27;
  t3700 = t541 * t1342;
  t3703 = t231 * t1345;
  t3706 = -0.625e5 / 0.19683e5 * t627 * t1028 * t71 * t78 + 0.15625e5 / 0.39366e5 * t627 * t1362 * t135 + 0.24e2 * t1749 * t1367 * t126 - 0.18e2 * t669 * t435 * t350 - t117 * t1360 * t126 - 0.6e1 * t669 * t135 * t1366 - t3657 - 0.3e1 * t117 * t452 * t350 - 0.3e1 * t117 * t362 * t447 - 0.3e1 * t117 * t167 * t1071 - t117 * t135 * t1355 - t117 * t78 * (0.125e3 / 0.324e3 * t1029 - 0.78125e5 / 0.26244e5 * t1711 * t1352 * t110 + 0.15625e6 / 0.19683e5 * t641 * t67 * t1028) + 0.15625e5 / 0.6561e4 * t1757 * t1338 * t3680 - 0.15625e5 / 0.39366e5 * t3683 * t1659 - 0.18e2 * t1227 * t162 * t447 * t126 + 0.25e2 / 0.144e3 * t3691 * t1110 + 0.625e3 / 0.1944e4 * t1805 * t312 * t1338 * t126 - 0.5e2 / 0.27e2 * t1390 * t329 - 0.1e3 / 0.9e1 * t3700 * t112 + 0.5e2 / 0.9e1 * t3703 * t112;
  t3708 = t231 * t1348;
  t3711 = t231 * t1356;
  t3714 = t1861 * t1367;
  t3724 = t52 * t350;
  t3729 = t103 * t1040 * t47;
  t3733 = t103 * t452 * t110;
  t3738 = t60 / t31 / t622;
  t3740 = t26 * t29;
  t3742 = 0.125e4 / 0.1162261467e10 * t1686 * t3738 * t3740;
  t3764 = t1385 * t126;
  t3768 = t231 * t1389;
  t3772 = t221 * t452 * t48;
  t3775 = 0.5e2 / 0.9e1 * t3708 * t112 + 0.5e2 / 0.27e2 * t3711 * t112 + 0.1e3 / 0.9e1 * t3714 * t112 + 0.3125e5 / 0.6561e4 * t2766 * t1107 * t3588 + 0.625e3 / 0.486e3 * t2909 * t420 + 0.25e2 / 0.144e3 * t2784 * t1386 + 0.25e2 / 0.144e3 * t1108 * t1109 * t3724 + 0.25e2 / 0.36e2 * t3729 * t153 + 0.25e2 / 0.36e2 * t3733 * t153 + t3742 - 0.5e4 / 0.729e3 * t1002 * t1094 - 0.25e2 / 0.27e2 * t1108 * t2839 * t1385 + 0.625e3 / 0.162e3 * t2872 * t1010 - 0.1e3 / 0.27e2 * t542 * t151 * t99 * t434 + 0.5e2 / 0.27e2 * t232 * t151 * t99 * t447 + 0.5e4 / 0.729e3 * t548 * t312 * t1051 * t162 + 0.1e3 / 0.27e2 * t727 * t1024 - 0.25e2 / 0.72e2 * t2835 * t1109 * t3764 - 0.25e2 / 0.36e2 * t3768 * t318 - 0.125e4 / 0.243e3 * t3772 * t314;
  t3781 = t447 * t47 * t1157;
  t3813 = t110 * t21;
  t3833 = 0.25e2 / 0.18e2 * t2142 * t1394 + 0.25e2 / 0.18e2 * t2145 * t1394 - 0.1e3 / 0.9e1 * t755 * t3781 - 0.25e2 / 0.18e2 * t2238 * t424 - 0.25e2 / 0.18e2 * t2898 * t424 - 0.25e2 / 0.18e2 * t727 * t1018 - 0.25e2 / 0.36e2 * t557 * t1376 - 0.25e2 / 0.36e2 * t770 * t1376 - 0.25e2 / 0.36e2 * t232 * t151 * t152 * t1071 - 0.625e3 / 0.486e3 * t1843 * t1380 - 0.625e3 / 0.486e3 * t548 * t312 * t419 * t350 - 0.625e3 / 0.486e3 * t2246 * t1006 - 0.3125e5 / 0.6561e4 * t1042 * t2936 * t419 - 0.25e2 / 0.144e3 * t779 * t431 - 0.625e3 / 0.1944e4 * t611 * t1400 - 0.625e3 / 0.1944e4 * t222 * t3813 * t1399 - 0.5e2 / 0.27e2 * t103 * t1360 * t112 + 0.25e2 / 0.27e2 * t353 * t1052 + 0.625e3 / 0.243e3 * t222 * t600 * t225 * t1028 + t72 * (0.125e4 / 0.1162261467e10 * t1664 * t3738 * t3740 - 0.25e3 / 0.1594323e7 * t656 * t1029 - t3742 + t3657);
  t3840 = my_piecewise3(t3, 0, -t7 * t86 * t1403 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3637 + t3706 + t3775 + t3833));
  tv4rhosigma30 = 0.2e1 * rho[0] * t3840 + 0.2e1 * t1407;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t3856 = t44 * t447;
  t3865 = t44 * t434;
  t3890 = -0.2e3 / 0.81e2 * t1142 * t1024 + 0.5e4 / 0.243e3 * t547 * t1107 * t461 * t312 * t1156 * t110 - 0.2e5 / 0.729e3 * t2600 * t1138 - 0.1e3 / 0.27e2 * t991 * t475 * t3856 * t126 - 0.1e5 / 0.729e3 * t731 * t732 * t3856 * t110 + 0.1e3 / 0.9e1 * t2551 * t475 * t3865 * t126 - 0.2e3 / 0.27e2 * t991 * t475 * t1136 * t350 + 0.2e5 / 0.729e3 * t1910 * t732 * t3865 * t110 + 0.25e2 / 0.27e2 * t3007 * t424 + 0.25e2 / 0.27e2 * t3018 * t424 + 0.25e2 / 0.27e2 * t3026 * t424 + 0.25e2 / 0.27e2 * t1142 * t1018 + 0.25e4 / 0.729e3 * t547 * t491 * t48 * t314;
  t3893 = t461 * t162;
  t3917 = 0.625e3 / 0.729e3 * t3101 * t1006 - 0.1e5 / 0.729e3 * t1910 * t1453 * t3893 * t126 - 0.2e3 / 0.27e2 * t3602 * t1150 - 0.5e3 / 0.81e2 * t1373 - 0.25e3 / 0.81e2 * t1377 - 0.65e5 / 0.2187e4 * t1381 + 0.5e3 / 0.81e2 * t1395 - 0.325e3 / 0.81e2 * t1397 - 0.4375e4 / 0.243e3 * t1401 + 0.5e6 / 0.19683e5 * t1042 * t2936 * t462 + 0.625e3 / 0.243e3 * t611 * t1475 + 0.625e3 / 0.243e3 * t222 * t3813 * t1474 + 0.25e2 / 0.27e2 * t779 * t472 + 0.4375e6 / 0.19683e5 * t1364;
  t3961 = 0.2e1 * t255 * t185 * t1071 - 0.6e1 * t669 * t394 * t434 - 0.6e1 * t669 * t403 * t434 + 0.2e1 * t255 * t1435 * t126 + 0.4e1 * t255 * t1437 * t126 + 0.2e1 * t255 * t1447 * t126 + 0.4e1 * t255 * t483 * t350 + 0.4e1 * t255 * t1197 * t162 + 0.4e1 * t255 * t1206 * t162 + 0.4e1 * t255 * t491 * t350 + 0.2e1 * t255 * t394 * t447 + 0.2e1 * t255 * t403 * t447 - 0.625e5 / 0.19683e5 * t627 * t1410 * t135 + 0.4e1 * t255 * t1208 * t162;
  t3969 = t231 * t1435;
  t3972 = t231 * t1437;
  t3975 = t231 * t1447;
  t3999 = 0.4e1 * t255 * t1210 * t162 + 0.25e2 / 0.432e3 * t893 * t431 + 0.25e2 / 0.432e3 * t896 * t431 + 0.5e2 / 0.27e2 * t3969 * t112 + 0.1e3 / 0.27e2 * t3972 * t112 + 0.5e2 / 0.27e2 * t3975 * t112 + 0.3125e5 / 0.19683e5 * t2766 * t185 * t419 - 0.5e6 / 0.19683e5 * t2766 * t1107 * t3893 - 0.625e3 / 0.243e3 * t1805 * t312 * t1409 * t126 - 0.25e2 / 0.27e2 * t3691 * t1237 - 0.25e2 / 0.81e2 * t388 * t1052 - 0.5e4 / 0.729e3 * t2909 * t463 - 0.25e2 / 0.27e2 * t2784 * t1428 - 0.25e2 / 0.27e2 * t1108 * t1236 * t3724;
  t4033 = -0.5e2 / 0.27e2 * t3729 * t176 - 0.5e2 / 0.27e2 * t3733 * t176 - 0.25e2 / 0.9e1 * t2980 * t151 * t28 * t993 - 0.5e4 / 0.729e3 * t3101 * t3102 * t997 - 0.2e3 / 0.27e2 * t3249 * t1158 - 0.1e3 / 0.27e2 * t917 * t3781 + 0.1e3 / 0.9e1 * t2494 * t434 * t47 * t1157 + 0.5e4 / 0.729e3 * t2246 * t1162 - 0.5e4 / 0.243e3 * t2872 * t1166 + 0.1e3 / 0.81e2 * t1240 * t1184 + 0.1e3 / 0.27e2 * t727 * t1174 + 0.5e2 / 0.27e2 * t557 * t1465 + 0.5e2 / 0.27e2 * t770 * t1465;
  t4069 = 0.5e2 / 0.27e2 * t232 * t151 * t175 * t1071 + 0.5e2 / 0.27e2 * t2835 * t1236 * t3764 + 0.5e2 / 0.27e2 * t3768 * t380 + 0.1e5 / 0.729e3 * t3772 * t376 - 0.25e2 / 0.216e3 * t917 * t419 * t151 * t126 - 0.2e3 / 0.27e2 * t3244 * t1158 + 0.1e3 / 0.81e2 * t1243 * t1184 + 0.5e4 / 0.2187e4 * t884 * t223 * t1453 * t302 - 0.1e3 / 0.27e2 * t2142 * t1469 - 0.1e3 / 0.27e2 * t2145 * t1469 - 0.25e2 / 0.54e2 * t3153 * t477 - 0.25e2 / 0.54e2 * t3159 * t477 - 0.25e2 / 0.54e2 * t1240 * t1153 - 0.25e2 / 0.54e2 * t3162 * t477;
  t4109 = -0.25e2 / 0.54e2 * t3165 * t477 - 0.25e2 / 0.54e2 * t1243 * t1153 - 0.625e3 / 0.1458e4 * t2429 * t1455 - 0.625e3 / 0.1458e4 * t2437 * t1455 + 0.5e4 / 0.729e3 * t1843 * t1459 + 0.5e4 / 0.729e3 * t548 * t312 * t462 * t350 + 0.1e3 / 0.27e2 * t2238 * t467 + 0.1e3 / 0.27e2 * t2898 * t467 - 0.2e1 * t117 * t167 * t1205 - t117 * t135 * t1446 - t117 * t78 * (-0.875e3 / 0.324e3 * t1339 + 0.15625e6 / 0.6561e4 * t1711 * t1443 * t110 - 0.109375e7 / 0.19683e5 * t1353) - t117 * t1040 * t184 - t117 * t452 * t402 - 0.2e1 * t117 * t362 * t490;
  t4110 = t184 * t447;
  t4124 = t627 * t1409;
  t4157 = -0.6e1 * t1227 * t4110 * t126 + 0.24e2 * t3187 * t184 * t434 * t126 - 0.12e2 * t1227 * t1228 * t350 - 0.125e6 / 0.6561e4 * t1757 * t1409 * t3680 + 0.625e5 / 0.19683e5 * t4124 * t1659 - 0.12e2 * t669 * t167 * t1229 - 0.12e2 * t1227 * t490 * t162 * t126 - 0.625e3 / 0.486e3 * t547 * t185 * t27 * t415 * t21 * t225 * t47 * t110 + 0.25e2 / 0.27e2 * t541 * t483 * t47 * t318 + 0.25e4 / 0.729e3 * t547 * t483 * t48 * t314 + 0.25e2 / 0.27e2 * t541 * t491 * t47 * t318 + 0.65e5 / 0.2187e4 * t1383 + 0.325e3 / 0.81e2 * t1387 + 0.25e3 / 0.81e2 * t1391;
  t4165 = my_piecewise3(t3, 0, -t7 * t86 * t1481 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3890 + t3917 + t3961 + t3999 + t4033 + t4069 + t4109 + t4157));
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t4165 + 0.2e1 * t1485;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t4194 = 0.1e4 / 0.81e2 * t1472 - 0.5e3 / 0.81e2 * t1449 - 0.5e3 / 0.81e2 * t1451 - 0.65e5 / 0.2187e4 * t1456 + 0.2e6 / 0.2187e4 * t1460 + 0.4e1 * t255 * t394 * t490 + 0.4e1 * t255 * t403 * t490 + 0.4e1 * t255 * t185 * t1205 + 0.2e1 * t255 * t1318 * t162 + 0.2e1 * t255 * t1327 * t162 + 0.2e1 * t255 * t522 * t350;
  t4223 = 0.5e6 / 0.19683e5 * t627 * t1488 * t135 - 0.6e1 * t669 * t1306 * t162 - 0.6e1 * t669 * t513 * t350 - 0.6e1 * t669 * t1530 * t126 + 0.4e1 * t255 * t483 * t402 + 0.1e5 / 0.81e2 * t1476 + 0.1e4 / 0.81e2 * t1478 - 0.1e3 / 0.27e2 * t779 * t509 - 0.2e7 / 0.19683e5 * t1042 * t2936 * t501 - 0.5e4 / 0.243e3 * t611 * t1499 - 0.5e4 / 0.243e3 * t222 * t3813 * t1498 - 0.1e7 / 0.6561e4 * t1412;
  t4225 = t500 * t162;
  t4235 = t461 * t184;
  t4241 = t52 * t402;
  t4252 = t541 * t1530;
  t4255 = t231 * t1541;
  t4258 = t231 * t1549;
  t4261 = 0.2e7 / 0.19683e5 * t2766 * t1107 * t4225 + 0.2e5 / 0.729e3 * t2909 * t502 + 0.5e4 / 0.243e3 * t1805 * t312 * t1487 * t126 - 0.5e6 / 0.19683e5 * t2766 * t1107 * t4235 - 0.25e2 / 0.27e2 * t2784 * t1513 - 0.25e2 / 0.27e2 * t1108 * t1236 * t4241 + 0.1e3 / 0.27e2 * t2784 * t1520 + 0.1e3 / 0.27e2 * t1108 * t1293 * t3724 + 0.1e3 / 0.27e2 * t3691 * t1294 - 0.1e3 / 0.27e2 * t4252 * t112 + 0.5e2 / 0.27e2 * t4255 * t112 + 0.5e2 / 0.27e2 * t4258 * t112;
  t4299 = -t117 * t362 * t521 - t117 * t167 * t1326 - t117 * t135 * t1548 - t117 * t78 * (0.5e3 / 0.27e2 * t1441 - 0.125e7 / 0.6561e4 * t1711 * t1545 * t110 + 0.25e7 / 0.6561e4 * t1444) + 0.2e1 * t255 * t362 * t512 + 0.4e5 / 0.729e3 * t1910 * t3326 * t1228 * t110 + 0.2e3 / 0.9e1 * t2551 * t475 * t44 * t1229 + 0.5e2 / 0.81e2 * t1312 * t1184 + 0.25e2 / 0.54e2 * t3494 * t477 + 0.25e2 / 0.54e2 * t1300 * t1153 + 0.1e3 / 0.9e1 * t3517 * t1158 - 0.2e3 / 0.27e2 * t917 * t490 * t47 * t1157;
  t4320 = t1512 * t126;
  t4328 = -0.25e2 / 0.108e3 * t3465 * t477 - 0.25e2 / 0.108e3 * t3468 * t477 - 0.25e2 / 0.108e3 * t1312 * t1153 - 0.1e3 / 0.27e2 * t3524 * t1158 + 0.5e4 / 0.729e3 * t548 * t312 * t462 * t402 + 0.1e3 / 0.27e2 * t2238 * t506 + 0.1e3 / 0.27e2 * t2898 * t506 + 0.1e3 / 0.27e2 * t727 * t1289 + 0.5e2 / 0.27e2 * t2835 * t1236 * t4320 + 0.1e3 / 0.27e2 * t557 * t1517 + 0.1e3 / 0.27e2 * t770 * t1517;
  t4364 = 0.1e3 / 0.27e2 * t232 * t151 * t175 * t1205 - 0.2e3 / 0.27e2 * t2835 * t1293 * t3764 - 0.2e5 / 0.729e3 * t1843 * t1493 - 0.2e5 / 0.729e3 * t548 * t312 * t501 * t350 - 0.2e5 / 0.729e3 * t2246 * t1264 + 0.2e5 / 0.243e3 * t2872 * t1270 + 0.5e4 / 0.729e3 * t1843 * t1503 - 0.1e3 / 0.81e2 * t1300 * t1184 - 0.12e2 * t1227 * t1228 * t402 - 0.12e2 * t1227 * t184 * t490 * t126 - 0.6e1 * t1227 * t521 * t162 * t126 + 0.1e7 / 0.6561e4 * t1757 * t1487 * t3680;
  t4366 = t627 * t1487;
  t4373 = t44 * t490;
  t4379 = t1861 * t513 * t47;
  t4391 = t541 * t522 * t47;
  t4410 = -0.5e6 / 0.19683e5 * t4366 * t1659 + 0.24e2 * t3187 * t512 * t162 * t126 - 0.2e5 / 0.729e3 * t731 * t732 * t4373 * t110 - 0.25e2 / 0.18e2 * t4379 * t318 + 0.25e2 / 0.27e2 * t1142 * t151 * t152 * t402 - 0.25e4 / 0.729e3 * t1814 * t513 * t48 * t314 + 0.25e2 / 0.54e2 * t4391 * t318 + 0.125e4 / 0.729e3 * t547 * t522 * t48 * t314 - 0.2e3 / 0.27e2 * t2574 * t1507 - 0.2e3 / 0.27e2 * t2580 * t1507 - 0.2e3 / 0.27e2 * t991 * t475 * t3355 * t162 - 0.2e3 / 0.27e2 * t991 * t475 * t1274 * t350;
  t4444 = -0.2e3 / 0.27e2 * t3602 * t1280 - 0.2e5 / 0.729e3 * t2600 * t1276 - 0.2e3 / 0.27e2 * t991 * t475 * t4373 * t126 + 0.4e5 / 0.729e3 * t1910 * t1453 * t4225 * t126 - 0.2e5 / 0.243e3 * t1916 * t1453 * t4225 * t110 - 0.1e5 / 0.729e3 * t1910 * t1453 * t4235 * t126 + 0.5e4 / 0.243e3 * t1916 * t1453 * t4235 * t110 + 0.2e1 * t255 * t1549 * t126 + 0.2e1 * t255 * t1541 * t126 - 0.2e6 / 0.2187e4 * t1426 - 0.1e4 / 0.81e2 * t1429 + 0.325e3 / 0.81e2 * t1433;
  t4452 = my_piecewise3(t3, 0, -t7 * t86 * t1551 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4194 + t4223 + t4261 + t4299 + t4328 + t4364 + t4410 + t4444));
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t4452 + 0.2e1 * t1555;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t4482 = t500 * t184;
  t4495 = t1861 * t1582;
  t4498 = t231 * t1594;
  t4504 = t627 * t1557;
  t4507 = t184 * t521;
  t4517 = 0.2e7 / 0.6561e4 * t2766 * t1107 * t4482 - 0.4e5 / 0.243e3 * t1805 * t312 * t1557 * t126 + 0.1e3 / 0.9e1 * t2784 * t1574 + 0.1e3 / 0.9e1 * t1108 * t1293 * t4241 + 0.1e3 / 0.9e1 * t4495 * t112 + 0.5e2 / 0.27e2 * t4498 * t112 - 0.8e7 / 0.6561e4 * t1757 * t1557 * t3680 + 0.4e7 / 0.19683e5 * t4504 * t1659 - 0.18e2 * t1227 * t4507 * t126 - 0.2e5 / 0.243e3 * t1843 * t1563 - 0.2e5 / 0.243e3 * t548 * t312 * t501 * t402;
  t4550 = -0.1e3 / 0.9e1 * t2142 * t1571 - 0.1e3 / 0.9e1 * t2145 * t1571 - 0.2e3 / 0.9e1 * t2835 * t1293 * t4320 + 0.5e2 / 0.9e1 * t557 * t1578 + 0.5e2 / 0.9e1 * t770 * t1578 + 0.5e2 / 0.9e1 * t232 * t151 * t175 * t1326 - 0.1e3 / 0.9e1 * t917 * t521 * t47 * t1157 + 0.6e1 * t255 * t403 * t521 + 0.6e1 * t255 * t185 * t1326 + 0.2e1 * t255 * t1594 * t126 - 0.4e7 / 0.19683e5 * t627 * t1558 * t135;
  t4560 = t44 * t521;
  t4577 = t44 * t512;
  t4591 = 0.24e2 * t1749 * t1582 * t126 - 0.18e2 * t669 * t513 * t402 + 0.6e1 * t255 * t394 * t521 - 0.1e3 / 0.9e1 * t991 * t475 * t4560 * t126 - 0.1e5 / 0.243e3 * t731 * t732 * t4560 * t110 + 0.4e5 / 0.243e3 * t1910 * t1453 * t4482 * t126 - 0.2e5 / 0.81e2 * t1916 * t1453 * t4482 * t110 + 0.1e3 / 0.3e1 * t2551 * t475 * t4577 * t126 - 0.2e3 / 0.9e1 * t991 * t475 * t1274 * t402 + 0.2e5 / 0.243e3 * t1910 * t732 * t4577 * t110 - 0.1e4 / 0.27e2 * t1514;
  t4598 = my_piecewise3(t3, 0, -t7 * t86 * t1596 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (-0.6e1 * t669 * t135 * t1581 - t117 * t135 * t1593 - t117 * t78 * (-0.1e5 / 0.81e2 * t1543 + 0.1e8 / 0.6561e4 * t1711 * t1590 * t110 - 0.5e8 / 0.19683e5 * t1546) + 0.2e6 / 0.729e3 * t1504 + 0.5e3 / 0.27e2 * t1525 - 0.25e3 / 0.27e2 * t1536 - 0.2e6 / 0.243e3 * t1500 + 0.4e5 / 0.243e3 * t611 * t1567 + 0.4e5 / 0.243e3 * t222 * t3813 * t1566 + 0.2e8 / 0.19683e5 * t1490 + t4517 + t4550 + t4591));
  tv4rhotau30 = 0.2e1 * rho[0] * t4598 + 0.2e1 * t1600;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t4602 = 0.1e1 / t31 / t800;
  t4603 = t28 * t4602;
  t4613 = t4602 * t21 * t145;
  t4614 = t1686 * t60 * t4613;
  t4616 = t434 * t434;
  t4620 = t447 * t447;
  t4639 = t52 * t434;
  t4646 = t117 * t78 * params->b;
  t4651 = t103 * t1360 * t47;
  t4656 = t52 * t447;
  t4660 = 0.625e3 / 0.15552e5 * t222 * t4603 * t312 - 0.625e3 / 0.486e3 * t784 * t1400 - 0.25e2 / 0.72e2 * t1048 * t431 - 0.625e3 / 0.1549681956e10 * t4614 + 0.24e2 * t1749 * t78 * t4616 + 0.6e1 * t255 * t78 * t4620 - 0.24e2 * t669 * t167 * t1366 - 0.4e1 * t117 * t167 * t1355 + 0.12e2 * t255 * t452 * t434 - 0.4e1 * t117 * t1360 * t162 - 0.6e1 * t117 * t452 * t447 - 0.25e2 / 0.36e2 * t2835 * t1109 * t4639 + 0.625e3 / 0.243e3 * t3772 * t420 - 0.78125e5 / 0.209952e6 * t4646 * t1757 * t4603 + 0.25e2 / 0.27e2 * t4651 * t153 + 0.25e2 / 0.36e2 * t3691 * t1386 + 0.25e2 / 0.72e2 * t1108 * t1109 * t4656;
  t4668 = t788 * t28;
  t4711 = 0.625e3 / 0.486e3 * t1805 * t312 * t1338 * t162 - 0.3125e5 / 0.19683e5 * t3683 * t2132 - 0.15625e5 / 0.52488e5 * t1757 * t4602 * t4668 - 0.36e2 * t669 * t435 * t447 + 0.24e2 * t255 * t438 * t447 + 0.8e1 * t255 * t1356 * t162 + 0.3125e5 / 0.19683e5 * t627 * t1362 * t167 + 0.5e2 / 0.9e1 * t3700 * t477 - 0.25e2 / 0.9e1 * t3703 * t477 - 0.25e2 / 0.9e1 * t3708 * t477 - 0.25e2 / 0.27e2 * t3711 * t477 - 0.5e2 / 0.9e1 * t3714 * t477 - 0.125e4 / 0.243e3 * t2246 * t1380 - 0.625e3 / 0.243e3 * t548 * t312 * t419 * t447 + 0.125e4 / 0.243e3 * t1815 * t312 * t419 * t434 + 0.5e2 / 0.9e1 * t541 * t1370 * t477 + t72 * (-0.625e3 / 0.1549681956e10 * t1664 * t60 * t4613 + 0.625e3 / 0.1549681956e10 * t4614);
  t4716 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t4660 + t4711));
  tv4sigma40 = 0.2e1 * rho[0] * t4716;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t4734 = 0.1e1 / t31 / t1027;
  t4738 = t4734 * t28;
  t4754 = -0.18e2 * t1227 * t4110 * t162 - 0.15625e5 / 0.39366e5 * t3683 * t2350 - t117 * t1360 * t184 - 0.3e1 * t117 * t452 * t490 - 0.3e1 * t117 * t167 * t1446 + 0.625e5 / 0.6561e4 * t4124 * t2132 + 0.15625e5 / 0.6561e4 * t1757 * t4734 * t4668 + 0.78125e5 / 0.26244e5 * t4646 * t1757 * t4738 - 0.25e4 / 0.243e3 * t3772 * t463 - 0.25e2 / 0.9e1 * t3691 * t1428 - 0.25e2 / 0.18e2 * t1108 * t1236 * t4656 - 0.625e3 / 0.81e2 * t547 * t78 * t1409 * t312 * t1156;
  t4790 = -0.5e2 / 0.27e2 * t4651 * t176 + 0.25e2 / 0.144e3 * t1240 * t431 + 0.25e2 / 0.144e3 * t1243 * t431 + 0.625e3 / 0.1944e4 * t884 * t1400 + 0.25e2 / 0.9e1 * t2835 * t1236 * t4639 + 0.12e2 * t255 * t1437 * t162 + 0.6e1 * t255 * t483 * t447 + 0.6e1 * t255 * t1447 * t162 + 0.6e1 * t255 * t491 * t447 + 0.2e1 * t255 * t185 * t1355 + 0.24e2 * t1749 * t185 * t1366 - 0.625e5 / 0.6561e4 * t627 * t1410 * t167 + 0.6e1 * t255 * t1435 * t162;
  t4824 = -0.18e2 * t669 * t483 * t434 - 0.18e2 * t669 * t491 * t434 + 0.25e4 / 0.243e3 * t548 * t312 * t462 * t447 + 0.5e2 / 0.9e1 * t727 * t1465 + 0.5e2 / 0.27e2 * t232 * t151 * t175 * t1355 + 0.5e2 / 0.9e1 * t3768 * t467 - 0.25e2 / 0.72e2 * t917 * t419 * t151 * t162 - 0.25e2 / 0.36e2 * t3969 * t477 - 0.25e2 / 0.18e2 * t3972 * t477 - 0.25e2 / 0.36e2 * t3975 * t477 - 0.625e3 / 0.486e3 * t3184 * t1455 + 0.5e4 / 0.243e3 * t2246 * t1459;
  t4862 = 0.1e3 / 0.9e1 * t2123 * t151 * t175 * t1366 - 0.5e4 / 0.243e3 * t1815 * t312 * t462 * t434 - 0.1e3 / 0.9e1 * t2280 * t1469 - 0.625e3 / 0.486e3 * t3142 * t1455 + 0.25e2 / 0.9e1 * t541 * t1414 * t477 + 0.25e2 / 0.9e1 * t541 * t1417 * t477 + 0.25e2 / 0.18e2 * t541 * t1420 * t477 - 0.25e2 / 0.6e1 * t1861 * t1423 * t477 - 0.1e3 / 0.9e1 * t991 * t475 * t3856 * t162 + 0.625e3 / 0.243e3 * t3101 * t1380 + 0.625e3 / 0.81e2 * t784 * t1475 + 0.25e2 / 0.18e2 * t1048 * t472 - 0.625e3 / 0.1944e4 * t222 * t4738 * t312;
  t4868 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t4754 + t4790 + t4824 + t4862));
  tv4sigma3tau0 = 0.2e1 * rho[0] * t4868;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t4878 = 0.1e1 / t31 / t588;
  t4882 = t490 * t490;
  t4909 = 0.125e6 / 0.19683e5 * t4124 * t2350 - 0.24e2 * t1227 * t1228 * t490 - 0.1e7 / 0.19683e5 * t4366 * t2132 - 0.125e6 / 0.6561e4 * t1757 * t4878 * t4668 + 0.4e1 * t255 * t78 * t4882 + 0.2e1 * t255 * t452 * t512 - t117 * t452 * t521 - 0.2e1 * t117 * t167 * t1548 + 0.4e1 * t255 * t185 * t1446 + 0.4e1 * t255 * t1541 * t162 + 0.4e1 * t255 * t1549 * t162 + 0.2e1 * t255 * t522 * t447 + 0.1e7 / 0.19683e5 * t627 * t1488 * t167;
  t4933 = t52 * t490;
  t4946 = t4878 * t28;
  t4950 = -0.12e2 * t669 * t1530 * t162 - 0.6e1 * t669 * t513 * t447 + 0.8e1 * t255 * t483 * t490 + 0.24e2 * t1749 * t513 * t434 - 0.6e1 * t669 * t522 * t434 + 0.2e5 / 0.729e3 * t3772 * t502 - 0.125e4 / 0.243e3 * t1805 * t312 * t1409 * t184 - 0.5e2 / 0.27e2 * t3691 * t1513 - 0.5e2 / 0.27e2 * t1108 * t1236 * t4933 + 0.2e3 / 0.27e2 * t3691 * t1520 + 0.1e3 / 0.27e2 * t1108 * t1293 * t4656 - 0.25e2 / 0.216e3 * t1300 * t431 + 0.25e2 / 0.432e3 * t1312 * t431 - 0.15625e6 / 0.6561e4 * t4646 * t1757 * t4946;
  t4969 = t1512 * t162;
  t4991 = -0.2e3 / 0.27e2 * t2835 * t1293 * t4639 + 0.1e5 / 0.243e3 * t1805 * t312 * t1487 * t162 - 0.25e2 / 0.54e2 * t4258 * t477 - 0.625e3 / 0.1458e4 * t3473 * t1455 + 0.1e5 / 0.729e3 * t2246 * t1503 + 0.1e5 / 0.729e3 * t548 * t312 * t462 * t490 + 0.1e3 / 0.27e2 * t2835 * t1236 * t4969 + 0.1e3 / 0.27e2 * t3768 * t506 + 0.2e3 / 0.27e2 * t727 * t1517 - 0.4e5 / 0.729e3 * t2246 * t1493 - 0.2e5 / 0.729e3 * t548 * t312 * t501 * t447 + 0.4e5 / 0.729e3 * t1815 * t312 * t501 * t434 + 0.1e3 / 0.27e2 * t232 * t151 * t175 * t1446;
  t5031 = 0.25e2 / 0.27e2 * t4252 * t477 + 0.625e3 / 0.729e3 * t3462 * t1455 - 0.25e2 / 0.54e2 * t4255 * t477 + 0.2e3 / 0.9e1 * t2551 * t475 * t1274 * t434 + 0.5e2 / 0.27e2 * t1142 * t151 * t152 * t490 + 0.25e2 / 0.27e2 * t4391 * t424 - 0.2e3 / 0.27e2 * t991 * t475 * t1274 * t447 - 0.25e2 / 0.9e1 * t4379 * t424 - 0.2e5 / 0.729e3 * t1910 * t1453 * t4235 * t162 - 0.4e3 / 0.27e2 * t3602 * t1507 - 0.4e3 / 0.27e2 * t991 * t475 * t4373 * t162 - 0.1e5 / 0.243e3 * t784 * t1499 + 0.625e3 / 0.243e3 * t222 * t4946 * t312 - 0.1e3 / 0.27e2 * t1048 * t509;
  t5037 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t4909 + t4950 + t4991 + t5031));
  tv4sigma2tau20 = 0.2e1 * rho[0] * t5037;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t5060 = t52 * t512;
  t5069 = t52 * t521;
  t5074 = 0.1e1 / t31 / t208;
  t5075 = t5074 * t28;
  t5099 = 0.6e1 * t255 * t185 * t1548 + 0.2e1 * t255 * t1594 * t162 - 0.4e7 / 0.19683e5 * t627 * t1558 * t167 + 0.24e2 * t1749 * t1582 * t162 - 0.18e2 * t669 * t513 * t490 + 0.6e1 * t255 * t483 * t521 + 0.6e1 * t255 * t491 * t521 + 0.25e2 / 0.9e1 * t2835 * t1236 * t5060 + 0.1e3 / 0.9e1 * t3691 * t1574 + 0.1e3 / 0.9e1 * t1108 * t1293 * t4933 - 0.25e2 / 0.18e2 * t1108 * t1236 * t5069 + 0.125e7 / 0.6561e4 * t4646 * t1757 * t5075 + 0.5e4 / 0.81e2 * t1805 * t312 * t1487 * t184 - 0.4e5 / 0.243e3 * t1805 * t312 * t1557 * t162 + 0.5e2 / 0.9e1 * t232 * t151 * t175 * t1548 + 0.25e4 / 0.243e3 * t548 * t312 * t462 * t521 - 0.25e2 / 0.18e2 * t4495 * t477 - 0.25e2 / 0.108e3 * t4498 * t477;
  t5156 = -0.2e5 / 0.243e3 * t2246 * t1563 - 0.2e5 / 0.243e3 * t548 * t312 * t501 * t490 - 0.1e3 / 0.9e1 * t2280 * t1571 - 0.5e4 / 0.243e3 * t1815 * t312 * t462 * t512 - 0.2e3 / 0.9e1 * t2835 * t1293 * t4969 + 0.5e2 / 0.9e1 * t727 * t1578 - 0.1e3 / 0.9e1 * t991 * t475 * t4560 * t162 + 0.25e2 / 0.18e2 * t541 * t1585 * t477 + 0.4e5 / 0.243e3 * t1910 * t1453 * t4482 * t162 + 0.1e3 / 0.3e1 * t2551 * t475 * t4577 * t162 - 0.2e3 / 0.9e1 * t991 * t475 * t1274 * t490 + 0.4e5 / 0.243e3 * t784 * t1567 - 0.5e4 / 0.243e3 * t222 * t5075 * t312 - 0.5e6 / 0.6561e4 * t4366 * t2350 - 0.18e2 * t1227 * t4507 * t162 + 0.4e7 / 0.19683e5 * t4504 * t2132 + 0.1e7 / 0.6561e4 * t1757 * t5074 * t4668 - 0.6e1 * t669 * t167 * t1581 - t117 * t167 * t1593;
  t5161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t5099 + t5156));
  tv4sigmatau30 = 0.2e1 * rho[0] * t5161;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t5173 = t512 * t512;
  t5180 = t521 * t521;
  t5218 = 0.4e3 / 0.9e1 * t2123 * t151 * t175 * t1581 - 0.4e3 / 0.9e1 * t991 * t475 * t1274 * t521 + 0.16e8 / 0.19683e5 * t4504 * t2350 + 0.24e2 * t1749 * t78 * t5173 - 0.36e2 * t669 * t513 * t521 + 0.6e1 * t255 * t78 * t5180 + 0.8e1 * t255 * t185 * t1593 + 0.2e3 / 0.27e2 * t232 * t151 * t175 * t1593 - 0.4e5 / 0.243e3 * t548 * t312 * t501 * t521 - 0.8e7 / 0.6561e4 * t1757 * t1632 * t4668 + 0.4e5 / 0.243e3 * t222 * t1633 * t312 - 0.4e3 / 0.9e1 * t2835 * t1293 * t5060 + 0.2e3 / 0.9e1 * t1108 * t1293 * t5069 - 0.1e8 / 0.6561e4 * t4646 * t1757 * t1633 - 0.16e6 / 0.243e3 * t1805 * t312 * t1557 * t184 + 0.8e5 / 0.243e3 * t1815 * t312 * t501 * t512;
  t5222 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t5218);
  tv4tau40 = 0.2e1 * rho[0] * t5222;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t52, t53, t54, t57, t60;
  double t61, t62, t63, t64, t65, t68, t71, t72;
  double t75, t76, t77, t78, t83, t85, t89, t90;
  double t91, t93, t94, t95, t96, t98, t99, t100;
  double t101, t102, t104, t105, t107, t108, t112, t114;
  double t117, t118, t122, t123, t124, t125, t128, t133;
  double t134, t135, t136, t141, t143, t147, tzk0;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t52 = tau[0] * t49 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t57 = 0.1e1 / t31 / t30;
  t60 = 0.1e1 - 0.25e2 / 0.81e2 * t53 * t54 * t57;
  t61 = t60 * t60;
  t62 = t61 * t60;
  t63 = t53 * t52;
  t64 = t30 * t30;
  t65 = 0.1e1 / t64;
  t68 = t53 * t53;
  t71 = t64 * t64;
  t72 = 0.1e1 / t71;
  t75 = 0.1e1 + 0.25e3 / 0.243e3 * t63 * t65 + 0.625e5 / 0.59049e5 * params->b * t68 * t53 * t72;
  t76 = 0.1e1 / t75;
  t77 = t62 * t76;
  t78 = params->kappa + t42 + params->c;
  t83 = params->kappa * (0.1e1 - params->kappa / t78) - t47;
  t85 = t77 * t83 + t47 + 0.1e1;
  t89 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t85);
  t90 = rho[1] <= p->dens_threshold;
  t91 = -t17;
  t93 = my_piecewise5(t15, t12, t11, t16, t91 * t8);
  t94 = 0.1e1 + t93;
  t95 = t94 <= p->zeta_threshold;
  t96 = POW_1_3(t94);
  t98 = my_piecewise3(t95, t23, t96 * t94);
  t99 = t98 * t27;
  t100 = rho[1] * rho[1];
  t101 = POW_1_3(rho[1]);
  t102 = t101 * t101;
  t104 = 0.1e1 / t102 / t100;
  t105 = sigma[2] * t104;
  t107 = 0.5e1 / 0.972e3 * t34 * t105;
  t108 = params->kappa + t107;
  t112 = params->kappa * (0.1e1 - params->kappa / t108);
  t114 = 0.1e1 / t102 / rho[1];
  t117 = tau[1] * t114 - t105 / 0.8e1;
  t118 = t117 * t117;
  t122 = 0.1e1 - 0.25e2 / 0.81e2 * t118 * t54 * t57;
  t123 = t122 * t122;
  t124 = t123 * t122;
  t125 = t118 * t117;
  t128 = t118 * t118;
  t133 = 0.1e1 + 0.25e3 / 0.243e3 * t125 * t65 + 0.625e5 / 0.59049e5 * params->b * t128 * t118 * t72;
  t134 = 0.1e1 / t133;
  t135 = t124 * t134;
  t136 = params->kappa + t107 + params->c;
  t141 = params->kappa * (0.1e1 - params->kappa / t136) - t112;
  t143 = t135 * t141 + t112 + 0.1e1;
  t147 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t143);
  tzk0 = t89 + t147;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t52, t53, t54, t57, t60;
  double t61, t62, t63, t64, t65, t68, t71, t72;
  double t75, t76, t77, t78, t83, t85, t89, t90;
  double t91, t93, t94, t95, t96, t98, t99, t100;
  double t101, t102, t104, t105, t107, t108, t112, t114;
  double t117, t118, t122, t123, t124, t125, t128, t133;
  double t134, t135, t136, t141, t143, t147, tzk0;

  double t148, t149, t150, t152, t155, t156, t160, t161;
  double t162, t165, t166, t167, t169, t170, t171, t172;
  double t174, t175, t176, t178, t179, t180, t185, t186;
  double t187, t190, t191, t192, t193, t197, t198, t201;
  double t202, t204, t206, t207, t210, t212, t217, t218;
  double t220, t223, t224, t228, t231, t233, tvrho0, t237;
  double t240, t241, t246, t248, t251, t252, t256, t258;
  double t259, t260, t261, t263, t264, t265, t267, t268;
  double t269, t274, t275, t276, t279, t280, t281, t282;
  double t286, t287, t290, t291, t293, t295, t296, t299;
  double t301, t306, tvrho1, t309, t310, t312, t313, t314;
  double t316, t318, t319, t321, t322, t326, t328, t332;
  double tvsigma0, tvsigma1, t333, t334, t336, t337, t338, t340;
  double t342, t343, t345, t346, t350, t352, t356, tvsigma2;
  double tvlapl0, tvlapl1, t357, t358, t363, t366, t367, t369;
  double t373, tvtau0, t374, t375, t380, t383, t384, t386;
  double t390, tvtau1;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t52 = tau[0] * t49 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t57 = 0.1e1 / t31 / t30;
  t60 = 0.1e1 - 0.25e2 / 0.81e2 * t53 * t54 * t57;
  t61 = t60 * t60;
  t62 = t61 * t60;
  t63 = t53 * t52;
  t64 = t30 * t30;
  t65 = 0.1e1 / t64;
  t68 = t53 * t53;
  t71 = t64 * t64;
  t72 = 0.1e1 / t71;
  t75 = 0.1e1 + 0.25e3 / 0.243e3 * t63 * t65 + 0.625e5 / 0.59049e5 * params->b * t68 * t53 * t72;
  t76 = 0.1e1 / t75;
  t77 = t62 * t76;
  t78 = params->kappa + t42 + params->c;
  t83 = params->kappa * (0.1e1 - params->kappa / t78) - t47;
  t85 = t77 * t83 + t47 + 0.1e1;
  t89 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t85);
  t90 = rho[1] <= p->dens_threshold;
  t91 = -t17;
  t93 = my_piecewise5(t15, t12, t11, t16, t91 * t8);
  t94 = 0.1e1 + t93;
  t95 = t94 <= p->zeta_threshold;
  t96 = POW_1_3(t94);
  t98 = my_piecewise3(t95, t23, t96 * t94);
  t99 = t98 * t27;
  t100 = rho[1] * rho[1];
  t101 = POW_1_3(rho[1]);
  t102 = t101 * t101;
  t104 = 0.1e1 / t102 / t100;
  t105 = sigma[2] * t104;
  t107 = 0.5e1 / 0.972e3 * t34 * t105;
  t108 = params->kappa + t107;
  t112 = params->kappa * (0.1e1 - params->kappa / t108);
  t114 = 0.1e1 / t102 / rho[1];
  t117 = tau[1] * t114 - t105 / 0.8e1;
  t118 = t117 * t117;
  t122 = 0.1e1 - 0.25e2 / 0.81e2 * t118 * t54 * t57;
  t123 = t122 * t122;
  t124 = t123 * t122;
  t125 = t118 * t117;
  t128 = t118 * t118;
  t133 = 0.1e1 + 0.25e3 / 0.243e3 * t125 * t65 + 0.625e5 / 0.59049e5 * params->b * t128 * t118 * t72;
  t134 = 0.1e1 / t133;
  t135 = t124 * t134;
  t136 = params->kappa + t107 + params->c;
  t141 = params->kappa * (0.1e1 - params->kappa / t136) - t112;
  t143 = t135 * t141 + t112 + 0.1e1;
  t147 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t143);
  tzk0 = t89 + t147;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t148 = t7 * t7;
  t149 = 0.1e1 / t148;
  t150 = t17 * t149;
  t152 = my_piecewise5(t11, 0, t15, 0, t8 - t150);
  t155 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t152);
  t156 = t155 * t27;
  t160 = t27 * t27;
  t161 = 0.1e1 / t160;
  t162 = t26 * t161;
  t165 = t6 * t162 * t85 / 0.8e1;
  t166 = params->kappa * params->kappa;
  t167 = t43 * t43;
  t169 = t166 / t167;
  t170 = t169 * t29;
  t171 = t33 * sigma[0];
  t172 = t35 * rho[0];
  t174 = 0.1e1 / t37 / t172;
  t175 = t171 * t174;
  t176 = t170 * t175;
  t178 = t61 * t76;
  t179 = t178 * t83;
  t180 = t52 * t54;
  t185 = -0.5e1 / 0.3e1 * tau[0] * t39 + sigma[0] * t174 / 0.3e1;
  t186 = t57 * t185;
  t187 = t180 * t186;
  t190 = t75 * t75;
  t191 = 0.1e1 / t190;
  t192 = t62 * t191;
  t193 = t53 * t65;
  t197 = params->b * t68 * t52;
  t198 = t72 * t185;
  t201 = 0.25e3 / 0.81e2 * t193 * t185 + 0.125e6 / 0.19683e5 * t197 * t198;
  t202 = t83 * t201;
  t204 = t78 * t78;
  t206 = t166 / t204;
  t207 = t206 * t29;
  t210 = -0.1e2 / 0.729e3 * t207 * t175 + 0.1e2 / 0.729e3 * t176;
  t212 = -0.1e2 / 0.729e3 * t176 - 0.5e2 / 0.27e2 * t179 * t187 - t192 * t202 + t77 * t210;
  t217 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t85 - t165 - 0.3e1 / 0.8e1 * t6 * t28 * t212);
  t218 = t91 * t149;
  t220 = my_piecewise5(t15, 0, t11, 0, -t8 - t218);
  t223 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t220);
  t224 = t223 * t27;
  t228 = t98 * t161;
  t231 = t6 * t228 * t143 / 0.8e1;
  t233 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t143 - t231);
  tvrho0 = t89 + t147 + t7 * (t217 + t233);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t237 = my_piecewise5(t11, 0, t15, 0, -t8 - t150);
  t240 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t237);
  t241 = t240 * t27;
  t246 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t85 - t165);
  t248 = my_piecewise5(t15, 0, t11, 0, t8 - t218);
  t251 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t248);
  t252 = t251 * t27;
  t256 = t108 * t108;
  t258 = t166 / t256;
  t259 = t258 * t29;
  t260 = t33 * sigma[2];
  t261 = t100 * rho[1];
  t263 = 0.1e1 / t102 / t261;
  t264 = t260 * t263;
  t265 = t259 * t264;
  t267 = t123 * t134;
  t268 = t267 * t141;
  t269 = t117 * t54;
  t274 = -0.5e1 / 0.3e1 * tau[1] * t104 + sigma[2] * t263 / 0.3e1;
  t275 = t57 * t274;
  t276 = t269 * t275;
  t279 = t133 * t133;
  t280 = 0.1e1 / t279;
  t281 = t124 * t280;
  t282 = t118 * t65;
  t286 = params->b * t128 * t117;
  t287 = t72 * t274;
  t290 = 0.25e3 / 0.81e2 * t282 * t274 + 0.125e6 / 0.19683e5 * t286 * t287;
  t291 = t141 * t290;
  t293 = t136 * t136;
  t295 = t166 / t293;
  t296 = t295 * t29;
  t299 = -0.1e2 / 0.729e3 * t296 * t264 + 0.1e2 / 0.729e3 * t265;
  t301 = -0.1e2 / 0.729e3 * t265 - 0.5e2 / 0.27e2 * t268 * t276 - t281 * t291 + t135 * t299;
  t306 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t143 - t231 - 0.3e1 / 0.8e1 * t6 * t99 * t301);
  tvrho1 = t89 + t147 + t7 * (t246 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t309 = t34 * t39;
  t310 = t169 * t309;
  t312 = t57 * t39;
  t313 = t180 * t312;
  t314 = t179 * t313;
  t316 = t193 * t39;
  t318 = t72 * t39;
  t319 = t197 * t318;
  t321 = -0.125e3 / 0.324e3 * t316 - 0.15625e5 / 0.19683e5 * t319;
  t322 = t83 * t321;
  t326 = 0.5e1 / 0.972e3 * t206 * t309 - 0.5e1 / 0.972e3 * t310;
  t328 = 0.5e1 / 0.972e3 * t310 + 0.25e2 / 0.108e3 * t314 - t192 * t322 + t77 * t326;
  t332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t328);
  tvsigma0 = t7 * t332;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t333 = t34 * t104;
  t334 = t258 * t333;
  t336 = t57 * t104;
  t337 = t269 * t336;
  t338 = t268 * t337;
  t340 = t282 * t104;
  t342 = t72 * t104;
  t343 = t286 * t342;
  t345 = -0.125e3 / 0.324e3 * t340 - 0.15625e5 / 0.19683e5 * t343;
  t346 = t141 * t345;
  t350 = 0.5e1 / 0.972e3 * t295 * t333 - 0.5e1 / 0.972e3 * t334;
  t352 = 0.5e1 / 0.972e3 * t334 + 0.25e2 / 0.108e3 * t338 - t281 * t346 + t135 * t350;
  t356 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t352);
  tvsigma2 = t7 * t356;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t357 = t57 * t49;
  t358 = t180 * t357;
  t363 = t72 * t49;
  t366 = 0.25e3 / 0.81e2 * t193 * t49 + 0.125e6 / 0.19683e5 * t197 * t363;
  t367 = t83 * t366;
  t369 = -0.5e2 / 0.27e2 * t179 * t358 - t192 * t367;
  t373 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t369);
  tvtau0 = t7 * t373;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t374 = t57 * t114;
  t375 = t269 * t374;
  t380 = t72 * t114;
  t383 = 0.25e3 / 0.81e2 * t282 * t114 + 0.125e6 / 0.19683e5 * t286 * t380;
  t384 = t141 * t383;
  t386 = -0.5e2 / 0.27e2 * t268 * t375 - t281 * t384;
  t390 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t386);
  tvtau1 = t7 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t52, t53, t54, t57, t60;
  double t61, t62, t63, t64, t65, t68, t71, t72;
  double t75, t76, t77, t78, t83, t85, t89, t90;
  double t91, t93, t94, t95, t96, t98, t99, t100;
  double t101, t102, t104, t105, t107, t108, t112, t114;
  double t117, t118, t122, t123, t124, t125, t128, t133;
  double t134, t135, t136, t141, t143, t147, tzk0;

  double t148, t149, t150, t152, t155, t156, t160, t161;
  double t162, t165, t166, t167, t169, t170, t171, t172;
  double t174, t175, t176, t178, t179, t180, t185, t186;
  double t187, t190, t191, t192, t193, t197, t198, t201;
  double t202, t204, t206, t207, t210, t212, t217, t218;
  double t220, t223, t224, t228, t231, t233, tvrho0, t237;
  double t240, t241, t246, t248, t251, t252, t256, t258;
  double t259, t260, t261, t263, t264, t265, t267, t268;
  double t269, t274, t275, t276, t279, t280, t281, t282;
  double t286, t287, t290, t291, t293, t295, t296, t299;
  double t301, t306, tvrho1, t309, t310, t312, t313, t314;
  double t316, t318, t319, t321, t322, t326, t328, t332;
  double tvsigma0, tvsigma1, t333, t334, t336, t337, t338, t340;
  double t342, t343, t345, t346, t350, t352, t356, tvsigma2;
  double tvlapl0, tvlapl1, t357, t358, t363, t366, t367, t369;
  double t373, tvtau0, t374, t375, t380, t383, t384, t386;
  double t390, tvtau1;

  double t393, t394, t395, t398, t399, t400, t403, t407;
  double t408, t412, t414, t420, t421, t424, t426, t430;
  double t431, t432, t433, t434, t435, t437, t438, t440;
  double t442, t443, t445, t446, t447, t448, t450, t451;
  double t452, t453, t456, t457, t458, t459, t460, t461;
  double t464, t467, t468, t475, t476, t477, t481, t482;
  double t483, t484, t487, t490, t495, t496, t502, t507;
  double t508, t513, t515, t520, t521, t522, t523, t526;
  double t529, t533, t534, t538, t540, t542, t545, t547;
  double tv2rho20, t550, t554, t558, t559, t563, t565, t573;
  double t574, t578, t582, t583, t587, t589, t596, t599;
  double tv2rho21, t604, t609, t613, t614, t620, t621, t626;
  double t630, t631, t642, t643, t644, t645, t646, t647;
  double t649, t650, t652, t654, t655, t657, t658, t659;
  double t660, t661, t662, t663, t666, t667, t668, t669;
  double t670, t673, t676, t677, t684, t685, t686, t690;
  double t691, t692, t693, t696, t699, t704, t705, t711;
  double t716, t717, t722, t724, t729, tv2rho22, t737, t738;
  double t740, t742, t744, t745, t747, t748, t749, t750;
  double t751, t752, t753, t755, t756, t757, t759, t761;
  double t762, t763, t765, t766, t767, t769, t775, t777;
  double t779, t782, t784, t785, t787, t788, t790, t799;
  double t801, t806, tv2rhosigma0, tv2rhosigma1, t813, t815, tv2rhosigma2, t821;
  double tv2rhosigma3, tv2rhosigma4, t826, t828, t830, t832, t833, t835;
  double t836, t837, t838, t839, t840, t842, t843, t844;
  double t846, t848, t849, t850, t852, t853, t854, t856;
  double t862, t864, t866, t869, t871, t872, t874, t875;
  double t877, t886, t888, t893, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2;
  double tv2rholapl3, t900, t901, t902, t905, t906, t911, t915;
  double t921, t930, t931, t933, t938, tv2rhotau0, t945, t947;
  double tv2rhotau1, t953, tv2rhotau2, t958, t959, t962, t963, t968;
  double t972, t978, t987, t988, t990, t995, tv2rhotau3, t997;
  double t999, t1000, t1001, t1003, t1004, t1005, t1007, t1008;
  double t1009, t1011, t1013, t1015, t1016, t1019, t1022, t1024;
  double t1025, t1027, t1028, t1032, t1034, t1038, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t1039, t1041, t1042, t1043, t1045;
  double t1046, t1047, t1049, t1050, t1051, t1053, t1055, t1057;
  double t1058, t1061, t1064, t1066, t1067, t1069, t1070, t1074;
  double t1076, t1080, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double tv2sigmalapl5, t1082, t1083, t1084, t1085, t1087, t1088, t1093;
  double t1094, t1095, t1097, t1099, t1102, t1104, t1106, t1107;
  double t1109, t1110, t1112, t1116, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3;
  double tv2sigmatau4, t1118, t1119, t1120, t1121, t1123, t1124, t1129;
  double t1130, t1131, t1133, t1135, t1138, t1140, t1142, t1143;
  double t1145, t1146, t1148, t1152, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22;
  double tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1154, t1155, t1156, t1159;
  double t1160, t1163, t1164, t1167, t1168, t1173, t1176, t1177;
  double t1179, t1183, tv2tau20, tv2tau21, t1185, t1186, t1187, t1190;
  double t1191, t1194, t1195, t1198, t1199, t1204, t1207, t1208;
  double t1210, t1214, tv2tau22;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t52 = tau[0] * t49 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t57 = 0.1e1 / t31 / t30;
  t60 = 0.1e1 - 0.25e2 / 0.81e2 * t53 * t54 * t57;
  t61 = t60 * t60;
  t62 = t61 * t60;
  t63 = t53 * t52;
  t64 = t30 * t30;
  t65 = 0.1e1 / t64;
  t68 = t53 * t53;
  t71 = t64 * t64;
  t72 = 0.1e1 / t71;
  t75 = 0.1e1 + 0.25e3 / 0.243e3 * t63 * t65 + 0.625e5 / 0.59049e5 * params->b * t68 * t53 * t72;
  t76 = 0.1e1 / t75;
  t77 = t62 * t76;
  t78 = params->kappa + t42 + params->c;
  t83 = params->kappa * (0.1e1 - params->kappa / t78) - t47;
  t85 = t77 * t83 + t47 + 0.1e1;
  t89 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t85);
  t90 = rho[1] <= p->dens_threshold;
  t91 = -t17;
  t93 = my_piecewise5(t15, t12, t11, t16, t91 * t8);
  t94 = 0.1e1 + t93;
  t95 = t94 <= p->zeta_threshold;
  t96 = POW_1_3(t94);
  t98 = my_piecewise3(t95, t23, t96 * t94);
  t99 = t98 * t27;
  t100 = rho[1] * rho[1];
  t101 = POW_1_3(rho[1]);
  t102 = t101 * t101;
  t104 = 0.1e1 / t102 / t100;
  t105 = sigma[2] * t104;
  t107 = 0.5e1 / 0.972e3 * t34 * t105;
  t108 = params->kappa + t107;
  t112 = params->kappa * (0.1e1 - params->kappa / t108);
  t114 = 0.1e1 / t102 / rho[1];
  t117 = tau[1] * t114 - t105 / 0.8e1;
  t118 = t117 * t117;
  t122 = 0.1e1 - 0.25e2 / 0.81e2 * t118 * t54 * t57;
  t123 = t122 * t122;
  t124 = t123 * t122;
  t125 = t118 * t117;
  t128 = t118 * t118;
  t133 = 0.1e1 + 0.25e3 / 0.243e3 * t125 * t65 + 0.625e5 / 0.59049e5 * params->b * t128 * t118 * t72;
  t134 = 0.1e1 / t133;
  t135 = t124 * t134;
  t136 = params->kappa + t107 + params->c;
  t141 = params->kappa * (0.1e1 - params->kappa / t136) - t112;
  t143 = t135 * t141 + t112 + 0.1e1;
  t147 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t143);
  tzk0 = t89 + t147;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t148 = t7 * t7;
  t149 = 0.1e1 / t148;
  t150 = t17 * t149;
  t152 = my_piecewise5(t11, 0, t15, 0, t8 - t150);
  t155 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t152);
  t156 = t155 * t27;
  t160 = t27 * t27;
  t161 = 0.1e1 / t160;
  t162 = t26 * t161;
  t165 = t6 * t162 * t85 / 0.8e1;
  t166 = params->kappa * params->kappa;
  t167 = t43 * t43;
  t169 = t166 / t167;
  t170 = t169 * t29;
  t171 = t33 * sigma[0];
  t172 = t35 * rho[0];
  t174 = 0.1e1 / t37 / t172;
  t175 = t171 * t174;
  t176 = t170 * t175;
  t178 = t61 * t76;
  t179 = t178 * t83;
  t180 = t52 * t54;
  t185 = -0.5e1 / 0.3e1 * tau[0] * t39 + sigma[0] * t174 / 0.3e1;
  t186 = t57 * t185;
  t187 = t180 * t186;
  t190 = t75 * t75;
  t191 = 0.1e1 / t190;
  t192 = t62 * t191;
  t193 = t53 * t65;
  t197 = params->b * t68 * t52;
  t198 = t72 * t185;
  t201 = 0.25e3 / 0.81e2 * t193 * t185 + 0.125e6 / 0.19683e5 * t197 * t198;
  t202 = t83 * t201;
  t204 = t78 * t78;
  t206 = t166 / t204;
  t207 = t206 * t29;
  t210 = -0.1e2 / 0.729e3 * t207 * t175 + 0.1e2 / 0.729e3 * t176;
  t212 = -0.1e2 / 0.729e3 * t176 - 0.5e2 / 0.27e2 * t179 * t187 - t192 * t202 + t77 * t210;
  t217 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t85 - t165 - 0.3e1 / 0.8e1 * t6 * t28 * t212);
  t218 = t91 * t149;
  t220 = my_piecewise5(t15, 0, t11, 0, -t8 - t218);
  t223 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t220);
  t224 = t223 * t27;
  t228 = t98 * t161;
  t231 = t6 * t228 * t143 / 0.8e1;
  t233 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t143 - t231);
  tvrho0 = t89 + t147 + t7 * (t217 + t233);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t237 = my_piecewise5(t11, 0, t15, 0, -t8 - t150);
  t240 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t237);
  t241 = t240 * t27;
  t246 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t85 - t165);
  t248 = my_piecewise5(t15, 0, t11, 0, t8 - t218);
  t251 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t248);
  t252 = t251 * t27;
  t256 = t108 * t108;
  t258 = t166 / t256;
  t259 = t258 * t29;
  t260 = t33 * sigma[2];
  t261 = t100 * rho[1];
  t263 = 0.1e1 / t102 / t261;
  t264 = t260 * t263;
  t265 = t259 * t264;
  t267 = t123 * t134;
  t268 = t267 * t141;
  t269 = t117 * t54;
  t274 = -0.5e1 / 0.3e1 * tau[1] * t104 + sigma[2] * t263 / 0.3e1;
  t275 = t57 * t274;
  t276 = t269 * t275;
  t279 = t133 * t133;
  t280 = 0.1e1 / t279;
  t281 = t124 * t280;
  t282 = t118 * t65;
  t286 = params->b * t128 * t117;
  t287 = t72 * t274;
  t290 = 0.25e3 / 0.81e2 * t282 * t274 + 0.125e6 / 0.19683e5 * t286 * t287;
  t291 = t141 * t290;
  t293 = t136 * t136;
  t295 = t166 / t293;
  t296 = t295 * t29;
  t299 = -0.1e2 / 0.729e3 * t296 * t264 + 0.1e2 / 0.729e3 * t265;
  t301 = -0.1e2 / 0.729e3 * t265 - 0.5e2 / 0.27e2 * t268 * t276 - t281 * t291 + t135 * t299;
  t306 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t143 - t231 - 0.3e1 / 0.8e1 * t6 * t99 * t301);
  tvrho1 = t89 + t147 + t7 * (t246 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t309 = t34 * t39;
  t310 = t169 * t309;
  t312 = t57 * t39;
  t313 = t180 * t312;
  t314 = t179 * t313;
  t316 = t193 * t39;
  t318 = t72 * t39;
  t319 = t197 * t318;
  t321 = -0.125e3 / 0.324e3 * t316 - 0.15625e5 / 0.19683e5 * t319;
  t322 = t83 * t321;
  t326 = 0.5e1 / 0.972e3 * t206 * t309 - 0.5e1 / 0.972e3 * t310;
  t328 = 0.5e1 / 0.972e3 * t310 + 0.25e2 / 0.108e3 * t314 - t192 * t322 + t77 * t326;
  t332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t328);
  tvsigma0 = t7 * t332;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t333 = t34 * t104;
  t334 = t258 * t333;
  t336 = t57 * t104;
  t337 = t269 * t336;
  t338 = t268 * t337;
  t340 = t282 * t104;
  t342 = t72 * t104;
  t343 = t286 * t342;
  t345 = -0.125e3 / 0.324e3 * t340 - 0.15625e5 / 0.19683e5 * t343;
  t346 = t141 * t345;
  t350 = 0.5e1 / 0.972e3 * t295 * t333 - 0.5e1 / 0.972e3 * t334;
  t352 = 0.5e1 / 0.972e3 * t334 + 0.25e2 / 0.108e3 * t338 - t281 * t346 + t135 * t350;
  t356 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t352);
  tvsigma2 = t7 * t356;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t357 = t57 * t49;
  t358 = t180 * t357;
  t363 = t72 * t49;
  t366 = 0.25e3 / 0.81e2 * t193 * t49 + 0.125e6 / 0.19683e5 * t197 * t363;
  t367 = t83 * t366;
  t369 = -0.5e2 / 0.27e2 * t179 * t358 - t192 * t367;
  t373 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t369);
  tvtau0 = t7 * t373;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t374 = t57 * t114;
  t375 = t269 * t374;
  t380 = t72 * t114;
  t383 = 0.25e3 / 0.81e2 * t282 * t114 + 0.125e6 / 0.19683e5 * t286 * t380;
  t384 = t141 * t383;
  t386 = -0.5e2 / 0.27e2 * t268 * t375 - t281 * t384;
  t390 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t386);
  tvtau1 = t7 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t393 = t24 * t24;
  t394 = 0.1e1 / t393;
  t395 = t152 * t152;
  t398 = t148 * t7;
  t399 = 0.1e1 / t398;
  t400 = t17 * t399;
  t403 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t149 + 0.2e1 * t400);
  t407 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t394 * t395 + 0.4e1 / 0.3e1 * t24 * t403);
  t408 = t407 * t27;
  t412 = t155 * t161;
  t414 = t6 * t412 * t85;
  t420 = 0.1e1 / t160 / t7;
  t421 = t26 * t420;
  t424 = t6 * t421 * t85 / 0.12e2;
  t426 = t6 * t162 * t212;
  t430 = t166 / t167 / t43;
  t431 = t430 * t54;
  t432 = sigma[0] * sigma[0];
  t433 = t57 * t432;
  t434 = t35 * t35;
  t435 = t434 * t172;
  t437 = 0.1e1 / t36 / t435;
  t438 = t433 * t437;
  t440 = 0.2e3 / 0.531441e6 * t431 * t438;
  t442 = 0.1e1 / t37 / t434;
  t443 = t171 * t442;
  t445 = 0.11e3 / 0.2187e4 * t170 * t443;
  t446 = t60 * t76;
  t447 = t446 * t83;
  t448 = t53 * t29;
  t450 = 0.1e1 / t32 / t64;
  t451 = t185 * t185;
  t452 = t450 * t451;
  t453 = t448 * t452;
  t456 = t61 * t191;
  t457 = t83 * t52;
  t458 = t456 * t457;
  t459 = t54 * t57;
  t460 = t185 * t201;
  t461 = t459 * t460;
  t464 = t178 * t210;
  t467 = t451 * t54;
  t468 = t467 * t57;
  t475 = 0.4e2 / 0.9e1 * tau[0] * t174 - 0.11e2 / 0.9e1 * sigma[0] * t442;
  t476 = t57 * t475;
  t477 = t180 * t476;
  t481 = 0.1e1 / t190 / t75;
  t482 = t62 * t481;
  t483 = t201 * t201;
  t484 = t83 * t483;
  t487 = t210 * t201;
  t490 = t52 * t65;
  t495 = params->b * t68;
  t496 = t72 * t451;
  t502 = 0.5e3 / 0.81e2 * t490 * t451 + 0.25e3 / 0.81e2 * t193 * t475 + 0.625e6 / 0.19683e5 * t495 * t496 + 0.125e6 / 0.19683e5 * t197 * t72 * t475;
  t507 = t166 / t204 / t78;
  t508 = t507 * t54;
  t513 = -0.2e3 / 0.531441e6 * t508 * t438 + 0.11e3 / 0.2187e4 * t207 * t443 + t440 - t445;
  t515 = -t440 + t445 + 0.1e5 / 0.729e3 * t447 * t453 + 0.1e3 / 0.27e2 * t458 * t461 - 0.1e3 / 0.27e2 * t464 * t187 - 0.5e2 / 0.27e2 * t179 * t468 - 0.5e2 / 0.27e2 * t179 * t477 + 0.2e1 * t482 * t484 - 0.2e1 * t192 * t487 - t192 * t83 * t502 + t77 * t513;
  t520 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t85 - t414 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t212 + t424 - t426 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t515);
  t521 = t96 * t96;
  t522 = 0.1e1 / t521;
  t523 = t220 * t220;
  t526 = t91 * t399;
  t529 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t149 + 0.2e1 * t526);
  t533 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t522 * t523 + 0.4e1 / 0.3e1 * t96 * t529);
  t534 = t533 * t27;
  t538 = t223 * t161;
  t540 = t6 * t538 * t143;
  t542 = t98 * t420;
  t545 = t6 * t542 * t143 / 0.12e2;
  t547 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t143 - t540 / 0.4e1 + t545);
  tv2rho20 = 0.2e1 * t217 + 0.2e1 * t233 + t7 * (t520 + t547);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t550 = t394 * t237;
  t554 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t400);
  t558 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t550 * t152 + 0.4e1 / 0.3e1 * t24 * t554);
  t559 = t558 * t27;
  t563 = t240 * t161;
  t565 = t6 * t563 * t85;
  t573 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t85 - t565 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t212 - t414 / 0.8e1 + t424 - t426 / 0.8e1);
  t574 = t522 * t248;
  t578 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t526);
  t582 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t574 * t220 + 0.4e1 / 0.3e1 * t96 * t578);
  t583 = t582 * t27;
  t587 = t251 * t161;
  t589 = t6 * t587 * t143;
  t596 = t6 * t228 * t301;
  t599 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t143 - t589 / 0.8e1 - t540 / 0.8e1 + t545 - 0.3e1 / 0.8e1 * t6 * t224 * t301 - t596 / 0.8e1);
  tv2rho21 = t217 + t233 + t246 + t306 + t7 * (t573 + t599);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t604 = t237 * t237;
  t609 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t149 + 0.2e1 * t400);
  t613 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t394 * t604 + 0.4e1 / 0.3e1 * t24 * t609);
  t614 = t613 * t27;
  t620 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t85 - t565 / 0.4e1 + t424);
  t621 = t248 * t248;
  t626 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t149 + 0.2e1 * t526);
  t630 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t522 * t621 + 0.4e1 / 0.3e1 * t96 * t626);
  t631 = t630 * t27;
  t642 = t166 / t256 / t108;
  t643 = t642 * t54;
  t644 = sigma[2] * sigma[2];
  t645 = t57 * t644;
  t646 = t100 * t100;
  t647 = t646 * t261;
  t649 = 0.1e1 / t101 / t647;
  t650 = t645 * t649;
  t652 = 0.2e3 / 0.531441e6 * t643 * t650;
  t654 = 0.1e1 / t102 / t646;
  t655 = t260 * t654;
  t657 = 0.11e3 / 0.2187e4 * t259 * t655;
  t658 = t122 * t134;
  t659 = t658 * t141;
  t660 = t118 * t29;
  t661 = t274 * t274;
  t662 = t450 * t661;
  t663 = t660 * t662;
  t666 = t123 * t280;
  t667 = t141 * t117;
  t668 = t666 * t667;
  t669 = t274 * t290;
  t670 = t459 * t669;
  t673 = t267 * t299;
  t676 = t661 * t54;
  t677 = t676 * t57;
  t684 = 0.4e2 / 0.9e1 * tau[1] * t263 - 0.11e2 / 0.9e1 * sigma[2] * t654;
  t685 = t57 * t684;
  t686 = t269 * t685;
  t690 = 0.1e1 / t279 / t133;
  t691 = t124 * t690;
  t692 = t290 * t290;
  t693 = t141 * t692;
  t696 = t299 * t290;
  t699 = t117 * t65;
  t704 = params->b * t128;
  t705 = t72 * t661;
  t711 = 0.5e3 / 0.81e2 * t699 * t661 + 0.25e3 / 0.81e2 * t282 * t684 + 0.625e6 / 0.19683e5 * t704 * t705 + 0.125e6 / 0.19683e5 * t286 * t72 * t684;
  t716 = t166 / t293 / t136;
  t717 = t716 * t54;
  t722 = -0.2e3 / 0.531441e6 * t717 * t650 + 0.11e3 / 0.2187e4 * t296 * t655 + t652 - t657;
  t724 = -t652 + t657 + 0.1e5 / 0.729e3 * t659 * t663 + 0.1e3 / 0.27e2 * t668 * t670 - 0.1e3 / 0.27e2 * t673 * t276 - 0.5e2 / 0.27e2 * t268 * t677 - 0.5e2 / 0.27e2 * t268 * t686 + 0.2e1 * t691 * t693 - 0.2e1 * t281 * t696 - t281 * t141 * t711 + t135 * t722;
  t729 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t143 - t589 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t301 + t545 - t596 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t724);
  tv2rho22 = 0.2e1 * t246 + 0.2e1 * t306 + t7 * (t620 + t729);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t737 = t6 * t162 * t328 / 0.8e1;
  t738 = t434 * t35;
  t740 = 0.1e1 / t36 / t738;
  t742 = t57 * t740 * sigma[0];
  t744 = 0.25e2 / 0.177147e6 * t431 * t742;
  t745 = t34 * t174;
  t747 = 0.1e2 / 0.729e3 * t169 * t745;
  t748 = t83 * t53;
  t749 = t446 * t748;
  t750 = t29 * t450;
  t751 = t39 * t185;
  t752 = t750 * t751;
  t753 = t749 * t752;
  t755 = t39 * t201;
  t756 = t459 * t755;
  t757 = t458 * t756;
  t759 = t464 * t313;
  t761 = t185 * t54;
  t762 = t761 * t312;
  t763 = t179 * t762;
  t765 = t57 * t174;
  t766 = t180 * t765;
  t767 = t179 * t766;
  t769 = t456 * t322;
  t775 = t210 * t321;
  t777 = t490 * t751;
  t779 = t193 * t174;
  t782 = t495 * t318 * t185;
  t784 = t72 * t174;
  t785 = t197 * t784;
  t787 = -0.125e3 / 0.162e3 * t777 + 0.25e3 / 0.243e3 * t779 - 0.78125e5 / 0.19683e5 * t782 + 0.125e6 / 0.59049e5 * t785;
  t788 = t83 * t787;
  t790 = t178 * t326;
  t799 = 0.25e2 / 0.177147e6 * t508 * t742 - 0.1e2 / 0.729e3 * t206 * t745 - t744 + t747;
  t801 = t744 - t747 - 0.125e4 / 0.729e3 * t753 - 0.25e2 / 0.108e3 * t757 + 0.25e2 / 0.108e3 * t759 + 0.25e2 / 0.108e3 * t763 - 0.5e2 / 0.81e2 * t767 + 0.5e2 / 0.27e2 * t769 * t187 + 0.2e1 * t482 * t322 * t201 - t192 * t775 - t192 * t788 - 0.5e2 / 0.27e2 * t790 * t187 - t192 * t326 * t201 + t77 * t799;
  t806 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t328 - t737 - 0.3e1 / 0.8e1 * t6 * t28 * t801);
  tv2rhosigma0 = t7 * t806 + t332;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t813 = t6 * t228 * t352 / 0.8e1;
  t815 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t352 - t813);
  tv2rhosigma2 = t7 * t815 + t356;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t821 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t328 - t737);
  tv2rhosigma3 = t7 * t821 + t332;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t826 = t646 * t100;
  t828 = 0.1e1 / t101 / t826;
  t830 = t57 * t828 * sigma[2];
  t832 = 0.25e2 / 0.177147e6 * t643 * t830;
  t833 = t34 * t263;
  t835 = 0.1e2 / 0.729e3 * t258 * t833;
  t836 = t141 * t118;
  t837 = t658 * t836;
  t838 = t104 * t274;
  t839 = t750 * t838;
  t840 = t837 * t839;
  t842 = t104 * t290;
  t843 = t459 * t842;
  t844 = t668 * t843;
  t846 = t673 * t337;
  t848 = t274 * t54;
  t849 = t848 * t336;
  t850 = t268 * t849;
  t852 = t57 * t263;
  t853 = t269 * t852;
  t854 = t268 * t853;
  t856 = t666 * t346;
  t862 = t299 * t345;
  t864 = t699 * t838;
  t866 = t282 * t263;
  t869 = t704 * t342 * t274;
  t871 = t72 * t263;
  t872 = t286 * t871;
  t874 = -0.125e3 / 0.162e3 * t864 + 0.25e3 / 0.243e3 * t866 - 0.78125e5 / 0.19683e5 * t869 + 0.125e6 / 0.59049e5 * t872;
  t875 = t141 * t874;
  t877 = t267 * t350;
  t886 = 0.25e2 / 0.177147e6 * t717 * t830 - 0.1e2 / 0.729e3 * t295 * t833 - t832 + t835;
  t888 = t832 - t835 - 0.125e4 / 0.729e3 * t840 - 0.25e2 / 0.108e3 * t844 + 0.25e2 / 0.108e3 * t846 + 0.25e2 / 0.108e3 * t850 - 0.5e2 / 0.81e2 * t854 + 0.5e2 / 0.27e2 * t856 * t276 + 0.2e1 * t691 * t346 * t290 - t281 * t862 - t281 * t875 - 0.5e2 / 0.27e2 * t877 * t276 - t281 * t350 * t290 + t135 * t886;
  t893 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t352 - t813 - 0.3e1 / 0.8e1 * t6 * t99 * t888);
  tv2rhosigma5 = t7 * t893 + t356;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t900 = t6 * t162 * t369 / 0.8e1;
  t901 = t49 * t185;
  t902 = t750 * t901;
  t905 = t49 * t201;
  t906 = t459 * t905;
  t911 = t761 * t357;
  t915 = t456 * t367;
  t921 = t210 * t366;
  t930 = 0.5e3 / 0.81e2 * t490 * t901 - 0.125e4 / 0.243e3 * t316 + 0.625e6 / 0.19683e5 * t495 * t363 * t185 - 0.625e6 / 0.59049e5 * t319;
  t931 = t83 * t930;
  t933 = 0.1e5 / 0.729e3 * t749 * t902 + 0.5e2 / 0.27e2 * t458 * t906 - 0.5e2 / 0.27e2 * t464 * t358 - 0.5e2 / 0.27e2 * t179 * t911 + 0.25e3 / 0.81e2 * t314 + 0.5e2 / 0.27e2 * t915 * t187 + 0.2e1 * t482 * t367 * t201 - t192 * t921 - t192 * t931;
  t938 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t369 - t900 - 0.3e1 / 0.8e1 * t6 * t28 * t933);
  tv2rhotau0 = t7 * t938 + t373;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t945 = t6 * t228 * t386 / 0.8e1;
  t947 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t386 - t945);
  tv2rhotau1 = t7 * t947 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t953 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t369 - t900);
  tv2rhotau2 = t7 * t953 + t373;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t958 = t114 * t274;
  t959 = t750 * t958;
  t962 = t114 * t290;
  t963 = t459 * t962;
  t968 = t848 * t374;
  t972 = t666 * t384;
  t978 = t299 * t383;
  t987 = 0.5e3 / 0.81e2 * t699 * t958 - 0.125e4 / 0.243e3 * t340 + 0.625e6 / 0.19683e5 * t704 * t380 * t274 - 0.625e6 / 0.59049e5 * t343;
  t988 = t141 * t987;
  t990 = 0.1e5 / 0.729e3 * t837 * t959 + 0.5e2 / 0.27e2 * t668 * t963 - 0.5e2 / 0.27e2 * t673 * t375 - 0.5e2 / 0.27e2 * t268 * t968 + 0.25e3 / 0.81e2 * t338 + 0.5e2 / 0.27e2 * t972 * t276 + 0.2e1 * t691 * t384 * t290 - t281 * t978 - t281 * t988;
  t995 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t386 - t945 - 0.3e1 / 0.8e1 * t6 * t99 * t990);
  tv2rhotau3 = t7 * t995 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t997 = t434 * rho[0];
  t999 = 0.1e1 / t36 / t997;
  t1000 = t459 * t999;
  t1001 = t430 * t1000;
  t1003 = t450 * t999;
  t1004 = t448 * t1003;
  t1005 = t447 * t1004;
  t1007 = t39 * t321;
  t1008 = t459 * t1007;
  t1009 = t458 * t1008;
  t1011 = t790 * t313;
  t1013 = t179 * t1000;
  t1015 = t321 * t321;
  t1016 = t83 * t1015;
  t1019 = t326 * t321;
  t1022 = t490 * t999;
  t1024 = t72 * t999;
  t1025 = t495 * t1024;
  t1027 = 0.125e3 / 0.1296e4 * t1022 + 0.78125e5 / 0.157464e6 * t1025;
  t1028 = t83 * t1027;
  t1032 = -0.25e2 / 0.472392e6 * t507 * t1000 + 0.25e2 / 0.472392e6 * t1001;
  t1034 = -0.25e2 / 0.472392e6 * t1001 + 0.625e3 / 0.2916e4 * t1005 - 0.25e2 / 0.54e2 * t1009 + 0.25e2 / 0.54e2 * t1011 - 0.25e2 / 0.864e3 * t1013 + 0.2e1 * t482 * t1016 - 0.2e1 * t192 * t1019 - t192 * t1028 + t77 * t1032;
  t1038 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1034);
  tv2sigma20 = t7 * t1038;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1039 = t646 * rho[1];
  t1041 = 0.1e1 / t101 / t1039;
  t1042 = t459 * t1041;
  t1043 = t642 * t1042;
  t1045 = t450 * t1041;
  t1046 = t660 * t1045;
  t1047 = t659 * t1046;
  t1049 = t104 * t345;
  t1050 = t459 * t1049;
  t1051 = t668 * t1050;
  t1053 = t877 * t337;
  t1055 = t268 * t1042;
  t1057 = t345 * t345;
  t1058 = t141 * t1057;
  t1061 = t350 * t345;
  t1064 = t699 * t1041;
  t1066 = t72 * t1041;
  t1067 = t704 * t1066;
  t1069 = 0.125e3 / 0.1296e4 * t1064 + 0.78125e5 / 0.157464e6 * t1067;
  t1070 = t141 * t1069;
  t1074 = -0.25e2 / 0.472392e6 * t716 * t1042 + 0.25e2 / 0.472392e6 * t1043;
  t1076 = -0.25e2 / 0.472392e6 * t1043 + 0.625e3 / 0.2916e4 * t1047 - 0.25e2 / 0.54e2 * t1051 + 0.25e2 / 0.54e2 * t1053 - 0.25e2 / 0.864e3 * t1055 + 0.2e1 * t691 * t1058 - 0.2e1 * t281 * t1061 - t281 * t1070 + t135 * t1074;
  t1080 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1076);
  tv2sigma25 = t7 * t1080;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1082 = 0.1e1 / t36 / t434;
  t1083 = t450 * t1082;
  t1084 = t448 * t1083;
  t1085 = t447 * t1084;
  t1087 = t49 * t321;
  t1088 = t459 * t1087;
  t1093 = t1082 * t54;
  t1094 = t1093 * t57;
  t1095 = t179 * t1094;
  t1097 = t915 * t313;
  t1099 = t367 * t321;
  t1102 = t326 * t366;
  t1104 = t490 * t1082;
  t1106 = t72 * t1082;
  t1107 = t495 * t1106;
  t1109 = -0.125e3 / 0.162e3 * t1104 - 0.78125e5 / 0.19683e5 * t1107;
  t1110 = t83 * t1109;
  t1112 = -0.125e4 / 0.729e3 * t1085 + 0.5e2 / 0.27e2 * t458 * t1088 - 0.5e2 / 0.27e2 * t790 * t358 + 0.25e2 / 0.108e3 * t1095 - 0.25e2 / 0.108e3 * t1097 + 0.2e1 * t482 * t1099 - t192 * t1102 - t192 * t1110;
  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1112);
  tv2sigmatau0 = t7 * t1116;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1118 = 0.1e1 / t101 / t646;
  t1119 = t450 * t1118;
  t1120 = t660 * t1119;
  t1121 = t659 * t1120;
  t1123 = t114 * t345;
  t1124 = t459 * t1123;
  t1129 = t1118 * t54;
  t1130 = t1129 * t57;
  t1131 = t268 * t1130;
  t1133 = t972 * t337;
  t1135 = t384 * t345;
  t1138 = t350 * t383;
  t1140 = t699 * t1118;
  t1142 = t72 * t1118;
  t1143 = t704 * t1142;
  t1145 = -0.125e3 / 0.162e3 * t1140 - 0.78125e5 / 0.19683e5 * t1143;
  t1146 = t141 * t1145;
  t1148 = -0.125e4 / 0.729e3 * t1121 + 0.5e2 / 0.27e2 * t668 * t1124 - 0.5e2 / 0.27e2 * t877 * t375 + 0.25e2 / 0.108e3 * t1131 - 0.25e2 / 0.108e3 * t1133 + 0.2e1 * t691 * t1135 - t281 * t1138 - t281 * t1146;
  t1152 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1148);
  tv2sigmatau5 = t7 * t1152;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1154 = 0.1e1 / t36 / t172;
  t1155 = t450 * t1154;
  t1156 = t448 * t1155;
  t1159 = t49 * t366;
  t1160 = t459 * t1159;
  t1163 = t1154 * t54;
  t1164 = t1163 * t57;
  t1167 = t366 * t366;
  t1168 = t83 * t1167;
  t1173 = t72 * t1154;
  t1176 = 0.5e3 / 0.81e2 * t490 * t1154 + 0.625e6 / 0.19683e5 * t495 * t1173;
  t1177 = t83 * t1176;
  t1179 = 0.1e5 / 0.729e3 * t447 * t1156 + 0.1e3 / 0.27e2 * t458 * t1160 - 0.5e2 / 0.27e2 * t179 * t1164 + 0.2e1 * t482 * t1168 - t192 * t1177;
  t1183 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1179);
  tv2tau20 = t7 * t1183;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1185 = 0.1e1 / t101 / t261;
  t1186 = t450 * t1185;
  t1187 = t660 * t1186;
  t1190 = t114 * t383;
  t1191 = t459 * t1190;
  t1194 = t1185 * t54;
  t1195 = t1194 * t57;
  t1198 = t383 * t383;
  t1199 = t141 * t1198;
  t1204 = t72 * t1185;
  t1207 = 0.5e3 / 0.81e2 * t699 * t1185 + 0.625e6 / 0.19683e5 * t704 * t1204;
  t1208 = t141 * t1207;
  t1210 = 0.1e5 / 0.729e3 * t659 * t1187 + 0.1e3 / 0.27e2 * t668 * t1191 - 0.5e2 / 0.27e2 * t268 * t1195 + 0.2e1 * t691 * t1199 - t281 * t1208;
  t1214 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1210);
  tv2tau22 = t7 * t1214;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t52, t53, t54, t57, t60;
  double t61, t62, t63, t64, t65, t68, t71, t72;
  double t75, t76, t77, t78, t83, t85, t89, t90;
  double t91, t93, t94, t95, t96, t98, t99, t100;
  double t101, t102, t104, t105, t107, t108, t112, t114;
  double t117, t118, t122, t123, t124, t125, t128, t133;
  double t134, t135, t136, t141, t143, t147, tzk0;

  double t148, t149, t150, t152, t155, t156, t160, t161;
  double t162, t165, t166, t167, t169, t170, t171, t172;
  double t174, t175, t176, t178, t179, t180, t185, t186;
  double t187, t190, t191, t192, t193, t197, t198, t201;
  double t202, t204, t206, t207, t210, t212, t217, t218;
  double t220, t223, t224, t228, t231, t233, tvrho0, t237;
  double t240, t241, t246, t248, t251, t252, t256, t258;
  double t259, t260, t261, t263, t264, t265, t267, t268;
  double t269, t274, t275, t276, t279, t280, t281, t282;
  double t286, t287, t290, t291, t293, t295, t296, t299;
  double t301, t306, tvrho1, t309, t310, t312, t313, t314;
  double t316, t318, t319, t321, t322, t326, t328, t332;
  double tvsigma0, tvsigma1, t333, t334, t336, t337, t338, t340;
  double t342, t343, t345, t346, t350, t352, t356, tvsigma2;
  double tvlapl0, tvlapl1, t357, t358, t363, t366, t367, t369;
  double t373, tvtau0, t374, t375, t380, t383, t384, t386;
  double t390, tvtau1;

  double t393, t394, t395, t398, t399, t400, t403, t407;
  double t408, t412, t414, t420, t421, t424, t426, t430;
  double t431, t432, t433, t434, t435, t437, t438, t440;
  double t442, t443, t445, t446, t447, t448, t450, t451;
  double t452, t453, t456, t457, t458, t459, t460, t461;
  double t464, t467, t468, t475, t476, t477, t481, t482;
  double t483, t484, t487, t490, t495, t496, t502, t507;
  double t508, t513, t515, t520, t521, t522, t523, t526;
  double t529, t533, t534, t538, t540, t542, t545, t547;
  double tv2rho20, t550, t554, t558, t559, t563, t565, t573;
  double t574, t578, t582, t583, t587, t589, t596, t599;
  double tv2rho21, t604, t609, t613, t614, t620, t621, t626;
  double t630, t631, t642, t643, t644, t645, t646, t647;
  double t649, t650, t652, t654, t655, t657, t658, t659;
  double t660, t661, t662, t663, t666, t667, t668, t669;
  double t670, t673, t676, t677, t684, t685, t686, t690;
  double t691, t692, t693, t696, t699, t704, t705, t711;
  double t716, t717, t722, t724, t729, tv2rho22, t737, t738;
  double t740, t742, t744, t745, t747, t748, t749, t750;
  double t751, t752, t753, t755, t756, t757, t759, t761;
  double t762, t763, t765, t766, t767, t769, t775, t777;
  double t779, t782, t784, t785, t787, t788, t790, t799;
  double t801, t806, tv2rhosigma0, tv2rhosigma1, t813, t815, tv2rhosigma2, t821;
  double tv2rhosigma3, tv2rhosigma4, t826, t828, t830, t832, t833, t835;
  double t836, t837, t838, t839, t840, t842, t843, t844;
  double t846, t848, t849, t850, t852, t853, t854, t856;
  double t862, t864, t866, t869, t871, t872, t874, t875;
  double t877, t886, t888, t893, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2;
  double tv2rholapl3, t900, t901, t902, t905, t906, t911, t915;
  double t921, t930, t931, t933, t938, tv2rhotau0, t945, t947;
  double tv2rhotau1, t953, tv2rhotau2, t958, t959, t962, t963, t968;
  double t972, t978, t987, t988, t990, t995, tv2rhotau3, t997;
  double t999, t1000, t1001, t1003, t1004, t1005, t1007, t1008;
  double t1009, t1011, t1013, t1015, t1016, t1019, t1022, t1024;
  double t1025, t1027, t1028, t1032, t1034, t1038, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t1039, t1041, t1042, t1043, t1045;
  double t1046, t1047, t1049, t1050, t1051, t1053, t1055, t1057;
  double t1058, t1061, t1064, t1066, t1067, t1069, t1070, t1074;
  double t1076, t1080, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double tv2sigmalapl5, t1082, t1083, t1084, t1085, t1087, t1088, t1093;
  double t1094, t1095, t1097, t1099, t1102, t1104, t1106, t1107;
  double t1109, t1110, t1112, t1116, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3;
  double tv2sigmatau4, t1118, t1119, t1120, t1121, t1123, t1124, t1129;
  double t1130, t1131, t1133, t1135, t1138, t1140, t1142, t1143;
  double t1145, t1146, t1148, t1152, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22;
  double tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1154, t1155, t1156, t1159;
  double t1160, t1163, t1164, t1167, t1168, t1173, t1176, t1177;
  double t1179, t1183, tv2tau20, tv2tau21, t1185, t1186, t1187, t1190;
  double t1191, t1194, t1195, t1198, t1199, t1204, t1207, t1208;
  double t1210, t1214, tv2tau22;

  double t1218, t1219, t1222, t1225, t1226, t1227, t1230, t1234;
  double t1235, t1239, t1241, t1246, t1248, t1251, t1257, t1258;
  double t1261, t1263, t1266, t1268, t1269, t1274, t1275, t1277;
  double t1280, t1281, t1284, t1285, t1289, t1296, t1301, t1307;
  double t1310, t1311, t1312, t1315, t1316, t1318, t1321, t1322;
  double t1323, t1326, t1327, t1330, t1332, t1333, t1334, t1335;
  double t1336, t1337, t1338, t1342, t1343, t1346, t1349, t1351;
  double t1353, t1355, t1357, t1358, t1360, t1361, t1368, t1371;
  double t1380, t1390, t1391, t1393, t1394, t1395, t1396, t1397;
  double t1400, t1405, t1406, t1411, t1413, t1414, t1417, t1420;
  double t1423, t1427, t1428, t1432, t1434, t1436, t1438, t1440;
  double t1443, t1445, tv3rho30, t1448, t1449, t1450, t1453, t1458;
  double t1459, t1461, t1465, t1466, t1470, t1473, t1477, t1479;
  double t1483, t1492, t1493, t1494, t1497, t1502, t1504, t1508;
  double t1509, t1513, t1516, t1517, t1519, t1528, t1530, t1533;
  double tv3rho31, t1536, t1541, t1545, t1549, t1550, t1554, t1556;
  double t1565, t1566, t1571, t1575, t1579, t1580, t1584, t1586;
  double t1593, t1601, t1603, t1604, tv3rho32, t1609, t1616, t1620;
  double t1621, t1628, t1629, t1636, t1640, t1641, t1656, t1657;
  double t1659, t1662, t1663, t1664, t1667, t1672, t1678, t1681;
  double t1682, t1683, t1686, t1689, t1691, t1692, t1693, t1694;
  double t1695, t1696, t1697, t1701, t1702, t1705, t1708, t1710;
  double t1712, t1714, t1716, t1717, t1719, t1724, t1729, t1739;
  double t1740, t1742, t1745, t1746, t1747, t1748, t1749, t1752;
  double t1753, t1759, t1760, t1766, t1767, t1772, t1773, t1775;
  double t1778, t1781, t1782, t1786, t1793, t1794, t1799, tv3rho33;
  double t1807, t1814, t1816, t1818, t1820, t1824, t1825, t1827;
  double t1829, t1831, t1832, t1833, t1835, t1840, t1843, t1845;
  double t1846, t1849, t1850, t1851, t1853, t1855, t1856, t1860;
  double t1863, t1867, t1869, t1871, t1872, t1874, t1876, t1879;
  double t1880, t1882, t1883, t1885, t1886, t1888, t1891, t1894;
  double t1897, t1899, t1900, t1902, t1903, t1905, t1908, t1911;
  double t1916, t1929, t1930, t1931, t1932, t1935, t1938, t1939;
  double t1940, t1942, t1943, t1944, t1945, t1947, t1948, t1952;
  double t1953, t1955, t1956, t1957, t1959, t1960, t1962, t1964;
  double t1965, t1966, t1969, t1970, t1972, t1975, t1980, t1983;
  double t1984, t1987, t1989, t1994, tv3rho2sigma0, tv3rho2sigma1, t2001, t2005;
  double t2007, tv3rho2sigma2, t2013, t2021, tv3rho2sigma3, tv3rho2sigma4, t2027, t2034;
  double t2037, tv3rho2sigma5, t2045, tv3rho2sigma6, tv3rho2sigma7, t2057, t2058, t2060;
  double t2062, t2065, t2068, t2069, t2071, t2072, t2074, t2075;
  double t2077, t2080, t2083, t2086, t2088, t2089, t2091, t2092;
  double t2094, t2097, t2099, t2102, t2104, t2106, t2107, t2111;
  double t2114, t2118, t2120, t2122, t2123, t2138, t2139, t2140;
  double t2141, t2146, t2149, t2151, t2153, t2155, t2156, t2157;
  double t2159, t2164, t2167, t2169, t2170, t2172, t2173, t2174;
  double t2176, t2177, t2178, t2179, t2181, t2182, t2185, t2186;
  double t2190, t2191, t2193, t2194, t2195, t2197, t2198, t2200;
  double t2202, t2203, t2204, t2207, t2208, t2210, t2213, t2218;
  double t2221, t2222, t2225, t2227, t2232, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1;
  double tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2239, t2246, t2248, t2252;
  double t2256, t2265, t2277, t2278, t2280, t2282, t2297, t2300;
  double t2302, t2309, t2312, t2313, t2317, t2322, t2330, t2333;
  double t2336, t2341, t2344, t2345, t2350, tv3rho2tau0, t2357, t2361;
  double t2363, tv3rho2tau1, t2369, t2377, tv3rho2tau2, t2383, t2390, t2393;
  double tv3rho2tau3, t2401, tv3rho2tau4, t2414, t2418, t2424, t2426, t2432;
  double t2444, t2445, t2459, t2462, t2467, t2471, t2474, t2475;
  double t2479, t2484, t2489, t2497, t2500, t2503, t2506, t2507;
  double t2512, tv3rho2tau5, t2519, t2520, t2523, t2525, t2526, t2528;
  double t2531, t2533, t2534, t2536, t2537, t2539, t2541, t2544;
  double t2548, t2549, t2552, t2553, t2555, t2556, t2557, t2558;
  double t2561, t2565, t2567, t2568, t2582, t2584, t2585, t2586;
  double t2588, t2590, t2591, t2594, t2595, t2597, t2598, t2599;
  double t2601, t2604, t2606, t2608, t2610, t2611, t2612, t2614;
  double t2616, t2618, t2619, t2620, t2622, t2624, t2625, t2626;
  double t2628, t2631, t2634, t2637, t2639, t2641, t2642, t2643;
  double t2645, t2646, t2651, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2658, t2660, tv3rhosigma25, t2666, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2671, t2672, t2673, t2674, t2677, t2681, t2683;
  double t2684, t2686, t2689, t2692, t2694, t2695, t2697, t2700;
  double t2702, t2703, t2705, t2706, t2708, t2710, t2714, t2715;
  double t2718, t2719, t2733, t2735, t2737, t2738, t2739, t2741;
  double t2742, t2744, t2745, t2746, t2748, t2752, t2753, t2755;
  double t2757, t2759, t2761, t2764, t2767, t2768, t2769, t2772;
  double t2773, t2775, t2777, t2779, t2780, t2781, t2783, t2785;
  double t2786, t2787, t2789, t2792, t2793, t2794, t2796, t2797;
  double t2802, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5;
  double tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t2809, t2810;
  double t2812, t2814, t2818, t2821, t2822, t2824, t2828, t2832;
  double t2835, t2836, t2837, t2839, t2841, t2842, t2844, t2845;
  double t2846, t2866, t2867, t2869, t2871, t2872, t2873, t2874;
  double t2877, t2878, t2880, t2891, t2892, t2899, t2901, t2903;
  double t2905, t2908, t2911, t2912, t2913, t2916, t2917, t2919;
  double t2921, t2922, t2927, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4;
  double t2934, t2936, tv3rhosigmatau5, t2942, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9;
  double tv3rhosigmatau10, t2948, t2949, t2950, t2952, t2954, t2955, t2957;
  double t2958, t2959, t2963, t2967, t2987, t2988, t2990, t2992;
  double t2993, t2994, t3001, t3002, t3004, t3005, t3008, t3010;
  double t3012, t3014, t3018, t3021, t3022, t3024, t3026, t3028;
  double t3030, t3033, t3036, t3037, t3038, t3042, t3048, t3049;
  double t3056, t3058, t3059, t3064, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22;
  double tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t3071, t3072, t3075, t3076, t3082;
  double t3087, t3091, t3099, t3100, t3103, t3104, t3110, t3116;
  double t3122, t3128, t3137, t3138, t3140, t3141, t3146, tv3rhotau20;
  double tv3rhotau21, t3153, t3155, tv3rhotau22, t3161, tv3rhotau23, tv3rhotau24, t3166;
  double t3169, t3170, t3176, t3181, t3185, t3193, t3194, t3197;
  double t3198, t3204, t3210, t3216, t3222, t3231, t3232, t3234;
  double t3235, t3240, tv3rhotau25, t3242, t3243, t3245, t3247, t3249;
  double t3251, t3253, t3255, t3256, t3263, t3266, t3269, t3273;
  double t3274, t3276, t3277, t3279, t3280, t3281, t3283, t3285;
  double t3286, t3287, t3289, t3290, t3291, t3293, t3295, t3296;
  double t3297, t3299, t3300, t3301, t3303, t3305, t3309, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t3310, t3311, t3313, t3315, t3316, t3322, t3323, t3325;
  double t3328, t3331, t3335, t3336, t3338, t3339, t3343, t3345;
  double t3347, t3348, t3349, t3351, t3353, t3354, t3355, t3357;
  double t3358, t3359, t3361, t3363, t3364, t3365, t3367, t3368;
  double t3369, t3371, t3373, t3377, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double tv3sigma2lapl11, t3378, t3383, t3384, t3386, t3397, t3400, t3402;
  double t3403, t3405, t3406, t3408, t3410, t3412, t3414, t3415;
  double t3417, t3418, t3419, t3423, t3424, t3427, t3428, t3429;
  double t3431, t3432, t3435, t3436, t3437, t3439, t3441, t3442;
  double t3443, t3445, t3446, t3450, t3451, t3455, tv3sigma2tau0, tv3sigma2tau1;
  double tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9;
  double tv3sigma2tau10, t3458, t3459, t3462, t3464, t3466, t3468, t3469;
  double t3470, t3472, t3473, t3476, t3477, t3478, t3483, t3488;
  double t3492, t3493, t3495, t3500, t3502, t3505, t3507, t3508;
  double t3510, t3511, t3513, t3515, t3516, t3517, t3519, t3520;
  double t3524, t3525, t3526, t3528, t3529, t3533, tv3sigma2tau11, tv3sigmalapl20;
  double tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t3534, t3535, t3537, t3539;
  double t3540, t3545, t3546, t3547, t3549, t3550, t3551, t3554;
  double t3559, t3560, t3561, t3563, t3564, t3567, t3572, t3577;
  double t3583, t3588, t3590, t3592, t3593, t3595, t3596, t3598;
  double t3602, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26;
  double tv3sigmatau27, t3603, t3604, t3606, t3608, t3609, t3614, t3615;
  double t3616, t3618, t3619, t3620, t3623, t3628, t3629, t3630;
  double t3632, t3633, t3636, t3641, t3646, t3652, t3657, t3659;
  double t3661, t3662, t3664, t3665, t3667, t3671, tv3sigmatau28, tv3lapl30;
  double tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t3672;
  double t3673, t3677, t3678, t3681, t3682, t3685, t3686, t3689;
  double t3692, t3693, t3696, t3697, t3705, t3708, t3709, t3711;
  double t3715, tv3tau30, tv3tau31, tv3tau32, t3716, t3717, t3721, t3722;
  double t3725, t3726, t3729, t3730, t3733, t3736, t3737, t3740;
  double t3741, t3749, t3752, t3753, t3755, t3759, tv3tau33;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t52 = tau[0] * t49 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t57 = 0.1e1 / t31 / t30;
  t60 = 0.1e1 - 0.25e2 / 0.81e2 * t53 * t54 * t57;
  t61 = t60 * t60;
  t62 = t61 * t60;
  t63 = t53 * t52;
  t64 = t30 * t30;
  t65 = 0.1e1 / t64;
  t68 = t53 * t53;
  t71 = t64 * t64;
  t72 = 0.1e1 / t71;
  t75 = 0.1e1 + 0.25e3 / 0.243e3 * t63 * t65 + 0.625e5 / 0.59049e5 * params->b * t68 * t53 * t72;
  t76 = 0.1e1 / t75;
  t77 = t62 * t76;
  t78 = params->kappa + t42 + params->c;
  t83 = params->kappa * (0.1e1 - params->kappa / t78) - t47;
  t85 = t77 * t83 + t47 + 0.1e1;
  t89 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t85);
  t90 = rho[1] <= p->dens_threshold;
  t91 = -t17;
  t93 = my_piecewise5(t15, t12, t11, t16, t91 * t8);
  t94 = 0.1e1 + t93;
  t95 = t94 <= p->zeta_threshold;
  t96 = POW_1_3(t94);
  t98 = my_piecewise3(t95, t23, t96 * t94);
  t99 = t98 * t27;
  t100 = rho[1] * rho[1];
  t101 = POW_1_3(rho[1]);
  t102 = t101 * t101;
  t104 = 0.1e1 / t102 / t100;
  t105 = sigma[2] * t104;
  t107 = 0.5e1 / 0.972e3 * t34 * t105;
  t108 = params->kappa + t107;
  t112 = params->kappa * (0.1e1 - params->kappa / t108);
  t114 = 0.1e1 / t102 / rho[1];
  t117 = tau[1] * t114 - t105 / 0.8e1;
  t118 = t117 * t117;
  t122 = 0.1e1 - 0.25e2 / 0.81e2 * t118 * t54 * t57;
  t123 = t122 * t122;
  t124 = t123 * t122;
  t125 = t118 * t117;
  t128 = t118 * t118;
  t133 = 0.1e1 + 0.25e3 / 0.243e3 * t125 * t65 + 0.625e5 / 0.59049e5 * params->b * t128 * t118 * t72;
  t134 = 0.1e1 / t133;
  t135 = t124 * t134;
  t136 = params->kappa + t107 + params->c;
  t141 = params->kappa * (0.1e1 - params->kappa / t136) - t112;
  t143 = t135 * t141 + t112 + 0.1e1;
  t147 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t143);
  tzk0 = t89 + t147;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t148 = t7 * t7;
  t149 = 0.1e1 / t148;
  t150 = t17 * t149;
  t152 = my_piecewise5(t11, 0, t15, 0, t8 - t150);
  t155 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t152);
  t156 = t155 * t27;
  t160 = t27 * t27;
  t161 = 0.1e1 / t160;
  t162 = t26 * t161;
  t165 = t6 * t162 * t85 / 0.8e1;
  t166 = params->kappa * params->kappa;
  t167 = t43 * t43;
  t169 = t166 / t167;
  t170 = t169 * t29;
  t171 = t33 * sigma[0];
  t172 = t35 * rho[0];
  t174 = 0.1e1 / t37 / t172;
  t175 = t171 * t174;
  t176 = t170 * t175;
  t178 = t61 * t76;
  t179 = t178 * t83;
  t180 = t52 * t54;
  t185 = -0.5e1 / 0.3e1 * tau[0] * t39 + sigma[0] * t174 / 0.3e1;
  t186 = t57 * t185;
  t187 = t180 * t186;
  t190 = t75 * t75;
  t191 = 0.1e1 / t190;
  t192 = t62 * t191;
  t193 = t53 * t65;
  t197 = params->b * t68 * t52;
  t198 = t72 * t185;
  t201 = 0.25e3 / 0.81e2 * t193 * t185 + 0.125e6 / 0.19683e5 * t197 * t198;
  t202 = t83 * t201;
  t204 = t78 * t78;
  t206 = t166 / t204;
  t207 = t206 * t29;
  t210 = -0.1e2 / 0.729e3 * t207 * t175 + 0.1e2 / 0.729e3 * t176;
  t212 = -0.1e2 / 0.729e3 * t176 - 0.5e2 / 0.27e2 * t179 * t187 - t192 * t202 + t77 * t210;
  t217 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t85 - t165 - 0.3e1 / 0.8e1 * t6 * t28 * t212);
  t218 = t91 * t149;
  t220 = my_piecewise5(t15, 0, t11, 0, -t8 - t218);
  t223 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t220);
  t224 = t223 * t27;
  t228 = t98 * t161;
  t231 = t6 * t228 * t143 / 0.8e1;
  t233 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t143 - t231);
  tvrho0 = t89 + t147 + t7 * (t217 + t233);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t237 = my_piecewise5(t11, 0, t15, 0, -t8 - t150);
  t240 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t237);
  t241 = t240 * t27;
  t246 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t85 - t165);
  t248 = my_piecewise5(t15, 0, t11, 0, t8 - t218);
  t251 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t248);
  t252 = t251 * t27;
  t256 = t108 * t108;
  t258 = t166 / t256;
  t259 = t258 * t29;
  t260 = t33 * sigma[2];
  t261 = t100 * rho[1];
  t263 = 0.1e1 / t102 / t261;
  t264 = t260 * t263;
  t265 = t259 * t264;
  t267 = t123 * t134;
  t268 = t267 * t141;
  t269 = t117 * t54;
  t274 = -0.5e1 / 0.3e1 * tau[1] * t104 + sigma[2] * t263 / 0.3e1;
  t275 = t57 * t274;
  t276 = t269 * t275;
  t279 = t133 * t133;
  t280 = 0.1e1 / t279;
  t281 = t124 * t280;
  t282 = t118 * t65;
  t286 = params->b * t128 * t117;
  t287 = t72 * t274;
  t290 = 0.25e3 / 0.81e2 * t282 * t274 + 0.125e6 / 0.19683e5 * t286 * t287;
  t291 = t141 * t290;
  t293 = t136 * t136;
  t295 = t166 / t293;
  t296 = t295 * t29;
  t299 = -0.1e2 / 0.729e3 * t296 * t264 + 0.1e2 / 0.729e3 * t265;
  t301 = -0.1e2 / 0.729e3 * t265 - 0.5e2 / 0.27e2 * t268 * t276 - t281 * t291 + t135 * t299;
  t306 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t143 - t231 - 0.3e1 / 0.8e1 * t6 * t99 * t301);
  tvrho1 = t89 + t147 + t7 * (t246 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t309 = t34 * t39;
  t310 = t169 * t309;
  t312 = t57 * t39;
  t313 = t180 * t312;
  t314 = t179 * t313;
  t316 = t193 * t39;
  t318 = t72 * t39;
  t319 = t197 * t318;
  t321 = -0.125e3 / 0.324e3 * t316 - 0.15625e5 / 0.19683e5 * t319;
  t322 = t83 * t321;
  t326 = 0.5e1 / 0.972e3 * t206 * t309 - 0.5e1 / 0.972e3 * t310;
  t328 = 0.5e1 / 0.972e3 * t310 + 0.25e2 / 0.108e3 * t314 - t192 * t322 + t77 * t326;
  t332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t328);
  tvsigma0 = t7 * t332;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t333 = t34 * t104;
  t334 = t258 * t333;
  t336 = t57 * t104;
  t337 = t269 * t336;
  t338 = t268 * t337;
  t340 = t282 * t104;
  t342 = t72 * t104;
  t343 = t286 * t342;
  t345 = -0.125e3 / 0.324e3 * t340 - 0.15625e5 / 0.19683e5 * t343;
  t346 = t141 * t345;
  t350 = 0.5e1 / 0.972e3 * t295 * t333 - 0.5e1 / 0.972e3 * t334;
  t352 = 0.5e1 / 0.972e3 * t334 + 0.25e2 / 0.108e3 * t338 - t281 * t346 + t135 * t350;
  t356 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t352);
  tvsigma2 = t7 * t356;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t357 = t57 * t49;
  t358 = t180 * t357;
  t363 = t72 * t49;
  t366 = 0.25e3 / 0.81e2 * t193 * t49 + 0.125e6 / 0.19683e5 * t197 * t363;
  t367 = t83 * t366;
  t369 = -0.5e2 / 0.27e2 * t179 * t358 - t192 * t367;
  t373 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t369);
  tvtau0 = t7 * t373;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t374 = t57 * t114;
  t375 = t269 * t374;
  t380 = t72 * t114;
  t383 = 0.25e3 / 0.81e2 * t282 * t114 + 0.125e6 / 0.19683e5 * t286 * t380;
  t384 = t141 * t383;
  t386 = -0.5e2 / 0.27e2 * t268 * t375 - t281 * t384;
  t390 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t386);
  tvtau1 = t7 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t393 = t24 * t24;
  t394 = 0.1e1 / t393;
  t395 = t152 * t152;
  t398 = t148 * t7;
  t399 = 0.1e1 / t398;
  t400 = t17 * t399;
  t403 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t149 + 0.2e1 * t400);
  t407 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t394 * t395 + 0.4e1 / 0.3e1 * t24 * t403);
  t408 = t407 * t27;
  t412 = t155 * t161;
  t414 = t6 * t412 * t85;
  t420 = 0.1e1 / t160 / t7;
  t421 = t26 * t420;
  t424 = t6 * t421 * t85 / 0.12e2;
  t426 = t6 * t162 * t212;
  t430 = t166 / t167 / t43;
  t431 = t430 * t54;
  t432 = sigma[0] * sigma[0];
  t433 = t57 * t432;
  t434 = t35 * t35;
  t435 = t434 * t172;
  t437 = 0.1e1 / t36 / t435;
  t438 = t433 * t437;
  t440 = 0.2e3 / 0.531441e6 * t431 * t438;
  t442 = 0.1e1 / t37 / t434;
  t443 = t171 * t442;
  t445 = 0.11e3 / 0.2187e4 * t170 * t443;
  t446 = t60 * t76;
  t447 = t446 * t83;
  t448 = t53 * t29;
  t450 = 0.1e1 / t32 / t64;
  t451 = t185 * t185;
  t452 = t450 * t451;
  t453 = t448 * t452;
  t456 = t61 * t191;
  t457 = t83 * t52;
  t458 = t456 * t457;
  t459 = t54 * t57;
  t460 = t185 * t201;
  t461 = t459 * t460;
  t464 = t178 * t210;
  t467 = t451 * t54;
  t468 = t467 * t57;
  t475 = 0.4e2 / 0.9e1 * tau[0] * t174 - 0.11e2 / 0.9e1 * sigma[0] * t442;
  t476 = t57 * t475;
  t477 = t180 * t476;
  t481 = 0.1e1 / t190 / t75;
  t482 = t62 * t481;
  t483 = t201 * t201;
  t484 = t83 * t483;
  t487 = t210 * t201;
  t490 = t52 * t65;
  t495 = params->b * t68;
  t496 = t72 * t451;
  t502 = 0.5e3 / 0.81e2 * t490 * t451 + 0.25e3 / 0.81e2 * t193 * t475 + 0.625e6 / 0.19683e5 * t495 * t496 + 0.125e6 / 0.19683e5 * t197 * t72 * t475;
  t507 = t166 / t204 / t78;
  t508 = t507 * t54;
  t513 = -0.2e3 / 0.531441e6 * t508 * t438 + 0.11e3 / 0.2187e4 * t207 * t443 + t440 - t445;
  t515 = -t440 + t445 + 0.1e5 / 0.729e3 * t447 * t453 + 0.1e3 / 0.27e2 * t458 * t461 - 0.1e3 / 0.27e2 * t464 * t187 - 0.5e2 / 0.27e2 * t179 * t468 - 0.5e2 / 0.27e2 * t179 * t477 + 0.2e1 * t482 * t484 - 0.2e1 * t192 * t487 - t192 * t83 * t502 + t77 * t513;
  t520 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t85 - t414 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t212 + t424 - t426 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t515);
  t521 = t96 * t96;
  t522 = 0.1e1 / t521;
  t523 = t220 * t220;
  t526 = t91 * t399;
  t529 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t149 + 0.2e1 * t526);
  t533 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t522 * t523 + 0.4e1 / 0.3e1 * t96 * t529);
  t534 = t533 * t27;
  t538 = t223 * t161;
  t540 = t6 * t538 * t143;
  t542 = t98 * t420;
  t545 = t6 * t542 * t143 / 0.12e2;
  t547 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t143 - t540 / 0.4e1 + t545);
  tv2rho20 = 0.2e1 * t217 + 0.2e1 * t233 + t7 * (t520 + t547);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t550 = t394 * t237;
  t554 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t400);
  t558 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t550 * t152 + 0.4e1 / 0.3e1 * t24 * t554);
  t559 = t558 * t27;
  t563 = t240 * t161;
  t565 = t6 * t563 * t85;
  t573 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t85 - t565 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t212 - t414 / 0.8e1 + t424 - t426 / 0.8e1);
  t574 = t522 * t248;
  t578 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t526);
  t582 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t574 * t220 + 0.4e1 / 0.3e1 * t96 * t578);
  t583 = t582 * t27;
  t587 = t251 * t161;
  t589 = t6 * t587 * t143;
  t596 = t6 * t228 * t301;
  t599 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t143 - t589 / 0.8e1 - t540 / 0.8e1 + t545 - 0.3e1 / 0.8e1 * t6 * t224 * t301 - t596 / 0.8e1);
  tv2rho21 = t217 + t233 + t246 + t306 + t7 * (t573 + t599);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t604 = t237 * t237;
  t609 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t149 + 0.2e1 * t400);
  t613 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t394 * t604 + 0.4e1 / 0.3e1 * t24 * t609);
  t614 = t613 * t27;
  t620 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t85 - t565 / 0.4e1 + t424);
  t621 = t248 * t248;
  t626 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t149 + 0.2e1 * t526);
  t630 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t522 * t621 + 0.4e1 / 0.3e1 * t96 * t626);
  t631 = t630 * t27;
  t642 = t166 / t256 / t108;
  t643 = t642 * t54;
  t644 = sigma[2] * sigma[2];
  t645 = t57 * t644;
  t646 = t100 * t100;
  t647 = t646 * t261;
  t649 = 0.1e1 / t101 / t647;
  t650 = t645 * t649;
  t652 = 0.2e3 / 0.531441e6 * t643 * t650;
  t654 = 0.1e1 / t102 / t646;
  t655 = t260 * t654;
  t657 = 0.11e3 / 0.2187e4 * t259 * t655;
  t658 = t122 * t134;
  t659 = t658 * t141;
  t660 = t118 * t29;
  t661 = t274 * t274;
  t662 = t450 * t661;
  t663 = t660 * t662;
  t666 = t123 * t280;
  t667 = t141 * t117;
  t668 = t666 * t667;
  t669 = t274 * t290;
  t670 = t459 * t669;
  t673 = t267 * t299;
  t676 = t661 * t54;
  t677 = t676 * t57;
  t684 = 0.4e2 / 0.9e1 * tau[1] * t263 - 0.11e2 / 0.9e1 * sigma[2] * t654;
  t685 = t57 * t684;
  t686 = t269 * t685;
  t690 = 0.1e1 / t279 / t133;
  t691 = t124 * t690;
  t692 = t290 * t290;
  t693 = t141 * t692;
  t696 = t299 * t290;
  t699 = t117 * t65;
  t704 = params->b * t128;
  t705 = t72 * t661;
  t711 = 0.5e3 / 0.81e2 * t699 * t661 + 0.25e3 / 0.81e2 * t282 * t684 + 0.625e6 / 0.19683e5 * t704 * t705 + 0.125e6 / 0.19683e5 * t286 * t72 * t684;
  t716 = t166 / t293 / t136;
  t717 = t716 * t54;
  t722 = -0.2e3 / 0.531441e6 * t717 * t650 + 0.11e3 / 0.2187e4 * t296 * t655 + t652 - t657;
  t724 = -t652 + t657 + 0.1e5 / 0.729e3 * t659 * t663 + 0.1e3 / 0.27e2 * t668 * t670 - 0.1e3 / 0.27e2 * t673 * t276 - 0.5e2 / 0.27e2 * t268 * t677 - 0.5e2 / 0.27e2 * t268 * t686 + 0.2e1 * t691 * t693 - 0.2e1 * t281 * t696 - t281 * t141 * t711 + t135 * t722;
  t729 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t143 - t589 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t301 + t545 - t596 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t724);
  tv2rho22 = 0.2e1 * t246 + 0.2e1 * t306 + t7 * (t620 + t729);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t737 = t6 * t162 * t328 / 0.8e1;
  t738 = t434 * t35;
  t740 = 0.1e1 / t36 / t738;
  t742 = t57 * t740 * sigma[0];
  t744 = 0.25e2 / 0.177147e6 * t431 * t742;
  t745 = t34 * t174;
  t747 = 0.1e2 / 0.729e3 * t169 * t745;
  t748 = t83 * t53;
  t749 = t446 * t748;
  t750 = t29 * t450;
  t751 = t39 * t185;
  t752 = t750 * t751;
  t753 = t749 * t752;
  t755 = t39 * t201;
  t756 = t459 * t755;
  t757 = t458 * t756;
  t759 = t464 * t313;
  t761 = t185 * t54;
  t762 = t761 * t312;
  t763 = t179 * t762;
  t765 = t57 * t174;
  t766 = t180 * t765;
  t767 = t179 * t766;
  t769 = t456 * t322;
  t775 = t210 * t321;
  t777 = t490 * t751;
  t779 = t193 * t174;
  t782 = t495 * t318 * t185;
  t784 = t72 * t174;
  t785 = t197 * t784;
  t787 = -0.125e3 / 0.162e3 * t777 + 0.25e3 / 0.243e3 * t779 - 0.78125e5 / 0.19683e5 * t782 + 0.125e6 / 0.59049e5 * t785;
  t788 = t83 * t787;
  t790 = t178 * t326;
  t799 = 0.25e2 / 0.177147e6 * t508 * t742 - 0.1e2 / 0.729e3 * t206 * t745 - t744 + t747;
  t801 = t744 - t747 - 0.125e4 / 0.729e3 * t753 - 0.25e2 / 0.108e3 * t757 + 0.25e2 / 0.108e3 * t759 + 0.25e2 / 0.108e3 * t763 - 0.5e2 / 0.81e2 * t767 + 0.5e2 / 0.27e2 * t769 * t187 + 0.2e1 * t482 * t322 * t201 - t192 * t775 - t192 * t788 - 0.5e2 / 0.27e2 * t790 * t187 - t192 * t326 * t201 + t77 * t799;
  t806 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t328 - t737 - 0.3e1 / 0.8e1 * t6 * t28 * t801);
  tv2rhosigma0 = t7 * t806 + t332;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t813 = t6 * t228 * t352 / 0.8e1;
  t815 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t352 - t813);
  tv2rhosigma2 = t7 * t815 + t356;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t821 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t328 - t737);
  tv2rhosigma3 = t7 * t821 + t332;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t826 = t646 * t100;
  t828 = 0.1e1 / t101 / t826;
  t830 = t57 * t828 * sigma[2];
  t832 = 0.25e2 / 0.177147e6 * t643 * t830;
  t833 = t34 * t263;
  t835 = 0.1e2 / 0.729e3 * t258 * t833;
  t836 = t141 * t118;
  t837 = t658 * t836;
  t838 = t104 * t274;
  t839 = t750 * t838;
  t840 = t837 * t839;
  t842 = t104 * t290;
  t843 = t459 * t842;
  t844 = t668 * t843;
  t846 = t673 * t337;
  t848 = t274 * t54;
  t849 = t848 * t336;
  t850 = t268 * t849;
  t852 = t57 * t263;
  t853 = t269 * t852;
  t854 = t268 * t853;
  t856 = t666 * t346;
  t862 = t299 * t345;
  t864 = t699 * t838;
  t866 = t282 * t263;
  t869 = t704 * t342 * t274;
  t871 = t72 * t263;
  t872 = t286 * t871;
  t874 = -0.125e3 / 0.162e3 * t864 + 0.25e3 / 0.243e3 * t866 - 0.78125e5 / 0.19683e5 * t869 + 0.125e6 / 0.59049e5 * t872;
  t875 = t141 * t874;
  t877 = t267 * t350;
  t886 = 0.25e2 / 0.177147e6 * t717 * t830 - 0.1e2 / 0.729e3 * t295 * t833 - t832 + t835;
  t888 = t832 - t835 - 0.125e4 / 0.729e3 * t840 - 0.25e2 / 0.108e3 * t844 + 0.25e2 / 0.108e3 * t846 + 0.25e2 / 0.108e3 * t850 - 0.5e2 / 0.81e2 * t854 + 0.5e2 / 0.27e2 * t856 * t276 + 0.2e1 * t691 * t346 * t290 - t281 * t862 - t281 * t875 - 0.5e2 / 0.27e2 * t877 * t276 - t281 * t350 * t290 + t135 * t886;
  t893 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t352 - t813 - 0.3e1 / 0.8e1 * t6 * t99 * t888);
  tv2rhosigma5 = t7 * t893 + t356;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t900 = t6 * t162 * t369 / 0.8e1;
  t901 = t49 * t185;
  t902 = t750 * t901;
  t905 = t49 * t201;
  t906 = t459 * t905;
  t911 = t761 * t357;
  t915 = t456 * t367;
  t921 = t210 * t366;
  t930 = 0.5e3 / 0.81e2 * t490 * t901 - 0.125e4 / 0.243e3 * t316 + 0.625e6 / 0.19683e5 * t495 * t363 * t185 - 0.625e6 / 0.59049e5 * t319;
  t931 = t83 * t930;
  t933 = 0.1e5 / 0.729e3 * t749 * t902 + 0.5e2 / 0.27e2 * t458 * t906 - 0.5e2 / 0.27e2 * t464 * t358 - 0.5e2 / 0.27e2 * t179 * t911 + 0.25e3 / 0.81e2 * t314 + 0.5e2 / 0.27e2 * t915 * t187 + 0.2e1 * t482 * t367 * t201 - t192 * t921 - t192 * t931;
  t938 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t369 - t900 - 0.3e1 / 0.8e1 * t6 * t28 * t933);
  tv2rhotau0 = t7 * t938 + t373;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t945 = t6 * t228 * t386 / 0.8e1;
  t947 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t386 - t945);
  tv2rhotau1 = t7 * t947 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t953 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t369 - t900);
  tv2rhotau2 = t7 * t953 + t373;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t958 = t114 * t274;
  t959 = t750 * t958;
  t962 = t114 * t290;
  t963 = t459 * t962;
  t968 = t848 * t374;
  t972 = t666 * t384;
  t978 = t299 * t383;
  t987 = 0.5e3 / 0.81e2 * t699 * t958 - 0.125e4 / 0.243e3 * t340 + 0.625e6 / 0.19683e5 * t704 * t380 * t274 - 0.625e6 / 0.59049e5 * t343;
  t988 = t141 * t987;
  t990 = 0.1e5 / 0.729e3 * t837 * t959 + 0.5e2 / 0.27e2 * t668 * t963 - 0.5e2 / 0.27e2 * t673 * t375 - 0.5e2 / 0.27e2 * t268 * t968 + 0.25e3 / 0.81e2 * t338 + 0.5e2 / 0.27e2 * t972 * t276 + 0.2e1 * t691 * t384 * t290 - t281 * t978 - t281 * t988;
  t995 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t386 - t945 - 0.3e1 / 0.8e1 * t6 * t99 * t990);
  tv2rhotau3 = t7 * t995 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t997 = t434 * rho[0];
  t999 = 0.1e1 / t36 / t997;
  t1000 = t459 * t999;
  t1001 = t430 * t1000;
  t1003 = t450 * t999;
  t1004 = t448 * t1003;
  t1005 = t447 * t1004;
  t1007 = t39 * t321;
  t1008 = t459 * t1007;
  t1009 = t458 * t1008;
  t1011 = t790 * t313;
  t1013 = t179 * t1000;
  t1015 = t321 * t321;
  t1016 = t83 * t1015;
  t1019 = t326 * t321;
  t1022 = t490 * t999;
  t1024 = t72 * t999;
  t1025 = t495 * t1024;
  t1027 = 0.125e3 / 0.1296e4 * t1022 + 0.78125e5 / 0.157464e6 * t1025;
  t1028 = t83 * t1027;
  t1032 = -0.25e2 / 0.472392e6 * t507 * t1000 + 0.25e2 / 0.472392e6 * t1001;
  t1034 = -0.25e2 / 0.472392e6 * t1001 + 0.625e3 / 0.2916e4 * t1005 - 0.25e2 / 0.54e2 * t1009 + 0.25e2 / 0.54e2 * t1011 - 0.25e2 / 0.864e3 * t1013 + 0.2e1 * t482 * t1016 - 0.2e1 * t192 * t1019 - t192 * t1028 + t77 * t1032;
  t1038 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1034);
  tv2sigma20 = t7 * t1038;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1039 = t646 * rho[1];
  t1041 = 0.1e1 / t101 / t1039;
  t1042 = t459 * t1041;
  t1043 = t642 * t1042;
  t1045 = t450 * t1041;
  t1046 = t660 * t1045;
  t1047 = t659 * t1046;
  t1049 = t104 * t345;
  t1050 = t459 * t1049;
  t1051 = t668 * t1050;
  t1053 = t877 * t337;
  t1055 = t268 * t1042;
  t1057 = t345 * t345;
  t1058 = t141 * t1057;
  t1061 = t350 * t345;
  t1064 = t699 * t1041;
  t1066 = t72 * t1041;
  t1067 = t704 * t1066;
  t1069 = 0.125e3 / 0.1296e4 * t1064 + 0.78125e5 / 0.157464e6 * t1067;
  t1070 = t141 * t1069;
  t1074 = -0.25e2 / 0.472392e6 * t716 * t1042 + 0.25e2 / 0.472392e6 * t1043;
  t1076 = -0.25e2 / 0.472392e6 * t1043 + 0.625e3 / 0.2916e4 * t1047 - 0.25e2 / 0.54e2 * t1051 + 0.25e2 / 0.54e2 * t1053 - 0.25e2 / 0.864e3 * t1055 + 0.2e1 * t691 * t1058 - 0.2e1 * t281 * t1061 - t281 * t1070 + t135 * t1074;
  t1080 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1076);
  tv2sigma25 = t7 * t1080;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1082 = 0.1e1 / t36 / t434;
  t1083 = t450 * t1082;
  t1084 = t448 * t1083;
  t1085 = t447 * t1084;
  t1087 = t49 * t321;
  t1088 = t459 * t1087;
  t1093 = t1082 * t54;
  t1094 = t1093 * t57;
  t1095 = t179 * t1094;
  t1097 = t915 * t313;
  t1099 = t367 * t321;
  t1102 = t326 * t366;
  t1104 = t490 * t1082;
  t1106 = t72 * t1082;
  t1107 = t495 * t1106;
  t1109 = -0.125e3 / 0.162e3 * t1104 - 0.78125e5 / 0.19683e5 * t1107;
  t1110 = t83 * t1109;
  t1112 = -0.125e4 / 0.729e3 * t1085 + 0.5e2 / 0.27e2 * t458 * t1088 - 0.5e2 / 0.27e2 * t790 * t358 + 0.25e2 / 0.108e3 * t1095 - 0.25e2 / 0.108e3 * t1097 + 0.2e1 * t482 * t1099 - t192 * t1102 - t192 * t1110;
  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1112);
  tv2sigmatau0 = t7 * t1116;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1118 = 0.1e1 / t101 / t646;
  t1119 = t450 * t1118;
  t1120 = t660 * t1119;
  t1121 = t659 * t1120;
  t1123 = t114 * t345;
  t1124 = t459 * t1123;
  t1129 = t1118 * t54;
  t1130 = t1129 * t57;
  t1131 = t268 * t1130;
  t1133 = t972 * t337;
  t1135 = t384 * t345;
  t1138 = t350 * t383;
  t1140 = t699 * t1118;
  t1142 = t72 * t1118;
  t1143 = t704 * t1142;
  t1145 = -0.125e3 / 0.162e3 * t1140 - 0.78125e5 / 0.19683e5 * t1143;
  t1146 = t141 * t1145;
  t1148 = -0.125e4 / 0.729e3 * t1121 + 0.5e2 / 0.27e2 * t668 * t1124 - 0.5e2 / 0.27e2 * t877 * t375 + 0.25e2 / 0.108e3 * t1131 - 0.25e2 / 0.108e3 * t1133 + 0.2e1 * t691 * t1135 - t281 * t1138 - t281 * t1146;
  t1152 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1148);
  tv2sigmatau5 = t7 * t1152;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1154 = 0.1e1 / t36 / t172;
  t1155 = t450 * t1154;
  t1156 = t448 * t1155;
  t1159 = t49 * t366;
  t1160 = t459 * t1159;
  t1163 = t1154 * t54;
  t1164 = t1163 * t57;
  t1167 = t366 * t366;
  t1168 = t83 * t1167;
  t1173 = t72 * t1154;
  t1176 = 0.5e3 / 0.81e2 * t490 * t1154 + 0.625e6 / 0.19683e5 * t495 * t1173;
  t1177 = t83 * t1176;
  t1179 = 0.1e5 / 0.729e3 * t447 * t1156 + 0.1e3 / 0.27e2 * t458 * t1160 - 0.5e2 / 0.27e2 * t179 * t1164 + 0.2e1 * t482 * t1168 - t192 * t1177;
  t1183 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1179);
  tv2tau20 = t7 * t1183;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1185 = 0.1e1 / t101 / t261;
  t1186 = t450 * t1185;
  t1187 = t660 * t1186;
  t1190 = t114 * t383;
  t1191 = t459 * t1190;
  t1194 = t1185 * t54;
  t1195 = t1194 * t57;
  t1198 = t383 * t383;
  t1199 = t141 * t1198;
  t1204 = t72 * t1185;
  t1207 = 0.5e3 / 0.81e2 * t699 * t1185 + 0.625e6 / 0.19683e5 * t704 * t1204;
  t1208 = t141 * t1207;
  t1210 = 0.1e5 / 0.729e3 * t659 * t1187 + 0.1e3 / 0.27e2 * t668 * t1191 - 0.5e2 / 0.27e2 * t268 * t1195 + 0.2e1 * t691 * t1199 - t281 * t1208;
  t1214 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1210);
  tv2tau22 = t7 * t1214;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1218 = 0.1e1 / t393 / t20;
  t1219 = t395 * t152;
  t1222 = t394 * t152;
  t1225 = t148 * t148;
  t1226 = 0.1e1 / t1225;
  t1227 = t17 * t1226;
  t1230 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t399 - 0.6e1 * t1227);
  t1234 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1218 * t1219 + 0.4e1 / 0.3e1 * t1222 * t403 + 0.4e1 / 0.3e1 * t24 * t1230);
  t1235 = t1234 * t27;
  t1239 = t407 * t161;
  t1241 = t6 * t1239 * t85;
  t1246 = t155 * t420;
  t1248 = t6 * t1246 * t85;
  t1251 = t6 * t412 * t212;
  t1257 = 0.1e1 / t160 / t148;
  t1258 = t26 * t1257;
  t1261 = 0.5e1 / 0.36e2 * t6 * t1258 * t85;
  t1263 = t6 * t421 * t212;
  t1266 = t6 * t162 * t515;
  t1268 = t61 * t481;
  t1269 = t1268 * t457;
  t1274 = t60 * t191;
  t1275 = t1274 * t748;
  t1277 = t750 * t451 * t201;
  t1280 = t185 * t475;
  t1281 = t750 * t1280;
  t1284 = t210 * t52;
  t1285 = t456 * t1284;
  t1289 = t459 * t475 * t201;
  t1296 = t178 * t513;
  t1301 = t761 * t476;
  t1307 = 0.1e1 / t37 / t997;
  t1310 = -0.44e3 / 0.27e2 * tau[0] * t442 + 0.154e3 / 0.27e2 * sigma[0] * t1307;
  t1311 = t57 * t1310;
  t1312 = t180 * t1311;
  t1315 = t52 * t29;
  t1316 = t451 * t185;
  t1318 = t1315 * t450 * t1316;
  t1321 = t456 * t83;
  t1322 = t57 * t201;
  t1323 = t467 * t1322;
  t1326 = -0.1e3 / 0.9e1 * t1269 * t459 * t185 * t483 - 0.1e5 / 0.243e3 * t1275 * t1277 + 0.1e5 / 0.243e3 * t749 * t1281 + 0.1e3 / 0.9e1 * t1285 * t461 + 0.5e2 / 0.9e1 * t458 * t1289 + 0.5e2 / 0.9e1 * t458 * t459 * t185 * t502 - 0.5e2 / 0.9e1 * t1296 * t187 - 0.5e2 / 0.9e1 * t464 * t477 - 0.5e2 / 0.9e1 * t179 * t1301 - 0.5e2 / 0.27e2 * t179 * t1312 + 0.1e5 / 0.243e3 * t447 * t1318 + 0.5e2 / 0.9e1 * t1321 * t1323;
  t1327 = t446 * t210;
  t1330 = t204 * t204;
  t1332 = t166 / t1330;
  t1333 = t432 * sigma[0];
  t1334 = t65 * t1333;
  t1335 = t434 * t434;
  t1336 = t1335 * t172;
  t1337 = 0.1e1 / t1336;
  t1338 = t1334 * t1337;
  t1342 = 0.1e1 / t36 / t1335;
  t1343 = t433 * t1342;
  t1346 = t171 * t1307;
  t1349 = t167 * t167;
  t1351 = t166 / t1349;
  t1353 = 0.4e4 / 0.43046721e8 * t1351 * t1338;
  t1355 = 0.22e4 / 0.531441e6 * t431 * t1343;
  t1357 = 0.154e4 / 0.6561e4 * t170 * t1346;
  t1358 = -0.4e4 / 0.43046721e8 * t1332 * t1338 + 0.22e4 / 0.531441e6 * t508 * t1343 - 0.154e4 / 0.6561e4 * t207 * t1346 + t1353 - t1355 + t1357;
  t1360 = t63 * t72;
  t1361 = t1316 * t76;
  t1368 = t513 * t201;
  t1371 = t210 * t502;
  t1380 = params->b * t63;
  t1390 = 0.5e3 / 0.81e2 * t1316 * t65 + 0.5e3 / 0.27e2 * t490 * t1280 + 0.25e3 / 0.81e2 * t193 * t1310 + 0.25e7 / 0.19683e5 * t1380 * t72 * t1316 + 0.625e6 / 0.6561e4 * t495 * t198 * t475 + 0.125e6 / 0.19683e5 * t197 * t72 * t1310;
  t1391 = t83 * t1390;
  t1393 = t190 * t190;
  t1394 = 0.1e1 / t1393;
  t1395 = t62 * t1394;
  t1396 = t483 * t201;
  t1397 = t83 * t1396;
  t1400 = t210 * t483;
  t1405 = 0.1e5 / 0.243e3 * t1327 * t453 + t77 * t1358 - t1353 - 0.1e7 / 0.19683e5 * t1360 * t1361 * t83 + 0.6e1 * t482 * t202 * t502 - 0.3e1 * t192 * t1368 - 0.3e1 * t192 * t1371 - t192 * t1391 - 0.6e1 * t1395 * t1397 + 0.6e1 * t482 * t1400 - 0.5e2 / 0.9e1 * t464 * t468 + t1355 - t1357;
  t1406 = t1326 + t1405;
  t1411 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1235 * t85 - 0.3e1 / 0.8e1 * t1241 - 0.9e1 / 0.8e1 * t6 * t408 * t212 + t1248 / 0.4e1 - 0.3e1 / 0.4e1 * t1251 - 0.9e1 / 0.8e1 * t6 * t156 * t515 - t1261 + t1263 / 0.4e1 - 0.3e1 / 0.8e1 * t1266 - 0.3e1 / 0.8e1 * t6 * t28 * t1406);
  t1413 = 0.1e1 / t521 / t94;
  t1414 = t523 * t220;
  t1417 = t522 * t220;
  t1420 = t91 * t1226;
  t1423 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t399 - 0.6e1 * t1420);
  t1427 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1413 * t1414 + 0.4e1 / 0.3e1 * t1417 * t529 + 0.4e1 / 0.3e1 * t96 * t1423);
  t1428 = t1427 * t27;
  t1432 = t533 * t161;
  t1434 = t6 * t1432 * t143;
  t1436 = t223 * t420;
  t1438 = t6 * t1436 * t143;
  t1440 = t98 * t1257;
  t1443 = 0.5e1 / 0.36e2 * t6 * t1440 * t143;
  t1445 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1428 * t143 - 0.3e1 / 0.8e1 * t1434 + t1438 / 0.4e1 - t1443);
  tv3rho30 = 0.3e1 * t520 + 0.3e1 * t547 + t7 * (t1411 + t1445);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1448 = 0.2e1 * t573;
  t1449 = 0.2e1 * t599;
  t1450 = t1218 * t237;
  t1453 = t394 * t554;
  t1458 = 0.2e1 * t399;
  t1459 = 0.6e1 * t1227;
  t1461 = my_piecewise5(t11, 0, t15, 0, t1458 - t1459);
  t1465 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1450 * t395 + 0.8e1 / 0.9e1 * t1453 * t152 + 0.4e1 / 0.9e1 * t550 * t403 + 0.4e1 / 0.3e1 * t24 * t1461);
  t1466 = t1465 * t27;
  t1470 = t558 * t161;
  t1473 = t6 * t1470 * t85 / 0.4e1;
  t1477 = t240 * t420;
  t1479 = t6 * t1477 * t85;
  t1483 = t6 * t563 * t212 / 0.4e1;
  t1492 = -0.3e1 / 0.8e1 * t6 * t1466 * t85 - t1473 - 0.3e1 / 0.4e1 * t6 * t559 * t212 + t1479 / 0.12e2 - t1483 - 0.3e1 / 0.8e1 * t6 * t241 * t515 - t1241 / 0.8e1 + t1248 / 0.6e1 - t1251 / 0.4e1 - t1261 + t1263 / 0.6e1 - t1266 / 0.8e1;
  t1493 = my_piecewise3(t2, 0, t1492);
  t1494 = t1413 * t248;
  t1497 = t522 * t578;
  t1502 = 0.6e1 * t1420;
  t1504 = my_piecewise5(t15, 0, t11, 0, -t1458 - t1502);
  t1508 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1494 * t523 + 0.8e1 / 0.9e1 * t1497 * t220 + 0.4e1 / 0.9e1 * t574 * t529 + 0.4e1 / 0.3e1 * t96 * t1504);
  t1509 = t1508 * t27;
  t1513 = t582 * t161;
  t1516 = t6 * t1513 * t143 / 0.4e1;
  t1517 = t251 * t420;
  t1519 = t6 * t1517 * t143;
  t1528 = t6 * t538 * t301 / 0.4e1;
  t1530 = t6 * t542 * t301;
  t1533 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1509 * t143 - t1516 + t1519 / 0.12e2 - t1434 / 0.8e1 + t1438 / 0.6e1 - t1443 - 0.3e1 / 0.8e1 * t6 * t534 * t301 - t1528 + t1530 / 0.12e2);
  tv3rho31 = t520 + t547 + t1448 + t1449 + t7 * (t1493 + t1533);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1536 = t1218 * t604;
  t1541 = t394 * t609;
  t1545 = my_piecewise5(t11, 0, t15, 0, -t1458 - t1459);
  t1549 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1536 * t152 + 0.8e1 / 0.9e1 * t550 * t554 + 0.4e1 / 0.9e1 * t1541 * t152 + 0.4e1 / 0.3e1 * t24 * t1545);
  t1550 = t1549 * t27;
  t1554 = t613 * t161;
  t1556 = t6 * t1554 * t85;
  t1565 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1550 * t85 - t1556 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t614 * t212 - t1473 + t1479 / 0.6e1 - t1483 + t1248 / 0.12e2 - t1261 + t1263 / 0.12e2);
  t1566 = t1413 * t621;
  t1571 = t522 * t626;
  t1575 = my_piecewise5(t15, 0, t11, 0, t1458 - t1502);
  t1579 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1566 * t220 + 0.8e1 / 0.9e1 * t574 * t578 + 0.4e1 / 0.9e1 * t1571 * t220 + 0.4e1 / 0.3e1 * t96 * t1575);
  t1580 = t1579 * t27;
  t1584 = t630 * t161;
  t1586 = t6 * t1584 * t143;
  t1593 = t6 * t587 * t301;
  t1601 = t6 * t228 * t724;
  t1603 = -0.3e1 / 0.8e1 * t6 * t1580 * t143 - t1586 / 0.8e1 - t1516 + t1519 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t583 * t301 - t1593 / 0.4e1 + t1438 / 0.12e2 - t1443 - t1528 + t1530 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t224 * t724 - t1601 / 0.8e1;
  t1604 = my_piecewise3(t90, 0, t1603);
  tv3rho32 = t1448 + t1449 + t620 + t729 + t7 * (t1565 + t1604);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1609 = t604 * t237;
  t1616 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t399 - 0.6e1 * t1227);
  t1620 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1218 * t1609 + 0.4e1 / 0.3e1 * t550 * t609 + 0.4e1 / 0.3e1 * t24 * t1616);
  t1621 = t1620 * t27;
  t1628 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1621 * t85 - 0.3e1 / 0.8e1 * t1556 + t1479 / 0.4e1 - t1261);
  t1629 = t621 * t248;
  t1636 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t399 - 0.6e1 * t1420);
  t1640 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1413 * t1629 + 0.4e1 / 0.3e1 * t574 * t626 + 0.4e1 / 0.3e1 * t96 * t1636);
  t1641 = t1640 * t27;
  t1656 = t117 * t29;
  t1657 = t661 * t274;
  t1659 = t1656 * t450 * t1657;
  t1662 = t666 * t141;
  t1663 = t57 * t290;
  t1664 = t676 * t1663;
  t1667 = t267 * t722;
  t1672 = t848 * t685;
  t1678 = 0.1e1 / t102 / t1039;
  t1681 = -0.44e3 / 0.27e2 * tau[1] * t654 + 0.154e3 / 0.27e2 * sigma[2] * t1678;
  t1682 = t57 * t1681;
  t1683 = t269 * t1682;
  t1686 = t658 * t299;
  t1689 = t293 * t293;
  t1691 = t166 / t1689;
  t1692 = t644 * sigma[2];
  t1693 = t65 * t1692;
  t1694 = t646 * t646;
  t1695 = t1694 * t261;
  t1696 = 0.1e1 / t1695;
  t1697 = t1693 * t1696;
  t1701 = 0.1e1 / t101 / t1694;
  t1702 = t645 * t1701;
  t1705 = t260 * t1678;
  t1708 = t256 * t256;
  t1710 = t166 / t1708;
  t1712 = 0.4e4 / 0.43046721e8 * t1710 * t1697;
  t1714 = 0.22e4 / 0.531441e6 * t643 * t1702;
  t1716 = 0.154e4 / 0.6561e4 * t259 * t1705;
  t1717 = -0.4e4 / 0.43046721e8 * t1691 * t1697 + 0.22e4 / 0.531441e6 * t717 * t1702 - 0.154e4 / 0.6561e4 * t296 * t1705 + t1712 - t1714 + t1716;
  t1719 = t299 * t711;
  t1724 = t274 * t684;
  t1729 = params->b * t125;
  t1739 = 0.5e3 / 0.81e2 * t1657 * t65 + 0.5e3 / 0.27e2 * t699 * t1724 + 0.25e3 / 0.81e2 * t282 * t1681 + 0.25e7 / 0.19683e5 * t1729 * t72 * t1657 + 0.625e6 / 0.6561e4 * t704 * t287 * t684 + 0.125e6 / 0.19683e5 * t286 * t72 * t1681;
  t1740 = t141 * t1739;
  t1742 = t299 * t692;
  t1745 = t279 * t279;
  t1746 = 0.1e1 / t1745;
  t1747 = t124 * t1746;
  t1748 = t692 * t290;
  t1749 = t141 * t1748;
  t1752 = 0.1e5 / 0.243e3 * t659 * t1659 + 0.5e2 / 0.9e1 * t1662 * t1664 - 0.5e2 / 0.9e1 * t1667 * t276 - 0.5e2 / 0.9e1 * t673 * t686 - 0.5e2 / 0.9e1 * t268 * t1672 - 0.5e2 / 0.27e2 * t268 * t1683 + 0.1e5 / 0.243e3 * t1686 * t663 + t135 * t1717 - 0.3e1 * t281 * t1719 - t281 * t1740 + 0.6e1 * t691 * t1742 - 0.6e1 * t1747 * t1749;
  t1753 = t722 * t290;
  t1759 = t125 * t72;
  t1760 = t1657 * t134;
  t1766 = t123 * t690;
  t1767 = t1766 * t667;
  t1772 = t122 * t280;
  t1773 = t1772 * t836;
  t1775 = t750 * t661 * t290;
  t1778 = t750 * t1724;
  t1781 = t299 * t117;
  t1782 = t666 * t1781;
  t1786 = t459 * t684 * t290;
  t1793 = -0.3e1 * t281 * t1753 + 0.6e1 * t691 * t291 * t711 - t1712 - 0.1e7 / 0.19683e5 * t1759 * t1760 * t141 - 0.5e2 / 0.9e1 * t673 * t677 + t1714 - t1716 - 0.1e3 / 0.9e1 * t1767 * t459 * t274 * t692 - 0.1e5 / 0.243e3 * t1773 * t1775 + 0.1e5 / 0.243e3 * t837 * t1778 + 0.1e3 / 0.9e1 * t1782 * t670 + 0.5e2 / 0.9e1 * t668 * t1786 + 0.5e2 / 0.9e1 * t668 * t459 * t274 * t711;
  t1794 = t1752 + t1793;
  t1799 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1641 * t143 - 0.3e1 / 0.8e1 * t1586 - 0.9e1 / 0.8e1 * t6 * t631 * t301 + t1519 / 0.4e1 - 0.3e1 / 0.4e1 * t1593 - 0.9e1 / 0.8e1 * t6 * t252 * t724 - t1443 + t1530 / 0.4e1 - 0.3e1 / 0.8e1 * t1601 - 0.3e1 / 0.8e1 * t6 * t99 * t1794);
  tv3rho33 = 0.3e1 * t620 + 0.3e1 * t729 + t7 * (t1628 + t1799);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1807 = t6 * t412 * t328;
  t1814 = t6 * t421 * t328 / 0.12e2;
  t1816 = t6 * t162 * t801;
  t1818 = t1268 * t322;
  t1820 = t180 * t186 * t201;
  t1824 = t750 * t751 * t201;
  t1825 = t1275 * t1824;
  t1827 = t1296 * t313;
  t1829 = t464 * t762;
  t1831 = t475 * t54;
  t1832 = t1831 * t312;
  t1833 = t179 * t1832;
  t1835 = t178 * t799;
  t1840 = t446 * t326;
  t1843 = t464 * t766;
  t1845 = t761 * t765;
  t1846 = t179 * t1845;
  t1849 = t57 * t442;
  t1850 = t180 * t1849;
  t1851 = t179 * t1850;
  t1853 = t1335 * t35;
  t1855 = t65 / t1853;
  t1856 = t1855 * t432;
  t1860 = t57 * t437 * sigma[0];
  t1863 = t34 * t442;
  t1867 = 0.5e3 / 0.14348907e8 * t1351 * t1856;
  t1869 = 0.25e2 / 0.19683e5 * t431 * t1860;
  t1871 = 0.11e3 / 0.2187e4 * t169 * t1863;
  t1872 = 0.5e3 / 0.14348907e8 * t1332 * t1856 - 0.25e2 / 0.19683e5 * t508 * t1860 + 0.11e3 / 0.2187e4 * t206 * t1863 - t1867 + t1869 - t1871;
  t1874 = t513 * t321;
  t1876 = t210 * t787;
  t1879 = t451 * t65;
  t1880 = t1879 * t39;
  t1882 = t174 * t185;
  t1883 = t490 * t1882;
  t1885 = t39 * t475;
  t1886 = t490 * t1885;
  t1888 = t193 * t442;
  t1891 = t1380 * t318 * t451;
  t1894 = t495 * t784 * t185;
  t1897 = t495 * t318 * t475;
  t1899 = t72 * t442;
  t1900 = t197 * t1899;
  t1902 = -0.125e3 / 0.162e3 * t1880 + 0.1e4 / 0.243e3 * t1883 - 0.125e3 / 0.162e3 * t1886 - 0.275e4 / 0.729e3 * t1888 - 0.3125e6 / 0.19683e5 * t1891 + 0.125e7 / 0.59049e5 * t1894 - 0.78125e5 / 0.19683e5 * t1897 - 0.1375e7 / 0.177147e6 * t1900;
  t1903 = t83 * t1902;
  t1905 = t799 * t201;
  t1908 = t326 * t483;
  t1911 = t326 * t502;
  t1916 = 0.55e3 / 0.243e3 * t1851 + t77 * t1872 - t192 * t1874 - 0.2e1 * t192 * t1876 - t192 * t1903 - 0.2e1 * t192 * t1905 + 0.2e1 * t482 * t1908 - t192 * t1911 + t1871 - 0.6e1 * t1395 * t322 * t483 + t1867;
  t1929 = t1360 * t451;
  t1930 = t76 * t83;
  t1931 = t1930 * t39;
  t1932 = t1929 * t1931;
  t1935 = t321 * t451 * t459;
  t1938 = t174 * t201;
  t1939 = t459 * t1938;
  t1940 = t458 * t1939;
  t1942 = t446 * t457;
  t1943 = t39 * t451;
  t1944 = t750 * t1943;
  t1945 = t1942 * t1944;
  t1947 = t750 * t1882;
  t1948 = t749 * t1947;
  t1952 = t459 * t39 * t483;
  t1953 = t1269 * t1952;
  t1955 = t210 * t53;
  t1956 = t446 * t1955;
  t1957 = t1956 * t752;
  t1959 = t750 * t1885;
  t1960 = t749 * t1959;
  t1962 = t1285 * t756;
  t1964 = t83 * t185;
  t1965 = t456 * t1964;
  t1966 = t1965 * t756;
  t1969 = t459 * t39 * t502;
  t1970 = t458 * t1969;
  t1972 = t456 * t775;
  t1975 = t456 * t788;
  t1980 = t1274 * t322;
  t1983 = t326 * t52;
  t1984 = t456 * t1983;
  t1987 = 0.25e2 / 0.54e2 * t1953 - 0.25e4 / 0.729e3 * t1957 - 0.125e4 / 0.729e3 * t1960 - 0.25e2 / 0.54e2 * t1962 - 0.25e2 / 0.54e2 * t1966 - 0.25e2 / 0.108e3 * t1970 + 0.1e3 / 0.27e2 * t1972 * t187 + 0.1e3 / 0.27e2 * t1975 * t187 + 0.5e2 / 0.27e2 * t769 * t477 - 0.1e5 / 0.729e3 * t1980 * t453 + 0.1e3 / 0.27e2 * t1984 * t461;
  t1989 = -0.2e3 / 0.27e2 * t1818 * t1820 + 0.25e4 / 0.729e3 * t1825 + 0.25e2 / 0.108e3 * t1827 + 0.25e2 / 0.54e2 * t1829 + 0.25e2 / 0.108e3 * t1833 - 0.1e3 / 0.27e2 * t1835 * t187 - 0.5e2 / 0.27e2 * t790 * t477 + 0.1e5 / 0.729e3 * t1840 * t453 - 0.1e3 / 0.81e2 * t1843 - 0.1e3 / 0.81e2 * t1846 + t1916 + 0.4e1 * t482 * t775 * t201 + 0.4e1 * t482 * t788 * t201 + 0.2e1 * t482 * t322 * t502 - 0.5e2 / 0.27e2 * t790 * t468 - t1869 + 0.125e6 / 0.19683e5 * t1932 + 0.5e2 / 0.27e2 * t1321 * t1935 + 0.1e3 / 0.81e2 * t1940 - 0.125e4 / 0.243e3 * t1945 + 0.2e5 / 0.2187e4 * t1948 + t1987;
  t1994 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t328 - t1807 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t801 + t1814 - t1816 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1989);
  tv3rho2sigma0 = t7 * t1994 + 0.2e1 * t806;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2001 = t6 * t538 * t352;
  t2005 = t6 * t542 * t352 / 0.12e2;
  t2007 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t352 - t2001 / 0.4e1 + t2005);
  tv3rho2sigma2 = t7 * t2007 + 0.2e1 * t815;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2013 = t6 * t563 * t328;
  t2021 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t328 - t2013 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t801 - t1807 / 0.8e1 + t1814 - t1816 / 0.8e1);
  tv3rho2sigma3 = t7 * t2021 + t806 + t821;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2027 = t6 * t587 * t352;
  t2034 = t6 * t228 * t888;
  t2037 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t352 - t2027 / 0.8e1 - t2001 / 0.8e1 + t2005 - 0.3e1 / 0.8e1 * t6 * t224 * t888 - t2034 / 0.8e1);
  tv3rho2sigma5 = t7 * t2037 + t815 + t893;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2045 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t328 - t2013 / 0.4e1 + t1814);
  tv3rho2sigma6 = t7 * t2045 + 0.2e1 * t821;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2057 = t750 * t838 * t290;
  t2058 = t1773 * t2057;
  t2060 = t1766 * t346;
  t2062 = t269 * t275 * t290;
  t2065 = t299 * t874;
  t2068 = t661 * t65;
  t2069 = t2068 * t104;
  t2071 = t263 * t274;
  t2072 = t699 * t2071;
  t2074 = t104 * t684;
  t2075 = t699 * t2074;
  t2077 = t282 * t654;
  t2080 = t1729 * t342 * t661;
  t2083 = t704 * t871 * t274;
  t2086 = t704 * t342 * t684;
  t2088 = t72 * t654;
  t2089 = t286 * t2088;
  t2091 = -0.125e3 / 0.162e3 * t2069 + 0.1e4 / 0.243e3 * t2072 - 0.125e3 / 0.162e3 * t2075 - 0.275e4 / 0.729e3 * t2077 - 0.3125e6 / 0.19683e5 * t2080 + 0.125e7 / 0.59049e5 * t2083 - 0.78125e5 / 0.19683e5 * t2086 - 0.1375e7 / 0.177147e6 * t2089;
  t2092 = t141 * t2091;
  t2094 = t886 * t290;
  t2097 = t350 * t711;
  t2099 = t350 * t692;
  t2102 = t722 * t345;
  t2104 = t1694 * t100;
  t2106 = t65 / t2104;
  t2107 = t2106 * t644;
  t2111 = t57 * t649 * sigma[2];
  t2114 = t34 * t654;
  t2118 = 0.5e3 / 0.14348907e8 * t1710 * t2107;
  t2120 = 0.25e2 / 0.19683e5 * t643 * t2111;
  t2122 = 0.11e3 / 0.2187e4 * t258 * t2114;
  t2123 = 0.5e3 / 0.14348907e8 * t1691 * t2107 - 0.25e2 / 0.19683e5 * t717 * t2111 + 0.11e3 / 0.2187e4 * t295 * t2114 - t2118 + t2120 - t2122;
  t2138 = t1759 * t661;
  t2139 = t134 * t141;
  t2140 = t2139 * t104;
  t2141 = t2138 * t2140;
  t2146 = t345 * t661 * t459;
  t2149 = t1667 * t337;
  t2151 = t673 * t849;
  t2153 = t2118 + 0.4e1 * t691 * t862 * t290 + 0.4e1 * t691 * t875 * t290 + 0.2e1 * t691 * t346 * t711 + t2122 + 0.125e6 / 0.19683e5 * t2141 - t2120 - 0.5e2 / 0.27e2 * t877 * t677 + 0.5e2 / 0.27e2 * t1662 * t2146 + 0.25e2 / 0.108e3 * t2149 + 0.25e2 / 0.54e2 * t2151;
  t2155 = t684 * t54;
  t2156 = t2155 * t336;
  t2157 = t268 * t2156;
  t2159 = t267 * t886;
  t2164 = t658 * t350;
  t2167 = t673 * t853;
  t2169 = t848 * t852;
  t2170 = t268 * t2169;
  t2172 = t57 * t654;
  t2173 = t269 * t2172;
  t2174 = t268 * t2173;
  t2176 = t658 * t667;
  t2177 = t104 * t661;
  t2178 = t750 * t2177;
  t2179 = t2176 * t2178;
  t2181 = t750 * t2071;
  t2182 = t837 * t2181;
  t2185 = t459 * t104 * t692;
  t2186 = t1767 * t2185;
  t2190 = t459 * t263 * t290;
  t2191 = t668 * t2190;
  t2193 = t299 * t118;
  t2194 = t658 * t2193;
  t2195 = t2194 * t839;
  t2197 = t750 * t2074;
  t2198 = t837 * t2197;
  t2200 = t1782 * t843;
  t2202 = t141 * t274;
  t2203 = t666 * t2202;
  t2204 = t2203 * t843;
  t2207 = t459 * t104 * t711;
  t2208 = t668 * t2207;
  t2210 = t666 * t862;
  t2213 = t666 * t875;
  t2218 = t1772 * t346;
  t2221 = t350 * t117;
  t2222 = t666 * t2221;
  t2225 = 0.1e3 / 0.81e2 * t2191 - 0.25e4 / 0.729e3 * t2195 - 0.125e4 / 0.729e3 * t2198 - 0.25e2 / 0.54e2 * t2200 - 0.25e2 / 0.54e2 * t2204 - 0.25e2 / 0.108e3 * t2208 + 0.1e3 / 0.27e2 * t2210 * t276 + 0.1e3 / 0.27e2 * t2213 * t276 + 0.5e2 / 0.27e2 * t856 * t686 - 0.1e5 / 0.729e3 * t2218 * t663 + 0.1e3 / 0.27e2 * t2222 * t670;
  t2227 = 0.25e4 / 0.729e3 * t2058 - 0.2e3 / 0.27e2 * t2060 * t2062 - 0.2e1 * t281 * t2065 - t281 * t2092 - 0.2e1 * t281 * t2094 - t281 * t2097 + 0.2e1 * t691 * t2099 - t281 * t2102 + t135 * t2123 - 0.6e1 * t1747 * t346 * t692 + t2153 + 0.25e2 / 0.108e3 * t2157 - 0.1e3 / 0.27e2 * t2159 * t276 - 0.5e2 / 0.27e2 * t877 * t686 + 0.1e5 / 0.729e3 * t2164 * t663 - 0.1e3 / 0.81e2 * t2167 - 0.1e3 / 0.81e2 * t2170 + 0.55e3 / 0.243e3 * t2174 - 0.125e4 / 0.243e3 * t2179 + 0.2e5 / 0.2187e4 * t2182 + 0.25e2 / 0.54e2 * t2186 + t2225;
  t2232 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t352 - t2027 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t888 + t2005 - t2034 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t2227);
  tv3rho2sigma8 = t7 * t2232 + 0.2e1 * t893;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2239 = t6 * t412 * t369;
  t2246 = t6 * t421 * t369 / 0.12e2;
  t2248 = t6 * t162 * t933;
  t2252 = t1268 * t367;
  t2256 = t750 * t901 * t201;
  t2265 = t49 * t475;
  t2277 = 0.5e3 / 0.81e2 * t1879 * t49 - 0.5e4 / 0.243e3 * t777 + 0.5e3 / 0.81e2 * t490 * t2265 + 0.1e5 / 0.729e3 * t779 + 0.25e7 / 0.19683e5 * t1380 * t363 * t451 - 0.625e7 / 0.59049e5 * t782 + 0.625e6 / 0.19683e5 * t495 * t363 * t475 + 0.5e7 / 0.177147e6 * t785;
  t2278 = t83 * t2277;
  t2280 = t513 * t366;
  t2282 = t210 * t930;
  t2297 = t1930 * t49;
  t2300 = -0.1e6 / 0.2187e4 * t753 - 0.5e3 / 0.81e2 * t757 - 0.2e3 / 0.27e2 * t2252 * t1820 - 0.2e5 / 0.729e3 * t1275 * t2256 + 0.5e3 / 0.81e2 * t759 + 0.5e3 / 0.81e2 * t763 - 0.2e4 / 0.243e3 * t767 - t192 * t2278 - t192 * t2280 - 0.2e1 * t192 * t2282 - 0.6e1 * t1395 * t367 * t483 + 0.4e1 * t482 * t921 * t201 + 0.4e1 * t482 * t931 * t201 + 0.2e1 * t482 * t367 * t502 - 0.1e7 / 0.19683e5 * t1929 * t2297;
  t2302 = t366 * t451 * t459;
  t2309 = t1831 * t357;
  t2312 = t49 * t451;
  t2313 = t750 * t2312;
  t2317 = t459 * t49 * t483;
  t2322 = t750 * t2265;
  t2330 = t459 * t49 * t502;
  t2333 = t456 * t921;
  t2336 = t456 * t931;
  t2341 = t1274 * t367;
  t2344 = 0.5e2 / 0.27e2 * t1321 * t2302 - 0.5e2 / 0.27e2 * t1296 * t358 - 0.1e3 / 0.27e2 * t464 * t911 - 0.5e2 / 0.27e2 * t179 * t2309 + 0.1e5 / 0.243e3 * t1942 * t2313 - 0.1e3 / 0.27e2 * t1269 * t2317 + 0.2e5 / 0.729e3 * t1956 * t902 + 0.1e5 / 0.729e3 * t749 * t2322 + 0.1e3 / 0.27e2 * t1285 * t906 + 0.1e3 / 0.27e2 * t1965 * t906 + 0.5e2 / 0.27e2 * t458 * t2330 + 0.1e3 / 0.27e2 * t2333 * t187 + 0.1e3 / 0.27e2 * t2336 * t187 + 0.5e2 / 0.27e2 * t915 * t477 - 0.1e5 / 0.729e3 * t2341 * t453;
  t2345 = t2300 + t2344;
  t2350 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t369 - t2239 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t933 + t2246 - t2248 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2345);
  tv3rho2tau0 = t7 * t2350 + 0.2e1 * t938;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2357 = t6 * t538 * t386;
  t2361 = t6 * t542 * t386 / 0.12e2;
  t2363 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t386 - t2357 / 0.4e1 + t2361);
  tv3rho2tau1 = t7 * t2363 + 0.2e1 * t947;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2369 = t6 * t563 * t369;
  t2377 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t369 - t2369 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t933 - t2239 / 0.8e1 + t2246 - t2248 / 0.8e1);
  tv3rho2tau2 = t7 * t2377 + t938 + t953;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2383 = t6 * t587 * t386;
  t2390 = t6 * t228 * t990;
  t2393 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t386 - t2383 / 0.8e1 - t2357 / 0.8e1 + t2361 - 0.3e1 / 0.8e1 * t6 * t224 * t990 - t2390 / 0.8e1);
  tv3rho2tau3 = t7 * t2393 + t947 + t995;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2401 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t369 - t2369 / 0.4e1 + t2246);
  tv3rho2tau4 = t7 * t2401 + 0.2e1 * t953;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2414 = t1766 * t384;
  t2418 = t750 * t958 * t290;
  t2424 = t722 * t383;
  t2426 = t299 * t987;
  t2432 = t114 * t684;
  t2444 = 0.5e3 / 0.81e2 * t2068 * t114 - 0.5e4 / 0.243e3 * t864 + 0.5e3 / 0.81e2 * t699 * t2432 + 0.1e5 / 0.729e3 * t866 + 0.25e7 / 0.19683e5 * t1729 * t380 * t661 - 0.625e7 / 0.59049e5 * t869 + 0.625e6 / 0.19683e5 * t704 * t380 * t684 + 0.5e7 / 0.177147e6 * t872;
  t2445 = t141 * t2444;
  t2459 = t2139 * t114;
  t2462 = -0.1e6 / 0.2187e4 * t840 - 0.5e3 / 0.81e2 * t844 - 0.2e3 / 0.27e2 * t2414 * t2062 - 0.2e5 / 0.729e3 * t1773 * t2418 + 0.5e3 / 0.81e2 * t846 + 0.5e3 / 0.81e2 * t850 - 0.2e4 / 0.243e3 * t854 - t281 * t2424 - 0.2e1 * t281 * t2426 - t281 * t2445 + 0.4e1 * t691 * t978 * t290 + 0.4e1 * t691 * t988 * t290 + 0.2e1 * t691 * t384 * t711 - 0.6e1 * t1747 * t384 * t692 - 0.1e7 / 0.19683e5 * t2138 * t2459;
  t2467 = t2155 * t374;
  t2471 = t383 * t661 * t459;
  t2474 = t114 * t661;
  t2475 = t750 * t2474;
  t2479 = t459 * t114 * t692;
  t2484 = t1772 * t384;
  t2489 = t750 * t2432;
  t2497 = t459 * t114 * t711;
  t2500 = t666 * t978;
  t2503 = t666 * t988;
  t2506 = -0.5e2 / 0.27e2 * t1667 * t375 - 0.1e3 / 0.27e2 * t673 * t968 - 0.5e2 / 0.27e2 * t268 * t2467 + 0.5e2 / 0.27e2 * t1662 * t2471 + 0.1e5 / 0.243e3 * t2176 * t2475 - 0.1e3 / 0.27e2 * t1767 * t2479 + 0.5e2 / 0.27e2 * t972 * t686 - 0.1e5 / 0.729e3 * t2484 * t663 + 0.2e5 / 0.729e3 * t2194 * t959 + 0.1e5 / 0.729e3 * t837 * t2489 + 0.1e3 / 0.27e2 * t1782 * t963 + 0.1e3 / 0.27e2 * t2203 * t963 + 0.5e2 / 0.27e2 * t668 * t2497 + 0.1e3 / 0.27e2 * t2500 * t276 + 0.1e3 / 0.27e2 * t2503 * t276;
  t2507 = t2462 + t2506;
  t2512 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t386 - t2383 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t990 + t2361 - t2390 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t2507);
  tv3rho2tau5 = t7 * t2512 + 0.2e1 * t995;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2519 = t6 * t162 * t1034 / 0.8e1;
  t2520 = t326 * t787;
  t2523 = t210 * t1027;
  t2525 = t185 * t65;
  t2526 = t2525 * t999;
  t2528 = t490 * t740;
  t2531 = t1380 * t1024 * t185;
  t2533 = t72 * t740;
  t2534 = t495 * t2533;
  t2536 = 0.125e3 / 0.1296e4 * t2526 - 0.125e3 / 0.243e3 * t2528 + 0.78125e5 / 0.39366e5 * t2531 - 0.15625e6 / 0.59049e5 * t2534;
  t2537 = t83 * t2536;
  t2539 = t1032 * t201;
  t2541 = t210 * t1015;
  t2544 = t799 * t321;
  t2548 = t459 * t1007 * t201;
  t2549 = t1269 * t2548;
  t2552 = t750 * t1007 * t185;
  t2553 = t1275 * t2552;
  t2555 = t1335 * rho[0];
  t2556 = 0.1e1 / t2555;
  t2557 = t65 * t2556;
  t2558 = t2557 * sigma[0];
  t2561 = t459 * t740;
  t2565 = 0.125e3 / 0.9565938e7 * t1351 * t2558;
  t2567 = 0.5e2 / 0.177147e6 * t430 * t2561;
  t2568 = -0.125e3 / 0.9565938e7 * t1332 * t2558 + 0.5e2 / 0.177147e6 * t507 * t2561 + t2565 - t2567;
  t2582 = t179 * t2561;
  t2584 = t1360 * t185;
  t2585 = t1930 * t999;
  t2586 = t2584 * t2585;
  t2588 = t464 * t1000;
  t2590 = -0.2e1 * t192 * t2520 - t192 * t2523 - t192 * t2537 - t192 * t2539 + 0.2e1 * t482 * t2541 - 0.2e1 * t192 * t2544 + 0.25e2 / 0.27e2 * t2549 + 0.25e4 / 0.729e3 * t2553 + t77 * t2568 + 0.4e1 * t482 * t322 * t787 + 0.4e1 * t482 * t1019 * t201 + t2567 + 0.2e1 * t482 * t1028 * t201 - t2565 - 0.6e1 * t1395 * t1016 * t201 + 0.25e2 / 0.162e3 * t2582 - 0.15625e5 / 0.19683e5 * t2586 - 0.25e2 / 0.864e3 * t2588;
  t2591 = t790 * t766;
  t2594 = t448 * t450 * t740;
  t2595 = t447 * t2594;
  t2597 = t999 * t54;
  t2598 = t2597 * t1322;
  t2599 = t1321 * t2598;
  t2601 = t178 * t1032;
  t2604 = t1327 * t1004;
  t2606 = t1835 * t313;
  t2608 = t790 * t762;
  t2610 = t174 * t321;
  t2611 = t459 * t2610;
  t2612 = t458 * t2611;
  t2614 = t1285 * t1008;
  t2616 = t1965 * t1008;
  t2618 = t39 * t787;
  t2619 = t459 * t2618;
  t2620 = t458 * t2619;
  t2622 = t1984 * t756;
  t2624 = t326 * t53;
  t2625 = t446 * t2624;
  t2626 = t2625 * t752;
  t2628 = t1268 * t1016;
  t2631 = t456 * t1019;
  t2634 = t456 * t1028;
  t2637 = t999 * t185;
  t2639 = t1942 * t750 * t2637;
  t2641 = t999 * t201;
  t2642 = t750 * t2641;
  t2643 = t1275 * t2642;
  t2645 = -0.1e3 / 0.81e2 * t2591 - 0.25e4 / 0.2187e4 * t2595 + 0.25e2 / 0.864e3 * t2599 - 0.5e2 / 0.27e2 * t2601 * t187 + 0.625e3 / 0.2916e4 * t2604 + 0.25e2 / 0.54e2 * t2606 + 0.25e2 / 0.54e2 * t2608 + 0.1e3 / 0.81e2 * t2612 - 0.25e2 / 0.54e2 * t2614 - 0.25e2 / 0.54e2 * t2616 - 0.25e2 / 0.54e2 * t2620 - 0.25e2 / 0.54e2 * t2622 - 0.25e4 / 0.729e3 * t2626 - 0.1e3 / 0.27e2 * t2628 * t187 + 0.1e3 / 0.27e2 * t2631 * t187 + 0.5e2 / 0.27e2 * t2634 * t187 + 0.625e3 / 0.972e3 * t2639 - 0.625e3 / 0.2916e4 * t2643;
  t2646 = t2590 + t2645;
  t2651 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t1034 - t2519 - 0.3e1 / 0.8e1 * t6 * t28 * t2646);
  tv3rhosigma20 = t7 * t2651 + t1038;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2658 = t6 * t228 * t1076 / 0.8e1;
  t2660 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t1076 - t2658);
  tv3rhosigma25 = t7 * t2660 + t1080;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2666 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t1034 - t2519);
  tv3rhosigma26 = t7 * t2666 + t1038;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2671 = t1694 * rho[1];
  t2672 = 0.1e1 / t2671;
  t2673 = t65 * t2672;
  t2674 = t2673 * sigma[2];
  t2677 = t459 * t828;
  t2681 = 0.125e3 / 0.9565938e7 * t1710 * t2674;
  t2683 = 0.5e2 / 0.177147e6 * t642 * t2677;
  t2684 = -0.125e3 / 0.9565938e7 * t1691 * t2674 + 0.5e2 / 0.177147e6 * t716 * t2677 + t2681 - t2683;
  t2686 = t886 * t345;
  t2689 = t350 * t874;
  t2692 = t299 * t1069;
  t2694 = t274 * t65;
  t2695 = t2694 * t1041;
  t2697 = t699 * t828;
  t2700 = t1729 * t1066 * t274;
  t2702 = t72 * t828;
  t2703 = t704 * t2702;
  t2705 = 0.125e3 / 0.1296e4 * t2695 - 0.125e3 / 0.243e3 * t2697 + 0.78125e5 / 0.39366e5 * t2700 - 0.15625e6 / 0.59049e5 * t2703;
  t2706 = t141 * t2705;
  t2708 = t1074 * t290;
  t2710 = t299 * t1057;
  t2714 = t459 * t1049 * t290;
  t2715 = t1767 * t2714;
  t2718 = t750 * t1049 * t274;
  t2719 = t1773 * t2718;
  t2733 = t673 * t1042;
  t2735 = t268 * t2677;
  t2737 = t1759 * t274;
  t2738 = t2139 * t1041;
  t2739 = t2737 * t2738;
  t2741 = t135 * t2684 - 0.2e1 * t281 * t2686 - 0.2e1 * t281 * t2689 - t281 * t2692 - t281 * t2706 - t281 * t2708 + 0.2e1 * t691 * t2710 + 0.25e2 / 0.27e2 * t2715 + 0.25e4 / 0.729e3 * t2719 - t2681 - 0.6e1 * t1747 * t1058 * t290 + 0.4e1 * t691 * t346 * t874 + 0.4e1 * t691 * t1061 * t290 + 0.2e1 * t691 * t1070 * t290 + t2683 - 0.25e2 / 0.864e3 * t2733 + 0.25e2 / 0.162e3 * t2735 - 0.15625e5 / 0.19683e5 * t2739;
  t2742 = t877 * t849;
  t2744 = t1041 * t54;
  t2745 = t2744 * t1663;
  t2746 = t1662 * t2745;
  t2748 = t267 * t1074;
  t2752 = t660 * t450 * t828;
  t2753 = t659 * t2752;
  t2755 = t877 * t853;
  t2757 = t1686 * t1046;
  t2759 = t2159 * t337;
  t2761 = t666 * t1061;
  t2764 = t666 * t1070;
  t2767 = t1041 * t290;
  t2768 = t750 * t2767;
  t2769 = t1773 * t2768;
  t2772 = t750 * t1041 * t274;
  t2773 = t2176 * t2772;
  t2775 = t1782 * t1050;
  t2777 = t2203 * t1050;
  t2779 = t104 * t874;
  t2780 = t459 * t2779;
  t2781 = t668 * t2780;
  t2783 = t2222 * t843;
  t2785 = t350 * t118;
  t2786 = t658 * t2785;
  t2787 = t2786 * t839;
  t2789 = t1766 * t1058;
  t2792 = t263 * t345;
  t2793 = t459 * t2792;
  t2794 = t668 * t2793;
  t2796 = 0.25e2 / 0.54e2 * t2742 + 0.25e2 / 0.864e3 * t2746 - 0.5e2 / 0.27e2 * t2748 * t276 - 0.25e4 / 0.2187e4 * t2753 - 0.1e3 / 0.81e2 * t2755 + 0.625e3 / 0.2916e4 * t2757 + 0.25e2 / 0.54e2 * t2759 + 0.1e3 / 0.27e2 * t2761 * t276 + 0.5e2 / 0.27e2 * t2764 * t276 - 0.625e3 / 0.2916e4 * t2769 + 0.625e3 / 0.972e3 * t2773 - 0.25e2 / 0.54e2 * t2775 - 0.25e2 / 0.54e2 * t2777 - 0.25e2 / 0.54e2 * t2781 - 0.25e2 / 0.54e2 * t2783 - 0.25e4 / 0.729e3 * t2787 - 0.1e3 / 0.27e2 * t2789 * t276 + 0.1e3 / 0.81e2 * t2794;
  t2797 = t2741 + t2796;
  t2802 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t1076 - t2658 - 0.3e1 / 0.8e1 * t6 * t99 * t2797);
  tv3rhosigma211 = t7 * t2802 + t1080;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2809 = t6 * t162 * t1112 / 0.8e1;
  t2810 = t326 * t930;
  t2812 = t210 * t1109;
  t2814 = t2525 * t1082;
  t2818 = t1380 * t1106 * t185;
  t2821 = -0.125e3 / 0.162e3 * t2814 + 0.1625e4 / 0.486e3 * t1022 - 0.3125e6 / 0.19683e5 * t2818 + 0.1015625e7 / 0.59049e5 * t1025;
  t2822 = t83 * t2821;
  t2824 = t799 * t366;
  t2828 = t459 * t1087 * t201;
  t2832 = t750 * t1087 * t185;
  t2835 = t312 * t201;
  t2836 = t180 * t2835;
  t2837 = t2252 * t2836;
  t2839 = t450 * t39;
  t2841 = t448 * t2839 * t185;
  t2842 = t2341 * t2841;
  t2844 = t321 * t52;
  t2845 = t459 * t185;
  t2846 = t2844 * t2845;
  t2866 = t1930 * t1082;
  t2867 = t2584 * t2866;
  t2869 = t464 * t1094;
  t2871 = -t192 * t2810 - t192 * t2812 - t192 * t2822 - t192 * t2824 - 0.25e3 / 0.81e2 * t1009 - 0.1e3 / 0.27e2 * t1269 * t2828 - 0.1e5 / 0.729e3 * t1275 * t2832 + 0.25e2 / 0.54e2 * t2837 + 0.125e4 / 0.729e3 * t2842 - 0.1e3 / 0.27e2 * t2252 * t2846 + 0.1625e5 / 0.2187e4 * t1005 + 0.25e3 / 0.81e2 * t1011 + 0.2e1 * t482 * t367 * t787 + 0.2e1 * t482 * t1102 * t201 + 0.2e1 * t482 * t1110 * t201 + 0.2e1 * t482 * t921 * t321 + 0.2e1 * t482 * t931 * t321 + 0.125e6 / 0.19683e5 * t2867 + 0.25e2 / 0.108e3 * t2869;
  t2872 = t1395 * t83;
  t2873 = t366 * t321;
  t2874 = t2873 * t201;
  t2877 = t1093 * t1322;
  t2878 = t1321 * t2877;
  t2880 = t1327 * t1084;
  t2891 = t49 * t787;
  t2892 = t459 * t2891;
  t2899 = t2333 * t313;
  t2901 = t2336 * t313;
  t2903 = t915 * t762;
  t2905 = t456 * t1102;
  t2908 = t456 * t1110;
  t2911 = t1082 * t201;
  t2912 = t750 * t2911;
  t2913 = t1275 * t2912;
  t2916 = t750 * t1082 * t185;
  t2917 = t1942 * t2916;
  t2919 = t915 * t766;
  t2921 = -0.6e1 * t2872 * t2874 - 0.25e2 / 0.108e3 * t2878 - 0.125e4 / 0.729e3 * t2880 - 0.5e2 / 0.27e2 * t1835 * t358 - 0.5e2 / 0.27e2 * t790 * t911 - 0.325e3 / 0.324e3 * t1013 + 0.5e2 / 0.27e2 * t1285 * t1088 + 0.5e2 / 0.27e2 * t1965 * t1088 + 0.5e2 / 0.27e2 * t458 * t2892 + 0.5e2 / 0.27e2 * t1984 * t906 + 0.1e5 / 0.729e3 * t2625 * t902 - 0.25e2 / 0.108e3 * t2899 - 0.25e2 / 0.108e3 * t2901 - 0.25e2 / 0.108e3 * t2903 + 0.5e2 / 0.27e2 * t2905 * t187 + 0.5e2 / 0.27e2 * t2908 * t187 + 0.125e4 / 0.729e3 * t2913 - 0.125e4 / 0.243e3 * t2917 + 0.5e2 / 0.81e2 * t2919;
  t2922 = t2871 + t2921;
  t2927 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t1112 - t2809 - 0.3e1 / 0.8e1 * t6 * t28 * t2922);
  tv3rhosigmatau0 = t7 * t2927 + t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2934 = t6 * t228 * t1148 / 0.8e1;
  t2936 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t1148 - t2934);
  tv3rhosigmatau5 = t7 * t2936 + t1152;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2942 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t1112 - t2809);
  tv3rhosigmatau6 = t7 * t2942 + t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2948 = t336 * t290;
  t2949 = t269 * t2948;
  t2950 = t2414 * t2949;
  t2952 = t450 * t104;
  t2954 = t660 * t2952 * t274;
  t2955 = t2484 * t2954;
  t2957 = t345 * t117;
  t2958 = t459 * t274;
  t2959 = t2957 * t2958;
  t2963 = t459 * t1123 * t290;
  t2967 = t750 * t1123 * t274;
  t2987 = t2139 * t1118;
  t2988 = t2737 * t2987;
  t2990 = t673 * t1130;
  t2992 = t1747 * t141;
  t2993 = t383 * t345;
  t2994 = t2993 * t290;
  t3001 = t1129 * t1663;
  t3002 = t1662 * t3001;
  t3004 = -0.25e3 / 0.81e2 * t1051 + 0.25e2 / 0.54e2 * t2950 + 0.125e4 / 0.729e3 * t2955 - 0.1e3 / 0.27e2 * t2414 * t2959 - 0.1e3 / 0.27e2 * t1767 * t2963 - 0.1e5 / 0.729e3 * t1773 * t2967 + 0.1625e5 / 0.2187e4 * t1047 + 0.25e3 / 0.81e2 * t1053 + 0.2e1 * t691 * t1138 * t290 + 0.2e1 * t691 * t1146 * t290 + 0.2e1 * t691 * t978 * t345 + 0.2e1 * t691 * t988 * t345 + 0.2e1 * t691 * t384 * t874 + 0.125e6 / 0.19683e5 * t2988 + 0.25e2 / 0.108e3 * t2990 - 0.6e1 * t2992 * t2994 - 0.5e2 / 0.27e2 * t2159 * t375 - 0.5e2 / 0.27e2 * t877 * t968 - 0.25e2 / 0.108e3 * t3002;
  t3005 = t1686 * t1120;
  t3008 = t886 * t383;
  t3010 = t350 * t987;
  t3012 = t299 * t1145;
  t3014 = t2694 * t1118;
  t3018 = t1729 * t1142 * t274;
  t3021 = -0.125e3 / 0.162e3 * t3014 + 0.1625e4 / 0.486e3 * t1064 - 0.3125e6 / 0.19683e5 * t3018 + 0.1015625e7 / 0.59049e5 * t1067;
  t3022 = t141 * t3021;
  t3024 = t2500 * t337;
  t3026 = t2503 * t337;
  t3028 = t972 * t849;
  t3030 = t666 * t1138;
  t3033 = t666 * t1146;
  t3036 = t1118 * t290;
  t3037 = t750 * t3036;
  t3038 = t1773 * t3037;
  t3042 = t2176 * t750 * t1118 * t274;
  t3048 = t114 * t874;
  t3049 = t459 * t3048;
  t3056 = t972 * t853;
  t3058 = -0.125e4 / 0.729e3 * t3005 - 0.325e3 / 0.324e3 * t1055 - t281 * t3008 - t281 * t3010 - t281 * t3012 - t281 * t3022 - 0.25e2 / 0.108e3 * t3024 - 0.25e2 / 0.108e3 * t3026 - 0.25e2 / 0.108e3 * t3028 + 0.5e2 / 0.27e2 * t3030 * t276 + 0.5e2 / 0.27e2 * t3033 * t276 + 0.125e4 / 0.729e3 * t3038 - 0.125e4 / 0.243e3 * t3042 + 0.5e2 / 0.27e2 * t1782 * t1124 + 0.5e2 / 0.27e2 * t2203 * t1124 + 0.5e2 / 0.27e2 * t668 * t3049 + 0.5e2 / 0.27e2 * t2222 * t963 + 0.1e5 / 0.729e3 * t2786 * t959 + 0.5e2 / 0.81e2 * t3056;
  t3059 = t3004 + t3058;
  t3064 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t1148 - t2934 - 0.3e1 / 0.8e1 * t6 * t99 * t3059);
  tv3rhosigmatau11 = t7 * t3064 + t1152;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3071 = t6 * t162 * t1179 / 0.8e1;
  t3072 = t1930 * t1154;
  t3075 = t1154 * t201;
  t3076 = t750 * t3075;
  t3082 = t750 * t1154 * t185;
  t3087 = t750 * t1159 * t185;
  t3091 = t459 * t1159 * t201;
  t3099 = t49 * t930;
  t3100 = t459 * t3099;
  t3103 = -0.1e7 / 0.19683e5 * t2584 * t3072 - 0.1e5 / 0.729e3 * t1275 * t3076 + 0.1e5 / 0.729e3 * t1327 * t1156 + 0.1e5 / 0.243e3 * t1942 * t3082 - 0.1e6 / 0.2187e4 * t1085 - 0.2e5 / 0.729e3 * t1275 * t3087 - 0.2e3 / 0.27e2 * t1269 * t3091 + 0.1e3 / 0.27e2 * t1285 * t1160 + 0.1e3 / 0.27e2 * t1965 * t1160 - 0.5e3 / 0.81e2 * t1097 + 0.1e3 / 0.27e2 * t458 * t3100;
  t3104 = t1163 * t1322;
  t3110 = t1268 * t1168;
  t3116 = t210 * t1167;
  t3122 = t456 * t1177;
  t3128 = t210 * t1176;
  t3137 = 0.5e3 / 0.81e2 * t2525 * t1154 - 0.5e4 / 0.243e3 * t1104 + 0.25e7 / 0.19683e5 * t1380 * t1173 * t185 - 0.625e7 / 0.59049e5 * t1107;
  t3138 = t83 * t3137;
  t3140 = 0.5e2 / 0.27e2 * t1321 * t3104 - 0.5e2 / 0.27e2 * t464 * t1164 + 0.5e3 / 0.81e2 * t1095 - 0.1e3 / 0.27e2 * t3110 * t187 - 0.6e1 * t1395 * t1168 * t201 + 0.2e1 * t482 * t3116 + 0.4e1 * t482 * t367 * t930 + 0.5e2 / 0.27e2 * t3122 * t187 + 0.2e1 * t482 * t1177 * t201 - t192 * t3128 - t192 * t3138;
  t3141 = t3103 + t3140;
  t3146 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t1179 - t3071 - 0.3e1 / 0.8e1 * t6 * t28 * t3141);
  tv3rhotau20 = t7 * t3146 + t1183;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3153 = t6 * t228 * t1210 / 0.8e1;
  t3155 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t1210 - t3153);
  tv3rhotau22 = t7 * t3155 + t1214;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3161 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t1179 - t3071);
  tv3rhotau23 = t7 * t3161 + t1183;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3166 = t2139 * t1185;
  t3169 = t1185 * t290;
  t3170 = t750 * t3169;
  t3176 = t750 * t1185 * t274;
  t3181 = t750 * t1190 * t274;
  t3185 = t459 * t1190 * t290;
  t3193 = t114 * t987;
  t3194 = t459 * t3193;
  t3197 = -0.1e7 / 0.19683e5 * t2737 * t3166 - 0.1e5 / 0.729e3 * t1773 * t3170 + 0.1e5 / 0.729e3 * t1686 * t1187 + 0.1e5 / 0.243e3 * t2176 * t3176 - 0.1e6 / 0.2187e4 * t1121 - 0.2e5 / 0.729e3 * t1773 * t3181 - 0.2e3 / 0.27e2 * t1767 * t3185 + 0.1e3 / 0.27e2 * t1782 * t1191 + 0.1e3 / 0.27e2 * t2203 * t1191 - 0.5e3 / 0.81e2 * t1133 + 0.1e3 / 0.27e2 * t668 * t3194;
  t3198 = t1194 * t1663;
  t3204 = t1766 * t1199;
  t3210 = t299 * t1198;
  t3216 = t666 * t1208;
  t3222 = t299 * t1207;
  t3231 = 0.5e3 / 0.81e2 * t2694 * t1185 - 0.5e4 / 0.243e3 * t1140 + 0.25e7 / 0.19683e5 * t1729 * t1204 * t274 - 0.625e7 / 0.59049e5 * t1143;
  t3232 = t141 * t3231;
  t3234 = 0.5e2 / 0.27e2 * t1662 * t3198 - 0.5e2 / 0.27e2 * t673 * t1195 + 0.5e3 / 0.81e2 * t1131 - 0.1e3 / 0.27e2 * t3204 * t276 - 0.6e1 * t1747 * t1199 * t290 + 0.2e1 * t691 * t3210 + 0.4e1 * t691 * t384 * t987 + 0.5e2 / 0.27e2 * t3216 * t276 + 0.2e1 * t691 * t1208 * t290 - t281 * t3222 - t281 * t3232;
  t3235 = t3197 + t3234;
  t3240 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t1210 - t3153 - 0.3e1 / 0.8e1 * t6 * t99 * t3235);
  tv3rhotau25 = t7 * t3240 + t1214;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3242 = 0.1e1 / t1335;
  t3243 = t3242 * t65;
  t3245 = t1351 * t3243;
  t3247 = 0.125e3 / 0.25509168e8 * t1332 * t3243 - 0.125e3 / 0.25509168e8 * t3245;
  t3249 = t790 * t1000;
  t3251 = t3242 * t76;
  t3253 = t1360 * t3251 * t83;
  t3255 = t1015 * t321;
  t3256 = t83 * t3255;
  t3263 = t326 * t1015;
  t3266 = t1032 * t321;
  t3269 = t326 * t1027;
  t3273 = t72 * t3242;
  t3274 = t1380 * t3273;
  t3276 = -0.125e3 / 0.10368e5 * t3243 - 0.78125e5 / 0.314928e6 * t3274;
  t3277 = t83 * t3276;
  t3279 = t999 * t321;
  t3280 = t750 * t3279;
  t3281 = t1275 * t3280;
  t3283 = t1984 * t1008;
  t3285 = t39 * t1027;
  t3286 = t459 * t3285;
  t3287 = t458 * t3286;
  t3289 = t39 * t1015;
  t3290 = t459 * t3289;
  t3291 = t1269 * t3290;
  t3293 = t1840 * t1004;
  t3295 = t450 * t3242;
  t3296 = t1315 * t3295;
  t3297 = t447 * t3296;
  t3299 = t57 * t321;
  t3300 = t2597 * t3299;
  t3301 = t1321 * t3300;
  t3303 = t2601 * t313;
  t3305 = t77 * t3247 - 0.25e2 / 0.288e3 * t3249 + 0.15625e5 / 0.157464e6 * t3253 - 0.6e1 * t1395 * t3256 + 0.6e1 * t482 * t322 * t1027 + 0.125e3 / 0.25509168e8 * t3245 + 0.6e1 * t482 * t3263 - 0.3e1 * t192 * t3266 - 0.3e1 * t192 * t3269 - t192 * t3277 - 0.625e3 / 0.972e3 * t3281 - 0.25e2 / 0.18e2 * t3283 - 0.25e2 / 0.36e2 * t3287 + 0.25e2 / 0.18e2 * t3291 + 0.625e3 / 0.972e3 * t3293 - 0.625e3 / 0.7776e4 * t3297 + 0.25e2 / 0.288e3 * t3301 + 0.25e2 / 0.36e2 * t3303;
  t3309 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3305);
  tv3sigma30 = t7 * t3309;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3310 = 0.1e1 / t1694;
  t3311 = t3310 * t134;
  t3313 = t1759 * t3311 * t141;
  t3315 = t1057 * t345;
  t3316 = t141 * t3315;
  t3322 = t3310 * t65;
  t3323 = t1710 * t3322;
  t3325 = t350 * t1057;
  t3328 = t1074 * t345;
  t3331 = t350 * t1069;
  t3335 = t72 * t3310;
  t3336 = t1729 * t3335;
  t3338 = -0.125e3 / 0.10368e5 * t3322 - 0.78125e5 / 0.314928e6 * t3336;
  t3339 = t141 * t3338;
  t3343 = 0.125e3 / 0.25509168e8 * t1691 * t3322 - 0.125e3 / 0.25509168e8 * t3323;
  t3345 = t877 * t1042;
  t3347 = t1041 * t345;
  t3348 = t750 * t3347;
  t3349 = t1773 * t3348;
  t3351 = t2222 * t1050;
  t3353 = t104 * t1069;
  t3354 = t459 * t3353;
  t3355 = t668 * t3354;
  t3357 = t104 * t1057;
  t3358 = t459 * t3357;
  t3359 = t1767 * t3358;
  t3361 = t2164 * t1046;
  t3363 = t450 * t3310;
  t3364 = t1656 * t3363;
  t3365 = t659 * t3364;
  t3367 = t57 * t345;
  t3368 = t2744 * t3367;
  t3369 = t1662 * t3368;
  t3371 = t2748 * t337;
  t3373 = 0.15625e5 / 0.157464e6 * t3313 - 0.6e1 * t1747 * t3316 + 0.6e1 * t691 * t346 * t1069 + 0.125e3 / 0.25509168e8 * t3323 + 0.6e1 * t691 * t3325 - 0.3e1 * t281 * t3328 - 0.3e1 * t281 * t3331 - t281 * t3339 + t135 * t3343 - 0.25e2 / 0.288e3 * t3345 - 0.625e3 / 0.972e3 * t3349 - 0.25e2 / 0.18e2 * t3351 - 0.25e2 / 0.36e2 * t3355 + 0.25e2 / 0.18e2 * t3359 + 0.625e3 / 0.972e3 * t3361 - 0.625e3 / 0.7776e4 * t3365 + 0.25e2 / 0.288e3 * t3369 + 0.25e2 / 0.36e2 * t3371;
  t3377 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3373);
  tv3sigma39 = t7 * t3377;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3378 = t790 * t1094;
  t3383 = 0.1e1 / t435;
  t3384 = t3383 * t76;
  t3386 = t1360 * t3384 * t83;
  t3397 = t326 * t1109;
  t3400 = t3383 * t65;
  t3402 = t72 * t3383;
  t3403 = t1380 * t3402;
  t3405 = 0.125e3 / 0.1296e4 * t3400 + 0.78125e5 / 0.39366e5 * t3403;
  t3406 = t83 * t3405;
  t3408 = t1032 * t366;
  t3410 = t2905 * t313;
  t3412 = t2908 * t313;
  t3414 = 0.25e2 / 0.54e2 * t3378 - 0.6e1 * t1395 * t367 * t1015 - 0.15625e5 / 0.19683e5 * t3386 + 0.4e1 * t482 * t1102 * t321 + 0.4e1 * t482 * t1110 * t321 + 0.2e1 * t482 * t367 * t1027 - 0.2e1 * t192 * t3397 - t192 * t3406 - t192 * t3408 - 0.25e2 / 0.54e2 * t3410 - 0.25e2 / 0.54e2 * t3412;
  t3415 = t2341 * t1004;
  t3417 = t1082 * t321;
  t3418 = t750 * t3417;
  t3419 = t1275 * t3418;
  t3423 = t49 * t1027;
  t3424 = t459 * t3423;
  t3427 = t312 * t321;
  t3428 = t180 * t3427;
  t3429 = t2252 * t3428;
  t3431 = t49 * t1015;
  t3432 = t459 * t3431;
  t3435 = t366 * t999;
  t3436 = t3435 * t459;
  t3437 = t1321 * t3436;
  t3439 = t1840 * t1084;
  t3441 = t450 * t3383;
  t3442 = t1315 * t3441;
  t3443 = t447 * t3442;
  t3445 = t1093 * t3299;
  t3446 = t1321 * t3445;
  t3450 = -0.625e3 / 0.2916e4 * t3415 + 0.25e4 / 0.729e3 * t3419 + 0.1e3 / 0.27e2 * t1984 * t1088 + 0.5e2 / 0.27e2 * t458 * t3424 + 0.25e2 / 0.27e2 * t3429 - 0.1e3 / 0.27e2 * t1269 * t3432 + 0.25e2 / 0.864e3 * t3437 - 0.25e4 / 0.729e3 * t3439 + 0.625e3 / 0.972e3 * t3443 - 0.25e2 / 0.54e2 * t3446 - 0.5e2 / 0.27e2 * t2601 * t358;
  t3451 = t3414 + t3450;
  t3455 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3451);
  tv3sigma2tau0 = t7 * t3455;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3458 = t114 * t1069;
  t3459 = t459 * t3458;
  t3462 = t3030 * t337;
  t3464 = t3033 * t337;
  t3466 = t2484 * t1046;
  t3468 = t1118 * t345;
  t3469 = t750 * t3468;
  t3470 = t1773 * t3469;
  t3472 = t114 * t1057;
  t3473 = t459 * t3472;
  t3476 = t336 * t345;
  t3477 = t269 * t3476;
  t3478 = t2414 * t3477;
  t3483 = t877 * t1130;
  t3488 = 0.1e3 / 0.27e2 * t2222 * t1124 + 0.5e2 / 0.27e2 * t668 * t3459 - 0.25e2 / 0.54e2 * t3462 - 0.25e2 / 0.54e2 * t3464 - 0.625e3 / 0.2916e4 * t3466 + 0.25e4 / 0.729e3 * t3470 - 0.1e3 / 0.27e2 * t1767 * t3473 + 0.25e2 / 0.27e2 * t3478 - 0.6e1 * t1747 * t384 * t1057 + 0.25e2 / 0.54e2 * t3483 + 0.4e1 * t691 * t1146 * t345;
  t3492 = 0.1e1 / t647;
  t3493 = t3492 * t134;
  t3495 = t1759 * t3493 * t141;
  t3500 = t1074 * t383;
  t3502 = t350 * t1145;
  t3505 = t3492 * t65;
  t3507 = t72 * t3492;
  t3508 = t1729 * t3507;
  t3510 = 0.125e3 / 0.1296e4 * t3505 + 0.78125e5 / 0.39366e5 * t3508;
  t3511 = t141 * t3510;
  t3513 = t2164 * t1120;
  t3515 = t450 * t3492;
  t3516 = t1656 * t3515;
  t3517 = t659 * t3516;
  t3519 = t1129 * t3367;
  t3520 = t1662 * t3519;
  t3524 = t383 * t1041;
  t3525 = t3524 * t459;
  t3526 = t1662 * t3525;
  t3528 = 0.2e1 * t691 * t384 * t1069 - 0.15625e5 / 0.19683e5 * t3495 + 0.4e1 * t691 * t1138 * t345 - t281 * t3500 - 0.2e1 * t281 * t3502 - t281 * t3511 - 0.25e4 / 0.729e3 * t3513 + 0.625e3 / 0.972e3 * t3517 - 0.25e2 / 0.54e2 * t3520 - 0.5e2 / 0.27e2 * t2748 * t375 + 0.25e2 / 0.864e3 * t3526;
  t3529 = t3488 + t3528;
  t3533 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3529);
  tv3sigma2tau11 = t7 * t3533;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3534 = 0.1e1 / t738;
  t3535 = t3534 * t76;
  t3537 = t1360 * t3535 * t83;
  t3539 = t1154 * t321;
  t3540 = t750 * t3539;
  t3545 = t450 * t3534;
  t3546 = t1315 * t3545;
  t3547 = t447 * t3546;
  t3549 = t1082 * t366;
  t3550 = t750 * t3549;
  t3551 = t1275 * t3550;
  t3554 = t459 * t1159 * t321;
  t3559 = t57 * t366;
  t3560 = t1093 * t3559;
  t3561 = t1321 * t3560;
  t3563 = t49 * t1109;
  t3564 = t459 * t3563;
  t3567 = t1163 * t3299;
  t3572 = t3110 * t313;
  t3577 = t326 * t1167;
  t3583 = t3122 * t313;
  t3588 = t326 * t1176;
  t3590 = t3534 * t65;
  t3592 = t72 * t3534;
  t3593 = t1380 * t3592;
  t3595 = -0.125e3 / 0.162e3 * t3590 - 0.3125e6 / 0.19683e5 * t3593;
  t3596 = t83 * t3595;
  t3598 = 0.125e6 / 0.19683e5 * t3537 - 0.1e5 / 0.729e3 * t1275 * t3540 + 0.1e5 / 0.729e3 * t1840 * t1156 - 0.125e4 / 0.243e3 * t3547 + 0.25e4 / 0.729e3 * t3551 - 0.2e3 / 0.27e2 * t1269 * t3554 + 0.1e3 / 0.27e2 * t1984 * t1160 - 0.25e2 / 0.54e2 * t3561 + 0.1e3 / 0.27e2 * t458 * t3564 + 0.5e2 / 0.27e2 * t1321 * t3567 - 0.5e2 / 0.27e2 * t790 * t1164 + 0.25e2 / 0.54e2 * t3572 - 0.6e1 * t1395 * t1168 * t321 + 0.2e1 * t482 * t3577 + 0.4e1 * t482 * t367 * t1109 - 0.25e2 / 0.108e3 * t3583 + 0.2e1 * t482 * t1177 * t321 - t192 * t3588 - t192 * t3596;
  t3602 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3598);
  tv3sigmatau20 = t7 * t3602;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3603 = 0.1e1 / t826;
  t3604 = t3603 * t134;
  t3606 = t1759 * t3604 * t141;
  t3608 = t1185 * t345;
  t3609 = t750 * t3608;
  t3614 = t450 * t3603;
  t3615 = t1656 * t3614;
  t3616 = t659 * t3615;
  t3618 = t1118 * t383;
  t3619 = t750 * t3618;
  t3620 = t1773 * t3619;
  t3623 = t459 * t1190 * t345;
  t3628 = t57 * t383;
  t3629 = t1129 * t3628;
  t3630 = t1662 * t3629;
  t3632 = t114 * t1145;
  t3633 = t459 * t3632;
  t3636 = t1194 * t3367;
  t3641 = t3204 * t337;
  t3646 = t350 * t1198;
  t3652 = t3216 * t337;
  t3657 = t350 * t1207;
  t3659 = t3603 * t65;
  t3661 = t72 * t3603;
  t3662 = t1729 * t3661;
  t3664 = -0.125e3 / 0.162e3 * t3659 - 0.3125e6 / 0.19683e5 * t3662;
  t3665 = t141 * t3664;
  t3667 = 0.125e6 / 0.19683e5 * t3606 - 0.1e5 / 0.729e3 * t1773 * t3609 + 0.1e5 / 0.729e3 * t2164 * t1187 - 0.125e4 / 0.243e3 * t3616 + 0.25e4 / 0.729e3 * t3620 - 0.2e3 / 0.27e2 * t1767 * t3623 + 0.1e3 / 0.27e2 * t2222 * t1191 - 0.25e2 / 0.54e2 * t3630 + 0.1e3 / 0.27e2 * t668 * t3633 + 0.5e2 / 0.27e2 * t1662 * t3636 - 0.5e2 / 0.27e2 * t877 * t1195 + 0.25e2 / 0.54e2 * t3641 - 0.6e1 * t1747 * t1199 * t345 + 0.2e1 * t691 * t3646 + 0.4e1 * t691 * t384 * t1145 - 0.25e2 / 0.108e3 * t3652 + 0.2e1 * t691 * t1208 * t345 - t281 * t3657 - t281 * t3665;
  t3671 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3667);
  tv3sigmatau28 = t7 * t3671;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t3672 = 0.1e1 / t997;
  t3673 = t3672 * t76;
  t3677 = t1154 * t366;
  t3678 = t750 * t3677;
  t3681 = t450 * t3672;
  t3682 = t1315 * t3681;
  t3685 = t49 * t1167;
  t3686 = t459 * t3685;
  t3689 = t1163 * t3559;
  t3692 = t49 * t1176;
  t3693 = t459 * t3692;
  t3696 = t1167 * t366;
  t3697 = t83 * t3696;
  t3705 = t72 * t3672;
  t3708 = 0.5e3 / 0.81e2 * t3672 * t65 + 0.25e7 / 0.19683e5 * t1380 * t3705;
  t3709 = t83 * t3708;
  t3711 = -0.1e7 / 0.19683e5 * t1360 * t3673 * t83 - 0.1e5 / 0.243e3 * t1275 * t3678 + 0.1e5 / 0.243e3 * t447 * t3682 - 0.1e3 / 0.9e1 * t1269 * t3686 + 0.5e2 / 0.9e1 * t1321 * t3689 + 0.5e2 / 0.9e1 * t458 * t3693 - 0.6e1 * t1395 * t3697 + 0.6e1 * t482 * t367 * t1176 - t192 * t3709;
  t3715 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3711);
  tv3tau30 = t7 * t3715;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t3716 = 0.1e1 / t1039;
  t3717 = t3716 * t134;
  t3721 = t1185 * t383;
  t3722 = t750 * t3721;
  t3725 = t450 * t3716;
  t3726 = t1656 * t3725;
  t3729 = t114 * t1198;
  t3730 = t459 * t3729;
  t3733 = t1194 * t3628;
  t3736 = t114 * t1207;
  t3737 = t459 * t3736;
  t3740 = t1198 * t383;
  t3741 = t141 * t3740;
  t3749 = t72 * t3716;
  t3752 = 0.5e3 / 0.81e2 * t3716 * t65 + 0.25e7 / 0.19683e5 * t1729 * t3749;
  t3753 = t141 * t3752;
  t3755 = -0.1e7 / 0.19683e5 * t1759 * t3717 * t141 - 0.1e5 / 0.243e3 * t1773 * t3722 + 0.1e5 / 0.243e3 * t659 * t3726 - 0.1e3 / 0.9e1 * t1767 * t3730 + 0.5e2 / 0.9e1 * t1662 * t3733 + 0.5e2 / 0.9e1 * t668 * t3737 - 0.6e1 * t1747 * t3741 + 0.6e1 * t691 * t384 * t1207 - t281 * t3753;
  t3759 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3755);
  tv3tau33 = t7 * t3759;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t52, t53, t54, t57, t60;
  double t61, t62, t63, t64, t65, t68, t71, t72;
  double t75, t76, t77, t78, t83, t85, t89, t90;
  double t91, t93, t94, t95, t96, t98, t99, t100;
  double t101, t102, t104, t105, t107, t108, t112, t114;
  double t117, t118, t122, t123, t124, t125, t128, t133;
  double t134, t135, t136, t141, t143, t147, tzk0;

  double t148, t149, t150, t152, t155, t156, t160, t161;
  double t162, t165, t166, t167, t169, t170, t171, t172;
  double t174, t175, t176, t178, t179, t180, t185, t186;
  double t187, t190, t191, t192, t193, t197, t198, t201;
  double t202, t204, t206, t207, t210, t212, t217, t218;
  double t220, t223, t224, t228, t231, t233, tvrho0, t237;
  double t240, t241, t246, t248, t251, t252, t256, t258;
  double t259, t260, t261, t263, t264, t265, t267, t268;
  double t269, t274, t275, t276, t279, t280, t281, t282;
  double t286, t287, t290, t291, t293, t295, t296, t299;
  double t301, t306, tvrho1, t309, t310, t312, t313, t314;
  double t316, t318, t319, t321, t322, t326, t328, t332;
  double tvsigma0, tvsigma1, t333, t334, t336, t337, t338, t340;
  double t342, t343, t345, t346, t350, t352, t356, tvsigma2;
  double tvlapl0, tvlapl1, t357, t358, t363, t366, t367, t369;
  double t373, tvtau0, t374, t375, t380, t383, t384, t386;
  double t390, tvtau1;

  double t393, t394, t395, t398, t399, t400, t403, t407;
  double t408, t412, t414, t420, t421, t424, t426, t430;
  double t431, t432, t433, t434, t435, t437, t438, t440;
  double t442, t443, t445, t446, t447, t448, t450, t451;
  double t452, t453, t456, t457, t458, t459, t460, t461;
  double t464, t467, t468, t475, t476, t477, t481, t482;
  double t483, t484, t487, t490, t495, t496, t502, t507;
  double t508, t513, t515, t520, t521, t522, t523, t526;
  double t529, t533, t534, t538, t540, t542, t545, t547;
  double tv2rho20, t550, t554, t558, t559, t563, t565, t573;
  double t574, t578, t582, t583, t587, t589, t596, t599;
  double tv2rho21, t604, t609, t613, t614, t620, t621, t626;
  double t630, t631, t642, t643, t644, t645, t646, t647;
  double t649, t650, t652, t654, t655, t657, t658, t659;
  double t660, t661, t662, t663, t666, t667, t668, t669;
  double t670, t673, t676, t677, t684, t685, t686, t690;
  double t691, t692, t693, t696, t699, t704, t705, t711;
  double t716, t717, t722, t724, t729, tv2rho22, t737, t738;
  double t740, t742, t744, t745, t747, t748, t749, t750;
  double t751, t752, t753, t755, t756, t757, t759, t761;
  double t762, t763, t765, t766, t767, t769, t775, t777;
  double t779, t782, t784, t785, t787, t788, t790, t799;
  double t801, t806, tv2rhosigma0, tv2rhosigma1, t813, t815, tv2rhosigma2, t821;
  double tv2rhosigma3, tv2rhosigma4, t826, t828, t830, t832, t833, t835;
  double t836, t837, t838, t839, t840, t842, t843, t844;
  double t846, t848, t849, t850, t852, t853, t854, t856;
  double t862, t864, t866, t869, t871, t872, t874, t875;
  double t877, t886, t888, t893, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2;
  double tv2rholapl3, t900, t901, t902, t905, t906, t911, t915;
  double t921, t930, t931, t933, t938, tv2rhotau0, t945, t947;
  double tv2rhotau1, t953, tv2rhotau2, t958, t959, t962, t963, t968;
  double t972, t978, t987, t988, t990, t995, tv2rhotau3, t997;
  double t999, t1000, t1001, t1003, t1004, t1005, t1007, t1008;
  double t1009, t1011, t1013, t1015, t1016, t1019, t1022, t1024;
  double t1025, t1027, t1028, t1032, t1034, t1038, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t1039, t1041, t1042, t1043, t1045;
  double t1046, t1047, t1049, t1050, t1051, t1053, t1055, t1057;
  double t1058, t1061, t1064, t1066, t1067, t1069, t1070, t1074;
  double t1076, t1080, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4;
  double tv2sigmalapl5, t1082, t1083, t1084, t1085, t1087, t1088, t1093;
  double t1094, t1095, t1097, t1099, t1102, t1104, t1106, t1107;
  double t1109, t1110, t1112, t1116, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3;
  double tv2sigmatau4, t1118, t1119, t1120, t1121, t1123, t1124, t1129;
  double t1130, t1131, t1133, t1135, t1138, t1140, t1142, t1143;
  double t1145, t1146, t1148, t1152, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22;
  double tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1154, t1155, t1156, t1159;
  double t1160, t1163, t1164, t1167, t1168, t1173, t1176, t1177;
  double t1179, t1183, tv2tau20, tv2tau21, t1185, t1186, t1187, t1190;
  double t1191, t1194, t1195, t1198, t1199, t1204, t1207, t1208;
  double t1210, t1214, tv2tau22;

  double t1218, t1219, t1222, t1225, t1226, t1227, t1230, t1234;
  double t1235, t1239, t1241, t1246, t1248, t1251, t1257, t1258;
  double t1261, t1263, t1266, t1268, t1269, t1274, t1275, t1277;
  double t1280, t1281, t1284, t1285, t1289, t1296, t1301, t1307;
  double t1310, t1311, t1312, t1315, t1316, t1318, t1321, t1322;
  double t1323, t1326, t1327, t1330, t1332, t1333, t1334, t1335;
  double t1336, t1337, t1338, t1342, t1343, t1346, t1349, t1351;
  double t1353, t1355, t1357, t1358, t1360, t1361, t1368, t1371;
  double t1380, t1390, t1391, t1393, t1394, t1395, t1396, t1397;
  double t1400, t1405, t1406, t1411, t1413, t1414, t1417, t1420;
  double t1423, t1427, t1428, t1432, t1434, t1436, t1438, t1440;
  double t1443, t1445, tv3rho30, t1448, t1449, t1450, t1453, t1458;
  double t1459, t1461, t1465, t1466, t1470, t1473, t1477, t1479;
  double t1483, t1492, t1493, t1494, t1497, t1502, t1504, t1508;
  double t1509, t1513, t1516, t1517, t1519, t1528, t1530, t1533;
  double tv3rho31, t1536, t1541, t1545, t1549, t1550, t1554, t1556;
  double t1565, t1566, t1571, t1575, t1579, t1580, t1584, t1586;
  double t1593, t1601, t1603, t1604, tv3rho32, t1609, t1616, t1620;
  double t1621, t1628, t1629, t1636, t1640, t1641, t1656, t1657;
  double t1659, t1662, t1663, t1664, t1667, t1672, t1678, t1681;
  double t1682, t1683, t1686, t1689, t1691, t1692, t1693, t1694;
  double t1695, t1696, t1697, t1701, t1702, t1705, t1708, t1710;
  double t1712, t1714, t1716, t1717, t1719, t1724, t1729, t1739;
  double t1740, t1742, t1745, t1746, t1747, t1748, t1749, t1752;
  double t1753, t1759, t1760, t1766, t1767, t1772, t1773, t1775;
  double t1778, t1781, t1782, t1786, t1793, t1794, t1799, tv3rho33;
  double t1807, t1814, t1816, t1818, t1820, t1824, t1825, t1827;
  double t1829, t1831, t1832, t1833, t1835, t1840, t1843, t1845;
  double t1846, t1849, t1850, t1851, t1853, t1855, t1856, t1860;
  double t1863, t1867, t1869, t1871, t1872, t1874, t1876, t1879;
  double t1880, t1882, t1883, t1885, t1886, t1888, t1891, t1894;
  double t1897, t1899, t1900, t1902, t1903, t1905, t1908, t1911;
  double t1916, t1929, t1930, t1931, t1932, t1935, t1938, t1939;
  double t1940, t1942, t1943, t1944, t1945, t1947, t1948, t1952;
  double t1953, t1955, t1956, t1957, t1959, t1960, t1962, t1964;
  double t1965, t1966, t1969, t1970, t1972, t1975, t1980, t1983;
  double t1984, t1987, t1989, t1994, tv3rho2sigma0, tv3rho2sigma1, t2001, t2005;
  double t2007, tv3rho2sigma2, t2013, t2021, tv3rho2sigma3, tv3rho2sigma4, t2027, t2034;
  double t2037, tv3rho2sigma5, t2045, tv3rho2sigma6, tv3rho2sigma7, t2057, t2058, t2060;
  double t2062, t2065, t2068, t2069, t2071, t2072, t2074, t2075;
  double t2077, t2080, t2083, t2086, t2088, t2089, t2091, t2092;
  double t2094, t2097, t2099, t2102, t2104, t2106, t2107, t2111;
  double t2114, t2118, t2120, t2122, t2123, t2138, t2139, t2140;
  double t2141, t2146, t2149, t2151, t2153, t2155, t2156, t2157;
  double t2159, t2164, t2167, t2169, t2170, t2172, t2173, t2174;
  double t2176, t2177, t2178, t2179, t2181, t2182, t2185, t2186;
  double t2190, t2191, t2193, t2194, t2195, t2197, t2198, t2200;
  double t2202, t2203, t2204, t2207, t2208, t2210, t2213, t2218;
  double t2221, t2222, t2225, t2227, t2232, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1;
  double tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2239, t2246, t2248, t2252;
  double t2256, t2265, t2277, t2278, t2280, t2282, t2297, t2300;
  double t2302, t2309, t2312, t2313, t2317, t2322, t2330, t2333;
  double t2336, t2341, t2344, t2345, t2350, tv3rho2tau0, t2357, t2361;
  double t2363, tv3rho2tau1, t2369, t2377, tv3rho2tau2, t2383, t2390, t2393;
  double tv3rho2tau3, t2401, tv3rho2tau4, t2414, t2418, t2424, t2426, t2432;
  double t2444, t2445, t2459, t2462, t2467, t2471, t2474, t2475;
  double t2479, t2484, t2489, t2497, t2500, t2503, t2506, t2507;
  double t2512, tv3rho2tau5, t2519, t2520, t2523, t2525, t2526, t2528;
  double t2531, t2533, t2534, t2536, t2537, t2539, t2541, t2544;
  double t2548, t2549, t2552, t2553, t2555, t2556, t2557, t2558;
  double t2561, t2565, t2567, t2568, t2582, t2584, t2585, t2586;
  double t2588, t2590, t2591, t2594, t2595, t2597, t2598, t2599;
  double t2601, t2604, t2606, t2608, t2610, t2611, t2612, t2614;
  double t2616, t2618, t2619, t2620, t2622, t2624, t2625, t2626;
  double t2628, t2631, t2634, t2637, t2639, t2641, t2642, t2643;
  double t2645, t2646, t2651, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2658, t2660, tv3rhosigma25, t2666, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2671, t2672, t2673, t2674, t2677, t2681, t2683;
  double t2684, t2686, t2689, t2692, t2694, t2695, t2697, t2700;
  double t2702, t2703, t2705, t2706, t2708, t2710, t2714, t2715;
  double t2718, t2719, t2733, t2735, t2737, t2738, t2739, t2741;
  double t2742, t2744, t2745, t2746, t2748, t2752, t2753, t2755;
  double t2757, t2759, t2761, t2764, t2767, t2768, t2769, t2772;
  double t2773, t2775, t2777, t2779, t2780, t2781, t2783, t2785;
  double t2786, t2787, t2789, t2792, t2793, t2794, t2796, t2797;
  double t2802, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5;
  double tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t2809, t2810;
  double t2812, t2814, t2818, t2821, t2822, t2824, t2828, t2832;
  double t2835, t2836, t2837, t2839, t2841, t2842, t2844, t2845;
  double t2846, t2866, t2867, t2869, t2871, t2872, t2873, t2874;
  double t2877, t2878, t2880, t2891, t2892, t2899, t2901, t2903;
  double t2905, t2908, t2911, t2912, t2913, t2916, t2917, t2919;
  double t2921, t2922, t2927, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4;
  double t2934, t2936, tv3rhosigmatau5, t2942, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9;
  double tv3rhosigmatau10, t2948, t2949, t2950, t2952, t2954, t2955, t2957;
  double t2958, t2959, t2963, t2967, t2987, t2988, t2990, t2992;
  double t2993, t2994, t3001, t3002, t3004, t3005, t3008, t3010;
  double t3012, t3014, t3018, t3021, t3022, t3024, t3026, t3028;
  double t3030, t3033, t3036, t3037, t3038, t3042, t3048, t3049;
  double t3056, t3058, t3059, t3064, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22;
  double tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t3071, t3072, t3075, t3076, t3082;
  double t3087, t3091, t3099, t3100, t3103, t3104, t3110, t3116;
  double t3122, t3128, t3137, t3138, t3140, t3141, t3146, tv3rhotau20;
  double tv3rhotau21, t3153, t3155, tv3rhotau22, t3161, tv3rhotau23, tv3rhotau24, t3166;
  double t3169, t3170, t3176, t3181, t3185, t3193, t3194, t3197;
  double t3198, t3204, t3210, t3216, t3222, t3231, t3232, t3234;
  double t3235, t3240, tv3rhotau25, t3242, t3243, t3245, t3247, t3249;
  double t3251, t3253, t3255, t3256, t3263, t3266, t3269, t3273;
  double t3274, t3276, t3277, t3279, t3280, t3281, t3283, t3285;
  double t3286, t3287, t3289, t3290, t3291, t3293, t3295, t3296;
  double t3297, t3299, t3300, t3301, t3303, t3305, t3309, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t3310, t3311, t3313, t3315, t3316, t3322, t3323, t3325;
  double t3328, t3331, t3335, t3336, t3338, t3339, t3343, t3345;
  double t3347, t3348, t3349, t3351, t3353, t3354, t3355, t3357;
  double t3358, t3359, t3361, t3363, t3364, t3365, t3367, t3368;
  double t3369, t3371, t3373, t3377, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double tv3sigma2lapl11, t3378, t3383, t3384, t3386, t3397, t3400, t3402;
  double t3403, t3405, t3406, t3408, t3410, t3412, t3414, t3415;
  double t3417, t3418, t3419, t3423, t3424, t3427, t3428, t3429;
  double t3431, t3432, t3435, t3436, t3437, t3439, t3441, t3442;
  double t3443, t3445, t3446, t3450, t3451, t3455, tv3sigma2tau0, tv3sigma2tau1;
  double tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9;
  double tv3sigma2tau10, t3458, t3459, t3462, t3464, t3466, t3468, t3469;
  double t3470, t3472, t3473, t3476, t3477, t3478, t3483, t3488;
  double t3492, t3493, t3495, t3500, t3502, t3505, t3507, t3508;
  double t3510, t3511, t3513, t3515, t3516, t3517, t3519, t3520;
  double t3524, t3525, t3526, t3528, t3529, t3533, tv3sigma2tau11, tv3sigmalapl20;
  double tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, t3534, t3535, t3537, t3539;
  double t3540, t3545, t3546, t3547, t3549, t3550, t3551, t3554;
  double t3559, t3560, t3561, t3563, t3564, t3567, t3572, t3577;
  double t3583, t3588, t3590, t3592, t3593, t3595, t3596, t3598;
  double t3602, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26;
  double tv3sigmatau27, t3603, t3604, t3606, t3608, t3609, t3614, t3615;
  double t3616, t3618, t3619, t3620, t3623, t3628, t3629, t3630;
  double t3632, t3633, t3636, t3641, t3646, t3652, t3657, t3659;
  double t3661, t3662, t3664, t3665, t3667, t3671, tv3sigmatau28, tv3lapl30;
  double tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t3672;
  double t3673, t3677, t3678, t3681, t3682, t3685, t3686, t3689;
  double t3692, t3693, t3696, t3697, t3705, t3708, t3709, t3711;
  double t3715, tv3tau30, tv3tau31, tv3tau32, t3716, t3717, t3721, t3722;
  double t3725, t3726, t3729, t3730, t3733, t3736, t3737, t3740;
  double t3741, t3749, t3752, t3753, t3755, t3759, tv3tau33;

  double t3763, t3767, t3770, t3774, t3778, t3784, t3787, t3790;
  double t3795, t3796, t3801, t3804, t3806, t3811, t3815, t3816;
  double t3822, t3824, t3826, t3828, t3830, t3836, t3837, t3838;
  double t3841, t3846, t3855, t3866, t3867, t3873, t3874, t3877;
  double t3880, t3891, t3898, t3899, t3903, t3917, t3922, t3950;
  double t3958, t3961, t3974, t3975, t3990, t3991, t4004, t4026;
  double t4037, t4040, t4046, t4048, t4049, t4055, t4061, t4062;
  double t4065, t4069, t4078, t4084, t4086, t4088, t4089, t4090;
  double t4092, t4093, t4099, t4104, t4107, t4111, t4118, t4122;
  double t4126, t4131, t4133, tv4rho40, t4140, t4144, t4145, t4148;
  double t4154, t4160, t4161, t4163, t4184, t4185, t4187, t4191;
  double t4205, t4206, t4223, t4225, t4229, t4236, t4240, t4241;
  double t4244, t4253, t4256, t4257, t4259, t4261, t4262, tv4rho41;
  double t4271, t4275, t4290, t4303, t4307, t4316, t4327, t4328;
  double t4337, t4350, t4354, t4361, t4365, t4374, t4377, t4388;
  double t4391, t4393, t4394, tv4rho42, t4415, t4419, t4426, t4437;
  double t4438, t4455, t4459, t4466, t4474, t4483, t4493, t4495;
  double t4496, tv4rho43, t4501, t4506, t4513, t4517, t4526, t4540;
  double t4541, t4545, t4551, t4554, t4560, t4563, t4566, t4567;
  double t4601, t4602, t4607, t4610, t4612, t4617, t4620, t4626;
  double t4628, t4630, t4632, t4634, t4647, t4651, t4652, t4653;
  double t4665, t4682, t4688, t4694, t4706, t4713, t4714, t4723;
  double t4736, t4739, t4740, t4749, t4750, t4765, t4770, t4780;
  double t4783, t4789, t4794, t4801, t4805, t4819, t4820, tv4rho44;
  double t4828, t4834, t4837, t4844, t4846, t4849, t4855, t4859;
  double t4863, t4866, t4870, t4872, t4874, t4876, t4902, t4905;
  double t4908, t4919, t4935, t4940, t4944, t4949, t4950, t4953;
  double t4975, t4981, t4985, t4992, t5017, t5033, t5061, t5074;
  double t5078, t5082, t5086, t5087, t5091, t5092, t5107, t5113;
  double t5116, t5136, t5143, t5163, t5166, t5180, t5184, t5215;
  double t5220, t5235, t5238, t5246, tv4rho3sigma0, tv4rho3sigma1, t5253, t5256;
  double t5260, t5262, tv4rho3sigma2, t5264, t5270, t5275, t5279, t5288;
  double t5289, tv4rho3sigma3, tv4rho3sigma4, t5291, t5297, t5299, t5308, t5310;
  double t5313, tv4rho3sigma5, t5319, t5328, tv4rho3sigma6, tv4rho3sigma7, t5334, t5341;
  double t5349, t5351, t5352, tv4rho3sigma8, t5361, tv4rho3sigma9, tv4rho3sigma10, t5382;
  double t5386, t5390, t5393, t5397, t5399, t5401, t5403, t5408;
  double t5414, t5421, t5437, t5440, t5443, t5454, t5470, t5476;
  double t5488, t5491, t5514, t5520, t5524, t5528, t5533, t5537;
  double t5538, t5558, t5576, t5584, t5599, t5639, t5642, t5646;
  double t5651, t5654, t5672, t5697, t5702, t5720, t5731, t5736;
  double t5754, t5765, t5773, tv4rho3sigma11, tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3;
  double tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7, t5780, t5786, t5789, t5796;
  double t5798, t5801, t5808, t5825, t5870, t5873, t5882, t5899;
  double t5902, t5905, t5920, t5930, t5952, t5980, t5983, t5984;
  double t5987, t6000, t6006, t6013, t6026, t6034, tv4rho3tau0, t6041;
  double t6044, t6048, t6050, tv4rho3tau1, t6052, t6058, t6063, t6067;
  double t6076, t6077, tv4rho3tau2, t6079, t6085, t6087, t6096, t6098;
  double t6101, tv4rho3tau3, t6107, t6116, tv4rho3tau4, t6122, t6129, t6137;
  double t6139, t6140, tv4rho3tau5, t6149, tv4rho3tau6, t6188, t6198, t6216;
  double t6219, t6224, t6227, t6230, t6243, t6246, t6257, t6266;
  double t6271, t6283, t6291, t6294, t6307, t6338, t6346, t6387;
  double t6395, tv4rho3tau7, t6402, t6409, t6411, t6418, t6432, t6441;
  double t6442, t6443, t6450, t6453, t6456, t6460, t6462, t6464;
  double t6480, t6499, t6503, t6511, t6520, t6529, t6569, t6570;
  double t6575, t6588, t6618, t6650, t6660, t6698, t6704, t6708;
  double t6716, t6728, t6764, t6765, t6777, t6798, t6806, tv4rho2sigma20;
  double tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t6813, t6817, t6819, tv4rho2sigma25;
  double t6825, t6833, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t6839;
  double t6846, t6849, tv4rho2sigma211, t6857, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215;
  double tv4rho2sigma216, t6871, t6884, t6922, t6925, t6928, t6932, t6934;
  double t6936, t6945, t6970, t6986, t7007, t7011, t7027, t7047;
  double t7052, t7076, t7106, t7119, t7138, t7153, t7157, t7165;
  double t7168, t7173, t7196, t7197, t7209, t7210, t7217, t7236;
  double t7239, t7250, t7258, tv4rho2sigma217, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3;
  double tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11;
  double tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, tv4rho2sigmalapl17, t7265, t7272;
  double t7274, t7318, t7335, t7340, t7345, t7348, t7351, t7354;
  double t7361, t7391, t7402, t7454, t7468, t7471, t7504, t7537;
  double t7559, t7582, t7594, t7633, t7641, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2;
  double tv4rho2sigmatau3, tv4rho2sigmatau4, t7648, t7652, t7654, tv4rho2sigmatau5, t7660, t7668;
  double tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, t7674, t7681, t7684;
  double tv4rho2sigmatau11, t7692, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t7742;
  double t7770, t7773, t7776, t7779, t7782, t7791, t7829, t7830;
  double t7835, t7885, t7898, t7928, t7933, t7992, t8025, t8033;
  double t8040, t8062, t8070, tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21, tv4rho2lapl22, tv4rho2lapl23;
  double tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2;
  double tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10;
  double tv4rho2lapltau11, t8077, t8084, t8086, t8138, t8148, t8171, t8176;
  double t8179, t8182, t8187, t8204, t8206, t8213, t8262, t8297;
  double t8304, tv4rho2tau20, tv4rho2tau21, t8311, t8315, t8317, tv4rho2tau22, t8323;
  double t8331, tv4rho2tau23, tv4rho2tau24, t8337, t8344, t8347, tv4rho2tau25, t8355;
  double tv4rho2tau26, tv4rho2tau27, t8366, t8412, t8417, t8420, t8423, t8424;
  double t8429, t8457, t8464, t8483, t8533, t8537, t8576, t8583;
  double tv4rho2tau28, t8590, t8624, t8647, t8658, t8677, t8681, t8685;
  double t8688, t8691, t8694, t8697, t8714, t8773, t8774, t8780;
  double t8786, t8791, t8798, t8801, t8810, t8818, t8836, t8845;
  double t8852, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, t8859, t8861, tv4rhosigma39, t8867, tv4rhosigma310, tv4rhosigma311;
  double tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t8873;
  double t8906, t8909, t8920, t8924, t8928, t8931, t8934, t8937;
  double t8972, t8995, t8996, t8999, t9023, t9031, t9047, t9058;
  double t9062, t9065, t9080, t9082, t9126, t9133, tv4rhosigma319, tv4rhosigma2lapl0;
  double tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8;
  double tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16;
  double tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, t9140;
  double t9179, t9204, t9222, t9259, t9276, t9296, t9338, t9353;
  double t9368, t9402, t9409, t9412, t9415, t9444, t9452, tv4rhosigma2tau0;
  double tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8;
  double tv4rhosigma2tau9, tv4rhosigma2tau10, t9459, t9461, tv4rhosigma2tau11, t9467, tv4rhosigma2tau12, tv4rhosigma2tau13;
  double tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21;
  double tv4rhosigma2tau22, t9512, t9553, t9592, t9629, t9669, t9690, t9702;
  double t9707, t9739, t9752, t9755, t9758, t9775, t9783, tv4rhosigma2tau23;
  double tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27;
  double tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215;
  double tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5;
  double tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13;
  double tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21;
  double tv4rhosigmalapltau22, tv4rhosigmalapltau23, t9790, t9818, t9857, t9884, t9895, t9932;
  double t9954, t9962, t9987, t9990, t9998, t10001, t10020, t10021;
  double t10033, t10054, t10062, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24;
  double tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, t10069, t10071, tv4rhosigmatau28, t10077, tv4rhosigmatau29;
  double tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, t10116;
  double t10149, t10190, t10215, t10224, t10239, t10263, t10288, t10291;
  double t10297, t10310, t10323, t10326, t10341, t10345, t10353, tv4rhosigmatau217;
  double tv4rholapl30, tv4rholapl31, tv4rholapl32, tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37;
  double tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7;
  double tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23;
  double tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211;
  double t10360, t10395, t10434, t10447, t10450, t10462, t10467, t10470;
  double t10490, t10497, tv4rhotau30, tv4rhotau31, tv4rhotau32, t10504, t10506, tv4rhotau33;
  double t10512, tv4rhotau34, tv4rhotau35, tv4rhotau36, t10587, t10589, t10603, t10606;
  double t10612, t10621, t10640, t10646, t10653, tv4rhotau37, t10655, t10659;
  double t10682, t10700, t10701, t10704, t10705, t10707, t10712, t10746;
  double t10751, t10755, t10761, t10766, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43;
  double tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411;
  double tv4sigma412, tv4sigma413, t10767, t10783, t10803, t10808, t10809, t10811;
  double t10815, t10816, t10825, t10854, t10858, t10864, t10873, t10878;
  double tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6;
  double tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14;
  double tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, t10889, t10919, t10954;
  double t10988, t11023, t11029, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4;
  double tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12;
  double tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, t11031, t11070;
  double t11106, t11140, t11175, t11181, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22;
  double tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210;
  double tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0;
  double tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8;
  double tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16;
  double tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, t11211;
  double t11223, t11234, t11263, t11288, t11301, t11344, t11348, t11354;
  double tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27;
  double tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215;
  double tv4sigma2tau216, t11384, t11396, t11405, t11438, t11452, t11477, t11493;
  double t11521, t11527, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34;
  double tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0;
  double tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8;
  double tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16;
  double tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26;
  double tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214;
  double tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, t11552, t11586, t11630, t11640, t11646;
  double t11651, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36;
  double tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t11676, t11711, t11753, t11762;
  double t11770, t11775, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44;
  double tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7;
  double tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27;
  double tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36;
  double tv4lapltau37, t11787, t11794, t11834, t11838, tv4tau40, tv4tau41, tv4tau42;
  double tv4tau43, t11850, t11857, t11897, t11901, tv4tau44;

  mgga_x_ms_params *params;

  assert(p->params != NULL);
  params = (mgga_x_ms_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t52 = tau[0] * t49 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t57 = 0.1e1 / t31 / t30;
  t60 = 0.1e1 - 0.25e2 / 0.81e2 * t53 * t54 * t57;
  t61 = t60 * t60;
  t62 = t61 * t60;
  t63 = t53 * t52;
  t64 = t30 * t30;
  t65 = 0.1e1 / t64;
  t68 = t53 * t53;
  t71 = t64 * t64;
  t72 = 0.1e1 / t71;
  t75 = 0.1e1 + 0.25e3 / 0.243e3 * t63 * t65 + 0.625e5 / 0.59049e5 * params->b * t68 * t53 * t72;
  t76 = 0.1e1 / t75;
  t77 = t62 * t76;
  t78 = params->kappa + t42 + params->c;
  t83 = params->kappa * (0.1e1 - params->kappa / t78) - t47;
  t85 = t77 * t83 + t47 + 0.1e1;
  t89 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t85);
  t90 = rho[1] <= p->dens_threshold;
  t91 = -t17;
  t93 = my_piecewise5(t15, t12, t11, t16, t91 * t8);
  t94 = 0.1e1 + t93;
  t95 = t94 <= p->zeta_threshold;
  t96 = POW_1_3(t94);
  t98 = my_piecewise3(t95, t23, t96 * t94);
  t99 = t98 * t27;
  t100 = rho[1] * rho[1];
  t101 = POW_1_3(rho[1]);
  t102 = t101 * t101;
  t104 = 0.1e1 / t102 / t100;
  t105 = sigma[2] * t104;
  t107 = 0.5e1 / 0.972e3 * t34 * t105;
  t108 = params->kappa + t107;
  t112 = params->kappa * (0.1e1 - params->kappa / t108);
  t114 = 0.1e1 / t102 / rho[1];
  t117 = tau[1] * t114 - t105 / 0.8e1;
  t118 = t117 * t117;
  t122 = 0.1e1 - 0.25e2 / 0.81e2 * t118 * t54 * t57;
  t123 = t122 * t122;
  t124 = t123 * t122;
  t125 = t118 * t117;
  t128 = t118 * t118;
  t133 = 0.1e1 + 0.25e3 / 0.243e3 * t125 * t65 + 0.625e5 / 0.59049e5 * params->b * t128 * t118 * t72;
  t134 = 0.1e1 / t133;
  t135 = t124 * t134;
  t136 = params->kappa + t107 + params->c;
  t141 = params->kappa * (0.1e1 - params->kappa / t136) - t112;
  t143 = t135 * t141 + t112 + 0.1e1;
  t147 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t143);
  tzk0 = t89 + t147;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t148 = t7 * t7;
  t149 = 0.1e1 / t148;
  t150 = t17 * t149;
  t152 = my_piecewise5(t11, 0, t15, 0, t8 - t150);
  t155 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t152);
  t156 = t155 * t27;
  t160 = t27 * t27;
  t161 = 0.1e1 / t160;
  t162 = t26 * t161;
  t165 = t6 * t162 * t85 / 0.8e1;
  t166 = params->kappa * params->kappa;
  t167 = t43 * t43;
  t169 = t166 / t167;
  t170 = t169 * t29;
  t171 = t33 * sigma[0];
  t172 = t35 * rho[0];
  t174 = 0.1e1 / t37 / t172;
  t175 = t171 * t174;
  t176 = t170 * t175;
  t178 = t61 * t76;
  t179 = t178 * t83;
  t180 = t52 * t54;
  t185 = -0.5e1 / 0.3e1 * tau[0] * t39 + sigma[0] * t174 / 0.3e1;
  t186 = t57 * t185;
  t187 = t180 * t186;
  t190 = t75 * t75;
  t191 = 0.1e1 / t190;
  t192 = t62 * t191;
  t193 = t53 * t65;
  t197 = params->b * t68 * t52;
  t198 = t72 * t185;
  t201 = 0.25e3 / 0.81e2 * t193 * t185 + 0.125e6 / 0.19683e5 * t197 * t198;
  t202 = t83 * t201;
  t204 = t78 * t78;
  t206 = t166 / t204;
  t207 = t206 * t29;
  t210 = -0.1e2 / 0.729e3 * t207 * t175 + 0.1e2 / 0.729e3 * t176;
  t212 = -0.1e2 / 0.729e3 * t176 - 0.5e2 / 0.27e2 * t179 * t187 - t192 * t202 + t77 * t210;
  t217 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t85 - t165 - 0.3e1 / 0.8e1 * t6 * t28 * t212);
  t218 = t91 * t149;
  t220 = my_piecewise5(t15, 0, t11, 0, -t8 - t218);
  t223 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t220);
  t224 = t223 * t27;
  t228 = t98 * t161;
  t231 = t6 * t228 * t143 / 0.8e1;
  t233 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t143 - t231);
  tvrho0 = t89 + t147 + t7 * (t217 + t233);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t237 = my_piecewise5(t11, 0, t15, 0, -t8 - t150);
  t240 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t237);
  t241 = t240 * t27;
  t246 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t85 - t165);
  t248 = my_piecewise5(t15, 0, t11, 0, t8 - t218);
  t251 = my_piecewise3(t95, 0, 0.4e1 / 0.3e1 * t96 * t248);
  t252 = t251 * t27;
  t256 = t108 * t108;
  t258 = t166 / t256;
  t259 = t258 * t29;
  t260 = t33 * sigma[2];
  t261 = t100 * rho[1];
  t263 = 0.1e1 / t102 / t261;
  t264 = t260 * t263;
  t265 = t259 * t264;
  t267 = t123 * t134;
  t268 = t267 * t141;
  t269 = t117 * t54;
  t274 = -0.5e1 / 0.3e1 * tau[1] * t104 + sigma[2] * t263 / 0.3e1;
  t275 = t57 * t274;
  t276 = t269 * t275;
  t279 = t133 * t133;
  t280 = 0.1e1 / t279;
  t281 = t124 * t280;
  t282 = t118 * t65;
  t286 = params->b * t128 * t117;
  t287 = t72 * t274;
  t290 = 0.25e3 / 0.81e2 * t282 * t274 + 0.125e6 / 0.19683e5 * t286 * t287;
  t291 = t141 * t290;
  t293 = t136 * t136;
  t295 = t166 / t293;
  t296 = t295 * t29;
  t299 = -0.1e2 / 0.729e3 * t296 * t264 + 0.1e2 / 0.729e3 * t265;
  t301 = -0.1e2 / 0.729e3 * t265 - 0.5e2 / 0.27e2 * t268 * t276 - t281 * t291 + t135 * t299;
  t306 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t143 - t231 - 0.3e1 / 0.8e1 * t6 * t99 * t301);
  tvrho1 = t89 + t147 + t7 * (t246 + t306);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t309 = t34 * t39;
  t310 = t169 * t309;
  t312 = t57 * t39;
  t313 = t180 * t312;
  t314 = t179 * t313;
  t316 = t193 * t39;
  t318 = t72 * t39;
  t319 = t197 * t318;
  t321 = -0.125e3 / 0.324e3 * t316 - 0.15625e5 / 0.19683e5 * t319;
  t322 = t83 * t321;
  t326 = 0.5e1 / 0.972e3 * t206 * t309 - 0.5e1 / 0.972e3 * t310;
  t328 = 0.5e1 / 0.972e3 * t310 + 0.25e2 / 0.108e3 * t314 - t192 * t322 + t77 * t326;
  t332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t328);
  tvsigma0 = t7 * t332;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t333 = t34 * t104;
  t334 = t258 * t333;
  t336 = t57 * t104;
  t337 = t269 * t336;
  t338 = t268 * t337;
  t340 = t282 * t104;
  t342 = t72 * t104;
  t343 = t286 * t342;
  t345 = -0.125e3 / 0.324e3 * t340 - 0.15625e5 / 0.19683e5 * t343;
  t346 = t141 * t345;
  t350 = 0.5e1 / 0.972e3 * t295 * t333 - 0.5e1 / 0.972e3 * t334;
  t352 = 0.5e1 / 0.972e3 * t334 + 0.25e2 / 0.108e3 * t338 - t281 * t346 + t135 * t350;
  t356 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t352);
  tvsigma2 = t7 * t356;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t357 = t57 * t49;
  t358 = t180 * t357;
  t363 = t72 * t49;
  t366 = 0.25e3 / 0.81e2 * t193 * t49 + 0.125e6 / 0.19683e5 * t197 * t363;
  t367 = t83 * t366;
  t369 = -0.5e2 / 0.27e2 * t179 * t358 - t192 * t367;
  t373 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t369);
  tvtau0 = t7 * t373;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t374 = t57 * t114;
  t375 = t269 * t374;
  t380 = t72 * t114;
  t383 = 0.25e3 / 0.81e2 * t282 * t114 + 0.125e6 / 0.19683e5 * t286 * t380;
  t384 = t141 * t383;
  t386 = -0.5e2 / 0.27e2 * t268 * t375 - t281 * t384;
  t390 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t386);
  tvtau1 = t7 * t390;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t393 = t24 * t24;
  t394 = 0.1e1 / t393;
  t395 = t152 * t152;
  t398 = t148 * t7;
  t399 = 0.1e1 / t398;
  t400 = t17 * t399;
  t403 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t149 + 0.2e1 * t400);
  t407 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t394 * t395 + 0.4e1 / 0.3e1 * t24 * t403);
  t408 = t407 * t27;
  t412 = t155 * t161;
  t414 = t6 * t412 * t85;
  t420 = 0.1e1 / t160 / t7;
  t421 = t26 * t420;
  t424 = t6 * t421 * t85 / 0.12e2;
  t426 = t6 * t162 * t212;
  t430 = t166 / t167 / t43;
  t431 = t430 * t54;
  t432 = sigma[0] * sigma[0];
  t433 = t57 * t432;
  t434 = t35 * t35;
  t435 = t434 * t172;
  t437 = 0.1e1 / t36 / t435;
  t438 = t433 * t437;
  t440 = 0.2e3 / 0.531441e6 * t431 * t438;
  t442 = 0.1e1 / t37 / t434;
  t443 = t171 * t442;
  t445 = 0.11e3 / 0.2187e4 * t170 * t443;
  t446 = t60 * t76;
  t447 = t446 * t83;
  t448 = t53 * t29;
  t450 = 0.1e1 / t32 / t64;
  t451 = t185 * t185;
  t452 = t450 * t451;
  t453 = t448 * t452;
  t456 = t61 * t191;
  t457 = t83 * t52;
  t458 = t456 * t457;
  t459 = t54 * t57;
  t460 = t185 * t201;
  t461 = t459 * t460;
  t464 = t178 * t210;
  t467 = t451 * t54;
  t468 = t467 * t57;
  t475 = 0.4e2 / 0.9e1 * tau[0] * t174 - 0.11e2 / 0.9e1 * sigma[0] * t442;
  t476 = t57 * t475;
  t477 = t180 * t476;
  t481 = 0.1e1 / t190 / t75;
  t482 = t62 * t481;
  t483 = t201 * t201;
  t484 = t83 * t483;
  t487 = t210 * t201;
  t490 = t52 * t65;
  t495 = params->b * t68;
  t496 = t72 * t451;
  t502 = 0.5e3 / 0.81e2 * t490 * t451 + 0.25e3 / 0.81e2 * t193 * t475 + 0.625e6 / 0.19683e5 * t495 * t496 + 0.125e6 / 0.19683e5 * t197 * t72 * t475;
  t507 = t166 / t204 / t78;
  t508 = t507 * t54;
  t513 = -0.2e3 / 0.531441e6 * t508 * t438 + 0.11e3 / 0.2187e4 * t207 * t443 + t440 - t445;
  t515 = -t440 + t445 + 0.1e5 / 0.729e3 * t447 * t453 + 0.1e3 / 0.27e2 * t458 * t461 - 0.1e3 / 0.27e2 * t464 * t187 - 0.5e2 / 0.27e2 * t179 * t468 - 0.5e2 / 0.27e2 * t179 * t477 + 0.2e1 * t482 * t484 - 0.2e1 * t192 * t487 - t192 * t83 * t502 + t77 * t513;
  t520 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t85 - t414 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t212 + t424 - t426 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t515);
  t521 = t96 * t96;
  t522 = 0.1e1 / t521;
  t523 = t220 * t220;
  t526 = t91 * t399;
  t529 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t149 + 0.2e1 * t526);
  t533 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t522 * t523 + 0.4e1 / 0.3e1 * t96 * t529);
  t534 = t533 * t27;
  t538 = t223 * t161;
  t540 = t6 * t538 * t143;
  t542 = t98 * t420;
  t545 = t6 * t542 * t143 / 0.12e2;
  t547 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t143 - t540 / 0.4e1 + t545);
  tv2rho20 = 0.2e1 * t217 + 0.2e1 * t233 + t7 * (t520 + t547);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t550 = t394 * t237;
  t554 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t400);
  t558 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t550 * t152 + 0.4e1 / 0.3e1 * t24 * t554);
  t559 = t558 * t27;
  t563 = t240 * t161;
  t565 = t6 * t563 * t85;
  t573 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t85 - t565 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t212 - t414 / 0.8e1 + t424 - t426 / 0.8e1);
  t574 = t522 * t248;
  t578 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t526);
  t582 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t574 * t220 + 0.4e1 / 0.3e1 * t96 * t578);
  t583 = t582 * t27;
  t587 = t251 * t161;
  t589 = t6 * t587 * t143;
  t596 = t6 * t228 * t301;
  t599 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t143 - t589 / 0.8e1 - t540 / 0.8e1 + t545 - 0.3e1 / 0.8e1 * t6 * t224 * t301 - t596 / 0.8e1);
  tv2rho21 = t217 + t233 + t246 + t306 + t7 * (t573 + t599);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t604 = t237 * t237;
  t609 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t149 + 0.2e1 * t400);
  t613 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t394 * t604 + 0.4e1 / 0.3e1 * t24 * t609);
  t614 = t613 * t27;
  t620 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t85 - t565 / 0.4e1 + t424);
  t621 = t248 * t248;
  t626 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t149 + 0.2e1 * t526);
  t630 = my_piecewise3(t95, 0, 0.4e1 / 0.9e1 * t522 * t621 + 0.4e1 / 0.3e1 * t96 * t626);
  t631 = t630 * t27;
  t642 = t166 / t256 / t108;
  t643 = t642 * t54;
  t644 = sigma[2] * sigma[2];
  t645 = t57 * t644;
  t646 = t100 * t100;
  t647 = t646 * t261;
  t649 = 0.1e1 / t101 / t647;
  t650 = t645 * t649;
  t652 = 0.2e3 / 0.531441e6 * t643 * t650;
  t654 = 0.1e1 / t102 / t646;
  t655 = t260 * t654;
  t657 = 0.11e3 / 0.2187e4 * t259 * t655;
  t658 = t122 * t134;
  t659 = t658 * t141;
  t660 = t118 * t29;
  t661 = t274 * t274;
  t662 = t450 * t661;
  t663 = t660 * t662;
  t666 = t123 * t280;
  t667 = t141 * t117;
  t668 = t666 * t667;
  t669 = t274 * t290;
  t670 = t459 * t669;
  t673 = t267 * t299;
  t676 = t661 * t54;
  t677 = t676 * t57;
  t684 = 0.4e2 / 0.9e1 * tau[1] * t263 - 0.11e2 / 0.9e1 * sigma[2] * t654;
  t685 = t57 * t684;
  t686 = t269 * t685;
  t690 = 0.1e1 / t279 / t133;
  t691 = t124 * t690;
  t692 = t290 * t290;
  t693 = t141 * t692;
  t696 = t299 * t290;
  t699 = t117 * t65;
  t704 = params->b * t128;
  t705 = t72 * t661;
  t711 = 0.5e3 / 0.81e2 * t699 * t661 + 0.25e3 / 0.81e2 * t282 * t684 + 0.625e6 / 0.19683e5 * t704 * t705 + 0.125e6 / 0.19683e5 * t286 * t72 * t684;
  t716 = t166 / t293 / t136;
  t717 = t716 * t54;
  t722 = -0.2e3 / 0.531441e6 * t717 * t650 + 0.11e3 / 0.2187e4 * t296 * t655 + t652 - t657;
  t724 = -t652 + t657 + 0.1e5 / 0.729e3 * t659 * t663 + 0.1e3 / 0.27e2 * t668 * t670 - 0.1e3 / 0.27e2 * t673 * t276 - 0.5e2 / 0.27e2 * t268 * t677 - 0.5e2 / 0.27e2 * t268 * t686 + 0.2e1 * t691 * t693 - 0.2e1 * t281 * t696 - t281 * t141 * t711 + t135 * t722;
  t729 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t143 - t589 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t301 + t545 - t596 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t724);
  tv2rho22 = 0.2e1 * t246 + 0.2e1 * t306 + t7 * (t620 + t729);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t737 = t6 * t162 * t328 / 0.8e1;
  t738 = t434 * t35;
  t740 = 0.1e1 / t36 / t738;
  t742 = t57 * t740 * sigma[0];
  t744 = 0.25e2 / 0.177147e6 * t431 * t742;
  t745 = t34 * t174;
  t747 = 0.1e2 / 0.729e3 * t169 * t745;
  t748 = t83 * t53;
  t749 = t446 * t748;
  t750 = t29 * t450;
  t751 = t39 * t185;
  t752 = t750 * t751;
  t753 = t749 * t752;
  t755 = t39 * t201;
  t756 = t459 * t755;
  t757 = t458 * t756;
  t759 = t464 * t313;
  t761 = t185 * t54;
  t762 = t761 * t312;
  t763 = t179 * t762;
  t765 = t57 * t174;
  t766 = t180 * t765;
  t767 = t179 * t766;
  t769 = t456 * t322;
  t775 = t210 * t321;
  t777 = t490 * t751;
  t779 = t193 * t174;
  t782 = t495 * t318 * t185;
  t784 = t72 * t174;
  t785 = t197 * t784;
  t787 = -0.125e3 / 0.162e3 * t777 + 0.25e3 / 0.243e3 * t779 - 0.78125e5 / 0.19683e5 * t782 + 0.125e6 / 0.59049e5 * t785;
  t788 = t83 * t787;
  t790 = t178 * t326;
  t799 = 0.25e2 / 0.177147e6 * t508 * t742 - 0.1e2 / 0.729e3 * t206 * t745 - t744 + t747;
  t801 = t744 - t747 - 0.125e4 / 0.729e3 * t753 - 0.25e2 / 0.108e3 * t757 + 0.25e2 / 0.108e3 * t759 + 0.25e2 / 0.108e3 * t763 - 0.5e2 / 0.81e2 * t767 + 0.5e2 / 0.27e2 * t769 * t187 + 0.2e1 * t482 * t322 * t201 - t192 * t775 - t192 * t788 - 0.5e2 / 0.27e2 * t790 * t187 - t192 * t326 * t201 + t77 * t799;
  t806 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t328 - t737 - 0.3e1 / 0.8e1 * t6 * t28 * t801);
  tv2rhosigma0 = t7 * t806 + t332;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t813 = t6 * t228 * t352 / 0.8e1;
  t815 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t352 - t813);
  tv2rhosigma2 = t7 * t815 + t356;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t821 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t328 - t737);
  tv2rhosigma3 = t7 * t821 + t332;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t826 = t646 * t100;
  t828 = 0.1e1 / t101 / t826;
  t830 = t57 * t828 * sigma[2];
  t832 = 0.25e2 / 0.177147e6 * t643 * t830;
  t833 = t34 * t263;
  t835 = 0.1e2 / 0.729e3 * t258 * t833;
  t836 = t141 * t118;
  t837 = t658 * t836;
  t838 = t104 * t274;
  t839 = t750 * t838;
  t840 = t837 * t839;
  t842 = t104 * t290;
  t843 = t459 * t842;
  t844 = t668 * t843;
  t846 = t673 * t337;
  t848 = t274 * t54;
  t849 = t848 * t336;
  t850 = t268 * t849;
  t852 = t57 * t263;
  t853 = t269 * t852;
  t854 = t268 * t853;
  t856 = t666 * t346;
  t862 = t299 * t345;
  t864 = t699 * t838;
  t866 = t282 * t263;
  t869 = t704 * t342 * t274;
  t871 = t72 * t263;
  t872 = t286 * t871;
  t874 = -0.125e3 / 0.162e3 * t864 + 0.25e3 / 0.243e3 * t866 - 0.78125e5 / 0.19683e5 * t869 + 0.125e6 / 0.59049e5 * t872;
  t875 = t141 * t874;
  t877 = t267 * t350;
  t886 = 0.25e2 / 0.177147e6 * t717 * t830 - 0.1e2 / 0.729e3 * t295 * t833 - t832 + t835;
  t888 = t832 - t835 - 0.125e4 / 0.729e3 * t840 - 0.25e2 / 0.108e3 * t844 + 0.25e2 / 0.108e3 * t846 + 0.25e2 / 0.108e3 * t850 - 0.5e2 / 0.81e2 * t854 + 0.5e2 / 0.27e2 * t856 * t276 + 0.2e1 * t691 * t346 * t290 - t281 * t862 - t281 * t875 - 0.5e2 / 0.27e2 * t877 * t276 - t281 * t350 * t290 + t135 * t886;
  t893 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t352 - t813 - 0.3e1 / 0.8e1 * t6 * t99 * t888);
  tv2rhosigma5 = t7 * t893 + t356;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t900 = t6 * t162 * t369 / 0.8e1;
  t901 = t49 * t185;
  t902 = t750 * t901;
  t905 = t49 * t201;
  t906 = t459 * t905;
  t911 = t761 * t357;
  t915 = t456 * t367;
  t921 = t210 * t366;
  t930 = 0.5e3 / 0.81e2 * t490 * t901 - 0.125e4 / 0.243e3 * t316 + 0.625e6 / 0.19683e5 * t495 * t363 * t185 - 0.625e6 / 0.59049e5 * t319;
  t931 = t83 * t930;
  t933 = 0.1e5 / 0.729e3 * t749 * t902 + 0.5e2 / 0.27e2 * t458 * t906 - 0.5e2 / 0.27e2 * t464 * t358 - 0.5e2 / 0.27e2 * t179 * t911 + 0.25e3 / 0.81e2 * t314 + 0.5e2 / 0.27e2 * t915 * t187 + 0.2e1 * t482 * t367 * t201 - t192 * t921 - t192 * t931;
  t938 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t369 - t900 - 0.3e1 / 0.8e1 * t6 * t28 * t933);
  tv2rhotau0 = t7 * t938 + t373;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t945 = t6 * t228 * t386 / 0.8e1;
  t947 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t386 - t945);
  tv2rhotau1 = t7 * t947 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t953 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t369 - t900);
  tv2rhotau2 = t7 * t953 + t373;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t958 = t114 * t274;
  t959 = t750 * t958;
  t962 = t114 * t290;
  t963 = t459 * t962;
  t968 = t848 * t374;
  t972 = t666 * t384;
  t978 = t299 * t383;
  t987 = 0.5e3 / 0.81e2 * t699 * t958 - 0.125e4 / 0.243e3 * t340 + 0.625e6 / 0.19683e5 * t704 * t380 * t274 - 0.625e6 / 0.59049e5 * t343;
  t988 = t141 * t987;
  t990 = 0.1e5 / 0.729e3 * t837 * t959 + 0.5e2 / 0.27e2 * t668 * t963 - 0.5e2 / 0.27e2 * t673 * t375 - 0.5e2 / 0.27e2 * t268 * t968 + 0.25e3 / 0.81e2 * t338 + 0.5e2 / 0.27e2 * t972 * t276 + 0.2e1 * t691 * t384 * t290 - t281 * t978 - t281 * t988;
  t995 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t386 - t945 - 0.3e1 / 0.8e1 * t6 * t99 * t990);
  tv2rhotau3 = t7 * t995 + t390;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t997 = t434 * rho[0];
  t999 = 0.1e1 / t36 / t997;
  t1000 = t459 * t999;
  t1001 = t430 * t1000;
  t1003 = t450 * t999;
  t1004 = t448 * t1003;
  t1005 = t447 * t1004;
  t1007 = t39 * t321;
  t1008 = t459 * t1007;
  t1009 = t458 * t1008;
  t1011 = t790 * t313;
  t1013 = t179 * t1000;
  t1015 = t321 * t321;
  t1016 = t83 * t1015;
  t1019 = t326 * t321;
  t1022 = t490 * t999;
  t1024 = t72 * t999;
  t1025 = t495 * t1024;
  t1027 = 0.125e3 / 0.1296e4 * t1022 + 0.78125e5 / 0.157464e6 * t1025;
  t1028 = t83 * t1027;
  t1032 = -0.25e2 / 0.472392e6 * t507 * t1000 + 0.25e2 / 0.472392e6 * t1001;
  t1034 = -0.25e2 / 0.472392e6 * t1001 + 0.625e3 / 0.2916e4 * t1005 - 0.25e2 / 0.54e2 * t1009 + 0.25e2 / 0.54e2 * t1011 - 0.25e2 / 0.864e3 * t1013 + 0.2e1 * t482 * t1016 - 0.2e1 * t192 * t1019 - t192 * t1028 + t77 * t1032;
  t1038 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1034);
  tv2sigma20 = t7 * t1038;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1039 = t646 * rho[1];
  t1041 = 0.1e1 / t101 / t1039;
  t1042 = t459 * t1041;
  t1043 = t642 * t1042;
  t1045 = t450 * t1041;
  t1046 = t660 * t1045;
  t1047 = t659 * t1046;
  t1049 = t104 * t345;
  t1050 = t459 * t1049;
  t1051 = t668 * t1050;
  t1053 = t877 * t337;
  t1055 = t268 * t1042;
  t1057 = t345 * t345;
  t1058 = t141 * t1057;
  t1061 = t350 * t345;
  t1064 = t699 * t1041;
  t1066 = t72 * t1041;
  t1067 = t704 * t1066;
  t1069 = 0.125e3 / 0.1296e4 * t1064 + 0.78125e5 / 0.157464e6 * t1067;
  t1070 = t141 * t1069;
  t1074 = -0.25e2 / 0.472392e6 * t716 * t1042 + 0.25e2 / 0.472392e6 * t1043;
  t1076 = -0.25e2 / 0.472392e6 * t1043 + 0.625e3 / 0.2916e4 * t1047 - 0.25e2 / 0.54e2 * t1051 + 0.25e2 / 0.54e2 * t1053 - 0.25e2 / 0.864e3 * t1055 + 0.2e1 * t691 * t1058 - 0.2e1 * t281 * t1061 - t281 * t1070 + t135 * t1074;
  t1080 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1076);
  tv2sigma25 = t7 * t1080;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1082 = 0.1e1 / t36 / t434;
  t1083 = t450 * t1082;
  t1084 = t448 * t1083;
  t1085 = t447 * t1084;
  t1087 = t49 * t321;
  t1088 = t459 * t1087;
  t1093 = t1082 * t54;
  t1094 = t1093 * t57;
  t1095 = t179 * t1094;
  t1097 = t915 * t313;
  t1099 = t367 * t321;
  t1102 = t326 * t366;
  t1104 = t490 * t1082;
  t1106 = t72 * t1082;
  t1107 = t495 * t1106;
  t1109 = -0.125e3 / 0.162e3 * t1104 - 0.78125e5 / 0.19683e5 * t1107;
  t1110 = t83 * t1109;
  t1112 = -0.125e4 / 0.729e3 * t1085 + 0.5e2 / 0.27e2 * t458 * t1088 - 0.5e2 / 0.27e2 * t790 * t358 + 0.25e2 / 0.108e3 * t1095 - 0.25e2 / 0.108e3 * t1097 + 0.2e1 * t482 * t1099 - t192 * t1102 - t192 * t1110;
  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1112);
  tv2sigmatau0 = t7 * t1116;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1118 = 0.1e1 / t101 / t646;
  t1119 = t450 * t1118;
  t1120 = t660 * t1119;
  t1121 = t659 * t1120;
  t1123 = t114 * t345;
  t1124 = t459 * t1123;
  t1129 = t1118 * t54;
  t1130 = t1129 * t57;
  t1131 = t268 * t1130;
  t1133 = t972 * t337;
  t1135 = t384 * t345;
  t1138 = t350 * t383;
  t1140 = t699 * t1118;
  t1142 = t72 * t1118;
  t1143 = t704 * t1142;
  t1145 = -0.125e3 / 0.162e3 * t1140 - 0.78125e5 / 0.19683e5 * t1143;
  t1146 = t141 * t1145;
  t1148 = -0.125e4 / 0.729e3 * t1121 + 0.5e2 / 0.27e2 * t668 * t1124 - 0.5e2 / 0.27e2 * t877 * t375 + 0.25e2 / 0.108e3 * t1131 - 0.25e2 / 0.108e3 * t1133 + 0.2e1 * t691 * t1135 - t281 * t1138 - t281 * t1146;
  t1152 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1148);
  tv2sigmatau5 = t7 * t1152;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1154 = 0.1e1 / t36 / t172;
  t1155 = t450 * t1154;
  t1156 = t448 * t1155;
  t1159 = t49 * t366;
  t1160 = t459 * t1159;
  t1163 = t1154 * t54;
  t1164 = t1163 * t57;
  t1167 = t366 * t366;
  t1168 = t83 * t1167;
  t1173 = t72 * t1154;
  t1176 = 0.5e3 / 0.81e2 * t490 * t1154 + 0.625e6 / 0.19683e5 * t495 * t1173;
  t1177 = t83 * t1176;
  t1179 = 0.1e5 / 0.729e3 * t447 * t1156 + 0.1e3 / 0.27e2 * t458 * t1160 - 0.5e2 / 0.27e2 * t179 * t1164 + 0.2e1 * t482 * t1168 - t192 * t1177;
  t1183 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1179);
  tv2tau20 = t7 * t1183;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1185 = 0.1e1 / t101 / t261;
  t1186 = t450 * t1185;
  t1187 = t660 * t1186;
  t1190 = t114 * t383;
  t1191 = t459 * t1190;
  t1194 = t1185 * t54;
  t1195 = t1194 * t57;
  t1198 = t383 * t383;
  t1199 = t141 * t1198;
  t1204 = t72 * t1185;
  t1207 = 0.5e3 / 0.81e2 * t699 * t1185 + 0.625e6 / 0.19683e5 * t704 * t1204;
  t1208 = t141 * t1207;
  t1210 = 0.1e5 / 0.729e3 * t659 * t1187 + 0.1e3 / 0.27e2 * t668 * t1191 - 0.5e2 / 0.27e2 * t268 * t1195 + 0.2e1 * t691 * t1199 - t281 * t1208;
  t1214 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t1210);
  tv2tau22 = t7 * t1214;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1218 = 0.1e1 / t393 / t20;
  t1219 = t395 * t152;
  t1222 = t394 * t152;
  t1225 = t148 * t148;
  t1226 = 0.1e1 / t1225;
  t1227 = t17 * t1226;
  t1230 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t399 - 0.6e1 * t1227);
  t1234 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1218 * t1219 + 0.4e1 / 0.3e1 * t1222 * t403 + 0.4e1 / 0.3e1 * t24 * t1230);
  t1235 = t1234 * t27;
  t1239 = t407 * t161;
  t1241 = t6 * t1239 * t85;
  t1246 = t155 * t420;
  t1248 = t6 * t1246 * t85;
  t1251 = t6 * t412 * t212;
  t1257 = 0.1e1 / t160 / t148;
  t1258 = t26 * t1257;
  t1261 = 0.5e1 / 0.36e2 * t6 * t1258 * t85;
  t1263 = t6 * t421 * t212;
  t1266 = t6 * t162 * t515;
  t1268 = t61 * t481;
  t1269 = t1268 * t457;
  t1274 = t60 * t191;
  t1275 = t1274 * t748;
  t1277 = t750 * t451 * t201;
  t1280 = t185 * t475;
  t1281 = t750 * t1280;
  t1284 = t210 * t52;
  t1285 = t456 * t1284;
  t1289 = t459 * t475 * t201;
  t1296 = t178 * t513;
  t1301 = t761 * t476;
  t1307 = 0.1e1 / t37 / t997;
  t1310 = -0.44e3 / 0.27e2 * tau[0] * t442 + 0.154e3 / 0.27e2 * sigma[0] * t1307;
  t1311 = t57 * t1310;
  t1312 = t180 * t1311;
  t1315 = t52 * t29;
  t1316 = t451 * t185;
  t1318 = t1315 * t450 * t1316;
  t1321 = t456 * t83;
  t1322 = t57 * t201;
  t1323 = t467 * t1322;
  t1326 = -0.1e3 / 0.9e1 * t1269 * t459 * t185 * t483 - 0.1e5 / 0.243e3 * t1275 * t1277 + 0.1e5 / 0.243e3 * t749 * t1281 + 0.1e3 / 0.9e1 * t1285 * t461 + 0.5e2 / 0.9e1 * t458 * t1289 + 0.5e2 / 0.9e1 * t458 * t459 * t185 * t502 - 0.5e2 / 0.9e1 * t1296 * t187 - 0.5e2 / 0.9e1 * t464 * t477 - 0.5e2 / 0.9e1 * t179 * t1301 - 0.5e2 / 0.27e2 * t179 * t1312 + 0.1e5 / 0.243e3 * t447 * t1318 + 0.5e2 / 0.9e1 * t1321 * t1323;
  t1327 = t446 * t210;
  t1330 = t204 * t204;
  t1332 = t166 / t1330;
  t1333 = t432 * sigma[0];
  t1334 = t65 * t1333;
  t1335 = t434 * t434;
  t1336 = t1335 * t172;
  t1337 = 0.1e1 / t1336;
  t1338 = t1334 * t1337;
  t1342 = 0.1e1 / t36 / t1335;
  t1343 = t433 * t1342;
  t1346 = t171 * t1307;
  t1349 = t167 * t167;
  t1351 = t166 / t1349;
  t1353 = 0.4e4 / 0.43046721e8 * t1351 * t1338;
  t1355 = 0.22e4 / 0.531441e6 * t431 * t1343;
  t1357 = 0.154e4 / 0.6561e4 * t170 * t1346;
  t1358 = -0.4e4 / 0.43046721e8 * t1332 * t1338 + 0.22e4 / 0.531441e6 * t508 * t1343 - 0.154e4 / 0.6561e4 * t207 * t1346 + t1353 - t1355 + t1357;
  t1360 = t63 * t72;
  t1361 = t1316 * t76;
  t1368 = t513 * t201;
  t1371 = t210 * t502;
  t1380 = params->b * t63;
  t1390 = 0.5e3 / 0.81e2 * t1316 * t65 + 0.5e3 / 0.27e2 * t490 * t1280 + 0.25e3 / 0.81e2 * t193 * t1310 + 0.25e7 / 0.19683e5 * t1380 * t72 * t1316 + 0.625e6 / 0.6561e4 * t495 * t198 * t475 + 0.125e6 / 0.19683e5 * t197 * t72 * t1310;
  t1391 = t83 * t1390;
  t1393 = t190 * t190;
  t1394 = 0.1e1 / t1393;
  t1395 = t62 * t1394;
  t1396 = t483 * t201;
  t1397 = t83 * t1396;
  t1400 = t210 * t483;
  t1405 = 0.1e5 / 0.243e3 * t1327 * t453 + t77 * t1358 - t1353 - 0.1e7 / 0.19683e5 * t1360 * t1361 * t83 + 0.6e1 * t482 * t202 * t502 - 0.3e1 * t192 * t1368 - 0.3e1 * t192 * t1371 - t192 * t1391 - 0.6e1 * t1395 * t1397 + 0.6e1 * t482 * t1400 - 0.5e2 / 0.9e1 * t464 * t468 + t1355 - t1357;
  t1406 = t1326 + t1405;
  t1411 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1235 * t85 - 0.3e1 / 0.8e1 * t1241 - 0.9e1 / 0.8e1 * t6 * t408 * t212 + t1248 / 0.4e1 - 0.3e1 / 0.4e1 * t1251 - 0.9e1 / 0.8e1 * t6 * t156 * t515 - t1261 + t1263 / 0.4e1 - 0.3e1 / 0.8e1 * t1266 - 0.3e1 / 0.8e1 * t6 * t28 * t1406);
  t1413 = 0.1e1 / t521 / t94;
  t1414 = t523 * t220;
  t1417 = t522 * t220;
  t1420 = t91 * t1226;
  t1423 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t399 - 0.6e1 * t1420);
  t1427 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1413 * t1414 + 0.4e1 / 0.3e1 * t1417 * t529 + 0.4e1 / 0.3e1 * t96 * t1423);
  t1428 = t1427 * t27;
  t1432 = t533 * t161;
  t1434 = t6 * t1432 * t143;
  t1436 = t223 * t420;
  t1438 = t6 * t1436 * t143;
  t1440 = t98 * t1257;
  t1443 = 0.5e1 / 0.36e2 * t6 * t1440 * t143;
  t1445 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1428 * t143 - 0.3e1 / 0.8e1 * t1434 + t1438 / 0.4e1 - t1443);
  tv3rho30 = 0.3e1 * t520 + 0.3e1 * t547 + t7 * (t1411 + t1445);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1448 = 0.2e1 * t573;
  t1449 = 0.2e1 * t599;
  t1450 = t1218 * t237;
  t1453 = t394 * t554;
  t1458 = 0.2e1 * t399;
  t1459 = 0.6e1 * t1227;
  t1461 = my_piecewise5(t11, 0, t15, 0, t1458 - t1459);
  t1465 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1450 * t395 + 0.8e1 / 0.9e1 * t1453 * t152 + 0.4e1 / 0.9e1 * t550 * t403 + 0.4e1 / 0.3e1 * t24 * t1461);
  t1466 = t1465 * t27;
  t1470 = t558 * t161;
  t1473 = t6 * t1470 * t85 / 0.4e1;
  t1477 = t240 * t420;
  t1479 = t6 * t1477 * t85;
  t1483 = t6 * t563 * t212 / 0.4e1;
  t1492 = -0.3e1 / 0.8e1 * t6 * t1466 * t85 - t1473 - 0.3e1 / 0.4e1 * t6 * t559 * t212 + t1479 / 0.12e2 - t1483 - 0.3e1 / 0.8e1 * t6 * t241 * t515 - t1241 / 0.8e1 + t1248 / 0.6e1 - t1251 / 0.4e1 - t1261 + t1263 / 0.6e1 - t1266 / 0.8e1;
  t1493 = my_piecewise3(t2, 0, t1492);
  t1494 = t1413 * t248;
  t1497 = t522 * t578;
  t1502 = 0.6e1 * t1420;
  t1504 = my_piecewise5(t15, 0, t11, 0, -t1458 - t1502);
  t1508 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1494 * t523 + 0.8e1 / 0.9e1 * t1497 * t220 + 0.4e1 / 0.9e1 * t574 * t529 + 0.4e1 / 0.3e1 * t96 * t1504);
  t1509 = t1508 * t27;
  t1513 = t582 * t161;
  t1516 = t6 * t1513 * t143 / 0.4e1;
  t1517 = t251 * t420;
  t1519 = t6 * t1517 * t143;
  t1528 = t6 * t538 * t301 / 0.4e1;
  t1530 = t6 * t542 * t301;
  t1533 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1509 * t143 - t1516 + t1519 / 0.12e2 - t1434 / 0.8e1 + t1438 / 0.6e1 - t1443 - 0.3e1 / 0.8e1 * t6 * t534 * t301 - t1528 + t1530 / 0.12e2);
  tv3rho31 = t520 + t547 + t1448 + t1449 + t7 * (t1493 + t1533);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1536 = t1218 * t604;
  t1541 = t394 * t609;
  t1545 = my_piecewise5(t11, 0, t15, 0, -t1458 - t1459);
  t1549 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1536 * t152 + 0.8e1 / 0.9e1 * t550 * t554 + 0.4e1 / 0.9e1 * t1541 * t152 + 0.4e1 / 0.3e1 * t24 * t1545);
  t1550 = t1549 * t27;
  t1554 = t613 * t161;
  t1556 = t6 * t1554 * t85;
  t1565 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1550 * t85 - t1556 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t614 * t212 - t1473 + t1479 / 0.6e1 - t1483 + t1248 / 0.12e2 - t1261 + t1263 / 0.12e2);
  t1566 = t1413 * t621;
  t1571 = t522 * t626;
  t1575 = my_piecewise5(t15, 0, t11, 0, t1458 - t1502);
  t1579 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1566 * t220 + 0.8e1 / 0.9e1 * t574 * t578 + 0.4e1 / 0.9e1 * t1571 * t220 + 0.4e1 / 0.3e1 * t96 * t1575);
  t1580 = t1579 * t27;
  t1584 = t630 * t161;
  t1586 = t6 * t1584 * t143;
  t1593 = t6 * t587 * t301;
  t1601 = t6 * t228 * t724;
  t1603 = -0.3e1 / 0.8e1 * t6 * t1580 * t143 - t1586 / 0.8e1 - t1516 + t1519 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t583 * t301 - t1593 / 0.4e1 + t1438 / 0.12e2 - t1443 - t1528 + t1530 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t224 * t724 - t1601 / 0.8e1;
  t1604 = my_piecewise3(t90, 0, t1603);
  tv3rho32 = t1448 + t1449 + t620 + t729 + t7 * (t1565 + t1604);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1609 = t604 * t237;
  t1616 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t399 - 0.6e1 * t1227);
  t1620 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1218 * t1609 + 0.4e1 / 0.3e1 * t550 * t609 + 0.4e1 / 0.3e1 * t24 * t1616);
  t1621 = t1620 * t27;
  t1628 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1621 * t85 - 0.3e1 / 0.8e1 * t1556 + t1479 / 0.4e1 - t1261);
  t1629 = t621 * t248;
  t1636 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t399 - 0.6e1 * t1420);
  t1640 = my_piecewise3(t95, 0, -0.8e1 / 0.27e2 * t1413 * t1629 + 0.4e1 / 0.3e1 * t574 * t626 + 0.4e1 / 0.3e1 * t96 * t1636);
  t1641 = t1640 * t27;
  t1656 = t117 * t29;
  t1657 = t661 * t274;
  t1659 = t1656 * t450 * t1657;
  t1662 = t666 * t141;
  t1663 = t57 * t290;
  t1664 = t676 * t1663;
  t1667 = t267 * t722;
  t1672 = t848 * t685;
  t1678 = 0.1e1 / t102 / t1039;
  t1681 = -0.44e3 / 0.27e2 * tau[1] * t654 + 0.154e3 / 0.27e2 * sigma[2] * t1678;
  t1682 = t57 * t1681;
  t1683 = t269 * t1682;
  t1686 = t658 * t299;
  t1689 = t293 * t293;
  t1691 = t166 / t1689;
  t1692 = t644 * sigma[2];
  t1693 = t65 * t1692;
  t1694 = t646 * t646;
  t1695 = t1694 * t261;
  t1696 = 0.1e1 / t1695;
  t1697 = t1693 * t1696;
  t1701 = 0.1e1 / t101 / t1694;
  t1702 = t645 * t1701;
  t1705 = t260 * t1678;
  t1708 = t256 * t256;
  t1710 = t166 / t1708;
  t1712 = 0.4e4 / 0.43046721e8 * t1710 * t1697;
  t1714 = 0.22e4 / 0.531441e6 * t643 * t1702;
  t1716 = 0.154e4 / 0.6561e4 * t259 * t1705;
  t1717 = -0.4e4 / 0.43046721e8 * t1691 * t1697 + 0.22e4 / 0.531441e6 * t717 * t1702 - 0.154e4 / 0.6561e4 * t296 * t1705 + t1712 - t1714 + t1716;
  t1719 = t299 * t711;
  t1724 = t274 * t684;
  t1729 = params->b * t125;
  t1739 = 0.5e3 / 0.81e2 * t1657 * t65 + 0.5e3 / 0.27e2 * t699 * t1724 + 0.25e3 / 0.81e2 * t282 * t1681 + 0.25e7 / 0.19683e5 * t1729 * t72 * t1657 + 0.625e6 / 0.6561e4 * t704 * t287 * t684 + 0.125e6 / 0.19683e5 * t286 * t72 * t1681;
  t1740 = t141 * t1739;
  t1742 = t299 * t692;
  t1745 = t279 * t279;
  t1746 = 0.1e1 / t1745;
  t1747 = t124 * t1746;
  t1748 = t692 * t290;
  t1749 = t141 * t1748;
  t1752 = 0.1e5 / 0.243e3 * t659 * t1659 + 0.5e2 / 0.9e1 * t1662 * t1664 - 0.5e2 / 0.9e1 * t1667 * t276 - 0.5e2 / 0.9e1 * t673 * t686 - 0.5e2 / 0.9e1 * t268 * t1672 - 0.5e2 / 0.27e2 * t268 * t1683 + 0.1e5 / 0.243e3 * t1686 * t663 + t135 * t1717 - 0.3e1 * t281 * t1719 - t281 * t1740 + 0.6e1 * t691 * t1742 - 0.6e1 * t1747 * t1749;
  t1753 = t722 * t290;
  t1759 = t125 * t72;
  t1760 = t1657 * t134;
  t1766 = t123 * t690;
  t1767 = t1766 * t667;
  t1772 = t122 * t280;
  t1773 = t1772 * t836;
  t1775 = t750 * t661 * t290;
  t1778 = t750 * t1724;
  t1781 = t299 * t117;
  t1782 = t666 * t1781;
  t1786 = t459 * t684 * t290;
  t1793 = -0.3e1 * t281 * t1753 + 0.6e1 * t691 * t291 * t711 - t1712 - 0.1e7 / 0.19683e5 * t1759 * t1760 * t141 - 0.5e2 / 0.9e1 * t673 * t677 + t1714 - t1716 - 0.1e3 / 0.9e1 * t1767 * t459 * t274 * t692 - 0.1e5 / 0.243e3 * t1773 * t1775 + 0.1e5 / 0.243e3 * t837 * t1778 + 0.1e3 / 0.9e1 * t1782 * t670 + 0.5e2 / 0.9e1 * t668 * t1786 + 0.5e2 / 0.9e1 * t668 * t459 * t274 * t711;
  t1794 = t1752 + t1793;
  t1799 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1641 * t143 - 0.3e1 / 0.8e1 * t1586 - 0.9e1 / 0.8e1 * t6 * t631 * t301 + t1519 / 0.4e1 - 0.3e1 / 0.4e1 * t1593 - 0.9e1 / 0.8e1 * t6 * t252 * t724 - t1443 + t1530 / 0.4e1 - 0.3e1 / 0.8e1 * t1601 - 0.3e1 / 0.8e1 * t6 * t99 * t1794);
  tv3rho33 = 0.3e1 * t620 + 0.3e1 * t729 + t7 * (t1628 + t1799);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1807 = t6 * t412 * t328;
  t1814 = t6 * t421 * t328 / 0.12e2;
  t1816 = t6 * t162 * t801;
  t1818 = t1268 * t322;
  t1820 = t180 * t186 * t201;
  t1824 = t750 * t751 * t201;
  t1825 = t1275 * t1824;
  t1827 = t1296 * t313;
  t1829 = t464 * t762;
  t1831 = t475 * t54;
  t1832 = t1831 * t312;
  t1833 = t179 * t1832;
  t1835 = t178 * t799;
  t1840 = t446 * t326;
  t1843 = t464 * t766;
  t1845 = t761 * t765;
  t1846 = t179 * t1845;
  t1849 = t57 * t442;
  t1850 = t180 * t1849;
  t1851 = t179 * t1850;
  t1853 = t1335 * t35;
  t1855 = t65 / t1853;
  t1856 = t1855 * t432;
  t1860 = t57 * t437 * sigma[0];
  t1863 = t34 * t442;
  t1867 = 0.5e3 / 0.14348907e8 * t1351 * t1856;
  t1869 = 0.25e2 / 0.19683e5 * t431 * t1860;
  t1871 = 0.11e3 / 0.2187e4 * t169 * t1863;
  t1872 = 0.5e3 / 0.14348907e8 * t1332 * t1856 - 0.25e2 / 0.19683e5 * t508 * t1860 + 0.11e3 / 0.2187e4 * t206 * t1863 - t1867 + t1869 - t1871;
  t1874 = t513 * t321;
  t1876 = t210 * t787;
  t1879 = t451 * t65;
  t1880 = t1879 * t39;
  t1882 = t174 * t185;
  t1883 = t490 * t1882;
  t1885 = t39 * t475;
  t1886 = t490 * t1885;
  t1888 = t193 * t442;
  t1891 = t1380 * t318 * t451;
  t1894 = t495 * t784 * t185;
  t1897 = t495 * t318 * t475;
  t1899 = t72 * t442;
  t1900 = t197 * t1899;
  t1902 = -0.125e3 / 0.162e3 * t1880 + 0.1e4 / 0.243e3 * t1883 - 0.125e3 / 0.162e3 * t1886 - 0.275e4 / 0.729e3 * t1888 - 0.3125e6 / 0.19683e5 * t1891 + 0.125e7 / 0.59049e5 * t1894 - 0.78125e5 / 0.19683e5 * t1897 - 0.1375e7 / 0.177147e6 * t1900;
  t1903 = t83 * t1902;
  t1905 = t799 * t201;
  t1908 = t326 * t483;
  t1911 = t326 * t502;
  t1916 = 0.55e3 / 0.243e3 * t1851 + t77 * t1872 - t192 * t1874 - 0.2e1 * t192 * t1876 - t192 * t1903 - 0.2e1 * t192 * t1905 + 0.2e1 * t482 * t1908 - t192 * t1911 + t1871 - 0.6e1 * t1395 * t322 * t483 + t1867;
  t1929 = t1360 * t451;
  t1930 = t76 * t83;
  t1931 = t1930 * t39;
  t1932 = t1929 * t1931;
  t1935 = t321 * t451 * t459;
  t1938 = t174 * t201;
  t1939 = t459 * t1938;
  t1940 = t458 * t1939;
  t1942 = t446 * t457;
  t1943 = t39 * t451;
  t1944 = t750 * t1943;
  t1945 = t1942 * t1944;
  t1947 = t750 * t1882;
  t1948 = t749 * t1947;
  t1952 = t459 * t39 * t483;
  t1953 = t1269 * t1952;
  t1955 = t210 * t53;
  t1956 = t446 * t1955;
  t1957 = t1956 * t752;
  t1959 = t750 * t1885;
  t1960 = t749 * t1959;
  t1962 = t1285 * t756;
  t1964 = t83 * t185;
  t1965 = t456 * t1964;
  t1966 = t1965 * t756;
  t1969 = t459 * t39 * t502;
  t1970 = t458 * t1969;
  t1972 = t456 * t775;
  t1975 = t456 * t788;
  t1980 = t1274 * t322;
  t1983 = t326 * t52;
  t1984 = t456 * t1983;
  t1987 = 0.25e2 / 0.54e2 * t1953 - 0.25e4 / 0.729e3 * t1957 - 0.125e4 / 0.729e3 * t1960 - 0.25e2 / 0.54e2 * t1962 - 0.25e2 / 0.54e2 * t1966 - 0.25e2 / 0.108e3 * t1970 + 0.1e3 / 0.27e2 * t1972 * t187 + 0.1e3 / 0.27e2 * t1975 * t187 + 0.5e2 / 0.27e2 * t769 * t477 - 0.1e5 / 0.729e3 * t1980 * t453 + 0.1e3 / 0.27e2 * t1984 * t461;
  t1989 = -0.2e3 / 0.27e2 * t1818 * t1820 + 0.25e4 / 0.729e3 * t1825 + 0.25e2 / 0.108e3 * t1827 + 0.25e2 / 0.54e2 * t1829 + 0.25e2 / 0.108e3 * t1833 - 0.1e3 / 0.27e2 * t1835 * t187 - 0.5e2 / 0.27e2 * t790 * t477 + 0.1e5 / 0.729e3 * t1840 * t453 - 0.1e3 / 0.81e2 * t1843 - 0.1e3 / 0.81e2 * t1846 + t1916 + 0.4e1 * t482 * t775 * t201 + 0.4e1 * t482 * t788 * t201 + 0.2e1 * t482 * t322 * t502 - 0.5e2 / 0.27e2 * t790 * t468 - t1869 + 0.125e6 / 0.19683e5 * t1932 + 0.5e2 / 0.27e2 * t1321 * t1935 + 0.1e3 / 0.81e2 * t1940 - 0.125e4 / 0.243e3 * t1945 + 0.2e5 / 0.2187e4 * t1948 + t1987;
  t1994 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t328 - t1807 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t801 + t1814 - t1816 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1989);
  tv3rho2sigma0 = t7 * t1994 + 0.2e1 * t806;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2001 = t6 * t538 * t352;
  t2005 = t6 * t542 * t352 / 0.12e2;
  t2007 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t352 - t2001 / 0.4e1 + t2005);
  tv3rho2sigma2 = t7 * t2007 + 0.2e1 * t815;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2013 = t6 * t563 * t328;
  t2021 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t328 - t2013 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t801 - t1807 / 0.8e1 + t1814 - t1816 / 0.8e1);
  tv3rho2sigma3 = t7 * t2021 + t806 + t821;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2027 = t6 * t587 * t352;
  t2034 = t6 * t228 * t888;
  t2037 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t352 - t2027 / 0.8e1 - t2001 / 0.8e1 + t2005 - 0.3e1 / 0.8e1 * t6 * t224 * t888 - t2034 / 0.8e1);
  tv3rho2sigma5 = t7 * t2037 + t815 + t893;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2045 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t328 - t2013 / 0.4e1 + t1814);
  tv3rho2sigma6 = t7 * t2045 + 0.2e1 * t821;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2057 = t750 * t838 * t290;
  t2058 = t1773 * t2057;
  t2060 = t1766 * t346;
  t2062 = t269 * t275 * t290;
  t2065 = t299 * t874;
  t2068 = t661 * t65;
  t2069 = t2068 * t104;
  t2071 = t263 * t274;
  t2072 = t699 * t2071;
  t2074 = t104 * t684;
  t2075 = t699 * t2074;
  t2077 = t282 * t654;
  t2080 = t1729 * t342 * t661;
  t2083 = t704 * t871 * t274;
  t2086 = t704 * t342 * t684;
  t2088 = t72 * t654;
  t2089 = t286 * t2088;
  t2091 = -0.125e3 / 0.162e3 * t2069 + 0.1e4 / 0.243e3 * t2072 - 0.125e3 / 0.162e3 * t2075 - 0.275e4 / 0.729e3 * t2077 - 0.3125e6 / 0.19683e5 * t2080 + 0.125e7 / 0.59049e5 * t2083 - 0.78125e5 / 0.19683e5 * t2086 - 0.1375e7 / 0.177147e6 * t2089;
  t2092 = t141 * t2091;
  t2094 = t886 * t290;
  t2097 = t350 * t711;
  t2099 = t350 * t692;
  t2102 = t722 * t345;
  t2104 = t1694 * t100;
  t2106 = t65 / t2104;
  t2107 = t2106 * t644;
  t2111 = t57 * t649 * sigma[2];
  t2114 = t34 * t654;
  t2118 = 0.5e3 / 0.14348907e8 * t1710 * t2107;
  t2120 = 0.25e2 / 0.19683e5 * t643 * t2111;
  t2122 = 0.11e3 / 0.2187e4 * t258 * t2114;
  t2123 = 0.5e3 / 0.14348907e8 * t1691 * t2107 - 0.25e2 / 0.19683e5 * t717 * t2111 + 0.11e3 / 0.2187e4 * t295 * t2114 - t2118 + t2120 - t2122;
  t2138 = t1759 * t661;
  t2139 = t134 * t141;
  t2140 = t2139 * t104;
  t2141 = t2138 * t2140;
  t2146 = t345 * t661 * t459;
  t2149 = t1667 * t337;
  t2151 = t673 * t849;
  t2153 = t2118 + 0.4e1 * t691 * t862 * t290 + 0.4e1 * t691 * t875 * t290 + 0.2e1 * t691 * t346 * t711 + t2122 + 0.125e6 / 0.19683e5 * t2141 - t2120 - 0.5e2 / 0.27e2 * t877 * t677 + 0.5e2 / 0.27e2 * t1662 * t2146 + 0.25e2 / 0.108e3 * t2149 + 0.25e2 / 0.54e2 * t2151;
  t2155 = t684 * t54;
  t2156 = t2155 * t336;
  t2157 = t268 * t2156;
  t2159 = t267 * t886;
  t2164 = t658 * t350;
  t2167 = t673 * t853;
  t2169 = t848 * t852;
  t2170 = t268 * t2169;
  t2172 = t57 * t654;
  t2173 = t269 * t2172;
  t2174 = t268 * t2173;
  t2176 = t658 * t667;
  t2177 = t104 * t661;
  t2178 = t750 * t2177;
  t2179 = t2176 * t2178;
  t2181 = t750 * t2071;
  t2182 = t837 * t2181;
  t2185 = t459 * t104 * t692;
  t2186 = t1767 * t2185;
  t2190 = t459 * t263 * t290;
  t2191 = t668 * t2190;
  t2193 = t299 * t118;
  t2194 = t658 * t2193;
  t2195 = t2194 * t839;
  t2197 = t750 * t2074;
  t2198 = t837 * t2197;
  t2200 = t1782 * t843;
  t2202 = t141 * t274;
  t2203 = t666 * t2202;
  t2204 = t2203 * t843;
  t2207 = t459 * t104 * t711;
  t2208 = t668 * t2207;
  t2210 = t666 * t862;
  t2213 = t666 * t875;
  t2218 = t1772 * t346;
  t2221 = t350 * t117;
  t2222 = t666 * t2221;
  t2225 = 0.1e3 / 0.81e2 * t2191 - 0.25e4 / 0.729e3 * t2195 - 0.125e4 / 0.729e3 * t2198 - 0.25e2 / 0.54e2 * t2200 - 0.25e2 / 0.54e2 * t2204 - 0.25e2 / 0.108e3 * t2208 + 0.1e3 / 0.27e2 * t2210 * t276 + 0.1e3 / 0.27e2 * t2213 * t276 + 0.5e2 / 0.27e2 * t856 * t686 - 0.1e5 / 0.729e3 * t2218 * t663 + 0.1e3 / 0.27e2 * t2222 * t670;
  t2227 = 0.25e4 / 0.729e3 * t2058 - 0.2e3 / 0.27e2 * t2060 * t2062 - 0.2e1 * t281 * t2065 - t281 * t2092 - 0.2e1 * t281 * t2094 - t281 * t2097 + 0.2e1 * t691 * t2099 - t281 * t2102 + t135 * t2123 - 0.6e1 * t1747 * t346 * t692 + t2153 + 0.25e2 / 0.108e3 * t2157 - 0.1e3 / 0.27e2 * t2159 * t276 - 0.5e2 / 0.27e2 * t877 * t686 + 0.1e5 / 0.729e3 * t2164 * t663 - 0.1e3 / 0.81e2 * t2167 - 0.1e3 / 0.81e2 * t2170 + 0.55e3 / 0.243e3 * t2174 - 0.125e4 / 0.243e3 * t2179 + 0.2e5 / 0.2187e4 * t2182 + 0.25e2 / 0.54e2 * t2186 + t2225;
  t2232 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t352 - t2027 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t888 + t2005 - t2034 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t2227);
  tv3rho2sigma8 = t7 * t2232 + 0.2e1 * t893;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2239 = t6 * t412 * t369;
  t2246 = t6 * t421 * t369 / 0.12e2;
  t2248 = t6 * t162 * t933;
  t2252 = t1268 * t367;
  t2256 = t750 * t901 * t201;
  t2265 = t49 * t475;
  t2277 = 0.5e3 / 0.81e2 * t1879 * t49 - 0.5e4 / 0.243e3 * t777 + 0.5e3 / 0.81e2 * t490 * t2265 + 0.1e5 / 0.729e3 * t779 + 0.25e7 / 0.19683e5 * t1380 * t363 * t451 - 0.625e7 / 0.59049e5 * t782 + 0.625e6 / 0.19683e5 * t495 * t363 * t475 + 0.5e7 / 0.177147e6 * t785;
  t2278 = t83 * t2277;
  t2280 = t513 * t366;
  t2282 = t210 * t930;
  t2297 = t1930 * t49;
  t2300 = -0.1e6 / 0.2187e4 * t753 - 0.5e3 / 0.81e2 * t757 - 0.2e3 / 0.27e2 * t2252 * t1820 - 0.2e5 / 0.729e3 * t1275 * t2256 + 0.5e3 / 0.81e2 * t759 + 0.5e3 / 0.81e2 * t763 - 0.2e4 / 0.243e3 * t767 - t192 * t2278 - t192 * t2280 - 0.2e1 * t192 * t2282 - 0.6e1 * t1395 * t367 * t483 + 0.4e1 * t482 * t921 * t201 + 0.4e1 * t482 * t931 * t201 + 0.2e1 * t482 * t367 * t502 - 0.1e7 / 0.19683e5 * t1929 * t2297;
  t2302 = t366 * t451 * t459;
  t2309 = t1831 * t357;
  t2312 = t49 * t451;
  t2313 = t750 * t2312;
  t2317 = t459 * t49 * t483;
  t2322 = t750 * t2265;
  t2330 = t459 * t49 * t502;
  t2333 = t456 * t921;
  t2336 = t456 * t931;
  t2341 = t1274 * t367;
  t2344 = 0.5e2 / 0.27e2 * t1321 * t2302 - 0.5e2 / 0.27e2 * t1296 * t358 - 0.1e3 / 0.27e2 * t464 * t911 - 0.5e2 / 0.27e2 * t179 * t2309 + 0.1e5 / 0.243e3 * t1942 * t2313 - 0.1e3 / 0.27e2 * t1269 * t2317 + 0.2e5 / 0.729e3 * t1956 * t902 + 0.1e5 / 0.729e3 * t749 * t2322 + 0.1e3 / 0.27e2 * t1285 * t906 + 0.1e3 / 0.27e2 * t1965 * t906 + 0.5e2 / 0.27e2 * t458 * t2330 + 0.1e3 / 0.27e2 * t2333 * t187 + 0.1e3 / 0.27e2 * t2336 * t187 + 0.5e2 / 0.27e2 * t915 * t477 - 0.1e5 / 0.729e3 * t2341 * t453;
  t2345 = t2300 + t2344;
  t2350 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t369 - t2239 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t933 + t2246 - t2248 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2345);
  tv3rho2tau0 = t7 * t2350 + 0.2e1 * t938;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2357 = t6 * t538 * t386;
  t2361 = t6 * t542 * t386 / 0.12e2;
  t2363 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t386 - t2357 / 0.4e1 + t2361);
  tv3rho2tau1 = t7 * t2363 + 0.2e1 * t947;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2369 = t6 * t563 * t369;
  t2377 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t369 - t2369 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t933 - t2239 / 0.8e1 + t2246 - t2248 / 0.8e1);
  tv3rho2tau2 = t7 * t2377 + t938 + t953;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2383 = t6 * t587 * t386;
  t2390 = t6 * t228 * t990;
  t2393 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t386 - t2383 / 0.8e1 - t2357 / 0.8e1 + t2361 - 0.3e1 / 0.8e1 * t6 * t224 * t990 - t2390 / 0.8e1);
  tv3rho2tau3 = t7 * t2393 + t947 + t995;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2401 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t369 - t2369 / 0.4e1 + t2246);
  tv3rho2tau4 = t7 * t2401 + 0.2e1 * t953;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2414 = t1766 * t384;
  t2418 = t750 * t958 * t290;
  t2424 = t722 * t383;
  t2426 = t299 * t987;
  t2432 = t114 * t684;
  t2444 = 0.5e3 / 0.81e2 * t2068 * t114 - 0.5e4 / 0.243e3 * t864 + 0.5e3 / 0.81e2 * t699 * t2432 + 0.1e5 / 0.729e3 * t866 + 0.25e7 / 0.19683e5 * t1729 * t380 * t661 - 0.625e7 / 0.59049e5 * t869 + 0.625e6 / 0.19683e5 * t704 * t380 * t684 + 0.5e7 / 0.177147e6 * t872;
  t2445 = t141 * t2444;
  t2459 = t2139 * t114;
  t2462 = -0.1e6 / 0.2187e4 * t840 - 0.5e3 / 0.81e2 * t844 - 0.2e3 / 0.27e2 * t2414 * t2062 - 0.2e5 / 0.729e3 * t1773 * t2418 + 0.5e3 / 0.81e2 * t846 + 0.5e3 / 0.81e2 * t850 - 0.2e4 / 0.243e3 * t854 - t281 * t2424 - 0.2e1 * t281 * t2426 - t281 * t2445 + 0.4e1 * t691 * t978 * t290 + 0.4e1 * t691 * t988 * t290 + 0.2e1 * t691 * t384 * t711 - 0.6e1 * t1747 * t384 * t692 - 0.1e7 / 0.19683e5 * t2138 * t2459;
  t2467 = t2155 * t374;
  t2471 = t383 * t661 * t459;
  t2474 = t114 * t661;
  t2475 = t750 * t2474;
  t2479 = t459 * t114 * t692;
  t2484 = t1772 * t384;
  t2489 = t750 * t2432;
  t2497 = t459 * t114 * t711;
  t2500 = t666 * t978;
  t2503 = t666 * t988;
  t2506 = -0.5e2 / 0.27e2 * t1667 * t375 - 0.1e3 / 0.27e2 * t673 * t968 - 0.5e2 / 0.27e2 * t268 * t2467 + 0.5e2 / 0.27e2 * t1662 * t2471 + 0.1e5 / 0.243e3 * t2176 * t2475 - 0.1e3 / 0.27e2 * t1767 * t2479 + 0.5e2 / 0.27e2 * t972 * t686 - 0.1e5 / 0.729e3 * t2484 * t663 + 0.2e5 / 0.729e3 * t2194 * t959 + 0.1e5 / 0.729e3 * t837 * t2489 + 0.1e3 / 0.27e2 * t1782 * t963 + 0.1e3 / 0.27e2 * t2203 * t963 + 0.5e2 / 0.27e2 * t668 * t2497 + 0.1e3 / 0.27e2 * t2500 * t276 + 0.1e3 / 0.27e2 * t2503 * t276;
  t2507 = t2462 + t2506;
  t2512 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t386 - t2383 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t990 + t2361 - t2390 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t2507);
  tv3rho2tau5 = t7 * t2512 + 0.2e1 * t995;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2519 = t6 * t162 * t1034 / 0.8e1;
  t2520 = t326 * t787;
  t2523 = t210 * t1027;
  t2525 = t185 * t65;
  t2526 = t2525 * t999;
  t2528 = t490 * t740;
  t2531 = t1380 * t1024 * t185;
  t2533 = t72 * t740;
  t2534 = t495 * t2533;
  t2536 = 0.125e3 / 0.1296e4 * t2526 - 0.125e3 / 0.243e3 * t2528 + 0.78125e5 / 0.39366e5 * t2531 - 0.15625e6 / 0.59049e5 * t2534;
  t2537 = t83 * t2536;
  t2539 = t1032 * t201;
  t2541 = t210 * t1015;
  t2544 = t799 * t321;
  t2548 = t459 * t1007 * t201;
  t2549 = t1269 * t2548;
  t2552 = t750 * t1007 * t185;
  t2553 = t1275 * t2552;
  t2555 = t1335 * rho[0];
  t2556 = 0.1e1 / t2555;
  t2557 = t65 * t2556;
  t2558 = t2557 * sigma[0];
  t2561 = t459 * t740;
  t2565 = 0.125e3 / 0.9565938e7 * t1351 * t2558;
  t2567 = 0.5e2 / 0.177147e6 * t430 * t2561;
  t2568 = -0.125e3 / 0.9565938e7 * t1332 * t2558 + 0.5e2 / 0.177147e6 * t507 * t2561 + t2565 - t2567;
  t2582 = t179 * t2561;
  t2584 = t1360 * t185;
  t2585 = t1930 * t999;
  t2586 = t2584 * t2585;
  t2588 = t464 * t1000;
  t2590 = -0.2e1 * t192 * t2520 - t192 * t2523 - t192 * t2537 - t192 * t2539 + 0.2e1 * t482 * t2541 - 0.2e1 * t192 * t2544 + 0.25e2 / 0.27e2 * t2549 + 0.25e4 / 0.729e3 * t2553 + t77 * t2568 + 0.4e1 * t482 * t322 * t787 + 0.4e1 * t482 * t1019 * t201 + t2567 + 0.2e1 * t482 * t1028 * t201 - t2565 - 0.6e1 * t1395 * t1016 * t201 + 0.25e2 / 0.162e3 * t2582 - 0.15625e5 / 0.19683e5 * t2586 - 0.25e2 / 0.864e3 * t2588;
  t2591 = t790 * t766;
  t2594 = t448 * t450 * t740;
  t2595 = t447 * t2594;
  t2597 = t999 * t54;
  t2598 = t2597 * t1322;
  t2599 = t1321 * t2598;
  t2601 = t178 * t1032;
  t2604 = t1327 * t1004;
  t2606 = t1835 * t313;
  t2608 = t790 * t762;
  t2610 = t174 * t321;
  t2611 = t459 * t2610;
  t2612 = t458 * t2611;
  t2614 = t1285 * t1008;
  t2616 = t1965 * t1008;
  t2618 = t39 * t787;
  t2619 = t459 * t2618;
  t2620 = t458 * t2619;
  t2622 = t1984 * t756;
  t2624 = t326 * t53;
  t2625 = t446 * t2624;
  t2626 = t2625 * t752;
  t2628 = t1268 * t1016;
  t2631 = t456 * t1019;
  t2634 = t456 * t1028;
  t2637 = t999 * t185;
  t2639 = t1942 * t750 * t2637;
  t2641 = t999 * t201;
  t2642 = t750 * t2641;
  t2643 = t1275 * t2642;
  t2645 = -0.1e3 / 0.81e2 * t2591 - 0.25e4 / 0.2187e4 * t2595 + 0.25e2 / 0.864e3 * t2599 - 0.5e2 / 0.27e2 * t2601 * t187 + 0.625e3 / 0.2916e4 * t2604 + 0.25e2 / 0.54e2 * t2606 + 0.25e2 / 0.54e2 * t2608 + 0.1e3 / 0.81e2 * t2612 - 0.25e2 / 0.54e2 * t2614 - 0.25e2 / 0.54e2 * t2616 - 0.25e2 / 0.54e2 * t2620 - 0.25e2 / 0.54e2 * t2622 - 0.25e4 / 0.729e3 * t2626 - 0.1e3 / 0.27e2 * t2628 * t187 + 0.1e3 / 0.27e2 * t2631 * t187 + 0.5e2 / 0.27e2 * t2634 * t187 + 0.625e3 / 0.972e3 * t2639 - 0.625e3 / 0.2916e4 * t2643;
  t2646 = t2590 + t2645;
  t2651 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t1034 - t2519 - 0.3e1 / 0.8e1 * t6 * t28 * t2646);
  tv3rhosigma20 = t7 * t2651 + t1038;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2658 = t6 * t228 * t1076 / 0.8e1;
  t2660 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t1076 - t2658);
  tv3rhosigma25 = t7 * t2660 + t1080;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2666 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t1034 - t2519);
  tv3rhosigma26 = t7 * t2666 + t1038;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2671 = t1694 * rho[1];
  t2672 = 0.1e1 / t2671;
  t2673 = t65 * t2672;
  t2674 = t2673 * sigma[2];
  t2677 = t459 * t828;
  t2681 = 0.125e3 / 0.9565938e7 * t1710 * t2674;
  t2683 = 0.5e2 / 0.177147e6 * t642 * t2677;
  t2684 = -0.125e3 / 0.9565938e7 * t1691 * t2674 + 0.5e2 / 0.177147e6 * t716 * t2677 + t2681 - t2683;
  t2686 = t886 * t345;
  t2689 = t350 * t874;
  t2692 = t299 * t1069;
  t2694 = t274 * t65;
  t2695 = t2694 * t1041;
  t2697 = t699 * t828;
  t2700 = t1729 * t1066 * t274;
  t2702 = t72 * t828;
  t2703 = t704 * t2702;
  t2705 = 0.125e3 / 0.1296e4 * t2695 - 0.125e3 / 0.243e3 * t2697 + 0.78125e5 / 0.39366e5 * t2700 - 0.15625e6 / 0.59049e5 * t2703;
  t2706 = t141 * t2705;
  t2708 = t1074 * t290;
  t2710 = t299 * t1057;
  t2714 = t459 * t1049 * t290;
  t2715 = t1767 * t2714;
  t2718 = t750 * t1049 * t274;
  t2719 = t1773 * t2718;
  t2733 = t673 * t1042;
  t2735 = t268 * t2677;
  t2737 = t1759 * t274;
  t2738 = t2139 * t1041;
  t2739 = t2737 * t2738;
  t2741 = t135 * t2684 - 0.2e1 * t281 * t2686 - 0.2e1 * t281 * t2689 - t281 * t2692 - t281 * t2706 - t281 * t2708 + 0.2e1 * t691 * t2710 + 0.25e2 / 0.27e2 * t2715 + 0.25e4 / 0.729e3 * t2719 - t2681 - 0.6e1 * t1747 * t1058 * t290 + 0.4e1 * t691 * t346 * t874 + 0.4e1 * t691 * t1061 * t290 + 0.2e1 * t691 * t1070 * t290 + t2683 - 0.25e2 / 0.864e3 * t2733 + 0.25e2 / 0.162e3 * t2735 - 0.15625e5 / 0.19683e5 * t2739;
  t2742 = t877 * t849;
  t2744 = t1041 * t54;
  t2745 = t2744 * t1663;
  t2746 = t1662 * t2745;
  t2748 = t267 * t1074;
  t2752 = t660 * t450 * t828;
  t2753 = t659 * t2752;
  t2755 = t877 * t853;
  t2757 = t1686 * t1046;
  t2759 = t2159 * t337;
  t2761 = t666 * t1061;
  t2764 = t666 * t1070;
  t2767 = t1041 * t290;
  t2768 = t750 * t2767;
  t2769 = t1773 * t2768;
  t2772 = t750 * t1041 * t274;
  t2773 = t2176 * t2772;
  t2775 = t1782 * t1050;
  t2777 = t2203 * t1050;
  t2779 = t104 * t874;
  t2780 = t459 * t2779;
  t2781 = t668 * t2780;
  t2783 = t2222 * t843;
  t2785 = t350 * t118;
  t2786 = t658 * t2785;
  t2787 = t2786 * t839;
  t2789 = t1766 * t1058;
  t2792 = t263 * t345;
  t2793 = t459 * t2792;
  t2794 = t668 * t2793;
  t2796 = 0.25e2 / 0.54e2 * t2742 + 0.25e2 / 0.864e3 * t2746 - 0.5e2 / 0.27e2 * t2748 * t276 - 0.25e4 / 0.2187e4 * t2753 - 0.1e3 / 0.81e2 * t2755 + 0.625e3 / 0.2916e4 * t2757 + 0.25e2 / 0.54e2 * t2759 + 0.1e3 / 0.27e2 * t2761 * t276 + 0.5e2 / 0.27e2 * t2764 * t276 - 0.625e3 / 0.2916e4 * t2769 + 0.625e3 / 0.972e3 * t2773 - 0.25e2 / 0.54e2 * t2775 - 0.25e2 / 0.54e2 * t2777 - 0.25e2 / 0.54e2 * t2781 - 0.25e2 / 0.54e2 * t2783 - 0.25e4 / 0.729e3 * t2787 - 0.1e3 / 0.27e2 * t2789 * t276 + 0.1e3 / 0.81e2 * t2794;
  t2797 = t2741 + t2796;
  t2802 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t1076 - t2658 - 0.3e1 / 0.8e1 * t6 * t99 * t2797);
  tv3rhosigma211 = t7 * t2802 + t1080;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2809 = t6 * t162 * t1112 / 0.8e1;
  t2810 = t326 * t930;
  t2812 = t210 * t1109;
  t2814 = t2525 * t1082;
  t2818 = t1380 * t1106 * t185;
  t2821 = -0.125e3 / 0.162e3 * t2814 + 0.1625e4 / 0.486e3 * t1022 - 0.3125e6 / 0.19683e5 * t2818 + 0.1015625e7 / 0.59049e5 * t1025;
  t2822 = t83 * t2821;
  t2824 = t799 * t366;
  t2828 = t459 * t1087 * t201;
  t2832 = t750 * t1087 * t185;
  t2835 = t312 * t201;
  t2836 = t180 * t2835;
  t2837 = t2252 * t2836;
  t2839 = t450 * t39;
  t2841 = t448 * t2839 * t185;
  t2842 = t2341 * t2841;
  t2844 = t321 * t52;
  t2845 = t459 * t185;
  t2846 = t2844 * t2845;
  t2866 = t1930 * t1082;
  t2867 = t2584 * t2866;
  t2869 = t464 * t1094;
  t2871 = -t192 * t2810 - t192 * t2812 - t192 * t2822 - t192 * t2824 - 0.25e3 / 0.81e2 * t1009 - 0.1e3 / 0.27e2 * t1269 * t2828 - 0.1e5 / 0.729e3 * t1275 * t2832 + 0.25e2 / 0.54e2 * t2837 + 0.125e4 / 0.729e3 * t2842 - 0.1e3 / 0.27e2 * t2252 * t2846 + 0.1625e5 / 0.2187e4 * t1005 + 0.25e3 / 0.81e2 * t1011 + 0.2e1 * t482 * t367 * t787 + 0.2e1 * t482 * t1102 * t201 + 0.2e1 * t482 * t1110 * t201 + 0.2e1 * t482 * t921 * t321 + 0.2e1 * t482 * t931 * t321 + 0.125e6 / 0.19683e5 * t2867 + 0.25e2 / 0.108e3 * t2869;
  t2872 = t1395 * t83;
  t2873 = t366 * t321;
  t2874 = t2873 * t201;
  t2877 = t1093 * t1322;
  t2878 = t1321 * t2877;
  t2880 = t1327 * t1084;
  t2891 = t49 * t787;
  t2892 = t459 * t2891;
  t2899 = t2333 * t313;
  t2901 = t2336 * t313;
  t2903 = t915 * t762;
  t2905 = t456 * t1102;
  t2908 = t456 * t1110;
  t2911 = t1082 * t201;
  t2912 = t750 * t2911;
  t2913 = t1275 * t2912;
  t2916 = t750 * t1082 * t185;
  t2917 = t1942 * t2916;
  t2919 = t915 * t766;
  t2921 = -0.6e1 * t2872 * t2874 - 0.25e2 / 0.108e3 * t2878 - 0.125e4 / 0.729e3 * t2880 - 0.5e2 / 0.27e2 * t1835 * t358 - 0.5e2 / 0.27e2 * t790 * t911 - 0.325e3 / 0.324e3 * t1013 + 0.5e2 / 0.27e2 * t1285 * t1088 + 0.5e2 / 0.27e2 * t1965 * t1088 + 0.5e2 / 0.27e2 * t458 * t2892 + 0.5e2 / 0.27e2 * t1984 * t906 + 0.1e5 / 0.729e3 * t2625 * t902 - 0.25e2 / 0.108e3 * t2899 - 0.25e2 / 0.108e3 * t2901 - 0.25e2 / 0.108e3 * t2903 + 0.5e2 / 0.27e2 * t2905 * t187 + 0.5e2 / 0.27e2 * t2908 * t187 + 0.125e4 / 0.729e3 * t2913 - 0.125e4 / 0.243e3 * t2917 + 0.5e2 / 0.81e2 * t2919;
  t2922 = t2871 + t2921;
  t2927 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t1112 - t2809 - 0.3e1 / 0.8e1 * t6 * t28 * t2922);
  tv3rhosigmatau0 = t7 * t2927 + t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2934 = t6 * t228 * t1148 / 0.8e1;
  t2936 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t1148 - t2934);
  tv3rhosigmatau5 = t7 * t2936 + t1152;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2942 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t1112 - t2809);
  tv3rhosigmatau6 = t7 * t2942 + t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2948 = t336 * t290;
  t2949 = t269 * t2948;
  t2950 = t2414 * t2949;
  t2952 = t450 * t104;
  t2954 = t660 * t2952 * t274;
  t2955 = t2484 * t2954;
  t2957 = t345 * t117;
  t2958 = t459 * t274;
  t2959 = t2957 * t2958;
  t2963 = t459 * t1123 * t290;
  t2967 = t750 * t1123 * t274;
  t2987 = t2139 * t1118;
  t2988 = t2737 * t2987;
  t2990 = t673 * t1130;
  t2992 = t1747 * t141;
  t2993 = t383 * t345;
  t2994 = t2993 * t290;
  t3001 = t1129 * t1663;
  t3002 = t1662 * t3001;
  t3004 = -0.25e3 / 0.81e2 * t1051 + 0.25e2 / 0.54e2 * t2950 + 0.125e4 / 0.729e3 * t2955 - 0.1e3 / 0.27e2 * t2414 * t2959 - 0.1e3 / 0.27e2 * t1767 * t2963 - 0.1e5 / 0.729e3 * t1773 * t2967 + 0.1625e5 / 0.2187e4 * t1047 + 0.25e3 / 0.81e2 * t1053 + 0.2e1 * t691 * t1138 * t290 + 0.2e1 * t691 * t1146 * t290 + 0.2e1 * t691 * t978 * t345 + 0.2e1 * t691 * t988 * t345 + 0.2e1 * t691 * t384 * t874 + 0.125e6 / 0.19683e5 * t2988 + 0.25e2 / 0.108e3 * t2990 - 0.6e1 * t2992 * t2994 - 0.5e2 / 0.27e2 * t2159 * t375 - 0.5e2 / 0.27e2 * t877 * t968 - 0.25e2 / 0.108e3 * t3002;
  t3005 = t1686 * t1120;
  t3008 = t886 * t383;
  t3010 = t350 * t987;
  t3012 = t299 * t1145;
  t3014 = t2694 * t1118;
  t3018 = t1729 * t1142 * t274;
  t3021 = -0.125e3 / 0.162e3 * t3014 + 0.1625e4 / 0.486e3 * t1064 - 0.3125e6 / 0.19683e5 * t3018 + 0.1015625e7 / 0.59049e5 * t1067;
  t3022 = t141 * t3021;
  t3024 = t2500 * t337;
  t3026 = t2503 * t337;
  t3028 = t972 * t849;
  t3030 = t666 * t1138;
  t3033 = t666 * t1146;
  t3036 = t1118 * t290;
  t3037 = t750 * t3036;
  t3038 = t1773 * t3037;
  t3042 = t2176 * t750 * t1118 * t274;
  t3048 = t114 * t874;
  t3049 = t459 * t3048;
  t3056 = t972 * t853;
  t3058 = -0.125e4 / 0.729e3 * t3005 - 0.325e3 / 0.324e3 * t1055 - t281 * t3008 - t281 * t3010 - t281 * t3012 - t281 * t3022 - 0.25e2 / 0.108e3 * t3024 - 0.25e2 / 0.108e3 * t3026 - 0.25e2 / 0.108e3 * t3028 + 0.5e2 / 0.27e2 * t3030 * t276 + 0.5e2 / 0.27e2 * t3033 * t276 + 0.125e4 / 0.729e3 * t3038 - 0.125e4 / 0.243e3 * t3042 + 0.5e2 / 0.27e2 * t1782 * t1124 + 0.5e2 / 0.27e2 * t2203 * t1124 + 0.5e2 / 0.27e2 * t668 * t3049 + 0.5e2 / 0.27e2 * t2222 * t963 + 0.1e5 / 0.729e3 * t2786 * t959 + 0.5e2 / 0.81e2 * t3056;
  t3059 = t3004 + t3058;
  t3064 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t1148 - t2934 - 0.3e1 / 0.8e1 * t6 * t99 * t3059);
  tv3rhosigmatau11 = t7 * t3064 + t1152;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3071 = t6 * t162 * t1179 / 0.8e1;
  t3072 = t1930 * t1154;
  t3075 = t1154 * t201;
  t3076 = t750 * t3075;
  t3082 = t750 * t1154 * t185;
  t3087 = t750 * t1159 * t185;
  t3091 = t459 * t1159 * t201;
  t3099 = t49 * t930;
  t3100 = t459 * t3099;
  t3103 = -0.1e7 / 0.19683e5 * t2584 * t3072 - 0.1e5 / 0.729e3 * t1275 * t3076 + 0.1e5 / 0.729e3 * t1327 * t1156 + 0.1e5 / 0.243e3 * t1942 * t3082 - 0.1e6 / 0.2187e4 * t1085 - 0.2e5 / 0.729e3 * t1275 * t3087 - 0.2e3 / 0.27e2 * t1269 * t3091 + 0.1e3 / 0.27e2 * t1285 * t1160 + 0.1e3 / 0.27e2 * t1965 * t1160 - 0.5e3 / 0.81e2 * t1097 + 0.1e3 / 0.27e2 * t458 * t3100;
  t3104 = t1163 * t1322;
  t3110 = t1268 * t1168;
  t3116 = t210 * t1167;
  t3122 = t456 * t1177;
  t3128 = t210 * t1176;
  t3137 = 0.5e3 / 0.81e2 * t2525 * t1154 - 0.5e4 / 0.243e3 * t1104 + 0.25e7 / 0.19683e5 * t1380 * t1173 * t185 - 0.625e7 / 0.59049e5 * t1107;
  t3138 = t83 * t3137;
  t3140 = 0.5e2 / 0.27e2 * t1321 * t3104 - 0.5e2 / 0.27e2 * t464 * t1164 + 0.5e3 / 0.81e2 * t1095 - 0.1e3 / 0.27e2 * t3110 * t187 - 0.6e1 * t1395 * t1168 * t201 + 0.2e1 * t482 * t3116 + 0.4e1 * t482 * t367 * t930 + 0.5e2 / 0.27e2 * t3122 * t187 + 0.2e1 * t482 * t1177 * t201 - t192 * t3128 - t192 * t3138;
  t3141 = t3103 + t3140;
  t3146 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t1179 - t3071 - 0.3e1 / 0.8e1 * t6 * t28 * t3141);
  tv3rhotau20 = t7 * t3146 + t1183;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3153 = t6 * t228 * t1210 / 0.8e1;
  t3155 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t1210 - t3153);
  tv3rhotau22 = t7 * t3155 + t1214;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3161 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t1179 - t3071);
  tv3rhotau23 = t7 * t3161 + t1183;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3166 = t2139 * t1185;
  t3169 = t1185 * t290;
  t3170 = t750 * t3169;
  t3176 = t750 * t1185 * t274;
  t3181 = t750 * t1190 * t274;
  t3185 = t459 * t1190 * t290;
  t3193 = t114 * t987;
  t3194 = t459 * t3193;
  t3197 = -0.1e7 / 0.19683e5 * t2737 * t3166 - 0.1e5 / 0.729e3 * t1773 * t3170 + 0.1e5 / 0.729e3 * t1686 * t1187 + 0.1e5 / 0.243e3 * t2176 * t3176 - 0.1e6 / 0.2187e4 * t1121 - 0.2e5 / 0.729e3 * t1773 * t3181 - 0.2e3 / 0.27e2 * t1767 * t3185 + 0.1e3 / 0.27e2 * t1782 * t1191 + 0.1e3 / 0.27e2 * t2203 * t1191 - 0.5e3 / 0.81e2 * t1133 + 0.1e3 / 0.27e2 * t668 * t3194;
  t3198 = t1194 * t1663;
  t3204 = t1766 * t1199;
  t3210 = t299 * t1198;
  t3216 = t666 * t1208;
  t3222 = t299 * t1207;
  t3231 = 0.5e3 / 0.81e2 * t2694 * t1185 - 0.5e4 / 0.243e3 * t1140 + 0.25e7 / 0.19683e5 * t1729 * t1204 * t274 - 0.625e7 / 0.59049e5 * t1143;
  t3232 = t141 * t3231;
  t3234 = 0.5e2 / 0.27e2 * t1662 * t3198 - 0.5e2 / 0.27e2 * t673 * t1195 + 0.5e3 / 0.81e2 * t1131 - 0.1e3 / 0.27e2 * t3204 * t276 - 0.6e1 * t1747 * t1199 * t290 + 0.2e1 * t691 * t3210 + 0.4e1 * t691 * t384 * t987 + 0.5e2 / 0.27e2 * t3216 * t276 + 0.2e1 * t691 * t1208 * t290 - t281 * t3222 - t281 * t3232;
  t3235 = t3197 + t3234;
  t3240 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t1210 - t3153 - 0.3e1 / 0.8e1 * t6 * t99 * t3235);
  tv3rhotau25 = t7 * t3240 + t1214;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3242 = 0.1e1 / t1335;
  t3243 = t3242 * t65;
  t3245 = t1351 * t3243;
  t3247 = 0.125e3 / 0.25509168e8 * t1332 * t3243 - 0.125e3 / 0.25509168e8 * t3245;
  t3249 = t790 * t1000;
  t3251 = t3242 * t76;
  t3253 = t1360 * t3251 * t83;
  t3255 = t1015 * t321;
  t3256 = t83 * t3255;
  t3263 = t326 * t1015;
  t3266 = t1032 * t321;
  t3269 = t326 * t1027;
  t3273 = t72 * t3242;
  t3274 = t1380 * t3273;
  t3276 = -0.125e3 / 0.10368e5 * t3243 - 0.78125e5 / 0.314928e6 * t3274;
  t3277 = t83 * t3276;
  t3279 = t999 * t321;
  t3280 = t750 * t3279;
  t3281 = t1275 * t3280;
  t3283 = t1984 * t1008;
  t3285 = t39 * t1027;
  t3286 = t459 * t3285;
  t3287 = t458 * t3286;
  t3289 = t39 * t1015;
  t3290 = t459 * t3289;
  t3291 = t1269 * t3290;
  t3293 = t1840 * t1004;
  t3295 = t450 * t3242;
  t3296 = t1315 * t3295;
  t3297 = t447 * t3296;
  t3299 = t57 * t321;
  t3300 = t2597 * t3299;
  t3301 = t1321 * t3300;
  t3303 = t2601 * t313;
  t3305 = t77 * t3247 - 0.25e2 / 0.288e3 * t3249 + 0.15625e5 / 0.157464e6 * t3253 - 0.6e1 * t1395 * t3256 + 0.6e1 * t482 * t322 * t1027 + 0.125e3 / 0.25509168e8 * t3245 + 0.6e1 * t482 * t3263 - 0.3e1 * t192 * t3266 - 0.3e1 * t192 * t3269 - t192 * t3277 - 0.625e3 / 0.972e3 * t3281 - 0.25e2 / 0.18e2 * t3283 - 0.25e2 / 0.36e2 * t3287 + 0.25e2 / 0.18e2 * t3291 + 0.625e3 / 0.972e3 * t3293 - 0.625e3 / 0.7776e4 * t3297 + 0.25e2 / 0.288e3 * t3301 + 0.25e2 / 0.36e2 * t3303;
  t3309 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3305);
  tv3sigma30 = t7 * t3309;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3310 = 0.1e1 / t1694;
  t3311 = t3310 * t134;
  t3313 = t1759 * t3311 * t141;
  t3315 = t1057 * t345;
  t3316 = t141 * t3315;
  t3322 = t3310 * t65;
  t3323 = t1710 * t3322;
  t3325 = t350 * t1057;
  t3328 = t1074 * t345;
  t3331 = t350 * t1069;
  t3335 = t72 * t3310;
  t3336 = t1729 * t3335;
  t3338 = -0.125e3 / 0.10368e5 * t3322 - 0.78125e5 / 0.314928e6 * t3336;
  t3339 = t141 * t3338;
  t3343 = 0.125e3 / 0.25509168e8 * t1691 * t3322 - 0.125e3 / 0.25509168e8 * t3323;
  t3345 = t877 * t1042;
  t3347 = t1041 * t345;
  t3348 = t750 * t3347;
  t3349 = t1773 * t3348;
  t3351 = t2222 * t1050;
  t3353 = t104 * t1069;
  t3354 = t459 * t3353;
  t3355 = t668 * t3354;
  t3357 = t104 * t1057;
  t3358 = t459 * t3357;
  t3359 = t1767 * t3358;
  t3361 = t2164 * t1046;
  t3363 = t450 * t3310;
  t3364 = t1656 * t3363;
  t3365 = t659 * t3364;
  t3367 = t57 * t345;
  t3368 = t2744 * t3367;
  t3369 = t1662 * t3368;
  t3371 = t2748 * t337;
  t3373 = 0.15625e5 / 0.157464e6 * t3313 - 0.6e1 * t1747 * t3316 + 0.6e1 * t691 * t346 * t1069 + 0.125e3 / 0.25509168e8 * t3323 + 0.6e1 * t691 * t3325 - 0.3e1 * t281 * t3328 - 0.3e1 * t281 * t3331 - t281 * t3339 + t135 * t3343 - 0.25e2 / 0.288e3 * t3345 - 0.625e3 / 0.972e3 * t3349 - 0.25e2 / 0.18e2 * t3351 - 0.25e2 / 0.36e2 * t3355 + 0.25e2 / 0.18e2 * t3359 + 0.625e3 / 0.972e3 * t3361 - 0.625e3 / 0.7776e4 * t3365 + 0.25e2 / 0.288e3 * t3369 + 0.25e2 / 0.36e2 * t3371;
  t3377 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3373);
  tv3sigma39 = t7 * t3377;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3378 = t790 * t1094;
  t3383 = 0.1e1 / t435;
  t3384 = t3383 * t76;
  t3386 = t1360 * t3384 * t83;
  t3397 = t326 * t1109;
  t3400 = t3383 * t65;
  t3402 = t72 * t3383;
  t3403 = t1380 * t3402;
  t3405 = 0.125e3 / 0.1296e4 * t3400 + 0.78125e5 / 0.39366e5 * t3403;
  t3406 = t83 * t3405;
  t3408 = t1032 * t366;
  t3410 = t2905 * t313;
  t3412 = t2908 * t313;
  t3414 = 0.25e2 / 0.54e2 * t3378 - 0.6e1 * t1395 * t367 * t1015 - 0.15625e5 / 0.19683e5 * t3386 + 0.4e1 * t482 * t1102 * t321 + 0.4e1 * t482 * t1110 * t321 + 0.2e1 * t482 * t367 * t1027 - 0.2e1 * t192 * t3397 - t192 * t3406 - t192 * t3408 - 0.25e2 / 0.54e2 * t3410 - 0.25e2 / 0.54e2 * t3412;
  t3415 = t2341 * t1004;
  t3417 = t1082 * t321;
  t3418 = t750 * t3417;
  t3419 = t1275 * t3418;
  t3423 = t49 * t1027;
  t3424 = t459 * t3423;
  t3427 = t312 * t321;
  t3428 = t180 * t3427;
  t3429 = t2252 * t3428;
  t3431 = t49 * t1015;
  t3432 = t459 * t3431;
  t3435 = t366 * t999;
  t3436 = t3435 * t459;
  t3437 = t1321 * t3436;
  t3439 = t1840 * t1084;
  t3441 = t450 * t3383;
  t3442 = t1315 * t3441;
  t3443 = t447 * t3442;
  t3445 = t1093 * t3299;
  t3446 = t1321 * t3445;
  t3450 = -0.625e3 / 0.2916e4 * t3415 + 0.25e4 / 0.729e3 * t3419 + 0.1e3 / 0.27e2 * t1984 * t1088 + 0.5e2 / 0.27e2 * t458 * t3424 + 0.25e2 / 0.27e2 * t3429 - 0.1e3 / 0.27e2 * t1269 * t3432 + 0.25e2 / 0.864e3 * t3437 - 0.25e4 / 0.729e3 * t3439 + 0.625e3 / 0.972e3 * t3443 - 0.25e2 / 0.54e2 * t3446 - 0.5e2 / 0.27e2 * t2601 * t358;
  t3451 = t3414 + t3450;
  t3455 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3451);
  tv3sigma2tau0 = t7 * t3455;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3458 = t114 * t1069;
  t3459 = t459 * t3458;
  t3462 = t3030 * t337;
  t3464 = t3033 * t337;
  t3466 = t2484 * t1046;
  t3468 = t1118 * t345;
  t3469 = t750 * t3468;
  t3470 = t1773 * t3469;
  t3472 = t114 * t1057;
  t3473 = t459 * t3472;
  t3476 = t336 * t345;
  t3477 = t269 * t3476;
  t3478 = t2414 * t3477;
  t3483 = t877 * t1130;
  t3488 = 0.1e3 / 0.27e2 * t2222 * t1124 + 0.5e2 / 0.27e2 * t668 * t3459 - 0.25e2 / 0.54e2 * t3462 - 0.25e2 / 0.54e2 * t3464 - 0.625e3 / 0.2916e4 * t3466 + 0.25e4 / 0.729e3 * t3470 - 0.1e3 / 0.27e2 * t1767 * t3473 + 0.25e2 / 0.27e2 * t3478 - 0.6e1 * t1747 * t384 * t1057 + 0.25e2 / 0.54e2 * t3483 + 0.4e1 * t691 * t1146 * t345;
  t3492 = 0.1e1 / t647;
  t3493 = t3492 * t134;
  t3495 = t1759 * t3493 * t141;
  t3500 = t1074 * t383;
  t3502 = t350 * t1145;
  t3505 = t3492 * t65;
  t3507 = t72 * t3492;
  t3508 = t1729 * t3507;
  t3510 = 0.125e3 / 0.1296e4 * t3505 + 0.78125e5 / 0.39366e5 * t3508;
  t3511 = t141 * t3510;
  t3513 = t2164 * t1120;
  t3515 = t450 * t3492;
  t3516 = t1656 * t3515;
  t3517 = t659 * t3516;
  t3519 = t1129 * t3367;
  t3520 = t1662 * t3519;
  t3524 = t383 * t1041;
  t3525 = t3524 * t459;
  t3526 = t1662 * t3525;
  t3528 = 0.2e1 * t691 * t384 * t1069 - 0.15625e5 / 0.19683e5 * t3495 + 0.4e1 * t691 * t1138 * t345 - t281 * t3500 - 0.2e1 * t281 * t3502 - t281 * t3511 - 0.25e4 / 0.729e3 * t3513 + 0.625e3 / 0.972e3 * t3517 - 0.25e2 / 0.54e2 * t3520 - 0.5e2 / 0.27e2 * t2748 * t375 + 0.25e2 / 0.864e3 * t3526;
  t3529 = t3488 + t3528;
  t3533 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3529);
  tv3sigma2tau11 = t7 * t3533;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3534 = 0.1e1 / t738;
  t3535 = t3534 * t76;
  t3537 = t1360 * t3535 * t83;
  t3539 = t1154 * t321;
  t3540 = t750 * t3539;
  t3545 = t450 * t3534;
  t3546 = t1315 * t3545;
  t3547 = t447 * t3546;
  t3549 = t1082 * t366;
  t3550 = t750 * t3549;
  t3551 = t1275 * t3550;
  t3554 = t459 * t1159 * t321;
  t3559 = t57 * t366;
  t3560 = t1093 * t3559;
  t3561 = t1321 * t3560;
  t3563 = t49 * t1109;
  t3564 = t459 * t3563;
  t3567 = t1163 * t3299;
  t3572 = t3110 * t313;
  t3577 = t326 * t1167;
  t3583 = t3122 * t313;
  t3588 = t326 * t1176;
  t3590 = t3534 * t65;
  t3592 = t72 * t3534;
  t3593 = t1380 * t3592;
  t3595 = -0.125e3 / 0.162e3 * t3590 - 0.3125e6 / 0.19683e5 * t3593;
  t3596 = t83 * t3595;
  t3598 = 0.125e6 / 0.19683e5 * t3537 - 0.1e5 / 0.729e3 * t1275 * t3540 + 0.1e5 / 0.729e3 * t1840 * t1156 - 0.125e4 / 0.243e3 * t3547 + 0.25e4 / 0.729e3 * t3551 - 0.2e3 / 0.27e2 * t1269 * t3554 + 0.1e3 / 0.27e2 * t1984 * t1160 - 0.25e2 / 0.54e2 * t3561 + 0.1e3 / 0.27e2 * t458 * t3564 + 0.5e2 / 0.27e2 * t1321 * t3567 - 0.5e2 / 0.27e2 * t790 * t1164 + 0.25e2 / 0.54e2 * t3572 - 0.6e1 * t1395 * t1168 * t321 + 0.2e1 * t482 * t3577 + 0.4e1 * t482 * t367 * t1109 - 0.25e2 / 0.108e3 * t3583 + 0.2e1 * t482 * t1177 * t321 - t192 * t3588 - t192 * t3596;
  t3602 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3598);
  tv3sigmatau20 = t7 * t3602;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3603 = 0.1e1 / t826;
  t3604 = t3603 * t134;
  t3606 = t1759 * t3604 * t141;
  t3608 = t1185 * t345;
  t3609 = t750 * t3608;
  t3614 = t450 * t3603;
  t3615 = t1656 * t3614;
  t3616 = t659 * t3615;
  t3618 = t1118 * t383;
  t3619 = t750 * t3618;
  t3620 = t1773 * t3619;
  t3623 = t459 * t1190 * t345;
  t3628 = t57 * t383;
  t3629 = t1129 * t3628;
  t3630 = t1662 * t3629;
  t3632 = t114 * t1145;
  t3633 = t459 * t3632;
  t3636 = t1194 * t3367;
  t3641 = t3204 * t337;
  t3646 = t350 * t1198;
  t3652 = t3216 * t337;
  t3657 = t350 * t1207;
  t3659 = t3603 * t65;
  t3661 = t72 * t3603;
  t3662 = t1729 * t3661;
  t3664 = -0.125e3 / 0.162e3 * t3659 - 0.3125e6 / 0.19683e5 * t3662;
  t3665 = t141 * t3664;
  t3667 = 0.125e6 / 0.19683e5 * t3606 - 0.1e5 / 0.729e3 * t1773 * t3609 + 0.1e5 / 0.729e3 * t2164 * t1187 - 0.125e4 / 0.243e3 * t3616 + 0.25e4 / 0.729e3 * t3620 - 0.2e3 / 0.27e2 * t1767 * t3623 + 0.1e3 / 0.27e2 * t2222 * t1191 - 0.25e2 / 0.54e2 * t3630 + 0.1e3 / 0.27e2 * t668 * t3633 + 0.5e2 / 0.27e2 * t1662 * t3636 - 0.5e2 / 0.27e2 * t877 * t1195 + 0.25e2 / 0.54e2 * t3641 - 0.6e1 * t1747 * t1199 * t345 + 0.2e1 * t691 * t3646 + 0.4e1 * t691 * t384 * t1145 - 0.25e2 / 0.108e3 * t3652 + 0.2e1 * t691 * t1208 * t345 - t281 * t3657 - t281 * t3665;
  t3671 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3667);
  tv3sigmatau28 = t7 * t3671;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t3672 = 0.1e1 / t997;
  t3673 = t3672 * t76;
  t3677 = t1154 * t366;
  t3678 = t750 * t3677;
  t3681 = t450 * t3672;
  t3682 = t1315 * t3681;
  t3685 = t49 * t1167;
  t3686 = t459 * t3685;
  t3689 = t1163 * t3559;
  t3692 = t49 * t1176;
  t3693 = t459 * t3692;
  t3696 = t1167 * t366;
  t3697 = t83 * t3696;
  t3705 = t72 * t3672;
  t3708 = 0.5e3 / 0.81e2 * t3672 * t65 + 0.25e7 / 0.19683e5 * t1380 * t3705;
  t3709 = t83 * t3708;
  t3711 = -0.1e7 / 0.19683e5 * t1360 * t3673 * t83 - 0.1e5 / 0.243e3 * t1275 * t3678 + 0.1e5 / 0.243e3 * t447 * t3682 - 0.1e3 / 0.9e1 * t1269 * t3686 + 0.5e2 / 0.9e1 * t1321 * t3689 + 0.5e2 / 0.9e1 * t458 * t3693 - 0.6e1 * t1395 * t3697 + 0.6e1 * t482 * t367 * t1176 - t192 * t3709;
  t3715 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t3711);
  tv3tau30 = t7 * t3715;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t3716 = 0.1e1 / t1039;
  t3717 = t3716 * t134;
  t3721 = t1185 * t383;
  t3722 = t750 * t3721;
  t3725 = t450 * t3716;
  t3726 = t1656 * t3725;
  t3729 = t114 * t1198;
  t3730 = t459 * t3729;
  t3733 = t1194 * t3628;
  t3736 = t114 * t1207;
  t3737 = t459 * t3736;
  t3740 = t1198 * t383;
  t3741 = t141 * t3740;
  t3749 = t72 * t3716;
  t3752 = 0.5e3 / 0.81e2 * t3716 * t65 + 0.25e7 / 0.19683e5 * t1729 * t3749;
  t3753 = t141 * t3752;
  t3755 = -0.1e7 / 0.19683e5 * t1759 * t3717 * t141 - 0.1e5 / 0.243e3 * t1773 * t3722 + 0.1e5 / 0.243e3 * t659 * t3726 - 0.1e3 / 0.9e1 * t1767 * t3730 + 0.5e2 / 0.9e1 * t1662 * t3733 + 0.5e2 / 0.9e1 * t668 * t3737 - 0.6e1 * t1747 * t3741 + 0.6e1 * t691 * t384 * t1207 - t281 * t3753;
  t3759 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t3755);
  tv3tau33 = t7 * t3759;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3763 = 0.1e1 / t160 / t398;
  t3767 = 0.1e2 / 0.27e2 * t6 * t26 * t3763 * t85;
  t3770 = t6 * t1234 * t161 * t85;
  t3774 = t6 * t407 * t420 * t85;
  t3778 = t6 * t155 * t1257 * t85;
  t3784 = t6 * t1258 * t212;
  t3787 = t6 * t421 * t515;
  t3790 = t6 * t162 * t1406;
  t3795 = t166 / t1330 / t78 * t65;
  t3796 = t432 * t432;
  t3801 = t3796 / t37 / t1335 / t738 * t34;
  t3804 = t1335 * t434;
  t3806 = t1334 / t3804;
  t3811 = t433 / t36 / t2555;
  t3815 = 0.1e1 / t37 / t738;
  t3816 = t171 * t3815;
  t3822 = t166 / t1349 / t43 * t65;
  t3824 = 0.16e6 / 0.31381059609e11 * t3822 * t3801;
  t3826 = 0.88e5 / 0.43046721e8 * t1351 * t3806;
  t3828 = 0.1958e6 / 0.4782969e7 * t431 * t3811;
  t3830 = 0.2618e5 / 0.19683e5 * t170 * t3816;
  t3836 = t1360 * t1316;
  t3837 = t191 * t83;
  t3838 = t3837 * t201;
  t3841 = t451 * t451;
  t3846 = t475 * t475;
  t3855 = t456 * t210;
  t3866 = t1268 * t83;
  t3867 = t57 * t483;
  t3873 = t77 * (-0.16e6 / 0.31381059609e11 * t3795 * t3801 + 0.88e5 / 0.43046721e8 * t1332 * t3806 - 0.1958e6 / 0.4782969e7 * t508 * t3811 + 0.2618e5 / 0.19683e5 * t207 * t3816 + t3824 - t3826 + t3828 - t3830) - 0.2e7 / 0.6561e4 * t1929 * t1930 * t475 + 0.4e7 / 0.19683e5 * t3836 * t3838 + 0.1e5 / 0.243e3 * t447 * t3841 * t29 * t450 - 0.5e2 / 0.9e1 * t179 * t3846 * t54 * t57 - 0.1e3 / 0.9e1 * t1296 * t468 - 0.1e3 / 0.9e1 * t1296 * t477 + 0.2e3 / 0.9e1 * t3855 * t1323 - 0.2e3 / 0.9e1 * t464 * t1301 - 0.2e3 / 0.27e2 * t464 * t1312 + 0.1e5 / 0.243e3 * t447 * t448 * t450 * t3846 - 0.2e3 / 0.9e1 * t3866 * t467 * t3867 + 0.4e5 / 0.243e3 * t1327 * t1318;
  t3874 = t446 * t513;
  t3877 = t178 * t1358;
  t3880 = t57 * t502;
  t3891 = 0.616e4 / 0.81e2 * tau[0] * t1307 - 0.2618e4 / 0.81e2 * sigma[0] * t3815;
  t3898 = t62 / t1393 / t75;
  t3899 = t483 * t483;
  t3903 = t502 * t502;
  t3917 = t185 * t1310;
  t3922 = params->b * t53;
  t3950 = 0.2e5 / 0.243e3 * t3874 * t453 - 0.2e3 / 0.27e2 * t3877 * t187 - t3824 + 0.1e3 / 0.9e1 * t1321 * t467 * t3880 - 0.2e3 / 0.27e2 * t179 * t761 * t1311 - 0.5e2 / 0.27e2 * t179 * t180 * t57 * t3891 + 0.24e2 * t3898 * t83 * t3899 + 0.6e1 * t482 * t83 * t3903 - 0.6e1 * t192 * t513 * t502 - 0.4e1 * t192 * t210 * t1390 - t192 * t83 * (0.1e4 / 0.27e2 * t1879 * t475 + 0.5e3 / 0.27e2 * t490 * t3846 + 0.2e4 / 0.81e2 * t490 * t3917 + 0.25e3 / 0.81e2 * t193 * t3891 + 0.25e7 / 0.6561e4 * t3922 * t72 * t3841 + 0.5e7 / 0.6561e4 * t1380 * t496 * t475 + 0.625e6 / 0.6561e4 * t495 * t72 * t3846 + 0.25e7 / 0.19683e5 * t495 * t198 * t1310 + 0.125e6 / 0.19683e5 * t197 * t72 * t3891) - 0.24e2 * t1395 * t210 * t1396 + 0.12e2 * t482 * t513 * t483 - 0.4e1 * t192 * t1358 * t201;
  t3958 = t1274 * t1955;
  t3961 = t1274 * t457;
  t3974 = t60 * t481;
  t3975 = t3974 * t748;
  t3990 = -t3828 + t3830 + 0.2e3 / 0.9e1 * t456 * t1371 * t187 + 0.2e3 / 0.27e2 * t456 * t1391 * t187 - 0.4e5 / 0.243e3 * t3958 * t1277 - 0.4e5 / 0.243e3 * t3961 * t750 * t1316 * t201 + 0.1e3 / 0.9e1 * t458 * t459 * t475 * t502 - 0.2e3 / 0.9e1 * t1269 * t459 * t475 * t483 + 0.4e5 / 0.243e3 * t3975 * t750 * t451 * t483 - 0.2e5 / 0.243e3 * t1275 * t750 * t451 * t502 + 0.4e5 / 0.243e3 * t1956 * t1281 + 0.2e3 / 0.9e1 * t1285 * t1289 + 0.2e3 / 0.9e1 * t1965 * t1289;
  t3991 = t83 * t451;
  t4004 = t61 * t1394;
  t4026 = t53 * t72;
  t4037 = t502 * t52 * t2845;
  t4040 = 0.2e5 / 0.81e2 * t446 * t3991 * t750 * t475 * t52 + 0.2e3 / 0.27e2 * t458 * t459 * t1310 * t201 + 0.4e5 / 0.729e3 * t749 * t750 * t3917 + 0.4e3 / 0.9e1 * t4004 * t1397 * t187 - 0.4e3 / 0.9e1 * t1268 * t1400 * t187 + 0.2e3 / 0.9e1 * t456 * t1368 * t187 - 0.4e7 / 0.19683e5 * t1360 * t1361 * t210 - 0.36e2 * t1395 * t484 * t502 + 0.24e2 * t482 * t487 * t502 + 0.8e1 * t482 * t202 * t1390 + t3826 - 0.2e7 / 0.6561e4 * t4026 * t3841 * t76 * t83 - 0.4e5 / 0.243e3 * t1275 * t750 * t460 * t475 - 0.4e3 / 0.9e1 * t1268 * t202 * t4037;
  t4046 = t20 * t20;
  t4048 = 0.1e1 / t393 / t4046;
  t4049 = t395 * t395;
  t4055 = t403 * t403;
  t4061 = 0.1e1 / t1225 / t7;
  t4062 = t17 * t4061;
  t4065 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1226 + 0.24e2 * t4062);
  t4069 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t4048 * t4049 - 0.16e2 / 0.9e1 * t1218 * t395 * t403 + 0.4e1 / 0.3e1 * t394 * t4055 + 0.16e2 / 0.9e1 * t1222 * t1230 + 0.4e1 / 0.3e1 * t24 * t4065);
  t4078 = t6 * t1239 * t212;
  t4084 = t6 * t1246 * t212;
  t4086 = t6 * t412 * t515;
  t4088 = t3767 - t3770 / 0.2e1 + t3774 / 0.2e1 - 0.5e1 / 0.9e1 * t3778 - 0.3e1 / 0.2e1 * t6 * t156 * t1406 - 0.5e1 / 0.9e1 * t3784 + t3787 / 0.2e1 - t3790 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t3873 + t3950 + t3990 + t4040) - 0.3e1 / 0.8e1 * t6 * t4069 * t27 * t85 - 0.3e1 / 0.2e1 * t6 * t1235 * t212 - 0.3e1 / 0.2e1 * t4078 - 0.9e1 / 0.4e1 * t6 * t408 * t515 + t4084 - 0.3e1 / 0.2e1 * t4086;
  t4089 = my_piecewise3(t2, 0, t4088);
  t4090 = t94 * t94;
  t4092 = 0.1e1 / t521 / t4090;
  t4093 = t523 * t523;
  t4099 = t529 * t529;
  t4104 = t91 * t4061;
  t4107 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1226 + 0.24e2 * t4104);
  t4111 = my_piecewise3(t95, 0, 0.4e2 / 0.81e2 * t4092 * t4093 - 0.16e2 / 0.9e1 * t1413 * t523 * t529 + 0.4e1 / 0.3e1 * t522 * t4099 + 0.16e2 / 0.9e1 * t1417 * t1423 + 0.4e1 / 0.3e1 * t96 * t4107);
  t4118 = t6 * t1427 * t161 * t143;
  t4122 = t6 * t533 * t420 * t143;
  t4126 = t6 * t223 * t1257 * t143;
  t4131 = 0.1e2 / 0.27e2 * t6 * t98 * t3763 * t143;
  t4133 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t4111 * t27 * t143 - t4118 / 0.2e1 + t4122 / 0.2e1 - 0.5e1 / 0.9e1 * t4126 + t4131);
  tv4rho40 = 0.4e1 * t1411 + 0.4e1 * t1445 + t7 * (t4089 + t4133);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t4140 = t6 * t1465 * t161 * t85;
  t4144 = t6 * t558 * t420 * t85;
  t4145 = t4144 / 0.4e1;
  t4148 = t6 * t240 * t1257 * t85;
  t4154 = t6 * t1470 * t212;
  t4160 = t6 * t1477 * t212;
  t4161 = t4160 / 0.4e1;
  t4163 = t6 * t563 * t515;
  t4184 = 0.12e2 * t1226;
  t4185 = 0.24e2 * t4062;
  t4187 = my_piecewise5(t11, 0, t15, 0, -t4184 + t4185);
  t4191 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t4048 * t237 * t1219 - 0.8e1 / 0.9e1 * t1218 * t554 * t395 - 0.8e1 / 0.9e1 * t1450 * t152 * t403 + 0.4e1 / 0.3e1 * t394 * t1461 * t152 + 0.4e1 / 0.3e1 * t1453 * t403 + 0.4e1 / 0.9e1 * t550 * t1230 + 0.4e1 / 0.3e1 * t24 * t4187);
  t4205 = -0.3e1 / 0.8e1 * t4140 + t4145 - 0.5e1 / 0.36e2 * t4148 + t3767 - t3770 / 0.8e1 + t3774 / 0.4e1 - 0.5e1 / 0.12e2 * t3778 - 0.3e1 / 0.4e1 * t4154 - 0.9e1 / 0.8e1 * t6 * t559 * t515 + t4161 - 0.3e1 / 0.8e1 * t4163 - 0.3e1 / 0.8e1 * t6 * t241 * t1406 - 0.3e1 / 0.8e1 * t6 * t4191 * t27 * t85 - 0.9e1 / 0.8e1 * t6 * t1466 * t212 - 0.5e1 / 0.12e2 * t3784 + t3787 / 0.4e1 - t3790 / 0.8e1 - 0.3e1 / 0.8e1 * t4078 + t4084 / 0.2e1 - 0.3e1 / 0.8e1 * t4086;
  t4206 = my_piecewise3(t2, 0, t4205);
  t4223 = 0.24e2 * t4104;
  t4225 = my_piecewise5(t15, 0, t11, 0, t4184 + t4223);
  t4229 = my_piecewise3(t95, 0, 0.4e2 / 0.81e2 * t4092 * t248 * t1414 - 0.8e1 / 0.9e1 * t1413 * t578 * t523 - 0.8e1 / 0.9e1 * t1494 * t220 * t529 + 0.4e1 / 0.3e1 * t522 * t1504 * t220 + 0.4e1 / 0.3e1 * t1497 * t529 + 0.4e1 / 0.9e1 * t574 * t1423 + 0.4e1 / 0.3e1 * t96 * t4225);
  t4236 = t6 * t1508 * t161 * t143;
  t4240 = t6 * t582 * t420 * t143;
  t4241 = t4240 / 0.4e1;
  t4244 = t6 * t251 * t1257 * t143;
  t4253 = t6 * t1432 * t301;
  t4256 = t6 * t1436 * t301;
  t4257 = t4256 / 0.4e1;
  t4259 = t6 * t1440 * t301;
  t4261 = -0.3e1 / 0.8e1 * t6 * t4229 * t27 * t143 - 0.3e1 / 0.8e1 * t4236 + t4241 - 0.5e1 / 0.36e2 * t4244 - t4118 / 0.8e1 + t4122 / 0.4e1 - 0.5e1 / 0.12e2 * t4126 + t4131 - 0.3e1 / 0.8e1 * t6 * t1428 * t301 - 0.3e1 / 0.8e1 * t4253 + t4257 - 0.5e1 / 0.36e2 * t4259;
  t4262 = my_piecewise3(t90, 0, t4261);
  tv4rho41 = t1411 + t1445 + 0.3e1 * t1493 + 0.3e1 * t1533 + t7 * (t4206 + t4262);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4271 = t6 * t1549 * t161 * t85;
  t4275 = t6 * t613 * t420 * t85;
  t4290 = t554 * t554;
  t4303 = my_piecewise5(t11, 0, t15, 0, t4185);
  t4307 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t4048 * t604 * t395 - 0.32e2 / 0.27e2 * t1450 * t152 * t554 - 0.8e1 / 0.27e2 * t1536 * t403 + 0.8e1 / 0.9e1 * t394 * t4290 + 0.8e1 / 0.9e1 * t550 * t1461 - 0.8e1 / 0.27e2 * t1218 * t609 * t395 + 0.8e1 / 0.9e1 * t394 * t1545 * t152 + 0.4e1 / 0.9e1 * t1541 * t403 + 0.4e1 / 0.3e1 * t24 * t4303);
  t4316 = t6 * t1554 * t212;
  t4327 = -t4271 / 0.4e1 + t4275 / 0.12e2 - t4140 / 0.4e1 + t4144 / 0.3e1 - 0.5e1 / 0.18e2 * t4148 + t3767 + t3774 / 0.12e2 - 0.5e1 / 0.18e2 * t3778 - 0.3e1 / 0.8e1 * t6 * t4307 * t27 * t85 - 0.3e1 / 0.4e1 * t6 * t1550 * t212 - t4316 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t614 * t515 - t4154 / 0.2e1 + t4160 / 0.3e1 - t4163 / 0.4e1 - 0.5e1 / 0.18e2 * t3784 + t3787 / 0.12e2 + t4084 / 0.6e1;
  t4328 = my_piecewise3(t2, 0, t4327);
  t4337 = t578 * t578;
  t4350 = my_piecewise5(t15, 0, t11, 0, t4223);
  t4354 = my_piecewise3(t95, 0, 0.4e2 / 0.81e2 * t4092 * t621 * t523 - 0.32e2 / 0.27e2 * t1494 * t220 * t578 - 0.8e1 / 0.27e2 * t1566 * t529 + 0.8e1 / 0.9e1 * t522 * t4337 + 0.8e1 / 0.9e1 * t574 * t1504 - 0.8e1 / 0.27e2 * t1413 * t626 * t523 + 0.8e1 / 0.9e1 * t522 * t1575 * t220 + 0.4e1 / 0.9e1 * t1571 * t529 + 0.4e1 / 0.3e1 * t96 * t4350);
  t4361 = t6 * t1579 * t161 * t143;
  t4365 = t6 * t630 * t420 * t143;
  t4374 = t6 * t1513 * t301;
  t4377 = t6 * t1517 * t301;
  t4388 = t6 * t538 * t724;
  t4391 = t6 * t542 * t724;
  t4393 = -0.3e1 / 0.8e1 * t6 * t4354 * t27 * t143 - t4361 / 0.4e1 + t4365 / 0.12e2 - t4236 / 0.4e1 + t4240 / 0.3e1 - 0.5e1 / 0.18e2 * t4244 - 0.3e1 / 0.4e1 * t6 * t1509 * t301 - t4374 / 0.2e1 + t4377 / 0.6e1 + t4122 / 0.12e2 - 0.5e1 / 0.18e2 * t4126 + t4131 - t4253 / 0.4e1 + t4256 / 0.3e1 - 0.5e1 / 0.18e2 * t4259 - 0.3e1 / 0.8e1 * t6 * t534 * t724 - t4388 / 0.4e1 + t4391 / 0.12e2;
  t4394 = my_piecewise3(t90, 0, t4393);
  tv4rho42 = 0.2e1 * t1493 + 0.2e1 * t1533 + 0.2e1 * t1565 + 0.2e1 * t1604 + t7 * (t4328 + t4394);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4415 = my_piecewise5(t11, 0, t15, 0, t4184 + t4185);
  t4419 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t4048 * t1609 * t152 - 0.8e1 / 0.9e1 * t1536 * t554 - 0.8e1 / 0.9e1 * t1450 * t609 * t152 + 0.4e1 / 0.3e1 * t1453 * t609 + 0.4e1 / 0.3e1 * t550 * t1545 + 0.4e1 / 0.9e1 * t394 * t1616 * t152 + 0.4e1 / 0.3e1 * t24 * t4415);
  t4426 = t6 * t1620 * t161 * t85;
  t4437 = -0.3e1 / 0.8e1 * t6 * t4419 * t27 * t85 - t4426 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1621 * t212 - 0.3e1 / 0.8e1 * t4271 + t4275 / 0.4e1 - 0.3e1 / 0.8e1 * t4316 + t4145 - 0.5e1 / 0.12e2 * t4148 + t4161 - 0.5e1 / 0.36e2 * t3778 + t3767 - 0.5e1 / 0.36e2 * t3784;
  t4438 = my_piecewise3(t2, 0, t4437);
  t4455 = my_piecewise5(t15, 0, t11, 0, -t4184 + t4223);
  t4459 = my_piecewise3(t95, 0, 0.4e2 / 0.81e2 * t4092 * t1629 * t220 - 0.8e1 / 0.9e1 * t1566 * t578 - 0.8e1 / 0.9e1 * t1494 * t626 * t220 + 0.4e1 / 0.3e1 * t1497 * t626 + 0.4e1 / 0.3e1 * t574 * t1575 + 0.4e1 / 0.9e1 * t522 * t1636 * t220 + 0.4e1 / 0.3e1 * t96 * t4455);
  t4466 = t6 * t1640 * t161 * t143;
  t4474 = t6 * t1584 * t301;
  t4483 = t6 * t587 * t724;
  t4493 = t6 * t228 * t1794;
  t4495 = -0.3e1 / 0.8e1 * t6 * t4459 * t27 * t143 - t4466 / 0.8e1 - 0.3e1 / 0.8e1 * t4361 + t4365 / 0.4e1 - 0.9e1 / 0.8e1 * t6 * t1580 * t301 - 0.3e1 / 0.8e1 * t4474 + t4241 - 0.5e1 / 0.12e2 * t4244 - 0.3e1 / 0.4e1 * t4374 + t4377 / 0.2e1 - 0.9e1 / 0.8e1 * t6 * t583 * t724 - 0.3e1 / 0.8e1 * t4483 - 0.5e1 / 0.36e2 * t4126 + t4131 + t4257 - 0.5e1 / 0.12e2 * t4259 - 0.3e1 / 0.8e1 * t4388 + t4391 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t224 * t1794 - t4493 / 0.8e1;
  t4496 = my_piecewise3(t90, 0, t4495);
  tv4rho43 = 0.3e1 * t1565 + 0.3e1 * t1604 + t1628 + t1799 + t7 * (t4438 + t4496);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4501 = t604 * t604;
  t4506 = t609 * t609;
  t4513 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1226 + 0.24e2 * t4062);
  t4517 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t4048 * t4501 - 0.16e2 / 0.9e1 * t1536 * t609 + 0.4e1 / 0.3e1 * t394 * t4506 + 0.16e2 / 0.9e1 * t550 * t1616 + 0.4e1 / 0.3e1 * t24 * t4513);
  t4526 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t4517 * t27 * t85 - t4426 / 0.2e1 + t4275 / 0.2e1 - 0.5e1 / 0.9e1 * t4148 + t3767);
  t4540 = t124 / t1745 / t133;
  t4541 = t692 * t692;
  t4545 = t711 * t711;
  t4551 = t684 * t684;
  t4554 = t274 * t1681;
  t4560 = 0.1e1 / t102 / t826;
  t4563 = 0.616e4 / 0.81e2 * tau[1] * t1678 - 0.2618e4 / 0.81e2 * sigma[2] * t4560;
  t4566 = params->b * t118;
  t4567 = t661 * t661;
  t4601 = t166 / t1689 / t136 * t65;
  t4602 = t644 * t644;
  t4607 = t4602 / t102 / t1694 / t826 * t34;
  t4610 = t1694 * t646;
  t4612 = t1693 / t4610;
  t4617 = t645 / t101 / t2671;
  t4620 = t260 * t4560;
  t4626 = t166 / t1708 / t108 * t65;
  t4628 = 0.16e6 / 0.31381059609e11 * t4626 * t4607;
  t4630 = 0.88e5 / 0.43046721e8 * t1710 * t4612;
  t4632 = 0.1958e6 / 0.4782969e7 * t643 * t4617;
  t4634 = 0.2618e5 / 0.19683e5 * t259 * t4620;
  t4647 = 0.12e2 * t691 * t722 * t692 + 0.24e2 * t4540 * t141 * t4541 + 0.6e1 * t691 * t141 * t4545 - t281 * t141 * (0.1e4 / 0.27e2 * t2068 * t684 + 0.5e3 / 0.27e2 * t699 * t4551 + 0.2e4 / 0.81e2 * t699 * t4554 + 0.25e3 / 0.81e2 * t282 * t4563 + 0.25e7 / 0.6561e4 * t4566 * t72 * t4567 + 0.5e7 / 0.6561e4 * t1729 * t705 * t684 + 0.625e6 / 0.6561e4 * t704 * t72 * t4551 + 0.25e7 / 0.19683e5 * t704 * t287 * t1681 + 0.125e6 / 0.19683e5 * t286 * t72 * t4563) - 0.24e2 * t1747 * t299 * t1748 - 0.4e1 * t281 * t1717 * t290 - 0.6e1 * t281 * t722 * t711 - 0.4e1 * t281 * t299 * t1739 + t135 * (-0.16e6 / 0.31381059609e11 * t4601 * t4607 + 0.88e5 / 0.43046721e8 * t1691 * t4612 - 0.1958e6 / 0.4782969e7 * t717 * t4617 + 0.2618e5 / 0.19683e5 * t296 * t4620 + t4628 - t4630 + t4632 - t4634) + 0.1e5 / 0.243e3 * t659 * t4567 * t29 * t450 - 0.5e2 / 0.9e1 * t268 * t4551 * t54 * t57 - 0.1e3 / 0.9e1 * t1667 * t677 - t4632;
  t4651 = t1759 * t1657;
  t4652 = t280 * t141;
  t4653 = t4652 * t290;
  t4665 = t118 * t72;
  t4682 = t141 * t661;
  t4688 = t4634 - 0.2e7 / 0.6561e4 * t2138 * t2139 * t684 + 0.4e7 / 0.19683e5 * t4651 * t4653 - 0.36e2 * t1747 * t693 * t711 + 0.24e2 * t691 * t696 * t711 + 0.8e1 * t691 * t291 * t1739 + t4630 - 0.2e7 / 0.6561e4 * t4665 * t4567 * t134 * t141 - 0.4e7 / 0.19683e5 * t1759 * t1760 * t299 - 0.4e3 / 0.9e1 * t1766 * t1742 * t276 + 0.2e3 / 0.9e1 * t1782 * t1786 + 0.4e5 / 0.243e3 * t2194 * t1778 + 0.2e3 / 0.9e1 * t2203 * t1786 + 0.2e5 / 0.81e2 * t658 * t4682 * t750 * t684 * t117;
  t4694 = t1772 * t667;
  t4706 = t1772 * t2193;
  t4713 = t122 * t690;
  t4714 = t4713 * t836;
  t4723 = t123 * t1746;
  t4736 = t658 * t722;
  t4739 = 0.2e3 / 0.27e2 * t668 * t459 * t1681 * t290 - 0.4e5 / 0.243e3 * t4694 * t750 * t1657 * t290 + 0.1e3 / 0.9e1 * t668 * t459 * t684 * t711 + 0.4e5 / 0.729e3 * t837 * t750 * t4554 - 0.4e5 / 0.243e3 * t4706 * t1775 - 0.2e3 / 0.9e1 * t1767 * t459 * t684 * t692 + 0.4e5 / 0.243e3 * t4714 * t750 * t661 * t692 - 0.2e5 / 0.243e3 * t1773 * t750 * t661 * t711 + 0.4e3 / 0.9e1 * t4723 * t1749 * t276 + 0.2e3 / 0.9e1 * t666 * t1753 * t276 + 0.2e3 / 0.9e1 * t666 * t1719 * t276 + 0.2e3 / 0.27e2 * t666 * t1740 * t276 + 0.2e5 / 0.243e3 * t4736 * t663;
  t4740 = t666 * t299;
  t4749 = t1766 * t141;
  t4750 = t57 * t692;
  t4765 = t267 * t1717;
  t4770 = t57 * t711;
  t4780 = t711 * t117 * t2958;
  t4783 = 0.2e3 / 0.9e1 * t4740 * t1664 - 0.2e3 / 0.9e1 * t673 * t1672 + 0.1e5 / 0.243e3 * t659 * t660 * t450 * t4551 - 0.2e3 / 0.9e1 * t4749 * t676 * t4750 + 0.4e5 / 0.243e3 * t1686 * t1659 - 0.2e3 / 0.27e2 * t673 * t1683 - 0.2e3 / 0.27e2 * t268 * t848 * t1682 - 0.5e2 / 0.27e2 * t268 * t269 * t57 * t4563 - 0.2e3 / 0.27e2 * t4765 * t276 - 0.1e3 / 0.9e1 * t1667 * t686 - t4628 + 0.1e3 / 0.9e1 * t1662 * t676 * t4770 - 0.4e5 / 0.243e3 * t1773 * t750 * t669 * t684 - 0.4e3 / 0.9e1 * t1766 * t291 * t4780;
  t4789 = t621 * t621;
  t4794 = t626 * t626;
  t4801 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1226 + 0.24e2 * t4104);
  t4805 = my_piecewise3(t95, 0, 0.4e2 / 0.81e2 * t4092 * t4789 - 0.16e2 / 0.9e1 * t1566 * t626 + 0.4e1 / 0.3e1 * t522 * t4794 + 0.16e2 / 0.9e1 * t574 * t1636 + 0.4e1 / 0.3e1 * t96 * t4801);
  t4819 = -t4466 / 0.2e1 - 0.3e1 / 0.2e1 * t4474 - 0.3e1 / 0.2e1 * t4483 - t4493 / 0.2e1 + t4365 / 0.2e1 + t4377 + t4391 / 0.2e1 - 0.5e1 / 0.9e1 * t4244 - 0.5e1 / 0.9e1 * t4259 + t4131 - 0.3e1 / 0.8e1 * t6 * t99 * (t4647 + t4688 + t4739 + t4783) - 0.3e1 / 0.8e1 * t6 * t4805 * t27 * t143 - 0.3e1 / 0.2e1 * t6 * t1641 * t301 - 0.9e1 / 0.4e1 * t6 * t631 * t724 - 0.3e1 / 0.2e1 * t6 * t252 * t1794;
  t4820 = my_piecewise3(t90, 0, t4819);
  tv4rho44 = 0.4e1 * t1628 + 0.4e1 * t1799 + t7 * (t4526 + t4820);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4828 = t6 * t1239 * t328;
  t4834 = t6 * t1246 * t328;
  t4837 = t6 * t412 * t801;
  t4844 = 0.5e1 / 0.36e2 * t6 * t1258 * t328;
  t4846 = t6 * t421 * t801;
  t4849 = t6 * t162 * t1989;
  t4855 = 0.1e1 / t37 / t1335 / t997 * t1333 * t34;
  t4859 = t65 * t1337 * t432;
  t4863 = t57 * t1342 * sigma[0];
  t4866 = t34 * t1307;
  t4870 = 0.2e5 / 0.10460353203e11 * t3822 * t4855;
  t4872 = 0.95e4 / 0.14348907e8 * t1351 * t4859;
  t4874 = 0.1705e5 / 0.1594323e7 * t431 * t4863;
  t4876 = 0.154e4 / 0.6561e4 * t169 * t4866;
  t4902 = t442 * t185;
  t4905 = t174 * t475;
  t4908 = t39 * t1310;
  t4919 = t1380 * t72;
  t4935 = -0.125e3 / 0.54e2 * t2525 * t1885 + 0.5e3 / 0.81e2 * t1879 * t174 - 0.55e4 / 0.243e3 * t490 * t4902 + 0.5e3 / 0.81e2 * t490 * t4905 - 0.125e3 / 0.162e3 * t490 * t4908 + 0.385e5 / 0.2187e4 * t193 * t1307 - 0.3125e6 / 0.6561e4 * t3922 * t318 * t1316 + 0.25e7 / 0.19683e5 * t1380 * t784 * t451 - 0.3125e6 / 0.6561e4 * t4919 * t751 * t475 - 0.6875e7 / 0.59049e5 * t495 * t1899 * t185 + 0.625e6 / 0.19683e5 * t495 * t784 * t475 - 0.78125e5 / 0.19683e5 * t495 * t318 * t1310 + 0.1925e8 / 0.531441e6 * t197 * t72 * t1307;
  t4940 = t1310 * t54;
  t4944 = t178 * t1872;
  t4949 = t77 * (0.2e5 / 0.10460353203e11 * t3795 * t4855 - 0.95e4 / 0.14348907e8 * t1332 * t4859 + 0.1705e5 / 0.1594323e7 * t508 * t4863 - 0.154e4 / 0.6561e4 * t206 * t4866 - t4870 + t4872 - t4874 + t4876) - 0.3e1 * t192 * t1872 * t201 - 0.3e1 * t192 * t799 * t502 - t192 * t326 * t1390 + 0.6e1 * t482 * t799 * t483 - t192 * t1358 * t321 - 0.3e1 * t192 * t513 * t787 - 0.3e1 * t192 * t210 * t1902 - t192 * t83 * t4935 + 0.25e2 / 0.36e2 * t464 * t1832 + 0.25e2 / 0.108e3 * t179 * t4940 * t312 - 0.5e2 / 0.9e1 * t4944 * t187 - 0.5e2 / 0.9e1 * t1835 * t477;
  t4950 = t446 * t799;
  t4953 = t456 * t326;
  t4975 = t4026 * t1316;
  t4981 = 0.1e5 / 0.243e3 * t4950 * t453 + 0.5e2 / 0.9e1 * t4953 * t1323 - 0.5e2 / 0.9e1 * t790 * t1301 + 0.1e5 / 0.243e3 * t1840 * t1318 - 0.5e2 / 0.27e2 * t790 * t1312 + 0.125e6 / 0.6561e4 * t2584 * t1930 * t1885 - 0.125e6 / 0.6561e4 * t1929 * t3837 * t755 + t4870 + 0.25e2 / 0.108e3 * t3877 * t313 + 0.25e2 / 0.36e2 * t1296 * t762 - 0.6e1 * t1395 * t326 * t1396 + 0.25e6 / 0.6561e4 * t4975 * t1931 - 0.1e7 / 0.19683e5 * t1929 * t1930 * t174;
  t4985 = t3837 * t321;
  t4992 = t76 * t210;
  t5017 = -0.5e2 / 0.9e1 * t1835 * t468 + t4874 + 0.1e7 / 0.19683e5 * t3836 * t4985 - 0.18e2 * t2872 * t321 * t502 * t201 + 0.125e6 / 0.6561e4 * t1929 * t4992 * t39 + 0.6e1 * t482 * t1874 * t201 + 0.12e2 * t482 * t1876 * t201 + 0.6e1 * t482 * t775 * t502 + 0.24e2 * t3898 * t322 * t1396 - 0.18e2 * t1395 * t775 * t483 - 0.18e2 * t1395 * t788 * t483 + 0.6e1 * t482 * t1911 * t201 - t4872;
  t5033 = t4004 * t457;
  t5061 = -t4876 + 0.6e1 * t482 * t788 * t502 + 0.2e1 * t482 * t322 * t1390 - 0.1e7 / 0.19683e5 * t1360 * t1361 * t326 + 0.6e1 * t482 * t1903 * t201 - 0.11e6 / 0.2187e4 * t749 * t750 * t4902 - 0.25e2 / 0.18e2 * t5033 * t459 * t39 * t1396 - 0.1e3 / 0.27e2 * t1269 * t459 * t174 * t483 - 0.55e3 / 0.81e2 * t458 * t459 * t442 * t201 - 0.1e3 / 0.9e1 * t1818 * t1323 + 0.1e5 / 0.243e3 * t1942 * t750 * t174 * t451 + 0.5e2 / 0.9e1 * t456 * t1911 * t187 - 0.1e3 / 0.9e1 * t1268 * t1908 * t187 + 0.5e2 / 0.9e1 * t456 * t1874 * t187;
  t5074 = t456 * t513 * t52;
  t5078 = t446 * t513 * t53;
  t5082 = t456 * t210 * t185;
  t5086 = t446 * t210 * t451;
  t5087 = t39 * t52;
  t5091 = t83 * t475;
  t5092 = t456 * t5091;
  t5107 = 0.1e3 / 0.9e1 * t456 * t1876 * t187 + 0.5e2 / 0.9e1 * t456 * t1903 * t187 + 0.1e3 / 0.9e1 * t456 * t1905 * t187 - 0.25e2 / 0.36e2 * t5074 * t756 - 0.125e4 / 0.243e3 * t5078 * t752 - 0.25e2 / 0.18e2 * t5082 * t756 - 0.125e4 / 0.81e2 * t5086 * t750 * t5087 - 0.25e2 / 0.36e2 * t5092 * t756 + 0.5e2 / 0.9e1 * t1972 * t477 - 0.1e5 / 0.243e3 * t1274 * t775 * t453 + 0.5e2 / 0.9e1 * t1975 * t477 - 0.1e5 / 0.243e3 * t1274 * t788 * t453 + 0.5e2 / 0.9e1 * t769 * t1301;
  t5113 = t1268 * t1284;
  t5116 = t1268 * t1964;
  t5136 = t1274 * t2624;
  t5143 = -0.1e5 / 0.243e3 * t1980 * t1318 + 0.1e5 / 0.729e3 * t749 * t750 * t4905 + 0.25e2 / 0.18e2 * t5113 * t1952 + 0.25e2 / 0.18e2 * t5116 * t1952 - 0.125e4 / 0.243e3 * t1956 * t1959 - 0.125e4 / 0.729e3 * t749 * t750 * t4908 - 0.25e2 / 0.36e2 * t1285 * t1969 - 0.25e2 / 0.36e2 * t1965 * t1969 - 0.25e2 / 0.108e3 * t458 * t459 * t39 * t1390 + 0.5e2 / 0.9e1 * t1984 * t1289 + 0.1e5 / 0.243e3 * t2625 * t1281 - 0.1e5 / 0.243e3 * t5136 * t1277 + 0.1e3 / 0.27e2 * t1285 * t1939 + 0.1e3 / 0.27e2 * t1965 * t1939;
  t5163 = t483 * t52 * t2845;
  t5166 = t446 * t5091;
  t5180 = t1316 * t29;
  t5184 = 0.5e2 / 0.27e2 * t458 * t459 * t174 * t502 + 0.2e5 / 0.729e3 * t1956 * t1947 + 0.5e2 / 0.27e2 * t769 * t1312 - 0.2e3 / 0.9e1 * t1268 * t775 * t1820 - 0.2e3 / 0.9e1 * t1268 * t788 * t1820 - 0.1e3 / 0.9e1 * t1818 * t4037 + 0.1e3 / 0.3e1 * t4004 * t322 * t5163 - 0.125e4 / 0.81e2 * t5166 * t750 * t5087 * t185 - 0.5e2 / 0.27e2 * t1296 * t766 - 0.1e3 / 0.27e2 * t464 * t1845 - 0.5e2 / 0.27e2 * t179 * t1831 * t765 + 0.55e3 / 0.81e2 * t464 * t1850 - 0.125e4 / 0.243e3 * t447 * t5180 * t2839;
  t5215 = t180 * t476 * t201;
  t5220 = t448 * t452 * t201;
  t5235 = t448 * t450 * t475 * t185;
  t5238 = 0.55e3 / 0.81e2 * t179 * t761 * t1849 - 0.77e4 / 0.729e3 * t179 * t180 * t57 * t1307 + 0.5e2 / 0.9e1 * t3855 * t1935 + 0.5e2 / 0.9e1 * t1321 * t787 * t451 * t459 - 0.25e4 / 0.243e3 * t3975 * t750 * t751 * t483 + 0.125e4 / 0.81e2 * t3961 * t750 * t1943 * t201 + 0.25e2 / 0.18e2 * t1269 * t459 * t755 * t502 - 0.2e5 / 0.729e3 * t1275 * t750 * t1938 * t185 - 0.1e3 / 0.9e1 * t1818 * t5215 + 0.2e5 / 0.243e3 * t3974 * t322 * t5220 + 0.25e4 / 0.243e3 * t3958 * t1824 + 0.125e4 / 0.243e3 * t1275 * t750 * t1885 * t201 + 0.125e4 / 0.243e3 * t1275 * t750 * t751 * t502 - 0.1e5 / 0.243e3 * t1980 * t5235;
  t5246 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1235 * t328 - 0.3e1 / 0.8e1 * t4828 - 0.9e1 / 0.8e1 * t6 * t408 * t801 + t4834 / 0.4e1 - 0.3e1 / 0.4e1 * t4837 - 0.9e1 / 0.8e1 * t6 * t156 * t1989 - t4844 + t4846 / 0.4e1 - 0.3e1 / 0.8e1 * t4849 - 0.3e1 / 0.8e1 * t6 * t28 * (t4949 + t4981 + t5017 + t5061 + t5107 + t5143 + t5184 + t5238));
  tv4rho3sigma0 = t7 * t5246 + 0.3e1 * t1994;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5253 = t6 * t1432 * t352;
  t5256 = t6 * t1436 * t352;
  t5260 = 0.5e1 / 0.36e2 * t6 * t1440 * t352;
  t5262 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1428 * t352 - 0.3e1 / 0.8e1 * t5253 + t5256 / 0.4e1 - t5260);
  tv4rho3sigma2 = t7 * t5262 + 0.3e1 * t2007;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5264 = 0.2e1 * t2021;
  t5270 = t6 * t1470 * t328 / 0.4e1;
  t5275 = t6 * t1477 * t328;
  t5279 = t6 * t563 * t801 / 0.4e1;
  t5288 = -0.3e1 / 0.8e1 * t6 * t1466 * t328 - t5270 - 0.3e1 / 0.4e1 * t6 * t559 * t801 + t5275 / 0.12e2 - t5279 - 0.3e1 / 0.8e1 * t6 * t241 * t1989 - t4828 / 0.8e1 + t4834 / 0.6e1 - t4837 / 0.4e1 - t4844 + t4846 / 0.6e1 - t4849 / 0.8e1;
  t5289 = my_piecewise3(t2, 0, t5288);
  tv4rho3sigma3 = t7 * t5289 + t1994 + t5264;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5291 = 0.2e1 * t2037;
  t5297 = t6 * t1513 * t352 / 0.4e1;
  t5299 = t6 * t1517 * t352;
  t5308 = t6 * t538 * t888 / 0.4e1;
  t5310 = t6 * t542 * t888;
  t5313 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1509 * t352 - t5297 + t5299 / 0.12e2 - t5253 / 0.8e1 + t5256 / 0.6e1 - t5260 - 0.3e1 / 0.8e1 * t6 * t534 * t888 - t5308 + t5310 / 0.12e2);
  tv4rho3sigma5 = t7 * t5313 + t2007 + t5291;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5319 = t6 * t1554 * t328;
  t5328 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1550 * t328 - t5319 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t614 * t801 - t5270 + t5275 / 0.6e1 - t5279 + t4834 / 0.12e2 - t4844 + t4846 / 0.12e2);
  tv4rho3sigma6 = t7 * t5328 + t2045 + t5264;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5334 = t6 * t1584 * t352;
  t5341 = t6 * t587 * t888;
  t5349 = t6 * t228 * t2227;
  t5351 = -0.3e1 / 0.8e1 * t6 * t1580 * t352 - t5334 / 0.8e1 - t5297 + t5299 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t583 * t888 - t5341 / 0.4e1 + t5256 / 0.12e2 - t5260 - t5308 + t5310 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t224 * t2227 - t5349 / 0.8e1;
  t5352 = my_piecewise3(t90, 0, t5351);
  tv4rho3sigma8 = t7 * t5352 + t2232 + t5291;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5361 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1621 * t328 - 0.3e1 / 0.8e1 * t5319 + t5275 / 0.4e1 - t4844);
  tv4rho3sigma9 = t7 * t5361 + 0.3e1 * t2045;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5382 = 0.1e1 / t102 / t1694 / t1039 * t1692 * t34;
  t5386 = t65 * t1696 * t644;
  t5390 = t57 * t1701 * sigma[2];
  t5393 = t34 * t1678;
  t5397 = 0.2e5 / 0.10460353203e11 * t4626 * t5382;
  t5399 = 0.95e4 / 0.14348907e8 * t1710 * t5386;
  t5401 = 0.1705e5 / 0.1594323e7 * t643 * t5390;
  t5403 = 0.154e4 / 0.6561e4 * t258 * t5393;
  t5408 = t4665 * t1657;
  t5414 = t4652 * t345;
  t5421 = t134 * t299;
  t5437 = t654 * t274;
  t5440 = t263 * t684;
  t5443 = t104 * t1681;
  t5454 = t1729 * t72;
  t5470 = -0.125e3 / 0.54e2 * t2694 * t2074 + 0.5e3 / 0.81e2 * t2068 * t263 - 0.55e4 / 0.243e3 * t699 * t5437 + 0.5e3 / 0.81e2 * t699 * t5440 - 0.125e3 / 0.162e3 * t699 * t5443 + 0.385e5 / 0.2187e4 * t282 * t1678 - 0.3125e6 / 0.6561e4 * t4566 * t342 * t1657 + 0.25e7 / 0.19683e5 * t1729 * t871 * t661 - 0.3125e6 / 0.6561e4 * t5454 * t838 * t684 - 0.6875e7 / 0.59049e5 * t704 * t2088 * t274 + 0.625e6 / 0.19683e5 * t704 * t871 * t684 - 0.78125e5 / 0.19683e5 * t704 * t342 * t1681 + 0.1925e8 / 0.531441e6 * t286 * t72 * t1678;
  t5476 = t135 * (0.2e5 / 0.10460353203e11 * t4601 * t5382 - 0.95e4 / 0.14348907e8 * t1691 * t5386 + 0.1705e5 / 0.1594323e7 * t717 * t5390 - 0.154e4 / 0.6561e4 * t295 * t5393 - t5397 + t5399 - t5401 + t5403) - 0.5e2 / 0.9e1 * t2159 * t677 + 0.25e6 / 0.6561e4 * t5408 * t2140 - 0.1e7 / 0.19683e5 * t2138 * t2139 * t263 + 0.1e7 / 0.19683e5 * t4651 * t5414 - 0.18e2 * t2992 * t345 * t711 * t290 + t5401 + 0.125e6 / 0.6561e4 * t2138 * t5421 * t104 - t281 * t350 * t1739 - 0.3e1 * t281 * t722 * t874 - 0.3e1 * t281 * t299 * t2091 - t281 * t141 * t5470 - 0.3e1 * t281 * t2123 * t290;
  t5488 = t1766 * t1781;
  t5491 = t1766 * t2202;
  t5514 = -0.3e1 * t281 * t886 * t711 - t281 * t1717 * t345 - 0.6e1 * t1747 * t350 * t1748 + 0.6e1 * t691 * t886 * t692 + 0.25e2 / 0.18e2 * t5488 * t2185 + 0.25e2 / 0.18e2 * t5491 * t2185 + 0.1e3 / 0.27e2 * t1782 * t2190 + 0.1e3 / 0.27e2 * t2203 * t2190 + 0.5e2 / 0.27e2 * t668 * t459 * t263 * t711 + 0.1e3 / 0.9e1 * t666 * t2065 * t276 + 0.5e2 / 0.9e1 * t666 * t2092 * t276 + 0.1e3 / 0.9e1 * t666 * t2094 * t276 + 0.5e2 / 0.9e1 * t666 * t2097 * t276;
  t5520 = t666 * t722 * t117;
  t5524 = t658 * t722 * t118;
  t5528 = t666 * t299 * t274;
  t5533 = t104 * t117;
  t5537 = t141 * t684;
  t5538 = t666 * t5537;
  t5558 = -0.1e3 / 0.9e1 * t1766 * t2099 * t276 - 0.25e2 / 0.36e2 * t5520 * t843 - 0.125e4 / 0.243e3 * t5524 * t839 - 0.25e2 / 0.18e2 * t5528 * t843 - 0.125e4 / 0.81e2 * t658 * t299 * t661 * t750 * t5533 - 0.25e2 / 0.36e2 * t5538 * t843 + 0.5e2 / 0.9e1 * t666 * t2102 * t276 + 0.5e2 / 0.9e1 * t2210 * t686 - 0.1e5 / 0.243e3 * t1772 * t862 * t663 + 0.5e2 / 0.9e1 * t2213 * t686 - 0.1e5 / 0.243e3 * t1772 * t875 * t663 + 0.5e2 / 0.9e1 * t856 * t1672 - 0.1e5 / 0.243e3 * t2218 * t1659;
  t5576 = t1772 * t2785;
  t5584 = t4723 * t667;
  t5599 = -0.125e4 / 0.243e3 * t2194 * t2197 - 0.125e4 / 0.729e3 * t837 * t750 * t5443 - 0.25e2 / 0.36e2 * t1782 * t2207 - 0.25e2 / 0.36e2 * t2203 * t2207 - 0.25e2 / 0.108e3 * t668 * t459 * t104 * t1739 + 0.5e2 / 0.9e1 * t2222 * t1786 + 0.1e5 / 0.243e3 * t2786 * t1778 - 0.1e5 / 0.243e3 * t5576 * t1775 + 0.2e5 / 0.729e3 * t2194 * t2181 + 0.1e5 / 0.729e3 * t837 * t750 * t5440 - 0.25e2 / 0.18e2 * t5584 * t459 * t104 * t1748 - 0.1e3 / 0.27e2 * t1767 * t459 * t263 * t692 - 0.55e3 / 0.81e2 * t668 * t459 * t654 * t290 - 0.1e3 / 0.9e1 * t2060 * t1664;
  t5639 = 0.1e5 / 0.243e3 * t2176 * t750 * t263 * t661 - 0.11e6 / 0.2187e4 * t837 * t750 * t5437 + 0.5e2 / 0.27e2 * t856 * t1683 + 0.6e1 * t691 * t2102 * t290 + 0.12e2 * t691 * t2065 * t290 + 0.6e1 * t691 * t2092 * t290 + 0.6e1 * t691 * t862 * t711 + 0.6e1 * t691 * t875 * t711 + 0.2e1 * t691 * t346 * t1739 - 0.1e7 / 0.19683e5 * t1759 * t1760 * t350 + 0.6e1 * t691 * t2097 * t290 + 0.25e2 / 0.108e3 * t4765 * t337 + 0.25e2 / 0.36e2 * t1667 * t849;
  t5642 = t1681 * t54;
  t5646 = t267 * t2123;
  t5651 = t658 * t886;
  t5654 = t666 * t350;
  t5672 = t5397 + 0.25e2 / 0.36e2 * t673 * t2156 + 0.25e2 / 0.108e3 * t268 * t5642 * t336 - 0.5e2 / 0.9e1 * t5646 * t276 - 0.5e2 / 0.9e1 * t2159 * t686 + 0.1e5 / 0.243e3 * t5651 * t663 + 0.5e2 / 0.9e1 * t5654 * t1664 - 0.5e2 / 0.9e1 * t877 * t1672 + 0.1e5 / 0.243e3 * t2164 * t1659 - 0.5e2 / 0.27e2 * t877 * t1683 + 0.125e6 / 0.6561e4 * t2737 * t2139 * t2074 - 0.125e6 / 0.6561e4 * t2138 * t4652 * t842 - t5399 - 0.18e2 * t1747 * t862 * t692;
  t5697 = t269 * t685 * t290;
  t5702 = t660 * t662 * t290;
  t5720 = -0.18e2 * t1747 * t875 * t692 - t5403 + 0.24e2 * t4540 * t346 * t1748 - 0.25e4 / 0.243e3 * t4714 * t750 * t838 * t692 + 0.125e4 / 0.81e2 * t4694 * t750 * t2177 * t290 - 0.2e5 / 0.729e3 * t1773 * t750 * t2071 * t290 + 0.25e2 / 0.18e2 * t1767 * t459 * t842 * t711 - 0.1e3 / 0.9e1 * t2060 * t5697 + 0.2e5 / 0.243e3 * t4713 * t346 * t5702 - 0.125e4 / 0.81e2 * t658 * t5537 * t750 * t5533 * t274 + 0.25e4 / 0.243e3 * t4706 * t2057 + 0.125e4 / 0.243e3 * t1773 * t750 * t2074 * t290 + 0.125e4 / 0.243e3 * t1773 * t750 * t838 * t711;
  t5731 = t692 * t117 * t2958;
  t5736 = t660 * t450 * t684 * t274;
  t5754 = t1657 * t29;
  t5765 = -0.2e3 / 0.9e1 * t1766 * t862 * t2062 - 0.2e3 / 0.9e1 * t1766 * t875 * t2062 - 0.1e3 / 0.9e1 * t2060 * t4780 + 0.1e3 / 0.3e1 * t4723 * t346 * t5731 - 0.1e5 / 0.243e3 * t2218 * t5736 - 0.5e2 / 0.27e2 * t268 * t2155 * t852 - 0.5e2 / 0.27e2 * t1667 * t853 - 0.1e3 / 0.27e2 * t673 * t2169 + 0.5e2 / 0.9e1 * t4740 * t2146 + 0.5e2 / 0.9e1 * t1662 * t874 * t661 * t459 + 0.55e3 / 0.81e2 * t673 * t2173 - 0.125e4 / 0.243e3 * t659 * t5754 * t2952 + 0.55e3 / 0.81e2 * t268 * t848 * t2172 - 0.77e4 / 0.729e3 * t268 * t269 * t57 * t1678;
  t5773 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1641 * t352 - 0.3e1 / 0.8e1 * t5334 - 0.9e1 / 0.8e1 * t6 * t631 * t888 + t5299 / 0.4e1 - 0.3e1 / 0.4e1 * t5341 - 0.9e1 / 0.8e1 * t6 * t252 * t2227 - t5260 + t5310 / 0.4e1 - 0.3e1 / 0.8e1 * t5349 - 0.3e1 / 0.8e1 * t6 * t99 * (t5476 + t5514 + t5558 + t5599 + t5639 + t5672 + t5720 + t5765));
  tv4rho3sigma11 = t7 * t5773 + 0.3e1 * t2232;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t5780 = t6 * t1239 * t369;
  t5786 = t6 * t1246 * t369;
  t5789 = t6 * t412 * t933;
  t5796 = 0.5e1 / 0.36e2 * t6 * t1258 * t369;
  t5798 = t6 * t421 * t933;
  t5801 = t6 * t162 * t2345;
  t5808 = t49 * t1310;
  t5825 = 0.5e3 / 0.27e2 * t2525 * t2265 - 0.25e4 / 0.81e2 * t1880 + 0.2e5 / 0.243e3 * t1883 - 0.25e4 / 0.81e2 * t1886 + 0.5e3 / 0.81e2 * t490 * t5808 - 0.11e6 / 0.2187e4 * t1888 + 0.25e7 / 0.6561e4 * t3922 * t363 * t1316 - 0.125e8 / 0.19683e5 * t1891 + 0.25e7 / 0.6561e4 * t4919 * t901 * t475 + 0.25e8 / 0.59049e5 * t1894 - 0.3125e7 / 0.19683e5 * t1897 + 0.625e6 / 0.19683e5 * t495 * t363 * t1310 - 0.55e8 / 0.531441e6 * t1900;
  t5870 = -t192 * t83 * t5825 - t192 * t1358 * t366 - 0.3e1 * t192 * t513 * t930 - 0.3e1 * t192 * t210 * t2277 + 0.1e6 / 0.729e3 * t1825 + 0.25e3 / 0.27e2 * t1827 + 0.5e3 / 0.27e2 * t1829 + 0.25e3 / 0.27e2 * t1833 - 0.2e4 / 0.81e2 * t1843 - 0.2e4 / 0.81e2 * t1846 + 0.22e5 / 0.729e3 * t1851 + 0.6e1 * t482 * t2280 * t201 + 0.12e2 * t482 * t2282 * t201 + 0.6e1 * t482 * t2278 * t201 + 0.6e1 * t482 * t921 * t502 + 0.6e1 * t482 * t931 * t502 + 0.2e1 * t482 * t367 * t1390 - 0.18e2 * t1395 * t921 * t483 - 0.18e2 * t1395 * t931 * t483 + 0.24e2 * t3898 * t367 * t1396;
  t5873 = t1274 * t931;
  t5882 = t49 * t52;
  t5899 = t456 * t2280;
  t5902 = t456 * t2282;
  t5905 = t456 * t2278;
  t5920 = 0.5e2 / 0.9e1 * t2336 * t477 - 0.1e5 / 0.243e3 * t5873 * t453 + 0.5e2 / 0.9e1 * t915 * t1301 - 0.1e5 / 0.243e3 * t2341 * t1318 + 0.5e2 / 0.27e2 * t915 * t1312 + 0.1e5 / 0.81e2 * t5086 * t750 * t5882 + 0.5e2 / 0.9e1 * t5092 * t906 - 0.1e3 / 0.9e1 * t5113 * t2317 - 0.1e3 / 0.9e1 * t5116 * t2317 + 0.1e5 / 0.243e3 * t1956 * t2322 + 0.1e5 / 0.729e3 * t749 * t750 * t5808 + 0.5e2 / 0.9e1 * t1285 * t2330 + 0.5e2 / 0.9e1 * t5899 * t187 + 0.1e3 / 0.9e1 * t5902 * t187 + 0.5e2 / 0.9e1 * t5905 * t187 + 0.5e2 / 0.9e1 * t5074 * t906 + 0.1e5 / 0.243e3 * t5078 * t902 + 0.1e3 / 0.9e1 * t5082 * t906 - 0.1e3 / 0.9e1 * t2252 * t1323 + 0.1e3 / 0.9e1 * t5033 * t459 * t49 * t1396;
  t5930 = t1274 * t921;
  t5952 = t450 * t49;
  t5980 = t4004 * t367;
  t5983 = 0.5e2 / 0.9e1 * t1965 * t2330 + 0.5e2 / 0.27e2 * t458 * t459 * t49 * t1390 + 0.5e2 / 0.9e1 * t2333 * t477 - 0.1e5 / 0.243e3 * t5930 * t453 - 0.5e2 / 0.27e2 * t3877 * t358 - 0.5e2 / 0.9e1 * t1296 * t911 - 0.5e2 / 0.9e1 * t464 * t2309 - 0.5e2 / 0.27e2 * t179 * t4940 * t357 - 0.1e7 / 0.6561e4 * t2584 * t1930 * t2265 + 0.1e7 / 0.6561e4 * t1929 * t3837 * t905 + 0.5e2 / 0.9e1 * t1321 * t930 * t451 * t459 + 0.1e5 / 0.243e3 * t447 * t5180 * t5952 + 0.5e2 / 0.9e1 * t3855 * t2302 + 0.2e5 / 0.243e3 * t3975 * t750 * t901 * t483 - 0.1e5 / 0.81e2 * t3961 * t750 * t2312 * t201 - 0.2e5 / 0.243e3 * t3958 * t2256 - 0.1e5 / 0.243e3 * t1275 * t750 * t2265 * t201 - 0.1e5 / 0.243e3 * t1275 * t750 * t901 * t502 - 0.1e3 / 0.9e1 * t1269 * t459 * t905 * t502 + 0.1e3 / 0.3e1 * t5980 * t5163;
  t5984 = t1268 * t921;
  t5987 = t1268 * t931;
  t6000 = t3974 * t367;
  t6006 = t3837 * t366;
  t6013 = t366 * t201;
  t6026 = -0.1e7 / 0.6561e4 * t1929 * t4992 * t49 - 0.18e2 * t2872 * t6013 * t502 + 0.2e4 / 0.81e2 * t1940 - 0.5e5 / 0.243e3 * t1945 + 0.4e6 / 0.2187e4 * t1948 + 0.5e3 / 0.27e2 * t1953 - 0.1e6 / 0.729e3 * t1957 - 0.5e5 / 0.729e3 * t1960 - 0.5e3 / 0.27e2 * t1962 - 0.5e3 / 0.27e2 * t1966 - 0.25e3 / 0.27e2 * t1970;
  t6034 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1235 * t369 - 0.3e1 / 0.8e1 * t5780 - 0.9e1 / 0.8e1 * t6 * t408 * t933 + t5786 / 0.4e1 - 0.3e1 / 0.4e1 * t5789 - 0.9e1 / 0.8e1 * t6 * t156 * t2345 - t5796 + t5798 / 0.4e1 - 0.3e1 / 0.8e1 * t5801 - 0.3e1 / 0.8e1 * t6 * t28 * (t5870 + t5920 + t5983 - 0.2e3 / 0.9e1 * t5984 * t1820 - 0.2e3 / 0.9e1 * t5987 * t1820 - 0.1e3 / 0.9e1 * t2252 * t4037 - 0.1e5 / 0.243e3 * t2341 * t5235 + 0.1e5 / 0.81e2 * t5166 * t750 * t5882 * t185 - 0.1e3 / 0.9e1 * t2252 * t5215 + 0.2e5 / 0.243e3 * t6000 * t5220 + 0.5e7 / 0.19683e5 * t1932 - 0.2e7 / 0.6561e4 * t4975 * t2297 + 0.1e7 / 0.19683e5 * t3836 * t6006 + t6026));
  tv4rho3tau0 = t7 * t6034 + 0.3e1 * t2350;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t6041 = t6 * t1432 * t386;
  t6044 = t6 * t1436 * t386;
  t6048 = 0.5e1 / 0.36e2 * t6 * t1440 * t386;
  t6050 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1428 * t386 - 0.3e1 / 0.8e1 * t6041 + t6044 / 0.4e1 - t6048);
  tv4rho3tau1 = t7 * t6050 + 0.3e1 * t2363;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t6052 = 0.2e1 * t2377;
  t6058 = t6 * t1470 * t369 / 0.4e1;
  t6063 = t6 * t1477 * t369;
  t6067 = t6 * t563 * t933 / 0.4e1;
  t6076 = -0.3e1 / 0.8e1 * t6 * t1466 * t369 - t6058 - 0.3e1 / 0.4e1 * t6 * t559 * t933 + t6063 / 0.12e2 - t6067 - 0.3e1 / 0.8e1 * t6 * t241 * t2345 - t5780 / 0.8e1 + t5786 / 0.6e1 - t5789 / 0.4e1 - t5796 + t5798 / 0.6e1 - t5801 / 0.8e1;
  t6077 = my_piecewise3(t2, 0, t6076);
  tv4rho3tau2 = t7 * t6077 + t2350 + t6052;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t6079 = 0.2e1 * t2393;
  t6085 = t6 * t1513 * t386 / 0.4e1;
  t6087 = t6 * t1517 * t386;
  t6096 = t6 * t538 * t990 / 0.4e1;
  t6098 = t6 * t542 * t990;
  t6101 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1509 * t386 - t6085 + t6087 / 0.12e2 - t6041 / 0.8e1 + t6044 / 0.6e1 - t6048 - 0.3e1 / 0.8e1 * t6 * t534 * t990 - t6096 + t6098 / 0.12e2);
  tv4rho3tau3 = t7 * t6101 + t2363 + t6079;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t6107 = t6 * t1554 * t369;
  t6116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1550 * t369 - t6107 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t614 * t933 - t6058 + t6063 / 0.6e1 - t6067 + t5786 / 0.12e2 - t5796 + t5798 / 0.12e2);
  tv4rho3tau4 = t7 * t6116 + t2401 + t6052;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t6122 = t6 * t1584 * t386;
  t6129 = t6 * t587 * t990;
  t6137 = t6 * t228 * t2507;
  t6139 = -0.3e1 / 0.8e1 * t6 * t1580 * t386 - t6122 / 0.8e1 - t6085 + t6087 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t583 * t990 - t6129 / 0.4e1 + t6044 / 0.12e2 - t6048 - t6096 + t6098 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t224 * t2507 - t6137 / 0.8e1;
  t6140 = my_piecewise3(t90, 0, t6139);
  tv4rho3tau5 = t7 * t6140 + t2512 + t6079;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t6149 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1621 * t369 - 0.3e1 / 0.8e1 * t6107 + t6063 / 0.4e1 - t5796);
  tv4rho3tau6 = t7 * t6149 + 0.3e1 * t2401;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t6188 = t450 * t114;
  t6198 = t114 * t1681;
  t6216 = t658 * t1781;
  t6219 = 0.1e6 / 0.729e3 * t2058 - 0.5e2 / 0.9e1 * t1667 * t968 - 0.5e2 / 0.9e1 * t673 * t2467 - 0.5e2 / 0.27e2 * t268 * t5642 * t374 + 0.1e7 / 0.6561e4 * t2138 * t4652 * t962 - 0.1e7 / 0.6561e4 * t2737 * t2139 * t2432 + 0.5e2 / 0.9e1 * t4740 * t2471 + 0.5e2 / 0.9e1 * t1662 * t987 * t661 * t459 - 0.5e2 / 0.27e2 * t4765 * t375 + 0.1e5 / 0.243e3 * t659 * t5754 * t6188 + 0.1e3 / 0.9e1 * t5584 * t459 * t114 * t1748 - 0.1e3 / 0.9e1 * t2414 * t1664 + 0.1e5 / 0.729e3 * t837 * t750 * t6198 + 0.5e2 / 0.9e1 * t5520 * t963 + 0.1e3 / 0.9e1 * t5528 * t963 + 0.5e2 / 0.9e1 * t1782 * t2497 + 0.5e2 / 0.9e1 * t5538 * t963 + 0.5e2 / 0.9e1 * t2203 * t2497 + 0.5e2 / 0.27e2 * t668 * t459 * t114 * t1739 + 0.1e5 / 0.81e2 * t6216 * t2475;
  t6224 = t666 * t2424;
  t6227 = t666 * t2426;
  t6230 = t666 * t2445;
  t6243 = t1772 * t978;
  t6246 = t1772 * t988;
  t6257 = t4723 * t384;
  t6266 = t4713 * t384;
  t6271 = -0.1e3 / 0.9e1 * t5488 * t2479 - 0.1e3 / 0.9e1 * t5491 * t2479 + 0.5e2 / 0.9e1 * t6224 * t276 + 0.1e3 / 0.9e1 * t6227 * t276 + 0.5e2 / 0.9e1 * t6230 * t276 + 0.5e2 / 0.9e1 * t972 * t1672 - 0.1e5 / 0.243e3 * t2484 * t1659 + 0.5e2 / 0.9e1 * t2500 * t686 + 0.5e2 / 0.9e1 * t2503 * t686 + 0.5e2 / 0.27e2 * t972 * t1683 - 0.1e5 / 0.243e3 * t6243 * t663 - 0.1e5 / 0.243e3 * t6246 * t663 + 0.1e5 / 0.243e3 * t5524 * t959 + 0.1e5 / 0.243e3 * t2194 * t2489 - 0.1e5 / 0.81e2 * t4694 * t750 * t2474 * t290 + 0.1e3 / 0.3e1 * t6257 * t5731 + 0.2e5 / 0.243e3 * t4714 * t750 * t958 * t692 - 0.1e3 / 0.9e1 * t2414 * t4780 + 0.2e5 / 0.243e3 * t6266 * t5702 - 0.1e5 / 0.243e3 * t2484 * t5736;
  t6283 = t958 * t684;
  t6291 = t1766 * t978;
  t6294 = t1766 * t988;
  t6307 = t4652 * t383;
  t6338 = 0.5e3 / 0.27e2 * t2694 * t2432 - 0.25e4 / 0.81e2 * t2069 + 0.2e5 / 0.243e3 * t2072 - 0.25e4 / 0.81e2 * t2075 + 0.5e3 / 0.81e2 * t699 * t6198 - 0.11e6 / 0.2187e4 * t2077 + 0.25e7 / 0.6561e4 * t4566 * t380 * t1657 - 0.125e8 / 0.19683e5 * t2080 + 0.25e7 / 0.6561e4 * t5454 * t6283 + 0.25e8 / 0.59049e5 * t2083 - 0.3125e7 / 0.19683e5 * t2086 + 0.625e6 / 0.19683e5 * t704 * t380 * t1681 - 0.55e8 / 0.531441e6 * t2089;
  t6346 = -0.2e5 / 0.243e3 * t4706 * t2418 - 0.1e5 / 0.243e3 * t1773 * t750 * t2432 * t290 - 0.1e5 / 0.243e3 * t1773 * t750 * t958 * t711 + 0.1e5 / 0.81e2 * t2176 * t750 * t6283 - 0.1e3 / 0.9e1 * t1767 * t459 * t962 * t711 - 0.2e3 / 0.9e1 * t6291 * t2062 - 0.2e3 / 0.9e1 * t6294 * t2062 - 0.1e3 / 0.9e1 * t2414 * t5697 + 0.5e7 / 0.19683e5 * t2141 - 0.18e2 * t2992 * t383 * t711 * t290 - 0.1e7 / 0.6561e4 * t2138 * t5421 * t114 + 0.1e7 / 0.19683e5 * t4651 * t6307 - 0.2e7 / 0.6561e4 * t5408 * t2459 - 0.3e1 * t281 * t722 * t987 - 0.3e1 * t281 * t299 * t2444 - t281 * t141 * t6338 - t281 * t1717 * t383 + 0.25e3 / 0.27e2 * t2149 + 0.5e3 / 0.27e2 * t2151 + 0.25e3 / 0.27e2 * t2157;
  t6387 = 0.12e2 * t691 * t2426 * t290 + 0.6e1 * t691 * t978 * t711 - 0.5e5 / 0.243e3 * t2179 + 0.4e6 / 0.2187e4 * t2182 + 0.5e3 / 0.27e2 * t2186 + 0.2e4 / 0.81e2 * t2191 - 0.1e6 / 0.729e3 * t2195 - 0.5e5 / 0.729e3 * t2198 - 0.5e3 / 0.27e2 * t2200 - 0.5e3 / 0.27e2 * t2204 - 0.25e3 / 0.27e2 * t2208;
  t6395 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t1641 * t386 - 0.3e1 / 0.8e1 * t6122 - 0.9e1 / 0.8e1 * t6 * t631 * t990 + t6087 / 0.4e1 - 0.3e1 / 0.4e1 * t6129 - 0.9e1 / 0.8e1 * t6 * t252 * t2507 - t6048 + t6098 / 0.4e1 - 0.3e1 / 0.8e1 * t6137 - 0.3e1 / 0.8e1 * t6 * t99 * (t6219 + t6271 + t6346 - 0.2e4 / 0.81e2 * t2167 - 0.2e4 / 0.81e2 * t2170 + 0.22e5 / 0.729e3 * t2174 + 0.24e2 * t4540 * t384 * t1748 + 0.6e1 * t691 * t2445 * t290 + 0.6e1 * t691 * t988 * t711 + 0.2e1 * t691 * t384 * t1739 - 0.18e2 * t1747 * t978 * t692 - 0.18e2 * t1747 * t988 * t692 + 0.6e1 * t691 * t2424 * t290 + t6387));
  tv4rho3tau7 = t7 * t6395 + 0.3e1 * t2512;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t6402 = t6 * t412 * t1034;
  t6409 = t6 * t421 * t1034 / 0.12e2;
  t6411 = t6 * t162 * t2646;
  t6418 = t740 * t54;
  t6432 = t451 * t29;
  t6441 = t3974 * t748 * t29;
  t6442 = t321 * t201;
  t6443 = t6442 * t185;
  t6450 = 0.1e1 / t37 / t3804 * t432 * t34;
  t6453 = t1855 * sigma[0];
  t6456 = t459 * t437;
  t6460 = 0.25e4 / 0.3486784401e10 * t3822 * t6450;
  t6462 = 0.5375e4 / 0.28697814e8 * t1351 * t6453;
  t6464 = 0.95e3 / 0.531441e6 * t430 * t6456;
  t6480 = 0.11e4 / 0.243e3 * t790 * t1850 - 0.25e2 / 0.432e3 * t3866 * t2597 * t3867 - 0.25e2 / 0.81e2 * t1321 * t6418 * t1322 - 0.1e3 / 0.27e2 * t3866 * t1015 * t451 * t459 + 0.1e3 / 0.27e2 * t4953 * t1935 + 0.5e2 / 0.27e2 * t1321 * t1027 * t451 * t459 + 0.625e3 / 0.972e3 * t447 * t6432 * t1003 + 0.475e5 / 0.6561e4 * t447 * t448 * t450 * t437 - 0.1e5 / 0.729e3 * t6441 * t2839 * t6443 + t77 * (-0.25e4 / 0.3486784401e10 * t3795 * t6450 + 0.5375e4 / 0.28697814e8 * t1332 * t6453 - 0.95e3 / 0.531441e6 * t507 * t6456 + t6460 - t6462 + t6464) - 0.2e3 / 0.27e2 * t1268 * t2541 * t187 - 0.11e4 / 0.243e3 * t458 * t459 * t442 * t321 + 0.2e3 / 0.27e2 * t456 * t2520 * t187 + 0.1e3 / 0.27e2 * t456 * t2523 * t187;
  t6499 = t456 * t799 * t52;
  t6503 = t456 * t326 * t185;
  t6511 = t446 * t799 * t53;
  t6520 = 0.1e3 / 0.27e2 * t456 * t2537 * t187 - 0.25e2 / 0.54e2 * t5074 * t1008 - 0.25e2 / 0.27e2 * t5082 * t1008 - 0.25e2 / 0.27e2 * t1285 * t2619 - 0.25e2 / 0.54e2 * t5092 * t1008 - 0.25e2 / 0.27e2 * t1965 * t2619 - 0.25e2 / 0.54e2 * t458 * t459 * t39 * t1902 - 0.25e2 / 0.27e2 * t6499 * t756 - 0.25e2 / 0.27e2 * t6503 * t756 - 0.25e2 / 0.54e2 * t1984 * t1969 + 0.4e5 / 0.2187e4 * t2625 * t1947 - 0.5e4 / 0.729e3 * t6511 * t752 - 0.25e4 / 0.729e3 * t2625 * t1959 + 0.2e3 / 0.81e2 * t1285 * t2611 + 0.2e3 / 0.81e2 * t1965 * t2611;
  t6529 = t750 * t52 * t185;
  t6569 = 0.2e3 / 0.81e2 * t458 * t459 * t174 * t787 + 0.625e3 / 0.486e3 * t446 * t210 * t999 * t6529 + 0.1e3 / 0.27e2 * t456 * t2539 * t187 - 0.1e3 / 0.27e2 * t2628 * t477 + 0.2e5 / 0.729e3 * t3974 * t1016 * t453 + 0.1e3 / 0.27e2 * t2631 * t477 - 0.2e5 / 0.729e3 * t1274 * t1019 * t453 + 0.5e2 / 0.27e2 * t2634 * t477 - 0.1e5 / 0.729e3 * t1274 * t1028 * t453 + 0.625e3 / 0.972e3 * t1942 * t750 * t999 * t475 + 0.5e4 / 0.2187e4 * t1275 * t750 * t740 * t201 + 0.2e3 / 0.27e2 * t456 * t2544 * t187 - 0.5e4 / 0.729e3 * t1942 * t750 * t740 * t185 + 0.625e3 / 0.1458e4 * t3975 * t750 * t999 * t483;
  t6570 = t1268 * t1983;
  t6575 = t446 * t1983;
  t6588 = t787 * t52 * t2845;
  t6618 = 0.25e2 / 0.27e2 * t6570 * t1952 + 0.2e3 / 0.81e2 * t1984 * t1939 - 0.25e4 / 0.243e3 * t6575 * t1944 - 0.625e3 / 0.1458e4 * t3958 * t2642 - 0.625e3 / 0.2916e4 * t1275 * t750 * t999 * t502 + 0.2e3 / 0.9e1 * t4004 * t1016 * t1820 - 0.4e3 / 0.27e2 * t1818 * t6588 - 0.4e3 / 0.27e2 * t1268 * t1019 * t1820 + 0.5e2 / 0.27e2 * t5113 * t2548 + 0.5e2 / 0.27e2 * t5116 * t2548 + 0.5e2 / 0.27e2 * t1269 * t459 * t2618 * t201 + 0.25e2 / 0.27e2 * t1269 * t459 * t1007 * t502 + 0.25e4 / 0.243e3 * t3961 * t750 * t1007 * t451 - 0.25e2 / 0.9e1 * t5033 * t459 * t1007 * t483 - 0.4e3 / 0.81e2 * t1269 * t459 * t2610 * t201;
  t6650 = t787 * t787;
  t6660 = -0.4e5 / 0.2187e4 * t1275 * t750 * t2610 * t185 + 0.5e4 / 0.729e3 * t3958 * t2552 + 0.5e4 / 0.729e3 * t1275 * t750 * t2618 * t185 + 0.25e4 / 0.729e3 * t1275 * t750 * t1007 * t475 - 0.2e3 / 0.27e2 * t1268 * t1028 * t1820 - 0.625e3 / 0.486e3 * t3961 * t750 * t2637 * t201 + 0.5e4 / 0.729e3 * t5136 * t1824 - 0.2e1 * t192 * t2568 * t201 + 0.2e1 * t482 * t1032 * t483 + 0.4e1 * t482 * t83 * t6650 - 0.12e2 * t1395 * t1019 * t483 + t6462 - t6464 - 0.6e1 * t1395 * t1028 * t483;
  t6698 = t4026 * t451;
  t6704 = 0.24e2 * t3898 * t1016 * t483 + 0.8e1 * t482 * t2544 * t201 + 0.8e1 * t482 * t2520 * t201 + 0.4e1 * t482 * t1019 * t502 + 0.2e1 * t482 * t1028 * t502 - 0.12e2 * t1395 * t2541 * t201 - 0.6e1 * t1395 * t1016 * t502 + 0.8e1 * t482 * t775 * t787 + 0.4e1 * t482 * t322 * t1902 + 0.4e1 * t482 * t2523 * t201 + 0.4e1 * t482 * t2537 * t201 - 0.475e3 / 0.486e3 * t179 * t6456 - 0.5e2 / 0.27e2 * t2601 * t468 - 0.3125e5 / 0.6561e4 * t6698 * t2585 + 0.5e6 / 0.59049e5 * t2584 * t1930 * t740;
  t6708 = t1360 * t475;
  t6716 = t76 * t326;
  t6728 = t475 * t65;
  t6764 = 0.25e2 / 0.81e2 * t464 * t2561 - 0.15625e5 / 0.19683e5 * t6708 * t2585 - 0.3125e5 / 0.19683e5 * t2584 * t4992 * t999 - 0.25e2 / 0.864e3 * t1296 * t1000 + 0.25e6 / 0.19683e5 * t1929 * t6716 * t39 - 0.24e2 * t2872 * t6442 * t787 - t192 * t513 * t1027 - 0.2e1 * t192 * t210 * t2536 - t192 * t83 * (0.125e3 / 0.1296e4 * t6728 * t999 - 0.25e3 / 0.243e3 * t2525 * t740 + 0.2375e4 / 0.729e3 * t490 * t437 + 0.78125e5 / 0.13122e5 * t3922 * t1024 * t451 - 0.125e7 / 0.59049e5 * t1380 * t2533 * t185 + 0.78125e5 / 0.39366e5 * t1380 * t1024 * t475 + 0.296875e7 / 0.177147e6 * t495 * t72 * t437) - t192 * t1032 * t502 + 0.2e1 * t482 * t513 * t1015 - 0.2e1 * t192 * t1872 * t321 - 0.4e1 * t192 * t799 * t787 - 0.2e1 * t192 * t326 * t1902;
  t6765 = t446 * t1032;
  t6777 = t178 * t2568;
  t6798 = 0.1e5 / 0.729e3 * t6765 * t453 + 0.625e3 / 0.2916e4 * t3874 * t1004 - 0.25e6 / 0.19683e5 * t1929 * t3837 * t1007 + 0.25e2 / 0.27e2 * t1835 * t762 + 0.25e2 / 0.54e2 * t790 * t1832 - 0.1e3 / 0.27e2 * t6777 * t187 + 0.3125e5 / 0.19683e5 * t2584 * t3837 * t2641 + 0.25e2 / 0.432e3 * t3855 * t2598 - 0.2e3 / 0.81e2 * t1835 * t766 - 0.2e3 / 0.81e2 * t790 * t1845 - 0.5e4 / 0.2187e4 * t1327 * t2594 + 0.25e2 / 0.864e3 * t1321 * t2597 * t3880 - 0.5e2 / 0.27e2 * t2601 * t477 + 0.25e2 / 0.54e2 * t4944 * t313 - t6460;
  t6806 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t1034 - t6402 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t2646 + t6409 - t6411 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t6480 + t6520 + t6569 + t6618 + t6660 + t6704 + t6764 + t6798));
  tv4rho2sigma20 = t7 * t6806 + 0.2e1 * t2651;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t6813 = t6 * t538 * t1076;
  t6817 = t6 * t542 * t1076 / 0.12e2;
  t6819 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t1076 - t6813 / 0.4e1 + t6817);
  tv4rho2sigma25 = t7 * t6819 + 0.2e1 * t2660;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t6825 = t6 * t563 * t1034;
  t6833 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t1034 - t6825 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t2646 - t6402 / 0.8e1 + t6409 - t6411 / 0.8e1);
  tv4rho2sigma26 = t7 * t6833 + t2651 + t2666;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t6839 = t6 * t587 * t1076;
  t6846 = t6 * t228 * t2797;
  t6849 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t1076 - t6839 / 0.8e1 - t6813 / 0.8e1 + t6817 - 0.3e1 / 0.8e1 * t6 * t224 * t2797 - t6846 / 0.8e1);
  tv4rho2sigma211 = t7 * t6849 + t2660 + t2802;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t6857 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t1034 - t6825 / 0.4e1 + t6409);
  tv4rho2sigma212 = t7 * t6857 + 0.2e1 * t2666;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t6871 = t874 * t874;
  t6884 = t684 * t65;
  t6922 = 0.1e1 / t102 / t4610 * t644 * t34;
  t6925 = t2106 * sigma[2];
  t6928 = t459 * t649;
  t6932 = 0.25e4 / 0.3486784401e10 * t4626 * t6922;
  t6934 = 0.5375e4 / 0.28697814e8 * t1710 * t6925;
  t6936 = 0.95e3 / 0.531441e6 * t642 * t6928;
  t6945 = 0.2e1 * t691 * t1074 * t692 + 0.4e1 * t691 * t141 * t6871 - 0.2e1 * t281 * t2123 * t345 - 0.4e1 * t281 * t886 * t874 - 0.2e1 * t281 * t299 * t2705 - t281 * t141 * (0.125e3 / 0.1296e4 * t6884 * t1041 - 0.25e3 / 0.243e3 * t2694 * t828 + 0.2375e4 / 0.729e3 * t699 * t649 + 0.78125e5 / 0.13122e5 * t4566 * t1066 * t661 - 0.125e7 / 0.59049e5 * t1729 * t2702 * t274 + 0.78125e5 / 0.39366e5 * t1729 * t1066 * t684 + 0.296875e7 / 0.177147e6 * t704 * t72 * t649) - t281 * t1074 * t711 - 0.2e1 * t281 * t2684 * t290 + 0.2e1 * t691 * t722 * t1057 - 0.2e1 * t281 * t350 * t2091 - t281 * t722 * t1069 + t135 * (-0.25e4 / 0.3486784401e10 * t4601 * t6922 + 0.5375e4 / 0.28697814e8 * t1691 * t6925 - 0.95e3 / 0.531441e6 * t716 * t6928 + t6932 - t6934 + t6936) - 0.625e3 / 0.2916e4 * t1773 * t750 * t1041 * t711 + 0.625e3 / 0.486e3 * t6216 * t2772;
  t6970 = t658 * t886 * t118;
  t6986 = 0.2e3 / 0.27e2 * t666 * t2689 * t276 + 0.1e3 / 0.27e2 * t2761 * t686 - 0.2e5 / 0.729e3 * t1772 * t1061 * t663 + 0.1e3 / 0.27e2 * t666 * t2692 * t276 + 0.1e3 / 0.27e2 * t666 * t2706 * t276 + 0.5e2 / 0.27e2 * t2764 * t686 - 0.1e5 / 0.729e3 * t1772 * t1070 * t663 - 0.625e3 / 0.1458e4 * t4706 * t2768 + 0.2e3 / 0.81e2 * t1782 * t2793 - 0.5e4 / 0.729e3 * t6970 * t839 - 0.25e4 / 0.729e3 * t2786 * t2197 - 0.2e3 / 0.27e2 * t1766 * t2710 * t276 - 0.1e3 / 0.27e2 * t2789 * t686 + 0.2e5 / 0.729e3 * t4713 * t1058 * t663 + 0.1e3 / 0.27e2 * t666 * t2708 * t276;
  t7007 = t666 * t886 * t117;
  t7011 = t666 * t350 * t274;
  t7027 = 0.625e3 / 0.972e3 * t2176 * t750 * t1041 * t684 - 0.25e2 / 0.54e2 * t5520 * t1050 - 0.25e2 / 0.27e2 * t5528 * t1050 - 0.25e2 / 0.27e2 * t1782 * t2780 - 0.25e2 / 0.54e2 * t5538 * t1050 - 0.25e2 / 0.27e2 * t2203 * t2780 - 0.25e2 / 0.54e2 * t668 * t459 * t104 * t2091 - 0.25e2 / 0.27e2 * t7007 * t843 - 0.25e2 / 0.27e2 * t7011 * t843 - 0.25e2 / 0.54e2 * t2222 * t2207 + 0.4e5 / 0.2187e4 * t2786 * t2181 + 0.2e3 / 0.27e2 * t666 * t2686 * t276 + 0.8e1 * t691 * t2689 * t290 + 0.4e1 * t691 * t1061 * t711;
  t7047 = t1766 * t2221;
  t7052 = t658 * t2221;
  t7076 = 0.4e1 * t691 * t2692 * t290 + 0.4e1 * t691 * t2706 * t290 + 0.2e1 * t691 * t1070 * t711 - 0.11e4 / 0.243e3 * t668 * t459 * t654 * t345 + 0.2e3 / 0.81e2 * t2203 * t2793 + 0.2e3 / 0.81e2 * t668 * t459 * t263 * t874 + 0.25e2 / 0.27e2 * t7047 * t2185 + 0.2e3 / 0.81e2 * t2222 * t2190 - 0.25e4 / 0.243e3 * t7052 * t2178 + 0.625e3 / 0.1458e4 * t4714 * t750 * t1041 * t692 + 0.5e4 / 0.2187e4 * t1773 * t750 * t828 * t290 - 0.5e4 / 0.729e3 * t2176 * t750 * t828 * t274 - 0.6e1 * t1747 * t1058 * t711 + 0.8e1 * t691 * t862 * t874 + 0.4e1 * t691 * t346 * t2091;
  t7106 = t1772 * t4682;
  t7119 = 0.8e1 * t691 * t2686 * t290 - 0.12e2 * t1747 * t2710 * t290 + t6934 - t6936 + 0.24e2 * t4540 * t1058 * t692 - 0.12e2 * t1747 * t1061 * t692 - 0.6e1 * t1747 * t1070 * t692 - 0.4e3 / 0.81e2 * t1767 * t459 * t2792 * t290 - 0.25e2 / 0.9e1 * t5584 * t459 * t1049 * t692 + 0.5e4 / 0.729e3 * t4706 * t2718 + 0.5e2 / 0.27e2 * t5491 * t2714 + 0.25e4 / 0.243e3 * t7106 * t750 * t1049 * t117 + 0.5e2 / 0.27e2 * t1767 * t459 * t2779 * t290 + 0.5e4 / 0.729e3 * t1773 * t750 * t2779 * t274;
  t7138 = t269 * t275 * t874;
  t7153 = t345 * t290;
  t7157 = t1759 * t684;
  t7165 = t4665 * t661;
  t7168 = 0.5e4 / 0.729e3 * t5576 * t2057 - 0.4e3 / 0.27e2 * t1766 * t1061 * t2062 - 0.2e3 / 0.27e2 * t1766 * t1070 * t2062 - 0.625e3 / 0.486e3 * t4694 * t750 * t2767 * t274 + 0.5e2 / 0.27e2 * t5488 * t2714 + 0.2e3 / 0.9e1 * t4723 * t1058 * t2062 - 0.4e3 / 0.27e2 * t2060 * t7138 + 0.25e2 / 0.27e2 * t1767 * t459 * t1049 * t711 - 0.4e5 / 0.2187e4 * t1773 * t750 * t2792 * t274 + 0.25e4 / 0.729e3 * t1773 * t750 * t1049 * t684 - 0.24e2 * t2992 * t7153 * t874 - 0.15625e5 / 0.19683e5 * t7157 * t2738 - 0.3125e5 / 0.19683e5 * t2737 * t5421 * t1041 - 0.25e2 / 0.864e3 * t1667 * t1042 - 0.3125e5 / 0.6561e4 * t7165 * t2738;
  t7173 = t134 * t350;
  t7196 = t4713 * t836 * t29;
  t7197 = t7153 * t274;
  t7209 = 0.5e6 / 0.59049e5 * t2737 * t2139 * t828 + 0.25e6 / 0.19683e5 * t2138 * t7173 * t104 + 0.3125e5 / 0.19683e5 * t2737 * t4652 * t2767 - 0.5e4 / 0.2187e4 * t1686 * t2752 - 0.2e3 / 0.81e2 * t2159 * t853 - 0.2e3 / 0.81e2 * t877 * t2169 - 0.25e6 / 0.19683e5 * t2138 * t4652 * t1049 + 0.25e2 / 0.81e2 * t673 * t2677 - 0.475e3 / 0.486e3 * t268 * t6928 - 0.5e2 / 0.27e2 * t2748 * t677 - 0.1e5 / 0.729e3 * t7196 * t2952 * t7197 + 0.11e4 / 0.243e3 * t877 * t2173 + 0.1e3 / 0.27e2 * t5654 * t2146 + 0.5e2 / 0.27e2 * t1662 * t1069 * t661 * t459;
  t7210 = t661 * t29;
  t7217 = t828 * t54;
  t7236 = t658 * t1074;
  t7239 = t267 * t2684;
  t7250 = 0.625e3 / 0.972e3 * t659 * t7210 * t1045 - 0.25e2 / 0.432e3 * t4749 * t2744 * t4750 - 0.25e2 / 0.81e2 * t1662 * t7217 * t1663 - 0.1e3 / 0.27e2 * t4749 * t1057 * t661 * t459 + 0.475e5 / 0.6561e4 * t659 * t660 * t450 * t649 + 0.25e2 / 0.54e2 * t877 * t2156 + 0.25e2 / 0.864e3 * t1662 * t2744 * t4770 - 0.5e2 / 0.27e2 * t2748 * t686 + 0.1e5 / 0.729e3 * t7236 * t663 - t6932 - 0.1e3 / 0.27e2 * t7239 * t276 + 0.25e2 / 0.432e3 * t4740 * t2745 + 0.625e3 / 0.2916e4 * t4736 * t1046 + 0.25e2 / 0.54e2 * t5646 * t337 + 0.25e2 / 0.27e2 * t2159 * t849;
  t7258 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t1076 - t6839 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t2797 + t6817 - t6846 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * (t6945 + t6986 + t7027 + t7076 + t7119 + t7168 + t7209 + t7250));
  tv4rho2sigma217 = t7 * t7258 + 0.2e1 * t2802;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t7265 = t6 * t412 * t1112;
  t7272 = t6 * t421 * t1112 / 0.12e2;
  t7274 = t6 * t162 * t2922;
  t7318 = 0.1e4 / 0.81e2 * t2549 + 0.1e6 / 0.2187e4 * t2553 + 0.5e2 / 0.27e2 * t458 * t459 * t49 * t1902 + 0.1e3 / 0.27e2 * t6499 * t906 + 0.1e3 / 0.27e2 * t6503 * t906 + 0.5e2 / 0.27e2 * t1984 * t2330 - 0.6e1 * t1395 * t1102 * t483 - 0.6e1 * t1395 * t1110 * t483 + 0.4e1 * t482 * t2824 * t201 + 0.4e1 * t482 * t2810 * t201 + 0.2e1 * t482 * t2278 * t321 + 0.4e1 * t482 * t931 * t787 + 0.2e1 * t482 * t367 * t1902 + 0.2e1 * t482 * t1102 * t502 + 0.2e1 * t482 * t1110 * t502 + 0.4e1 * t482 * t2812 * t201;
  t7335 = t1274 * t1102;
  t7340 = t1274 * t1110;
  t7345 = t456 * t2824;
  t7348 = t456 * t2810;
  t7351 = t456 * t2812;
  t7354 = t456 * t2822;
  t7361 = 0.4e1 * t482 * t2822 * t201 + 0.2e1 * t482 * t2280 * t321 + 0.4e1 * t482 * t2282 * t321 + 0.4e1 * t482 * t921 * t787 - 0.25e2 / 0.108e3 * t915 * t1832 + 0.5e2 / 0.27e2 * t2905 * t477 - 0.1e5 / 0.729e3 * t7335 * t453 + 0.5e2 / 0.27e2 * t2908 * t477 - 0.1e5 / 0.729e3 * t7340 * t453 + 0.25e4 / 0.729e3 * t3958 * t2912 + 0.1e3 / 0.27e2 * t7345 * t187 + 0.1e3 / 0.27e2 * t7348 * t187 + 0.1e3 / 0.27e2 * t7351 * t187 + 0.1e3 / 0.27e2 * t7354 * t187 + 0.5e2 / 0.27e2 * t5074 * t1088 + 0.1e3 / 0.27e2 * t5082 * t1088;
  t7391 = t446 * t1284;
  t7402 = 0.1e3 / 0.27e2 * t1285 * t2892 + 0.5e2 / 0.27e2 * t5092 * t1088 + 0.1e3 / 0.27e2 * t1965 * t2892 - 0.55e3 / 0.243e3 * t915 * t1850 - 0.1e3 / 0.27e2 * t2252 * t1935 - 0.25e4 / 0.729e3 * t3975 * t750 * t1082 * t483 + 0.1e3 / 0.81e2 * t2333 * t766 + 0.1e3 / 0.81e2 * t2336 * t766 + 0.1e3 / 0.81e2 * t915 * t1845 - 0.1e3 / 0.27e2 * t6570 * t2317 + 0.1e5 / 0.243e3 * t6575 * t2313 + 0.125e4 / 0.729e3 * t1275 * t750 * t1082 * t502 - 0.25e4 / 0.243e3 * t7391 * t2916 - 0.125e4 / 0.243e3 * t1942 * t750 * t1082 * t475 + 0.2e5 / 0.729e3 * t6511 * t902 + 0.1e5 / 0.729e3 * t2625 * t2322;
  t7454 = -0.25e2 / 0.108e3 * t5899 * t313 - 0.25e2 / 0.54e2 * t5902 * t313 - 0.25e2 / 0.54e2 * t2333 * t762 - 0.25e2 / 0.108e3 * t5905 * t313 - 0.25e2 / 0.54e2 * t2336 * t762 - 0.2e3 / 0.27e2 * t1269 * t459 * t2891 * t201 - 0.2e5 / 0.729e3 * t1275 * t750 * t2891 * t185 - 0.2e5 / 0.729e3 * t5136 * t2256 - 0.2e3 / 0.27e2 * t5113 * t2828 - 0.1e3 / 0.27e2 * t2252 * t2844 * t459 * t475 + 0.2e5 / 0.729e3 * t6000 * t321 * t53 * t750 * t451 + 0.25e4 / 0.243e3 * t3961 * t750 * t2911 * t185 - 0.1e3 / 0.27e2 * t1269 * t459 * t1087 * t502 - 0.1e5 / 0.729e3 * t1275 * t750 * t1087 * t475 + 0.25e2 / 0.54e2 * t2252 * t180 * t312 * t502 + 0.25e2 / 0.27e2 * t5984 * t2836 + 0.25e4 / 0.729e3 * t5930 * t2841;
  t7468 = t1268 * t1102;
  t7471 = t1268 * t1110;
  t7504 = 0.25e2 / 0.27e2 * t5987 * t2836 + 0.25e4 / 0.729e3 * t5873 * t2841 + 0.25e2 / 0.27e2 * t2252 * t761 * t2835 + 0.125e4 / 0.243e3 * t2341 * t6432 * t2839 * t52 - 0.2e3 / 0.27e2 * t7468 * t1820 - 0.2e3 / 0.27e2 * t7471 * t1820 - 0.2e5 / 0.729e3 * t3958 * t2832 - 0.2e3 / 0.27e2 * t5116 * t2828 - 0.1e5 / 0.243e3 * t1274 * t3991 * t750 * t1087 * t52 - 0.1e7 / 0.19683e5 * t1929 * t6716 * t49 + 0.25e6 / 0.6561e4 * t6698 * t2866 - 0.12e2 * t1395 * t210 * t2874 - 0.12e2 * t2872 * t930 * t321 * t201 - 0.12e2 * t2872 * t366 * t787 * t201 + 0.125e6 / 0.19683e5 * t6708 * t2866 + 0.25e6 / 0.19683e5 * t2584 * t4992 * t1082;
  t7537 = t3898 * t83;
  t7559 = 0.25e2 / 0.108e3 * t1296 * t1094 - 0.6e1 * t2872 * t2873 * t502 - 0.25e2 / 0.18e2 * t5980 * t180 * t312 * t483 - 0.2e3 / 0.81e2 * t2252 * t180 * t765 * t201 + 0.1e3 / 0.9e1 * t5033 * t459 * t1087 * t483 - 0.2e5 / 0.2187e4 * t2341 * t448 * t450 * t174 * t185 + 0.125e4 / 0.729e3 * t2341 * t448 * t2839 * t475 - 0.2e3 / 0.27e2 * t5984 * t2846 - 0.2e3 / 0.27e2 * t5987 * t2846 - 0.2e3 / 0.27e2 * t2252 * t6588 + 0.24e2 * t7537 * t2873 * t483 - 0.125e4 / 0.243e3 * t447 * t6432 * t1083 + 0.25e2 / 0.54e2 * t3866 * t1093 * t3867 + 0.5e2 / 0.27e2 * t4953 * t2302 + 0.5e2 / 0.27e2 * t1321 * t1109 * t451 * t459 - 0.25e6 / 0.19683e5 * t2584 * t3837 * t2911 + 0.1e7 / 0.19683e5 * t1929 * t3837 * t1087;
  t7582 = t3974 * t367 * t53;
  t7594 = -0.125e6 / 0.19683e5 * t1929 * t3837 * t366 * t39 - 0.25e2 / 0.54e2 * t3855 * t2877 - 0.25e2 / 0.108e3 * t1321 * t1093 * t3880 - 0.125e4 / 0.729e3 * t3874 * t1084 - 0.5e2 / 0.27e2 * t4944 * t358 - 0.1e3 / 0.27e2 * t1835 * t911 - 0.5e2 / 0.27e2 * t790 * t2309 + 0.13e4 / 0.243e3 * t2582 - 0.325e7 / 0.59049e5 * t2586 - 0.325e3 / 0.162e3 * t2588 - 0.5e4 / 0.729e3 * t7582 * t1824 + 0.2e3 / 0.9e1 * t4004 * t1099 * t1820 + 0.4e5 / 0.729e3 * t6441 * t5952 * t6443 - 0.2e4 / 0.243e3 * t2591 - 0.26e6 / 0.6561e4 * t2595 + 0.325e3 / 0.162e3 * t2599;
  t7633 = 0.325e5 / 0.2187e4 * t2604 + 0.5e3 / 0.81e2 * t2606 + 0.5e3 / 0.81e2 * t2608 - t192 * t1872 * t366 - 0.2e1 * t192 * t799 * t930 - t192 * t326 * t2277 - t192 * t513 * t1109 - 0.2e1 * t192 * t210 * t2821 - t192 * t83 * (-0.125e3 / 0.162e3 * t6728 * t1082 + 0.1625e4 / 0.243e3 * t2526 - 0.13e5 / 0.729e3 * t2528 - 0.3125e6 / 0.6561e4 * t3922 * t1106 * t451 + 0.8125e7 / 0.59049e5 * t2531 - 0.3125e6 / 0.19683e5 * t1380 * t1106 * t475 - 0.1625e8 / 0.177147e6 * t2534) + 0.2e4 / 0.243e3 * t2612 - 0.5e3 / 0.81e2 * t2614 - 0.5e3 / 0.81e2 * t2616 - 0.5e3 / 0.81e2 * t2620 - 0.5e3 / 0.81e2 * t2622 - 0.1e6 / 0.2187e4 * t2626 + 0.325e5 / 0.729e3 * t2639 - 0.325e5 / 0.2187e4 * t2643;
  t7641 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t1112 - t7265 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t2922 + t7272 - t7274 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t7318 + t7361 + t7402 + t7454 + t7504 + t7559 + t7594 + t7633));
  tv4rho2sigmatau0 = t7 * t7641 + 0.2e1 * t2927;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t7648 = t6 * t538 * t1148;
  t7652 = t6 * t542 * t1148 / 0.12e2;
  t7654 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t1148 - t7648 / 0.4e1 + t7652);
  tv4rho2sigmatau5 = t7 * t7654 + 0.2e1 * t2936;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t7660 = t6 * t563 * t1112;
  t7668 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t1112 - t7660 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t2922 - t7265 / 0.8e1 + t7272 - t7274 / 0.8e1);
  tv4rho2sigmatau6 = t7 * t7668 + t2927 + t2942;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t7674 = t6 * t587 * t1148;
  t7681 = t6 * t228 * t3059;
  t7684 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t1148 - t7674 / 0.8e1 - t7648 / 0.8e1 + t7652 - 0.3e1 / 0.8e1 * t6 * t224 * t3059 - t7681 / 0.8e1);
  tv4rho2sigmatau11 = t7 * t7684 + t2936 + t3064;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t7692 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t1112 - t7660 / 0.4e1 + t7272);
  tv4rho2sigmatau12 = t7 * t7692 + 0.2e1 * t2942;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t7742 = 0.1e4 / 0.81e2 * t2715 + 0.1e6 / 0.2187e4 * t2719 + 0.25e6 / 0.19683e5 * t2737 * t5421 * t1118 + 0.25e2 / 0.108e3 * t1667 * t1130 - 0.12e2 * t1747 * t299 * t2994 - 0.12e2 * t2992 * t987 * t345 * t290 - 0.1e3 / 0.27e2 * t2159 * t968 - 0.5e2 / 0.27e2 * t877 * t2467 - 0.25e2 / 0.108e3 * t1662 * t1129 * t4770 - 0.25e6 / 0.19683e5 * t2737 * t4652 * t3036 - 0.25e2 / 0.54e2 * t4740 * t3001 + 0.1e7 / 0.19683e5 * t2138 * t4652 * t1123 - 0.125e6 / 0.19683e5 * t2138 * t4652 * t383 * t104 - 0.125e4 / 0.729e3 * t4736 * t1120 - 0.5e2 / 0.27e2 * t5646 * t375 + 0.5e2 / 0.27e2 * t5654 * t2471;
  t7770 = t750 * t117 * t274;
  t7773 = t666 * t3008;
  t7776 = t666 * t3010;
  t7779 = t666 * t3012;
  t7782 = t666 * t3022;
  t7791 = 0.5e2 / 0.27e2 * t1662 * t1145 * t661 * t459 - 0.125e4 / 0.243e3 * t659 * t7210 * t1119 + 0.25e2 / 0.54e2 * t4749 * t1129 * t4750 + 0.125e4 / 0.729e3 * t1773 * t750 * t1118 * t711 - 0.125e4 / 0.243e3 * t2176 * t750 * t1118 * t684 + 0.5e2 / 0.27e2 * t5520 * t1124 + 0.1e3 / 0.27e2 * t5528 * t1124 + 0.1e3 / 0.27e2 * t1782 * t3049 - 0.25e4 / 0.243e3 * t658 * t299 * t1118 * t7770 + 0.1e3 / 0.27e2 * t7773 * t276 + 0.1e3 / 0.27e2 * t7776 * t276 + 0.1e3 / 0.27e2 * t7779 * t276 + 0.1e3 / 0.27e2 * t7782 * t276 - 0.25e2 / 0.108e3 * t6224 * t337 - 0.25e2 / 0.54e2 * t6227 * t337 - 0.25e2 / 0.54e2 * t2500 * t849;
  t7829 = -0.25e2 / 0.108e3 * t6230 * t337 - 0.25e4 / 0.729e3 * t4714 * t750 * t1118 * t692 + 0.1e3 / 0.81e2 * t2500 * t853 + 0.1e3 / 0.81e2 * t2503 * t853 + 0.1e3 / 0.81e2 * t972 * t2169 + 0.5e2 / 0.27e2 * t5538 * t1124 + 0.1e3 / 0.27e2 * t2203 * t3049 + 0.5e2 / 0.27e2 * t668 * t459 * t114 * t2091 + 0.1e3 / 0.27e2 * t7007 * t963 + 0.1e3 / 0.27e2 * t7011 * t963 + 0.5e2 / 0.27e2 * t2222 * t2497 + 0.2e5 / 0.729e3 * t6970 * t959 + 0.1e5 / 0.729e3 * t2786 * t2489 - 0.25e2 / 0.54e2 * t2503 * t849 - 0.25e2 / 0.108e3 * t972 * t2156 + 0.5e2 / 0.27e2 * t3030 * t686;
  t7830 = t1772 * t1138;
  t7835 = t1772 * t1146;
  t7885 = -0.1e5 / 0.729e3 * t7830 * t663 + 0.5e2 / 0.27e2 * t3033 * t686 - 0.1e5 / 0.729e3 * t7835 * t663 + 0.25e4 / 0.729e3 * t4706 * t3037 - 0.55e3 / 0.243e3 * t972 * t2173 - 0.1e3 / 0.27e2 * t2414 * t2146 - 0.1e3 / 0.27e2 * t7047 * t2479 + 0.1e5 / 0.243e3 * t7052 * t2475 - t281 * t141 * (-0.125e3 / 0.162e3 * t6884 * t1118 + 0.1625e4 / 0.243e3 * t2695 - 0.13e5 / 0.729e3 * t2697 - 0.3125e6 / 0.6561e4 * t4566 * t1142 * t661 + 0.8125e7 / 0.59049e5 * t2700 - 0.3125e6 / 0.19683e5 * t1729 * t1142 * t684 - 0.1625e8 / 0.177147e6 * t2703) - t281 * t2123 * t383 - 0.2e1 * t281 * t886 * t987 - t281 * t350 * t2444 - t281 * t722 * t1145 - 0.2e1 * t281 * t299 * t3021 + 0.125e6 / 0.19683e5 * t7157 * t2987 - 0.25e2 / 0.18e2 * t6257 * t269 * t336 * t692 - 0.2e3 / 0.81e2 * t2414 * t269 * t852 * t290;
  t7898 = t1766 * t1138;
  t7928 = t1766 * t1146;
  t7933 = 0.1e3 / 0.9e1 * t5584 * t459 * t1123 * t692 - 0.2e3 / 0.27e2 * t6291 * t2959 - 0.2e3 / 0.27e2 * t6294 * t2959 - 0.2e3 / 0.27e2 * t2414 * t7138 - 0.2e3 / 0.27e2 * t7898 * t2062 + 0.25e2 / 0.27e2 * t2414 * t848 * t2948 + 0.125e4 / 0.243e3 * t2484 * t7210 * t2952 * t117 - 0.2e5 / 0.729e3 * t1773 * t750 * t3048 * t274 - 0.2e5 / 0.729e3 * t5576 * t2418 - 0.1e3 / 0.27e2 * t1767 * t459 * t1123 * t711 + 0.25e4 / 0.243e3 * t4694 * t750 * t3036 * t274 - 0.2e3 / 0.27e2 * t5488 * t2963 - 0.2e5 / 0.729e3 * t4706 * t2967 - 0.2e3 / 0.27e2 * t5491 * t2963 - 0.2e3 / 0.27e2 * t7928 * t2062 + 0.25e2 / 0.27e2 * t6291 * t2949;
  t7992 = 0.25e4 / 0.729e3 * t6243 * t2954 + 0.25e2 / 0.27e2 * t6294 * t2949 + 0.25e4 / 0.729e3 * t6246 * t2954 - 0.1e3 / 0.27e2 * t2414 * t2957 * t459 * t684 + 0.2e5 / 0.729e3 * t6266 * t345 * t118 * t750 * t661 - 0.1e5 / 0.729e3 * t1773 * t750 * t1123 * t684 + 0.25e2 / 0.54e2 * t2414 * t269 * t336 * t711 - 0.2e5 / 0.2187e4 * t2484 * t660 * t450 * t263 * t274 + 0.125e4 / 0.729e3 * t2484 * t660 * t2952 * t684 - 0.1e5 / 0.243e3 * t7106 * t750 * t1123 * t117 - 0.2e3 / 0.27e2 * t1767 * t459 * t3048 * t290 - 0.6e1 * t1747 * t1138 * t692 - 0.6e1 * t1747 * t1146 * t692 + 0.4e1 * t691 * t3022 * t290 + 0.2e1 * t691 * t1146 * t711 + 0.2e1 * t691 * t384 * t2091 + 0.4e1 * t691 * t3008 * t290;
  t8025 = t4713 * t384 * t118;
  t8033 = 0.4e1 * t691 * t3010 * t290 + 0.2e1 * t691 * t1138 * t711 + 0.4e1 * t691 * t3012 * t290 + 0.2e1 * t691 * t2424 * t345 + 0.4e1 * t691 * t2426 * t345 + 0.4e1 * t691 * t978 * t874 + 0.2e1 * t691 * t2445 * t345 + 0.4e1 * t691 * t988 * t874 - 0.325e3 / 0.162e3 * t2733 + 0.13e4 / 0.243e3 * t2735 - 0.325e7 / 0.59049e5 * t2739 + 0.4e5 / 0.729e3 * t7196 * t6188 * t7197 - 0.5e4 / 0.729e3 * t8025 * t2057 + 0.2e3 / 0.9e1 * t4723 * t1135 * t2062 + 0.5e3 / 0.81e2 * t2742 + 0.325e3 / 0.162e3 * t2746;
  t8040 = t4540 * t141;
  t8062 = -0.26e6 / 0.6561e4 * t2753 - 0.2e4 / 0.243e3 * t2755 + 0.325e5 / 0.2187e4 * t2757 + 0.5e3 / 0.81e2 * t2759 + 0.25e6 / 0.6561e4 * t7165 * t2987 + 0.24e2 * t8040 * t2993 * t692 - 0.12e2 * t2992 * t383 * t874 * t290 - 0.6e1 * t2992 * t2993 * t711 - 0.1e7 / 0.19683e5 * t2138 * t7173 * t114 - 0.325e5 / 0.2187e4 * t2769 + 0.325e5 / 0.729e3 * t2773 - 0.5e3 / 0.81e2 * t2775 - 0.5e3 / 0.81e2 * t2777 - 0.5e3 / 0.81e2 * t2781 - 0.5e3 / 0.81e2 * t2783 - 0.1e6 / 0.2187e4 * t2787 + 0.2e4 / 0.243e3 * t2794;
  t8070 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t1148 - t7674 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t3059 + t7652 - t7681 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * (t7742 + t7791 + t7829 + t7885 + t7933 + t7992 + t8033 + t8062));
  tv4rho2sigmatau17 = t7 * t8070 + 0.2e1 * t3064;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t8077 = t6 * t412 * t1179;
  t8084 = t6 * t421 * t1179 / 0.12e2;
  t8086 = t6 * t162 * t3141;
  t8138 = t930 * t930;
  t8148 = 0.2e1 * t482 * t513 * t1167 - t192 * t513 * t1176 - 0.2e1 * t192 * t210 * t3137 - t192 * t83 * (0.5e3 / 0.81e2 * t6728 * t1154 - 0.1e5 / 0.243e3 * t2814 + 0.65e5 / 0.729e3 * t1022 + 0.25e7 / 0.6561e4 * t3922 * t1173 * t451 - 0.5e8 / 0.59049e5 * t2818 + 0.25e7 / 0.19683e5 * t1380 * t1173 * t475 + 0.8125e8 / 0.177147e6 * t1025) + 0.2e4 / 0.81e2 * t2837 + 0.2e6 / 0.2187e4 * t2842 + 0.2e7 / 0.19683e5 * t2584 * t3837 * t3075 + 0.1e5 / 0.729e3 * t3874 * t1156 + 0.2e7 / 0.19683e5 * t1929 * t3837 * t1159 + 0.1e3 / 0.27e2 * t3855 * t3104 - 0.1e3 / 0.27e2 * t3866 * t1163 * t3867 - 0.1e3 / 0.27e2 * t3866 * t1167 * t451 * t459 + 0.5e2 / 0.27e2 * t1321 * t1176 * t451 * t459 + 0.1e5 / 0.243e3 * t447 * t6432 * t1155 + 0.13e7 / 0.6561e4 * t1005 + 0.4e1 * t482 * t83 * t8138 - 0.1e5 / 0.729e3 * t1275 * t750 * t1154 * t502 + 0.2e5 / 0.243e3 * t7391 * t3082;
  t8171 = t1268 * t3116;
  t8176 = t3974 * t1168;
  t8179 = t456 * t3128;
  t8182 = t456 * t3138;
  t8187 = t1274 * t1177;
  t8204 = 0.1e5 / 0.243e3 * t1942 * t750 * t1154 * t475 + 0.1e3 / 0.27e2 * t5074 * t1160 + 0.2e3 / 0.27e2 * t5082 * t1160 + 0.2e3 / 0.27e2 * t1285 * t3100 + 0.2e5 / 0.729e3 * t3975 * t750 * t1154 * t483 + 0.1e3 / 0.27e2 * t5092 * t1160 + 0.2e3 / 0.27e2 * t1965 * t3100 + 0.1e3 / 0.27e2 * t458 * t459 * t49 * t2277 - 0.2e3 / 0.27e2 * t8171 * t187 - 0.1e3 / 0.27e2 * t3110 * t477 + 0.2e5 / 0.729e3 * t8176 * t453 + 0.1e3 / 0.27e2 * t8179 * t187 + 0.1e3 / 0.27e2 * t8182 * t187 + 0.5e2 / 0.27e2 * t3122 * t477 - 0.1e5 / 0.729e3 * t8187 * t453 - 0.2e5 / 0.729e3 * t3958 * t3076 + 0.2e3 / 0.9e1 * t5033 * t459 * t1159 * t483 - 0.2e5 / 0.243e3 * t3961 * t750 * t3075 * t185 - 0.2e5 / 0.243e3 * t3961 * t750 * t1159 * t451;
  t8206 = t4004 * t1168;
  t8213 = t1268 * t1177;
  t8262 = 0.2e3 / 0.9e1 * t8206 * t1820 - 0.4e3 / 0.27e2 * t2252 * t180 * t186 * t930 - 0.2e3 / 0.27e2 * t8213 * t1820 - 0.4e5 / 0.729e3 * t3958 * t3087 - 0.4e5 / 0.729e3 * t1275 * t750 * t3099 * t185 - 0.2e5 / 0.729e3 * t1275 * t750 * t1159 * t475 - 0.4e3 / 0.27e2 * t5113 * t3091 - 0.4e3 / 0.27e2 * t5116 * t3091 - 0.4e3 / 0.27e2 * t1269 * t459 * t3099 * t201 - 0.2e3 / 0.27e2 * t1269 * t459 * t1159 * t502 - 0.6e1 * t1395 * t1177 * t483 + 0.24e2 * t3898 * t1168 * t483 + 0.4e1 * t482 * t367 * t2277 + 0.4e1 * t482 * t3128 * t201 + 0.4e1 * t482 * t3138 * t201 + 0.2e1 * t482 * t1177 * t502 - 0.12e2 * t1395 * t3116 * t201 - 0.6e1 * t1395 * t1168 * t502;
  t8297 = 0.8e1 * t482 * t921 * t930 + 0.8e5 / 0.729e3 * t6441 * t5952 * t366 * t185 * t201 + 0.2e8 / 0.59049e5 * t2867 + 0.1e4 / 0.81e2 * t2869 - 0.1e4 / 0.81e2 * t2878 - 0.2e6 / 0.2187e4 * t2880 - 0.24e2 * t2872 * t6013 * t930 - 0.1e7 / 0.19683e5 * t6708 * t3072 - 0.2e7 / 0.19683e5 * t2584 * t4992 * t1154 - 0.2e7 / 0.6561e4 * t6698 * t3072 - 0.65e4 / 0.243e3 * t1013 - 0.5e2 / 0.27e2 * t1296 * t1164 + 0.5e2 / 0.27e2 * t1321 * t1163 * t3880 - 0.1e4 / 0.81e2 * t2899 - 0.1e4 / 0.81e2 * t2901 - 0.1e4 / 0.81e2 * t2903 + 0.2e6 / 0.2187e4 * t2913 - 0.2e6 / 0.729e3 * t2917 + 0.4e4 / 0.243e3 * t2919;
  t8304 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t408 * t1179 - t8077 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t156 * t3141 + t8084 - t8086 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t8148 + t8204 + t8262 + t8297));
  tv4rho2tau20 = t7 * t8304 + 0.2e1 * t3146;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t8311 = t6 * t538 * t1210;
  t8315 = t6 * t542 * t1210 / 0.12e2;
  t8317 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t534 * t1210 - t8311 / 0.4e1 + t8315);
  tv4rho2tau22 = t7 * t8317 + 0.2e1 * t3155;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t8323 = t6 * t563 * t1179;
  t8331 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t559 * t1179 - t8323 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t241 * t3141 - t8077 / 0.8e1 + t8084 - t8086 / 0.8e1);
  tv4rho2tau23 = t7 * t8331 + t3146 + t3161;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t8337 = t6 * t587 * t1210;
  t8344 = t6 * t228 * t3235;
  t8347 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t583 * t1210 - t8337 / 0.8e1 - t8311 / 0.8e1 + t8315 - 0.3e1 / 0.8e1 * t6 * t224 * t3235 - t8344 / 0.8e1);
  tv4rho2tau25 = t7 * t8347 + t3155 + t3240;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t8355 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t614 * t1179 - t8323 / 0.4e1 + t8084);
  tv4rho2tau26 = t7 * t8355 + 0.2e1 * t3161;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t8366 = t987 * t987;
  t8412 = t1766 * t3210;
  t8417 = t4713 * t1199;
  t8420 = t666 * t3222;
  t8423 = 0.4e1 * t691 * t141 * t8366 - t281 * t141 * (0.5e3 / 0.81e2 * t6884 * t1185 - 0.1e5 / 0.243e3 * t3014 + 0.65e5 / 0.729e3 * t1064 + 0.25e7 / 0.6561e4 * t4566 * t1204 * t661 - 0.5e8 / 0.59049e5 * t3018 + 0.25e7 / 0.19683e5 * t1729 * t1204 * t684 + 0.8125e8 / 0.177147e6 * t1067) + 0.2e1 * t691 * t722 * t1198 - t281 * t722 * t1207 - 0.2e1 * t281 * t299 * t3231 + 0.2e4 / 0.81e2 * t2950 + 0.2e6 / 0.2187e4 * t2955 + 0.13e7 / 0.6561e4 * t1047 + 0.2e3 / 0.27e2 * t5528 * t1191 + 0.2e3 / 0.27e2 * t1782 * t3194 + 0.1e3 / 0.27e2 * t5538 * t1191 + 0.2e3 / 0.27e2 * t2203 * t3194 + 0.1e3 / 0.27e2 * t668 * t459 * t114 * t2444 + 0.2e5 / 0.729e3 * t4714 * t750 * t1185 * t692 - 0.2e3 / 0.27e2 * t8412 * t276 - 0.1e3 / 0.27e2 * t3204 * t686 + 0.2e5 / 0.729e3 * t8417 * t663 + 0.1e3 / 0.27e2 * t8420 * t276;
  t8424 = t666 * t3232;
  t8429 = t1772 * t1208;
  t8457 = t4723 * t1199;
  t8464 = t1766 * t1208;
  t8483 = 0.1e3 / 0.27e2 * t8424 * t276 + 0.5e2 / 0.27e2 * t3216 * t686 - 0.1e5 / 0.729e3 * t8429 * t663 - 0.2e5 / 0.729e3 * t4706 * t3170 - 0.1e5 / 0.729e3 * t1773 * t750 * t1185 * t711 + 0.2e5 / 0.243e3 * t6216 * t3176 + 0.1e5 / 0.243e3 * t2176 * t750 * t1185 * t684 + 0.1e3 / 0.27e2 * t5520 * t1191 + 0.24e2 * t4540 * t1199 * t692 - 0.2e5 / 0.243e3 * t4694 * t750 * t1190 * t661 + 0.2e3 / 0.9e1 * t5584 * t459 * t1190 * t692 + 0.2e3 / 0.9e1 * t8457 * t2062 - 0.4e3 / 0.27e2 * t2414 * t269 * t275 * t987 - 0.2e3 / 0.27e2 * t8464 * t2062 - 0.4e3 / 0.27e2 * t5488 * t3185 - 0.4e3 / 0.27e2 * t5491 * t3185 - 0.4e3 / 0.27e2 * t1767 * t459 * t3193 * t290 - 0.2e3 / 0.27e2 * t1767 * t459 * t1190 * t711 - 0.2e5 / 0.243e3 * t4694 * t750 * t3169 * t274;
  t8533 = t383 * t290;
  t8537 = -0.4e5 / 0.729e3 * t4706 * t3181 - 0.4e5 / 0.729e3 * t1773 * t750 * t3193 * t274 - 0.2e5 / 0.729e3 * t1773 * t750 * t1190 * t684 + 0.4e1 * t691 * t3222 * t290 + 0.4e1 * t691 * t3232 * t290 + 0.2e1 * t691 * t1208 * t711 - 0.6e1 * t1747 * t1208 * t692 - 0.12e2 * t1747 * t3210 * t290 - 0.6e1 * t1747 * t1199 * t711 + 0.8e1 * t691 * t978 * t987 + 0.4e1 * t691 * t384 * t2444 + 0.8e5 / 0.729e3 * t7196 * t6188 * t383 * t274 * t290 + 0.2e8 / 0.59049e5 * t2988 + 0.1e4 / 0.81e2 * t2990 - 0.1e7 / 0.19683e5 * t7157 * t3166 - 0.2e7 / 0.19683e5 * t2737 * t5421 * t1185 - 0.5e2 / 0.27e2 * t1667 * t1195 - 0.24e2 * t2992 * t8533 * t987;
  t8576 = -0.2e7 / 0.6561e4 * t7165 * t3166 - 0.1e4 / 0.81e2 * t3002 - 0.2e6 / 0.2187e4 * t3005 + 0.2e7 / 0.19683e5 * t2737 * t4652 * t3169 + 0.1e5 / 0.729e3 * t4736 * t1187 + 0.2e7 / 0.19683e5 * t2138 * t4652 * t1190 + 0.1e3 / 0.27e2 * t4740 * t3198 + 0.5e2 / 0.27e2 * t1662 * t1194 * t4770 - 0.1e3 / 0.27e2 * t4749 * t1194 * t4750 - 0.1e3 / 0.27e2 * t4749 * t1198 * t661 * t459 + 0.5e2 / 0.27e2 * t1662 * t1207 * t661 * t459 + 0.1e5 / 0.243e3 * t659 * t7210 * t1186 - 0.65e4 / 0.243e3 * t1055 - 0.1e4 / 0.81e2 * t3024 - 0.1e4 / 0.81e2 * t3026 - 0.1e4 / 0.81e2 * t3028 + 0.2e6 / 0.2187e4 * t3038 - 0.2e6 / 0.729e3 * t3042 + 0.4e4 / 0.243e3 * t3056;
  t8583 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t631 * t1210 - t8337 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t252 * t3235 + t8315 - t8344 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * (t8423 + t8483 + t8537 + t8576));
  tv4rho2tau28 = t7 * t8583 + 0.2e1 * t3240;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t8590 = t6 * t162 * t3305 / 0.8e1;
  t8624 = 0.125e3 / 0.3188646e7 * t1351 * t2557;
  t8647 = -0.3e1 * t192 * t326 * t2536 - t192 * t210 * t3276 - t192 * t83 * (0.125e3 / 0.1296e4 * t2557 - 0.78125e5 / 0.104976e6 * t3922 * t3273 * t185 + 0.78125e5 / 0.39366e5 * t1380 * t72 * t2556) - t192 * t3247 * t201 - 0.6e1 * t1395 * t210 * t3255 + 0.6e1 * t482 * t799 * t1015 - 0.3e1 * t192 * t2568 * t321 - 0.3e1 * t192 * t1032 * t787 - 0.3e1 * t192 * t799 * t1027 - t8624 - 0.625e3 / 0.972e3 * t1275 * t750 * t999 * t787 - 0.25e2 / 0.18e2 * t6499 * t1008 - 0.25e2 / 0.18e2 * t6503 * t1008 - 0.25e2 / 0.18e2 * t1984 * t2619 - 0.25e2 / 0.36e2 * t1285 * t3286 - 0.25e2 / 0.36e2 * t1965 * t3286 - 0.25e2 / 0.36e2 * t458 * t459 * t39 * t2536 + 0.25e2 / 0.18e2 * t5113 * t3290 + 0.25e2 / 0.18e2 * t5116 * t3290;
  t8658 = t4004 * t3256;
  t8677 = t459 * t6442;
  t8681 = t456 * t1032 * t52;
  t8685 = t446 * t1032 * t53;
  t8688 = t1268 * t3263;
  t8691 = t456 * t3266;
  t8694 = t456 * t3269;
  t8697 = t456 * t3277;
  t8714 = -0.625e3 / 0.972e3 * t5136 * t2642 + 0.625e3 / 0.7776e4 * t3961 * t750 * t3242 * t201 + 0.625e3 / 0.324e3 * t446 * t326 * t999 * t6529 + 0.1e3 / 0.9e1 * t8658 * t187 + 0.25e4 / 0.729e3 * t1275 * t750 * t740 * t321 + 0.1e3 / 0.27e2 * t1984 * t2611 + 0.5e2 / 0.27e2 * t458 * t459 * t174 * t1027 - 0.1e3 / 0.27e2 * t1269 * t459 * t174 * t1015 - 0.25e2 / 0.144e3 * t1268 * t83 * t999 * t8677 - 0.25e2 / 0.36e2 * t8681 * t756 - 0.125e4 / 0.243e3 * t8685 * t752 - 0.1e3 / 0.9e1 * t8688 * t187 + 0.5e2 / 0.9e1 * t8691 * t187 + 0.5e2 / 0.9e1 * t8694 * t187 + 0.5e2 / 0.27e2 * t8697 * t187 - 0.625e3 / 0.972e3 * t3958 * t3280 + 0.2e1 * t482 * t3277 * t201 + 0.12e2 * t482 * t1019 * t787 + 0.6e1 * t482 * t3266 * t201 + 0.6e1 * t482 * t3269 * t201;
  t8773 = t1027 * t52;
  t8774 = t8773 * t2845;
  t8780 = 0.1e1 / t37 / t1336 * t29 * t171;
  t8786 = 0.625e3 / 0.2324522934e10 * t3822 * t8780;
  t8791 = -0.18e2 * t1395 * t1016 * t787 + 0.6e1 * t482 * t775 * t1027 + 0.6e1 * t482 * t788 * t1027 + 0.6e1 * t482 * t322 * t2536 - 0.18e2 * t1395 * t3263 * t201 - 0.15625e5 / 0.19683e5 * t1360 * t2556 * t76 * t83 + 0.15625e5 / 0.157464e6 * t1360 * t3251 * t210 + 0.24e2 * t3898 * t3256 * t201 + 0.25e2 / 0.9e1 * t1269 * t459 * t1007 * t787 - 0.25e4 / 0.243e3 * t3975 * t750 * t3289 * t185 + 0.625e3 / 0.486e3 * t3975 * t750 * t3279 * t201 - 0.625e3 / 0.324e3 * t3961 * t750 * t3279 * t185 + 0.25e2 / 0.9e1 * t6570 * t2548 + 0.25e4 / 0.243e3 * t5136 * t2552 + 0.25e2 / 0.18e2 * t1269 * t459 * t3285 * t201 + 0.125e4 / 0.243e3 * t1275 * t750 * t3285 * t185 - 0.25e2 / 0.6e1 * t5033 * t459 * t3289 * t201 - 0.1e3 / 0.9e1 * t1818 * t8774 + t77 * (0.625e3 / 0.2324522934e10 * t3795 * t8780 - 0.125e3 / 0.3188646e7 * t1332 * t2557 - t8786 + t8624) + 0.25e2 / 0.54e2 * t790 * t2561;
  t8798 = t1930 * t185;
  t8801 = t1360 * t3242;
  t8810 = t57 * t787;
  t8818 = t178 * t3247;
  t8836 = t185 * t29;
  t8845 = -0.15625e5 / 0.6561e4 * t2584 * t6716 * t999 - 0.25e2 / 0.288e3 * t1835 * t1000 + 0.15625e5 / 0.26244e5 * t4026 * t3242 * t8798 - 0.15625e5 / 0.157464e6 * t8801 * t3838 - 0.18e2 * t2872 * t321 * t1027 * t201 + 0.25e2 / 0.288e3 * t3855 * t3300 + 0.25e2 / 0.288e3 * t1321 * t2597 * t8810 + 0.25e2 / 0.36e2 * t6777 * t313 + 0.25e2 / 0.36e2 * t2601 * t762 - 0.5e2 / 0.27e2 * t8818 * t187 + 0.25e2 / 0.288e3 * t4953 * t2598 - 0.25e4 / 0.729e3 * t1840 * t2594 + 0.625e3 / 0.972e3 * t447 * t1315 * t450 * t2556 + 0.15625e5 / 0.6561e4 * t2584 * t3837 * t3279 + 0.625e3 / 0.972e3 * t4950 * t1004 - 0.625e3 / 0.7776e4 * t1327 * t3296 - 0.625e3 / 0.7776e4 * t447 * t8836 * t3295 + t8786 - 0.25e2 / 0.54e2 * t1321 * t6418 * t3299 - 0.5e2 / 0.27e2 * t2601 * t766;
  t8852 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t3305 - t8590 - 0.3e1 / 0.8e1 * t6 * t28 * (t8647 + t8714 + t8791 + t8845));
  tv4rhosigma30 = t7 * t8852 + t3309;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t8859 = t6 * t228 * t3373 / 0.8e1;
  t8861 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t3373 - t8859);
  tv4rhosigma39 = t7 * t8861 + t3377;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t8867 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t3305 - t8590);
  tv4rhosigma310 = t7 * t8867 + t3309;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t8873 = 0.125e3 / 0.3188646e7 * t1710 * t2673;
  t8906 = t1766 * t3325;
  t8909 = t666 * t3328;
  t8920 = t459 * t7153;
  t8924 = t666 * t1074 * t117;
  t8928 = t658 * t1074 * t118;
  t8931 = t666 * t3331;
  t8934 = t666 * t3339;
  t8937 = -t8873 - t281 * t141 * (0.125e3 / 0.1296e4 * t2673 - 0.78125e5 / 0.104976e6 * t4566 * t3335 * t274 + 0.78125e5 / 0.39366e5 * t1729 * t72 * t2672) - t281 * t3343 * t290 - 0.6e1 * t1747 * t299 * t3315 + 0.6e1 * t691 * t886 * t1057 - 0.3e1 * t281 * t2684 * t345 - 0.3e1 * t281 * t1074 * t874 - 0.3e1 * t281 * t886 * t1069 - 0.3e1 * t281 * t350 * t2705 - t281 * t299 * t3338 - 0.1e3 / 0.9e1 * t8906 * t276 + 0.5e2 / 0.9e1 * t8909 * t276 + 0.25e4 / 0.729e3 * t1773 * t750 * t828 * t345 + 0.1e3 / 0.27e2 * t2222 * t2793 - 0.25e2 / 0.144e3 * t1766 * t141 * t1041 * t8920 - 0.25e2 / 0.36e2 * t8924 * t843 - 0.125e4 / 0.243e3 * t8928 * t839 + 0.5e2 / 0.9e1 * t8931 * t276 + 0.5e2 / 0.27e2 * t8934 * t276;
  t8972 = t4723 * t3316;
  t8995 = t1069 * t117;
  t8996 = t8995 * t2958;
  t8999 = 0.625e3 / 0.324e3 * t658 * t350 * t1041 * t7770 - 0.625e3 / 0.972e3 * t4706 * t3348 - 0.625e3 / 0.972e3 * t1773 * t750 * t1041 * t874 - 0.25e2 / 0.18e2 * t7007 * t1050 - 0.25e2 / 0.18e2 * t7011 * t1050 - 0.25e2 / 0.18e2 * t2222 * t2780 - 0.25e2 / 0.36e2 * t1782 * t3354 - 0.25e2 / 0.36e2 * t2203 * t3354 - 0.25e2 / 0.36e2 * t668 * t459 * t104 * t2705 + 0.25e2 / 0.18e2 * t5488 * t3358 + 0.25e2 / 0.18e2 * t5491 * t3358 - 0.625e3 / 0.972e3 * t5576 * t2768 + 0.625e3 / 0.7776e4 * t4694 * t750 * t3310 * t290 + 0.1e3 / 0.9e1 * t8972 * t276 + 0.5e2 / 0.27e2 * t668 * t459 * t263 * t1069 - 0.1e3 / 0.27e2 * t1767 * t459 * t263 * t1057 - 0.25e2 / 0.6e1 * t5584 * t459 * t3357 * t290 + 0.25e2 / 0.9e1 * t1767 * t459 * t1049 * t874 - 0.25e4 / 0.243e3 * t4714 * t750 * t3357 * t274 - 0.1e3 / 0.9e1 * t2060 * t8996;
  t9023 = t57 * t874;
  t9031 = t267 * t3343;
  t9047 = t274 * t29;
  t9058 = 0.625e3 / 0.486e3 * t4714 * t750 * t3347 * t290 - 0.625e3 / 0.324e3 * t4694 * t750 * t3347 * t274 + 0.25e2 / 0.9e1 * t7047 * t2714 + 0.25e4 / 0.243e3 * t5576 * t2718 + 0.25e2 / 0.18e2 * t1767 * t459 * t3353 * t290 + 0.125e4 / 0.243e3 * t1773 * t750 * t3353 * t274 + 0.25e2 / 0.288e3 * t4740 * t3368 + 0.25e2 / 0.288e3 * t1662 * t2744 * t9023 + 0.25e2 / 0.36e2 * t7239 * t337 + 0.25e2 / 0.36e2 * t2748 * t849 - 0.5e2 / 0.27e2 * t9031 * t276 + 0.25e2 / 0.288e3 * t5654 * t2745 + 0.15625e5 / 0.6561e4 * t2737 * t4652 * t3347 + 0.625e3 / 0.972e3 * t5651 * t1046 - 0.5e2 / 0.27e2 * t2748 * t853 - 0.25e4 / 0.729e3 * t2164 * t2752 - 0.625e3 / 0.7776e4 * t1686 * t3364 - 0.625e3 / 0.7776e4 * t659 * t9047 * t3363 + 0.625e3 / 0.972e3 * t659 * t1656 * t450 * t2672 - 0.25e2 / 0.54e2 * t1662 * t7217 * t3367;
  t9062 = t2139 * t274;
  t9065 = t1759 * t3310;
  t9080 = 0.1e1 / t102 / t1695 * t29 * t260;
  t9082 = 0.625e3 / 0.2324522934e10 * t4626 * t9080;
  t9126 = 0.25e2 / 0.54e2 * t877 * t2677 + 0.15625e5 / 0.26244e5 * t4665 * t3310 * t9062 - 0.15625e5 / 0.157464e6 * t9065 * t4653 - 0.18e2 * t2992 * t345 * t1069 * t290 - 0.25e2 / 0.288e3 * t2159 * t1042 - 0.15625e5 / 0.6561e4 * t2737 * t7173 * t1041 + t9082 + 0.12e2 * t691 * t1061 * t874 + 0.6e1 * t691 * t3328 * t290 + 0.6e1 * t691 * t3331 * t290 + 0.6e1 * t691 * t862 * t1069 + 0.6e1 * t691 * t875 * t1069 + 0.6e1 * t691 * t346 * t2705 - 0.18e2 * t1747 * t3325 * t290 + 0.2e1 * t691 * t3339 * t290 + 0.15625e5 / 0.157464e6 * t1759 * t3311 * t299 + 0.24e2 * t4540 * t3316 * t290 - 0.18e2 * t1747 * t1058 * t874 - 0.15625e5 / 0.19683e5 * t1759 * t2672 * t134 * t141 + t135 * (0.625e3 / 0.2324522934e10 * t4601 * t9080 - 0.125e3 / 0.3188646e7 * t1691 * t2673 - t9082 + t8873);
  t9133 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t3373 - t8859 - 0.3e1 / 0.8e1 * t6 * t99 * (t8937 + t8999 + t9058 + t9126));
  tv4rhosigma319 = t7 * t9133 + t3377;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t9140 = t6 * t162 * t3451 / 0.8e1;
  t9179 = 0.109375e6 / 0.19683e5 * t3253 - 0.2e3 / 0.27e2 * t7471 * t2846 - 0.1e3 / 0.27e2 * t2252 * t8774 + 0.25e2 / 0.27e2 * t7468 * t2836 - 0.2e3 / 0.81e2 * t2252 * t180 * t765 * t321 - 0.1e5 / 0.729e3 * t1275 * t750 * t3423 * t185 + 0.25e2 / 0.27e2 * t5984 * t3428 + 0.25e2 / 0.27e2 * t5987 * t3428 + 0.25e2 / 0.27e2 * t2252 * t761 * t3427 + 0.25e2 / 0.27e2 * t2252 * t180 * t312 * t787 + 0.1e3 / 0.9e1 * t5033 * t459 * t3431 * t201 - 0.2e3 / 0.27e2 * t1269 * t459 * t1087 * t787 + 0.2e5 / 0.729e3 * t3975 * t750 * t3431 * t185;
  t9204 = t1015 * t52;
  t9222 = 0.25e4 / 0.729e3 * t7335 * t2841 + 0.25e2 / 0.27e2 * t7471 * t2836 + 0.25e4 / 0.729e3 * t7340 * t2841 + 0.625e3 / 0.1458e4 * t6000 * t448 * t1003 * t201 - 0.625e3 / 0.972e3 * t2341 * t1315 * t1003 * t185 - 0.5e4 / 0.729e3 * t3975 * t750 * t3417 * t201 + 0.25e4 / 0.243e3 * t3961 * t750 * t3417 * t185 - 0.2e3 / 0.27e2 * t6570 * t2828 + 0.1e3 / 0.9e1 * t5980 * t9204 * t2845 - 0.2e3 / 0.27e2 * t7468 * t2846 - 0.2e5 / 0.729e3 * t5136 * t2832 - 0.1e3 / 0.27e2 * t1269 * t459 * t3423 * t201 - 0.25e2 / 0.9e1 * t4004 * t367 * t52 * t2548 - 0.5e4 / 0.729e3 * t7582 * t2552;
  t9259 = 0.15625e5 / 0.19683e5 * t2584 * t3837 * t3435 - 0.25e6 / 0.19683e5 * t2584 * t3837 * t3417 + 0.25e2 / 0.864e3 * t3855 * t3436 + 0.25e2 / 0.864e3 * t1321 * t930 * t999 * t459 - 0.25e4 / 0.729e3 * t4950 * t1084 + 0.625e3 / 0.972e3 * t1327 * t3442 + 0.625e3 / 0.972e3 * t447 * t8836 * t3441 - 0.25e2 / 0.54e2 * t3855 * t3445 - 0.25e2 / 0.54e2 * t1321 * t1093 * t8810 - 0.25e2 / 0.162e3 * t1321 * t366 * t740 * t459 - 0.5e2 / 0.27e2 * t6777 * t358 - 0.5e2 / 0.27e2 * t2601 * t911 - 0.25e2 / 0.54e2 * t4953 * t2877 - 0.4375e4 / 0.972e3 * t3297;
  t9276 = t1360 * t3383;
  t9296 = 0.325e3 / 0.162e3 * t3301 + 0.25e3 / 0.81e2 * t3303 + 0.325e5 / 0.2187e4 * t3293 - 0.325e3 / 0.162e3 * t3249 + 0.25e2 / 0.54e2 * t1835 * t1094 + 0.24e2 * t7537 * t366 * t1015 * t201 - 0.12e2 * t2872 * t2873 * t787 - 0.3125e5 / 0.6561e4 * t4026 * t3383 * t8798 + 0.15625e5 / 0.19683e5 * t9276 * t3838 - 0.12e2 * t1395 * t326 * t2874 - 0.12e2 * t2872 * t1109 * t321 * t201 - 0.6e1 * t2872 * t366 * t1027 * t201 + 0.25e6 / 0.19683e5 * t2584 * t6716 * t1082 + 0.4e1 * t482 * t1110 * t787;
  t9338 = 0.4e1 * t482 * t2824 * t321 + 0.4e1 * t482 * t2810 * t321 + 0.4e1 * t482 * t1102 * t787 + 0.4e1 * t482 * t2812 * t321 + 0.4e1 * t482 * t2822 * t321 + 0.2e1 * t482 * t3406 * t201 + 0.2e1 * t482 * t3408 * t201 - 0.6e1 * t1395 * t921 * t1015 - 0.6e1 * t1395 * t931 * t1015 - 0.15625e5 / 0.19683e5 * t1360 * t3384 * t210 + 0.2e1 * t482 * t921 * t1027 + 0.2e1 * t482 * t931 * t1027 + 0.2e1 * t482 * t367 * t2536;
  t9353 = t1268 * t83 * t1082;
  t9368 = 0.4e1 * t482 * t3397 * t201 - 0.325e5 / 0.2187e4 * t3281 - 0.5e3 / 0.81e2 * t3283 - 0.25e3 / 0.81e2 * t3287 + 0.5e3 / 0.81e2 * t3291 + 0.25e4 / 0.729e3 * t5136 * t2912 - 0.625e3 / 0.972e3 * t3961 * t750 * t3383 * t201 + 0.25e2 / 0.27e2 * t9353 * t8677 + 0.5e2 / 0.27e2 * t8681 * t906 + 0.1e5 / 0.729e3 * t8685 * t902 - 0.25e2 / 0.54e2 * t7345 * t313 - 0.25e2 / 0.54e2 * t7348 * t313 - 0.25e2 / 0.54e2 * t2905 * t762 - 0.25e2 / 0.54e2 * t7351 * t313;
  t9402 = -0.25e2 / 0.54e2 * t7354 * t313 - 0.25e2 / 0.54e2 * t2908 * t762 - 0.625e3 / 0.2916e4 * t5930 * t1004 - 0.625e3 / 0.2916e4 * t5873 * t1004 + 0.25e4 / 0.729e3 * t3958 * t3418 + 0.25e4 / 0.729e3 * t1275 * t750 * t1082 * t787 + 0.1e3 / 0.27e2 * t6499 * t1088 + 0.1e3 / 0.27e2 * t6503 * t1088 + 0.1e3 / 0.27e2 * t1984 * t2892 + 0.5e2 / 0.27e2 * t1285 * t3424 + 0.5e2 / 0.27e2 * t1965 * t3424 + 0.5e2 / 0.27e2 * t458 * t459 * t49 * t2536 - 0.1e3 / 0.27e2 * t5113 * t3432 - 0.1e3 / 0.27e2 * t5116 * t3432;
  t9409 = t456 * t3397;
  t9412 = t456 * t3406;
  t9415 = t456 * t3408;
  t9444 = -0.25e2 / 0.432e3 * t2252 * t2598 - 0.25e4 / 0.243e3 * t446 * t326 * t1082 * t6529 + 0.1e3 / 0.27e2 * t9409 * t187 + 0.5e2 / 0.27e2 * t9412 * t187 + 0.5e2 / 0.27e2 * t9415 * t187 + 0.1e3 / 0.81e2 * t2905 * t766 + 0.1e3 / 0.81e2 * t2908 * t766 + 0.25e4 / 0.2187e4 * t2341 * t2594 - 0.2e1 * t192 * t799 * t1109 - 0.2e1 * t192 * t326 * t2821 - t192 * t210 * t3405 - t192 * t83 * (-0.875e3 / 0.1296e4 * t3243 + 0.78125e5 / 0.13122e5 * t3922 * t3402 * t185 - 0.546875e6 / 0.39366e5 * t3274) - t192 * t2568 * t366 - t192 * t1032 * t930;
  t9452 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t3451 - t9140 - 0.3e1 / 0.8e1 * t6 * t28 * (t9179 + t9222 + t9259 + t9296 + t9338 + t9368 + t9402 + t9444));
  tv4rhosigma2tau0 = t7 * t9452 + t3455;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t9459 = t6 * t228 * t3529 / 0.8e1;
  t9461 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t3529 - t9459);
  tv4rhosigma2tau11 = t7 * t9461 + t3533;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t9467 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t3451 - t9140);
  tv4rhosigma2tau12 = t7 * t9467 + t3455;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t9512 = 0.109375e6 / 0.19683e5 * t3313 - 0.2e3 / 0.27e2 * t7047 * t2963 - 0.2e5 / 0.729e3 * t5576 * t2967 - 0.1e3 / 0.27e2 * t1767 * t459 * t3458 * t290 - 0.2e3 / 0.81e2 * t2414 * t269 * t852 * t345 + 0.1e3 / 0.9e1 * t5584 * t459 * t3472 * t290 - 0.2e3 / 0.27e2 * t1767 * t459 * t1123 * t874 + 0.2e5 / 0.729e3 * t4714 * t750 * t3472 * t274 + 0.25e2 / 0.27e2 * t6291 * t3477 + 0.25e2 / 0.27e2 * t6294 * t3477 + 0.25e2 / 0.27e2 * t2414 * t848 * t3476 + 0.25e2 / 0.27e2 * t2414 * t269 * t336 * t874 + 0.1e3 / 0.9e1 * t6257 * t1057 * t117 * t2958;
  t9553 = -0.2e3 / 0.27e2 * t7928 * t2959 - 0.1e3 / 0.27e2 * t2414 * t8996 - 0.2e3 / 0.27e2 * t7898 * t2959 - 0.1e5 / 0.729e3 * t1773 * t750 * t3458 * t274 + 0.25e2 / 0.27e2 * t7898 * t2949 + 0.25e4 / 0.729e3 * t7830 * t2954 + 0.25e2 / 0.27e2 * t7928 * t2949 + 0.25e4 / 0.729e3 * t7835 * t2954 + 0.625e3 / 0.1458e4 * t6266 * t660 * t1045 * t290 - 0.625e3 / 0.972e3 * t2484 * t1656 * t1045 * t274 - 0.5e4 / 0.729e3 * t4714 * t750 * t3468 * t290 + 0.25e4 / 0.243e3 * t4694 * t750 * t3468 * t274 + 0.25e2 / 0.864e3 * t4740 * t3525 + 0.25e2 / 0.864e3 * t1662 * t987 * t1041 * t459;
  t9592 = 0.15625e5 / 0.19683e5 * t2737 * t4652 * t3524 - 0.25e6 / 0.19683e5 * t2737 * t4652 * t3468 - 0.25e2 / 0.54e2 * t5654 * t3001 - 0.25e4 / 0.729e3 * t5651 * t1120 + 0.625e3 / 0.972e3 * t1686 * t3516 + 0.625e3 / 0.972e3 * t659 * t9047 * t3515 - 0.25e2 / 0.54e2 * t4740 * t3519 - 0.25e2 / 0.54e2 * t1662 * t1129 * t9023 - 0.5e2 / 0.27e2 * t7239 * t375 - 0.5e2 / 0.27e2 * t2748 * t968 - 0.25e2 / 0.162e3 * t1662 * t383 * t828 * t459 + 0.2e1 * t691 * t3500 * t290 + 0.4e1 * t691 * t3502 * t290 + 0.2e1 * t691 * t3511 * t290;
  t9629 = -0.25e2 / 0.9e1 * t4723 * t384 * t117 * t2714 - 0.5e4 / 0.729e3 * t8025 * t2718 + 0.325e5 / 0.2187e4 * t3361 - 0.4375e4 / 0.972e3 * t3365 + 0.325e3 / 0.162e3 * t3369 + 0.25e3 / 0.81e2 * t3371 - t281 * t2684 * t383 - t281 * t1074 * t987 - 0.2e1 * t281 * t886 * t1145 - 0.2e1 * t281 * t350 * t3021 - t281 * t299 * t3510 - t281 * t141 * (-0.875e3 / 0.1296e4 * t3322 + 0.78125e5 / 0.13122e5 * t4566 * t3507 * t274 - 0.546875e6 / 0.39366e5 * t3336) - 0.15625e5 / 0.19683e5 * t1759 * t3493 * t299 + 0.4e1 * t691 * t3008 * t345;
  t9669 = 0.4e1 * t691 * t3010 * t345 + 0.4e1 * t691 * t1138 * t874 - 0.6e1 * t1747 * t988 * t1057 + 0.4e1 * t691 * t3012 * t345 + 0.4e1 * t691 * t3022 * t345 + 0.4e1 * t691 * t1146 * t874 + 0.2e1 * t691 * t978 * t1069 + 0.2e1 * t691 * t988 * t1069 + 0.2e1 * t691 * t384 * t2705 - 0.6e1 * t1747 * t978 * t1057 - 0.325e3 / 0.162e3 * t3345 - 0.12e2 * t1747 * t350 * t2994 + 0.25e6 / 0.19683e5 * t2737 * t7173 * t1118;
  t9690 = t1759 * t3492;
  t9702 = t1766 * t141 * t1118;
  t9707 = 0.24e2 * t8040 * t383 * t1057 * t290 - 0.12e2 * t2992 * t2993 * t874 + 0.25e2 / 0.54e2 * t2159 * t1130 - 0.12e2 * t2992 * t1145 * t345 * t290 - 0.6e1 * t2992 * t383 * t1069 * t290 - 0.3125e5 / 0.6561e4 * t4665 * t3492 * t9062 + 0.15625e5 / 0.19683e5 * t9690 * t4653 - 0.325e5 / 0.2187e4 * t3349 - 0.5e3 / 0.81e2 * t3351 - 0.25e3 / 0.81e2 * t3355 + 0.5e3 / 0.81e2 * t3359 - 0.625e3 / 0.972e3 * t4694 * t750 * t3492 * t290 + 0.25e2 / 0.27e2 * t9702 * t8920 + 0.5e2 / 0.27e2 * t8924 * t963;
  t9739 = 0.1e5 / 0.729e3 * t8928 * t959 - 0.25e2 / 0.432e3 * t2414 * t2745 + 0.5e2 / 0.27e2 * t1782 * t3459 + 0.5e2 / 0.27e2 * t2203 * t3459 + 0.5e2 / 0.27e2 * t668 * t459 * t114 * t2705 - 0.25e2 / 0.54e2 * t7773 * t337 - 0.25e2 / 0.54e2 * t7776 * t337 - 0.25e2 / 0.54e2 * t3030 * t849 - 0.25e2 / 0.54e2 * t7779 * t337 - 0.25e2 / 0.54e2 * t7782 * t337 - 0.25e2 / 0.54e2 * t3033 * t849 - 0.625e3 / 0.2916e4 * t6243 * t1046 - 0.625e3 / 0.2916e4 * t6246 * t1046 + 0.25e4 / 0.729e3 * t4706 * t3469;
  t9752 = t666 * t3500;
  t9755 = t666 * t3502;
  t9758 = t666 * t3511;
  t9775 = 0.25e4 / 0.729e3 * t1773 * t750 * t1118 * t874 - 0.1e3 / 0.27e2 * t5488 * t3473 - 0.1e3 / 0.27e2 * t5491 * t3473 - 0.25e4 / 0.243e3 * t658 * t350 * t1118 * t7770 + 0.5e2 / 0.27e2 * t9752 * t276 + 0.1e3 / 0.27e2 * t9755 * t276 + 0.5e2 / 0.27e2 * t9758 * t276 + 0.25e4 / 0.729e3 * t5576 * t3037 + 0.1e3 / 0.27e2 * t7007 * t1124 + 0.1e3 / 0.27e2 * t7011 * t1124 + 0.1e3 / 0.27e2 * t2222 * t3049 + 0.1e3 / 0.81e2 * t3030 * t853 + 0.1e3 / 0.81e2 * t3033 * t853 + 0.25e4 / 0.2187e4 * t2484 * t2752;
  t9783 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t3529 - t9459 - 0.3e1 / 0.8e1 * t6 * t99 * (t9512 + t9553 + t9592 + t9629 + t9669 + t9707 + t9739 + t9775));
  tv4rhosigma2tau23 = t7 * t9783 + t3533;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t9790 = t6 * t162 * t3598 / 0.8e1;
  t9818 = -0.25e6 / 0.6561e4 * t3386 - 0.25e4 / 0.729e3 * t8176 * t2841 + 0.1e3 / 0.9e1 * t8206 * t2846 - 0.2e3 / 0.27e2 * t2252 * t1109 * t52 * t2845 + 0.25e2 / 0.54e2 * t8213 * t2836 + 0.125e4 / 0.729e3 * t8187 * t2841 - 0.1e3 / 0.27e2 * t8213 * t2846 - 0.5e4 / 0.729e3 * t3975 * t750 * t3549 * t201 + 0.25e4 / 0.243e3 * t3961 * t750 * t3549 * t185 - 0.2e3 / 0.27e2 * t5113 * t3554 - 0.2e3 / 0.27e2 * t5116 * t3554;
  t9857 = -0.2e3 / 0.27e2 * t1269 * t459 * t3099 * t321 - 0.2e3 / 0.27e2 * t1269 * t459 * t1159 * t787 - 0.2e3 / 0.27e2 * t6570 * t3091 - 0.2e5 / 0.729e3 * t5136 * t3087 - 0.2e3 / 0.27e2 * t1269 * t459 * t3563 * t201 + 0.2e5 / 0.729e3 * t3975 * t750 * t3539 * t201 - 0.1e5 / 0.243e3 * t3961 * t750 * t3539 * t185 - 0.2e5 / 0.729e3 * t1275 * t750 * t3563 * t185 - 0.25e2 / 0.18e2 * t8206 * t2836 + 0.25e2 / 0.27e2 * t2252 * t180 * t312 * t930 - t192 * t799 * t1176 - t192 * t326 * t3137;
  t9884 = t57 * t930;
  t9895 = -t192 * t210 * t3595 - t192 * t83 * (0.125e3 / 0.27e2 * t3400 - 0.3125e6 / 0.6561e4 * t3922 * t3592 * t185 + 0.625e6 / 0.6561e4 * t3403) + 0.2e1 * t482 * t799 * t1167 + 0.1e5 / 0.729e3 * t4950 * t1156 - 0.125e4 / 0.243e3 * t1327 * t3546 - 0.125e4 / 0.243e3 * t447 * t8836 * t3545 - 0.25e6 / 0.19683e5 * t2584 * t3837 * t3549 - 0.25e2 / 0.54e2 * t3855 * t3560 - 0.25e2 / 0.54e2 * t1321 * t1093 * t9884 + 0.5e2 / 0.27e2 * t3855 * t3567 + 0.5e2 / 0.27e2 * t1321 * t1163 * t8810 + 0.5e2 / 0.27e2 * t4953 * t3104;
  t9932 = 0.1e7 / 0.19683e5 * t2584 * t3837 * t3539 + 0.2e1 * t482 * t3128 * t321 + 0.2e1 * t482 * t3138 * t321 + 0.2e1 * t482 * t1177 * t787 + 0.2e1 * t482 * t3588 * t201 + 0.2e1 * t482 * t3596 * t201 - 0.6e1 * t1395 * t3577 * t201 + 0.4e1 * t482 * t1102 * t930 + 0.4e1 * t482 * t921 * t1109 + 0.4e1 * t482 * t931 * t1109 + 0.4e1 * t482 * t367 * t2821 + 0.125e6 / 0.19683e5 * t1360 * t3535 * t210;
  t9954 = t1360 * t3534;
  t9962 = -0.6e1 * t1395 * t3116 * t321 - 0.6e1 * t1395 * t1168 * t787 + 0.2e3 / 0.9e1 * t4004 * t457 * t54 * t357 * t2874 + 0.4e5 / 0.729e3 * t6441 * t5952 * t2873 * t185 + 0.325e3 / 0.162e3 * t3437 - 0.1e6 / 0.2187e4 * t3439 + 0.25e4 / 0.81e2 * t3443 - 0.5e3 / 0.81e2 * t3446 - 0.125e6 / 0.19683e5 * t9954 * t3838 - 0.1e7 / 0.19683e5 * t2584 * t6716 * t1154 - 0.5e2 / 0.27e2 * t1835 * t1164;
  t9987 = t1268 * t3577;
  t9990 = 0.24e2 * t7537 * t1167 * t321 * t201 - 0.12e2 * t2872 * t2873 * t930 - 0.12e2 * t2872 * t366 * t1109 * t201 - 0.6e1 * t2872 * t1176 * t321 * t201 + 0.25e6 / 0.6561e4 * t4026 * t3534 * t8798 + 0.5e3 / 0.81e2 * t3378 - 0.5e3 / 0.81e2 * t3410 - 0.5e3 / 0.81e2 * t3412 - 0.325e5 / 0.2187e4 * t3415 + 0.1e6 / 0.2187e4 * t3419 + 0.1e4 / 0.81e2 * t3429 - 0.1e3 / 0.27e2 * t9987 * t187;
  t9998 = t456 * t3588;
  t10001 = t456 * t3596;
  t10020 = -0.25e2 / 0.108e3 * t8179 * t313 - 0.25e2 / 0.108e3 * t8182 * t313 - 0.25e2 / 0.108e3 * t3122 * t762 + 0.5e2 / 0.27e2 * t9998 * t187 + 0.5e2 / 0.27e2 * t10001 * t187 - 0.1e3 / 0.81e2 * t3110 * t766 + 0.5e2 / 0.81e2 * t3122 * t766 + 0.25e4 / 0.729e3 * t3958 * t3550 + 0.25e4 / 0.729e3 * t1275 * t750 * t1082 * t930 + 0.1e3 / 0.27e2 * t6499 * t1160 + 0.1e3 / 0.27e2 * t6503 * t1160 + 0.1e3 / 0.27e2 * t1984 * t3100;
  t10021 = t459 * t6013;
  t10033 = t1268 * t83 * t1154;
  t10054 = 0.25e2 / 0.27e2 * t9353 * t10021 + 0.1e3 / 0.27e2 * t1285 * t3564 + 0.1e3 / 0.27e2 * t1965 * t3564 + 0.1e3 / 0.27e2 * t458 * t459 * t49 * t2821 - 0.1e3 / 0.27e2 * t10033 * t8677 + 0.25e2 / 0.54e2 * t8171 * t313 + 0.25e2 / 0.54e2 * t3110 * t762 - 0.1e5 / 0.729e3 * t3958 * t3540 - 0.1e5 / 0.729e3 * t1275 * t750 * t1154 * t787 - 0.1e5 / 0.729e3 * t5136 * t3076 + 0.1e5 / 0.243e3 * t6575 * t3082 + 0.125e4 / 0.243e3 * t3961 * t750 * t3534 * t201;
  t10062 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t3598 - t9790 - 0.3e1 / 0.8e1 * t6 * t28 * (t9818 + t9857 + t9895 + t9932 + t9962 + t9990 + t10020 + t10054));
  tv4rhosigmatau20 = t7 * t10062 + t3602;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t10069 = t6 * t228 * t3667 / 0.8e1;
  t10071 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t3667 - t10069);
  tv4rhosigmatau28 = t7 * t10071 + t3671;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t10077 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t3598 - t9790);
  tv4rhosigmatau29 = t7 * t10077 + t3602;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t10116 = 0.2e1 * t691 * t886 * t1198 - t281 * t886 * t1207 - t281 * t350 * t3231 - t281 * t299 * t3664 - t281 * t141 * (0.125e3 / 0.27e2 * t3505 - 0.3125e6 / 0.6561e4 * t4566 * t3661 * t274 + 0.625e6 / 0.6561e4 * t3508) - 0.25e6 / 0.6561e4 * t3495 - 0.5e4 / 0.729e3 * t4714 * t750 * t3618 * t290 + 0.25e4 / 0.243e3 * t4694 * t750 * t3618 * t274 - 0.25e2 / 0.18e2 * t8457 * t2949 + 0.25e2 / 0.27e2 * t2414 * t269 * t336 * t987 - 0.25e4 / 0.729e3 * t8417 * t2954;
  t10149 = 0.1e3 / 0.9e1 * t8457 * t2959 - 0.2e3 / 0.27e2 * t2414 * t1145 * t117 * t2958 + 0.25e2 / 0.54e2 * t8464 * t2949 + 0.125e4 / 0.729e3 * t8429 * t2954 - 0.1e3 / 0.27e2 * t8464 * t2959 - 0.2e3 / 0.27e2 * t5488 * t3623 - 0.2e3 / 0.27e2 * t5491 * t3623 - 0.2e3 / 0.27e2 * t1767 * t459 * t3193 * t345 - 0.2e3 / 0.27e2 * t1767 * t459 * t1190 * t874 - 0.2e3 / 0.27e2 * t7047 * t3185 - 0.2e5 / 0.729e3 * t5576 * t3181 - 0.2e3 / 0.27e2 * t1767 * t459 * t3632 * t290;
  t10190 = -0.2e5 / 0.729e3 * t1773 * t750 * t3632 * t274 + 0.2e5 / 0.729e3 * t4714 * t750 * t3608 * t290 - 0.1e5 / 0.243e3 * t4694 * t750 * t3608 * t274 + 0.4e1 * t691 * t1138 * t987 + 0.4e1 * t691 * t978 * t1145 + 0.4e1 * t691 * t988 * t1145 + 0.125e6 / 0.19683e5 * t1759 * t3604 * t299 - 0.6e1 * t1747 * t3210 * t345 - 0.6e1 * t1747 * t1199 * t874 - 0.6e1 * t1747 * t3646 * t290 + 0.2e1 * t691 * t3657 * t290 + 0.2e1 * t691 * t3665 * t290;
  t10215 = t57 * t987;
  t10224 = 0.4e1 * t691 * t384 * t3021 + 0.2e1 * t691 * t3222 * t345 + 0.2e1 * t691 * t3232 * t345 + 0.2e1 * t691 * t1208 * t874 + 0.1e5 / 0.729e3 * t5651 * t1187 - 0.125e4 / 0.243e3 * t1686 * t3615 - 0.125e4 / 0.243e3 * t659 * t9047 * t3614 - 0.25e6 / 0.19683e5 * t2737 * t4652 * t3618 - 0.25e2 / 0.54e2 * t4740 * t3629 - 0.25e2 / 0.54e2 * t1662 * t1129 * t10215 + 0.5e2 / 0.27e2 * t4740 * t3636 + 0.5e2 / 0.27e2 * t1662 * t1194 * t9023;
  t10239 = t1759 * t3603;
  t10263 = 0.5e2 / 0.27e2 * t5654 * t3198 + 0.1e7 / 0.19683e5 * t2737 * t4652 * t3608 - 0.6e1 * t2992 * t1207 * t345 * t290 + 0.25e6 / 0.6561e4 * t4665 * t3603 * t9062 - 0.125e6 / 0.19683e5 * t10239 * t4653 - 0.1e7 / 0.19683e5 * t2737 * t7173 * t1185 - 0.5e2 / 0.27e2 * t2159 * t1195 + 0.24e2 * t8040 * t1198 * t345 * t290 - 0.12e2 * t2992 * t2993 * t987 - 0.12e2 * t2992 * t383 * t1145 * t290 + 0.2e3 / 0.9e1 * t4723 * t667 * t54 * t374 * t2994;
  t10288 = t1766 * t141 * t1185;
  t10291 = 0.4e5 / 0.729e3 * t7196 * t6188 * t2993 * t274 - 0.1e6 / 0.2187e4 * t3513 + 0.25e4 / 0.81e2 * t3517 - 0.5e3 / 0.81e2 * t3520 + 0.325e3 / 0.162e3 * t3526 + 0.5e3 / 0.81e2 * t3483 + 0.125e4 / 0.243e3 * t4694 * t750 * t3603 * t290 - 0.1e3 / 0.81e2 * t3204 * t853 + 0.5e2 / 0.81e2 * t3216 * t853 + 0.1e3 / 0.27e2 * t2203 * t3633 + 0.1e3 / 0.27e2 * t668 * t459 * t114 * t3021 - 0.1e3 / 0.27e2 * t10288 * t8920;
  t10297 = t1766 * t3646;
  t10310 = t666 * t3665;
  t10323 = 0.25e2 / 0.54e2 * t8412 * t337 + 0.25e2 / 0.54e2 * t3204 * t849 - 0.1e3 / 0.27e2 * t10297 * t276 - 0.1e5 / 0.729e3 * t4706 * t3609 - 0.1e5 / 0.729e3 * t1773 * t750 * t1185 * t874 - 0.1e5 / 0.729e3 * t5576 * t3170 + 0.1e5 / 0.243e3 * t7052 * t3176 + 0.5e2 / 0.27e2 * t10310 * t276 + 0.25e4 / 0.729e3 * t4706 * t3619 + 0.25e4 / 0.729e3 * t1773 * t750 * t1118 * t987 + 0.1e3 / 0.27e2 * t7007 * t1191 + 0.1e3 / 0.27e2 * t7011 * t1191;
  t10326 = t459 * t8533;
  t10341 = t666 * t3657;
  t10345 = 0.1e3 / 0.27e2 * t2222 * t3194 + 0.25e2 / 0.27e2 * t9702 * t10326 + 0.1e3 / 0.27e2 * t1782 * t3633 - 0.5e3 / 0.81e2 * t3462 - 0.5e3 / 0.81e2 * t3464 - 0.325e5 / 0.2187e4 * t3466 + 0.1e6 / 0.2187e4 * t3470 - 0.25e2 / 0.108e3 * t8420 * t337 - 0.25e2 / 0.108e3 * t8424 * t337 - 0.25e2 / 0.108e3 * t3216 * t849 + 0.5e2 / 0.27e2 * t10341 * t276 + 0.1e4 / 0.81e2 * t3478;
  t10353 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t3667 - t10069 - 0.3e1 / 0.8e1 * t6 * t99 * (t10116 + t10149 + t10190 + t10224 + t10263 + t10291 + t10323 + t10345));
  tv4rhosigmatau217 = t7 * t10353 + t3671;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t10360 = t6 * t162 * t3711 / 0.8e1;
  t10395 = t1176 * t52;
  t10434 = 0.2e5 / 0.243e3 * t3975 * t750 * t3677 * t201 - 0.1e5 / 0.81e2 * t3961 * t750 * t3677 * t185 - 0.18e2 * t1395 * t1168 * t930 + 0.6e1 * t482 * t921 * t1176 + 0.6e1 * t482 * t931 * t1176 + 0.6e1 * t482 * t367 * t3137 + 0.2e1 * t482 * t3709 * t201 - 0.1e7 / 0.19683e5 * t1360 * t3673 * t210 + 0.24e2 * t3898 * t3697 * t201 + 0.1e7 / 0.6561e4 * t2584 * t3837 * t3677 + 0.1e5 / 0.243e3 * t1327 * t3682;
  t10447 = t1360 * t3672;
  t10450 = t366 * t1176;
  t10462 = 0.1e5 / 0.243e3 * t447 * t8836 * t3681 + 0.5e2 / 0.9e1 * t3855 * t3689 + 0.5e2 / 0.9e1 * t1321 * t1163 * t9884 - 0.2e7 / 0.6561e4 * t4026 * t3672 * t8798 + 0.1e7 / 0.19683e5 * t10447 * t3838 - 0.18e2 * t2872 * t10450 * t201 - 0.5e5 / 0.243e3 * t3547 - 0.5e3 / 0.27e2 * t3561 - 0.1e3 / 0.9e1 * t10033 * t10021 + 0.5e2 / 0.9e1 * t1285 * t3693 + 0.5e2 / 0.9e1 * t1965 * t3693;
  t10467 = t4004 * t3697;
  t10470 = t456 * t3709;
  t10490 = 0.5e2 / 0.9e1 * t458 * t459 * t49 * t3137 + 0.1e3 / 0.9e1 * t10467 * t187 + 0.5e2 / 0.27e2 * t10470 * t187 - 0.1e5 / 0.243e3 * t3958 * t3678 - 0.1e5 / 0.243e3 * t1275 * t750 * t1154 * t930 - 0.1e5 / 0.243e3 * t3961 * t750 * t3672 * t201 - 0.1e3 / 0.9e1 * t5113 * t3686 - 0.1e3 / 0.9e1 * t5116 * t3686 + 0.1e6 / 0.729e3 * t3551 + 0.5e3 / 0.27e2 * t3572 - 0.25e3 / 0.27e2 * t3583;
  t10497 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t156 * t3711 - t10360 - 0.3e1 / 0.8e1 * t6 * t28 * (-0.6e1 * t1395 * t210 * t3696 - t192 * t210 * t3708 - t192 * t83 * (-0.25e4 / 0.81e2 * t3590 + 0.25e7 / 0.6561e4 * t3922 * t3705 * t185 - 0.125e8 / 0.19683e5 * t3593) + 0.5e7 / 0.19683e5 * t3537 + 0.1e3 / 0.3e1 * t5033 * t459 * t3685 * t201 - 0.2e3 / 0.9e1 * t1269 * t459 * t1159 * t930 + 0.2e5 / 0.243e3 * t3975 * t750 * t3685 * t185 - 0.1e3 / 0.9e1 * t1269 * t459 * t3692 * t201 - 0.1e5 / 0.243e3 * t1275 * t750 * t3692 * t185 - 0.1e3 / 0.9e1 * t2252 * t10395 * t2845 + t10434 + t10462 + t10490));
  tv4rhotau30 = t7 * t10497 + t3715;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t10504 = t6 * t228 * t3755 / 0.8e1;
  t10506 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t224 * t3755 - t10504);
  tv4rhotau33 = t7 * t10506 + t3759;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t10512 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t241 * t3711 - t10360);
  tv4rhotau34 = t7 * t10512 + t3715;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t10587 = 0.6e1 * t691 * t978 * t1207 + 0.6e1 * t691 * t988 * t1207 + 0.6e1 * t691 * t384 * t3231 + 0.2e1 * t691 * t3753 * t290 - 0.1e7 / 0.19683e5 * t1759 * t3717 * t299 - 0.1e5 / 0.81e2 * t4694 * t750 * t3721 * t274 + 0.1e3 / 0.3e1 * t5584 * t459 * t3729 * t290 - 0.2e3 / 0.9e1 * t1767 * t459 * t1190 * t987 + 0.2e5 / 0.243e3 * t4714 * t750 * t3729 * t274 - 0.1e3 / 0.9e1 * t1767 * t459 * t3736 * t290 - 0.1e5 / 0.243e3 * t1773 * t750 * t3736 * t274;
  t10589 = t1207 * t117;
  t10603 = t1759 * t3716;
  t10606 = t383 * t1207;
  t10612 = t666 * t3753;
  t10621 = -0.1e3 / 0.9e1 * t2414 * t10589 * t2958 + 0.2e5 / 0.243e3 * t4714 * t750 * t3721 * t290 + 0.5e2 / 0.9e1 * t1662 * t1194 * t10215 - 0.2e7 / 0.6561e4 * t4665 * t3716 * t9062 + 0.1e7 / 0.19683e5 * t10603 * t4653 - 0.18e2 * t2992 * t10606 * t290 - 0.5e5 / 0.243e3 * t3616 - 0.5e3 / 0.27e2 * t3630 + 0.5e2 / 0.27e2 * t10612 * t276 - 0.1e5 / 0.243e3 * t4706 * t3722 - 0.1e5 / 0.243e3 * t1773 * t750 * t1185 * t987;
  t10640 = t4723 * t3741;
  t10646 = -0.1e5 / 0.243e3 * t4694 * t750 * t3716 * t290 - 0.1e3 / 0.9e1 * t5488 * t3730 - 0.1e3 / 0.9e1 * t5491 * t3730 - 0.1e3 / 0.9e1 * t10288 * t10326 + 0.5e2 / 0.9e1 * t1782 * t3737 + 0.5e2 / 0.9e1 * t2203 * t3737 + 0.5e2 / 0.9e1 * t668 * t459 * t114 * t3231 + 0.1e3 / 0.9e1 * t10640 * t276 + 0.1e6 / 0.729e3 * t3620 + 0.5e3 / 0.27e2 * t3641 - 0.25e3 / 0.27e2 * t3652;
  t10653 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t252 * t3755 - t10504 - 0.3e1 / 0.8e1 * t6 * t99 * (-0.6e1 * t1747 * t299 * t3740 - t281 * t299 * t3752 - t281 * t141 * (-0.25e4 / 0.81e2 * t3659 + 0.25e7 / 0.6561e4 * t4566 * t3749 * t274 - 0.125e8 / 0.19683e5 * t3662) + 0.1e7 / 0.6561e4 * t2737 * t4652 * t3721 + 0.1e5 / 0.243e3 * t1686 * t3726 + 0.1e5 / 0.243e3 * t659 * t9047 * t3725 + 0.5e2 / 0.9e1 * t4740 * t3733 + 0.5e7 / 0.19683e5 * t3606 + 0.24e2 * t4540 * t3741 * t290 - 0.18e2 * t1747 * t1199 * t987 + t10587 + t10621 + t10646));
  tv4rhotau37 = t7 * t10653 + t3759;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t10655 = t1015 * t1015;
  t10659 = t1027 * t1027;
  t10682 = 0.1e1 / t37 / t1853;
  t10700 = t459 * t39;
  t10701 = t8773 * t10700;
  t10704 = t10682 * t29;
  t10705 = t10704 * t33;
  t10707 = t3822 * t10705;
  t10712 = 0.24e2 * t3898 * t83 * t10655 + 0.6e1 * t482 * t83 * t10659 - 0.4e1 * t192 * t3247 * t321 - 0.24e2 * t1395 * t326 * t3255 + 0.12e2 * t482 * t1032 * t1015 - 0.6e1 * t192 * t1032 * t1027 - 0.4e1 * t192 * t326 * t3276 + 0.15625e5 / 0.39366e5 * t1360 * t3251 * t326 - 0.15625e5 / 0.209952e6 * t4026 * t10682 * t76 * t83 - 0.36e2 * t1395 * t1016 * t1027 + 0.24e2 * t482 * t1019 * t1027 + 0.8e1 * t482 * t322 * t3276 + 0.25e2 / 0.27e2 * t8818 * t313 + 0.25e2 / 0.72e2 * t4953 * t3300 + 0.5e2 / 0.9e1 * t1818 * t10701 + t77 * (-0.625e3 / 0.6198727824e10 * t3795 * t10705 + 0.625e3 / 0.6198727824e10 * t10707) - 0.625e3 / 0.6198727824e10 * t10707;
  t10746 = t192 * t83;
  t10751 = t57 * t1027;
  t10755 = t57 * t1015;
  t10761 = -0.15625e5 / 0.39366e5 * t8801 * t4985 + 0.625e3 / 0.62208e5 * t447 * t10704 * t450 - 0.25e2 / 0.144e3 * t2601 * t1000 - 0.5e2 / 0.9e1 * t8658 * t313 + 0.5e2 / 0.9e1 * t8688 * t313 - 0.25e2 / 0.9e1 * t8691 * t313 - 0.25e2 / 0.9e1 * t8694 * t313 - 0.25e2 / 0.27e2 * t8697 * t313 - 0.625e3 / 0.243e3 * t5136 * t3280 - 0.625e3 / 0.486e3 * t1275 * t750 * t999 * t1027 + 0.625e3 / 0.1944e4 * t3961 * t750 * t3242 * t321 + 0.625e3 / 0.243e3 * t3975 * t750 * t999 * t1015 - 0.625e3 / 0.1944e4 * t1840 * t3296 - 0.78125e5 / 0.839808e6 * t10746 * t3922 * t72 * t10682 + 0.25e2 / 0.144e3 * t1321 * t2597 * t10751 - 0.25e2 / 0.72e2 * t3866 * t2597 * t10755 + 0.625e3 / 0.486e3 * t6765 * t1004;
  t10766 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t10712 + t10761));
  tv4sigma40 = t7 * t10766;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t10767 = t1069 * t1069;
  t10783 = t1057 * t1057;
  t10803 = 0.1e1 / t102 / t2104;
  t10808 = t10803 * t29;
  t10809 = t10808 * t33;
  t10811 = t4626 * t10809;
  t10815 = t459 * t104;
  t10816 = t8995 * t10815;
  t10825 = 0.6e1 * t691 * t141 * t10767 + 0.12e2 * t691 * t1074 * t1057 - 0.4e1 * t281 * t3343 * t345 - 0.6e1 * t281 * t1074 * t1069 - 0.4e1 * t281 * t350 * t3338 + 0.24e2 * t4540 * t141 * t10783 - 0.24e2 * t1747 * t350 * t3315 - 0.36e2 * t1747 * t1058 * t1069 + 0.24e2 * t691 * t1061 * t1069 + 0.8e1 * t691 * t346 * t3338 + 0.15625e5 / 0.39366e5 * t1759 * t3311 * t350 - 0.15625e5 / 0.209952e6 * t4665 * t10803 * t134 * t141 + t135 * (-0.625e3 / 0.6198727824e10 * t4601 * t10809 + 0.625e3 / 0.6198727824e10 * t10811) + 0.5e2 / 0.9e1 * t2060 * t10816 - 0.625e3 / 0.6198727824e10 * t10811 - 0.25e2 / 0.144e3 * t2748 * t1042 + 0.625e3 / 0.62208e5 * t659 * t10808 * t450;
  t10854 = t57 * t1069;
  t10858 = t57 * t1057;
  t10864 = t281 * t141;
  t10873 = -0.15625e5 / 0.39366e5 * t9065 * t5414 + 0.625e3 / 0.243e3 * t4714 * t750 * t1041 * t1057 - 0.25e2 / 0.27e2 * t8934 * t337 - 0.625e3 / 0.243e3 * t5576 * t3348 - 0.625e3 / 0.486e3 * t1773 * t750 * t1041 * t1069 + 0.625e3 / 0.1944e4 * t4694 * t750 * t3310 * t345 - 0.5e2 / 0.9e1 * t8972 * t337 + 0.5e2 / 0.9e1 * t8906 * t337 - 0.25e2 / 0.9e1 * t8909 * t337 - 0.25e2 / 0.9e1 * t8931 * t337 - 0.625e3 / 0.1944e4 * t2164 * t3364 + 0.25e2 / 0.144e3 * t1662 * t2744 * t10854 - 0.25e2 / 0.72e2 * t4749 * t2744 * t10858 + 0.625e3 / 0.486e3 * t7236 * t1046 - 0.78125e5 / 0.839808e6 * t10864 * t4566 * t72 * t10803 + 0.25e2 / 0.27e2 * t9031 * t337 + 0.25e2 / 0.72e2 * t5654 * t3368;
  t10878 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * (t10825 + t10873));
  tv4sigma414 = t7 * t10878;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t10889 = 0.1e1 / t37 / t2555;
  t10919 = 0.24e2 * t3898 * t367 * t3255 - 0.18e2 * t1395 * t1110 * t1015 - 0.15625e5 / 0.6561e4 * t1360 * t3384 * t326 + 0.15625e5 / 0.26244e5 * t4026 * t10889 * t76 * t83 + 0.6e1 * t482 * t3408 * t321 + 0.12e2 * t482 * t3397 * t321 + 0.6e1 * t482 * t1102 * t1027 + 0.6e1 * t482 * t3406 * t321 + 0.6e1 * t482 * t1110 * t1027 + 0.2e1 * t482 * t367 * t3276 - 0.18e2 * t1395 * t1102 * t1015 - 0.1e3 / 0.9e1 * t1269 * t459 * t3423 * t321;
  t10954 = 0.625e3 / 0.486e3 * t6000 * t448 * t1003 * t321 - 0.25e2 / 0.6e1 * t5980 * t9204 * t10700 + 0.25e2 / 0.9e1 * t7468 * t3428 + 0.25e2 / 0.9e1 * t7471 * t3428 + 0.25e2 / 0.18e2 * t2252 * t10701 + 0.15625e5 / 0.6561e4 * t9276 * t4985 - 0.15625e5 / 0.157464e6 * t8801 * t6006 - 0.625e3 / 0.7776e4 * t447 * t10889 * t29 * t450 + 0.25e2 / 0.36e2 * t2601 * t1094 - 0.18e2 * t2872 * t2873 * t1027 - 0.3e1 * t192 * t1032 * t1109 - 0.3e1 * t192 * t326 * t3405 - t192 * t3247 * t366;
  t10988 = 0.125e4 / 0.243e3 * t1275 * t750 * t1082 * t1027 - 0.625e3 / 0.324e3 * t3961 * t750 * t3383 * t321 + 0.5e2 / 0.9e1 * t8681 * t1088 + 0.5e2 / 0.9e1 * t1984 * t3424 + 0.5e2 / 0.27e2 * t458 * t459 * t49 * t3276 - 0.25e2 / 0.144e3 * t2252 * t3300 - 0.25e2 / 0.18e2 * t9409 * t313 - 0.25e2 / 0.36e2 * t9412 * t313 - 0.25e2 / 0.36e2 * t9415 * t313 - 0.625e3 / 0.972e3 * t7335 * t1004 - 0.625e3 / 0.972e3 * t7340 * t1004 + 0.1e3 / 0.9e1 * t5033 * t459 * t49 * t3255;
  t11023 = -0.25e4 / 0.243e3 * t3975 * t750 * t1082 * t1015 - 0.1e3 / 0.9e1 * t6570 * t3432 + 0.625e3 / 0.7776e4 * t2341 * t3296 + 0.25e4 / 0.243e3 * t5136 * t3418 + 0.625e3 / 0.324e3 * t1840 * t3442 + 0.78125e5 / 0.104976e6 * t10746 * t3922 * t72 * t10889 + 0.25e2 / 0.288e3 * t4953 * t3436 + 0.25e2 / 0.288e3 * t1321 * t1109 * t999 * t459 - 0.25e2 / 0.36e2 * t1321 * t1093 * t10751 + 0.25e2 / 0.18e2 * t3866 * t1093 * t10755 - 0.125e4 / 0.243e3 * t6765 * t1084 - 0.5e2 / 0.27e2 * t8818 * t358 - 0.25e2 / 0.18e2 * t4953 * t3445;
  t11029 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t10919 + t10954 + t10988 + t11023));
  tv4sigma3tau0 = t7 * t11029;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t11031 = 0.1e1 / t102 / t2671;
  t11070 = 0.15625e5 / 0.26244e5 * t4665 * t11031 * t134 * t141 + 0.6e1 * t691 * t3500 * t345 + 0.24e2 * t4540 * t384 * t3315 - 0.18e2 * t1747 * t1138 * t1057 - 0.18e2 * t1747 * t1146 * t1057 + 0.12e2 * t691 * t3502 * t345 + 0.6e1 * t691 * t3511 * t345 + 0.6e1 * t691 * t1146 * t1069 + 0.6e1 * t691 * t1138 * t1069 + 0.2e1 * t691 * t384 * t3338 - 0.15625e5 / 0.6561e4 * t1759 * t3493 * t350 + 0.625e3 / 0.486e3 * t6266 * t660 * t1045 * t345;
  t11106 = 0.25e2 / 0.18e2 * t2414 * t10816 - 0.1e3 / 0.9e1 * t1767 * t459 * t3458 * t345 + 0.25e2 / 0.9e1 * t7898 * t3477 + 0.25e2 / 0.9e1 * t7928 * t3477 - 0.25e2 / 0.6e1 * t6257 * t269 * t336 * t1057 - 0.15625e5 / 0.157464e6 * t9065 * t6307 + 0.15625e5 / 0.6561e4 * t9690 * t5414 - 0.18e2 * t2992 * t2993 * t1069 + 0.25e2 / 0.36e2 * t2748 * t1130 - 0.625e3 / 0.7776e4 * t659 * t11031 * t29 * t450 + 0.625e3 / 0.7776e4 * t2484 * t3364 - 0.625e3 / 0.324e3 * t4694 * t750 * t3492 * t345 - 0.25e2 / 0.144e3 * t2414 * t3368;
  t11140 = 0.5e2 / 0.9e1 * t8924 * t1124 + 0.5e2 / 0.9e1 * t2222 * t3459 + 0.25e4 / 0.243e3 * t5576 * t3469 + 0.5e2 / 0.27e2 * t668 * t459 * t114 * t3338 + 0.125e4 / 0.243e3 * t1773 * t750 * t1118 * t1069 - 0.25e2 / 0.36e2 * t9752 * t337 - 0.25e2 / 0.18e2 * t9755 * t337 - 0.625e3 / 0.972e3 * t7830 * t1046 - 0.25e2 / 0.36e2 * t9758 * t337 - 0.625e3 / 0.972e3 * t7835 * t1046 - 0.25e4 / 0.243e3 * t4714 * t750 * t1118 * t1057 + 0.1e3 / 0.9e1 * t5584 * t459 * t114 * t3315;
  t11175 = -0.1e3 / 0.9e1 * t7047 * t3473 + 0.25e2 / 0.18e2 * t4749 * t1129 * t10858 + 0.625e3 / 0.324e3 * t2164 * t3516 + 0.78125e5 / 0.104976e6 * t10864 * t4566 * t72 * t11031 - 0.125e4 / 0.243e3 * t7236 * t1120 - 0.5e2 / 0.27e2 * t9031 * t375 - 0.25e2 / 0.18e2 * t5654 * t3519 - 0.25e2 / 0.36e2 * t1662 * t1129 * t10854 + 0.25e2 / 0.288e3 * t5654 * t3525 + 0.25e2 / 0.288e3 * t1662 * t1145 * t1041 * t459 - t281 * t3343 * t383 - 0.3e1 * t281 * t1074 * t1145 - 0.3e1 * t281 * t350 * t3510;
  t11181 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * (t11070 + t11106 + t11140 + t11175));
  tv4sigma3tau19 = t7 * t11181;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t11211 = 0.1e1 / t37 / t1335;
  t11223 = 0.25e2 / 0.27e2 * t8213 * t3428 - 0.2e3 / 0.27e2 * t1269 * t459 * t1159 * t1027 - 0.25e2 / 0.9e1 * t8206 * t3428 + 0.5e2 / 0.27e2 * t2252 * t180 * t312 * t1109 - 0.1e5 / 0.729e3 * t3975 * t750 * t3549 * t321 - 0.4e3 / 0.27e2 * t6570 * t3554 - 0.4e3 / 0.27e2 * t1269 * t459 * t3563 * t321 + 0.2e3 / 0.9e1 * t5033 * t459 * t1159 * t1015 - 0.25e6 / 0.19683e5 * t9954 * t4985 + 0.625e3 / 0.972e3 * t447 * t11211 * t29 * t450 + 0.3125e5 / 0.19683e5 * t9276 * t6006 - 0.5e2 / 0.27e2 * t2601 * t1164 - 0.24e2 * t2872 * t2873 * t1109;
  t11234 = t459 * t2873;
  t11263 = 0.5e4 / 0.729e3 * t5136 * t3550 + 0.5e4 / 0.729e3 * t1275 * t750 * t1082 * t1109 - 0.625e3 / 0.486e3 * t3961 * t750 * t3383 * t366 + 0.5e2 / 0.27e2 * t9353 * t11234 + 0.1e3 / 0.27e2 * t8681 * t1160 + 0.2e3 / 0.27e2 * t1984 * t3564 + 0.1e3 / 0.27e2 * t458 * t459 * t49 * t3405 - 0.2e5 / 0.729e3 * t5136 * t3540 - 0.1e5 / 0.729e3 * t1275 * t750 * t1154 * t1027 + 0.25e4 / 0.243e3 * t3961 * t750 * t3534 * t321 + 0.25e2 / 0.27e2 * t9987 * t313 + 0.625e3 / 0.1458e4 * t8176 * t1004 - 0.25e2 / 0.54e2 * t9998 * t313 - 0.25e2 / 0.54e2 * t10001 * t313;
  t11288 = t57 * t1109;
  t11301 = -0.625e3 / 0.2916e4 * t8187 * t1004 + 0.2e5 / 0.729e3 * t3975 * t750 * t1154 * t1015 + 0.2e1 * t482 * t1032 * t1167 - t192 * t1032 * t1176 - 0.2e1 * t192 * t326 * t3595 - 0.1e3 / 0.27e2 * t3866 * t1163 * t10755 + 0.1e5 / 0.729e3 * t6765 * t1156 - 0.25e4 / 0.243e3 * t1840 * t3546 - 0.25e2 / 0.27e2 * t4953 * t3560 - 0.25e2 / 0.27e2 * t1321 * t1093 * t11288 + 0.1e3 / 0.27e2 * t4953 * t3567 + 0.5e2 / 0.27e2 * t1321 * t1163 * t10751 - 0.25e2 / 0.432e3 * t3866 * t1167 * t999 * t459;
  t11344 = t1109 * t1109;
  t11348 = 0.25e2 / 0.864e3 * t1321 * t1176 * t999 * t459 - 0.78125e5 / 0.13122e5 * t10746 * t3922 * t72 * t11211 - 0.6e1 * t1395 * t1177 * t1015 + 0.24e2 * t3898 * t1168 * t1015 + 0.2e1 * t482 * t1177 * t1027 + 0.4e1 * t482 * t3588 * t321 + 0.4e1 * t482 * t3596 * t321 + 0.4e1 * t482 * t367 * t3405 - 0.3125e5 / 0.6561e4 * t4026 * t11211 * t76 * t83 - 0.12e2 * t1395 * t3577 * t321 - 0.6e1 * t1395 * t1168 * t1027 + 0.8e1 * t482 * t1102 * t1109 + 0.25e6 / 0.19683e5 * t1360 * t3535 * t326 + 0.4e1 * t482 * t83 * t11344;
  t11354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t11223 + t11263 + t11301 + t11348));
  tv4sigma2tau20 = t7 * t11354;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t11384 = 0.1e1 / t102 / t1694;
  t11396 = -0.25e2 / 0.9e1 * t8457 * t3477 + 0.5e2 / 0.27e2 * t2414 * t269 * t336 * t1145 + 0.25e2 / 0.27e2 * t8464 * t3477 - 0.1e5 / 0.729e3 * t4714 * t750 * t3618 * t345 - 0.4e3 / 0.27e2 * t7047 * t3623 - 0.4e3 / 0.27e2 * t1767 * t459 * t3632 * t345 - 0.2e3 / 0.27e2 * t1767 * t459 * t1190 * t1069 + 0.2e3 / 0.9e1 * t5584 * t459 * t1190 * t1057 - 0.25e6 / 0.19683e5 * t10239 * t5414 + 0.625e3 / 0.972e3 * t659 * t11384 * t29 * t450 + 0.3125e5 / 0.19683e5 * t9690 * t6307 - 0.5e2 / 0.27e2 * t2748 * t1195 - 0.24e2 * t2992 * t2993 * t1145;
  t11405 = t459 * t2993;
  t11438 = 0.5e4 / 0.729e3 * t1773 * t750 * t1118 * t1145 - 0.625e3 / 0.486e3 * t4694 * t750 * t3492 * t383 + 0.5e2 / 0.27e2 * t9702 * t11405 + 0.1e3 / 0.27e2 * t8924 * t1191 + 0.2e3 / 0.27e2 * t2222 * t3633 + 0.1e3 / 0.27e2 * t668 * t459 * t114 * t3510 - 0.2e5 / 0.729e3 * t5576 * t3609 - 0.1e5 / 0.729e3 * t1773 * t750 * t1185 * t1069 + 0.25e4 / 0.243e3 * t4694 * t750 * t3603 * t345 + 0.2e5 / 0.729e3 * t4714 * t750 * t1185 * t1057 + 0.25e2 / 0.27e2 * t10297 * t337 + 0.625e3 / 0.1458e4 * t8417 * t1046 - 0.25e2 / 0.54e2 * t10341 * t337 - 0.25e2 / 0.54e2 * t10310 * t337;
  t11452 = t1145 * t1145;
  t11477 = -0.625e3 / 0.2916e4 * t8429 * t1046 + 0.5e4 / 0.729e3 * t5576 * t3619 - 0.2e1 * t281 * t350 * t3664 + 0.2e1 * t691 * t1074 * t1198 - t281 * t1074 * t1207 + 0.4e1 * t691 * t141 * t11452 + 0.24e2 * t4540 * t1199 * t1057 - 0.6e1 * t1747 * t1208 * t1057 - 0.12e2 * t1747 * t3646 * t345 - 0.6e1 * t1747 * t1199 * t1069 + 0.8e1 * t691 * t1138 * t1145 + 0.4e1 * t691 * t384 * t3510 + 0.4e1 * t691 * t3657 * t345;
  t11493 = t57 * t1145;
  t11521 = 0.4e1 * t691 * t3665 * t345 + 0.2e1 * t691 * t1208 * t1069 + 0.25e6 / 0.19683e5 * t1759 * t3604 * t350 - 0.3125e5 / 0.6561e4 * t4665 * t11384 * t134 * t141 - 0.25e2 / 0.27e2 * t5654 * t3629 - 0.25e2 / 0.27e2 * t1662 * t1129 * t11493 + 0.1e3 / 0.27e2 * t5654 * t3636 + 0.5e2 / 0.27e2 * t1662 * t1194 * t10854 - 0.25e2 / 0.432e3 * t4749 * t1198 * t1041 * t459 + 0.25e2 / 0.864e3 * t1662 * t1207 * t1041 * t459 - 0.78125e5 / 0.13122e5 * t10864 * t4566 * t72 * t11384 + 0.1e5 / 0.729e3 * t7236 * t1187 - 0.25e4 / 0.243e3 * t2164 * t3615 - 0.1e3 / 0.27e2 * t4749 * t1194 * t10858;
  t11527 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * (t11396 + t11438 + t11477 + t11521));
  tv4sigma2tau217 = t7 * t11527;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t11552 = 0.1e1 / t37 / t435;
  t11586 = 0.1e3 / 0.3e1 * t5033 * t459 * t3685 * t321 - 0.2e3 / 0.9e1 * t1269 * t459 * t1159 * t1109 - 0.1e3 / 0.9e1 * t1269 * t459 * t3692 * t321 + 0.25e2 / 0.18e2 * t2252 * t10395 * t10700 + 0.2e5 / 0.243e3 * t3975 * t750 * t3677 * t321 + 0.1e7 / 0.19683e5 * t10447 * t4985 - 0.125e6 / 0.6561e4 * t9954 * t6006 - 0.125e4 / 0.243e3 * t447 * t11552 * t29 * t450 - 0.18e2 * t2872 * t10450 * t321 - 0.25e2 / 0.18e2 * t10467 * t313 - 0.25e2 / 0.108e3 * t10470 * t313 - 0.1e5 / 0.243e3 * t5136 * t3678 - 0.1e5 / 0.243e3 * t1275 * t750 * t1154 * t1109 + 0.125e4 / 0.81e2 * t3961 * t750 * t3534 * t366 - 0.1e5 / 0.243e3 * t3961 * t750 * t3672 * t321 - 0.1e3 / 0.9e1 * t6570 * t3686 - 0.25e4 / 0.243e3 * t3975 * t750 * t1082 * t1167 - 0.1e3 / 0.9e1 * t10033 * t11234;
  t11630 = t57 * t1176;
  t11640 = t57 * t1167;
  t11646 = 0.5e2 / 0.9e1 * t1984 * t3693 + 0.5e2 / 0.9e1 * t458 * t459 * t49 * t3595 + 0.125e4 / 0.243e3 * t1275 * t750 * t1082 * t1176 - 0.6e1 * t1395 * t326 * t3696 - t192 * t326 * t3708 + 0.6e1 * t482 * t367 * t3595 + 0.2e1 * t482 * t3709 * t321 - 0.1e7 / 0.19683e5 * t1360 * t3673 * t326 + 0.25e6 / 0.6561e4 * t4026 * t11552 * t76 * t83 + 0.24e2 * t3898 * t3697 * t321 - 0.18e2 * t1395 * t1168 * t1109 + 0.6e1 * t482 * t1102 * t1176 + 0.6e1 * t482 * t1110 * t1176 + 0.5e2 / 0.9e1 * t1321 * t1163 * t11288 - 0.25e2 / 0.36e2 * t1321 * t1093 * t11630 + 0.3125e6 / 0.6561e4 * t10746 * t3922 * t72 * t11552 + 0.1e5 / 0.243e3 * t1840 * t3682 + 0.25e2 / 0.18e2 * t3866 * t1093 * t11640 + 0.5e2 / 0.9e1 * t4953 * t3689;
  t11651 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t11586 + t11646));
  tv4sigmatau30 = t7 * t11651;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t11676 = 0.1e1 / t102 / t647;
  t11711 = 0.1e3 / 0.3e1 * t5584 * t459 * t3729 * t345 - 0.2e3 / 0.9e1 * t1767 * t459 * t1190 * t1145 - 0.1e3 / 0.9e1 * t1767 * t459 * t3736 * t345 + 0.25e2 / 0.18e2 * t2414 * t10589 * t10815 + 0.2e5 / 0.243e3 * t4714 * t750 * t3721 * t345 + 0.1e7 / 0.19683e5 * t10603 * t5414 - 0.125e6 / 0.6561e4 * t10239 * t6307 - 0.125e4 / 0.243e3 * t659 * t11676 * t29 * t450 - 0.18e2 * t2992 * t10606 * t345 - 0.6e1 * t1747 * t350 * t3740 - t281 * t350 * t3752 + 0.125e4 / 0.243e3 * t1773 * t750 * t1118 * t1207 - 0.25e2 / 0.18e2 * t10640 * t337 - 0.25e2 / 0.108e3 * t10612 * t337 - 0.1e5 / 0.243e3 * t5576 * t3722 - 0.1e5 / 0.243e3 * t1773 * t750 * t1185 * t1145 + 0.125e4 / 0.81e2 * t4694 * t750 * t3603 * t383 - 0.1e5 / 0.243e3 * t4694 * t750 * t3716 * t345;
  t11753 = t57 * t1198;
  t11762 = t57 * t1207;
  t11770 = -0.1e3 / 0.9e1 * t7047 * t3730 - 0.25e4 / 0.243e3 * t4714 * t750 * t1118 * t1198 - 0.1e3 / 0.9e1 * t10288 * t11405 + 0.5e2 / 0.9e1 * t2222 * t3737 + 0.5e2 / 0.9e1 * t668 * t459 * t114 * t3664 + 0.6e1 * t691 * t384 * t3664 + 0.2e1 * t691 * t3753 * t345 - 0.1e7 / 0.19683e5 * t1759 * t3717 * t350 + 0.25e6 / 0.6561e4 * t4665 * t11676 * t134 * t141 + 0.24e2 * t4540 * t3741 * t345 - 0.18e2 * t1747 * t1199 * t1145 + 0.6e1 * t691 * t1138 * t1207 + 0.6e1 * t691 * t1146 * t1207 + 0.1e5 / 0.243e3 * t2164 * t3726 + 0.25e2 / 0.18e2 * t4749 * t1129 * t11753 + 0.5e2 / 0.9e1 * t5654 * t3733 + 0.5e2 / 0.9e1 * t1662 * t1194 * t11493 - 0.25e2 / 0.36e2 * t1662 * t1129 * t11762 + 0.3125e6 / 0.6561e4 * t10864 * t4566 * t72 * t11676;
  t11775 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * (t11711 + t11770));
  tv4sigmatau311 = t7 * t11775;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t11787 = t1167 * t1167;
  t11794 = t1176 * t1176;
  t11834 = -0.2e3 / 0.9e1 * t3866 * t1163 * t11640 + 0.2e3 / 0.27e2 * t458 * t459 * t49 * t3708 - 0.2e5 / 0.243e3 * t1275 * t750 * t1154 * t1176 + 0.24e2 * t3898 * t83 * t11787 - 0.36e2 * t1395 * t1168 * t1176 + 0.6e1 * t482 * t83 * t11794 + 0.8e1 * t482 * t367 * t3708 + 0.4e5 / 0.243e3 * t3975 * t750 * t1154 * t1167 - 0.4e5 / 0.243e3 * t3961 * t750 * t3672 * t366 + 0.4e3 / 0.9e1 * t5033 * t459 * t49 * t3696 - 0.4e3 / 0.9e1 * t1269 * t459 * t1159 * t1176 - 0.2e7 / 0.6561e4 * t4026 * t3815 * t76 * t83 + 0.4e7 / 0.19683e5 * t10447 * t6006 + 0.1e5 / 0.243e3 * t447 * t3815 * t29 * t450 + 0.1e3 / 0.9e1 * t1321 * t1163 * t11630 - 0.25e7 / 0.6561e4 * t10746 * t3922 * t72 * t3815;
  t11838 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t11834);
  tv4tau40 = t7 * t11838;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t11850 = t1198 * t1198;
  t11857 = t1207 * t1207;
  t11897 = -0.2e5 / 0.243e3 * t1773 * t750 * t1185 * t1207 - 0.2e3 / 0.9e1 * t4749 * t1194 * t11753 + 0.2e3 / 0.27e2 * t668 * t459 * t114 * t3752 + 0.24e2 * t4540 * t141 * t11850 - 0.36e2 * t1747 * t1199 * t1207 + 0.6e1 * t691 * t141 * t11857 + 0.8e1 * t691 * t384 * t3752 + 0.4e3 / 0.9e1 * t5584 * t459 * t114 * t3740 - 0.4e3 / 0.9e1 * t1767 * t459 * t1190 * t1207 + 0.4e5 / 0.243e3 * t4714 * t750 * t1185 * t1198 - 0.4e5 / 0.243e3 * t4694 * t750 * t3716 * t383 - 0.2e7 / 0.6561e4 * t4665 * t4560 * t134 * t141 + 0.4e7 / 0.19683e5 * t10603 * t6307 + 0.1e5 / 0.243e3 * t659 * t4560 * t29 * t450 + 0.1e3 / 0.9e1 * t1662 * t1194 * t11762 - 0.25e7 / 0.6561e4 * t10864 * t4566 * t72 * t4560;
  t11901 = my_piecewise3(t90, 0, -0.3e1 / 0.8e1 * t6 * t99 * t11897);
  tv4tau44 = t7 * t11901;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

