#include <stdlib.h>
#include "libut/ut.h"

typedef struct test_t {
    int key;
    void *other_data;
    UT_hash_handle hh;
    struct test_t *next;
} test_t;

test_t *list = NULL;

int runtest_cmd(int argc, char *argv[]) {
    test_t *tt, *tmp, *del;
    int i, num, replaced=0;

    if (argc > 1) {
        if (sscanf(argv[1], "%d", &num) != 1) {
            UT_shle("error: non-numeric argument");
            return SHL_ERROR;
        }
    } else num = 100;

    for(i=0; i < num; i++) {
        tt = (test_t*)UT_mem_alloc("testpool", 1);
        tt->key = (int)((num*1.0 * rand()) / (RAND_MAX+1.0));
        tt->next = NULL;

        HASH_FIND_INT(list, del, key, &tt->key);
        if (del) {
            replaced++;
            HASH_DEL(list,tmp,del);
            UT_mem_free("testpool",del,1);
        }
        HASH_ADD_INT(list, tmp, key, tt);
    }
    UT_shlf("Stored %d values in hash (%d replaced prior values)", num, replaced);
    return SHL_OK;
}

int usage_cb(int argc, char*argv[]) {
    UT_shlf("usage: runtest [num]  -- run 100 (or num) iterations of test\n");
}

int main() {
    UT_init(INIT_END);
    UT_shl_cmd_create("runtest", "run a round of testing", runtest_cmd, usage_cb);
    UT_mem_pool_create("testpool", sizeof(test_t), 10);
    UT_event_loop();
}
