#include "libut/ut.h"

int float_cb(char *name, void *data) {
    double f;
    UT_var_get(name, &f);
    if (f > 2) {
        UT_LOG(Info,"%s > 2, averting...", name);
        return -1;
    }
    UT_LOG(Info,"%s accepting value %f", name, f);
    return 0;
}

int main(int argc, char **argv) {

	UT_init(INIT_END);

    /* Creates a variable whose initial value will be less than the minimum,
     * to be established in the subsequent line. This isn't forbidden. *
     * If you then telnet to the control port and set "float" to 2.1, it 
     * will be averted by the float_cb above, but the reversion will also
     * be averted by the restriction callback which sees 0.0 (reverted value)
     * as below the minimum allowed value. (This tests the detection code). */

    /* If you then set the var to 1.9 (this is allowed), then set it to
     * 2.1, this value will be averted by the float_cb, but the reversion 
     * is now back to value 1.9, so the reversion is not averted by the 
     * restriction callback. */
    UT_var_create("float", "test var", UT_var_double, 0.0);
    UT_var_restrict("float", range, 0.1, 2.9);
    UT_var_reg_cb("float", float_cb, NULL);


	UT_event_loop();

}
