#include "libut/ut.h"
    #include <time.h>

int wget_done_cb(char *name, void *data, int flags, UT_iob *io[2]) {
    char *out;
    size_t outlen;

    if (flags & UTFD_IS_REQFAILURE) {
        UT_LOG(Error, "wget failed");
        return;
    }

    /* we always expect REQUESTFIN since there was no REQFALURE */
    if (flags & UTFD_IS_REQSUCCESS) UT_LOG(Info, "wget finished");

    out = UT_iob_flatten(io[1], &outlen);
    UT_LOG(Info, "wget reply buffer follows");
    UT_LOG(Info, "%s", out);
    free(out);

    /* the iobs are our responsibility to free */
    UT_iob_free(io[0]);
    UT_iob_free(io[1]);
}

int wget_test_cmd(int argc, char *argv[] ) {
    int rc;
    UT_iob *io[2];
    char *dst_ipport, hostport[100];

    if (argc != 2) {
        UT_shle("usage: wget hostname\n");
        return SHL_ERROR;
    }

    snprintf(hostport,100,"%s:80", argv[1]);
    if ( (dst_ipport = UT_net_resolve( hostport)) == NULL ) {
        UT_shle("name resolution of %s failed\n", argv[1]);
        return SHL_ERROR;
    }

    io[0] = UT_iob_create();  /* request buffer */
    io[1] = UT_iob_create();  /* reply buffer */
    UT_iob_printf(io[0], 
            "GET / HTTP/1.0\r\nUser-Agent: wget\r\nHost: %s\r\n\r\n", argv[1]);
    rc = UT_net_request("wget", wget_done_cb, NULL, io, UT_CONNECT_TO_IPPORT,
            dst_ipport); 
    if (rc < 0) {
        UT_shle("request error");
        return SHL_ERROR;
    }
    return SHL_OK;
}

int ascii_cmd(int argc, char *argv[]) {
    char *cols[] = { "dec", "hex", "char", NULL };
    int i;

    UT_shl_hdr( cols );
    for(i=97;i<123;i++) UT_shlf("%3d %3x %4c\n",i,i,i); 
    return SHL_OK;
}

int main(int argc, char **argv) {
	UT_init(INIT_END);
    UT_shl_cmd_create("wget", "test http get to host", wget_test_cmd, NULL);
    UT_shl_cmd_create("ascii", "show a-z ascii values", ascii_cmd, NULL);
	UT_event_loop();
}
