/*
Copyright (c) 2003-2005, Troy Hanson
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of the copyright holder nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <time.h>

/*******************************************************************************
 *  Coprocess support                                                          *
 ******************************************************************************/

#define COPROC_POOL "ut_coprocess"
#define COPROC_NAME_MAXLEN 20

#define FD_TO_STDIN 0
#define FD_FROM_STDOUT 1
#define FD_FROM_STDERR 2

#define COPROC_WAITPID_INTERVAL 1000 /* msec to wait before waitpid again */

typedef struct UT_coprocess {
  char name[COPROC_NAME_MAXLEN];
  pid_t pid;
  UT_exithdlr *exit_cb;  /* invoked after coprocess exits and is collected */
  void *data;
  int fds[3];
  time_t start_time;
  struct UT_coprocess *next;
} UT_coprocess;

/* A global intance of this struct contains all coproc state */
typedef struct UT_coprocess_global_type {
  UT_coprocess *coprocs;
} UT_coprocess_global_type;

/* Internal rototypes */
void UT_coproc_init(void);
