/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      vcomment.cpp
 * Description:   implementation of vorbisComment for handling
 *                all editing calls for flacTag and oggTag
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "vorbisComment/vcomment.hpp"

string vorbisComment::empty("");

vorbisComment::vorbisComment(const char * fname) : TagEditor(fname)
{
}

vorbisComment::~vorbisComment() {}


int vorbisComment::removeField(FieldID ID)
{
	string key = translateID(ID);
	if(comments.erase(key) > 0) {
		tag_altered = 1;
		return 0;
	} else
		return -1;
}

bool vorbisComment::fieldExists(FieldID ID) const
{
    return comments.find(translateID(ID)) != comments.end();
}


string vorbisComment::getField(FieldID ID) const
{
	string key = translateID(ID);
	map<string, string>::const_iterator it = comments.find(key);
	if(it != comments.end())
		return it->second;
	else
		return empty;
}

int vorbisComment::setField(FieldID ID, const string& s)
{
	comments[translateID(ID)] = s;
	tag_altered = 1;
	return 0;
}

string vorbisComment::translateID(FieldID ID) const
{
	switch(ID) {
	case Artist:
		return "ARTIST";
	case Title:
		return "TITLE";
	case Album:
		return "ALBUM";
	case Year:
		return "DATE";
	case Track:
		return "TRACKNUMBER";
	case Genre:
		return "GENRE";
	case Comment:
		return "";
	}
	// case Comment:
	return "";
}
