/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      tageditor.cpp
 * Description:   implementation of some TagEditor methods,
 *                saves compile time
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "libtagedit/tageditor.hpp"

TagEditor::TagEditor(const char* n) : fname(n)
{
    tag_altered = 0;
    tag_insane = 0;
    file_length = file_bitrate = 0;
}

TagEditor::~TagEditor() {}

FieldID TagEditor::mapToID(const string& str) const
{
    if(str == "Artist")
        return Artist;
    else if(str == "Title")
        return Title;
    else if(str == "Album")
        return Album;
    else if(str == "Year")
        return Year;
    else if(str == "Track")
        return Track;
    else if(str == "Genre")
        return Genre;
    else if(str == "Comment")
        return Comment;
    else
        return (FieldID)-1;
}


UTF8Converter* TagEditor::converter() const
{
    static UTF8Converter _myconv("ISO-8859-1");
    return &_myconv;
}
