/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 *	 Parts of the code are taken from the xmms mgp123-Plugin by Espen Skoglund
 *   Code for swapEndian fuctions taken from glib.h
 * 
 * Filename:      id3tag.hpp
 * Description:   definition of the MP3 (ID3v2) tageditor class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/

#ifndef ID3TAG_HPP
#define ID3TAG_HPP

#include <map>
#include <string>
#include <iostream>
#include <fstream>
#include <sstream>

#include "libtagedit/tageditor.hpp"
#include "framedesc.hpp"
#include "id3frames.hpp"

using namespace std;

#define ID3_EHFLAG_CRC	0x80000000

// tag header flags
enum taghdrFlags {
	ID3_THFLAG_USYNC = 0x80000000,
	ID3_THFLAG_EXT   = 0x40000000,
	ID3_THFLAG_EXP   = 0x20000000,
};

//class SongInfo {
//    bool headCheck(unsigned long);
//    int decodeHeader(mp3info*, unsigned long);
//    double computeBpf(mp3info*);
//    double computeTpf(mp3info*);

class id3Tag: public TagEditor
{
public:
	// ctor: read tag from file
	id3Tag(const char*);
	// dtor
	~id3Tag();
    // get extension
    string extension() const 
    {
        return string("mp3");
    }
	int type()
	{
		if(hasID3v2)
			return 2;
		else if(hasID3v1)
			return 1;
		else
			return 0;
	}
	size_t sizeInFile() 
	{
		return id3_tagsize;
	}
	//overloaded from TagEditor
	int setField(FieldID, const string&);
    string getField(FieldID) const;
	int removeField(FieldID);
	bool fieldExists(FieldID ID) const
	{
        return (frames.find(frdesc.translateField(ID)) != frames.end());
    }
	int writeTag();
private:
	// current size of tag
	size_t tagsize();
	// write ID3-tag to stream
	void writeID3v2Tag(fstream&, int);
	// main function for reading tags
	void read();
	// read tagheader (if int = 0, read frames, too)
	bool readID3v2Tag();
	// read one frame from fstream
	void readID3Frame();
	// read given number of bytes from filestream into given or own buffer
	void* readFromID3(void*, size_t);
	// id3v1 reading
	bool readID3v1Tag();
	// fill id3v2 frame from id3v1 field
	void fillFrame(ID3FrameID, const char*, int);
	// allocate new frame by ID
	id3Frame* newFrame(ID3FrameID, id3_framehdr_t* = NULL);
    // read song length and bitrate from mp3 header
    void getSongInfo();
    // various functions taken from mpg123 and renamed them to look self-written
    bool headCheck(unsigned long);
    int decodeHeader(mp3info*, unsigned long);
    double computeBpf(mp3info*);
    double computeTpf(mp3info*);
	// compute new size of id3 tag
	size_t newSpace(size_t t) 
	{
		return (t+128);
	}
    
	// class-flags
	unsigned int id3_pos;
	bool hasID3v1;
	bool hasID3v2;
	
	// read from file
    int	id3_version;
    int id3_revision;
    int	id3_flags;
	unsigned int id3_tagsize;
    unsigned int id3_bufsize;
    
	char* id3_buf;
	fstream* file;
	FRAMEMAP frames;
};

#endif //ID3TAG_HPP
