/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 *	 Parts of the code are taken from the xmms mgp123-Plugin by Espen Skoglund
 *   
 * 
 * Filename:      id3frames.cpp
 * Description:   implementation of the frame classes used in the id3Tag class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "id3frames.hpp"
#include <sstream>


id3Frame::id3Frame(ID3FrameID ID)
{
    fr_desc = frdesc.getDescr(ID);
    fr_size = fr_encoding = fr_flags = 0;
    // for encoding
    offset = 1;
}

id3Frame::id3Frame(ID3FrameID ID, id3_framehdr_t* hdr)
{
    fr_desc = frdesc.getDescr(ID);
    fr_size = swapEndian(hdr->fh_size);
    fr_flags = swapEndian(hdr->fh_flags);
    offset = 1;
}

void id3Frame::fillHeader(id3_framehdr_t* hdr)
{
    fr_size = getSize();
    hdr->fh_id = swapEndian((uint32)fr_desc->fd_id);
    hdr->fh_size = swapEndian(fr_size);
    hdr->fh_flags = swapEndian(fr_flags);
}

size_t id3Frame::getSize() 
{
    prepareData();
    if(fr_data == "")
        return 0;
    else
        return fr_data.length() + offset;
}

const string& id3Frame::getContent()
{        
    if(fr_encoding == '\0') {
        uniconv->toUTF8(fr_content, fr_converted);
        return fr_converted;
    }
    return fr_content;
}

const char* id3Frame::getData()
{
    if(getSize() != 0) {
        fr_data.insert((string::size_type)0, (string::size_type)1, fr_encoding);
        fr_data.insert((unsigned int)1, (unsigned int)offset - 1, '\0');
        return fr_data.c_str();
    }
    return 0;
}


void id3Frame::setData(const char* p)
{
    if(fr_size != 0) {
        fr_encoding = p[0];
        // with prepareContent: assignment to fr_data, prepareContent call
        fr_content.assign(p + offset, fr_size - offset);
        fr_content.resize(fr_size - offset);
    }
}

UTF8Converter* id3Frame::uniconv;

void id3Frame::setConverter(UTF8Converter* _u)
{
    uniconv = _u;
}


void contentFrame::setData(const char* p)
{
    id3Frame::setData(p);
    fr_content = expandContent(fr_content);
}

string contentFrame::expandContent(const string& s)
{
    if(s[0] != '(' || s == "")
        return s;
    unsigned int n;
    stringstream num(s.substr(1, s.length() - 2));
    num >> n;
    if(n < frdesc.numGenres())
        return frdesc.id3Genres[n];
    return "";
}

void contentFrame::prepareData()
{
    stringstream str;
    for(unsigned int i = 0; i < frdesc.numGenres(); ++i) {
        if(fr_content == frdesc.id3Genres[i]) {
            str << "(" << i << ")";
            str >> fr_data;
            return;
        }
    }
    fr_data = fr_content;
}
