/*********************************************************************
 * 
 *   Copyright (C) 2001, 2002 Torsten Marek
 *	 Parts of the code are taken from the xmms mgp123-Plugin by Espen Skoglund
 *   
 * 
 * Filename:      id3base.hpp
 * Description:   basic types, structures and macros fr id3v2 tags
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/

#ifndef ID3BASE_HPP
#define ID3BASE_HPP

typedef signed char int8;
typedef unsigned char uint8;
typedef signed short int16;
typedef unsigned short uint16;
typedef signed int int32;
typedef unsigned int uint32;

uint32 swapEndian(uint32);
uint16 swapEndian(uint16);

#define ID3_SET_SIZE28(size) ( ((size << 3) & 0x7f000000) |	((size << 2) & 0x007f0000) | ((size << 1) & 0x00007f00) | (size & 0x0000007f) )
#define ID3_GET_SIZE28(size) ( ((size & 0x7f000000) >> 3) |	((size & 0x007f0000) >> 2) | ((size & 0x00007f00) >> 1) | (size & 0x0000007f) )


// ID3 tag header
struct id3_taghdr_t {
	uint8	th_version;
	uint8	th_revision;
	uint8	th_flags;
	uint32	th_size;
} __attribute__ ((packed));

// ID3 extended header (nyi)	
struct id3_exthdr_t {
	uint32	eh_size;
	uint16	eh_flags;
	uint32	eh_padsize;
} __attribute__ ((packed));

// ID3 frame header	
struct id3_framehdr_t 
{
	uint32	fh_id;
	uint32	fh_size;
	uint16	fh_flags;
} __attribute ((packed));

// ID3v1.1 structure
struct id3v1
{
	char t_tag[3];
	char t_title[30];
	char t_name[30];
	char t_album[30];
	char t_year[4];
	char t_comment[28];
	char t_null;
	unsigned char t_track;
	unsigned char t_genre;
} __attribute__ ((packed));

// definitions from mpg123 for reading mp3 headers
#define MAXFRAMESIZE 1792

struct mp3info
{
	int lsf;
	int mpeg25;
	int lay;
	int bitrate_index;
	int sampling_frequency;
	int padding;
	int framesize;		/* computed framesize */ 
};

const int tabsel_123[2][3][16] = {
{{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448,},
 {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384,},
 {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320,}},
{{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256,},
 {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160,},
 {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160,}}
};

const int mpg123_freqs[9] =
{44100, 48000, 32000, 22050, 24000, 16000, 11025, 12000, 8000};

#endif //ID3BASE_HPP
