/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      id3_if.cpp
 * Description:   libtagedit plugin interface for MP3
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#include "id3tag.hpp"
#include "libtagedit/libtagedit.hpp"

extern "C" {
	static TagEditor* createID3Editor(const char*);
	PluginInterface mp3 = {
		".mp3",
		createID3Editor
	};

	PluginInterface* getInfo() 
	{
		return &mp3;
	}
	static TagEditor* createID3Editor(const char* filename)
	{
		return new id3Tag(filename);
	}
}
