/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 *	 Parts of the code are taken from the xmms mgp123-Plugin by Espen Skoglund
 *   
 * 
 * Filename:      framedesc.hpp
 * Description:   definition of the id3v2 ids and the frame descriptor class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/

#ifndef FRAMEDESC_HPP
#define FRAMEDESC_HPP

#include <map>
#include <string>
#include <iostream>
#include <algorithm>
#include "libtagedit/tageditor.hpp"

using namespace std;

#define ID3_FRAME_ID(a,b,c,d)   ((a << 24) | (b << 16) | (c << 8) | d)

enum ID3FrameID {
	ID3_AENC = ID3_FRAME_ID('A','E','N','C'),
	ID3_APIC = ID3_FRAME_ID('A','P','I','C'),
	ID3_COMM = ID3_FRAME_ID('C','O','M','M'),
	ID3_COMR = ID3_FRAME_ID('C','O','M','R'),
	ID3_ENCR = ID3_FRAME_ID('E','N','C','R'),
	ID3_EQUA = ID3_FRAME_ID('E','Q','U','A'),
	ID3_ETCO = ID3_FRAME_ID('E','T','C','O'),
	ID3_GEOB = ID3_FRAME_ID('G','E','O','B'),
	ID3_GRID = ID3_FRAME_ID('G','R','I','D'),
	ID3_IPLS = ID3_FRAME_ID('I','P','L','S'),
	ID3_LINK = ID3_FRAME_ID('L','I','N','K'),
	ID3_MCDI = ID3_FRAME_ID('M','C','D','I'),

	ID3_MLLT = ID3_FRAME_ID('M','L','L','T'),
	ID3_OWNE = ID3_FRAME_ID('O','W','N','E'),
	ID3_PRIV = ID3_FRAME_ID('P','R','I','V'),
	ID3_PCNT = ID3_FRAME_ID('P','C','N','T'),
	ID3_POPM = ID3_FRAME_ID('P','O','P','M'),
	ID3_POSS = ID3_FRAME_ID('P','O','S','S'),
	ID3_RBUF = ID3_FRAME_ID('R','B','U','F'),
	ID3_RVAD = ID3_FRAME_ID('R','V','A','D'),
	ID3_RVRB = ID3_FRAME_ID('R','V','R','B'),
	ID3_SYLT = ID3_FRAME_ID('S','Y','L','T'),
	ID3_SYTC = ID3_FRAME_ID('S','Y','T','C'),
	ID3_TALB = ID3_FRAME_ID('T','A','L','B'),
	ID3_TBPM = ID3_FRAME_ID('T','B','P','M'),
	ID3_TCOM = ID3_FRAME_ID('T','C','O','M'),
	ID3_TCON = ID3_FRAME_ID('T','C','O','N'),
	ID3_TCOP = ID3_FRAME_ID('T','C','O','P'),
	ID3_TDAT = ID3_FRAME_ID('T','D','A','T'),
	ID3_TDLY = ID3_FRAME_ID('T','D','L','Y'),
	ID3_TENC = ID3_FRAME_ID('T','E','N','C'),
	ID3_TEXT = ID3_FRAME_ID('T','E','X','T'),
	ID3_TFLT = ID3_FRAME_ID('T','F','L','T'),
	ID3_TIME = ID3_FRAME_ID('T','I','M','E'),
	ID3_TIT1 = ID3_FRAME_ID('T','I','T','1'),
	ID3_TIT2 = ID3_FRAME_ID('T','I','T','2'),
	ID3_TIT3 = ID3_FRAME_ID('T','I','T','3'),
	ID3_TKEY = ID3_FRAME_ID('T','K','E','Y'),
	ID3_TLAN = ID3_FRAME_ID('T','L','A','N'),
	ID3_TLEN = ID3_FRAME_ID('T','L','E','N'),
	ID3_TMED = ID3_FRAME_ID('T','M','E','D'),
	ID3_TOAL = ID3_FRAME_ID('T','O','A','L'),
	ID3_TOFN = ID3_FRAME_ID('T','O','F','N'),
	ID3_TOLY = ID3_FRAME_ID('T','O','L','Y'),
	ID3_TOPE = ID3_FRAME_ID('T','O','P','E'),
	ID3_TORY = ID3_FRAME_ID('T','O','R','Y'),
	ID3_TOWN = ID3_FRAME_ID('T','O','W','N'),
	ID3_TPE1 = ID3_FRAME_ID('T','P','E','1'),
	ID3_TPE2 = ID3_FRAME_ID('T','P','E','2'),
	ID3_TPE3 = ID3_FRAME_ID('T','P','E','3'),
	ID3_TPE4 = ID3_FRAME_ID('T','P','E','4'),
	ID3_TPOS = ID3_FRAME_ID('T','P','O','S'),
	ID3_TPUB = ID3_FRAME_ID('T','P','U','B'),
	ID3_TRCK = ID3_FRAME_ID('T','R','C','K'),
	ID3_TRDA = ID3_FRAME_ID('T','R','D','A'),
	ID3_TRSN = ID3_FRAME_ID('T','R','S','N'),
	ID3_TRSO = ID3_FRAME_ID('T','R','S','O'),
	ID3_TSIZ = ID3_FRAME_ID('T','S','I','Z'),
	ID3_TSRC = ID3_FRAME_ID('T','S','R','C'),
	ID3_TSSE = ID3_FRAME_ID('T','S','S','E'),
	ID3_TYER = ID3_FRAME_ID('T','Y','E','R'),
	ID3_TXXX = ID3_FRAME_ID('T','X','X','X'),
	ID3_UFID = ID3_FRAME_ID('U','F','I','D'),
	ID3_USER = ID3_FRAME_ID('U','S','E','R'),
	ID3_USLT = ID3_FRAME_ID('U','S','L','T'),
	ID3_WCOM = ID3_FRAME_ID('W','C','O','M'),
	ID3_WCOP = ID3_FRAME_ID('W','C','O','P'),
	ID3_WOAF = ID3_FRAME_ID('W','O','A','F'),
	ID3_WOAR = ID3_FRAME_ID('W','O','A','R'),
	ID3_WOAS = ID3_FRAME_ID('W','O','A','S'),
	ID3_WORS = ID3_FRAME_ID('W','O','R','S'),
	ID3_WPAY = ID3_FRAME_ID('W','P','A','Y'),
	ID3_WPUB = ID3_FRAME_ID('W','P','U','B'),
	ID3_WXXX = ID3_FRAME_ID('W','X','X','X'),

    // new 2.4 frames
    ID3_ASPI = ID3_FRAME_ID('A','S','P','I'),
    ID3_EQU2 = ID3_FRAME_ID('E','Q','U','2'),
    ID3_RVA2 = ID3_FRAME_ID('R','V','A','2'),
    ID3_SEEK = ID3_FRAME_ID('S','E','E','K'),
    ID3_SIGN = ID3_FRAME_ID('S','I','G','N'),
    ID3_TDEN = ID3_FRAME_ID('T','D','E','N'),
    ID3_TDOR = ID3_FRAME_ID('T','D','O','R'),
    ID3_TDRC = ID3_FRAME_ID('T','D','R','C'),
    ID3_TDRL = ID3_FRAME_ID('T','D','R','L'),
    ID3_TDTG = ID3_FRAME_ID('T','D','T','G'),
    ID3_TIPL = ID3_FRAME_ID('T','I','P','L'),
    ID3_TMCL = ID3_FRAME_ID('T','M','C','L'),
    ID3_TMOO = ID3_FRAME_ID('T','M','O','O'),
    ID3_TPRO = ID3_FRAME_ID('T','P','R','O'),
    ID3_TSOA = ID3_FRAME_ID('T','S','O','A'),
    ID3_TSOP = ID3_FRAME_ID('T','S','O','P'),
    ID3_TSOT = ID3_FRAME_ID('T','S','O','T'),
    ID3_TSST = ID3_FRAME_ID('T','S','S','T')
};


struct id3Framedesc {
	ID3FrameID fd_id;
	char	fd_idstr[5];
	char	*fd_description;
};

typedef map<ID3FrameID, id3Framedesc> DESCMAP;

class frameDesc
{
public:
	frameDesc();
    void f(ID3FrameID, char*, char*);
    ID3FrameID checkID(ID3FrameID ID, bool* discard = NULL)
	{
		if(descmap.find(ID) != descmap.end()) {
            if(discard != NULL)
                *discard = false;
            switch(ID) {
                // discard this frames for ID3v2.4
            case ID3_EQUA:
            case ID3_RVAD:
            case ID3_TIME:
            case ID3_TRDA:
            case ID3_TSIZ:
                if(discard != NULL)
                    *discard = true;
                return ID;
                // convert frames
            case ID3_TDAT:
            case ID3_TYER:
                return ID3_TDRC;
            case ID3_TORY:
                return ID3_TDOR;
            default:
                return ID;
            }
        }
        else
			return (ID3FrameID)0;
	}
	const id3Framedesc* getDescr(ID3FrameID ID) 
	{
		if(checkID(ID) == -1)
			return NULL;
		DESCMAP::iterator it = descmap.find(ID);
		return &(it->second);
	}
	ID3FrameID translateField(FieldID);
	size_t numGenres();
	static char* id3Genres[];
private:
	DESCMAP descmap;
};

extern frameDesc frdesc;

#endif //FRAMEDESC_HPP
