/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  SBML converter to convert a model's units to SI units.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  It is a class used in
the implementation of extra functionality provided by libSBML.
</p>

 <p>
 * This SBML converter converts the units in a model to base SI units,
 * namely metre, kilogram, second, Ampere, Kelvin, mole and candela.
 <p>
 * {@link Unit} conversion will only be performed on models that are fully unit
 * consistent; that is, all objects have associated units, and there are no
 * literal numbers with no units specified.  In the case of an SBML
 * Level&nbsp;3 model involving math expressions, this means that the 
 * <code>timeUnits</code> attribute on the {@link Model} object must be set, and if there are
 * any reactions in the model, the <code>extentUnits</code> attribute on the {@link Model}
 * object must also be set.
 <p>
 * This converter has the additional Boolean property 'removeUnusedUnits'
 * that can be used to tell the converter whether to remove any
 * {@link UnitDefinition} objects that are not referred to, after conversion is
 * complete.  You can set this value by adding the property using
 * <div class='fragment'><pre class='fragment'>
prop.addOption('removeUnusedUnits', false);
</pre></div>
 * The converter's default behavior is to remove the unused
 * {@link UnitDefinition} objects in the model.
 <p>
 * @see SBMLFunctionDefinitionConverter
 * @see SBMLLevelVersionConverter
 * @see SBMLRuleConverter
 * @see SBMLStripPackageConverter
 * @see SBMLUnitsConverter
 */

public class SBMLUnitsConverter extends SBMLConverter {
   private long swigCPtr;

   protected SBMLUnitsConverter(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLUnitsConverter_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLUnitsConverter obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLUnitsConverter obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLUnitsConverter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  public static void init() {
    libsbmlJNI.SBMLUnitsConverter_init();
  }

  public SBMLUnitsConverter() {
    this(libsbmlJNI.new_SBMLUnitsConverter__SWIG_0(), true);
  }

  public SBMLUnitsConverter(SBMLUnitsConverter obj) {
    this(libsbmlJNI.new_SBMLUnitsConverter__SWIG_1(SBMLUnitsConverter.getCPtr(obj), obj), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link SBMLConverter} object.
   <p>
   * @return a (deep) copy of this {@link SBMLConverter} object.
   */ public
 SBMLConverter cloneObject() {
    long cPtr = libsbmlJNI.SBMLUnitsConverter_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLUnitsConverter(cPtr, true);
  }

  
/**
   * Predicate returning <code>true</code> if this converter's properties matches a
   * given set of configuration properties.
   <p>
   * @param props the configuration properties to match.
   <p>
   * @return <code>true</code> if this converter's properties match, <code>false</code>
   * otherwise.
   */ public
 boolean matchesProperties(ConversionProperties props) {
    return libsbmlJNI.SBMLUnitsConverter_matchesProperties(swigCPtr, this, ConversionProperties.getCPtr(props), props);
  }

  
/**
   * Perform the conversion.
   <p>
   * This method causes the converter to do the actual conversion work,
   * that is, to convert the {@link SBMLDocument} object set by
   * {@link SBMLConverter#setDocument(SBMLDocument doc)} and
   * with the configuration options set by
   * {@link SBMLConverter#setProperties(ConversionProperties props)}.
   <p>
   * @return  integer value indicating the success/failure of the operation.
   *  The set of possible values that may
   * be returned depends on the converter subclass; please consult
   * the documentation for the relevant class to find out what the
   * possibilities are.
   */ public
 int convert() {
    return libsbmlJNI.SBMLUnitsConverter_convert(swigCPtr, this);
  }

  
/**
   * Returns the default properties of this converter.
   <p>
   * A given converter exposes one or more properties that can be adjusted
   * in order to influence the behavior of the converter.  This method
   * returns the <em>default</em> property settings for this converter.  It is
   * meant to be called in order to discover all the settings for the
   * converter object.  The run-time properties of the converter object can
   * be adjusted by using the method
   * {@link SBMLConverter#setProperties(ConversionProperties props)}.
   <p>
   * @return the default properties for the converter.
   <p>
   * @see #setProperties(ConversionProperties props)
   * @see #matchesProperties(ConversionProperties props)
   */ public
 ConversionProperties getDefaultProperties() {
    return new ConversionProperties(libsbmlJNI.SBMLUnitsConverter_getDefaultProperties(swigCPtr, this), true);
  }

}
