/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Representation of errors, warnings and other diagnostics
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * When a libSBML operation on SBML content results in an error, or when
 * there is something wrong with the SBML content, the problems are
 * reported as {@link SBMLError} objects.  These are generally stored in an
 * {@link SBMLErrorLog} object; this log object, in turn, is kept in the
 * {@link SBMLDocument} object containing the SBML content.  Applications can
 * obtain the list of logged errors using {@link SBMLDocument#getErrorLog()} and
 * then use the methods provided by {@link SBMLErrorLog} to access individual
 * {@link SBMLError} objects.  (Note that despite the word 'error' in the name,
 * {@link SBMLError} objects are used to represent not only 'true' errors, but also
 * warnings and some informational diagnostics.  The name is a historical
 * hold-over from early versions of libSBML, in which the object really was
 * only used to report errors.)
 <p>
 * * Each {@link SBMLError} object instance has an identification number that
 * identifies the nature of the problem.  This 'error id' number will be up
 * to five digits long, and it will come from one of two sets of static
 * integer constants defined in the interface class <code><a
 * href='libsbmlConstants.html'> libsbmlConstants</a></code>: either the
 * SBML error identifiers <a class='el' href='#SBMLErrorCode_t'> (described
 * below)</a> or the XML error identifiers (described in the documentation
 * for the class <code><a href='XMLError.html'> {@link XMLError}</a></code>).  The
 * former set of constants includes all the SBML validation rule numbers
 * listed in the appendices of the SBML specification documents, as well as
 * some additional libSBML-specific error codes.
 <p>
 <p>
 * Error codes are useful mainly for software.  For human readers,
 * {@link SBMLError} also includes text messages that describe the nature of a
 * given problem.  The messages can be accessed using
 * {@link SBMLError#getShortMessage()} and {@link SBMLError#getMessage()}.  The former
 * provides a brief one-line description of the issue, while
 * {@link SBMLError#getMessage()} provides a more detailed text, including (if
 * appropriate) references to sections of the SBML specifications where
 * relevant topics are discussed.  These text strings are suitable for
 * displaying to human users.
 <p>
 * * An {@link SBMLError} object also contains a category code; its value may be
 * retrieved using the method {@link SBMLError#getCategory()}.  Category values
 * are drawn from a set of static integer constants
 * defined in <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>,
 * and having names beginning with the characters
 * <code>LIBSBML_CAT_</code>.  The list of possible codes is described in a
 * separate section below.  Categories are used to partition errors into
 * distinct conceptual groups.  This is principally used by the libSBML
 * validation system to group classes of validation checks.  For example,
 * {@link  libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}
 * is the category for tests that check identifier consistency;
 * {@link  libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}
 * is the category for MathML consistency checking; and
 * so on.
 <p>
 <p>
 * In addition, {@link SBMLError} also has a severity code.  Its value may be
 * retrieved using the method {@link SBMLError#getSeverity()}.  The possible
 * severity values are the same as those reported by <code><a href='XMLError.html'>XMLError</a></code>. 
 * Severity levels currently range from informational
 * ({@link  libsbmlConstants#LIBSBML_SEV_INFO LIBSBML_SEV_INFO})
 * to fatal errors
 * ({@link  libsbmlConstants#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL}).
 * They can be
 * used by an application to evaluate how serious a given problem
 * is. 
 <p>
 * Finally, {@link SBMLError} records the line and column near where the problem
 * occurred in the SBML content.  The values may be retrieved using the
 * methods {@link SBMLError#getLine()} and {@link SBMLError#getColumn()}.  We say 'near',
 * because a lot of factors affect how accurate the line/column information
 * ultimately is.  For example, different XML parsers have different
 * conventions for which line and column number they report for a
 * particular problem (which makes a difference when a problem involves an
 * opening XML tag on one line and a closing tag on another line).  In some
 * situations, some parsers report invalid line and/or column numbers
 * altogether.  If this occurs, libSBML sets the line and/or column number
 * in the {@link SBMLError} object to the the value of the maximum unsigned long
 * integer representable on the platform where libSBML is running.  (This
 * is equal to the constant named <code>ULONG_MAX</code> in C and C++.)
 * The probability that a true line or column number in an SBML model would
 * equal this value is vanishingly small; thus, if an application
 * encounters these values in an {@link XMLError} object, it can assume no valid
 * line/column number could be provided by libSBML in that situation.
 <p>
 * <h3><a class='anchor' 
 * name='SBMLErrorCode_t'>Error codes associated with {@link SBMLError} objects</a></h3>
 <p>
 * The error and warning codes returned by libSBML are listed in the table
 * below.  The method {@link SBMLError#getErrorId()} returns the error code of a
 * given {@link SBMLError} object instance.  In the libSBML Java language
 * interface, these error identifiers are currently
 * implemented as static integer constants defined in the interface class
 * <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the error identifiers.
 <p>
 * In this table, the right-hand columns titled 'L1V1', 'L1V2', etc. refer
 * to Levels and Versions of the SBML specifications, and the entries in
 * each column refer to whether the severity of the condition in that
 * particular Level+Version of SBML.  The codes stand for the following:
 <p>
 <p>
 <p>
 * <table cellspacing='1' cellpadding='2' border='0' class='normal-font'>
 * <tr><td class='s-na'>N</td><td>= Not applicable</td></tr>
 * <tr><td class='s-info'>I</td><td>= Informational</td></tr>
 * <tr><td class='s-warning'>W</td><td>= Warning</td></tr>
 * <tr><td class='s-error'>E</td><td>= Error</td></tr>
 * <tr><td class='s-fatal'>F</td><td>= Fatal</td></tr>
 * </table>
 <p>
 * The text shown in the 'Meaning' is the text returned by the
 * {@link SBMLError#getShortMessage()} method on a given {@link SBMLError} object.  A
 * longer and (hopefully) clearer explanation of the issue is returned by
 * {@link SBMLError#getMessage()}.
 <p>
 * The error codes come from different lists depending on whether they're
 * from libSBML core or from an SBML Level&nbsp;3 package extension.
 <p>
 * However, in the language interfaces other than C++, all
 * libSBML error codes are ultimately represented as integer constants rather
 * than separate enumerations lists, and they are all stored in a single
 * interface class.  Codes from different libSBML extensions have names that
 * begin with the package's nickname, such as <code>Qual</code> for
 * the Qualitative Models package, <code>Layout</code> for the {@link Layout}
 * package, and so on.  If the name of a code does not begin with one of
 * the package nicknames (<code>%Layout</code>, <code>Fbc</code>,
 * <code>Comp</code>, <code>Qual</code>, etc.), then it is a code
 * from libSBML core.
 <p>
 * <p>
<table width='95%' cellspacing='1' cellpadding='2' border='0'
       class='centered text-table small-font alt-row-colors'>
 <tr style='background: lightgray' class='normal-font'>
     <th valign='bottom'><strong>Enumerator</strong></th>
     <th valign='bottom'><strong>Meaning</strong></th>
     <th align='center' width='15'>L 1 V 1</th>
     <th align='center' width='15'>L 1 V 2</th>
     <th align='center' width='15'>L 2 V 1</th>
     <th align='center' width='15'>L 2 V 2</th>
     <th align='center' width='15'>L 2 V 3</th>
     <th align='center' width='15'>L 2 V 4</th>
     <th align='center' width='15'>L 3 V 1</th>
 </tr>
<tr><td><code>{@link  libsbmlConstants#UnknownError UnknownError }</code></td>
<td>Encountered unknown internal libSBML error</td>
<td class='s-fatal'>F</td>
<td class='s-fatal'>F</td>
<td class='s-fatal'>F</td>
<td class='s-fatal'>F</td>
<td class='s-fatal'>F</td>
<td class='s-fatal'>F</td>
<td class='s-fatal'>F</td></tr>
<tr><td><code>{@link  libsbmlConstants#NotUTF8 NotUTF8 }</code></td>
<td>File does not use UTF-8 encoding</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#UnrecognizedElement UnrecognizedElement }</code></td>
<td>Encountered unrecognized element</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NotSchemaConformant NotSchemaConformant }</code></td>
<td>Document does not conform to the SBML XML schema</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3NotSchemaConformant L3NotSchemaConformant }</code></td>
<td>Document is not well-formed XML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidMathElement InvalidMathElement }</code></td>
<td>Invalid MathML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DisallowedMathMLSymbol DisallowedMathMLSymbol }</code></td>
<td>Disallowed MathML symbol found</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DisallowedMathMLEncodingUse DisallowedMathMLEncodingUse }</code></td>
<td>Use of the MathML 'encoding' attribute is not allowed on this element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DisallowedDefinitionURLUse DisallowedDefinitionURLUse }</code></td>
<td>Use of the MathML 'definitionURL' attribute is not allowed on this element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#BadCsymbolDefinitionURLValue BadCsymbolDefinitionURLValue }</code></td>
<td>Invalid <code>&lt;csymbol&gt;</code> 'definitionURL' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DisallowedMathTypeAttributeUse DisallowedMathTypeAttributeUse }</code></td>
<td>Use of the MathML 'type' attribute is not allowed on this element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DisallowedMathTypeAttributeValue DisallowedMathTypeAttributeValue }</code></td>
<td>Disallowed MathML 'type' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LambdaOnlyAllowedInFunctionDef LambdaOnlyAllowedInFunctionDef }</code></td>
<td>Use of <code>&lt;lambda&gt;</code> not permitted outside of {@link FunctionDefinition} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#BooleanOpsNeedBooleanArgs BooleanOpsNeedBooleanArgs }</code></td>
<td>Non-Boolean argument given to Boolean operator</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NumericOpsNeedNumericArgs NumericOpsNeedNumericArgs }</code></td>
<td>Non-numerical argument given to numerical operator</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ArgsToEqNeedSameType ArgsToEqNeedSameType }</code></td>
<td>Arguments to <code>&lt;eq&gt;</code> and <code>&lt;neq&gt;</code> must have the same data types</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#PiecewiseNeedsConsistentTypes PiecewiseNeedsConsistentTypes }</code></td>
<td>Terms in a <code>&lt;piecewise&gt;</code> expression must have consistent data types</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#PieceNeedsBoolean PieceNeedsBoolean }</code></td>
<td>The second argument of a <code>&lt;piece&gt;</code> expression must yield a Boolean value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ApplyCiMustBeUserFunction ApplyCiMustBeUserFunction }</code></td>
<td>A <code>&lt;ci&gt;</code> element in this context must refer to a function definition</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ApplyCiMustBeModelComponent ApplyCiMustBeModelComponent }</code></td>
<td>A <code>&lt;ci&gt;</code> element in this context must refer to a model component</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#KineticLawParametersAreLocalOnly KineticLawParametersAreLocalOnly }</code></td>
<td>Cannot use a {@link KineticLaw} local parameter outside of its local scope</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MathResultMustBeNumeric MathResultMustBeNumeric }</code></td>
<td>A formula's result in this context must be a numerical value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OpsNeedCorrectNumberOfArgs OpsNeedCorrectNumberOfArgs }</code></td>
<td>Incorrect number of arguments given to MathML operator</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidNoArgsPassedToFunctionDef InvalidNoArgsPassedToFunctionDef }</code></td>
<td>Incorrect number of arguments given to function invocation</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DisallowedMathUnitsUse DisallowedMathUnitsUse }</code></td>
<td>Attribute 'units' is only permitted on <code>&lt;cn&gt;</code> elements</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidUnitsValue InvalidUnitsValue }</code></td>
<td>Invalid value given for the 'units' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateComponentId DuplicateComponentId }</code></td>
<td>Duplicate 'id' attribute value</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateUnitDefinitionId DuplicateUnitDefinitionId }</code></td>
<td>Duplicate unit definition 'id' attribute value</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateLocalParameterId DuplicateLocalParameterId }</code></td>
<td>Duplicate local parameter 'id' attribute value</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MultipleAssignmentOrRateRules MultipleAssignmentOrRateRules }</code></td>
<td>Multiple rules for the same variable are not allowed</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MultipleEventAssignmentsForId MultipleEventAssignmentsForId }</code></td>
<td>Multiple event assignments for the same variable are not allowed</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventAndAssignmentRuleForId EventAndAssignmentRuleForId }</code></td>
<td>An event assignment and an assignment rule must not have the same value for 'variable'</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateMetaId DuplicateMetaId }</code></td>
<td>Duplicate 'metaid' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSBOTermSyntax InvalidSBOTermSyntax }</code></td>
<td>Invalid syntax for an 'sboTerm' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidMetaidSyntax InvalidMetaidSyntax }</code></td>
<td>Invalid syntax for a 'metaid' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidIdSyntax InvalidIdSyntax }</code></td>
<td>Invalid syntax for an 'id' attribute value</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidUnitIdSyntax InvalidUnitIdSyntax }</code></td>
<td>Invalid syntax for the identifier of a unit</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidNameSyntax InvalidNameSyntax }</code></td>
<td>Invalid syntax for a 'name' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingAnnotationNamespace MissingAnnotationNamespace }</code></td>
<td>Missing declaration of the XML namespace for the annotation</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateAnnotationNamespaces DuplicateAnnotationNamespaces }</code></td>
<td>Multiple annotations using the same XML namespace</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#SBMLNamespaceInAnnotation SBMLNamespaceInAnnotation }</code></td>
<td>The SBML XML namespace cannot be used in an Annotation object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#MultipleAnnotations MultipleAnnotations }</code></td>
<td>Only one Annotation object is permitted under a given SBML object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InconsistentArgUnits InconsistentArgUnits }</code></td>
<td>The units of the function call's arguments are not consistent with its definition</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InconsistentKineticLawUnitsL3 InconsistentKineticLawUnitsL3 }</code></td>
<td>The kinetic law's units are inconsistent with those of other kinetic laws in the model</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AssignRuleCompartmentMismatch AssignRuleCompartmentMismatch }</code></td>
<td>Mismatched units in assignment rule for compartment</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AssignRuleSpeciesMismatch AssignRuleSpeciesMismatch }</code></td>
<td>Mismatched units in assignment rule for species</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AssignRuleParameterMismatch AssignRuleParameterMismatch }</code></td>
<td>Mismatched units in assignment rule for parameter</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AssignRuleStoichiometryMismatch AssignRuleStoichiometryMismatch }</code></td>
<td>Mismatched units in assignment rule for stoichiometry</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitAssignCompartmenMismatch InitAssignCompartmenMismatch }</code></td>
<td>Mismatched units in initial assignment to compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitAssignSpeciesMismatch InitAssignSpeciesMismatch }</code></td>
<td>Mismatched units in initial assignment to species</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitAssignParameterMismatch InitAssignParameterMismatch }</code></td>
<td>Mismatched units in initial assignment to parameter</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitAssignStoichiometryMismatch InitAssignStoichiometryMismatch }</code></td>
<td>Mismatched units in initial assignment to stoichiometry</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RateRuleCompartmentMismatch RateRuleCompartmentMismatch }</code></td>
<td>Mismatched units in rate rule for compartment</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RateRuleSpeciesMismatch RateRuleSpeciesMismatch }</code></td>
<td>Mismatched units in rate rule for species</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RateRuleParameterMismatch RateRuleParameterMismatch }</code></td>
<td>Mismatched units in rate rule for parameter</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RateRuleStoichiometryMismatch RateRuleStoichiometryMismatch }</code></td>
<td>Mismatched units in rate rule for stoichiometry</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#KineticLawNotSubstancePerTime KineticLawNotSubstancePerTime }</code></td>
<td>The units of the kinetic law are not 'substance'/'time'</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpeciesInvalidExtentUnits SpeciesInvalidExtentUnits }</code></td>
<td>The species' units are not consistent with units of extent</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#DelayUnitsNotTime DelayUnitsNotTime }</code></td>
<td>The units of the delay expression are not units of time</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventAssignCompartmentMismatch EventAssignCompartmentMismatch }</code></td>
<td>Mismatched units in event assignment for compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventAssignSpeciesMismatch EventAssignSpeciesMismatch }</code></td>
<td>Mismatched units in event assignment for species</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventAssignParameterMismatch EventAssignParameterMismatch }</code></td>
<td>Mismatched units in event assignment for parameter</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventAssignStoichiometryMismatch EventAssignStoichiometryMismatch }</code></td>
<td>Mismatched units in event assignment for stoichiometry</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#PriorityUnitsNotDimensionless PriorityUnitsNotDimensionless }</code></td>
<td>The units of a priority expression must be 'dimensionless'</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#UpperUnitBound UpperUnitBound }</code></td>
<td>Upper boundary of unit validation diagnostic codes</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OverdeterminedSystem OverdeterminedSystem }</code></td>
<td>The model is overdetermined</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidModelSBOTerm InvalidModelSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Model} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidFunctionDefSBOTerm InvalidFunctionDefSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link FunctionDefinition} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidParameterSBOTerm InvalidParameterSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Parameter} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidInitAssignSBOTerm InvalidInitAssignSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for an {@link InitialAssignment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidRuleSBOTerm InvalidRuleSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Rule} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidConstraintSBOTerm InvalidConstraintSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Constraint} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidReactionSBOTerm InvalidReactionSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Reaction} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesReferenceSBOTerm InvalidSpeciesReferenceSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link SpeciesReference} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidKineticLawSBOTerm InvalidKineticLawSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link KineticLaw} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidEventSBOTerm InvalidEventSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for an {@link Event} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidEventAssignmentSBOTerm InvalidEventAssignmentSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for an {@link EventAssignment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidCompartmentSBOTerm InvalidCompartmentSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Compartment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesSBOTerm InvalidSpeciesSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link Species} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidCompartmentTypeSBOTerm InvalidCompartmentTypeSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link CompartmentType} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesTypeSBOTerm InvalidSpeciesTypeSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for a {@link SpeciesType} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidTriggerSBOTerm InvalidTriggerSBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for an {@link Event} Trigger object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidDelaySBOTerm InvalidDelaySBOTerm }</code></td>
<td>Invalid 'sboTerm' attribute value for an {@link Event} Delay object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NotesNotInXHTMLNamespace NotesNotInXHTMLNamespace }</code></td>
<td>Notes must be placed in the XHTML XML namespace</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NotesContainsXMLDecl NotesContainsXMLDecl }</code></td>
<td>XML declarations are not permitted in Notes objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NotesContainsDOCTYPE NotesContainsDOCTYPE }</code></td>
<td>XML DOCTYPE elements are not permitted in Notes objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidNotesContent InvalidNotesContent }</code></td>
<td>Invalid notes content found</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyOneNotesElementAllowed OnlyOneNotesElementAllowed }</code></td>
<td>Only one Notes subobject is permitted on a given SBML object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidNamespaceOnSBML InvalidNamespaceOnSBML }</code></td>
<td>Invalid XML namespace for the SBML container element</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingOrInconsistentLevel MissingOrInconsistentLevel }</code></td>
<td>Missing or inconsistent value for the 'level' attribute</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingOrInconsistentVersion MissingOrInconsistentVersion }</code></td>
<td>Missing or inconsistent value for the 'version' attribute</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#PackageNSMustMatch PackageNSMustMatch }</code></td>
<td>Inconsistent or invalid SBML Level/Version for the package namespace declaration</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LevelPositiveInteger LevelPositiveInteger }</code></td>
<td>The 'level' attribute must have a positive integer value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#VersionPositiveInteger VersionPositiveInteger }</code></td>
<td>The 'version' attribute must have a positive integer value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnSBML AllowedAttributesOnSBML }</code></td>
<td>Invalid attribute found on the SBML container element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3PackageOnLowerSBML L3PackageOnLowerSBML }</code></td>
<td>An L3 package ns found on the SBML container element.</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingModel MissingModel }</code></td>
<td>No model definition found</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#IncorrectOrderInModel IncorrectOrderInModel }</code></td>
<td>Incorrect ordering of components within the {@link Model} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#EmptyListElement EmptyListElement }</code></td>
<td>Empty ListOf___ object found</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NeedCompartmentIfHaveSpecies NeedCompartmentIfHaveSpecies }</code></td>
<td>The presence of a species requires a compartment</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneOfEachListOf OneOfEachListOf }</code></td>
<td>Only one of each kind of ListOf___ object is allowed inside a {@link Model} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyFuncDefsInListOfFuncDefs OnlyFuncDefsInListOfFuncDefs }</code></td>
<td>Only {@link FunctionDefinition}, Notes and Annotation objects are allowed in {@link ListOfFunctionDefinitions}</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyUnitDefsInListOfUnitDefs OnlyUnitDefsInListOfUnitDefs }</code></td>
<td>Only {@link UnitDefinition}, Notes and Annotation objects are allowed in {@link ListOfUnitDefinitions} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyCompartmentsInListOfCompartments OnlyCompartmentsInListOfCompartments }</code></td>
<td>Only {@link Compartment}, Notes and Annotation objects are allowed in {@link ListOfCompartments} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlySpeciesInListOfSpecies OnlySpeciesInListOfSpecies }</code></td>
<td>Only {@link Species}, Notes and Annotation objects are allowed in {@link ListOfSpecies} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyParametersInListOfParameters OnlyParametersInListOfParameters }</code></td>
<td>Only {@link Parameter}, Notes and Annotation objects are allowed in {@link ListOfParameters} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyInitAssignsInListOfInitAssigns OnlyInitAssignsInListOfInitAssigns }</code></td>
<td>Only {@link InitialAssignment}, Notes and Annotation objects are allowed in {@link ListOfInitialAssignments} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyRulesInListOfRules OnlyRulesInListOfRules }</code></td>
<td>Only {@link Rule}, Notes and Annotation objects are allowed in {@link ListOfRules} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyConstraintsInListOfConstraints OnlyConstraintsInListOfConstraints }</code></td>
<td>Only {@link Constraint}, Notes and Annotation objects are allowed in {@link ListOfConstraints} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyReactionsInListOfReactions OnlyReactionsInListOfReactions }</code></td>
<td>Only {@link Reaction}, Notes and Annotation objects are allowed in {@link ListOfReactions} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyEventsInListOfEvents OnlyEventsInListOfEvents }</code></td>
<td>Only {@link Event}, Notes and Annotation objects are allowed in {@link ListOfEvents} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3ConversionFactorOnModel L3ConversionFactorOnModel }</code></td>
<td>A 'conversionFactor' attribute value must reference a {@link Parameter} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3TimeUnitsOnModel L3TimeUnitsOnModel }</code></td>
<td>Invalid 'timeUnits' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3VolumeUnitsOnModel L3VolumeUnitsOnModel }</code></td>
<td>Invalid 'volumeUnits' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3AreaUnitsOnModel L3AreaUnitsOnModel }</code></td>
<td>Invalid 'areaUnits' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3LengthUnitsOnModel L3LengthUnitsOnModel }</code></td>
<td>Invalid 'lengthUnits' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3ExtentUnitsOnModel L3ExtentUnitsOnModel }</code></td>
<td>Invalid 'extentUnits' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnModel AllowedAttributesOnModel }</code></td>
<td>Invalid attribute found on the {@link Model} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfFuncs AllowedAttributesOnListOfFuncs }</code></td>
<td>Invalid attribute found on the {@link ListOfFunctionDefinitions} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfUnitDefs AllowedAttributesOnListOfUnitDefs }</code></td>
<td>Invalid attribute found on the {@link ListOfUnitDefinitions} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfComps AllowedAttributesOnListOfComps }</code></td>
<td>Invalid attribute found on the {@link ListOfCompartments} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfSpecies AllowedAttributesOnListOfSpecies }</code></td>
<td>Invalid attribute found on the {@link ListOfSpecies} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfParams AllowedAttributesOnListOfParams }</code></td>
<td>Invalid attribute found on the {@link ListOfParameters} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfInitAssign AllowedAttributesOnListOfInitAssign }</code></td>
<td>Invalid attribute found on the {@link ListOfInitialAssignments} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfRules AllowedAttributesOnListOfRules }</code></td>
<td>Invalid attribute found on the {@link ListOfRules} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfConstraints AllowedAttributesOnListOfConstraints }</code></td>
<td>Invalid attribute found on the {@link ListOfConstraints} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfReactions AllowedAttributesOnListOfReactions }</code></td>
<td>Invalid attribute found on the {@link ListOfReactions} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfEvents AllowedAttributesOnListOfEvents }</code></td>
<td>Invalid attribute found on the {@link ListOfEvents} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FunctionDefMathNotLambda FunctionDefMathNotLambda }</code></td>
<td>Invalid expression found in the function definition</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidApplyCiInLambda InvalidApplyCiInLambda }</code></td>
<td>Invalid forward reference in the MathML <code>&lt;apply&gt;</code><code>&lt;ci&gt;</code>...<code>&lt;/ci&gt;</code><code>&lt;/apply&gt;</code> expression</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#RecursiveFunctionDefinition RecursiveFunctionDefinition }</code></td>
<td>Recursive function definitions are not permitted</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidCiInLambda InvalidCiInLambda }</code></td>
<td>Invalid <code>&lt;ci&gt;</code> reference found inside the <code>&lt;lambda&gt;</code> mathematical formula</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidFunctionDefReturnType InvalidFunctionDefReturnType }</code></td>
<td>A function's return type must be either a number or a Boolean</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathElementPerFunc OneMathElementPerFunc }</code></td>
<td>A {@link FunctionDefinition} object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnFunc AllowedAttributesOnFunc }</code></td>
<td>Invalid attribute found on the {@link FunctionDefinition} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidUnitDefId InvalidUnitDefId }</code></td>
<td>Invalid 'id' attribute value for a {@link UnitDefinition} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSubstanceRedefinition InvalidSubstanceRedefinition }</code></td>
<td>Invalid redefinition of built-in type 'substance'</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidLengthRedefinition InvalidLengthRedefinition }</code></td>
<td>Invalid redefinition of built-in type 'length'</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidAreaRedefinition InvalidAreaRedefinition }</code></td>
<td>Invalid redefinition of built-in type name 'area'</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidTimeRedefinition InvalidTimeRedefinition }</code></td>
<td>Invalid redefinition of built-in type name 'time'</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidVolumeRedefinition InvalidVolumeRedefinition }</code></td>
<td>Invalid redefinition of built-in type name 'volume'</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#VolumeLitreDefExponentNotOne VolumeLitreDefExponentNotOne }</code></td>
<td>Must use 'exponent'=1 when defining 'volume' in terms of litres</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#VolumeMetreDefExponentNot3 VolumeMetreDefExponentNot3 }</code></td>
<td>Must use 'exponent'=3 when defining 'volume' in terms of metres</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#EmptyListOfUnits EmptyListOfUnits }</code></td>
<td>An empty list of {@link Unit} objects is not permitted in a {@link UnitDefinition} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidUnitKind InvalidUnitKind }</code></td>
<td>Invalid value for the 'kind' attribute of a {@link UnitDefinition} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OffsetNoLongerValid OffsetNoLongerValid }</code></td>
<td>Unit attribute 'offset' is not supported in this Level+Version of SBML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#CelsiusNoLongerValid CelsiusNoLongerValid }</code></td>
<td>Unit name 'Celsius' is not defined in this Level+Version of SBML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#EmptyUnitListElement EmptyUnitListElement }</code></td>
<td>A {@link ListOfUnits} object must not be empty</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneListOfUnitsPerUnitDef OneListOfUnitsPerUnitDef }</code></td>
<td>At most one {@link ListOfUnits} object is allowed inside a {@link UnitDefinition} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyUnitsInListOfUnits OnlyUnitsInListOfUnits }</code></td>
<td>Only {@link Unit}, Notes and Annotation objects are allowed in {@link ListOfUnits} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnUnitDefinition AllowedAttributesOnUnitDefinition }</code></td>
<td>Invalid attribute found on the {@link UnitDefinition} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfUnits AllowedAttributesOnListOfUnits }</code></td>
<td>Invalid attribute found on the {@link ListOfUnits} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnUnit AllowedAttributesOnUnit }</code></td>
<td>Invalid attribute found on the {@link Unit} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ZeroDimensionalCompartmentSize ZeroDimensionalCompartmentSize }</code></td>
<td>Invalid use of the 'size' attribute for a zero-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ZeroDimensionalCompartmentUnits ZeroDimensionalCompartmentUnits }</code></td>
<td>Invalid use of the 'units' attribute for a zero-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ZeroDimensionalCompartmentConst ZeroDimensionalCompartmentConst }</code></td>
<td>Zero-dimensional compartments must be defined to be constant</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndefinedOutsideCompartment UndefinedOutsideCompartment }</code></td>
<td>Invalid value for the 'outside' attribute of a {@link Compartment} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#RecursiveCompartmentContainment RecursiveCompartmentContainment }</code></td>
<td>Recursive nesting of compartments via the 'outside' attribute is not permitted</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ZeroDCompartmentContainment ZeroDCompartmentContainment }</code></td>
<td>Invalid nesting of zero-dimensional compartments</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#Invalid1DCompartmentUnits Invalid1DCompartmentUnits }</code></td>
<td>Invalid value for the 'units' attribute of a one-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#Invalid2DCompartmentUnits Invalid2DCompartmentUnits }</code></td>
<td>Invalid value for the 'units' attribute of a two-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#Invalid3DCompartmentUnits Invalid3DCompartmentUnits }</code></td>
<td>Invalid value for the 'units' attribute of a three-dimensional compartment</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidCompartmentTypeRef InvalidCompartmentTypeRef }</code></td>
<td>Invalid value for the 'compartmentType' attribute of a compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneDimensionalCompartmentUnits OneDimensionalCompartmentUnits }</code></td>
<td>No units defined for 1-D compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#TwoDimensionalCompartmentUnits TwoDimensionalCompartmentUnits }</code></td>
<td>No units defined for 2-D compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ThreeDimensionalCompartmentUnits ThreeDimensionalCompartmentUnits }</code></td>
<td>No units defined for 3-D {@link Compartment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnCompartment AllowedAttributesOnCompartment }</code></td>
<td>Invalid attribute found on {@link Compartment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoUnitsOnCompartment NoUnitsOnCompartment }</code></td>
<td>No units defined for {@link Compartment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesCompartmentRef InvalidSpeciesCompartmentRef }</code></td>
<td>Invalid value found for {@link Species} 'compartment' attribute</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#HasOnlySubsNoSpatialUnits HasOnlySubsNoSpatialUnits }</code></td>
<td>Attribute 'spatialSizeUnits' must not be set if 'hasOnlySubstanceUnits'='true'</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpatialUnitsInZeroD NoSpatialUnitsInZeroD }</code></td>
<td>Attribute 'spatialSizeUnits' must not be set if the compartment is zero-dimensional</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoConcentrationInZeroD NoConcentrationInZeroD }</code></td>
<td>Attribute 'initialConcentration' must not be set if the compartment is zero-dimensional</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpatialUnitsInOneD SpatialUnitsInOneD }</code></td>
<td>Invalid value for 'spatialSizeUnits' attribute of a one-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpatialUnitsInTwoD SpatialUnitsInTwoD }</code></td>
<td>Invalid value for the 'spatialSizeUnits' attribute of a two-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpatialUnitsInThreeD SpatialUnitsInThreeD }</code></td>
<td>Invalid value for the 'spatialSizeUnits' attribute of a three-dimensional compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesSusbstanceUnits InvalidSpeciesSusbstanceUnits }</code></td>
<td>Invalid value for a {@link Species} 'units' attribute</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#BothAmountAndConcentrationSet BothAmountAndConcentrationSet }</code></td>
<td>Cannot set both 'initialConcentration' and 'initialAmount' attributes simultaneously</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NonBoundarySpeciesAssignedAndUsed NonBoundarySpeciesAssignedAndUsed }</code></td>
<td>Cannot use a non-boundary species in both reactions and rules simultaneously</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NonConstantSpeciesUsed NonConstantSpeciesUsed }</code></td>
<td>Cannot use a constant, non-boundary species as a reactant or product</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesTypeRef InvalidSpeciesTypeRef }</code></td>
<td>Invalid value for the 'speciesType' attribute of a species</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#MultSpeciesSameTypeInCompartment MultSpeciesSameTypeInCompartment }</code></td>
<td>Cannot have multiple species of the same species type in the same compartment</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingSpeciesCompartment MissingSpeciesCompartment }</code></td>
<td>Missing value for the 'compartment' attribute</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpatialSizeUnitsRemoved SpatialSizeUnitsRemoved }</code></td>
<td>Attribute 'spatialSizeUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SubstanceUnitsOnSpecies SubstanceUnitsOnSpecies }</code></td>
<td>No substance units defined for the species</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConversionFactorOnSpecies ConversionFactorOnSpecies }</code></td>
<td>Invalid value for the 'conversionFactor' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnSpecies AllowedAttributesOnSpecies }</code></td>
<td>Invalid attribute found on {@link Species} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidParameterUnits InvalidParameterUnits }</code></td>
<td>Invalid value for the 'units' attribute of a {@link Parameter} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ParameterUnits ParameterUnits }</code></td>
<td>No units defined for the parameter</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConversionFactorMustConstant ConversionFactorMustConstant }</code></td>
<td>A conversion factor must reference a {@link Parameter} object declared to be a constant</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnParameter AllowedAttributesOnParameter }</code></td>
<td>Invalid attribute found on {@link Parameter} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidInitAssignSymbol InvalidInitAssignSymbol }</code></td>
<td>Invalid value for the 'symbol' attribute of an {@link InitialAssignment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MultipleInitAssignments MultipleInitAssignments }</code></td>
<td>Multiple initial assignments for the same 'symbol' value are not allowed</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitAssignmentAndRuleForSameId InitAssignmentAndRuleForSameId }</code></td>
<td>Cannot set a value using both an initial assignment and an assignment rule simultaneously</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathElementPerInitialAssign OneMathElementPerInitialAssign }</code></td>
<td>An {@link InitialAssignment} object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnInitialAssign AllowedAttributesOnInitialAssign }</code></td>
<td>Invalid attribute found on an {@link InitialAssignment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidAssignRuleVariable InvalidAssignRuleVariable }</code></td>
<td>Invalid value for the 'variable' attribute of an {@link AssignmentRule} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidRateRuleVariable InvalidRateRuleVariable }</code></td>
<td>Invalid value for the 'variable' attribute of a {@link RateRule} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AssignmentToConstantEntity AssignmentToConstantEntity }</code></td>
<td>An assignment rule cannot assign an entity declared to be constant</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#RateRuleForConstantEntity RateRuleForConstantEntity }</code></td>
<td>A rate rule cannot assign an entity declared to be constant</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CircularRuleDependency CircularRuleDependency }</code></td>
<td>Circular dependencies involving rules and reactions are not permitted</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathElementPerRule OneMathElementPerRule }</code></td>
<td>A rule object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnAssignRule AllowedAttributesOnAssignRule }</code></td>
<td>Invalid attribute found on an {@link AssignmentRule} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnRateRule AllowedAttributesOnRateRule }</code></td>
<td>Invalid attribute found on a {@link RateRule} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnAlgRule AllowedAttributesOnAlgRule }</code></td>
<td>Invalid attribute found on an {@link AlgebraicRule} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstraintMathNotBoolean ConstraintMathNotBoolean }</code></td>
<td>A {@link Constraint} object's <code>&lt;math&gt;</code> must evaluate to a Boolean value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#IncorrectOrderInConstraint IncorrectOrderInConstraint }</code></td>
<td>Subobjects inside the {@link Constraint} object are not in the prescribed order</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstraintNotInXHTMLNamespace ConstraintNotInXHTMLNamespace }</code></td>
<td>A {@link Constraint}'s Message subobject must be in the XHTML XML namespace</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstraintContainsXMLDecl ConstraintContainsXMLDecl }</code></td>
<td>XML declarations are not permitted within {@link Constraint}'s Message objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstraintContainsDOCTYPE ConstraintContainsDOCTYPE }</code></td>
<td>XML DOCTYPE elements are not permitted within {@link Constraint}'s Message objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidConstraintContent InvalidConstraintContent }</code></td>
<td>Invalid content for a {@link Constraint} object's Message object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathElementPerConstraint OneMathElementPerConstraint }</code></td>
<td>A {@link Constraint} object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMessageElementPerConstraint OneMessageElementPerConstraint }</code></td>
<td>A {@link Constraint} object must contain one Message subobject</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnConstraint AllowedAttributesOnConstraint }</code></td>
<td>Invalid attribute found on {@link Constraint} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoReactantsOrProducts NoReactantsOrProducts }</code></td>
<td>Cannot have a reaction with neither reactants nor products</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#IncorrectOrderInReaction IncorrectOrderInReaction }</code></td>
<td>Subobjects inside the {@link Reaction} object are not in the prescribed order</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#EmptyListInReaction EmptyListInReaction }</code></td>
<td>Reaction components, if present, cannot be empty</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidReactantsProductsList InvalidReactantsProductsList }</code></td>
<td>Invalid object found in the list of reactants or products</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidModifiersList InvalidModifiersList }</code></td>
<td>Invalid object found in the list of modifiers</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneSubElementPerReaction OneSubElementPerReaction }</code></td>
<td>A {@link Reaction} object can only contain one of each allowed type of object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompartmentOnReaction CompartmentOnReaction }</code></td>
<td>Invalid value for the {@link Reaction} 'compartment' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnReaction AllowedAttributesOnReaction }</code></td>
<td>Invalid attribute for a {@link Reaction} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSpeciesReference InvalidSpeciesReference }</code></td>
<td>Invalid 'species' attribute value in {@link SpeciesReference} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#BothStoichiometryAndMath BothStoichiometryAndMath }</code></td>
<td>The 'stoichiometry' attribute and {@link StoichiometryMath} subobject are mutually exclusive</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnSpeciesReference AllowedAttributesOnSpeciesReference }</code></td>
<td>Invalid attribute found on the {@link SpeciesReference} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnModifier AllowedAttributesOnModifier }</code></td>
<td>Invalid attribute found on the {@link ModifierSpeciesReference} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndeclaredSpeciesRef UndeclaredSpeciesRef }</code></td>
<td>Unknown species referenced in the kinetic law <code>&lt;math&gt;</code> formula</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#IncorrectOrderInKineticLaw IncorrectOrderInKineticLaw }</code></td>
<td>Incorrect ordering of components in the {@link KineticLaw} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#EmptyListInKineticLaw EmptyListInKineticLaw }</code></td>
<td>The list of parameters, if present, cannot be empty</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NonConstantLocalParameter NonConstantLocalParameter }</code></td>
<td>Parameters local to a {@link KineticLaw} object must have a 'constant' attribute value of 'true'</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SubsUnitsNoLongerValid SubsUnitsNoLongerValid }</code></td>
<td>Attribute 'substanceUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#TimeUnitsNoLongerValid TimeUnitsNoLongerValid }</code></td>
<td>Attribute 'timeUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneListOfPerKineticLaw OneListOfPerKineticLaw }</code></td>
<td>Only one {@link ListOfLocalParameters} object is permitted within a {@link KineticLaw} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyLocalParamsInListOfLocalParams OnlyLocalParamsInListOfLocalParams }</code></td>
<td>Only {@link LocalParameter}, Notes and Annotation objects are allowed in ListOfLocalParameter objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfLocalParam AllowedAttributesOnListOfLocalParam }</code></td>
<td>Invalid attribute found on the {@link ListOfLocalParameters} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathPerKineticLaw OneMathPerKineticLaw }</code></td>
<td>Only one <code>&lt;math&gt;</code> element is allowed in a {@link KineticLaw} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndeclaredSpeciesInStoichMath UndeclaredSpeciesInStoichMath }</code></td>
<td>Unknown species referenced in the {@link StoichiometryMath} object's <code>&lt;math&gt;</code> formula</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnKineticLaw AllowedAttributesOnKineticLaw }</code></td>
<td>Invalid attribute found on the {@link KineticLaw} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfSpeciesRef AllowedAttributesOnListOfSpeciesRef }</code></td>
<td>Invalid attribute found on the {@link ListOfSpeciesReferences} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfMods AllowedAttributesOnListOfMods }</code></td>
<td>Invalid attribute found on the ListOfModifiers object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnLocalParameter AllowedAttributesOnLocalParameter }</code></td>
<td>Invalid attribute found on the {@link LocalParameter} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingTriggerInEvent MissingTriggerInEvent }</code></td>
<td>The {@link Event} object is missing a {@link Trigger} subobject</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#TriggerMathNotBoolean TriggerMathNotBoolean }</code></td>
<td>A {@link Trigger} object's <code>&lt;math&gt;</code> expression must evaluate to a Boolean value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MissingEventAssignment MissingEventAssignment }</code></td>
<td>The {@link Event} object is missing an {@link EventAssignment} subobject</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#TimeUnitsEvent TimeUnitsEvent }</code></td>
<td>Units referenced by 'timeUnits' attribute are not compatible with units of time</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#IncorrectOrderInEvent IncorrectOrderInEvent }</code></td>
<td>Incorrect ordering of components in {@link Event} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ValuesFromTriggerTimeNeedDelay ValuesFromTriggerTimeNeedDelay }</code></td>
<td>Attribute 'useValuesFromTriggerTime'='false', but the {@link Event} object does not define a delay</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#DelayNeedsValuesFromTriggerTime DelayNeedsValuesFromTriggerTime }</code></td>
<td>The use of a {@link Delay} object requires the {@link Event} attribute 'useValuesFromTriggerTime'</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathPerTrigger OneMathPerTrigger }</code></td>
<td>A {@link Trigger} object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathPerDelay OneMathPerDelay }</code></td>
<td>A {@link Delay} object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidEventAssignmentVariable InvalidEventAssignmentVariable }</code></td>
<td>Invalid 'variable' attribute value in {@link Event} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventAssignmentForConstantEntity EventAssignmentForConstantEntity }</code></td>
<td>An {@link EventAssignment} object cannot assign to a component having attribute 'constant'='true'</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathPerEventAssignment OneMathPerEventAssignment }</code></td>
<td>An {@link EventAssignment} object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnEventAssignment AllowedAttributesOnEventAssignment }</code></td>
<td>Invalid attribute found on the {@link EventAssignment} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyOneDelayPerEvent OnlyOneDelayPerEvent }</code></td>
<td>An {@link Event} object can only have one {@link Delay} subobject</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneListOfEventAssignmentsPerEvent OneListOfEventAssignmentsPerEvent }</code></td>
<td>An {@link Event} object can only have one {@link ListOfEventAssignments} subobject</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyEventAssignInListOfEventAssign OnlyEventAssignInListOfEventAssign }</code></td>
<td>Only {@link EventAssignment}, Notes and Annotation objects are allowed in {@link ListOfEventAssignments}</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnListOfEventAssign AllowedAttributesOnListOfEventAssign }</code></td>
<td>Invalid attribute found on the {@link ListOfEventAssignments} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnEvent AllowedAttributesOnEvent }</code></td>
<td>Invalid attribute found on the {@link Event} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnTrigger AllowedAttributesOnTrigger }</code></td>
<td>Invalid attribute found on the {@link Trigger} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnDelay AllowedAttributesOnDelay }</code></td>
<td>Invalid attribute found on the {@link Delay} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#PersistentNotBoolean PersistentNotBoolean }</code></td>
<td>The {@link Trigger} attribute 'persistent' must evaluate to a Boolean value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitialValueNotBoolean InitialValueNotBoolean }</code></td>
<td>The {@link Trigger} attribute 'initialValue' must evaluate to a Boolean value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OnlyOnePriorityPerEvent OnlyOnePriorityPerEvent }</code></td>
<td>An {@link Event} object can only have one {@link Priority} subobject</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#OneMathPerPriority OneMathPerPriority }</code></td>
<td>A {@link Priority} object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AllowedAttributesOnPriority AllowedAttributesOnPriority }</code></td>
<td>Invalid attribute found on the {@link Priority} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#GeneralWarningNotSpecified GeneralWarningNotSpecified }</code></td>
<td>Unknown error</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompartmentShouldHaveSize CompartmentShouldHaveSize }</code></td>
<td>It's best to define a size for every compartment in a model</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpeciesShouldHaveValue SpeciesShouldHaveValue }</code></td>
<td>It's best to define an initial amount or initial concentration for every species in a model</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ParameterShouldHaveUnits ParameterShouldHaveUnits }</code></td>
<td>It's best to declare units for every parameter in a model</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#LocalParameterShadowsId LocalParameterShadowsId }</code></td>
<td>Local parameters defined within a kinetic law shadow global object symbols</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CannotConvertToL1V1 CannotConvertToL1V1 }</code></td>
<td>Cannot convert to SBML Level 1 Version 1</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoEventsInL1 NoEventsInL1 }</code></td>
<td>SBML Level 1 does not support events</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoFunctionDefinitionsInL1 NoFunctionDefinitionsInL1 }</code></td>
<td>SBML Level 1 does not support function definitions</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoConstraintsInL1 NoConstraintsInL1 }</code></td>
<td>SBML Level 1 does not support constraints</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoInitialAssignmentsInL1 NoInitialAssignmentsInL1 }</code></td>
<td>SBML Level 1 does not support initial assignments</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesTypesInL1 NoSpeciesTypesInL1 }</code></td>
<td>SBML Level 1 does not support species types</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoCompartmentTypeInL1 NoCompartmentTypeInL1 }</code></td>
<td>SBML Level 1 does not support compartment types</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoNon3DCompartmentsInL1 NoNon3DCompartmentsInL1 }</code></td>
<td>SBML Level 1 only supports three-dimensional compartments</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoFancyStoichiometryMathInL1 NoFancyStoichiometryMathInL1 }</code></td>
<td>SBML Level 1 does not support non-integer nor non-rational stoichiometry formulas</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoNonIntegerStoichiometryInL1 NoNonIntegerStoichiometryInL1 }</code></td>
<td>SBML Level 1 does not support non-integer 'stoichiometry' attribute values</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoUnitMultipliersOrOffsetsInL1 NoUnitMultipliersOrOffsetsInL1 }</code></td>
<td>SBML Level 1 does not support multipliers or offsets in unit definitions</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpeciesCompartmentRequiredInL1 SpeciesCompartmentRequiredInL1 }</code></td>
<td>In SBML Level 1, a value for 'compartment' is mandatory in species definitions</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesSpatialSizeUnitsInL1 NoSpeciesSpatialSizeUnitsInL1 }</code></td>
<td>SBML Level 1 does not support species 'spatialSizeUnits' settings</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSBOTermsInL1 NoSBOTermsInL1 }</code></td>
<td>SBML Level 1 does not support the 'sboTerm' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#StrictUnitsRequiredInL1 StrictUnitsRequiredInL1 }</code></td>
<td>SBML Level 1 requires strict unit consistency</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConversionFactorNotInL1 ConversionFactorNotInL1 }</code></td>
<td>SBML Level 1 does not support the 'conversionFactor' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompartmentNotOnL1Reaction CompartmentNotOnL1Reaction }</code></td>
<td>SBML Level 1 does not support the 'compartment' attribute on {@link Reaction} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ExtentUnitsNotSubstance ExtentUnitsNotSubstance }</code></td>
<td>Units of extent must be compatible with units of substance</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#GlobalUnitsNotDeclared GlobalUnitsNotDeclared }</code></td>
<td>Global units must be refer to unit kind or unitDefinition.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#HasOnlySubstanceUnitsNotinL1 HasOnlySubstanceUnitsNotinL1 }</code></td>
<td>The concept of hasOnlySubstanceUnits was not available in SBML Level 1.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AvogadroNotSupported AvogadroNotSupported }</code></td>
<td>Avogadro not supported in Levels 2 and 1.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoConstraintsInL2v1 NoConstraintsInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support {@link Constraint} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoInitialAssignmentsInL2v1 NoInitialAssignmentsInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support {@link InitialAssignment} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesTypeInL2v1 NoSpeciesTypeInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support {@link SpeciesType} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoCompartmentTypeInL2v1 NoCompartmentTypeInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support {@link CompartmentType} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSBOTermsInL2v1 NoSBOTermsInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support the 'sboTerm' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoIdOnSpeciesReferenceInL2v1 NoIdOnSpeciesReferenceInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support the 'id' attribute on {@link SpeciesReference} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoDelayedEventAssignmentInL2v1 NoDelayedEventAssignmentInL2v1 }</code></td>
<td>SBML Level 2 Version 1 does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#StrictUnitsRequiredInL2v1 StrictUnitsRequiredInL2v1 }</code></td>
<td>SBML Level 2 Version 1 requires strict unit consistency</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#IntegerSpatialDimensions IntegerSpatialDimensions }</code></td>
<td>SBML Level 2 Version 1 requires that compartments have spatial dimensions of 0-3</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#StoichiometryMathNotYetSupported StoichiometryMathNotYetSupported }</code></td>
<td>Conversion to {@link StoichiometryMath} objects not yet supported</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#PriorityLostFromL3 PriorityLostFromL3 }</code></td>
<td>SBML Level 2 Version 1 does not support priorities on {@link Event} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NonPersistentNotSupported NonPersistentNotSupported }</code></td>
<td>SBML Level 2 Version 1 does not support the 'persistent' attribute on {@link Trigger} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitialValueFalseEventNotSupported InitialValueFalseEventNotSupported }</code></td>
<td>SBML Level 2 Version 1 does not support the 'initialValue' attribute on {@link Trigger} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#SBOTermNotUniversalInL2v2 SBOTermNotUniversalInL2v2 }</code></td>
<td>The 'sboTerm' attribute is invalid for this component in SBML Level 2 Version 2</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoUnitOffsetInL2v2 NoUnitOffsetInL2v2 }</code></td>
<td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawTimeUnitsInL2v2 NoKineticLawTimeUnitsInL2v2 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawSubstanceUnitsInL2v2 NoKineticLawSubstanceUnitsInL2v2 }</code></td>
<td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoDelayedEventAssignmentInL2v2 NoDelayedEventAssignmentInL2v2 }</code></td>
<td>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ModelSBOBranchChangedBeyondL2v2 ModelSBOBranchChangedBeyondL2v2 }</code></td>
<td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#StrictUnitsRequiredInL2v2 StrictUnitsRequiredInL2v2 }</code></td>
<td>SBML Level 2 Version 2 requires strict unit consistency</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#StrictSBORequiredInL2v2 StrictSBORequiredInL2v2 }</code></td>
<td>SBML Level 2 Version 2 requires strict {@link SBO} term consistency</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateAnnotationInvalidInL2v2 DuplicateAnnotationInvalidInL2v2 }</code></td>
<td>Duplicate top-level annotations are invalid in SBML Level 2 Version 2</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoUnitOffsetInL2v3 NoUnitOffsetInL2v3 }</code></td>
<td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawTimeUnitsInL2v3 NoKineticLawTimeUnitsInL2v3 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawSubstanceUnitsInL2v3 NoKineticLawSubstanceUnitsInL2v3 }</code></td>
<td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesSpatialSizeUnitsInL2v3 NoSpeciesSpatialSizeUnitsInL2v3 }</code></td>
<td>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoEventTimeUnitsInL2v3 NoEventTimeUnitsInL2v3 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoDelayedEventAssignmentInL2v3 NoDelayedEventAssignmentInL2v3 }</code></td>
<td>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ModelSBOBranchChangedBeyondL2v3 ModelSBOBranchChangedBeyondL2v3 }</code></td>
<td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#StrictUnitsRequiredInL2v3 StrictUnitsRequiredInL2v3 }</code></td>
<td>SBML Level 2 Version 3 requires strict unit consistency</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#StrictSBORequiredInL2v3 StrictSBORequiredInL2v3 }</code></td>
<td>SBML Level 2 Version 3 requires strict {@link SBO} term consistency</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateAnnotationInvalidInL2v3 DuplicateAnnotationInvalidInL2v3 }</code></td>
<td>Duplicate top-level annotations are invalid in SBML Level 2 Version 3</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoUnitOffsetInL2v4 NoUnitOffsetInL2v4 }</code></td>
<td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawTimeUnitsInL2v4 NoKineticLawTimeUnitsInL2v4 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawSubstanceUnitsInL2v4 NoKineticLawSubstanceUnitsInL2v4 }</code></td>
<td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesSpatialSizeUnitsInL2v4 NoSpeciesSpatialSizeUnitsInL2v4 }</code></td>
<td>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoEventTimeUnitsInL2v4 NoEventTimeUnitsInL2v4 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ModelSBOBranchChangedInL2v4 ModelSBOBranchChangedInL2v4 }</code></td>
<td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateAnnotationInvalidInL2v4 DuplicateAnnotationInvalidInL2v4 }</code></td>
<td>Duplicate top-level annotations are invalid in SBML Level 2 Version 4</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesTypeInL3v1 NoSpeciesTypeInL3v1 }</code></td>
<td>SBML Level 3 Version 1 does not support {@link SpeciesType} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoCompartmentTypeInL3v1 NoCompartmentTypeInL3v1 }</code></td>
<td>SBML Level 3 Version 1 does not support {@link CompartmentType} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoUnitOffsetInL3v1 NoUnitOffsetInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawTimeUnitsInL3v1 NoKineticLawTimeUnitsInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoKineticLawSubstanceUnitsInL3v1 NoKineticLawSubstanceUnitsInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoSpeciesSpatialSizeUnitsInL3v1 NoSpeciesSpatialSizeUnitsInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoEventTimeUnitsInL3v1 NoEventTimeUnitsInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#ModelSBOBranchChangedInL3v1 ModelSBOBranchChangedInL3v1 }</code></td>
<td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#DuplicateAnnotationInvalidInL3v1 DuplicateAnnotationInvalidInL3v1 }</code></td>
<td>Duplicate top-level annotations are invalid in SBML Level 3 Version 1</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoCompartmentOutsideInL3v1 NoCompartmentOutsideInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the 'outside' attribute on {@link Compartment} objects</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoStoichiometryMathInL3v1 NoStoichiometryMathInL3v1 }</code></td>
<td>This Level+Version of SBML does not support the {@link StoichiometryMath} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidSBMLLevelVersion InvalidSBMLLevelVersion }</code></td>
<td>Unknown Level+Version combination of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#AnnotationNotesNotAllowedLevel1 AnnotationNotesNotAllowedLevel1 }</code></td>
<td>Annotation objects on the SBML container element are not permitted in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidRuleOrdering InvalidRuleOrdering }</code></td>
<td>Invalid ordering of rules</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#RequiredPackagePresent RequiredPackagePresent }</code></td>
<td>The SBML document requires an SBML Level 3 package unavailable in this software</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#UnrequiredPackagePresent UnrequiredPackagePresent }</code></td>
<td>The SBML document uses an SBML Level 3 package unavailable in this software</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#PackageRequiredShouldBeFalse PackageRequiredShouldBeFalse }</code></td>
<td>This package expects required to be false.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#SubsUnitsAllowedInKL SubsUnitsAllowedInKL }</code></td>
<td>Disallowed value for attribute 'substanceUnits' on {@link KineticLaw} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#TimeUnitsAllowedInKL TimeUnitsAllowedInKL }</code></td>
<td>Disallowed value for attribute 'timeUnits' on {@link KineticLaw} object</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#FormulaInLevel1KL FormulaInLevel1KL }</code></td>
<td>Only predefined functions are allowed in SBML Level 1 formulas</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3SubstanceUnitsOnModel L3SubstanceUnitsOnModel }</code></td>
<td>Invalid 'substanceUnits' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#TimeUnitsRemoved TimeUnitsRemoved }</code></td>
<td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#BadMathML BadMathML }</code></td>
<td>Invalid MathML expression</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FailedMathMLReadOfDouble FailedMathMLReadOfDouble }</code></td>
<td>Missing or invalid floating-point number in MathML expression</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FailedMathMLReadOfInteger FailedMathMLReadOfInteger }</code></td>
<td>Missing or invalid integer in MathML expression</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FailedMathMLReadOfExponential FailedMathMLReadOfExponential }</code></td>
<td>Missing or invalid exponential expression in MathML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FailedMathMLReadOfRational FailedMathMLReadOfRational }</code></td>
<td>Missing or invalid rational expression in MathML</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#BadMathMLNodeType BadMathMLNodeType }</code></td>
<td>Invalid MathML element</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoTimeSymbolInFunctionDef NoTimeSymbolInFunctionDef }</code></td>
<td>Use of <code>&lt;csymbol&gt;</code> for 'time' not allowed within {@link FunctionDefinition} objects</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#NoBodyInFunctionDef NoBodyInFunctionDef }</code></td>
<td>There must be a <code>&lt;lambda&gt;</code> body within the <code>&lt;math&gt;</code> element of a {@link FunctionDefinition} object</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#DanglingUnitSIdRef DanglingUnitSIdRef }</code></td>
<td>Units must refer to valid unit or unitDefinition</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RDFMissingAboutTag RDFMissingAboutTag }</code></td>
<td>RDF missing the <code>&lt;about&gt;</code> tag.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RDFEmptyAboutTag RDFEmptyAboutTag }</code></td>
<td>RDF empty <code>&lt;about&gt;</code> tag.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RDFAboutTagNotMetaid RDFAboutTagNotMetaid }</code></td>
<td>RDF <code>&lt;about&gt;</code> tag is not metaid.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RDFNotCompleteModelHistory RDFNotCompleteModelHistory }</code></td>
<td>RDF does not contain valid {@link ModelHistory}.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#RDFNotModelHistory RDFNotModelHistory }</code></td>
<td>RDF does not result in a {@link ModelHistory}.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#AnnotationNotElement AnnotationNotElement }</code></td>
<td>Annotation must contain element.</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndeclaredUnits UndeclaredUnits }</code></td>
<td>Missing unit declarations on parameters or literal numbers in expression</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndeclaredTimeUnitsL3 UndeclaredTimeUnitsL3 }</code></td>
<td>Unable to verify consistency of units: the unit of time has not been declared</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndeclaredExtentUnitsL3 UndeclaredExtentUnitsL3 }</code></td>
<td>Unable to verify consistency of units: the units of reaction extent have not been declared</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#UndeclaredObjectUnitsL3 UndeclaredObjectUnitsL3 }</code></td>
<td>Unable to verify consistency of units: encountered a model entity with no declared units</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#UnrecognisedSBOTerm UnrecognisedSBOTerm }</code></td>
<td>Unrecognized 'sboTerm' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#ObseleteSBOTerm ObseleteSBOTerm }</code></td>
<td>Obsolete 'sboTerm' attribute value</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#IncorrectCompartmentSpatialDimensions IncorrectCompartmentSpatialDimensions }</code></td>
<td>In SBML Level 1, only three-dimensional compartments are allowed</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompartmentTypeNotValidAttribute CompartmentTypeNotValidAttribute }</code></td>
<td>CompartmentType objects are not available in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstantNotValidAttribute ConstantNotValidAttribute }</code></td>
<td>This Level+Version of SBML does not support the 'constant' attribute on this component</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#MetaIdNotValidAttribute MetaIdNotValidAttribute }</code></td>
<td>Attribute 'metaid' is not available in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SBOTermNotValidAttributeBeforeL2V3 SBOTermNotValidAttributeBeforeL2V3 }</code></td>
<td>The 'sboTerm' attribute is not available on this component before SBML Level 2 Version 3</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidL1CompartmentUnits InvalidL1CompartmentUnits }</code></td>
<td>Invalid units for a compartment in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#L1V1CompartmentVolumeReqd L1V1CompartmentVolumeReqd }</code></td>
<td>In SBML Level 1, a compartment's volume must be specified</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompartmentTypeNotValidComponent CompartmentTypeNotValidComponent }</code></td>
<td>CompartmentType objects are not available in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstraintNotValidComponent ConstraintNotValidComponent }</code></td>
<td>Constraint objects are not available in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#EventNotValidComponent EventNotValidComponent }</code></td>
<td>Event objects are not available in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SBOTermNotValidAttributeBeforeL2V2 SBOTermNotValidAttributeBeforeL2V2 }</code></td>
<td>The 'sboTerm' attribute is invalid for this component before Level 2 Version 2</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#FuncDefNotValidComponent FuncDefNotValidComponent }</code></td>
<td>FunctionDefinition objects are not available in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#InitialAssignNotValidComponent InitialAssignNotValidComponent }</code></td>
<td>InitialAssignment objects are not available in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#VariableNotValidAttribute VariableNotValidAttribute }</code></td>
<td>Attribute 'variable' is not available on this component in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#UnitsNotValidAttribute UnitsNotValidAttribute }</code></td>
<td>Attribute 'units' is not available on this component in this Level+Version of SBML</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#ConstantSpeciesNotValidAttribute ConstantSpeciesNotValidAttribute }</code></td>
<td>Attribute 'constant' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpatialSizeUnitsNotValidAttribute SpatialSizeUnitsNotValidAttribute }</code></td>
<td>Attribute 'spatialSizeUnits' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpeciesTypeNotValidAttribute SpeciesTypeNotValidAttribute }</code></td>
<td>Attribute 'speciesType' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#HasOnlySubsUnitsNotValidAttribute HasOnlySubsUnitsNotValidAttribute }</code></td>
<td>Attribute 'hasOnlySubstanceUnits' is not available on {@link Species} objects in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#IdNotValidAttribute IdNotValidAttribute }</code></td>
<td>Attribute 'id' is not available on {@link SpeciesReference} objects in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#NameNotValidAttribute NameNotValidAttribute }</code></td>
<td>Attribute 'name' is not available on {@link SpeciesReference} objects in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#SpeciesTypeNotValidComponent SpeciesTypeNotValidComponent }</code></td>
<td>The {@link SpeciesType} object is not supported in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#StoichiometryMathNotValidComponent StoichiometryMathNotValidComponent }</code></td>
<td>The {@link StoichiometryMath} object is not supported in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#MultiplierNotValidAttribute MultiplierNotValidAttribute }</code></td>
<td>Attribute 'multiplier' on {@link Unit} objects is not supported in SBML Level 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#OffsetNotValidAttribute OffsetNotValidAttribute }</code></td>
<td>Attribute 'offset' on {@link Unit} objects is only available in SBML Level 2 Version 1</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3SpatialDimensionsUnset L3SpatialDimensionsUnset }</code></td>
<td>No value given for 'spatialDimensions' attribute; assuming a value of 3</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#PackageConversionNotSupported PackageConversionNotSupported }</code></td>
<td>Conversion of SBML Level 3 package constructs is not yet supported</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#InvalidTargetLevelVersion InvalidTargetLevelVersion }</code></td>
<td>The requested SBML Level/Version combination is not known to exist</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#L3NotSupported L3NotSupported }</code></td>
<td>SBML Level 3 is not yet supported</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompUnknown CompUnknown }</code></td>
<td> Unknown error from comp </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompNSUndeclared CompNSUndeclared }</code></td>
<td> The comp ns is not correctly declared </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompElementNotInNs CompElementNotInNs }</code></td>
<td> Element not in comp namespace </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDuplicateComponentId CompDuplicateComponentId }</code></td>
<td> Duplicate 'id' attribute value </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompUniqueModelIds CompUniqueModelIds }</code></td>
<td> {@link Model} and ExternalModelDefinitions must have unique ids </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompUniquePortIds CompUniquePortIds }</code></td>
<td> Ports must have unique ids </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidSIdSyntax CompInvalidSIdSyntax }</code></td>
<td> Invalid SId syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidSubmodelRefSyntax CompInvalidSubmodelRefSyntax }</code></td>
<td> Invalid submodelRef syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidDeletionSyntax CompInvalidDeletionSyntax }</code></td>
<td> Invalid deletion syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidConversionFactorSyntax CompInvalidConversionFactorSyntax }</code></td>
<td> Invalid conversionFactor syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidNameSyntax CompInvalidNameSyntax }</code></td>
<td> Invalid name syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedUnitsShouldMatch CompReplacedUnitsShouldMatch }</code></td>
<td> Units of replaced elements should match replacement units. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneListOfReplacedElements CompOneListOfReplacedElements }</code></td>
<td> Only one <code>&lt;listOfReplacedElements&gt;</code> allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOReplaceElementsAllowedElements CompLOReplaceElementsAllowedElements }</code></td>
<td> Allowed children of <code>&lt;listOfReplacedElements&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOReplacedElementsAllowedAttribs CompLOReplacedElementsAllowedAttribs }</code></td>
<td> Allowed <code>&lt;listOfReplacedElements&gt;</code> attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompEmptyLOReplacedElements CompEmptyLOReplacedElements }</code></td>
<td> <code>&lt;listOfReplacedElements&gt;</code> must not be empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneReplacedByElement CompOneReplacedByElement }</code></td>
<td> Only one <code>&lt;replacedBy&gt;</code> object allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompAttributeRequiredMissing CompAttributeRequiredMissing }</code></td>
<td> Required comp:required attribute on <code>&lt;sbml&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompAttributeRequiredMustBeBoolean CompAttributeRequiredMustBeBoolean }</code></td>
<td> The comp:required attribute must be Boolean </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompRequiredTrueIfElementsRemain CompRequiredTrueIfElementsRemain }</code></td>
<td> The comp:required attribute must be 'true' if math changes. NOTE:  Deprecated </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompRequiredFalseIfAllElementsReplaced CompRequiredFalseIfAllElementsReplaced }</code></td>
<td> The comp:required attribute must be 'false' if math does not change. NOTE:  Deprecated </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneListOfModelDefinitions CompOneListOfModelDefinitions }</code></td>
<td> Only one <code>&lt;listOfModelDefinitions&gt;</code> allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompEmptyLOModelDefs CompEmptyLOModelDefs }</code></td>
<td> <code>&lt;listOfModelDefinitions&gt;</code> and <code>&lt;listOfExternalModelDefinitions&gt;</code> must not be empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOModelDefsAllowedElements CompLOModelDefsAllowedElements }</code></td>
<td> Only <code>&lt;modelDefinitions&gt;</code> in <code>&lt;listOfModelDefinitions&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOExtModelDefsAllowedElements CompLOExtModelDefsAllowedElements }</code></td>
<td> Only <code>&lt;externalModelDefinitions&gt;</code> in <code>&lt;listOfExternalModelDefinitions&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOModelDefsAllowedAttributes CompLOModelDefsAllowedAttributes }</code></td>
<td> Allowed <code>&lt;listOfModelDefinitions&gt;</code> attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOExtModDefsAllowedAttributes CompLOExtModDefsAllowedAttributes }</code></td>
<td> Allowed <code>&lt;listOfExternalModelDefinitions&gt;</code> attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneListOfExtModelDefinitions CompOneListOfExtModelDefinitions }</code></td>
<td> Only one <code>&lt;listOfExternalModelDefinitions&gt;</code> allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompAttributeRequiredMustBeTrue CompAttributeRequiredMustBeTrue }</code></td>
<td> The comp:required attribute must be 'true' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompExtModDefAllowedCoreAttributes CompExtModDefAllowedCoreAttributes }</code></td>
<td> Allowed <code>&lt;externalModelDefinitions&gt;</code> core attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompExtModDefAllowedElements CompExtModDefAllowedElements }</code></td>
<td> Allowed <code>&lt;externalModelDefinitions&gt;</code> elements </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompExtModDefAllowedAttributes CompExtModDefAllowedAttributes }</code></td>
<td> Allowed <code>&lt;externalModelDefinitions&gt;</code> attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReferenceMustBeL3 CompReferenceMustBeL3 }</code></td>
<td> External models must be L3 </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompModReferenceMustIdOfModel CompModReferenceMustIdOfModel }</code></td>
<td> 'modelRef' must be the 'id' of a model in the 'source' document </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompExtModMd5DoesNotMatch CompExtModMd5DoesNotMatch }</code></td>
<td> MD5 checksum does not match the 'source' document </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidSourceSyntax CompInvalidSourceSyntax }</code></td>
<td> The 'comp:source' attribute must be of type 'anyURI' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidModelRefSyntax CompInvalidModelRefSyntax }</code></td>
<td> The 'comp:modelRef' attribute must have the syntax of 'SId' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidMD5Syntax CompInvalidMD5Syntax }</code></td>
<td> The 'comp:md5' attribute must have the syntax of 'string' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompCircularExternalModelReference CompCircularExternalModelReference }</code></td>
<td> Circular reference in <code>&lt;externalModelDefinitiongt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneListOfOnModel CompOneListOfOnModel }</code></td>
<td> Only one <code>&lt;listOfSubmodels&gt;</code> and one <code>&lt;listOfPorts&gt;</code> allowed </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompNoEmptyListOfOnModel CompNoEmptyListOfOnModel }</code></td>
<td> No empty listOf elements allowed </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOSubmodelsAllowedElements CompLOSubmodelsAllowedElements }</code></td>
<td> Allowed elements on <code>&lt;listOfSubmodels&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOPortsAllowedElements CompLOPortsAllowedElements }</code></td>
<td> Allowed elements on <code>&lt;listOfPorts&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOSubmodelsAllowedAttributes CompLOSubmodelsAllowedAttributes }</code></td>
<td> Allowed attributes on <code>&lt;listOfSubmodels&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLOPortsAllowedAttributes CompLOPortsAllowedAttributes }</code></td>
<td> Allowed attributes on <code>&lt;listOfPorts&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSubmodelAllowedCoreAttributes CompSubmodelAllowedCoreAttributes }</code></td>
<td> Allowed core attributes on <code>&lt;submodel&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSubmodelAllowedElements CompSubmodelAllowedElements }</code></td>
<td> Allowed elements on <code>&lt;submodel&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneListOfDeletionOnSubmodel CompOneListOfDeletionOnSubmodel }</code></td>
<td> Only one <code>&lt;listOfDeletions&gt;</code> on a <code>&lt;submodel&gt;</code> allowed </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSubmodelNoEmptyLODeletions CompSubmodelNoEmptyLODeletions }</code></td>
<td> No empty listOfDeletions elements allowed </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLODeletionsAllowedElements CompLODeletionsAllowedElements }</code></td>
<td> Allowed elements on <code>&lt;listOfDeletions&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLODeletionAllowedAttributes CompLODeletionAllowedAttributes }</code></td>
<td> Allowed <code>&lt;listOfDeletions&gt;</code> attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSubmodelAllowedAttributes CompSubmodelAllowedAttributes }</code></td>
<td> Allowed <code>&lt;submodel&gt;</code> attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompModReferenceSyntax CompModReferenceSyntax }</code></td>
<td> 'comp:modelRef' must conform to SId syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidTimeConvFactorSyntax CompInvalidTimeConvFactorSyntax }</code></td>
<td> 'comp:timeConversionFactor' must conform to SId syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidExtentConvFactorSyntax CompInvalidExtentConvFactorSyntax }</code></td>
<td> 'comp:extentConversionFactor' must conform to SId syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSubmodelMustReferenceModel CompSubmodelMustReferenceModel }</code></td>
<td> The 'comp:modelRef' attribute must reference a model </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSubmodelCannotReferenceSelf CompSubmodelCannotReferenceSelf }</code></td>
<td> The 'comp:modelRef' attribute cannot reference own model </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompModCannotCircularlyReferenceSelf CompModCannotCircularlyReferenceSelf }</code></td>
<td> <code>&lt;model&gt;</code> may not reference <code>&lt;submodel&gt;</code> that references itself. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompTimeConversionMustBeParameter CompTimeConversionMustBeParameter }</code></td>
<td> The 'comp:timeConversionFactor' must reference a parameter </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompExtentConversionMustBeParameter CompExtentConversionMustBeParameter }</code></td>
<td> The 'comp:extentConversionFactor' must reference a parameter </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompPortRefMustReferencePort CompPortRefMustReferencePort }</code></td>
<td> The 'comp:portRef' attribute must be the 'id' of a <code>&lt;port&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompIdRefMustReferenceObject CompIdRefMustReferenceObject }</code></td>
<td> The 'comp:idRef' attribute must be the 'id' of a model element </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompUnitRefMustReferenceUnitDef CompUnitRefMustReferenceUnitDef }</code></td>
<td> The 'comp:unitRef' attribute must be the 'id' of a {@link UnitDefinition} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompMetaIdRefMustReferenceObject CompMetaIdRefMustReferenceObject }</code></td>
<td> The 'comp:metaIdRef' attribute must be the 'metaid' of an object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompParentOfSBRefChildMustBeSubmodel CompParentOfSBRefChildMustBeSubmodel }</code></td>
<td> If <code>&lt;sBaseRef&gt;</code> has a child <code>&lt;sBaseRef&gt;</code> its parent must be a <code>&lt;submodel&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidPortRefSyntax CompInvalidPortRefSyntax }</code></td>
<td> The 'comp:portRef' attribute must have the syntax of an SBML SId </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidIdRefSyntax CompInvalidIdRefSyntax }</code></td>
<td> The 'comp:idRef' attribute must have the syntax of an SBML SId </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidUnitRefSyntax CompInvalidUnitRefSyntax }</code></td>
<td> The 'comp:unitRef' attribute must have the syntax of an SBML SId </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompInvalidMetaIdRefSyntax CompInvalidMetaIdRefSyntax }</code></td>
<td> The 'comp:metaIdRef' attribute must have the syntax of an XML ID </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompOneSBaseRefOnly CompOneSBaseRefOnly }</code></td>
<td> Only one <code>&lt;sbaseRef&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeprecatedSBaseRefSpelling CompDeprecatedSBaseRefSpelling }</code></td>
<td> The spelling 'sbaseRef' is deprecated </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSBaseRefMustReferenceObject CompSBaseRefMustReferenceObject }</code></td>
<td> An {@link SBaseRef} must reference an object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompSBaseRefMustReferenceOnlyOneObject CompSBaseRefMustReferenceOnlyOneObject }</code></td>
<td> An {@link SBaseRef} must reference only one other object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompNoMultipleReferences CompNoMultipleReferences }</code></td>
<td> Objects may not be referenced by mutiple {@link SBaseRef} constructs. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompPortMustReferenceObject CompPortMustReferenceObject }</code></td>
<td> {@link Port} must reference an object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompPortMustReferenceOnlyOneObject CompPortMustReferenceOnlyOneObject }</code></td>
<td> {@link Port} must reference only one other object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompPortAllowedAttributes CompPortAllowedAttributes }</code></td>
<td> Allowed attributes on a {@link Port} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompPortReferencesUnique CompPortReferencesUnique }</code></td>
<td> {@link Port} definitions must be unique. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeletionMustReferenceObject CompDeletionMustReferenceObject }</code></td>
<td> {@link Deletion} must reference an object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeletionMustReferOnlyOneObject CompDeletionMustReferOnlyOneObject }</code></td>
<td> {@link Deletion} must reference only one other object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeletionAllowedAttributes CompDeletionAllowedAttributes }</code></td>
<td> Allowed attributes on a {@link Deletion} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementMustRefObject CompReplacedElementMustRefObject }</code></td>
<td> {@link ReplacedElement} must reference an object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementMustRefOnlyOne CompReplacedElementMustRefOnlyOne }</code></td>
<td> {@link ReplacedElement} must reference only one other object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementAllowedAttributes CompReplacedElementAllowedAttributes }</code></td>
<td> Allowed attributes on <code>&lt;replacedElement&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementSubModelRef CompReplacedElementSubModelRef }</code></td>
<td> The 'comp:submodelRef' attribute must point to a <code>&lt;submodel&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementDeletionRef CompReplacedElementDeletionRef }</code></td>
<td> The 'comp:deletion' attribute must point to a <code>&lt;deletion&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementConvFactorRef CompReplacedElementConvFactorRef }</code></td>
<td> The 'comp:conversionFactor attribute must point to a <code>&lt;parameter&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementSameReference CompReplacedElementSameReference }</code></td>
<td> No <code>&lt;replacedElement&gt;</code> refer to same object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedElementNoDelAndConvFact CompReplacedElementNoDelAndConvFact }</code></td>
<td> No <code>&lt;replacedElement&gt;</code> with deletion and conversionfactor </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedByMustRefObject CompReplacedByMustRefObject }</code></td>
<td> {@link ReplacedBy} must reference an object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedByMustRefOnlyOne CompReplacedByMustRefOnlyOne }</code></td>
<td> {@link ReplacedBy} must reference only one other object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedByAllowedAttributes CompReplacedByAllowedAttributes }</code></td>
<td> Allowed attributes on <code>&lt;replacedBy&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompReplacedBySubModelRef CompReplacedBySubModelRef }</code></td>
<td> The 'comp:submodelRef' attribute must point to a <code>&lt;submodel&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompMustReplaceSameClass CompMustReplaceSameClass }</code></td>
<td> Replaced classes must match. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompMustReplaceIDs CompMustReplaceIDs }</code></td>
<td> Replaced IDs must be replaced with IDs. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompMustReplaceMetaIDs CompMustReplaceMetaIDs }</code></td>
<td> Replaced metaids must be replaced with metaids. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompMustReplacePackageIDs CompMustReplacePackageIDs }</code></td>
<td> Replaced package IDs must be replaced with package IDs. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompUnresolvedReference CompUnresolvedReference }</code></td>
<td> Unresolved reference. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompNoModelInReference CompNoModelInReference }</code></td>
<td> No model in referenced document. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompExtModDefBad CompExtModDefBad }</code></td>
<td> Referenced <code>&lt;externalModelDefinitiongt;</code> unresolvable. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompModelFlatteningFailed CompModelFlatteningFailed }</code></td>
<td> {@link Model} failed to flatten. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompFlatModelNotValid CompFlatModelNotValid }</code></td>
<td> Flat model not valid. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompLineNumbersUnreliable CompLineNumbersUnreliable }</code></td>
<td> Line numbers unreliable. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompFlatteningNotRecognisedReqd CompFlatteningNotRecognisedReqd }</code></td>
<td> Flattening not implemented for required package. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompFlatteningNotRecognisedNotReqd CompFlatteningNotRecognisedNotReqd }</code></td>
<td> Flattening not implemented for unrequired package. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompFlatteningNotImplementedNotReqd CompFlatteningNotImplementedNotReqd }</code></td>
<td> Flattening not implemented for unrequired package. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompFlatteningNotImplementedReqd CompFlatteningNotImplementedReqd }</code></td>
<td> Flattening not implemented for required package. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompFlatteningWarning CompFlatteningWarning }</code></td>
<td> Flattening reference may come from package. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeprecatedDeleteFunction CompDeprecatedDeleteFunction }</code></td>
<td> The performDeletions functions is deprecated. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeprecatedReplaceFunction CompDeprecatedReplaceFunction }</code></td>
<td> The performReplacementsAndConversions fuctions is deprecated. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompDeletedReplacement CompDeletedReplacement }</code></td>
<td> Element deleted before a subelement could be replaced. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompIdRefMayReferenceUnknownPackage CompIdRefMayReferenceUnknownPackage }</code></td>
<td> The 'comp:idRef' attribute must be the 'id' of a model element </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#CompMetaIdRefMayReferenceUnknownPkg CompMetaIdRefMayReferenceUnknownPkg }</code></td>
<td> The 'comp:metaIdRef' attribute must be the 'metaid' of a model element </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcUnknown FbcUnknown }</code></td>
<td> Unknown error from fbc </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcNSUndeclared FbcNSUndeclared }</code></td>
<td> The fbc ns is not correctly declared </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcElementNotInNs FbcElementNotInNs }</code></td>
<td> Element not in fbc namespace </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcDuplicateComponentId FbcDuplicateComponentId }</code></td>
<td> Duplicate 'id' attribute value </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcSBMLSIdSyntax FbcSBMLSIdSyntax }</code></td>
<td> Invalid 'id' attribute </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcAttributeRequiredMissing FbcAttributeRequiredMissing }</code></td>
<td> Required fbc:required attribute on <code>&lt;sbml&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcAttributeRequiredMustBeBoolean FbcAttributeRequiredMustBeBoolean }</code></td>
<td> The fbc:required attribute must be Boolean </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcRequiredFalse FbcRequiredFalse }</code></td>
<td> The fbc:required attribute must be 'false' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcOnlyOneEachListOf FbcOnlyOneEachListOf }</code></td>
<td> One of each list of allowed </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcNoEmptyListOfs FbcNoEmptyListOfs }</code></td>
<td> {@link ListOf} elements cannot be empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcLOFluxBoundsAllowedElements FbcLOFluxBoundsAllowedElements }</code></td>
<td> Allowed elements on {@link ListOfFluxBounds} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcLOObjectivesAllowedElements FbcLOObjectivesAllowedElements }</code></td>
<td> Allowed elements on {@link ListOfObjectives} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcLOFluxBoundsAllowedAttributes FbcLOFluxBoundsAllowedAttributes }</code></td>
<td> Allowed attributes on {@link ListOfFluxBounds} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcLOObjectivesAllowedAttributes FbcLOObjectivesAllowedAttributes }</code></td>
<td> Allowed attributes on {@link ListOfObjectives} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcActiveObjectiveSyntax FbcActiveObjectiveSyntax }</code></td>
<td> Type of activeObjective attribute </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcActiveObjectiveRefersObjective FbcActiveObjectiveRefersObjective }</code></td>
<td> ActiveObjective must reference {@link Objective} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcSpeciesAllowedL3Attributes FbcSpeciesAllowedL3Attributes }</code></td>
<td> {@link Species} allowed attributes </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcSpeciesChargeMustBeInteger FbcSpeciesChargeMustBeInteger }</code></td>
<td> Charge must be integer </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcSpeciesFormulaMustBeString FbcSpeciesFormulaMustBeString }</code></td>
<td> Chemical formula must be string </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundAllowedL3Attributes FbcFluxBoundAllowedL3Attributes }</code></td>
<td> <code>&lt;fluxBound&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundAllowedElements FbcFluxBoundAllowedElements }</code></td>
<td> <code>&lt;fluxBound&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundRequiredAttributes FbcFluxBoundRequiredAttributes }</code></td>
<td> Invalid attribute found on <code>&lt;fluxBound&gt;</code> object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundRectionMustBeSIdRef FbcFluxBoundRectionMustBeSIdRef }</code></td>
<td> Datatype for 'fbc:reaction' must be SIdRef </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundNameMustBeString FbcFluxBoundNameMustBeString }</code></td>
<td> The attribute 'fbc:name' must be of the data type string </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundOperationMustBeEnum FbcFluxBoundOperationMustBeEnum }</code></td>
<td> The attribute 'fbc:operation' must be of data type FbcOperation </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundValueMustBeDouble FbcFluxBoundValueMustBeDouble }</code></td>
<td> The attribute 'fbc:value' must be of the data type double </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundReactionMustExist FbcFluxBoundReactionMustExist }</code></td>
<td> 'fbc:reaction' must refer to valid reaction </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxBoundsForReactionConflict FbcFluxBoundsForReactionConflict }</code></td>
<td> Conflicting set of FluxBounds for a reaction </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveAllowedL3Attributes FbcObjectiveAllowedL3Attributes }</code></td>
<td> <code>&lt;objective&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveAllowedElements FbcObjectiveAllowedElements }</code></td>
<td> <code>&lt;objective&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveRequiredAttributes FbcObjectiveRequiredAttributes }</code></td>
<td> Invalid attribute found on <code>&lt;objective&gt;</code> object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveNameMustBeString FbcObjectiveNameMustBeString }</code></td>
<td> The attribute 'fbc:name' must be of the data type string </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveTypeMustBeEnum FbcObjectiveTypeMustBeEnum }</code></td>
<td> The attribute 'fbc:type' must be of data type FbcType. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveOneListOfObjectives FbcObjectiveOneListOfObjectives }</code></td>
<td> An <code>&lt;objective&gt;</code> must have one <code>&lt;listOfFluxObjectives&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveLOFluxObjMustNotBeEmpty FbcObjectiveLOFluxObjMustNotBeEmpty }</code></td>
<td> <code>&lt;listOfFluxObjectives&gt;</code> subobject must not be empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveLOFluxObjOnlyFluxObj FbcObjectiveLOFluxObjOnlyFluxObj }</code></td>
<td> Invalid element found in <code>&lt;listOfFluxObjectives&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcObjectiveLOFluxObjAllowedAttribs FbcObjectiveLOFluxObjAllowedAttribs }</code></td>
<td> <code>&lt;listOfFluxObjectives&gt;</code> may only have 'metaId' and 'sboTerm' from L3 core </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectAllowedL3Attributes FbcFluxObjectAllowedL3Attributes }</code></td>
<td> <code>&lt;fluxObjectivegt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectAllowedElements FbcFluxObjectAllowedElements }</code></td>
<td> <code>&lt;fluxObjectivegt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectRequiredAttributes FbcFluxObjectRequiredAttributes }</code></td>
<td> Invalid attribute found on <code>&lt;fluxObjectivegt;</code> object </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectNameMustBeString FbcFluxObjectNameMustBeString }</code></td>
<td> The attribute 'fbc:name' must be of the data type string </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectReactionMustBeSIdRef FbcFluxObjectReactionMustBeSIdRef }</code></td>
<td> Datatype for 'fbc:reaction' must be SIdRef </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectReactionMustExist FbcFluxObjectReactionMustExist }</code></td>
<td> 'fbc:reaction' must refer to valid reaction </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#FbcFluxObjectCoefficientMustBeDouble FbcFluxObjectCoefficientMustBeDouble }</code></td>
<td> The attribute 'fbc:coefficient' must be of the data type double </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutUnknownError LayoutUnknownError }</code></td>
<td> Unknown error from layout </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutNSUndeclared LayoutNSUndeclared }</code></td>
<td> The layout ns is not correctly declared </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutElementNotInNs LayoutElementNotInNs }</code></td>
<td> Element not in layout namespace </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutDuplicateComponentId LayoutDuplicateComponentId }</code></td>
<td> Duplicate 'id' attribute value </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSIdSyntax LayoutSIdSyntax }</code></td>
<td> 'id' attribute incorrect syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutXsiTypeAllowedLocations LayoutXsiTypeAllowedLocations }</code></td>
<td> 'xsi:type' allowed locations </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutXsiTypeSyntax LayoutXsiTypeSyntax }</code></td>
<td> 'xsi:type' attribute incorrect syntax </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutAttributeRequiredMissing LayoutAttributeRequiredMissing }</code></td>
<td> Required layout:required attribute on <code>&lt;sbml&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutAttributeRequiredMustBeBoolean LayoutAttributeRequiredMustBeBoolean }</code></td>
<td> The layout:required attribute must be Boolean </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRequiredFalse LayoutRequiredFalse }</code></td>
<td> The layout:required attribute must be 'false' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutOnlyOneLOLayouts LayoutOnlyOneLOLayouts }</code></td>
<td> Only one listOfLayouts on <code>&lt;model&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOLayoutsNotEmpty LayoutLOLayoutsNotEmpty }</code></td>
<td> {@link ListOf} elements cannot be empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOLayoutsAllowedElements LayoutLOLayoutsAllowedElements }</code></td>
<td> Allowed elements on {@link ListOfLayouts} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOLayoutsAllowedAttributes LayoutLOLayoutsAllowedAttributes }</code></td>
<td> Allowed attributes on {@link ListOfLayouts} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLayoutAllowedElements LayoutLayoutAllowedElements }</code></td>
<td> Allowed elements on {@link Layout} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLayoutAllowedCoreAttributes LayoutLayoutAllowedCoreAttributes }</code></td>
<td> Allowed core attributes on {@link Layout} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutOnlyOneEachListOf LayoutOnlyOneEachListOf }</code></td>
<td> Only one each listOf on <code>&lt;layout&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutNoEmptyListOfs LayoutNoEmptyListOfs }</code></td>
<td> {@link ListOf} elements cannot be empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLayoutAllowedAttributes LayoutLayoutAllowedAttributes }</code></td>
<td> <code>&lt;layout&gt;</code> must have 'id' and may have 'name' </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLayoutNameMustBeString LayoutLayoutNameMustBeString }</code></td>
<td> 'name' must be string </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOCompGlyphAllowedAttributes LayoutLOCompGlyphAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfCompartmentGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOCompGlyphAllowedElements LayoutLOCompGlyphAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfCompartmentGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSpeciesGlyphAllowedAttributes LayoutLOSpeciesGlyphAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfSpeciesGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSpeciesGlyphAllowedElements LayoutLOSpeciesGlyphAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfSpeciesGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLORnGlyphAllowedAttributes LayoutLORnGlyphAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfReactionGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLORnGlyphAllowedElements LayoutLORnGlyphAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfReactionGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOAddGOAllowedAttribut LayoutLOAddGOAllowedAttribut }</code></td>
<td> Attributes allowed on <code>&lt;listOfAdditionalGraphicalObjectGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOAddGOAllowedElements LayoutLOAddGOAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfAdditionalGraphicalObjectGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLayoutMustHaveDimensions LayoutLayoutMustHaveDimensions }</code></td>
<td> {@link Layout} must have <code>&lt;dimensions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOTextGlyphAllowedAttributes LayoutLOTextGlyphAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfTextGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOTextGlyphAllowedElements LayoutLOTextGlyphAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfTextGlyphs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOAllowedCoreElements LayoutGOAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;graphicalObject&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOAllowedCoreAttributes LayoutGOAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;graphicalObject&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOAllowedElements LayoutGOAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;graphicalObject&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOAllowedAttributes LayoutGOAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;graphicalObject&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOMetaIdRefMustBeIDREF LayoutGOMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOMetaIdRefMustReferenceObject LayoutGOMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGOMustContainBoundingBox LayoutGOMustContainBoundingBox }</code></td>
<td> A <code>&lt;graphicalObject&gt;</code> must contain a <code>&lt;boundingBox&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGAllowedCoreElements LayoutCGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;compartmentGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGAllowedCoreAttributes LayoutCGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;compartmentGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGAllowedElements LayoutCGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;compartmentGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGAllowedAttributes LayoutCGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;compartmentGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGMetaIdRefMustBeIDREF LayoutCGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGMetaIdRefMustReferenceObject LayoutCGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGCompartmentSyntax LayoutCGCompartmentSyntax }</code></td>
<td> {@link CompartmentGlyph} 'compartment' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGCompartmentMustRefComp LayoutCGCompartmentMustRefComp }</code></td>
<td> {@link CompartmentGlyph} compartment must reference existing compartment. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGNoDuplicateReferences LayoutCGNoDuplicateReferences }</code></td>
<td> {@link CompartmentGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCGOrderMustBeDouble LayoutCGOrderMustBeDouble }</code></td>
<td> {@link CompartmentGlyph} order must be double. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGAllowedCoreElements LayoutSGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;speciesGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGAllowedCoreAttributes LayoutSGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;speciesGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGAllowedElements LayoutSGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;speciesGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGAllowedAttributes LayoutSGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;speciesGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGMetaIdRefMustBeIDREF LayoutSGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGMetaIdRefMustReferenceObject LayoutSGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGSpeciesSyntax LayoutSGSpeciesSyntax }</code></td>
<td> {@link SpeciesGlyph} 'species' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGSpeciesMustRefSpecies LayoutSGSpeciesMustRefSpecies }</code></td>
<td> {@link SpeciesGlyph} species must reference existing species. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSGNoDuplicateReferences LayoutSGNoDuplicateReferences }</code></td>
<td> {@link SpeciesGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGAllowedCoreElements LayoutRGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;reactionGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGAllowedCoreAttributes LayoutRGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;reactionGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGAllowedElements LayoutRGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;reactionGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGAllowedAttributes LayoutRGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;reactionGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGMetaIdRefMustBeIDREF LayoutRGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGMetaIdRefMustReferenceObject LayoutRGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGReactionSyntax LayoutRGReactionSyntax }</code></td>
<td> {@link ReactionGlyph} 'reaction' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGReactionMustRefReaction LayoutRGReactionMustRefReaction }</code></td>
<td> {@link ReactionGlyph} reaction must reference existing reaction. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutRGNoDuplicateReferences LayoutRGNoDuplicateReferences }</code></td>
<td> {@link ReactionGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSpeciesRefGlyphAllowedElements LayoutLOSpeciesRefGlyphAllowedElements }</code></td>
<td> Allowed elements on {@link ListOfSpeciesReferenceGlyphs} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSpeciesRefGlyphAllowedAttribs LayoutLOSpeciesRefGlyphAllowedAttribs }</code></td>
<td> Allowed attributes on {@link ListOfSpeciesReferenceGlyphs} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSpeciesRefGlyphNotEmpty LayoutLOSpeciesRefGlyphNotEmpty }</code></td>
<td> {@link ListOfSpeciesReferenceGlyphs} not empty </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGAllowedCoreElements LayoutGGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;generalGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGAllowedCoreAttributes LayoutGGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;generalGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGAllowedElements LayoutGGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;generalGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGAllowedAttributes LayoutGGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;generalGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGMetaIdRefMustBeIDREF LayoutGGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGMetaIdRefMustReferenceObject LayoutGGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGReferenceSyntax LayoutGGReferenceSyntax }</code></td>
<td> {@link GeneralGlyph} 'reference' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGReferenceMustRefObject LayoutGGReferenceMustRefObject }</code></td>
<td> {@link GeneralGlyph} 'reference' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutGGNoDuplicateReferences LayoutGGNoDuplicateReferences }</code></td>
<td> {@link GeneralGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOReferenceGlyphAllowedElements LayoutLOReferenceGlyphAllowedElements }</code></td>
<td> Allowed elements on {@link ListOfReferenceGlyphs} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOReferenceGlyphAllowedAttribs LayoutLOReferenceGlyphAllowedAttribs }</code></td>
<td> Allowed attributes on {@link ListOfReferenceGlyphs} </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSubGlyphAllowedElements LayoutLOSubGlyphAllowedElements }</code></td>
<td> Allowed elements on ListOfSubGlyphs </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOSubGlyphAllowedAttribs LayoutLOSubGlyphAllowedAttribs }</code></td>
<td> Allowed attributes on ListOfSubGlyphs </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGAllowedCoreElements LayoutTGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;textGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGAllowedCoreAttributes LayoutTGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;textGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGAllowedElements LayoutTGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;textGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGAllowedAttributes LayoutTGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;textGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGMetaIdRefMustBeIDREF LayoutTGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGMetaIdRefMustReferenceObject LayoutTGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGOriginOfTextSyntax LayoutTGOriginOfTextSyntax }</code></td>
<td> {@link TextGlyph} 'originOfText' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGOriginOfTextMustRefObject LayoutTGOriginOfTextMustRefObject }</code></td>
<td> {@link TextGlyph} 'originOfText' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGNoDuplicateReferences LayoutTGNoDuplicateReferences }</code></td>
<td> {@link TextGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGGraphicalObjectSyntax LayoutTGGraphicalObjectSyntax }</code></td>
<td> {@link TextGlyph} 'graphicalObject' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGGraphicalObjectMustRefObject LayoutTGGraphicalObjectMustRefObject }</code></td>
<td> {@link TextGlyph} 'graphicalObject' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutTGTextMustBeString LayoutTGTextMustBeString }</code></td>
<td> {@link TextGlyph} 'text' must be string. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGAllowedCoreElements LayoutSRGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;speciesReferenceGlyphgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGAllowedCoreAttributes LayoutSRGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;speciesReferenceGlyphgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGAllowedElements LayoutSRGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;speciesReferenceGlyphgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGAllowedAttributes LayoutSRGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;speciesReferenceGlyphgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGMetaIdRefMustBeIDREF LayoutSRGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGMetaIdRefMustReferenceObject LayoutSRGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGSpeciesReferenceSyntax LayoutSRGSpeciesReferenceSyntax }</code></td>
<td> {@link SpeciesReferenceGlyph} 'speciesReference' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGSpeciesRefMustRefObject LayoutSRGSpeciesRefMustRefObject }</code></td>
<td> {@link SpeciesReferenceGlyph} 'speciesReference' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGNoDuplicateReferences LayoutSRGNoDuplicateReferences }</code></td>
<td> {@link SpeciesReferenceGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGSpeciesGlyphSyntax LayoutSRGSpeciesGlyphSyntax }</code></td>
<td> {@link SpeciesReferenceGlyph} 'speciesGlyph' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGSpeciesGlyphMustRefObject LayoutSRGSpeciesGlyphMustRefObject }</code></td>
<td> {@link SpeciesReferenceGlyph} 'speciesGlyph' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutSRGRoleSyntax LayoutSRGRoleSyntax }</code></td>
<td> {@link SpeciesReferenceGlyph} 'role' must be string from enumeration. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGAllowedCoreElements LayoutREFGAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;referenceGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGAllowedCoreAttributes LayoutREFGAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;referenceGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGAllowedElements LayoutREFGAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;referenceGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGAllowedAttributes LayoutREFGAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;referenceGlyph&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGMetaIdRefMustBeIDREF LayoutREFGMetaIdRefMustBeIDREF }</code></td>
<td> {@link Layout} 'metIdRef' must be IDREF. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGMetaIdRefMustReferenceObject LayoutREFGMetaIdRefMustReferenceObject }</code></td>
<td> {@link Layout} 'metIdRef' must reference existing object. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGReferenceSyntax LayoutREFGReferenceSyntax }</code></td>
<td> {@link ReferenceGlyph} 'reference' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGReferenceMustRefObject LayoutREFGReferenceMustRefObject }</code></td>
<td> {@link ReferenceGlyph} 'reference' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGNoDuplicateReferences LayoutREFGNoDuplicateReferences }</code></td>
<td> {@link ReferenceGlyph} cannot reference two objects. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGGlyphSyntax LayoutREFGGlyphSyntax }</code></td>
<td> {@link ReferenceGlyph} 'glyph' must have SIdRef syntax. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGGlyphMustRefObject LayoutREFGGlyphMustRefObject }</code></td>
<td> {@link ReferenceGlyph} 'glyph' must reference existing element. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutREFGRoleSyntax LayoutREFGRoleSyntax }</code></td>
<td> {@link ReferenceGlyph} 'role' must be string. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutPointAllowedCoreElements LayoutPointAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;point&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutPointAllowedCoreAttributes LayoutPointAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;point&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutPointAllowedAttributes LayoutPointAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;point&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutPointAttributesMustBeDouble LayoutPointAttributesMustBeDouble }</code></td>
<td> {@link Layout} 'x', 'y' and 'z' must be double. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutBBoxAllowedCoreElements LayoutBBoxAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;boundingBox&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutBBoxAllowedCoreAttributes LayoutBBoxAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;boundingBox&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutBBoxAllowedElements LayoutBBoxAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;boundingBox&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutBBoxAllowedAttributes LayoutBBoxAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;boundingBox&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutBBoxConsistent3DDefinition LayoutBBoxConsistent3DDefinition }</code></td>
<td> {@link Layout} consistent dimensions on a <code>&lt;boundingBox&gt;</code> </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCurveAllowedCoreElements LayoutCurveAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;curve&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCurveAllowedCoreAttributes LayoutCurveAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;curve&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCurveAllowedElements LayoutCurveAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;curve&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCurveAllowedAttributes LayoutCurveAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;curve&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOCurveSegsAllowedAttributes LayoutLOCurveSegsAllowedAttributes }</code></td>
<td> Allowed attributes on ListOfCurveSegments </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOCurveSegsAllowedElements LayoutLOCurveSegsAllowedElements }</code></td>
<td> Allowed elements on ListOfCurveSegments </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLOCurveSegsNotEmpty LayoutLOCurveSegsNotEmpty }</code></td>
<td> No empty ListOfCurveSegments </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLSegAllowedCoreElements LayoutLSegAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;lineSegment&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLSegAllowedCoreAttributes LayoutLSegAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;lineSegment&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLSegAllowedElements LayoutLSegAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;lineSegment&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutLSegAllowedAttributes LayoutLSegAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;lineSegment&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCBezAllowedCoreElements LayoutCBezAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;cubicBezier&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCBezAllowedCoreAttributes LayoutCBezAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;cubicBezier&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCBezAllowedElements LayoutCBezAllowedElements }</code></td>
<td> Layout elements allowed on <code>&lt;cubicBezier&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutCBezAllowedAttributes LayoutCBezAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;cubicBezier&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutDimsAllowedCoreElements LayoutDimsAllowedCoreElements }</code></td>
<td> Core elements allowed on <code>&lt;dimensions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutDimsAllowedCoreAttributes LayoutDimsAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;dimensions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutDimsAllowedAttributes LayoutDimsAllowedAttributes }</code></td>
<td> Layout attributes allowed on <code>&lt;dimensions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#LayoutDimsAttributesMustBeDouble LayoutDimsAttributesMustBeDouble }</code></td>
<td> {@link Layout} 'width', 'height' and 'depth' must be double. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualUnknown QualUnknown }</code></td>
<td> Unknown error from qual. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualNSUndeclared QualNSUndeclared }</code></td>
<td> The qual ns is not correctly declared. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualElementNotInNs QualElementNotInNs }</code></td>
<td> Element not in qual namespace. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFunctionTermBool QualFunctionTermBool }</code></td>
<td> {@link FunctionTerm} should return boolean. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualMathCSymbolDisallowed QualMathCSymbolDisallowed }</code></td>
<td> CSymbol time or delay not allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-warning'>W</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualDuplicateComponentId QualDuplicateComponentId }</code></td>
<td> Duplicate 'id' attribute value. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualAttributeRequiredMissing QualAttributeRequiredMissing }</code></td>
<td> Required qual:required attribute on <code>&lt;sbml&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualAttributeRequiredMustBeBoolean QualAttributeRequiredMustBeBoolean }</code></td>
<td> The qual:required attribute must be Boolean. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualRequiredTrueIfTransitions QualRequiredTrueIfTransitions }</code></td>
<td> The qual:required attribute must be 'true' if math changes. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOneListOfTransOrQS QualOneListOfTransOrQS }</code></td>
<td> Only one <code>&lt;listOfTransitions&gt;</code> or <code>&lt;listOfQualitativeSpeciesgt;</code> allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualEmptyLONotAllowed QualEmptyLONotAllowed }</code></td>
<td> Empty <code>&lt;listOfTransitions&gt;</code> or <code>&lt;listOfQualitativeSpeciesgt;</code> not allowed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualLOTransitiondAllowedElements QualLOTransitiondAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfTransitions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualLOQualSpeciesAllowedElements QualLOQualSpeciesAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;listOfTransitions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualLOQualSpeciesAllowedAttributes QualLOQualSpeciesAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfQualitativeSpeciesgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualLOTransitionsAllowedAttributes QualLOTransitionsAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfTransitions&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualQualSpeciesAllowedCoreAttributes QualQualSpeciesAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;qualitativeSpeciesgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualQualSpeciesAllowedElements QualQualSpeciesAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;qualitativeSpeciesgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualQualSpeciesAllowedAttributes QualQualSpeciesAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;qualitativeSpeciesgt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualConstantMustBeBool QualConstantMustBeBool }</code></td>
<td> Attribute 'constant' on <code>&lt;qualitativeSpeciesgt;</code> must be boolean. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualNameMustBeString QualNameMustBeString }</code></td>
<td> Attribute 'name' on <code>&lt;qualitativeSpeciesgt;</code> must be string. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInitialLevelMustBeInt QualInitialLevelMustBeInt }</code></td>
<td> Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> must be integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualMaxLevelMustBeInt QualMaxLevelMustBeInt }</code></td>
<td> Attribute 'maxLevel' on <code>&lt;qualitativeSpeciesgt;</code> must be integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualCompartmentMustReferExisting QualCompartmentMustReferExisting }</code></td>
<td> Attribute 'compartment' on <code>&lt;qualitativeSpeciesgt;</code> must reference compartment. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInitialLevelCannotExceedMax QualInitialLevelCannotExceedMax }</code></td>
<td> Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot exceed maxLevel. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualConstantQSCannotBeOutput QualConstantQSCannotBeOutput }</code></td>
<td> Constant <code>&lt;qualitativeSpeciesgt;</code> cannot be an {@link Output}. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualQSAssignedOnlyOnce QualQSAssignedOnlyOnce }</code></td>
<td> A <code>&lt;qualitativeSpeciesgt;</code> can only be assigned once. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInitalLevelNotNegative QualInitalLevelNotNegative }</code></td>
<td> Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot be negative. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualMaxLevelNotNegative QualMaxLevelNotNegative }</code></td>
<td> Attribute 'maxLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot be negative. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionAllowedCoreAttributes QualTransitionAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;transition&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionAllowedElements QualTransitionAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;transition&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionAllowedAttributes QualTransitionAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;transition&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionNameMustBeString QualTransitionNameMustBeString }</code></td>
<td> Attribute 'name' on <code>&lt;transition&gt;</code> must be string. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOElements QualTransitionLOElements }</code></td>
<td> {@link ListOf} elements on <code>&lt;transition&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionEmptyLOElements QualTransitionEmptyLOElements }</code></td>
<td> {@link ListOf} elements on <code>&lt;transition&gt;</code> not empty. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOInputElements QualTransitionLOInputElements }</code></td>
<td> Elements on <code>&lt;listOfInputs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOOutputElements QualTransitionLOOutputElements }</code></td>
<td> Elements on <code>&lt;listOfOutputs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOFuncTermElements QualTransitionLOFuncTermElements }</code></td>
<td> Elements on <code>&lt;listOfFunctionTerms&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOInputAttributes QualTransitionLOInputAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfInputs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOOutputAttributes QualTransitionLOOutputAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfOutputs&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOFuncTermAttributes QualTransitionLOFuncTermAttributes }</code></td>
<td> Attributes allowed on <code>&lt;listOfFunctionTerms&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOFuncTermExceedMax QualTransitionLOFuncTermExceedMax }</code></td>
<td> <code>&lt;listOfFunctionTerms&gt;</code> cannot make qualitativeSpecies exceed maxLevel. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualTransitionLOFuncTermNegative QualTransitionLOFuncTermNegative }</code></td>
<td> <code>&lt;listOfFunctionTerms&gt;</code> cannot make qualitativeSpecies negative. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputAllowedCoreAttributes QualInputAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;input&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputAllowedElements QualInputAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;input&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputAllowedAttributes QualInputAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;input&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputNameMustBeString QualInputNameMustBeString }</code></td>
<td> Attribute 'name' on <code>&lt;input&gt;</code> must be string. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputSignMustBeSignEnum QualInputSignMustBeSignEnum }</code></td>
<td> Attribute 'sign' on <code>&lt;input&gt;</code> must be enum. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputTransEffectMustBeInputEffect QualInputTransEffectMustBeInputEffect }</code></td>
<td> Attribute 'transitionEffect' on <code>&lt;input&gt;</code> must be enum. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputThreshMustBeInteger QualInputThreshMustBeInteger }</code></td>
<td> Attribute 'thresholdLevel' on <code>&lt;input&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputQSMustBeExistingQS QualInputQSMustBeExistingQS }</code></td>
<td> Attribute 'qualitativeSpecies' on <code>&lt;input&gt;</code> must refer to existing. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputConstantCannotBeConsumed QualInputConstantCannotBeConsumed }</code></td>
<td> Constant <code>&lt;input&gt;</code> cannot be consumed. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualInputThreshMustBeNonNegative QualInputThreshMustBeNonNegative }</code></td>
<td> Attribute 'thresholdLevel' on <code>&lt;input&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputAllowedCoreAttributes QualOutputAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;output&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputAllowedElements QualOutputAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;output&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputAllowedAttributes QualOutputAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;output&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputNameMustBeString QualOutputNameMustBeString }</code></td>
<td> Attribute 'name' on <code>&lt;output&gt;</code> must be string. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputTransEffectMustBeOutput QualOutputTransEffectMustBeOutput }</code></td>
<td> Attribute 'transitionEffect' on <code>&lt;output&gt;</code> must be enum. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputLevelMustBeInteger QualOutputLevelMustBeInteger }</code></td>
<td> Attribute 'outputLevel' on <code>&lt;output&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputQSMustBeExistingQS QualOutputQSMustBeExistingQS }</code></td>
<td> Attribute 'qualitativeSpecies' on <code>&lt;output&gt;</code> must refer to existing. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputConstantMustBeFalse QualOutputConstantMustBeFalse }</code></td>
<td> Constant 'qualitativeSpecies' cannot be <code>&lt;output&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputProductionMustHaveLevel QualOutputProductionMustHaveLevel }</code></td>
<td> <code>&lt;output&gt;</code> being produced must have level. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualOutputLevelMustBeNonNegative QualOutputLevelMustBeNonNegative }</code></td>
<td> Attribute 'outputLevel' on <code>&lt;output&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualDefaultTermAllowedCoreAttributes QualDefaultTermAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;defaultTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualDefaultTermAllowedElements QualDefaultTermAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;defaultTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualDefaultTermAllowedAttributes QualDefaultTermAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;defaultTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualDefaultTermResultMustBeInteger QualDefaultTermResultMustBeInteger }</code></td>
<td> Attribute 'resultLevel' on <code>&lt;defaultTerm&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualDefaultTermResultMustBeNonNeg QualDefaultTermResultMustBeNonNeg }</code></td>
<td> Attribute 'resultLevel' on <code>&lt;defaultTerm&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFuncTermAllowedCoreAttributes QualFuncTermAllowedCoreAttributes }</code></td>
<td> Core attributes allowed on <code>&lt;functionTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFuncTermAllowedElements QualFuncTermAllowedElements }</code></td>
<td> Elements allowed on <code>&lt;functionTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFuncTermAllowedAttributes QualFuncTermAllowedAttributes }</code></td>
<td> Attributes allowed on <code>&lt;functionTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFuncTermOnlyOneMath QualFuncTermOnlyOneMath }</code></td>
<td> Only one <code>&lt;math&gt;</code> on <code>&lt;functionTerm&gt;</code>. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFuncTermResultMustBeInteger QualFuncTermResultMustBeInteger }</code></td>
<td> Attribute 'resultLevel' on <code>&lt;functionTerm&gt;</code> must be non negative integer. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
<tr><td><code>{@link  libsbmlConstants#QualFuncTermResultMustBeNonNeg QualFuncTermResultMustBeNonNeg }</code></td>
<td> Attribute 'resultLevel' on <code>&lt;functionTerm&gt;</code> must be non negative integer.. </td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-na'>N</td>
<td class='s-error'>E</td></tr>
</table>
 <p>
 * <h3><a class='anchor'
 * name='SBMLErrorCategory_t'>Category codes associated with {@link SBMLError} objects</a></h3>
 <p>
 * As discussed above, each {@link SBMLError} object contains a value for a
 * category identifier, describing the type of issue that the {@link SBMLError}
 * object represents.  The category can be retrieved from an {@link SBMLError}
 * object using the method {@link SBMLError#getCategory()}.  The following table
 * lists each possible value and a brief description of its meaning.
 <p>
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * {@link libsbmlConstants}.
 <p>
 * The following table lists each possible value and a brief description of
 * its meaning.
 <p>
 <p>
 <p>
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='4' border='0'  class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</td>
 *      <th>Meaning</td>
 *  </tr>
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML LIBSBML_CAT_SBML}</td><td>General error not falling into
 * another category below.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L1_COMPAT LIBSBML_CAT_SBML_L1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model from SBML Level&nbsp;2 to SBML
 * Level&nbsp;1.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V1_COMPAT LIBSBML_CAT_SBML_L2V1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;1.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V2_COMPAT LIBSBML_CAT_SBML_L2V2_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;2.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating general SBML constructs.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 2xxxx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating symbol identifiers in a model.
 * With respect to the SBML specification, these concern failures in
 * applying the validation rules numbered 103xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>  
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating the units of measurement on
 * quantities in a model.  With respect to the SBML specification, these
 * concern failures in applying the validation rules numbered 105xx in the
 * Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating MathML formulas in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 102xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY}</td><td>Category of errors
 * that can occur while validating {@link SBO} identifiers in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 107xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL}</td><td>Error in the
 * system of equations in the model: the system is overdetermined,
 * therefore violating a tenet of proper SBML.  With respect to the SBML
 * specification, this is validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V3_COMPAT LIBSBML_CAT_SBML_L2V3_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;3.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE}</td><td>Category of
 * warnings about recommended good practices involving SBML and
 * computational modeling.  (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_INTERNAL_CONSISTENCY LIBSBML_CAT_INTERNAL_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating libSBML's internal representation
 * of SBML constructs. (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V4_COMPAT LIBSBML_CAT_SBML_L2V4_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;4.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L3V1_COMPAT LIBSBML_CAT_SBML_L3V1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;3
 * Version&nbsp;1.</td></tr> 
 <p>
 * </table>
 * </center>
 <p>
 * <h3><a class='anchor'
 * name='SBMLErrorSeverity_t'>Severity codes associated with {@link SBMLError}
 * objects</h3>
 <p>
 * In libSBML version 5.9.0
 * there are no additional severity codes beyond those defined by {@link XMLError}.  
 * They are implemented as static integer constants defined in the interface 
 * class <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>, 
 * and have names beginning with <code>LIBSBML_SEV_</code>.
 */

public class SBMLError extends XMLError {
   private long swigCPtr;

   protected SBMLError(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLError_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLError obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLError obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLError(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category, String arg8, long pkgVersion) {
    this(libsbmlJNI.new_SBMLError__SWIG_0(errorId, level, version, details, line, column, severity, category, arg8, pkgVersion), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category, String arg8) {
    this(libsbmlJNI.new_SBMLError__SWIG_1(errorId, level, version, details, line, column, severity, category, arg8), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category) {
    this(libsbmlJNI.new_SBMLError__SWIG_2(errorId, level, version, details, line, column, severity, category), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column, long severity) {
    this(libsbmlJNI.new_SBMLError__SWIG_3(errorId, level, version, details, line, column, severity), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line, long column) {
    this(libsbmlJNI.new_SBMLError__SWIG_4(errorId, level, version, details, line, column), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details, long line) {
    this(libsbmlJNI.new_SBMLError__SWIG_5(errorId, level, version, details, line), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version, String details) {
    this(libsbmlJNI.new_SBMLError__SWIG_6(errorId, level, version, details), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level, long version) {
    this(libsbmlJNI.new_SBMLError__SWIG_7(errorId, level, version), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId, long level) {
    this(libsbmlJNI.new_SBMLError__SWIG_8(errorId, level), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError(long errorId) {
    this(libsbmlJNI.new_SBMLError__SWIG_9(errorId), true);
  }

  
/**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   <p>
   * @param errorId a long integer, the identification number of the error.
   <p>
   * @param level the SBML Level of the SBML model
   <p>
   * @param version the SBML Version within the Level of the SBML model
   <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   <p>
   * @param line a long integer, the line number at which the error occured.
   <p>
   * @param column a long integer, the column number at which the error occured.
   <p>
   * @param severity an integer indicating severity of the error.
   <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   <p>
   * @param package the SBML Level package involved.
   <p>
   * @param pkgVersion the version of the <code>package</code>.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 SBMLError() {
    this(libsbmlJNI.new_SBMLError__SWIG_10(), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link SBMLError}.
   */ public
 SBMLError(SBMLError orig) {
    this(libsbmlJNI.new_SBMLError__SWIG_11(SBMLError.getCPtr(orig), orig), true);
  }

}
