/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Implementation of SBML Level&nbsp;3's
 * ListOfLocalParameters construct.
 <p>
 * <p>
 * The various ListOf___ classes in SBML are merely containers used for
 * organizing the main components of an SBML model.  All are derived from
 * the abstract class {@link SBase}, and inherit the various attributes and
 * subelements of {@link SBase}, such as 'metaid' as and 'annotation'.  The
 * ListOf___ classes do not add any attributes of their own.
 <p>
 * The relationship between the lists and the rest of an SBML model is
 * illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
 <p>
 * <figure>
  <object type="image/svg+xml" data="listof-illustration.svg" class="centered"></object>
</figure>

 <p>
 * Readers may wonder about the motivations for using the ListOf___
 * containers.  A simpler approach in XML might be to place the components
 * all directly at the top level of the model definition.  The choice made
 * in SBML is to group them within XML elements named after
 * {@link ListOf}<em>Classname</em>, in part because it helps organize the
 * components.  More importantly, the fact that the container classes are
 * derived from {@link SBase} means that software tools can add information <em>about</em>
 * the lists themselves into each list container's 'annotation'.
 <p>
 * @see ListOfFunctionDefinitions
 * @see ListOfUnitDefinitions
 * @see ListOfCompartmentTypes
 * @see ListOfSpeciesTypes
 * @see ListOfCompartments
 * @see ListOfSpecies
 * @see ListOfParameters
 * @see ListOfInitialAssignments
 * @see ListOfRules
 * @see ListOfConstraints
 * @see ListOfReactions
 * @see ListOfEvents
 */

public class ListOfLocalParameters extends ListOfParameters {
   private long swigCPtr;

   protected ListOfLocalParameters(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.ListOfLocalParameters_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(ListOfLocalParameters obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ListOfLocalParameters obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ListOfLocalParameters(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link ListOfLocalParameters} object.
   <p>
   * The object is constructed such that it is valid for the given SBML
   * Level and Version combination.
   <p>
   * @param level the SBML Level
   <p>
   * @param version the Version within the SBML Level
   */ public
 ListOfLocalParameters(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_ListOfLocalParameters__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link ListOfLocalParameters} object.
   <p>
   * The object is constructed such that it is valid for the SBML Level and
   * Version combination determined by the {@link SBMLNamespaces} object in 
   * <code>sbmlns</code>.
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object that is used to determine the
   * characteristics of the {@link ListOfLocalParameters} object to be created.
   */ public
 ListOfLocalParameters(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_ListOfLocalParameters__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link ListOfLocalParameters} object.
   <p>
   * @return a (deep) copy of this {@link ListOfLocalParameters}.
   */ public
 ListOfLocalParameters cloneObject() {
    long cPtr = libsbmlJNI.ListOfLocalParameters_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfLocalParameters(cPtr, true);
  }

  
/**
   * Returns the libSBML type code for the objects contained in this {@link ListOf}
   * (i.e., {@link LocalParameter} objects, if the list is non-empty).
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters &ldquo;<code>SBML_</code>&rdquo;. 
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3 
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
   <p>
   * @return the SBML type code for the objects contained in this ListOf:
   * {@link  libsbmlConstants#SBML_LOCAL_PARAMETER SBML_LOCAL_PARAMETER} (default).
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getItemTypeCode() {
    return libsbmlJNI.ListOfLocalParameters_getItemTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object.
   <p>
   * For {@link ListOfLocalParameters}, the XML element name is <code>'listOfLocalParameters'.</code>
   <p>
   * @return the name of this element, i.e., <code>'listOfLocalParameters'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.ListOfLocalParameters_getElementName(swigCPtr, this);
  }

  
/**
   * Returns the {@link LocalParameter} object located at position <code>n</code> within this
   * {@link ListOfLocalParameters} instance.
   <p>
   * @param n the index number of the {@link LocalParameter} to get.
   <p>
   * @return the nth {@link LocalParameter} in this {@link ListOfLocalParameters}.  If the
   * index <code>n</code> is out of bounds for the length of the list, then <code>null</code>
   * is returned.
   <p>
   * @see #size()
   * @see #get(String sid)
   */ public
 LocalParameter get(long n) {
    long cPtr = libsbmlJNI.ListOfLocalParameters_get__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
/**
   * Returns the first {@link LocalParameter} object matching the given identifier.
   <p>
   * @param sid a string, the identifier of the {@link LocalParameter} to get.
   <p>
   * @return the {@link LocalParameter} object found.  The caller owns the returned
   * object and is responsible for deleting it.  If none of the items have
   * an identifier matching <code>sid</code>, then <code>null</code> is returned.
   <p>
   * @see #get(long n)
   * @see #size()
   */ public
 LocalParameter get(String sid) {
    long cPtr = libsbmlJNI.ListOfLocalParameters_get__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
/**
   * Returns the first child element found that has the given <code>id</code> in the
   * model-wide SId namespace, or <code>null</code> if no such object is found.
   <p>
   * Note that LocalParameters, while they use the SId namespace, are not in
   * the model-wide SId namespace, so no {@link LocalParameter} object will be
   * returned from this function (and is the reason we override the base
   * ListOf.getElementBySId function here).
   <p>
   * @param id string representing the id of objects to find
   <p>
   * @return pointer to the first element found with the given <code>id</code>.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.ListOfLocalParameters_getElementBySId(swigCPtr, this, id), false);
}

  
/**
   * Removes the nth item from this {@link ListOfLocalParameters}, and returns a
   * pointer to it.
   <p>
   * @param n the index of the item to remove.  
   <p>
   * @return the item removed.  The caller owns the returned object and is
   * responsible for deleting it.  If the index number <code>n</code> is out of
   * bounds for the length of the list, then <code>null</code> is returned.
   <p>
   * @see #size()
   * @see #remove(String sid)
   */ public
 LocalParameter remove(long n) {
    long cPtr = libsbmlJNI.ListOfLocalParameters_remove__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, true);
  }

  
/**
   * Removes the first {@link LocalParameter} object in this {@link ListOfLocalParameters}
   * matching the given identifier, and returns a pointer to it.
   <p>
   * @param sid the identifier of the item to remove.
   <p>
   * @return the item removed.  The caller owns the returned object and is
   * responsible for deleting it.  If none of the items have an identifier
   * matching <code>sid</code>, then <code>null</code> is returned.
   */ public
 LocalParameter remove(String sid) {
    long cPtr = libsbmlJNI.ListOfLocalParameters_remove__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, true);
  }

}
